/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.lqpt.model.LqEpConfig;
import kd.imc.bdm.lqpt.model.request.base.oil.OilSpbmRequest;
import kd.imc.bdm.lqpt.model.request.base.oil.OilStockOperateRequest;
import kd.imc.bdm.lqpt.model.request.base.oil.OilStockQueryRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.base.SpbmResponseItem;
import kd.imc.bdm.lqpt.model.response.base.oil.OilSpbmItem;
import kd.imc.bdm.lqpt.model.response.base.oil.OilSpbmResponse;
import kd.imc.bdm.lqpt.model.response.base.oil.OilStockQueryResponse;
import kd.imc.bdm.lqpt.model.response.base.oil.OilStockQueryResult;
import kd.imc.bdm.lqpt.service.LqptService;

public class OilService {
    public List<SpbmResponseItem> querySpbmFromLq(String taxNo) {
        ArrayList<SpbmResponseItem> spbmItemList = new ArrayList<SpbmResponseItem>(16);
        OilSpbmRequest request = new OilSpbmRequest();
        request.setNsrsbh(taxNo);
        QFilter filter1 = new QFilter("number", "=", (Object)taxNo);
        DynamicObject epBaseInfo = QueryServiceHelper.queryOne((String)"bdm_enterprise_baseinfo", (String)"id", (QFilter[])filter1.toArray());
        QFilter filter2 = new QFilter("epinfo", "=", epBaseInfo.get("id"));
        DynamicObject epInfo = QueryServiceHelper.queryOne((String)"bdm_enterprise_info", (String)"zgswskfjdm", (QFilter[])filter2.toArray());
        request.setSjswjgdm(epInfo.getString("zgswskfjdm"));
        LqptService service = new LqptService();
        LqptResponse response = service.send(request);
        OilSpbmResponse oilSpbmResponse = (OilSpbmResponse)response.getData();
        if (oilSpbmResponse != null) {
            List<OilSpbmItem> itemList = oilSpbmResponse.getResultList();
            DynamicObject[] array = new DynamicObject[itemList.size()];
            int count = 0;
            for (OilSpbmItem item : itemList) {
                DynamicObject slObject = BusinessDataServiceHelper.newDynamicObject((String)"bdm_lqpt_spbm");
                slObject.set("nsrsbh", (Object)taxNo);
                slObject.set("create_time", (Object)new Date());
                slObject.set("number", (Object)item.getSpbm());
                slObject.set("name", (Object)item.getSpmc());
                slObject.set("sphfwfljc", (Object)item.getSpjc());
                slObject.set("tdyslxdm", (Object)"01");
                array[count++] = slObject;
                SpbmResponseItem spbmitem = new SpbmResponseItem();
                spbmitem.setTdyslxdm("01");
                spbmitem.setSphfwssflhbbm(item.getSpbm());
                spbmitem.setSphfwmc(item.getSpmc());
                spbmitem.setSphfwfljc(item.getSpjc());
                spbmItemList.add(spbmitem);
            }
            try (TXHandle tx = TX.requiresNew();){
                QFilter qFilter1 = new QFilter("nsrsbh", "=", (Object)taxNo);
                QFilter qFilter2 = new QFilter("tdyslxdm", "=", (Object)"01");
                DeleteServiceHelper.delete((String)"bdm_lqpt_spbm", (QFilter[])new QFilter[]{qFilter1, qFilter2});
                SaveServiceHelper.save((DynamicObject[])array);
            }
        }
        return spbmItemList;
    }

    public void updateStock(String taxNo, String invoiceNo) {
        DynamicObject[] stockArray;
        QFilter filter1 = new QFilter("invoiceno", "=", (Object)invoiceNo);
        QFilter filter2 = new QFilter("salertaxno", "=", (Object)taxNo);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"sim_vatinvoice", (String)"items.goodscode as goodscode,items.unit as unit,items.num as num", (QFilter[])new QFilter[]{filter1, filter2});
        HashMap<String, BigDecimal> stockMap = new HashMap<String, BigDecimal>(8);
        for (DynamicObject item : collect) {
            String spbm = item.getString("goodscode");
            BigDecimal stock = (BigDecimal)stockMap.get(spbm);
            BigDecimal num = item.getBigDecimal("num");
            if (stock == null) {
                stock = BigDecimal.ZERO;
            }
            num = this.changeSl(spbm, item.getString("unit"), num);
            stock = stock.add(num);
            stockMap.put(spbm, stock);
        }
        QFilter qFilter1 = new QFilter("nsrsbh", "=", (Object)taxNo);
        QFilter qFilter2 = new QFilter("spbm", "in", stockMap.keySet());
        for (DynamicObject stock : stockArray = BusinessDataServiceHelper.load((String)"bdm_lqpt_oilstock", (String)"id,spbm,cpyzkc,ksycpykc,yxzcpykc,yxzwsycpykc", (QFilter[])new QFilter[]{qFilter1, qFilter2})) {
            String spbm = stock.getString("spbm");
            BigDecimal num = (BigDecimal)stockMap.get(spbm);
            BigDecimal yxzwsycpykc = stock.getBigDecimal("yxzwsycpykc");
            if (yxzwsycpykc.compareTo(num) > 0) {
                stock.set("yxzwsycpykc", (Object)yxzwsycpykc.subtract(num));
                continue;
            }
            stock.set("yxzwsycpykc", (Object)BigDecimal.ZERO);
        }
        SaveServiceHelper.update((DynamicObject[])stockArray);
    }

    public BigDecimal changeSl(String spbm, String unit, BigDecimal sl) {
        if ("\u5347".equals(unit)) {
            sl = sl.divide(this.getConversionRatio(spbm), 8, RoundingMode.HALF_UP);
        }
        return sl;
    }

    public LqptResponse queryStockFromLq(String taxNo) {
        OilStockQueryRequest request = new OilStockQueryRequest();
        request.setNsrsbh(taxNo);
        LqptService service = new LqptService();
        LqptResponse response = service.send(request);
        OilStockQueryResponse oilSpbmResponse = (OilStockQueryResponse)response.getData();
        List<OilStockQueryResult> resultList = oilSpbmResponse.getResultList();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(resultList.size());
        for (OilStockQueryResult item : resultList) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bdm_lqpt_oilstock");
            obj.set("nsrsbh", (Object)taxNo);
            obj.set("spmc", (Object)item.getSpmc());
            obj.set("spbm", (Object)item.getSpbm());
            obj.set("sdbz", (Object)item.getSdbz());
            obj.set("cpyzkc", (Object)item.getCpyzkc());
            obj.set("ksycpykc", (Object)item.getKsycpykc());
            obj.set("yxzcpykc", (Object)item.getYxzcpykc());
            obj.set("yxzwsycpykc", (Object)item.getYxzwsycpykc());
            obj.set("create_time", (Object)new Date());
            list.add(obj);
        }
        try (TXHandle tx = TX.requiresNew();){
            QFilter qFilter1 = new QFilter("nsrsbh", "=", (Object)taxNo);
            DeleteServiceHelper.delete((String)"bdm_lqpt_oilstock", (QFilter[])new QFilter[]{qFilter1});
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
        return response;
    }

    public LqptResponse checkStock(String taxNo, Map<String, BigDecimal> stockMap) {
        QFilter qFilter1 = new QFilter("nsrsbh", "=", (Object)taxNo);
        QFilter qFilter2 = new QFilter("spbm", "in", stockMap.keySet());
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"bdm_lqpt_oilstock", (String)"spbm,cpyzkc,ksycpykc,yxzcpykc,yxzwsycpykc", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        HashMap<String, BigDecimal> appStockMap = new HashMap<String, BigDecimal>(collect.size());
        for (DynamicObject obj : collect) {
            BigDecimal invoiceStock;
            String spbm = obj.getString("spbm");
            BigDecimal cpyzkc = obj.getBigDecimal("cpyzkc");
            BigDecimal ksycpykc = obj.getBigDecimal("ksycpykc");
            BigDecimal yxzcpykc = obj.getBigDecimal("yxzcpykc");
            BigDecimal yxzwsycpykc = obj.getBigDecimal("yxzwsycpykc");
            if (yxzwsycpykc.compareTo(invoiceStock = stockMap.get(spbm)) > 0) {
                appStockMap.put(spbm, BigDecimal.ZERO);
                continue;
            }
            if (ksycpykc.compareTo(invoiceStock) < 0) {
                return new LqptResponse("6150", String.format(ResManager.loadKDString((String)"%1$s\u53ef\u4f7f\u7528\u6210\u54c1\u6cb9\u5e93\u5b58\u4e0d\u8db3", (String)"OilService_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]), obj.getString("spbm")));
            }
            if (yxzwsycpykc.compareTo(invoiceStock) >= 0) continue;
            BigDecimal apply = ksycpykc.multiply(new BigDecimal("0.8"));
            if (apply.compareTo(invoiceStock) < 0) {
                apply = ksycpykc;
            }
            appStockMap.put(spbm, apply);
        }
        for (Map.Entry<String, BigDecimal> entry : stockMap.entrySet()) {
            BigDecimal apply = (BigDecimal)appStockMap.get(entry.getKey());
            LqptResponse appluReulst = null;
            if (apply == null) {
                if (!collect.isEmpty()) {
                    return new LqptResponse("6151", String.format(ResManager.loadKDString((String)"%1$s\u53ef\u4f7f\u7528\u6210\u54c1\u6cb9\u5e93\u5b58\u4e0d\u8db3", (String)"OilService_1", (String)"imc-bdm-lqpt", (Object[])new Object[0]), entry.getValue()));
                }
                appluReulst = this.downloadStock(taxNo, entry.getKey(), entry.getValue());
            } else if (apply.compareTo(BigDecimal.ZERO) > 0) {
                appluReulst = this.downloadStock(taxNo, entry.getKey(), apply);
            }
            if (appluReulst == null || appluReulst.success()) continue;
            return appluReulst;
        }
        return new LqptResponse("0000", "");
    }

    public LqptResponse downloadStock(String taxNo, String spbm, BigDecimal sl) {
        return this.operateStock(taxNo, spbm, sl, "0");
    }

    public LqptResponse senBackStock(String taxNo, String spbm, BigDecimal sl) {
        return this.operateStock(taxNo, spbm, sl, "1");
    }

    public LqptResponse operateStock(String taxNo, String spbm, BigDecimal sl, String sqlx) {
        try (DLock lock = DLock.create((String)("lqpt_oilstock" + taxNo + spbm), (String)"lqpt_oilstock");){
            if (lock.tryLock()) {
                LqptService service = new LqptService();
                LqEpConfig config = service.getLqEpConfig(taxNo);
                OilStockOperateRequest request = new OilStockOperateRequest();
                request.setNsrsbh(taxNo);
                request.setSpbm(spbm);
                request.setSl(sl.setScale(6, RoundingMode.DOWN));
                request.setSqlx(sqlx);
                request.setPtbh(config.getJrdwptbh());
                String uuid = UUID.randomUUID();
                String yeslsh = config.getSydwptbh() + config.getJrdwptbh() + (uuid + uuid).substring(0, 32);
                request.setYwlsh(yeslsh);
                LqptResponse response = service.send(request);
                if (response.success()) {
                    this.queryStockFromLq(taxNo);
                }
                LqptResponse lqptResponse = response;
                return lqptResponse;
            }
        }
        return new LqptResponse("6153", String.format(ResManager.loadKDString((String)"%1$\u83b7\u53d6\u6210\u54c1\u6cb9\u5e93\u5b58\u5931\u8d25", (String)"OilService_0", (String)"imc-bdm-lqpt", (Object[])new Object[0]), spbm));
    }

    public BigDecimal getConversionRatio(String spbm) {
        switch (spbm) {
            case "1070101010100000000": {
                return new BigDecimal(1388);
            }
            case "1070101010200000000": {
                return new BigDecimal(1388);
            }
            case "1070101010300000000": {
                return new BigDecimal(1388);
            }
            case "1070101010400000000": {
                return new BigDecimal(1388);
            }
            case "1070101010500000000": {
                return new BigDecimal(1388);
            }
            case "1070101020100000000": {
                return new BigDecimal(1246);
            }
            case "1070101020200000000": {
                return new BigDecimal(1176);
            }
            case "1070101030100000000": {
                return new BigDecimal(1176);
            }
            case "1070101030200000000": {
                return new BigDecimal(1176);
            }
            case "1070101030300000000": {
                return new BigDecimal(1176);
            }
            case "1070101030400000000": {
                return new BigDecimal(1176);
            }
            case "1070101040100000000": {
                return new BigDecimal(1015);
            }
            case "1070101040200000000": {
                return new BigDecimal(1015);
            }
            case "1070101040300000000": {
                return new BigDecimal(1015);
            }
            case "1070101050100000000": {
                return new BigDecimal(1385);
            }
            case "1070101050200000000": {
                return new BigDecimal(1385);
            }
            case "1070101050300000000": {
                return new BigDecimal(1385);
            }
            case "1070101060100000000": {
                return new BigDecimal(1282);
            }
            case "1070101070100000000": {
                return new BigDecimal(1126);
            }
            case "1070101070200000000": {
                return new BigDecimal(1126);
            }
            case "1070101070300000000": {
                return new BigDecimal(1126);
            }
            case "1070101010600000000": {
                return new BigDecimal(1388);
            }
            case "1070101060200000000": {
                return new BigDecimal(1282);
            }
            case "1070101060300000000": {
                return new BigDecimal(1282);
            }
            case "1070101060400000000": {
                return new BigDecimal(1282);
            }
            case "1070101060500000000": {
                return new BigDecimal(1282);
            }
            case "1070101050400000000": {
                return new BigDecimal(1385);
            }
            case "1070101050500000000": {
                return new BigDecimal(1385);
            }
            case "1070101050600000000": {
                return new BigDecimal(1385);
            }
            case "1070101050700000000": {
                return new BigDecimal(1385);
            }
            case "1070101050800000000": {
                return new BigDecimal(1385);
            }
            case "1070101050900000000": {
                return new BigDecimal(1385);
            }
        }
        return new BigDecimal(1126);
    }
}

