/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.lqpt.model.request.base.SlvRequest;
import kd.imc.bdm.lqpt.model.request.base.SpbmRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.base.SlvResponse;
import kd.imc.bdm.lqpt.model.response.base.SlvResponseItem;
import kd.imc.bdm.lqpt.model.response.base.SpbmResponse;
import kd.imc.bdm.lqpt.model.response.base.SpbmResponseItem;
import kd.imc.bdm.lqpt.model.response.base.SpbmResponseItemHy;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.bdm.lqpt.service.OilService;
import org.apache.commons.collections.CollectionUtils;

public class SpbmAndSlvService {
    private static Log logger = LogFactory.getLog(SpbmAndSlvService.class);

    public List<SpbmResponseItem> querySpbmFromLq(String taxNo) {
        logger.info("\u4ece\u4e50\u4f01\u4e0b\u8f7d\u7a0e\u6536\u5206\u7c7b\u7f16\u7801{}", (Object)taxNo);
        int count = 0;
        SpbmRequest request = new SpbmRequest();
        request.setNsrsbh(taxNo);
        LqptService service = new LqptService();
        LqptResponse response = service.send(request);
        if (!response.success()) {
            return new ArrayList<SpbmResponseItem>(1);
        }
        SpbmResponse spbmResponse = (SpbmResponse)response.getData();
        List<SpbmResponseItem> itemList = spbmResponse.getSsbmList();
        if (CollectionUtils.isEmpty(itemList)) {
            return new ArrayList<SpbmResponseItem>(1);
        }
        DynamicObject[] array = new DynamicObject[itemList.size()];
        for (SpbmResponseItem spbmResponseItem : itemList) {
            DynamicObject slObject = BusinessDataServiceHelper.newDynamicObject((String)"bdm_lqpt_spbm");
            slObject.set("nsrsbh", (Object)taxNo);
            slObject.set("create_time", (Object)new Date());
            slObject.set("number", (Object)spbmResponseItem.getSphfwssflhbbm());
            slObject.set("name", (Object)spbmResponseItem.getSphfwmc());
            slObject.set("fjbm", (Object)spbmResponseItem.getFjbm());
            slObject.set("tdyslxdm", (Object)spbmResponseItem.getTdyslxdm());
            slObject.set("cezs", (Object)spbmResponseItem.getCezs());
            slObject.set("bzs", (Object)spbmResponseItem.getBzs());
            slObject.set("jzjtdm", (Object)spbmResponseItem.getJzjtdm());
            slObject.set("sphfwfljc", (Object)spbmResponseItem.getSphfwfljc());
            slObject.set("sm", (Object)spbmResponseItem.getSm());
            slObject.set("zzssl", (Object)spbmResponseItem.getZzssl());
            slObject.set("zsl", (Object)spbmResponseItem.getZsl());
            slObject.set("zzstsgl", (Object)spbmResponseItem.getZzstsgl());
            slObject.set("zzszcyj", (Object)spbmResponseItem.getZzszcyj());
            slObject.set("zzstsnrdm", (Object)spbmResponseItem.getZzstsnrdm());
            slObject.set("xfsgl", (Object)spbmResponseItem.getXfsgl());
            slObject.set("xfszcyj", (Object)spbmResponseItem.getXfszcyj());
            slObject.set("xfstsnrdm", (Object)spbmResponseItem.getXfstsnrdm());
            slObject.set("gjz", (Object)spbmResponseItem.getGjz());
            slObject.set("sfhzx", (Object)spbmResponseItem.getSfhzx());
            slObject.set("dytjjbm", (Object)spbmResponseItem.getDytjjbm());
            slObject.set("hgjcksppm", (Object)spbmResponseItem.getHgjcksppm());
            slObject.set("qyrq", (Object)spbmResponseItem.getQyrq());
            slObject.set("tyrq", (Object)spbmResponseItem.getTyrq());
            List<SpbmResponseItemHy> zspmList = spbmResponseItem.getZspmList();
            if (zspmList != null && !zspmList.isEmpty()) {
                DynamicObjectCollection collect = slObject.getDynamicObjectCollection("zspmlist");
                for (SpbmResponseItemHy hy : zspmList) {
                    DynamicObject entry = collect.addNew();
                    entry.set("hydm", (Object)hy.getHydm());
                    entry.set("dydhy", (Object)hy.getDydhy());
                    entry.set("hydydzspm1", (Object)hy.getHydydzspm1());
                    entry.set("hydydzsmc1", (Object)hy.getHydydzsmc1());
                    entry.set("hydydzspm2", (Object)hy.getHydydzspm2());
                    entry.set("hydydzsmc2", (Object)hy.getHydydzsmc2());
                }
            }
            array[count++] = slObject;
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            DeleteServiceHelper.delete((String)"bdm_lqpt_spbm", (QFilter[])new QFilter("nsrsbh", "=", (Object)taxNo).toArray());
            SaveServiceHelper.save((DynamicObject[])array);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        OilService oilService = new OilService();
        List<SpbmResponseItem> list = oilService.querySpbmFromLq(taxNo);
        if (!list.isEmpty()) {
            itemList.addAll(list);
        }
        return itemList;
    }

    public void queryLvFromLq(String taxNo) {
        logger.info("\u4ece\u4e50\u4f01\u4e0b\u8f7d\u53ef\u7528\u7a0e\u7387{}", (Object)taxNo);
        int count = 0;
        SlvRequest request = new SlvRequest();
        request.setNsrsbh(taxNo);
        LqptService service = new LqptService();
        LqptResponse response = service.send(request);
        if (!response.success()) {
            return;
        }
        SlvResponse slvResponse = (SlvResponse)response.getData();
        List<SlvResponseItem> list = slvResponse.getSlzslList();
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        DynamicObject[] array = new DynamicObject[list.size()];
        for (SlvResponseItem item : list) {
            DynamicObject slObject = BusinessDataServiceHelper.newDynamicObject((String)"bdm_lqpt_sl");
            slObject.set("nsrsbh", (Object)taxNo);
            slObject.set("create_time", (Object)new Date());
            slObject.set("update_time", (Object)new Date());
            slObject.set("csxz", (Object)item.getCsxz());
            slObject.set("slzsl", (Object)item.getSlzsl());
            slObject.set("yslbz", (Object)item.getYslbz());
            slObject.set("dyysl", (Object)item.getDyysl());
            slObject.set("cszt", (Object)item.getCszt());
            slObject.set("yxqq", (Object)item.getYxqq());
            slObject.set("yxqz", (Object)item.getYxqz());
            slObject.set("tyrq", (Object)item.getTyrq());
            array[count++] = slObject;
        }
        try (TXHandle tx = TX.requiresNew();){
            DeleteServiceHelper.delete((String)"bdm_lqpt_sl", (QFilter[])new QFilter("nsrsbh", "=", (Object)taxNo).toArray());
            SaveServiceHelper.save((DynamicObject[])array);
        }
    }
}

