/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.service.collect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.lqpt.constant.LqptErrorCode;
import kd.imc.bdm.lqpt.enums.CollectApiRequestEnum;
import kd.imc.bdm.lqpt.model.request.LqptRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.bdm.lqpt.utils.RequestValidateUtil;

public class InvoiceCollectionService {
    private static Log LOGGER = LogFactory.getLog(InvoiceCollectionService.class);

    public JSONObject send(JSONObject param) {
        LOGGER.info("InvoiceCollectionService send param:{}", (Object)param);
        if (param == null || param.isEmpty()) {
            throw new KDBizException(LqptErrorCode.PARAM_EMPTY, new Object[0]);
        }
        String apiType = param.getString("api_type");
        String paramStr = JSONObject.toJSONString((Object)param);
        Class clazz = null;
        try {
            clazz = CollectApiRequestEnum.getClazzByType(apiType);
        }
        catch (Exception e) {
            LOGGER.info("InvoiceCollectionService Class Exception:{}", (Object)e);
        }
        LqptResponse response = null;
        if (clazz != null) {
            LqptRequest request = (LqptRequest)JSON.parseObject((String)paramStr, (Class)clazz);
            if (!RequestValidateUtil.checkRequestParam(request)) {
                throw new KDBizException(LqptErrorCode.PARAM_EMPTY, new Object[0]);
            }
            LqptService service = new LqptService();
            response = service.send(request);
            LOGGER.info("InvoiceCollectionService send response:{}", JSON.toJSON((Object)response));
        }
        return JSON.parseObject((String)JSON.toJSONString(response));
    }
}

