/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.bdm.lqpt.utils;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.util.HttpUtil;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public class LqptHttpUtils {
    private static Log logger = LogFactory.getLog(LqptHttpUtils.class);
    private static int connectTimeout = 20000;
    private static int socketTimeout = 60000;

    public static CloseableHttpClient getConnection(String proxy) {
        return LqptHttpUtils.getConnection(proxy, true, connectTimeout, socketTimeout);
    }

    public static CloseableHttpClient getConnection(String proxy, boolean redirectsEnabled, int connectTime, int readTime) {
        int connectionRequestTimeout = 1200000;
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(connectionRequestTimeout).setConnectTimeout(connectTime).setSocketTimeout(readTime).setRedirectsEnabled(redirectsEnabled).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(requestConfig);
        if (StringUtils.isNotEmpty((CharSequence)proxy)) {
            String[] values = proxy.trim().split(":");
            if (values.length < 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ee3\u7406\u914d\u7f6e\u683c\u5f0f\u9519\u8bef", (String)"LqptHttpUtils_0", (String)"imc-bdm-lqpt", (Object[])new Object[0]));
            }
            HttpHost httpHost = new HttpHost(values[0], Integer.parseInt(values[1]));
            httpClientBuilder.setProxy(httpHost);
        }
        HttpUtil.setSslIgnore((HttpClientBuilder)httpClientBuilder);
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return httpClient;
    }
}

