/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.invoice.input.InputInvoiceDataService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.schedule.inputdata.InputDataBoardJob;
import org.apache.commons.compress.utils.Lists;

public class InputDataBoardCustomPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(InputDataBoardCustomPlugin.class);

    public void registerListener(EventObject e) {
        Button submit = (Button)this.getControl("run");
        submit.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        block18: {
            String key = ((Control)evt.getSource()).getKey();
            if (StringUtils.equals((CharSequence)"run", (CharSequence)key)) {
                Date startDate = (Date)this.getModel().getValue("startdate");
                Date endDate = (Date)this.getModel().getValue("enddate");
                if (startDate == null || endDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f", (String)"InputDataBoardCustomPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (endDate.before(startDate)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u5f97\u5927\u4e8e\u5f00\u59cb\u65e5\u671f", (String)"InputDataBoardCustomPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("enddate", (Object)"");
                    return;
                }
                try (DLock lock = DLock.create((String)"InputDataBoardJob", (String)ResManager.loadKDString((String)"\u5237\u65b0\u5361\u7247\u9501", (String)"InputDataBoardCustomPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));){
                    if (lock.tryLock(500L)) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        String startDateStr = sdf.format(startDate);
                        String endDateStr = sdf.format(endDate);
                        try {
                            List<String> everyDayList = InputDataBoardCustomPlugin.findEveryDay(startDateStr, endDateStr);
                            InputInvoiceDataService service = new InputInvoiceDataService();
                            everyDayList.forEach(f -> {
                                try {
                                    Date parse = sdf.parse((String)f);
                                    Date dayStart = DateUtils.getDayStart((Date)parse);
                                    Date dayEnd = DateUtils.getDayEnd((Date)parse);
                                    service.init(dayStart, dayEnd);
                                }
                                catch (Exception e) {
                                    logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f\u6307\u5b9a\u65e5\u671f\u533a\u95f4\u8fd0\u884c\u5931\u8d25", (Object)e);
                                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25", (String)"InputDataBoardCustomPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                                }
                            });
                            InputDataBoardJob idbJob = new InputDataBoardJob();
                            idbJob.run();
                        }
                        catch (Exception e) {
                            logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f\u6307\u5b9a\u65e5\u671f\u533a\u95f4\u8fd0\u884c\u5931\u8d25", (Object)e);
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25", (String)"InputDataBoardCustomPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        }
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"InputDataBoardCustomPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        break block18;
                    }
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", (String)"InputDataBoardCustomPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public static List<String> findEveryDay(String beginTime, String endTime) throws ParseException {
        ArrayList dates = Lists.newArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date dBegin = sdf.parse(beginTime);
        Date dEnd = sdf.parse(endTime);
        dates.add(sdf.format(dBegin));
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBegin);
        while (dEnd.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            dates.add(sdf.format(calBegin.getTime()));
        }
        return dates;
    }
}

