/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeUploadEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.RimPermItemEnum;
import kd.imc.rim.common.expense.domain.ExpenseAttachDTO;
import kd.imc.rim.common.expense.domain.ExpenseCoverDTO;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.domain.ExpenseInvoiceDTO;
import kd.imc.rim.common.expense.service.ExpenseCallBackService;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.invoice.collector.InvoiceCollectPluginService;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.collector.InvoiceCollectTask;
import kd.imc.rim.common.invoice.collector.ScannerService;
import kd.imc.rim.common.invoice.fpzs.ExpenseRelationService;
import kd.imc.rim.common.invoice.query.AttachSaveService;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionCheckTask;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionProgress;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionProgressError;
import kd.imc.rim.common.invoice.verify.VerifyService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.invoice.verify.dto.VerifyResultDto;
import kd.imc.rim.common.license.LicenseFormPlugin;
import kd.imc.rim.common.service.DialogService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.collections4.MapUtils;

public class InvSignByExpensePlugin
extends LicenseFormPlugin
implements UploadListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(InvSignByExpensePlugin.class);
    private static final String initFlex = "flex_init";
    private static final String toolBarLeft = "function_toolbar_left";
    private static final String treeEntryEntity = "treeEntryEntity";
    private static final String invoiceEditPage = "rim_inv_collect_edit";
    private static final String expenseEditPage = "rim_expense_edit";
    private static final String attachEditPage = "rim_fpzs_attach_edit";
    private static final String customScanner = "custom_scanner";
    private InvoiceCollectService invoiceCollectService = new InvoiceCollectService();
    private ExpenseService expenseService = new ExpenseService();
    private ExpenseRelationService expenseRelationService = new ExpenseRelationService();
    private InvoiceQueryService invoiceQueryService = new InvoiceQueryService();
    private AttachSaveService attachSaveService = new AttachSaveService();
    private static final String CACHE_EXPENSE_MAX_SEQ_DATA = "collect_expense_max_seq_cache";
    private static final HashMap<String, String> errorLevelColer = new HashMap(3);
    private static final String UPLOAD_INVOICE_COUNT = "upload_invoice_count";
    private static final String UPLOAD_COVER_COUNT = "upload_cover_count";
    private static final String UPLOAD_ATTACHMENT_COUNT = "upload_attachment_count";

    public void registerListener(EventObject e) {
        Toolbar functionToolBarLeft = (Toolbar)this.getControl(toolBarLeft);
        functionToolBarLeft.addUploadListener((UploadListener)this);
        functionToolBarLeft.addItemClickListener((ItemClickListener)this);
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(treeEntryEntity);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initView();
        CustomControl scannerControl = (CustomControl)this.getControl(customScanner);
        ScannerService.init((CustomControl)scannerControl, (String)this.getView().getPageId());
    }

    private void initView() {
        this.getView().setVisible(Boolean.TRUE, new String[]{initFlex});
        this.progressBarVisible(Boolean.FALSE, null);
        this.getModel().deleteEntryData(treeEntryEntity);
        InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)"{}");
        InvoiceCollectPluginService.setInvoiceSeqCache((String)this.getView().getPageId(), (String)"{}");
        InvoiceCollectPluginService.setInvoiceVerifyCache((String)this.getView().getPageId(), (String)"{}");
        this.getPageCache().remove("fileIndex");
        this.getPageCache().remove("serial_no_index");
        this.getPageCache().remove("collect_expenseNum");
        this.getPageCache().remove(CACHE_EXPENSE_MAX_SEQ_DATA);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flex_invoice_list"});
    }

    private void refreshInvoiceData(JSONObject invoice) {
        JSONArray barcodeArray;
        logger.info("\u626b\u63cf\u4eea\u5408\u89c4\u6027\u6821\u9a8c\u53d1\u7968\u4e4b\u524d\uff1a" + invoice);
        ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
        ArrayList<Long> uncheckInvoiceIds = new ArrayList<Long>(8);
        JSONArray showInvoiceArray = new JSONArray();
        String mainId = invoice.getString("mainId");
        String unCheckId = invoice.getString("unCheckId");
        if (StringUtils.isNotEmpty((String)unCheckId)) {
            uncheckInvoiceIds.add(Long.valueOf(unCheckId));
        } else if (StringUtils.isNotEmpty((String)mainId)) {
            invoiceIds.add(Long.parseLong(mainId));
        } else {
            showInvoiceArray.add((Object)invoice);
        }
        if (StringUtils.isNotEmpty((String)invoice.getString("serialNo"))) {
            JSONArray invoiceArray = new JSONArray();
            invoiceArray.add((Object)invoice);
            InvoiceCollectPluginService.cacheInvoiceSeqRelation((JSONArray)invoiceArray);
        }
        InvoiceCollectPluginService.cacheInvoiceList((String)this.getView().getPageId(), this.getCustomParam(), invoiceIds, uncheckInvoiceIds, (JSONArray)showInvoiceArray, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        String serialNo = invoice.getString("serialNo");
        logger.info("\u626b\u63cf\u4eea\u5408\u89c4\u6027\u6821\u9a8c\u53d1\u7968\u4e4b\u540e\u6d41\u6c34\u53f7\uff1a[{}]", (Object)serialNo);
        JSONObject invoiceJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        JSONObject invoiceTemp = invoiceJson.getJSONObject(serialNo);
        if (StringUtils.isNotEmpty((String)invoice.getString("errcode")) && !"0000".equals(invoice.getString("errcode"))) {
            String invoice_info = invoiceTemp.getString("invoice_info");
            if (invoice_info.indexOf("ch_1") != -1) {
                invoice_info = invoice_info.replace("ch_1", "ch_2");
            } else if (invoice_info.indexOf("ch_2") == -1) {
                invoice_info = invoice_info + "ch_2,";
            }
            invoiceTemp.put("invoice_info", (Object)invoice_info);
            invoiceTemp.put("delete", (Object)"2");
        }
        invoiceTemp.put("tempFileIndex", invoice.get((Object)"tempFileIndex"));
        invoiceTemp.put("delete", invoice.get((Object)"delete"));
        if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoice.getLong("invoiceType")) && !CollectionUtils.isEmpty((Collection)(barcodeArray = invoice.getJSONArray("barcode")))) {
            invoiceTemp.put("barcode", invoice.get((Object)"barcode"));
            invoiceTemp.put("kdcloudUrl", invoice.get((Object)"kdcloudUrl"));
            String expenseNum = (String)barcodeArray.get(0);
            if (StringUtils.isNotEmpty((String)expenseNum)) {
                invoiceTemp.put("expenseNum", (Object)expenseNum);
            }
        }
        invoiceTemp.put("fileName", invoice.get((Object)"fileName"));
        invoiceJson.put(serialNo, (Object)invoiceTemp);
        this.clearDoubleAttachment(invoiceJson);
        InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)invoiceJson));
    }

    private void refreshInvoiceDate(JSONObject invoice) {
        JSONArray barcodeArray;
        String expenseNum;
        String cache;
        JSONObject invoiceSeqCache;
        Integer index;
        JSONArray barcodeArray2;
        logger.info("\u5408\u89c4\u6027\u6821\u9a8c\u53d1\u7968\u4e4b\u524d\uff1a" + invoice);
        if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoice.getLong("invoiceType")) && !CollectionUtils.isEmpty((Collection)(barcodeArray2 = invoice.getJSONArray("barcode"))) && StringUtils.isNotEmpty((String)(barcodeArray2.get(0) + "")) && (index = (invoiceSeqCache = StringUtils.isNotEmpty((String)(cache = this.getPageCache().get("serial_no_index"))) ? JSON.parseObject((String)cache) : new JSONObject()).getInteger(expenseNum = barcodeArray2.get(0) + "")) != null) {
            return;
        }
        ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
        ArrayList<Long> uncheckInvoiceIds = new ArrayList<Long>(8);
        JSONArray showInvoiceArray = new JSONArray();
        String mainId = invoice.getString("mainId");
        String unCheckId = invoice.getString("unCheckId");
        if (StringUtils.isNotEmpty((String)unCheckId)) {
            uncheckInvoiceIds.add(Long.valueOf(unCheckId));
        } else if (StringUtils.isNotEmpty((String)mainId)) {
            invoiceIds.add(Long.parseLong(mainId));
        } else {
            showInvoiceArray.add((Object)invoice);
        }
        if (StringUtils.isNotEmpty((String)invoice.getString("serialNo"))) {
            JSONArray invoiceArray = new JSONArray();
            invoiceArray.add((Object)invoice);
            InvoiceCollectPluginService.cacheInvoiceSeqRelation((JSONArray)invoiceArray);
        }
        JSONObject invoiceJson = InvoiceCollectPluginService.cacheInvoiceList((String)this.getView().getPageId(), this.getCustomParam(), invoiceIds, uncheckInvoiceIds, (JSONArray)showInvoiceArray, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        String serialNo = invoice.getString("serialNo");
        logger.info("\u5408\u89c4\u6027\u6821\u9a8c\u53d1\u7968\u4e4b\u540e\u6d41\u6c34\u53f7\uff1a[{}]" + serialNo);
        JSONObject invoiceTemp = invoiceJson.getJSONObject(serialNo);
        if (StringUtils.isNotEmpty((String)invoice.getString("errcode")) && !"0000".equals(invoice.getString("errcode"))) {
            String invoice_info = invoiceTemp.getString("invoice_info");
            if (invoice_info.indexOf("ch_1") != -1) {
                invoice_info = invoice_info.replace("ch_1", "ch_2");
            } else if (invoice_info.indexOf("ch_2") == -1) {
                invoice_info = invoice_info + "ch_2,";
            }
            invoiceTemp.put("invoice_info", (Object)invoice_info);
            invoiceTemp.put("delete", (Object)"2");
        }
        invoiceTemp.put("fileIndex", invoice.get((Object)"fileIndex"));
        invoiceTemp.put("imageType", invoice.get((Object)"imageType"));
        invoiceTemp.put("delete", invoice.get((Object)"delete"));
        if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoice.getLong("invoiceType")) && !CollectionUtils.isEmpty((Collection)(barcodeArray = invoice.getJSONArray("barcode")))) {
            invoiceTemp.put("barcode", invoice.get((Object)"barcode"));
            invoiceTemp.put("kdcloudUrl", invoice.get((Object)"kdcloudUrl"));
            String expenseNum2 = (String)barcodeArray.get(0);
            if (StringUtils.isNotEmpty((String)expenseNum2)) {
                invoiceTemp.put("expenseNum", (Object)expenseNum2);
            }
        }
        invoiceTemp.put("fileName", invoice.get((Object)"fileName"));
        JSONObject invoiceVerifyJson = InvoiceCollectPluginService.getInvoiceVerifyCache((String)this.getView().getPageId());
        JSONObject verify = new JSONObject();
        JSONObject invoiceVerify = new JSONObject(4);
        invoiceVerify.put("errorLevel", invoiceTemp.get((Object)"errorLevel"));
        invoiceVerify.put("validateMessage", invoiceTemp.get((Object)"validateMessage"));
        invoiceVerify.put("verifyResult", invoiceTemp.get((Object)"verifyResult"));
        invoiceVerify.put("validateMessage_html", invoiceTemp.get((Object)"validateMessage_html"));
        verify.put("invoice", (Object)invoiceVerify);
        JSONObject expenseVerify = new JSONObject(4);
        String expenseNum3 = invoiceTemp.getString("expenseNum");
        if (StringUtils.isEmpty((String)expenseNum3)) {
            ArrayList<VerifyResultDto> resultList = new ArrayList<VerifyResultDto>(2);
            VerifyResultDto dto = new VerifyResultDto();
            dto.setName(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7f16\u53f7\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvSignByExpensePlugin_88", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            dto.setConfig("0");
            dto.setMsg(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7f16\u53f7\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvSignByExpensePlugin_88", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            resultList.add(dto);
            expenseVerify.put("errorLevel", (Object)"0");
            expenseVerify.put("validateMessage", (Object)VerifyService.getResultMsg(resultList));
            expenseVerify.put("verifyResult", resultList);
            expenseVerify.put("validateMessage_html", (Object)VerifyService.getResultMsgHtml(resultList));
            if ("cover".equals(invoiceTemp.getString("imageType"))) {
                invoiceTemp.put("errorLevel", (Object)"0");
                invoiceTemp.put("validateMessage", expenseVerify.get((Object)"validateMessage"));
                invoiceTemp.put("verifyResult", resultList);
                invoiceTemp.put("validateMessage_html", expenseVerify.get((Object)"validateMessage_html"));
            }
        } else {
            expenseVerify.put("errorLevel", (Object)"3");
            if ("cover".equals(invoiceTemp.getString("imageType"))) {
                invoiceTemp.put("errorLevel", (Object)"3");
            }
        }
        verify.put("cover", (Object)expenseVerify);
        JSONObject attachVerify = new JSONObject(4);
        String fileName = invoiceTemp.getString("fileName");
        if (StringUtils.isEmpty((String)fileName)) {
            ArrayList<VerifyResultDto> resultList = new ArrayList<VerifyResultDto>(2);
            VerifyResultDto dto = new VerifyResultDto();
            dto.setName(ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvSignByExpensePlugin_89", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            dto.setConfig("0");
            dto.setMsg(ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvSignByExpensePlugin_89", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            resultList.add(dto);
            attachVerify.put("errorLevel", (Object)"0");
            attachVerify.put("validateMessage", (Object)VerifyService.getResultMsg(resultList));
            attachVerify.put("verifyResult", resultList);
            attachVerify.put("validateMessage_html", (Object)VerifyService.getResultMsgHtml(resultList));
            if ("attachment".equals(invoiceTemp.getString("imageType"))) {
                invoiceTemp.put("errorLevel", (Object)"0");
                invoiceTemp.put("validateMessage", attachVerify.get((Object)"validateMessage"));
                invoiceTemp.put("verifyResult", resultList);
                invoiceTemp.put("validateMessage_html", attachVerify.get((Object)"validateMessage_html"));
            }
        } else {
            attachVerify.put("errorLevel", (Object)"3");
            if ("attachment".equals(invoiceTemp.getString("imageType"))) {
                invoiceTemp.put("errorLevel", (Object)"3");
            }
        }
        verify.put("attachment", (Object)attachVerify);
        invoiceVerifyJson.put(serialNo, (Object)verify);
        InvoiceCollectPluginService.setInvoiceVerifyCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)invoiceVerifyJson));
        invoiceJson.put(invoiceTemp.getString("serialNo"), (Object)invoiceTemp);
        this.clearDoubleAttachment(invoiceJson);
        InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)invoiceJson));
    }

    private void sortExpenseInvoice(String operate) {
        logger.info("\u626b\u63cf\u4eea\u8bc6\u522b\u8c03\u7528\u65b9\u6cd5\u6b21\u6570");
        JSONObject invoiceJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        String rescanBeginIndex = this.getPageCache().get("rescan_begin_index");
        String rescanEndIndex = this.getPageCache().get("rescan_end_index");
        if (StringUtils.isNotEmpty((String)rescanBeginIndex) && StringUtils.isNotEmpty((String)rescanEndIndex)) {
            int beginIndex = Integer.parseInt(rescanBeginIndex);
            int endIndex = Integer.parseInt(rescanEndIndex);
            int imagesNum = ObjectUtils.isEmpty((Object)this.getPageCache().get("dealCount")) ? 0 : Integer.parseInt(this.getPageCache().get("dealCount"));
            int count = 0;
            if ("scanner".equals(operate)) {
                InvoiceCollectPluginService.setInvoiceSeqCache((String)this.getView().getPageId(), (String)"{}");
                InvoiceCollectPluginService.setInvoiceVerifyCache((String)this.getView().getPageId(), (String)"{}");
                this.getPageCache().remove("fileIndex");
                this.getPageCache().remove("serial_no_index");
                this.getPageCache().remove("collect_expenseNum");
                this.getPageCache().remove(CACHE_EXPENSE_MAX_SEQ_DATA);
                String scannerSerialNoCache = this.getPageCache().get("scanner_serialNo");
                JSONObject scannerSerialNo = new JSONObject();
                if (StringUtils.isNotEmpty((String)scannerSerialNoCache)) {
                    scannerSerialNo = JSON.parseObject((String)scannerSerialNoCache);
                }
                logger.info("\u672c\u6b21\u626b\u63cf\u7684\u6587\u4ef6\uff1a[{}]", (Object)scannerSerialNo);
                int rescanIndex = 0;
                for (int i = 0; i < beginIndex; ++i) {
                    JSONObject invoice;
                    DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(treeEntryEntity).get(i);
                    String serialNo = dynamicObject.getString("serial_no");
                    String imageType = dynamicObject.getString("image_type");
                    String expenseNumber = dynamicObject.getString("expense_num");
                    if (!ObjectUtils.isEmpty((Object)scannerSerialNo.get((Object)serialNo)) || "cover".equals(imageType) && !ObjectUtils.isEmpty((Object)scannerSerialNo.get((Object)expenseNumber)) || ObjectUtils.isEmpty((Object)(invoice = invoiceJson.getJSONObject(serialNo)))) continue;
                    invoice.remove((Object)"fileIndex");
                    logger.info("\u8865\u626b\u4e4b\u540e\u5207\u5165\u70b9\u524d\u9762\u6587\u4ef6[{}]\u7684\u4e34\u65f6\u7d22\u5f15\u662f\uff1a[{}]", (Object)(StringUtils.isNotEmpty((String)expenseNumber) ? expenseNumber : dynamicObject.getString("invoice_no")), (Object)rescanIndex);
                    invoice.put("tempFileIndex", (Object)rescanIndex);
                    invoice.put("reorderFlag", (Object)"1");
                    ++rescanIndex;
                }
                for (Map.Entry entry : scannerSerialNo.entrySet()) {
                    String value = (String)entry.getValue();
                    JSONObject invoice = invoiceJson.getJSONObject(value);
                    if (ObjectUtils.isEmpty((Object)invoice)) continue;
                    invoice.remove((Object)"fileIndex");
                    int tempFileIndex = invoice.getIntValue("tempFileIndex");
                    invoice.put("tempFileIndex", (Object)(tempFileIndex + rescanIndex));
                    logger.info("\u8865\u626b\u6587\u4ef6[{}]\u7684\u4e34\u65f6\u7d22\u5f15\u662f\uff1a[{}]", (Object)value, (Object)(tempFileIndex + rescanIndex));
                }
                imagesNum = rescanIndex + scannerSerialNo.keySet().size();
            }
            JSONObject invoiceSeqCache = new JSONObject();
            for (int i = beginIndex; i <= endIndex; ++i) {
                String expenseMaxSeqCache;
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(treeEntryEntity).get(i);
                String serialNo = dynamicObject.getString("serial_no");
                JSONObject invoice = invoiceJson.getJSONObject(serialNo);
                if (ObjectUtils.isEmpty((Object)invoice)) continue;
                invoice.remove((Object)"fileIndex");
                if (!ObjectUtils.isEmpty((Object)invoice.get((Object)"tempFileIndex"))) continue;
                invoice.put("tempFileIndex", (Object)(imagesNum + count));
                invoice.put("reorderFlag", (Object)"1");
                logger.info("\u8865\u626b\u4e4b\u540e\u5207\u5165\u70b9\u540e\u9762\u6587\u4ef6\u7684\u91cd\u7f6e\u4e34\u65f6\u7d22\u5f15\u662f\uff1a[{}]", (Object)(imagesNum + count));
                ++count;
                invoiceJson.put(serialNo, (Object)invoice);
                String cache = this.getPageCache().get("serial_no_index");
                invoiceSeqCache.clear();
                if (StringUtils.isNotEmpty((String)cache)) {
                    invoiceSeqCache = JSON.parseObject((String)cache);
                }
                JSONObject expenseMaxIndex = StringUtils.isNotEmpty((String)(expenseMaxSeqCache = this.getPageCache().get(CACHE_EXPENSE_MAX_SEQ_DATA))) ? JSON.parseObject((String)expenseMaxSeqCache) : new JSONObject();
                String imageType = invoice.getString("imageType");
                String expenseNumber = invoice.getString("expenseNum");
                logger.info("\u8865\u626b\u4e4b\u540e\u5207\u5165\u70b9\u540e\u9762\u6587\u4ef6\u5f71\u50cf\u7c7b\u578b\uff1a[{}]", (Object)imageType);
                if ("cover".equals(imageType) && StringUtils.isNotEmpty((String)expenseNumber)) {
                    logger.info("\u8865\u626b\u4e4b\u540e\u5207\u5165\u70b9\u540e\u9762\u6587\u4ef6\u51fa\u73b0\u7684\u5355\u636e\u53f7\uff1a[{}]", (Object)expenseNumber);
                    invoiceSeqCache.remove((Object)expenseNumber);
                    expenseMaxIndex.remove((Object)expenseNumber);
                    this.getPageCache().put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
                }
                invoiceSeqCache.remove((Object)serialNo);
                this.getPageCache().put("serial_no_index", invoiceSeqCache.toJSONString());
            }
            if (!"scanner".equals(operate)) {
                int preRowIndex = "delete".equals(operate) ? beginIndex - 2 : beginIndex - 1;
                if (preRowIndex >= 0) {
                    DynamicObject preDynamicObject = (DynamicObject)this.getModel().getEntryEntity(treeEntryEntity).get(preRowIndex);
                    String preSerialNo = preDynamicObject.getString("serial_no");
                    JSONObject preInvoice = invoiceJson.getJSONObject(preSerialNo);
                    boolean noExpenseNum = true;
                    JSONObject expenseMaxIndex = new JSONObject();
                    for (int i = preRowIndex; i >= 0; --i) {
                        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(treeEntryEntity).get(i);
                        String serialNo = dynamicObject.getString("serial_no");
                        JSONObject invoice = invoiceJson.getJSONObject(serialNo);
                        String imageType = invoice.getString("imageType");
                        String expenseNum = invoice.getString("expenseNum");
                        if (!"cover".equals(imageType) || !StringUtils.isNotEmpty((String)expenseNum)) continue;
                        noExpenseNum = false;
                        String fileIndex = invoice.getString("fileIndex");
                        this.getPageCache().put("fileIndex", fileIndex);
                        this.getPageCache().put("collect_expenseNum", expenseNum);
                        String expenseMaxSeqCache = this.getPageCache().get(CACHE_EXPENSE_MAX_SEQ_DATA);
                        expenseMaxIndex.clear();
                        if (StringUtils.isNotEmpty((String)expenseMaxSeqCache)) {
                            expenseMaxIndex = JSON.parseObject((String)expenseMaxSeqCache);
                        }
                        expenseMaxIndex.put(expenseNum, (Object)preInvoice.getString("fileIndex"));
                        this.getPageCache().put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
                        break;
                    }
                    if (noExpenseNum) {
                        String fileIndex = preInvoice.getString("fileIndex");
                        this.getPageCache().put("fileIndex", fileIndex);
                        this.getPageCache().remove("collect_expenseNum");
                    }
                } else {
                    InvoiceCollectPluginService.setInvoiceSeqCache((String)this.getView().getPageId(), (String)"{}");
                    if (!"update".equals(operate)) {
                        InvoiceCollectPluginService.setInvoiceVerifyCache((String)this.getView().getPageId(), (String)"{}");
                    }
                    this.getPageCache().remove("fileIndex");
                    this.getPageCache().remove("serial_no_index");
                    this.getPageCache().remove("collect_expenseNum");
                    this.getPageCache().remove(CACHE_EXPENSE_MAX_SEQ_DATA);
                }
            }
        }
        HashMap<Integer, String> seqMap = new HashMap<Integer, String>(invoiceJson.entrySet().size());
        for (Map.Entry entry : invoiceJson.entrySet()) {
            JSONObject obj = (JSONObject)entry.getValue();
            if (!StringUtils.isNotEmpty((String)obj.getString("tempFileIndex"))) continue;
            seqMap.put(obj.getInteger("tempFileIndex"), obj.getString("serialNo"));
            logger.info("\u626b\u63cf\u4eea\u8bc6\u522b\u5355\u636e\u53d1\u7968\u4e34\u65f6\u5e8f\u53f7\uff1a[{}]\uff0c\u6d41\u6c34\u53f7\uff1a[{}]", (Object)obj.getInteger("tempFileIndex"), (Object)obj.getString("serialNo"));
        }
        Map sortMap = seqMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oleValue, newValue) -> oleValue, LinkedHashMap::new));
        logger.info("\u626b\u63cf\u4eea\u8bc6\u522b\u4e4b\u540e\u53d1\u7968\u7684\u4e34\u65f6\u6392\u5e8f\u662f[{}]", (Object)sortMap);
        for (Map.Entry entry : sortMap.entrySet()) {
            String serialNo = (String)entry.getValue();
            JSONObject invoice = invoiceJson.getJSONObject(serialNo);
            String reorderFlag = invoice.getString("reorderFlag");
            if (StringUtils.isNotEmpty((String)reorderFlag)) {
                this.afterReorder(serialNo, invoice);
            } else {
                this.afterScanner(serialNo, invoice);
            }
            JSONObject invoiceVerifyJson = InvoiceCollectPluginService.getInvoiceVerifyCache((String)this.getView().getPageId());
            JSONObject verify = new JSONObject();
            JSONObject invoiceVerify = new JSONObject(4);
            invoiceVerify.put("errorLevel", invoice.get((Object)"errorLevel"));
            invoiceVerify.put("validateMessage", invoice.get((Object)"validateMessage"));
            invoiceVerify.put("verifyResult", invoice.get((Object)"verifyResult"));
            invoiceVerify.put("validateMessage_html", invoice.get((Object)"validateMessage_html"));
            verify.put("invoice", (Object)invoiceVerify);
            JSONObject expenseVerify = new JSONObject(4);
            String expenseNumber = invoice.getString("expenseNum");
            if (StringUtils.isEmpty((String)expenseNumber)) {
                ArrayList<VerifyResultDto> resultList = new ArrayList<VerifyResultDto>(2);
                VerifyResultDto dto = new VerifyResultDto();
                dto.setName(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7f16\u53f7\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvSignByExpensePlugin_88", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                dto.setConfig("0");
                dto.setMsg(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7f16\u53f7\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvSignByExpensePlugin_88", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                resultList.add(dto);
                expenseVerify.put("errorLevel", (Object)"0");
                expenseVerify.put("validateMessage", (Object)VerifyService.getResultMsg(resultList));
                expenseVerify.put("verifyResult", resultList);
                expenseVerify.put("validateMessage_html", (Object)VerifyService.getResultMsgHtml(resultList));
                if ("cover".equals(invoice.getString("imageType"))) {
                    invoice.put("errorLevel", (Object)"0");
                    invoice.put("validateMessage", expenseVerify.get((Object)"validateMessage"));
                    invoice.put("verifyResult", resultList);
                    invoice.put("validateMessage_html", expenseVerify.get((Object)"validateMessage_html"));
                }
            } else {
                expenseVerify.put("errorLevel", (Object)"3");
                if ("cover".equals(invoice.getString("imageType"))) {
                    invoice.put("errorLevel", (Object)"3");
                }
            }
            verify.put("cover", (Object)expenseVerify);
            JSONObject attachVerify = new JSONObject(4);
            String fileName = invoice.getString("fileName");
            if (StringUtils.isEmpty((String)fileName)) {
                ArrayList<VerifyResultDto> resultList = new ArrayList<VerifyResultDto>(2);
                VerifyResultDto dto = new VerifyResultDto();
                dto.setName(ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvSignByExpensePlugin_89", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                dto.setConfig("0");
                dto.setMsg(ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvSignByExpensePlugin_89", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                resultList.add(dto);
                attachVerify.put("errorLevel", (Object)"0");
                attachVerify.put("validateMessage", (Object)VerifyService.getResultMsg(resultList));
                attachVerify.put("verifyResult", resultList);
                attachVerify.put("validateMessage_html", (Object)VerifyService.getResultMsgHtml(resultList));
                if ("attachment".equals(invoice.getString("imageType"))) {
                    invoice.put("errorLevel", (Object)"0");
                    invoice.put("validateMessage", attachVerify.get((Object)"validateMessage"));
                    invoice.put("verifyResult", resultList);
                    invoice.put("validateMessage_html", attachVerify.get((Object)"validateMessage_html"));
                }
            } else {
                attachVerify.put("errorLevel", (Object)"3");
                if ("attachment".equals(invoice.getString("imageType"))) {
                    invoice.put("errorLevel", (Object)"3");
                }
            }
            verify.put("attachment", (Object)attachVerify);
            invoiceVerifyJson.put(invoice.getString("serialNo"), (Object)verify);
            if (!"update".equals(operate)) {
                InvoiceCollectPluginService.setInvoiceVerifyCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)invoiceVerifyJson));
            }
            invoice.remove((Object)"reorderFlag");
            invoiceJson.put(invoice.getString("serialNo"), (Object)invoice);
        }
        this.clearDoubleAttachment(invoiceJson);
        InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)invoiceJson));
    }

    private void afterReorder(String serialNo, JSONObject invoice) {
        String cache;
        String expenseNumTemp;
        JSONArray barcodeArray;
        String expenseNum = this.getPageCache().get("collect_expenseNum");
        logger.info("[{}]\u91cd\u6392\u5e8f\u5355\u636e\u7684\u6d41\u6c34\u53f7\u662f[{}]", (Object)expenseNum, (Object)serialNo);
        String imageType = invoice.getString("imageType");
        if ("cover".equals(imageType) && !CollectionUtils.isEmpty((Collection)(barcodeArray = invoice.getJSONArray("barcode"))) && StringUtils.isNotEmpty((String)(expenseNumTemp = (String)barcodeArray.get(0)))) {
            expenseNum = expenseNumTemp;
            serialNo = expenseNumTemp;
            logger.info("\u91cd\u6392\u5e8f\u518d\u4e00\u6b21\u8bbe\u7f6e\u7684\u5355\u636e\u53f7\u662f\uff1a[{}]", (Object)expenseNum);
            this.getPageCache().put("collect_expenseNum", expenseNum);
        }
        JSONObject invoiceSeqCache = StringUtils.isNotEmpty((String)(cache = this.getPageCache().get("serial_no_index"))) ? JSON.parseObject((String)cache) : new JSONObject();
        Integer index = invoiceSeqCache.getInteger(serialNo);
        logger.info("\u6d41\u6c34\u53f7[{}]\u5bf9\u5e94\u7684\u91cd\u6392\u5e8f\u7d22\u5f15\u662f[{}]", (Object)serialNo, (Object)index);
        if (index != null && StringUtils.isNotEmpty((String)serialNo)) {
            invoice.put("fileIndex", (Object)index);
            invoice.remove((Object)"tempFileIndex");
        } else {
            String expenseMaxSeqCache = this.getPageCache().get(CACHE_EXPENSE_MAX_SEQ_DATA);
            JSONObject expenseMaxIndex = StringUtils.isNotEmpty((String)expenseMaxSeqCache) ? JSON.parseObject((String)expenseMaxSeqCache) : new JSONObject();
            logger.info("[{}]\u5355\u636e\u7684\u91cd\u6392\u5e8f\u7d22\u5f15\u7f13\u5b58\u662f[{}]", (Object)expenseNum, (Object)expenseMaxIndex);
            if (StringUtils.isNotEmpty((String)expenseNum)) {
                String maxIndex = expenseMaxIndex.getString(expenseNum);
                logger.info("[{}]\u5355\u636e\u7684\u91cd\u6392\u5e8f\u6700\u5927\u7d22\u5f15\u662f[{}]", (Object)expenseNum, (Object)maxIndex);
                if (StringUtils.isNotEmpty((String)maxIndex)) {
                    if ("attachment".equals(imageType)) {
                        int attachIndex = Integer.parseInt(maxIndex) + 1;
                        expenseMaxIndex.put(expenseNum, (Object)attachIndex);
                        this.getPageCache().put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
                        invoice.put("fileIndex", (Object)attachIndex);
                        invoice.remove((Object)"tempFileIndex");
                        logger.info("\u91cd\u6392\u5e8f\u91cd\u7f6e\u7d22\u5f15\u662f[{}]", (Object)attachIndex);
                        if (StringUtils.isNotEmpty((String)serialNo)) {
                            invoiceSeqCache.put(serialNo, (Object)attachIndex);
                            this.getPageCache().put("serial_no_index", invoiceSeqCache.toJSONString());
                        }
                    } else if ("invoice".equals(imageType)) {
                        int invoicesIndex = Integer.parseInt(maxIndex) + 1;
                        expenseMaxIndex.put(expenseNum, (Object)invoicesIndex);
                        this.getPageCache().put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
                        invoice.put("fileIndex", (Object)invoicesIndex);
                        invoice.remove((Object)"tempFileIndex");
                        logger.info("\u91cd\u6392\u5e8f\u91cd\u7f6e\u7d22\u5f15\u662f[{}]", (Object)invoicesIndex);
                        if (StringUtils.isNotEmpty((String)serialNo)) {
                            invoiceSeqCache.put(serialNo, (Object)invoicesIndex);
                            this.getPageCache().put("serial_no_index", invoiceSeqCache.toJSONString());
                        }
                    }
                } else if ("cover".equals(imageType)) {
                    int expenseIndex = ObjectUtils.isEmpty((Object)this.getPageCache().get("fileIndex")) ? 1 : Integer.parseInt(this.getPageCache().get("fileIndex")) + 500;
                    this.getPageCache().put("fileIndex", String.valueOf(expenseIndex));
                    expenseMaxIndex.put(expenseNum, (Object)expenseIndex);
                    this.getPageCache().put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
                    invoice.put("fileIndex", (Object)expenseIndex);
                    invoice.remove((Object)"tempFileIndex");
                    logger.info("\u91cd\u6392\u5e8f\u91cd\u7f6e\u7d22\u5f15\u662f[{}]", (Object)expenseIndex);
                    if (StringUtils.isNotEmpty((String)serialNo)) {
                        invoiceSeqCache.put(serialNo, (Object)expenseIndex);
                        this.getPageCache().put("serial_no_index", invoiceSeqCache.toJSONString());
                    }
                }
            } else {
                int beginIndex = ObjectUtils.isEmpty((Object)this.getPageCache().get("fileIndex")) ? 1 : Integer.parseInt(this.getPageCache().get("fileIndex")) + 1;
                this.getPageCache().put("fileIndex", String.valueOf(beginIndex));
                invoice.put("fileIndex", (Object)beginIndex);
                logger.info("\u91cd\u6392\u5e8f\u91cd\u7f6e\u7d22\u5f15\u662f[{}]", (Object)beginIndex);
                if (StringUtils.isNotEmpty((String)serialNo)) {
                    invoiceSeqCache.put(serialNo, (Object)beginIndex);
                    this.getPageCache().put("serial_no_index", invoiceSeqCache.toJSONString());
                }
                invoice.remove((Object)"tempFileIndex");
            }
        }
    }

    private void afterScanner(String serialNo, JSONObject invoice) {
        String cache;
        String expenseNumTemp;
        JSONArray barcodeArray;
        String expenseNum = this.getPageCache().get("collect_expenseNum");
        logger.info("[{}]\u626b\u63cf\u4eea\u8bc6\u522b\u5355\u636e\u7684\u6d41\u6c34\u53f7\u662f[{}]", (Object)expenseNum, (Object)serialNo);
        if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoice.getLong("invoiceType")) && !CollectionUtils.isEmpty((Collection)(barcodeArray = invoice.getJSONArray("barcode"))) && StringUtils.isNotEmpty((String)(expenseNumTemp = (String)barcodeArray.get(0)))) {
            expenseNum = expenseNumTemp;
            serialNo = expenseNumTemp;
            logger.info("\u626b\u63cf\u4eea\u8bc6\u522b\u518d\u4e00\u6b21\u8bbe\u7f6e\u7684\u5355\u636e\u53f7\u662f\uff1a[{}]", (Object)expenseNum);
            this.getPageCache().put("collect_expenseNum", expenseNum);
        }
        JSONObject invoiceSeqCache = StringUtils.isNotEmpty((String)(cache = this.getPageCache().get("serial_no_index"))) ? JSON.parseObject((String)cache) : new JSONObject();
        Integer index = invoiceSeqCache.getInteger(serialNo);
        logger.info("\u6d41\u6c34\u53f7[{}]\u5bf9\u5e94\u7684\u626b\u63cf\u4eea\u8bc6\u522b\u7d22\u5f15\u662f[{}]", (Object)serialNo, (Object)index);
        if (index != null && StringUtils.isNotEmpty((String)serialNo)) {
            invoice.put("fileIndex", (Object)index);
            this.setImageType(invoice);
            invoice.remove((Object)"tempFileIndex");
        } else {
            String expenseMaxSeqCache = this.getPageCache().get(CACHE_EXPENSE_MAX_SEQ_DATA);
            JSONObject expenseMaxIndex = StringUtils.isNotEmpty((String)expenseMaxSeqCache) ? JSON.parseObject((String)expenseMaxSeqCache) : new JSONObject();
            logger.info("[{}]\u5355\u636e\u7684\u626b\u63cf\u4eea\u8bc6\u522b\u7d22\u5f15\u7f13\u5b58\u662f[{}]", (Object)expenseNum, (Object)expenseMaxIndex);
            if (StringUtils.isNotEmpty((String)expenseNum)) {
                String maxIndex = expenseMaxIndex.getString(expenseNum);
                logger.info("[{}]\u5355\u636e\u7684\u626b\u63cf\u4eea\u8bc6\u522b\u6700\u5927\u7d22\u5f15\u662f[{}]", (Object)expenseNum, (Object)maxIndex);
                this.setImageType(invoice);
                if (StringUtils.isNotEmpty((String)maxIndex)) {
                    if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoice.getLong("invoiceType"))) {
                        JSONArray barcodeArray2 = invoice.getJSONArray("barcode");
                        if (CollectionUtils.isEmpty((Collection)barcodeArray2) || StringUtils.isEmpty((String)(barcodeArray2.get(0) + ""))) {
                            int attachIndex = Integer.parseInt(maxIndex) + 1;
                            expenseMaxIndex.put(expenseNum, (Object)attachIndex);
                            this.getPageCache().put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
                            invoice.put("fileIndex", (Object)attachIndex);
                            invoice.remove((Object)"tempFileIndex");
                            logger.info("\u626b\u63cf\u4eea\u8bc6\u522b\u91cd\u7f6e\u7d22\u5f15\u662f[{}]", (Object)attachIndex);
                            if (StringUtils.isNotEmpty((String)serialNo)) {
                                invoiceSeqCache.put(serialNo, (Object)attachIndex);
                                this.getPageCache().put("serial_no_index", invoiceSeqCache.toJSONString());
                            }
                        }
                    } else {
                        int invoicesIndex = Integer.parseInt(maxIndex) + 1;
                        expenseMaxIndex.put(expenseNum, (Object)invoicesIndex);
                        this.getPageCache().put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
                        invoice.put("fileIndex", (Object)invoicesIndex);
                        invoice.remove((Object)"tempFileIndex");
                        logger.info("\u626b\u63cf\u4eea\u8bc6\u522b\u91cd\u7f6e\u7d22\u5f15\u662f[{}]", (Object)invoicesIndex);
                        if (StringUtils.isNotEmpty((String)serialNo)) {
                            invoiceSeqCache.put(serialNo, (Object)invoicesIndex);
                            this.getPageCache().put("serial_no_index", invoiceSeqCache.toJSONString());
                        }
                    }
                } else {
                    int expenseIndex = ObjectUtils.isEmpty((Object)this.getPageCache().get("fileIndex")) ? 1 : Integer.parseInt(this.getPageCache().get("fileIndex")) + 500;
                    this.getPageCache().put("fileIndex", String.valueOf(expenseIndex));
                    expenseMaxIndex.put(expenseNum, (Object)expenseIndex);
                    this.getPageCache().put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
                    invoice.put("fileIndex", (Object)expenseIndex);
                    invoice.remove((Object)"tempFileIndex");
                    logger.info("\u626b\u63cf\u4eea\u8bc6\u522b\u91cd\u7f6e\u7d22\u5f15\u662f[{}]", (Object)expenseIndex);
                    if (StringUtils.isNotEmpty((String)serialNo)) {
                        invoiceSeqCache.put(serialNo, (Object)expenseIndex);
                        this.getPageCache().put("serial_no_index", invoiceSeqCache.toJSONString());
                    }
                }
            } else {
                int beginIndex = ObjectUtils.isEmpty((Object)this.getPageCache().get("fileIndex")) ? 1 : Integer.parseInt(this.getPageCache().get("fileIndex")) + 1;
                this.getPageCache().put("fileIndex", String.valueOf(beginIndex));
                invoice.put("fileIndex", (Object)beginIndex);
                logger.info("\u626b\u63cf\u4eea\u8bc6\u522b\u91cd\u7f6e\u7d22\u5f15\u662f[{}]", (Object)beginIndex);
                if (StringUtils.isNotEmpty((String)serialNo)) {
                    invoiceSeqCache.put(serialNo, (Object)beginIndex);
                    this.getPageCache().put("serial_no_index", invoiceSeqCache.toJSONString());
                }
                this.setImageType(invoice);
                invoice.remove((Object)"tempFileIndex");
            }
        }
    }

    private void setImageType(JSONObject invoice) {
        if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoice.getLong("invoiceType"))) {
            JSONArray barcodeArray = invoice.getJSONArray("barcode");
            if (CollectionUtils.isEmpty((Collection)barcodeArray) || StringUtils.isEmpty((String)(barcodeArray.get(0) + ""))) {
                invoice.put("imageType", (Object)"attachment");
            } else {
                Pattern pattern = this.getBatchPattern();
                if (pattern != null && pattern.matcher(barcodeArray.getString(0)).find()) {
                    invoice.put("imageType", (Object)"batch");
                } else {
                    Pattern coverpattern = this.getCoverPattern();
                    if (coverpattern != null) {
                        if (coverpattern.matcher(barcodeArray.getString(0)).find()) {
                            invoice.put("imageType", (Object)"cover");
                        } else {
                            invoice.put("imageType", (Object)"attachment");
                        }
                    } else {
                        invoice.put("imageType", (Object)"cover");
                    }
                }
            }
        } else if (InvoiceCollectPluginService.typeofsalerlist.equals(invoice.getLong("invoiceType"))) {
            invoice.put("imageType", (Object)"");
        } else {
            invoice.put("imageType", (Object)"invoice");
        }
    }

    private void refreshInvoiceGrid(String operate) {
        this.getPageCache().put("change", "1");
        JSONObject invoiceJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        invoiceJson = this.removeRepeatInvoice(invoiceJson);
        String cache = this.getPageCache().get("serial_no_index");
        String expenseMaxSeqCache = this.getPageCache().get(CACHE_EXPENSE_MAX_SEQ_DATA);
        logger.info("\u6700\u540e\u987a\u5e8f\u7f13\u5b58\uff1a{}", (Object)cache);
        logger.info("\u5355\u636e\u53f7\u6700\u5927\u7d22\u5f15\u7f13\u5b58\uff1a{}", (Object)expenseMaxSeqCache);
        if (invoiceJson != null) {
            this.updateExpenseInvoiceGrid(invoiceJson, operate);
        }
        if (invoiceJson != null) {
            boolean initFlexFlag = false;
            this.getView().setVisible(Boolean.valueOf(initFlexFlag), new String[]{initFlex});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flex_invoice_list"});
        }
        this.getPageCache().remove("change");
    }

    private JSONObject removeRepeatInvoice(JSONObject invoiceJson) {
        ArrayList<String> repeatList = new ArrayList<String>(4);
        for (Map.Entry entry : invoiceJson.entrySet()) {
            String serialNo = (String)entry.getKey();
            JSONObject invoice = invoiceJson.getJSONObject(serialNo);
            if (!ErrorType.REPEAT_SAVE_INVOICE.getCode().equals(invoice.getString("errorCode"))) continue;
            repeatList.add(serialNo);
        }
        for (String str : repeatList) {
            invoiceJson.remove((Object)str);
        }
        if (!repeatList.isEmpty()) {
            InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)invoiceJson.toJSONString());
        }
        return invoiceJson;
    }

    public void updateExpenseInvoiceGrid(JSONObject invoiceArray, String operate) {
        boolean initFlexFlag = false;
        this.getView().setVisible(Boolean.valueOf(initFlexFlag), new String[]{initFlex});
        this.getModel().deleteEntryData(treeEntryEntity);
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(treeEntryEntity);
        HashMap<Integer, String> seqMap = new HashMap<Integer, String>(invoiceArray.entrySet().size());
        for (Map.Entry entry : invoiceArray.entrySet()) {
            JSONObject obj = (JSONObject)entry.getValue();
            if (!StringUtils.isNotEmpty((String)obj.getString("fileIndex"))) continue;
            seqMap.put(obj.getInteger("fileIndex"), obj.getString("serialNo"));
            logger.info("\u5355\u636e\u53d1\u7968\u7d22\u5f15\uff1a[{}]\uff0c\u6d41\u6c34\u53f7\uff1a[{}]", (Object)obj.getInteger("fileIndex"), (Object)obj.getString("serialNo"));
        }
        Map sortMap = seqMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oleValue, newValue) -> oleValue, LinkedHashMap::new));
        boolean hasExpenseNum = false;
        int newEntryRow = 0;
        int maxRowIndex = 0;
        int coverCount = 0;
        int invoiceCount = 0;
        int attachnentCount = 0;
        for (Map.Entry entry : sortMap.entrySet()) {
            int insertEntryRow;
            String serialNo = (String)entry.getValue();
            JSONObject invoice = invoiceArray.getJSONObject(serialNo);
            Long invoiceType = invoice.getLong("invoiceType");
            if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType)) {
                invoice.put("invoiceCode", (Object)invoice.getString("trainNum"));
                invoice.put("invoiceNo", (Object)invoice.getString("printingSequenceNo"));
            } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
                invoice.put("invoiceNo", (Object)invoice.getString("electronicTicketNum"));
                invoice.put("passengerName", (Object)invoice.getString("customerName"));
            } else if (InvoiceCollectPluginService.typeofsalerlist.equals(invoiceType)) {
                invoice.put("imageType", (Object)"");
            }
            logger.info("\u5217\u8868\u53d1\u7968\u7d22\u5f15\uff1a[{}]\uff0c\u5355\u636e\u53f7\uff1a[{}]\uff0c\u53d1\u7968\u53f7\u7801\uff1a[{}]", new Object[]{invoice.getInteger("fileIndex"), invoice.getString("expenseNum"), invoice.getString("invoiceNo")});
            ArrayList<String> button = new ArrayList<String>(1);
            String imageType = invoice.getString("imageType");
            if ("cover".equals(imageType) || "batch".equals(imageType)) {
                ++coverCount;
                hasExpenseNum = true;
                newEntryRow = this.getModel().createNewEntryRow(treeEntryEntity);
                this.getModel().setValue("expense_num", (Object)invoice.getString("expenseNum"), newEntryRow);
                this.getModel().setValue("image_type", (Object)imageType, newEntryRow);
                this.getModel().setValue("serial_no", (Object)invoice.getString("serialNo"), newEntryRow);
                this.getModel().setValue("error_level", (Object)invoice.getString("errorLevel"), newEntryRow);
                if (this.expenseRelationService.canEdit(invoice.getString("expenseNum")).booleanValue()) {
                    button.add("select_view");
                    entryGrid.hideOperateItems("operationcolumnap", newEntryRow, button);
                } else {
                    button.add("select_edit");
                    entryGrid.hideOperateItems("operationcolumnap", newEntryRow, button);
                }
                maxRowIndex = newEntryRow;
                continue;
            }
            if ("invoice".equals(invoice.getString("imageType"))) {
                ++invoiceCount;
                insertEntryRow = hasExpenseNum ? this.getModel().insertEntryRow(treeEntryEntity, newEntryRow) : this.getModel().createNewEntryRow(treeEntryEntity);
                this.getModel().setValue("image_type", (Object)"invoice", insertEntryRow);
                logger.info("\u53d1\u7968\u4fe1\u606f\u4e2d\u7684invoice_info\u662f\uff1a[{}]", (Object)invoice.getString("invoice_info"));
                this.getModel().setValue("invoice_info", (Object)invoice.getString("invoice_info"), insertEntryRow);
                this.getModel().setValue("invoice_type", (Object)InputInvoiceTypeEnum.getInvoiceType((Long)invoiceType).getName(), insertEntryRow);
                this.getModel().setValue("total_amount", (Object)invoice.getString("totalAmount"), insertEntryRow);
                this.getModel().setValue("total_tax_amount", (Object)invoice.getString("totalTaxAmount"), insertEntryRow);
                this.getModel().setValue("invoice_date", (Object)invoice.getString("invoiceDate"), insertEntryRow);
                this.getModel().setValue("invoice_code", (Object)invoice.getString("invoiceCode"), insertEntryRow);
                this.getModel().setValue("invoice_no", (Object)invoice.getString("invoiceNo"), insertEntryRow);
                this.getModel().setValue("buyer_name", (Object)invoice.getString("buyerName"), insertEntryRow);
                this.getModel().setValue("buyer_tax_no", (Object)invoice.getString("buyerTaxNo"), insertEntryRow);
                this.getModel().setValue("passenger_name", (Object)invoice.getString("passengerName"), insertEntryRow);
                this.getModel().setValue("serial_no", (Object)invoice.getString("serialNo"), insertEntryRow);
                this.getModel().setValue("error_level", (Object)invoice.getString("errorLevel"), insertEntryRow);
                if (InvoiceCollectPluginService.canEditInvoice((JSONObject)invoice).booleanValue()) {
                    button.add("select_view");
                    entryGrid.hideOperateItems("operationcolumnap", insertEntryRow, button);
                } else {
                    button.add("select_edit");
                    entryGrid.hideOperateItems("operationcolumnap", insertEntryRow, button);
                }
                maxRowIndex = insertEntryRow;
                continue;
            }
            ++attachnentCount;
            insertEntryRow = hasExpenseNum ? this.getModel().insertEntryRow(treeEntryEntity, newEntryRow) : this.getModel().createNewEntryRow(treeEntryEntity);
            this.getModel().setValue("image_type", (Object)"attachment", insertEntryRow);
            this.getModel().setValue("serial_no", (Object)invoice.getString("serialNo"), insertEntryRow);
            this.getModel().setValue("error_level", (Object)invoice.getString("errorLevel"), insertEntryRow);
            if (InvoiceCollectPluginService.typeofsalerlist.equals(invoiceType)) {
                this.getModel().setValue("invoice_type", (Object)ResManager.loadKDString((String)"\u9500\u8d27\u6e05\u5355", (String)"InvSignByExpensePlugin_90", (String)"imc-rim-formplugin", (Object[])new Object[0]), insertEntryRow);
                this.getModel().setValue("invoice_code", (Object)invoice.getString("invoiceCode"), insertEntryRow);
                this.getModel().setValue("invoice_no", (Object)invoice.getString("invoiceNo"), insertEntryRow);
                this.getView().setEnable(Boolean.FALSE, insertEntryRow, new String[]{"image_type"});
            }
            button.add("select_view");
            entryGrid.hideOperateItems("operationcolumnap", insertEntryRow, button);
            maxRowIndex = insertEntryRow;
        }
        this.getPageCache().put(UPLOAD_COVER_COUNT, String.valueOf(coverCount));
        this.getPageCache().put(UPLOAD_INVOICE_COUNT, String.valueOf(invoiceCount));
        this.getPageCache().put(UPLOAD_ATTACHMENT_COUNT, String.valueOf(attachnentCount));
        entryGrid.setCollapse(false);
        if ("property_changed".equals(operate)) {
            String rowIndex = this.getPageCache().get("focusRowIndex");
            if (StringUtils.isNotEmpty((String)rowIndex)) {
                entryGrid.focusCell(Integer.parseInt(rowIndex), "image_type");
                this.getPageCache().remove("focusRowIndex");
            }
        } else if ("recognition_check".equals(operate)) {
            logger.info("\u6bcf\u6b21\u8bc6\u522b\u67e5\u9a8c\u8bbe\u7f6e\u7684\u6700\u5927\u7d22\u5f15\u662f\uff1a[{}]", (Object)maxRowIndex);
            entryGrid.focusCell(maxRowIndex, "operationcolumnap");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String flag = this.getPageCache().get("change");
        if (StringUtils.isNotEmpty((String)flag)) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        int index = this.getModel().getEntryCurrentRowIndex(treeEntryEntity);
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity(treeEntryEntity, index);
        String serialNo = dynamicObject.getString("serial_no");
        JSONObject invoiceJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        JSONObject invoice = invoiceJson.getJSONObject(serialNo);
        if ("image_type".equals(fieldKey) && StringUtils.isNotEmpty((String)serialNo)) {
            JSONObject newVerify;
            String newImageType = (String)e.getChangeSet()[0].getNewValue();
            String oldImageType = (String)e.getChangeSet()[0].getOldValue();
            JSONObject verifyJson = InvoiceCollectPluginService.getInvoiceVerifyCache((String)this.getView().getPageId());
            JSONObject verify = verifyJson.getJSONObject(serialNo);
            logger.info("\u5408\u89c4\u6027\u6821\u9a8c\u4fe1\u606f\u7f13\u5b58\uff1a{}", (Object)verify);
            if (verify != null && (newVerify = verify.getJSONObject(newImageType)) != null) {
                String errorLevel = newVerify.getString("errorLevel");
                if (!"3".equals(errorLevel)) {
                    invoice.put("errorLevel", newVerify.get((Object)"errorLevel"));
                    invoice.put("validateMessage", newVerify.get((Object)"validateMessage"));
                    invoice.put("verifyResult", newVerify.get((Object)"verifyResult"));
                    invoice.put("validateMessage_html", newVerify.get((Object)"validateMessage_html"));
                } else {
                    invoice.put("errorLevel", (Object)"3");
                    invoice.remove((Object)"validateMessage");
                    invoice.remove((Object)"verifyResult");
                    invoice.remove((Object)"validateMessage_html");
                }
            }
            invoice.put("imageType", (Object)newImageType);
            if ("invoice".equals(newImageType) && "attachment".equals(oldImageType) && InvoiceCollectPluginService.typeofsalerlist.equals(invoice.getLong("invoiceType"))) {
                invoice.put("invoiceType", (Object)InputInvoiceTypeEnum.OTHER_INVOICE.getCode());
            }
            invoiceJson.put(serialNo, (Object)invoice);
            InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)invoiceJson));
            this.setRowFocus(index);
            if ("cover".equals(newImageType) || "cover".equals(oldImageType)) {
                String cache = this.getPageCache().get("serial_no_index");
                JSONObject invoiceSeqCache = StringUtils.isNotEmpty((String)cache) ? JSON.parseObject((String)cache) : new JSONObject();
                String expenseMaxSeqCache = this.getPageCache().get(CACHE_EXPENSE_MAX_SEQ_DATA);
                JSONObject expenseMaxIndex = StringUtils.isNotEmpty((String)expenseMaxSeqCache) ? JSON.parseObject((String)expenseMaxSeqCache) : new JSONObject();
                String expenseNumber = invoice.getString("expenseNum");
                if (StringUtils.isNotEmpty((String)expenseNumber)) {
                    expenseMaxIndex.remove((Object)expenseNumber);
                    invoiceSeqCache.remove((Object)expenseNumber);
                    this.getPageCache().put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
                }
                invoiceSeqCache.remove((Object)serialNo);
                this.getPageCache().put("serial_no_index", invoiceSeqCache.toJSONString());
                if (StringUtils.isNotEmpty((String)invoice.getString("expenseNum"))) {
                    DynamicObjectCollection collection = this.getModel().getEntryEntity(treeEntryEntity);
                    int maxRowIndex = collection.size() - 1;
                    int selectRow = index;
                    logger.info("\u5f53\u524d\u884c\u7684\u7d22\u5f15\u662f\uff1a[{}]", (Object)selectRow);
                    if (selectRow <= maxRowIndex) {
                        this.getPageCache().put("rescan_begin_index", String.valueOf(selectRow));
                        this.getPageCache().put("rescan_end_index", String.valueOf(maxRowIndex));
                        logger.info("\u5207\u6362\u5f71\u50cf\u7c7b\u522b\u8d77\u59cb\u884c\u7d22\u5f15\u662f\uff1a[{}]\uff0c\u7ec8\u6b62\u884c\u7d22\u5f15\u662f\uff1a[{}]", (Object)String.valueOf(selectRow), (Object)maxRowIndex);
                    }
                    this.sortExpenseInvoice("update");
                    this.getPageCache().remove("rescan_begin_index");
                    this.getPageCache().remove("rescan_end_index");
                }
            }
            this.refreshInvoiceGrid("property_changed");
        }
    }

    private void setRowFocus(int index) {
        this.getPageCache().remove("focusRowIndex");
        this.getPageCache().put("focusRowIndex", index + "");
    }

    public void itemClick(ItemClickEvent evt) {
        if ("clearview".equals(evt.getItemKey())) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvSignByExpensePlugin_91", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InvSignByExpensePlugin_92", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6e05\u7a7a\u540e\u6570\u636e\u5728\u5f53\u524d\u754c\u9762\u65e0\u6cd5\u67e5\u770b\uff0c\u662f\u5426\u786e\u8ba4\u6e05\u7a7a\uff1f", (String)"InvSignByExpensePlugin_93", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("clearviewCallBack"), btnNameMaps);
        } else if ("del_invoice".equals(evt.getItemKey())) {
            this.operateCustomTable();
        } else if ("delete_invoice".equals(evt.getItemKey())) {
            this.operateCustomTable();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            if ("clearviewCallBack".equals(callBackId)) {
                this.initView();
            } else if ("clearCallBack".equals(callBackId)) {
                this.operateCustomTable();
            } else if ("downJsScanner".equals(callBackId)) {
                ScannerService.downJsScanner((AbstractFormPlugin)this);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map callBackData = (Map)closedCallBackEvent.getReturnData();
        if (callBackData != null && "editCallback".equals(closedCallBackEvent.getActionId())) {
            logger.info("\u4fee\u6539\u7ed3\u679c\uff1a" + SerializationUtils.toJsonString((Object)callBackData));
            this.editCallback(callBackData);
        } else if (callBackData != null && "retryCallback".equals(closedCallBackEvent.getActionId())) {
            JSONArray successData = JSONArray.parseArray((String)callBackData.get("successData").toString());
            logger.info("\u53f0\u8d26\u53d1\u7968\u91c7\u96c6\u91cd\u8bd5\u5904\u7406\u5b8c\u6bd5:" + successData);
            if (successData.size() > 0) {
                int invoiceSize = successData.size();
                for (int invoiceIndex = 0; invoiceIndex < invoiceSize; ++invoiceIndex) {
                    JSONObject invoice = successData.getJSONObject(invoiceIndex);
                    this.refreshInvoiceDate(invoice);
                }
                this.refreshInvoiceGrid("recognition_check");
            }
        } else if (callBackData != null && expenseEditPage.equals(closedCallBackEvent.getActionId())) {
            this.updateExpenseData(callBackData);
        } else if (callBackData != null && attachEditPage.equals(closedCallBackEvent.getActionId())) {
            this.updateAttachData(callBackData);
        }
    }

    private void updateExpenseData(Map<String, Object> returnData) {
        JSONObject dataJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        if (dataJson == null) {
            return;
        }
        String serialNo = MapUtils.getString(returnData, (Object)"serialNo");
        JSONObject invoice = dataJson.getJSONObject(serialNo);
        JSONObject verifyJson = InvoiceCollectPluginService.getInvoiceVerifyCache((String)this.getView().getPageId());
        JSONObject verify = verifyJson.getJSONObject(serialNo);
        if (verify != null) {
            JSONObject coverVerify = verify.getJSONObject("cover");
            if (coverVerify != null) {
                if (StringUtils.isEmpty((String)MapUtils.getString(returnData, (Object)"expenseNum"))) {
                    ArrayList<VerifyResultDto> resultList = new ArrayList<VerifyResultDto>(2);
                    VerifyResultDto dto = new VerifyResultDto();
                    dto.setName(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7f16\u53f7\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvSignByExpensePlugin_88", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    dto.setConfig("0");
                    dto.setMsg(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7f16\u53f7\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvSignByExpensePlugin_88", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    resultList.add(dto);
                    coverVerify.put("errorLevel", (Object)"0");
                    coverVerify.put("validateMessage", (Object)VerifyService.getResultMsg(resultList));
                    coverVerify.put("verifyResult", resultList);
                    coverVerify.put("validateMessage_html", (Object)VerifyService.getResultMsgHtml(resultList));
                    if ("cover".equals(invoice.getString("imageType"))) {
                        invoice.put("errorLevel", (Object)"0");
                        invoice.put("validateMessage", coverVerify.get((Object)"validateMessage"));
                        invoice.put("verifyResult", resultList);
                        invoice.put("validateMessage_html", coverVerify.get((Object)"validateMessage_html"));
                    }
                } else {
                    coverVerify.put("errorLevel", (Object)"3");
                    coverVerify.remove((Object)"validateMessage");
                    coverVerify.remove((Object)"verifyResult");
                    coverVerify.remove((Object)"validateMessage_html");
                    if ("cover".equals(invoice.getString("imageType"))) {
                        invoice.put("errorLevel", (Object)"3");
                        invoice.remove((Object)"validateMessage");
                        invoice.remove((Object)"verifyResult");
                        invoice.remove((Object)"validateMessage_html");
                    }
                }
            }
            verify.put("cover", (Object)coverVerify);
            verifyJson.put(serialNo, (Object)verify);
            InvoiceCollectPluginService.setInvoiceVerifyCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)verifyJson));
        }
        JSONArray barcodeArray = new JSONArray(1);
        barcodeArray.add(returnData.get("expenseNum"));
        invoice.put("barcode", (Object)barcodeArray);
        invoice.put("expenseNum", returnData.get("expenseNum"));
        dataJson.put(serialNo, (Object)invoice);
        logger.info("\u7f16\u8f91\u540e\u7684\u53d1\u7968\u4fe1\u606f\u662f\uff1a[{}]", (Object)invoice);
        InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)dataJson));
        int selectRow = this.getModel().getEntryCurrentRowIndex(treeEntryEntity);
        String expenseNum = (String)returnData.get("expenseNum");
        logger.info("\u5207\u5165\u70b9\u7684\u7d22\u5f15\u662f\uff1a[{}]", (Object)selectRow);
        if (StringUtils.isNotEmpty((String)expenseNum)) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity(treeEntryEntity);
            int maxRowIndex = collection.size() - 1;
            if (selectRow <= maxRowIndex) {
                this.getPageCache().put("rescan_begin_index", String.valueOf(selectRow));
                this.getPageCache().put("rescan_end_index", String.valueOf(maxRowIndex));
                logger.info("\u8865\u626b\u63d2\u5165\u8d77\u59cbrowIndex\u662f\uff1a[{}]\uff0c\u7ec8\u6b62rowIndex\u662f\uff1a[{}]", (Object)String.valueOf(selectRow), (Object)maxRowIndex);
            }
            this.sortExpenseInvoice("update");
            this.getPageCache().remove("rescan_begin_index");
            this.getPageCache().remove("rescan_end_index");
        }
        this.refreshInvoiceGrid(null);
    }

    private void updateAttachData(Map<String, Object> returnData) {
        JSONObject dataJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        if (dataJson == null) {
            return;
        }
        String serialNo = MapUtils.getString(returnData, (Object)"serialNo");
        JSONObject invoice = dataJson.getJSONObject(serialNo);
        JSONObject verifyJson = InvoiceCollectPluginService.getInvoiceVerifyCache((String)this.getView().getPageId());
        JSONObject verify = verifyJson.getJSONObject(serialNo);
        if (verify != null) {
            JSONObject attachVerify = verify.getJSONObject("attachment");
            if (attachVerify != null) {
                if (StringUtils.isEmpty((String)MapUtils.getString(returnData, (Object)"attach_name"))) {
                    ArrayList<VerifyResultDto> resultList = new ArrayList<VerifyResultDto>(2);
                    VerifyResultDto dto = new VerifyResultDto();
                    dto.setName(ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvSignByExpensePlugin_89", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    dto.setConfig("0");
                    dto.setMsg(ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvSignByExpensePlugin_89", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    resultList.add(dto);
                    attachVerify.put("errorLevel", (Object)"0");
                    attachVerify.put("validateMessage", (Object)VerifyService.getResultMsg(resultList));
                    attachVerify.put("verifyResult", resultList);
                    attachVerify.put("validateMessage_html", (Object)VerifyService.getResultMsgHtml(resultList));
                    if ("attachment".equals(invoice.getString("imageType"))) {
                        invoice.put("errorLevel", (Object)"0");
                        invoice.put("validateMessage", attachVerify.get((Object)"validateMessage"));
                        invoice.put("verifyResult", resultList);
                        invoice.put("validateMessage_html", attachVerify.get((Object)"validateMessage_html"));
                    }
                } else {
                    attachVerify.put("errorLevel", (Object)"3");
                    attachVerify.remove((Object)"validateMessage");
                    attachVerify.remove((Object)"verifyResult");
                    attachVerify.remove((Object)"validateMessage_html");
                    if ("attachment".equals(invoice.getString("imageType"))) {
                        invoice.put("errorLevel", (Object)"3");
                        invoice.remove((Object)"validateMessage");
                        invoice.remove((Object)"verifyResult");
                        invoice.remove((Object)"validateMessage_html");
                    }
                }
            }
            verify.put("attachment", (Object)attachVerify);
            verifyJson.put(serialNo, (Object)verify);
            InvoiceCollectPluginService.setInvoiceVerifyCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)verifyJson));
        }
        invoice.put("fileName", returnData.get("attach_name"));
        invoice.put("attachRemark", returnData.get("attach_remark"));
        invoice.put("attach_category", returnData.get("attach_category"));
        dataJson.put(serialNo, (Object)invoice);
        InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)dataJson));
        this.refreshInvoiceGrid(null);
    }

    private void editCallback(Map<String, Object> returnData) {
        String attachRemark;
        String fileName;
        JSONArray barcodeArray;
        JSONObject dataJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        if (dataJson == null) {
            dataJson = new JSONObject();
        }
        JSONObject invoice = (JSONObject)returnData.get("invoice");
        String oldSerialNo = (String)returnData.get("oldSerialNo");
        String newSerialNo = invoice.getString("serialNo");
        if (newSerialNo.equals(oldSerialNo)) {
            dataJson.put(newSerialNo, (Object)invoice);
        }
        if (!newSerialNo.equals(oldSerialNo)) {
            dataJson.remove((Object)oldSerialNo);
        }
        InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)dataJson.toJSONString());
        if (StringUtils.isNotEmpty((String)invoice.getString("serialNo"))) {
            JSONArray invoiceArray = new JSONArray();
            invoiceArray.add((Object)invoice);
            InvoiceCollectPluginService.cacheInvoiceSeqRelation((JSONArray)invoiceArray);
        }
        Long mainId = invoice.getLong("mainId");
        Long unCheckId = invoice.getLong("unCheckId");
        if (unCheckId != null) {
            InvoiceCollectPluginService.cacheInvoiceList((String)this.getView().getPageId(), this.getCustomParam(), null, Stream.of(unCheckId).collect(Collectors.toList()), null, (Boolean)Boolean.FALSE, (Boolean)Boolean.FALSE);
        } else {
            InvoiceCollectPluginService.cacheInvoiceList((String)this.getView().getPageId(), this.getCustomParam(), Stream.of(mainId).collect(Collectors.toList()), null, null, (Boolean)Boolean.FALSE, (Boolean)Boolean.FALSE);
        }
        JSONObject invoiceJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        JSONObject invoiceTemp = invoiceJson.getJSONObject(invoice.getString("serialNo"));
        invoiceTemp.put("fileIndex", invoice.get((Object)"fileIndex"));
        invoiceTemp.put("imageType", invoice.get((Object)"imageType"));
        invoiceTemp.put("delete", invoice.get((Object)"delete"));
        String expenseNum = invoice.getString("expenseNum");
        if (StringUtils.isNotEmpty((String)expenseNum)) {
            invoiceTemp.put("expenseNum", (Object)expenseNum);
        }
        if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoice.getLong("invoiceType")) && !CollectionUtils.isEmpty((Collection)(barcodeArray = invoice.getJSONArray("barcode"))) && StringUtils.isNotEmpty((String)(barcodeArray.get(0) + ""))) {
            barcodeArray.clear();
            barcodeArray.add((Object)expenseNum);
            invoiceTemp.put("barcode", (Object)invoice.getJSONArray("barcode"));
            invoiceTemp.put("kdcloudUrl", invoice.get((Object)"kdcloudUrl"));
        }
        if (StringUtils.isNotEmpty((String)(fileName = invoice.getString("fileName")))) {
            invoiceTemp.put("fileName", (Object)fileName);
        }
        if (StringUtils.isNotEmpty((String)(attachRemark = invoice.getString("attachRemark")))) {
            invoiceTemp.put("attachRemark", (Object)attachRemark);
        }
        invoiceJson.put(invoice.getString("serialNo"), (Object)invoiceTemp);
        InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)invoiceJson));
        if (!newSerialNo.equals(oldSerialNo)) {
            String cache;
            JSONObject invoiceVerifyJson = InvoiceCollectPluginService.getInvoiceVerifyCache((String)this.getView().getPageId());
            JSONObject verify = invoiceVerifyJson.getJSONObject(oldSerialNo);
            if (!ObjectUtils.isEmpty((Object)verify)) {
                JSONObject invoiceVerify = verify.getJSONObject("invoice");
                invoiceVerify.put("errorLevel", invoice.get((Object)"errorLevel"));
                if ("3".equals(invoiceVerify.getString("errorLevel"))) {
                    invoiceVerify.remove((Object)"validateMessage");
                    invoiceVerify.remove((Object)"verifyResult");
                    invoiceVerify.remove((Object)"validateMessage_html");
                } else {
                    invoiceVerify.put("validateMessage", invoice.get((Object)"validateMessage"));
                    invoiceVerify.put("verifyResult", invoice.get((Object)"verifyResult"));
                    invoiceVerify.put("validateMessage_html", invoice.get((Object)"validateMessage_html"));
                }
                verify.put("invoice", (Object)invoiceVerify);
                invoiceVerifyJson.put(newSerialNo, (Object)verify);
                invoiceVerifyJson.remove((Object)oldSerialNo);
            }
            JSONObject invoiceSeqCache = StringUtils.isNotEmpty((String)(cache = this.getPageCache().get("serial_no_index"))) ? JSON.parseObject((String)cache) : new JSONObject();
            invoiceSeqCache.put(newSerialNo, invoiceSeqCache.get((Object)oldSerialNo));
            invoiceSeqCache.remove((Object)oldSerialNo);
            this.getPageCache().put("serial_no_index", invoiceSeqCache.toJSONString());
        }
        this.refreshInvoiceGrid(null);
    }

    private void signInvoiceList(boolean isValidate) {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(treeEntryEntity);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u8fdb\u884c\u7b7e\u6536", (String)"InvSignByExpensePlugin_94", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        JSONObject invoiceJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        if (invoiceJson == null || invoiceJson.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5355\u636e\u53d1\u7968\u53ef\u7b7e\u6536", (String)"InvSignByExpensePlugin_95", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        DynamicObjectCollection collection = this.getModel().getEntryEntity(treeEntryEntity);
        HashMap<String, List<String>> expenseAndInvoiceMap = new HashMap<String, List<String>>(2);
        String expenseNumSerialNo = null;
        for (DynamicObject dynamicObject : collection) {
            ArrayList<String> invoiceAndAttach;
            String serialNo = dynamicObject.getString("serial_no");
            if ("cover".equals(dynamicObject.getString("image_type"))) {
                expenseNumSerialNo = serialNo;
                invoiceAndAttach = new ArrayList<String>(2);
                expenseAndInvoiceMap.put(serialNo, invoiceAndAttach);
                continue;
            }
            invoiceAndAttach = (ArrayList<String>)expenseAndInvoiceMap.get(expenseNumSerialNo);
            if (invoiceAndAttach == null) continue;
            invoiceAndAttach.add(serialNo);
        }
        LinkedHashMap<String, ExpenseDTO> expenseDTOMap = new LinkedHashMap<String, ExpenseDTO>(6);
        HashMap<String, String> expenseSerialNoMap = new HashMap<String, String>(2);
        if (this.validateInvoice(selectRows, invoiceJson, expenseAndInvoiceMap, expenseDTOMap, expenseSerialNoMap)) {
            return;
        }
        int expense_success_cnt = 0;
        int invoice_success_cnt = 0;
        int attach_success_cnt = 0;
        int expense_fail_cnt = 0;
        int invoice_fail_cnt = 0;
        int attach_fail_cnt = 0;
        HashSet<String> failExpenseSerialNoSet = new HashSet<String>(2);
        Iterator<Map.Entry<String, ExpenseDTO>> it = expenseDTOMap.entrySet().iterator();
        while (it.hasNext()) {
            this.validateSign(invoiceJson, expenseSerialNoMap, failExpenseSerialNoSet, it, isValidate);
        }
        this.removeSignedRow(expenseDTOMap, expenseSerialNoMap, failExpenseSerialNoSet, isValidate);
        for (Map.Entry entry : expenseDTOMap.entrySet()) {
            boolean flag;
            String expenseSerialNo = (String)entry.getKey();
            ExpenseDTO expenseDTO = (ExpenseDTO)entry.getValue();
            int invoiceCnt = CollectionUtils.isEmpty((Collection)expenseDTO.getInvoiceList()) ? 0 : expenseDTO.getInvoiceList().size();
            int attachCnt = CollectionUtils.isEmpty((Collection)expenseDTO.getAttachDTOList()) ? 0 : expenseDTO.getAttachDTOList().size();
            String expenseNumTemp = (String)expenseSerialNoMap.get(expenseSerialNo);
            boolean bl = flag = invoiceCnt == 0 && attachCnt == 0;
            if (!isValidate) {
                flag = false;
            }
            if (failExpenseSerialNoSet.contains(expenseSerialNo) || flag) {
                logger.info("\u7b7e\u6536\u5931\u8d25\u7684\u5355\u636e\u53f7\u662f\uff1a[{}]", (Object)expenseNumTemp);
                ++expense_fail_cnt;
                invoice_fail_cnt += invoiceCnt;
                attach_fail_cnt += attachCnt;
                continue;
            }
            ++expense_success_cnt;
            invoice_success_cnt += invoiceCnt;
            attach_success_cnt += attachCnt;
        }
        String msg = String.format(ResManager.loadKDString((String)"\u6210\u529f\u7b7e\u6536\uff1a\u5171\u8ba1\u5355\u636e%1$s\u4efd\uff0c\u53d1\u7968%2$s\u4efd\uff0c\u9644\u4ef6%3$s\u4efd\u3002\u7b7e\u6536\u5931\u8d25\uff1a\u5171\u8ba1\u5355\u636e%4$s\u4efd\uff0c\u53d1\u7968%5$s\u4efd\uff0c\u9644\u4ef6%6$s\u4efd\u3002\u7b7e\u6536\u5931\u8d25\u7684\u53d1\u7968\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e\u5173\u8054\u5355\u636e\u5c01\u9762\uff0c\u6216\u68c0\u67e5\u201c!\u201d\u4e0a\u7684\u5177\u4f53\u9519\u8bef\u63d0\u793a\u3002", (String)"InvSignByExpensePlugin_80", (String)"imc-rim-formplugin", (Object[])new Object[0]), expense_success_cnt, invoice_success_cnt, attach_success_cnt, expense_fail_cnt, invoice_fail_cnt, attach_fail_cnt);
        if (expense_success_cnt + invoice_success_cnt + attach_success_cnt > 0) {
            this.getView().showSuccessNotification(msg, Integer.valueOf(30000));
        } else {
            this.getView().showTipNotification(msg, Integer.valueOf(30000));
        }
    }

    private void validateSign(JSONObject invoiceJson, Map<String, String> expenseSerialNoMap, Set<String> failExpenseSerialNoSet, Iterator<Map.Entry<String, ExpenseDTO>> it, boolean isValidate) {
        JSONObject invoice;
        String serialNo;
        Map.Entry<String, ExpenseDTO> entry = it.next();
        String expenseSerialNo = entry.getKey();
        ExpenseDTO expenseDTO = entry.getValue();
        boolean signFlag = true;
        String expenseNumTemp = expenseSerialNoMap.get(expenseSerialNo);
        boolean expenseRelationExitst = true;
        HashSet extraSerials = Sets.newHashSet();
        String resource = "";
        if (StringUtils.isNotEmpty((String)expenseNumTemp)) {
            String serialNo2;
            QFilter qFilters = new QFilter("expense_num", "=", (Object)expenseNumTemp);
            expenseRelationExitst = this.expenseService.isExitst(qFilters);
            if (expenseRelationExitst) {
                QFilter expenseRelationFilters;
                DynamicObjectCollection expenseRelation;
                List serialNos;
                DynamicObjectCollection expenseCollection = this.expenseService.findByFilter("expense_id,resource", qFilters);
                if (!CollectionUtils.isEmpty((Collection)expenseCollection)) {
                    resource = ((DynamicObject)expenseCollection.get(0)).getString("resource");
                    expenseDTO.setExpenseId(((DynamicObject)expenseCollection.get(0)).getString("expense_id"));
                }
                if (!CollectionUtils.isEmpty(serialNos = (expenseRelation = this.expenseRelationService.findByFilter("serial_no", expenseRelationFilters = new QFilter("expense_num", "=", (Object)expenseNumTemp))).stream().map(c -> c.getString("serial_no")).collect(Collectors.toList()))) {
                    JSONObject invoice2;
                    String serialNo3;
                    for (ExpenseInvoiceDTO expenseInvoiceDTO : expenseDTO.getInvoiceList()) {
                        serialNo3 = expenseInvoiceDTO.getSerialNo();
                        invoice2 = invoiceJson.getJSONObject(serialNo3);
                        if (!serialNos.contains(serialNo3) && !"6".equals(resource)) {
                            signFlag = false;
                            if (isValidate) {
                                failExpenseSerialNoSet.add(expenseSerialNo);
                            }
                            extraSerials.add(serialNo3);
                            this.addVerifyMsg(invoiceJson, serialNo3, invoice2, ResManager.loadKDString((String)"\u591a\u626b\u6216\u9519\u626b", (String)"InvSignByExpensePlugin_96", (String)"imc-rim-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8be5\u5355\u636e\u524d\u7aef\u4e1a\u52a1\u4eba\u5458\u6ca1\u6709\u91c7\u96c6\u8be5\u53d1\u7968\uff0c\u4e0d\u80fd\u505a\u7b7e\u6536\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u591a\u626b\u6216\u9519\u626b", (String)"InvSignByExpensePlugin_97", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                            continue;
                        }
                        this.clearVerifyMsg(invoiceJson, serialNo3, invoice2, ResManager.loadKDString((String)"\u591a\u626b\u6216\u9519\u626b", (String)"InvSignByExpensePlugin_96", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    }
                    if (signFlag && !"6".equals(resource)) {
                        JSONObject invoice3;
                        String serialNo4;
                        QFilter qFilter = new QFilter("serial_no", "in", serialNos);
                        qFilter.and("invoice_type", "in", (Object)InputInvoiceTypeEnum.getPaperTypes());
                        DynamicObjectCollection paperInvoices = QueryServiceHelper.query((String)"rim_invoice", (String)"serial_no", (QFilter[])qFilter.toArray());
                        List paperSerialNos = paperInvoices.stream().map(s -> s.getString("serial_no")).collect(Collectors.toList());
                        List signSerialNos = expenseDTO.getInvoiceList().stream().map(ExpenseInvoiceDTO::getSerialNo).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(paperSerialNos) && !signSerialNos.containsAll(paperSerialNos)) {
                            for (ExpenseInvoiceDTO expenseInvoiceDTO : expenseDTO.getInvoiceList()) {
                                serialNo4 = expenseInvoiceDTO.getSerialNo();
                                invoice3 = invoiceJson.getJSONObject(serialNo4);
                                signFlag = false;
                                if (isValidate) {
                                    failExpenseSerialNoSet.add(expenseSerialNo);
                                }
                                this.addVerifyMsg(invoiceJson, serialNo4, invoice3, ResManager.loadKDString((String)"\u7f3a\u5c11\u7eb8\u8d28\u53d1\u7968", (String)"InvSignByExpensePlugin_98", (String)"imc-rim-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8be5\u5355\u636e\u7f3a\u5c11\u7eb8\u8d28\u53d1\u7968\uff0c\u8bf7\u68c0\u67e5", (String)"InvSignByExpensePlugin_99", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                            }
                        } else {
                            for (ExpenseInvoiceDTO expenseInvoiceDTO : expenseDTO.getInvoiceList()) {
                                serialNo4 = expenseInvoiceDTO.getSerialNo();
                                invoice3 = invoiceJson.getJSONObject(serialNo4);
                                this.clearVerifyMsg(invoiceJson, serialNo4, invoice3, ResManager.loadKDString((String)"\u7f3a\u5c11\u7eb8\u8d28\u53d1\u7968", (String)"InvSignByExpensePlugin_98", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                            }
                        }
                    } else {
                        for (ExpenseInvoiceDTO expenseInvoiceDTO : expenseDTO.getInvoiceList()) {
                            serialNo3 = expenseInvoiceDTO.getSerialNo();
                            invoice2 = invoiceJson.getJSONObject(serialNo3);
                            this.clearVerifyMsg(invoiceJson, serialNo3, invoice2, ResManager.loadKDString((String)"\u7f3a\u5c11\u53d1\u7968", (String)"InvSignByExpensePlugin_100", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        }
                    }
                } else {
                    expenseRelationExitst = false;
                }
            }
            if (!expenseRelationExitst || "6".equals(resource)) {
                for (ExpenseInvoiceDTO expenseInvoiceDTO : expenseDTO.getInvoiceList()) {
                    serialNo2 = expenseInvoiceDTO.getSerialNo();
                    QFilter expenseRelationFilters = new QFilter("serial_no", "=", (Object)serialNo2);
                    expenseRelationFilters.and("status", "!=", (Object)"1");
                    DynamicObjectCollection expenseRelation = this.expenseRelationService.findByFilter("expense_num", expenseRelationFilters);
                    JSONObject invoice4 = invoiceJson.getJSONObject(serialNo2);
                    if (CollectionUtils.isEmpty((Collection)expenseRelation)) continue;
                    if (!expenseNumTemp.equals(((DynamicObject)expenseRelation.get(0)).getString("expense_num"))) {
                        signFlag = false;
                        if (isValidate) {
                            failExpenseSerialNoSet.add(expenseSerialNo);
                        }
                        this.addVerifyMsg(invoiceJson, serialNo2, invoice4, ResManager.loadKDString((String)"\u91cd\u590d\u62a5\u9500", (String)"InvSignByExpensePlugin_101", (String)"imc-rim-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u91cd\u590d\u62a5\u9500", (String)"InvSignByExpensePlugin_101", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    this.clearVerifyMsg(invoiceJson, serialNo2, invoice4, ResManager.loadKDString((String)"\u91cd\u590d\u62a5\u9500", (String)"InvSignByExpensePlugin_101", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
            }
            for (ExpenseInvoiceDTO expenseInvoiceDTO : expenseDTO.getInvoiceList()) {
                serialNo2 = expenseInvoiceDTO.getSerialNo();
                JSONObject invoice5 = invoiceJson.getJSONObject(serialNo2);
                if (!"0".equals(invoice5.getString("errorLevel"))) continue;
                signFlag = false;
                if (!isValidate) continue;
                failExpenseSerialNoSet.add(expenseSerialNo);
            }
        }
        for (ExpenseAttachDTO expenseAttachDTO : expenseDTO.getAttachDTOList()) {
            serialNo = expenseAttachDTO.getSerialNo();
            invoice = invoiceJson.getJSONObject(serialNo);
            if (!"0".equals(invoice.getString("errorLevel"))) continue;
            signFlag = false;
            if (!isValidate) continue;
            failExpenseSerialNoSet.add(expenseSerialNo);
        }
        if (StringUtils.isEmpty((String)expenseNumTemp)) {
            signFlag = false;
            logger.info("\u5355\u636e\u7f16\u53f7\u662f\u7a7a");
            for (ExpenseInvoiceDTO expenseInvoiceDTO : expenseDTO.getInvoiceList()) {
                serialNo = expenseInvoiceDTO.getSerialNo();
                invoice = invoiceJson.getJSONObject(serialNo);
                if (!"0".equals(invoice.getString("errorLevel")) || !isValidate) continue;
                failExpenseSerialNoSet.add(expenseSerialNo);
            }
        }
        if (isValidate && CollectionUtils.isEmpty((Collection)expenseDTO.getInvoiceList()) && CollectionUtils.isEmpty((Collection)expenseDTO.getAttachDTOList())) {
            failExpenseSerialNoSet.add(expenseSerialNo);
            signFlag = false;
        }
        InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)invoiceJson));
        if (!signFlag && isValidate) {
            return;
        }
        logger.info("\u7b7e\u6536\u89c4\u5219\u901a\u8fc7\uff1a[{}]", (Object)expenseNumTemp);
        if (isValidate) {
            extraSerials.clear();
        }
        this.beginSignInvoice(invoiceJson, expenseDTO, expenseRelationExitst, resource, extraSerials, isValidate);
    }

    private void addVerifyMsg(JSONObject invoiceJson, String serialNo, JSONObject invoice, String msgKey, String msgValue) {
        ArrayList<VerifyResultDto> resultList = (ArrayList<VerifyResultDto>)invoice.get((Object)"verifyResult");
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            resultList = new ArrayList<VerifyResultDto>(2);
        } else {
            String validateMessage = invoice.getString("validateMessage");
            if (StringUtils.isNotEmpty((String)validateMessage) && validateMessage.indexOf(msgKey) != -1) {
                return;
            }
        }
        VerifyResultDto dto = new VerifyResultDto();
        dto.setName(msgValue);
        dto.setConfig("0");
        dto.setMsg(msgValue);
        resultList.add(dto);
        invoice.put("errorLevel", (Object)"0");
        invoice.put("validateMessage", (Object)VerifyService.getResultMsg(resultList));
        invoice.put("verifyResult", resultList);
        invoice.put("validateMessage_html", (Object)VerifyService.getResultMsgHtml(resultList));
        invoiceJson.put(serialNo, (Object)invoice);
    }

    private void clearVerifyMsg(JSONObject invoiceJson, String serialNo, JSONObject invoice, String msgKey) {
        List verifyList = JSON.parseArray((String)JSON.toJSONString((Object)invoice.get((Object)"verifyResult")), VerifyResultDto.class);
        if (!CollectionUtils.isEmpty((Collection)verifyList)) {
            boolean haveError = false;
            Iterator iterator = verifyList.iterator();
            while (iterator.hasNext()) {
                VerifyResultDto dto = (VerifyResultDto)iterator.next();
                String msg = dto.getMsg();
                if (!StringUtils.isNotEmpty((String)msg) || msg.indexOf(msgKey) == -1) continue;
                haveError = true;
                iterator.remove();
                break;
            }
            if (haveError) {
                String level = "3";
                for (VerifyResultDto dto : verifyList) {
                    if (Integer.parseInt(dto.getConfig()) >= Integer.parseInt(level)) continue;
                    level = dto.getConfig();
                }
                invoice.put("errorLevel", (Object)level);
                invoice.put("validateMessage", (Object)VerifyService.getResultMsg((Object)verifyList));
                invoice.put("verifyResult", (Object)verifyList);
                invoice.put("validateMessage_html", (Object)VerifyService.getResultMsgHtml((Object)verifyList));
                invoiceJson.put(serialNo, (Object)invoice);
            }
        }
    }

    private void beginSignInvoice(JSONObject invoiceJson, ExpenseDTO expenseDTO, boolean expenseRelationExitst, String resource, Set<String> extraSerials, boolean isValidate) {
        boolean signResult;
        this.attachSaveService.save(expenseDTO);
        expenseDTO.setDeleteAttachRelation(true);
        if (!expenseRelationExitst || "6".equals(resource)) {
            this.expenseService.save(expenseDTO);
            for (ExpenseInvoiceDTO expenseInvoiceDTO : expenseDTO.getInvoiceList()) {
                DynamicObject[] qFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
                String serialNo = expenseInvoiceDTO.getSerialNo();
                qFilter.and("serial_no", "=", (Object)serialNo);
                DynamicObject invoiceMain = this.invoiceQueryService.queryOne("expense_num, expense_status, invoice_info", (QFilter)qFilter);
                JSONObject invoice = invoiceJson.getJSONObject(serialNo);
                invoice.put("expenseNum", invoiceMain.get("expense_num"));
                invoice.put("expenseStatus", invoiceMain.get("expense_status"));
                invoice.put("invoice_info", invoiceMain.get("invoice_info"));
                invoiceJson.put(serialNo, (Object)invoice);
            }
        } else {
            if (this.getBatchPattern() != null) {
                DynamicObject[] expenses;
                QFilter filer = new QFilter("expense_id", "=", (Object)expenseDTO.getExpenseId());
                if (!StringUtils.isEmpty((String)resource)) {
                    filer = filer.and(new QFilter("resource", "=", (Object)resource));
                }
                if ((expenses = BusinessDataServiceHelper.load((String)"rim_expense", (String)"id,batch,expense_id,update_time", (QFilter[])filer.toArray())) != null && expenses.length > 0) {
                    for (DynamicObject expense : expenses) {
                        expense.set("batch", (Object)expenseDTO.getBatch());
                        expense.set("update_time", (Object)new Date());
                    }
                    SaveServiceHelper.save((DynamicObject[])expenses);
                }
            }
            this.expenseService.saveCoverAndAttachmentRelation(expenseDTO);
        }
        ArrayList<String> serialNosList = new ArrayList<String>(2);
        for (ExpenseInvoiceDTO expenseInvoiceDTO : expenseDTO.getInvoiceList()) {
            String serialNo = expenseInvoiceDTO.getSerialNo();
            JSONObject invoice = invoiceJson.getJSONObject(serialNo);
            if (!StringUtils.isNotEmpty((String)serialNo) || "0".equals(invoice.getString("isStorage"))) continue;
            serialNosList.add(serialNo);
            logger.info("\u5237\u65b0\u7b7e\u6536\u72b6\u6001\u7684\u53d1\u7968\u53f7\u7801\uff1a[{},delete:{},list:{}]", new Object[]{invoice.getString("invoiceNo"), invoice.getString("fdelete"), serialNosList});
            String invoice_info = invoice.getString("invoice_info");
            if (invoice_info.indexOf("or_0") != -1) {
                invoice_info = invoice_info.replace("or_0", "or_1");
            } else if (invoice_info.indexOf("or_1") == -1) {
                invoice_info = invoice_info + "or_1,";
            }
            invoice.put("invoice_info", (Object)invoice_info);
            invoice.put("originalState", (Object)"1");
            invoice.put("delete", (Object)"1");
            VerifyUtil.updateInvoiceDelStatus((String)serialNo, (String)"rim_invoice_uncheck", (boolean)true);
            invoiceJson.put(serialNo, (Object)invoice);
        }
        InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)invoiceJson));
        logger.info("\u5faa\u73af\u7b7e\u6536\u53d1\u7968\u7684\u6570\u91cf\u662f\uff1a[{}]", (Object)serialNosList.size());
        if (!CollectionUtils.isEmpty(serialNosList) && (signResult = this.invoiceCollectService.signInvoice(serialNosList, "1"))) {
            ExpenseCallBackService.signInvoiceBatch(serialNosList, (String)"1");
        }
        this.saveSignLog(expenseDTO, invoiceJson, isValidate);
    }

    private void saveSignLog(ExpenseDTO expenseDTO, JSONObject invoiceJson, boolean isValidate) {
        RequestContext cotext = RequestContext.get();
        DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"rim_invsign_log");
        logObj.set("creater", (Object)cotext.getCurrUserId());
        logObj.set("createdate", (Object)new Date());
        logObj.set("traceid", (Object)cotext.getTraceId());
        logObj.set("expense_num", (Object)expenseDTO.getExpenseNum());
        logObj.set("expense_id", (Object)expenseDTO.getExpenseId());
        logObj.set("batch", (Object)expenseDTO.getBatch());
        if (isValidate) {
            logObj.set("sign_type", (Object)"1");
        } else {
            logObj.set("sign_type", (Object)"2");
        }
        List invoiceList = expenseDTO.getInvoiceList();
        List attachList = expenseDTO.getAttachDTOList();
        if (invoiceList != null) {
            logObj.set("invoice_count", (Object)invoiceList.size());
            ArrayList<String> serialList = new ArrayList<String>(invoiceList.size());
            for (ExpenseInvoiceDTO invoiceDto : invoiceList) {
                serialList.add(invoiceDto.getSerialNo());
            }
            QFilter filter = new QFilter("serial_no", "in", serialList);
            DynamicObjectCollection expenseCollect = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no,status,expense_num", (QFilter[])filter.toArray());
            HashMap<String, HashSet<String>> expenseMap = new HashMap<String, HashSet<String>>(invoiceList.size());
            HashMap<String, Integer> statusMap = new HashMap<String, Integer>(invoiceList.size());
            for (DynamicObject obj : expenseCollect) {
                Integer currentStats;
                String expenseNo = obj.getString("expense_num");
                String serial_no = obj.getString("serial_no");
                HashSet<String> set = (HashSet<String>)expenseMap.get(serial_no);
                if (set == null) {
                    set = new HashSet<String>(4);
                }
                set.add(expenseNo);
                expenseMap.put(serial_no, set);
                Integer status = (Integer)statusMap.get(serial_no);
                if (status == null) {
                    status = 1;
                }
                if ((currentStats = Integer.valueOf(BigDecimalUtil.transDecimal((Object)obj.getString("status")).intValue())) > status) {
                    status = currentStats;
                }
                statusMap.put(serial_no, status);
            }
            for (ExpenseInvoiceDTO invoiceDto : invoiceList) {
                DynamicObject item = logObj.getDynamicObjectCollection("invoice_entryentity").addNew();
                JSONObject invoice = invoiceJson.getJSONObject(invoiceDto.getSerialNo());
                String validateMessage = invoice.getString("validateMessage");
                item.set("serial_no", (Object)invoiceDto.getSerialNo());
                item.set("invoice_no", (Object)invoice.getString("invoiceNo"));
                item.set("invoice_code", (Object)invoice.getString("invoiceCode"));
                if (statusMap.get(invoiceDto.getSerialNo()) != null) {
                    item.set("expense_status", statusMap.get(invoiceDto.getSerialNo()));
                } else {
                    item.set("expense_status", (Object)"1");
                }
                if (expenseMap.get(invoiceDto.getSerialNo()) != null) {
                    Set noSet = (Set)expenseMap.get(invoiceDto.getSerialNo());
                    String num = String.join((CharSequence)",", noSet);
                    if (num.length() > 450) {
                        item.set("exists_num", (Object)num.substring(0, 450));
                    } else {
                        item.set("exists_num", (Object)num);
                    }
                } else {
                    item.set("expense_status", (Object)"1");
                }
                if (validateMessage != null && validateMessage.length() > 500) {
                    item.set("verify_msg", (Object)validateMessage.substring(0, 500));
                } else {
                    item.set("verify_msg", (Object)validateMessage);
                }
                item.set("invoice_amount", (Object)BigDecimalUtil.transDecimal((Object)invoice.get((Object)"invoiceAmount")));
                item.set("total_tax_amount", (Object)BigDecimalUtil.transDecimal((Object)invoice.get((Object)"totalTaxAmount")));
                item.set("total_amount", (Object)BigDecimalUtil.transDecimal((Object)invoice.get((Object)"totalAmount")));
                item.set("invoice_type", (Object)InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoice.getString("invoiceType")));
            }
        }
        if (attachList != null) {
            logObj.set("attach_count", (Object)attachList.size());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
    }

    private boolean validateInvoice(int[] selectRows, JSONObject invoiceJson, Map<String, List<String>> expenseAndInvoiceMap, Map<String, ExpenseDTO> expenseDTOMap, Map<String, String> expenseSerialNoMap) {
        HashSet<String> expenseNumSet = new HashSet<String>(selectRows.length);
        logger.info("validateInvoice:{}", (Object)invoiceJson);
        String expenseNum = null;
        Pattern batchPattern = this.getBatchPattern();
        String batch = null;
        for (int i = 0; i < selectRows.length; ++i) {
            ExpenseDTO expenseDTO;
            List<String> invoiceAndAttach;
            String ducExpenseNum;
            int rowIndex = selectRows[i];
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(treeEntryEntity, rowIndex);
            if (ObjectUtils.isEmpty((Object)dynamicObject)) continue;
            String serialNo = dynamicObject.getString("serial_no");
            JSONObject invoice = invoiceJson.getJSONObject(serialNo);
            if ("batch".equals(dynamicObject.getString("image_type"))) {
                if (batchPattern == null) continue;
                ducExpenseNum = dynamicObject.getString("expense_num");
                if (!batchPattern.matcher(ducExpenseNum).find()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6279\u6b21\u53f7\u683c\u5f0f\u9519\u8bef", (String)"InvSignByExpensePlugin_118", (String)"imc-rim-formplugin", (Object[])new Object[0]), rowIndex + 1), Integer.valueOf(3000));
                    return false;
                }
                batch = ducExpenseNum;
                continue;
            }
            if ("cover".equals(dynamicObject.getString("image_type"))) {
                ducExpenseNum = dynamicObject.getString("expense_num");
                if (!expenseNumSet.add(ducExpenseNum)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u53f7\u4e0d\u80fd\u91cd\u590d", (String)"InvSignByExpensePlugin_102", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return true;
                }
                expenseNum = serialNo;
                expenseSerialNoMap.put(serialNo, ducExpenseNum);
                ExpenseDTO dto = new ExpenseDTO();
                dto.setExpenseId(ducExpenseNum);
                dto.setExpenseNum(ducExpenseNum);
                dto.setResource("6");
                dto.setStatus("60");
                dto.setOrgId(Long.valueOf(RequestContext.get().getOrgId()));
                dto.setBillUser(RequestContext.get().getUserId());
                dto.setInvoiceList(new ArrayList(2));
                dto.setAttachDTOList(new ArrayList(2));
                dto.setRowIndex(Integer.valueOf(rowIndex));
                if (batchPattern != null) {
                    QFilter filter;
                    DynamicObject obj;
                    if (StringUtils.isEmpty((String)batch) && (obj = QueryServiceHelper.queryOne((String)"rim_expense", (String)"batch", (QFilter[])(filter = new QFilter("expense_id", "=", (Object)dto.getExpenseId())).toArray())) != null) {
                        batch = obj.getString("batch");
                    }
                    if (StringUtils.isEmpty((String)batch)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvSignByExpensePlugin_119", (String)"imc-rim-formplugin", (Object[])new Object[0]), rowIndex + 1), Integer.valueOf(3000));
                        return false;
                    }
                    dto.setBatch(batch);
                }
                if (!ObjectUtils.isEmpty((Object)invoice)) {
                    String type;
                    ExpenseCoverDTO expenseCoverDTO = new ExpenseCoverDTO();
                    String localUrl = invoice.getString("downloadUrl");
                    if (StringUtils.isEmpty((String)localUrl)) {
                        localUrl = invoice.getString("attach_url");
                    }
                    if (StringUtils.isEmpty((String)localUrl)) {
                        localUrl = invoice.getString("snapshotUrl");
                    }
                    if (StringUtils.isEmpty((String)localUrl)) {
                        localUrl = invoice.getString("snapshot_url");
                    }
                    if ("pdf".equalsIgnoreCase(type = FileUtils.getFileType((String)localUrl))) {
                        expenseCoverDTO.setFileType(Integer.valueOf(1));
                    } else {
                        expenseCoverDTO.setFileType(Integer.valueOf(2));
                    }
                    expenseCoverDTO.setLocalUrl(localUrl);
                    ArrayList<ExpenseCoverDTO> coverDTOList = new ArrayList<ExpenseCoverDTO>(1);
                    coverDTOList.add(expenseCoverDTO);
                    dto.setCoverDTOList(coverDTOList);
                }
                expenseDTOMap.put(expenseNum, dto);
                continue;
            }
            if ("invoice".equals(dynamicObject.getString("image_type"))) {
                invoiceAndAttach = expenseAndInvoiceMap.get(expenseNum);
                if (invoiceAndAttach != null && !invoiceAndAttach.contains(serialNo)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u524d\u7aef\u4e1a\u52a1\u4eba\u5458\u6ca1\u6709\u91c7\u96c6\u8be5\u53d1\u7968\uff0c\u4e0d\u80fd\u505a\u7b7e\u6536\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u591a\u626b\u6216\u9519\u626b", (String)"InvSignByExpensePlugin_97", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return true;
                }
                ExpenseInvoiceDTO expenseInvoiceDTO = new ExpenseInvoiceDTO();
                expenseInvoiceDTO.setSerialNo(serialNo);
                expenseInvoiceDTO.setRowIndex(Integer.valueOf(rowIndex));
                expenseDTO = expenseDTOMap.get(expenseNum);
                if (expenseDTO == null) continue;
                expenseDTO.getInvoiceList().add(expenseInvoiceDTO);
                continue;
            }
            invoiceAndAttach = expenseAndInvoiceMap.get(expenseNum);
            if (invoiceAndAttach != null && !invoiceAndAttach.contains(serialNo)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u524d\u7aef\u4e1a\u52a1\u4eba\u5458\u6ca1\u6709\u91c7\u96c6\u8be5\u9644\u4ef6\uff0c\u4e0d\u80fd\u505a\u7b7e\u6536\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u591a\u626b\u6216\u9519\u626b", (String)"InvSignByExpensePlugin_103", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return true;
            }
            ExpenseAttachDTO expenseAttachDTO = new ExpenseAttachDTO();
            expenseAttachDTO.setAttachType("2");
            expenseAttachDTO.setAttachName(invoice.getString("fileName"));
            expenseAttachDTO.setAttachUrl(invoice.getString("snapshotUrl"));
            expenseAttachDTO.setAttachRemark(invoice.getString("attachRemark"));
            expenseAttachDTO.setRelationType("1");
            expenseAttachDTO.setSerialNo(serialNo);
            expenseAttachDTO.setRowIndex(Integer.valueOf(rowIndex));
            expenseAttachDTO.setAttachId(invoice.getString("id"));
            expenseDTO = expenseDTOMap.get(expenseNum);
            if (expenseDTO == null) continue;
            expenseDTO.getAttachDTOList().add(expenseAttachDTO);
        }
        if (StringUtils.isEmpty(expenseNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b7e\u6536\u5931\u8d25\uff0c\u672a\u52fe\u9009\u53d1\u7968\u5bf9\u5e94\u7684\u5355\u636e\u5c01\u9762", (String)"InvSignByExpensePlugin_104", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return true;
        }
        return false;
    }

    private void removeSignedRow(Map<String, ExpenseDTO> expenseDTOMap, Map<String, String> expenseSerialNoMap, Set<String> failExpenseSerialNoSet, boolean isValidate) {
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>(2);
        JSONObject invoiceJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        if (invoiceJson == null) {
            return;
        }
        Iterator<Map.Entry<String, ExpenseDTO>> it = expenseDTOMap.entrySet().iterator();
        int rowCount = this.getModel().getEntryRowCount(treeEntryEntity);
        HashMap<String, String> allExpense = new HashMap<String, String>(8);
        HashMap<String, Integer> batchRow = new HashMap<String, Integer>(8);
        String batchNum = null;
        for (int i = 0; i < rowCount; ++i) {
            String image_type = (String)this.getModel().getValue("image_type", i);
            String expense_num = (String)this.getModel().getValue("expense_num", i);
            if ("batch".equals(image_type)) {
                batchRow.put(expense_num, i);
                batchNum = expense_num;
                continue;
            }
            if (!"cover".equals(image_type) || batchNum == null) continue;
            allExpense.put(expense_num, batchNum);
        }
        LinkedHashSet<String> remainBatch = new LinkedHashSet<String>(4);
        while (it.hasNext()) {
            Iterator entry = it.next();
            String expenseSerialNo = (String)entry.getKey();
            ExpenseDTO expenseDTO = (ExpenseDTO)entry.getValue();
            String expenseNumTemp = expenseSerialNoMap.get(expenseSerialNo);
            if (StringUtils.isEmpty((String)expenseNumTemp) || failExpenseSerialNoSet.contains(expenseSerialNo)) {
                if (!StringUtils.isNotEmpty((String)expenseDTO.getBatch())) continue;
                remainBatch.add(expenseDTO.getBatch());
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)expenseDTO.getInvoiceList()) && CollectionUtils.isEmpty((Collection)expenseDTO.getAttachDTOList()) && isValidate) continue;
            allExpense.remove(expenseNumTemp);
            boolean haveUnSign = false;
            for (ExpenseInvoiceDTO expenseInvoiceDTO : expenseDTO.getInvoiceList()) {
                String serialNo = expenseInvoiceDTO.getSerialNo();
                JSONObject invoice = invoiceJson.getJSONObject(serialNo);
                String invoice_info = invoice.getString("invoice_info");
                if (invoice_info.indexOf("or_1") != -1) continue;
                haveUnSign = true;
                break;
            }
            if (haveUnSign) {
                if (!StringUtils.isNotEmpty((String)expenseDTO.getBatch())) continue;
                remainBatch.add(expenseDTO.getBatch());
                continue;
            }
            rowIndexs.add(expenseDTO.getRowIndex());
            for (ExpenseInvoiceDTO expenseInvoiceDTO : expenseDTO.getInvoiceList()) {
                rowIndexs.add(expenseInvoiceDTO.getRowIndex());
            }
            for (ExpenseAttachDTO expenseAttachDTO : expenseDTO.getAttachDTOList()) {
                rowIndexs.add(expenseAttachDTO.getRowIndex());
            }
        }
        for (Map.Entry batchEcnty : allExpense.entrySet()) {
            remainBatch.add((String)batchEcnty.getValue());
        }
        for (Map.Entry batchEcnty : batchRow.entrySet()) {
            if (remainBatch.contains(batchEcnty.getKey())) continue;
            rowIndexs.add((Integer)batchEcnty.getValue());
        }
        Collections.sort(rowIndexs);
        logger.info("\u9700\u8981\u79fb\u9664\u7684\u884c\uff1a{}", rowIndexs);
        int[] selectRows = rowIndexs.stream().mapToInt(Integer::intValue).toArray();
        if (ArrayUtils.isEmpty((int[])selectRows)) {
            logger.info("\u6ca1\u6709\u9700\u8981\u79fb\u9664\u7684\u884c");
            this.refreshInvoiceGrid(null);
            return;
        }
        this.batchDeleteRow(selectRows, invoiceJson);
    }

    private void deleteRow() {
        int index = this.getModel().getEntryCurrentRowIndex(treeEntryEntity);
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity(treeEntryEntity, index);
        logger.info("\u5220\u9664\u7684\u7d22\u5f15\u662f\uff1a[{}]\uff0c\u884c\u6570\u636e\u662f\uff1a[{}]", (Object)index, (Object)dynamicObject);
        JSONObject dataJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        String serialNo = dynamicObject.getString("serial_no");
        JSONObject invoice = dataJson.getJSONObject(serialNo);
        logger.info("\u5220\u9664\u7684\u53d1\u7968\u6570\u636e\u662f\uff1a[{}]", (Object)invoice);
        if (ObjectUtils.isEmpty((Object)invoice)) {
            return;
        }
        this.deleteOperate(index, dataJson, serialNo, invoice);
    }

    private void deleteOperate(int index, JSONObject dataJson, String serialNo, JSONObject invoice) {
        String cache = this.getPageCache().get("serial_no_index");
        JSONObject invoiceSeqCache = StringUtils.isNotEmpty((String)cache) ? JSON.parseObject((String)cache) : new JSONObject();
        String expenseMaxSeqCache = this.getPageCache().get(CACHE_EXPENSE_MAX_SEQ_DATA);
        JSONObject expenseMaxIndex = StringUtils.isNotEmpty((String)expenseMaxSeqCache) ? JSON.parseObject((String)expenseMaxSeqCache) : new JSONObject();
        String expenseNumber = invoice.getString("expenseNum");
        if ("cover".equals(invoice.getString("imageType")) && StringUtils.isNotEmpty((String)expenseNumber)) {
            expenseMaxIndex.remove((Object)expenseNumber);
            invoiceSeqCache.remove((Object)expenseNumber);
            this.getPageCache().put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
        }
        invoiceSeqCache.remove((Object)serialNo);
        this.getPageCache().put("serial_no_index", invoiceSeqCache.toJSONString());
        DynamicObjectCollection collection = this.getModel().getEntryEntity(treeEntryEntity);
        int maxRowIndex = collection.size() - 1;
        int selectRow = index;
        logger.info("\u5207\u5165\u70b9\u7684\u7d22\u5f15\u662f\uff1a[{}]", (Object)selectRow);
        if (selectRow < maxRowIndex) {
            this.getPageCache().put("rescan_begin_index", String.valueOf(selectRow + 1));
            this.getPageCache().put("rescan_end_index", String.valueOf(maxRowIndex));
            logger.info("\u8865\u626b\u63d2\u5165\u8d77\u59cbrowIndex\u662f\uff1a[{}]\uff0c\u7ec8\u6b62rowIndex\u662f\uff1a[{}]", (Object)String.valueOf(selectRow + 1), (Object)maxRowIndex);
        } else {
            int preRowIndex = index - 1;
            if (preRowIndex >= 0) {
                DynamicObject preDynamicObject = (DynamicObject)this.getModel().getEntryEntity(treeEntryEntity).get(preRowIndex);
                String preSerialNo = preDynamicObject.getString("serial_no");
                JSONObject preInvoiceObject = dataJson.getJSONObject(preSerialNo);
                boolean noExpenseNum = true;
                for (int i = index - 1; i >= 0; --i) {
                    DynamicObject invoiceObject = (DynamicObject)this.getModel().getEntryEntity(treeEntryEntity).get(i);
                    String serial_no = invoiceObject.getString("serial_no");
                    JSONObject preInvoice = dataJson.getJSONObject(serial_no);
                    String imageType = preInvoice.getString("imageType");
                    String expenseNum = preInvoice.getString("expenseNum");
                    if (!"cover".equals(imageType) || !StringUtils.isNotEmpty((String)expenseNum)) continue;
                    noExpenseNum = false;
                    String fileIndex = preInvoice.getString("fileIndex");
                    this.getPageCache().put("fileIndex", fileIndex);
                    this.getPageCache().put("collect_expenseNum", expenseNum);
                    expenseMaxIndex.put(expenseNum, (Object)preInvoiceObject.getString("fileIndex"));
                    this.getPageCache().put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
                    break;
                }
                if (noExpenseNum) {
                    String fileIndex = preInvoiceObject.getString("fileIndex");
                    this.getPageCache().put("fileIndex", fileIndex);
                    this.getPageCache().remove("collect_expenseNum");
                }
            } else {
                InvoiceCollectPluginService.setInvoiceSeqCache((String)this.getView().getPageId(), (String)"{}");
                InvoiceCollectPluginService.setInvoiceVerifyCache((String)this.getView().getPageId(), (String)"{}");
                this.getPageCache().remove("fileIndex");
                this.getPageCache().remove("serial_no_index");
                this.getPageCache().remove("collect_expenseNum");
                this.getPageCache().remove(CACHE_EXPENSE_MAX_SEQ_DATA);
            }
        }
        dataJson.remove((Object)serialNo);
        InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)dataJson.toJSONString());
        this.sortExpenseInvoice("delete");
        this.getPageCache().remove("rescan_begin_index");
        this.getPageCache().remove("rescan_end_index");
        this.refreshInvoiceGrid(null);
        if (index > 0) {
            TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(treeEntryEntity);
            entryGrid.focusCell(index - 1, "operationcolumnap");
        }
    }

    private void operateCustomTable() {
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(treeEntryEntity);
        int[] selectRows = grid.getSelectRows();
        if (ArrayUtils.isEmpty((int[])selectRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u8fdb\u884c\u5220\u9664", (String)"InvSignByExpensePlugin_105", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        JSONObject dataJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        if (dataJson == null) {
            return;
        }
        this.batchDeleteRow(selectRows, dataJson);
    }

    private void batchDeleteRow(int[] selectRows, JSONObject dataJson) {
        int i;
        String cache = this.getPageCache().get("serial_no_index");
        JSONObject invoiceSeqCache = StringUtils.isNotEmpty((String)cache) ? JSON.parseObject((String)cache) : new JSONObject();
        String expenseMaxSeqCache = this.getPageCache().get(CACHE_EXPENSE_MAX_SEQ_DATA);
        JSONObject expenseMaxIndex = StringUtils.isNotEmpty((String)expenseMaxSeqCache) ? JSON.parseObject((String)expenseMaxSeqCache) : new JSONObject();
        DynamicObjectCollection collection = this.getModel().getEntryEntity(treeEntryEntity);
        int maxRowIndex = collection.size() - 1;
        int firstRowIndex = selectRows[0];
        logger.info("\u5220\u9664\u7684\u8d77\u59cb\u7d22\u5f15\u662f\uff1a[{}]", (Object)firstRowIndex);
        for (i = firstRowIndex; i < collection.size(); ++i) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(treeEntryEntity, i);
            String serialNo = dynamicObject.getString("serial_no");
            JSONObject invoice = dataJson.getJSONObject(serialNo);
            if (ObjectUtils.isEmpty((Object)invoice)) continue;
            String expenseNumber = invoice.getString("expenseNum");
            if ("cover".equals(invoice.getString("imageType")) && StringUtils.isNotEmpty((String)expenseNumber)) {
                expenseMaxIndex.remove((Object)expenseNumber);
                invoiceSeqCache.remove((Object)expenseNumber);
                this.getPageCache().put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
            }
            invoiceSeqCache.remove((Object)serialNo);
            this.getPageCache().put("serial_no_index", invoiceSeqCache.toJSONString());
        }
        if (collection.size() - firstRowIndex == selectRows.length) {
            int preRowIndex = firstRowIndex - 1;
            if (preRowIndex >= 0) {
                DynamicObject preDynamicObject = (DynamicObject)this.getModel().getEntryEntity(treeEntryEntity).get(preRowIndex);
                String preSerialNo = preDynamicObject.getString("serial_no");
                JSONObject preInvoiceObject = dataJson.getJSONObject(preSerialNo);
                boolean noExpenseNum = true;
                for (int i2 = preRowIndex; i2 >= 0; --i2) {
                    DynamicObject invoiceObject = (DynamicObject)this.getModel().getEntryEntity(treeEntryEntity).get(i2);
                    String serial_no = invoiceObject.getString("serial_no");
                    JSONObject preInvoice = dataJson.getJSONObject(serial_no);
                    String imageType = preInvoice.getString("imageType");
                    String expenseNum = preInvoice.getString("expenseNum");
                    if (!"cover".equals(imageType) || !StringUtils.isNotEmpty((String)expenseNum)) continue;
                    noExpenseNum = false;
                    String fileIndex = preInvoice.getString("fileIndex");
                    this.getPageCache().put("fileIndex", fileIndex);
                    this.getPageCache().put("collect_expenseNum", expenseNum);
                    expenseMaxIndex.put(expenseNum, (Object)preInvoiceObject.getString("fileIndex"));
                    this.getPageCache().put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
                    break;
                }
                if (noExpenseNum) {
                    String fileIndex = preInvoiceObject.getString("fileIndex");
                    this.getPageCache().put("fileIndex", fileIndex);
                    this.getPageCache().remove("collect_expenseNum");
                }
            } else {
                InvoiceCollectPluginService.setInvoiceSeqCache((String)this.getView().getPageId(), (String)"{}");
                InvoiceCollectPluginService.setInvoiceVerifyCache((String)this.getView().getPageId(), (String)"{}");
                this.getPageCache().remove("fileIndex");
                this.getPageCache().remove("serial_no_index");
                this.getPageCache().remove("collect_expenseNum");
                this.getPageCache().remove(CACHE_EXPENSE_MAX_SEQ_DATA);
            }
        } else {
            this.getPageCache().put("rescan_begin_index", String.valueOf(firstRowIndex + 1));
            this.getPageCache().put("rescan_end_index", String.valueOf(maxRowIndex));
            logger.info("\u91cd\u7f6e\u7d22\u5f15\u7684\u8d77\u59cbrowIndex\u662f\uff1a[{}]\uff0c\u7ec8\u6b62rowIndex\u662f\uff1a[{}]", (Object)String.valueOf(firstRowIndex + 1), (Object)maxRowIndex);
        }
        for (i = 0; i < selectRows.length; ++i) {
            int index = selectRows[i];
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(treeEntryEntity, index);
            if (dynamicObject == null) continue;
            String serialNo = dynamicObject.getString("serial_no");
            dataJson.remove((Object)serialNo);
        }
        InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)dataJson.toJSONString());
        this.batchDeleteResetIndex();
        this.getPageCache().remove("rescan_begin_index");
        this.getPageCache().remove("rescan_end_index");
        this.refreshInvoiceGrid(null);
        if (firstRowIndex > 0) {
            TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(treeEntryEntity);
            entryGrid.focusCell(firstRowIndex - 1, "operationcolumnap");
        }
    }

    private void batchDeleteResetIndex() {
        JSONObject invoiceJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        String rescanBeginIndex = this.getPageCache().get("rescan_begin_index");
        String rescanEndIndex = this.getPageCache().get("rescan_end_index");
        if (StringUtils.isNotEmpty((String)rescanBeginIndex) && StringUtils.isNotEmpty((String)rescanEndIndex)) {
            int beginIndex = Integer.parseInt(rescanBeginIndex);
            int endIndex = Integer.parseInt(rescanEndIndex);
            int imagesNum = ObjectUtils.isEmpty((Object)this.getPageCache().get("dealCount")) ? 0 : Integer.parseInt(this.getPageCache().get("dealCount"));
            int count = 0;
            for (int i = beginIndex; i <= endIndex; ++i) {
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(treeEntryEntity).get(i);
                String serialNo = dynamicObject.getString("serial_no");
                JSONObject invoice = invoiceJson.getJSONObject(serialNo);
                if (ObjectUtils.isEmpty((Object)invoice)) continue;
                invoice.remove((Object)"fileIndex");
                invoice.put("tempFileIndex", (Object)(imagesNum + count));
                invoice.put("reorderFlag", (Object)"1");
                logger.info("\u5220\u9664\u4e4b\u540e\u540e\u9762\u884c\u7684\u91cd\u7f6e\u4e34\u65f6\u7d22\u5f15\u662f\uff1a[{}]", (Object)(imagesNum + count));
                ++count;
                invoiceJson.put(serialNo, (Object)invoice);
                logger.info("\u5220\u9664\u4e4b\u540e\u540e\u9762\u884c\u7684\u6d41\u6c34\u53f7\u662f\uff1a[{}]", (Object)serialNo);
            }
            int preRowIndex = beginIndex - 2;
            if (preRowIndex >= 0) {
                DynamicObject preDynamicObject = (DynamicObject)this.getModel().getEntryEntity(treeEntryEntity).get(preRowIndex);
                String preSerialNo = preDynamicObject.getString("serial_no");
                JSONObject preInvoice = invoiceJson.getJSONObject(preSerialNo);
                boolean noExpenseNum = true;
                JSONObject expenseMaxIndex = new JSONObject();
                for (int i = preRowIndex; i >= 0; --i) {
                    DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(treeEntryEntity).get(i);
                    String serialNo = dynamicObject.getString("serial_no");
                    JSONObject invoice = invoiceJson.getJSONObject(serialNo);
                    if (ObjectUtils.isEmpty((Object)invoice)) continue;
                    String imageType = invoice.getString("imageType");
                    String expenseNum = invoice.getString("expenseNum");
                    if (!"cover".equals(imageType) || !StringUtils.isNotEmpty((String)expenseNum)) continue;
                    noExpenseNum = false;
                    String fileIndex = invoice.getString("fileIndex");
                    this.getPageCache().put("fileIndex", fileIndex);
                    this.getPageCache().put("collect_expenseNum", expenseNum);
                    String expenseMaxSeqCache = this.getPageCache().get(CACHE_EXPENSE_MAX_SEQ_DATA);
                    expenseMaxIndex.clear();
                    if (StringUtils.isNotEmpty((String)expenseMaxSeqCache)) {
                        expenseMaxIndex = JSON.parseObject((String)expenseMaxSeqCache);
                    }
                    expenseMaxIndex.put(expenseNum, (Object)preInvoice.getString("fileIndex"));
                    this.getPageCache().put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
                    break;
                }
                if (noExpenseNum) {
                    String fileIndex = preInvoice.getString("fileIndex");
                    this.getPageCache().put("fileIndex", fileIndex);
                    this.getPageCache().remove("collect_expenseNum");
                }
            } else {
                InvoiceCollectPluginService.setInvoiceSeqCache((String)this.getView().getPageId(), (String)"{}");
                InvoiceCollectPluginService.setInvoiceVerifyCache((String)this.getView().getPageId(), (String)"{}");
                this.getPageCache().remove("fileIndex");
                this.getPageCache().remove("serial_no_index");
                this.getPageCache().remove("collect_expenseNum");
                this.getPageCache().remove(CACHE_EXPENSE_MAX_SEQ_DATA);
            }
        }
        HashMap<Integer, String> seqMap = new HashMap<Integer, String>(invoiceJson.entrySet().size());
        for (Map.Entry entry : invoiceJson.entrySet()) {
            JSONObject obj = (JSONObject)entry.getValue();
            if (!StringUtils.isNotEmpty((String)obj.getString("tempFileIndex"))) continue;
            seqMap.put(obj.getInteger("tempFileIndex"), obj.getString("serialNo"));
            logger.info("\u5220\u9664\u4e4b\u540e\u540e\u9762\u884c\u7684\u4e34\u65f6\u5e8f\u53f7\uff1a[{}]\uff0c\u6d41\u6c34\u53f7\uff1a[{}]", (Object)obj.getInteger("tempFileIndex"), (Object)obj.getString("serialNo"));
        }
        Map sortMap = seqMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oleValue, newValue) -> oleValue, LinkedHashMap::new));
        logger.info("\u5220\u9664\u4e4b\u540e\u540e\u9762\u884c\u7684\u4e34\u65f6\u6392\u5e8f\u662f[{}]", (Object)sortMap);
        for (Map.Entry entry : sortMap.entrySet()) {
            String serialNo = (String)entry.getValue();
            JSONObject invoice = invoiceJson.getJSONObject(serialNo);
            String reorderFlag = invoice.getString("reorderFlag");
            if (StringUtils.isNotEmpty((String)reorderFlag)) {
                this.afterReorder(serialNo, invoice);
            } else {
                this.afterScanner(serialNo, invoice);
            }
            JSONObject invoiceVerifyJson = InvoiceCollectPluginService.getInvoiceVerifyCache((String)this.getView().getPageId());
            JSONObject verify = new JSONObject();
            JSONObject invoiceVerify = new JSONObject(4);
            invoiceVerify.put("errorLevel", invoice.get((Object)"errorLevel"));
            invoiceVerify.put("validateMessage", invoice.get((Object)"validateMessage"));
            invoiceVerify.put("verifyResult", invoice.get((Object)"verifyResult"));
            invoiceVerify.put("validateMessage_html", invoice.get((Object)"validateMessage_html"));
            verify.put("invoice", (Object)invoiceVerify);
            JSONObject expenseVerify = new JSONObject(4);
            String expenseNumber = invoice.getString("expenseNum");
            if (StringUtils.isEmpty((String)expenseNumber)) {
                ArrayList<VerifyResultDto> resultList = new ArrayList<VerifyResultDto>(2);
                VerifyResultDto dto = new VerifyResultDto();
                dto.setName(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7f16\u53f7\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvSignByExpensePlugin_88", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                dto.setConfig("0");
                dto.setMsg(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7f16\u53f7\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvSignByExpensePlugin_88", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                resultList.add(dto);
                expenseVerify.put("errorLevel", (Object)"0");
                expenseVerify.put("validateMessage", (Object)VerifyService.getResultMsg(resultList));
                expenseVerify.put("verifyResult", resultList);
                expenseVerify.put("validateMessage_html", (Object)VerifyService.getResultMsgHtml(resultList));
                if ("cover".equals(invoice.getString("imageType"))) {
                    invoice.put("errorLevel", (Object)"0");
                    invoice.put("validateMessage", expenseVerify.get((Object)"validateMessage"));
                    invoice.put("verifyResult", resultList);
                    invoice.put("validateMessage_html", expenseVerify.get((Object)"validateMessage_html"));
                }
            } else {
                expenseVerify.put("errorLevel", (Object)"3");
                if ("cover".equals(invoice.getString("imageType"))) {
                    invoice.put("errorLevel", (Object)"3");
                }
            }
            verify.put("cover", (Object)expenseVerify);
            JSONObject attachVerify = new JSONObject(4);
            String fileName = invoice.getString("fileName");
            if (StringUtils.isEmpty((String)fileName)) {
                ArrayList<VerifyResultDto> resultList = new ArrayList<VerifyResultDto>(2);
                VerifyResultDto dto = new VerifyResultDto();
                dto.setName(ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvSignByExpensePlugin_89", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                dto.setConfig("0");
                dto.setMsg(ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvSignByExpensePlugin_89", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                resultList.add(dto);
                attachVerify.put("errorLevel", (Object)"0");
                attachVerify.put("validateMessage", (Object)VerifyService.getResultMsg(resultList));
                attachVerify.put("verifyResult", resultList);
                attachVerify.put("validateMessage_html", (Object)VerifyService.getResultMsgHtml(resultList));
                if ("attachment".equals(invoice.getString("imageType"))) {
                    invoice.put("errorLevel", (Object)"0");
                    invoice.put("validateMessage", attachVerify.get((Object)"validateMessage"));
                    invoice.put("verifyResult", resultList);
                    invoice.put("validateMessage_html", attachVerify.get((Object)"validateMessage_html"));
                }
            } else {
                attachVerify.put("errorLevel", (Object)"3");
                if ("attachment".equals(invoice.getString("imageType"))) {
                    invoice.put("errorLevel", (Object)"3");
                }
            }
            verify.put("attachment", (Object)attachVerify);
            invoiceVerifyJson.put(invoice.getString("serialNo"), (Object)verify);
            InvoiceCollectPluginService.setInvoiceVerifyCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)invoiceVerifyJson));
            invoice.remove((Object)"reorderFlag");
            invoiceJson.put(invoice.getString("serialNo"), (Object)invoice);
        }
        InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)invoiceJson));
    }

    private void extracted(String serialNo) {
        boolean delResult = this.invoiceCollectService.delInvoice(serialNo);
        if (!delResult) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25!", (String)"InvSignByExpensePlugin_106", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    public void beforeUpload(BeforeUploadEvent evt) {
        if (!this.checkPermission(RimPermItemEnum.RIM_PC_UPLOAD, "btn_upload")) {
            return;
        }
        this.progressBarVisible(Boolean.TRUE, null);
    }

    private Map<String, Object> getCustomParam() {
        JSONObject json;
        if (this.getView().getPageCache().get("customParam") != null) {
            json = JSON.parseObject((String)this.getView().getPageCache().get("customParam"));
        } else {
            Map customParams;
            Long orgId = RequestContext.get().getOrgId();
            Map companyInfo = TenantUtils.getCompanyNameAndTaxNoByOrgId((Long)orgId);
            json = new JSONObject();
            json.put("resourcePlugin", (Object)"sign_by_expense");
            json.put("orgId", (Object)orgId);
            if (companyInfo != null && !companyInfo.isEmpty()) {
                ArrayList taxList = new ArrayList(1);
                ArrayList nameList = new ArrayList(1);
                taxList.add(companyInfo.get("taxNo"));
                nameList.add(companyInfo.get("name"));
                json.put("buyer_tax_no", taxList);
                json.put("buyer_name", nameList);
            }
            if ((customParams = this.getView().getFormShowParameter().getCustomParams()) != null) {
                String billType = (String)customParams.get("billType");
                if (StringUtils.isEmpty((String)billType)) {
                    billType = "adqs";
                }
                json.put("billType", (Object)billType);
            }
            this.getView().getPageCache().put("customParam", json.toJSONString());
        }
        logger.info("\u53d1\u7968\u7b7e\u6536\u6821\u9a8c\u53c2\u6570\uff1a" + json);
        return json;
    }

    public void afterUpload(UploadEvent evt) {
        if (!this.checkPermission(RimPermItemEnum.RIM_PC_UPLOAD, "btn_upload")) {
            String caption = this.getView().getFormShowParameter().getCaption();
            if (StringUtils.isEmpty((String)caption)) {
                caption = ResManager.loadKDString((String)"\u6309\u5355\u7b7e\u6536", (String)"InvSignByExpensePlugin_107", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InvSignByExpensePlugin_81", (String)"imc-rim-formplugin", (Object[])new Object[0]), caption, RimPermItemEnum.RIM_PC_UPLOAD.getDescription()));
        }
        this.deleteUploadCountCache();
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            StringJoiner taskUrls = new StringJoiner(",");
            ArrayList fileUrls = new ArrayList(urls.length);
            int size = urls.length;
            for (int i = 0; i < size; ++i) {
                String url = urls[i].toString();
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put("url", url);
                fileUrls.add(map);
                taskUrls.add(url);
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_upload"});
            this.getPageCache().put("taskUrls", taskUrls.toString());
            this.progressBarVisible(Boolean.TRUE, new String[]{ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d...", (String)"InvSignByExpensePlugin_108", (String)"imc-rim-formplugin", (Object[])new Object[0])});
            this.getPageCache().put("startprogress", "true");
            JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_UPLOAD.getCode());
            InvoiceCollectTask collectTask = new InvoiceCollectTask(RequestContext.get(), this.getView().getPageId(), fileUrls, businessParam);
            ThreadPools.executeOnce((String)"SignCollectorProgressPool", (Runnable)collectTask);
        }
    }

    public boolean checkPermission(RimPermItemEnum permItemEnum, String metadataId) {
        String entityId = PermissionUtils.getEntityIdByView((IFormView)this.getView());
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        String appId = mainEntityType.getAppId();
        boolean havePermission = true;
        RequestContext requestContext = RequestContext.get();
        if (PermissionServiceHelper.checkPermission((Long)Long.parseLong(requestContext.getUserId()), (Long)requestContext.getOrgId(), (String)appId, (String)entityId, (String)permItemEnum.getPermId()) != 1) {
            havePermission = false;
        }
        return havePermission;
    }

    private JSONObject getBusinessParam(String collectType) {
        JSONObject businessParam = new JSONObject();
        if (this.getView().getPageCache().get("businessParam") != null) {
            businessParam = JSON.parseObject((String)this.getView().getPageCache().get("businessParam"));
        } else {
            Object paramValue;
            long orgId;
            boolean isAutoSign;
            RequestContext request = RequestContext.get();
            businessParam.put("collect_type", (Object)collectType);
            businessParam.put("resource", (Object)"\u6536\u7968\u7ba1\u7406");
            businessParam.put("isAdmin", (Object)PermissionUtils.checkPermission((String)request.getUserId(), (Long)request.getOrgId(), (IFormView)this.getView(), (String)"1PAFGP5MO1NU"));
            String state = RimConfigUtils.getConfig((String)"original_state");
            if ("1".equals(state)) {
                businessParam.put("originalState", (Object)"1");
            }
            if ((isAutoSign = SysParamUtil.getSysParamByOrgId((Long)(orgId = RequestContext.get().getOrgId()), (String)"is_autosign")) && (paramValue = SysParamUtil.getParamValue((Long)orgId, (String)"autosign_config")) != null) {
                String[] valueStr = paramValue.toString().split(",");
                if (!Arrays.asList(valueStr).contains("2")) {
                    businessParam.remove((Object)"originalState");
                } else {
                    businessParam.put("originalState", (Object)"1");
                }
            }
            businessParam.put("resourcePlugin", (Object)"sign_by_expense");
            businessParam.put("billType", (Object)"adqs");
            this.getView().getPageCache().put("businessParam", businessParam.toJSONString());
        }
        logger.info("\u53d1\u7968\u7b7e\u6536\u91c7\u96c6\u53c2\u6570:" + businessParam);
        return businessParam;
    }

    private FormShowParameter newPage(String formId, Map<String, Object> customParams, String callBackId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setShowTitle(true);
        showParameter.setCustomParams(customParams);
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isNotEmpty((String)callBackId)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, callBackId);
            showParameter.setCloseCallBack(closeCallBack);
        }
        return showParameter;
    }

    public void customEvent(CustomEventArgs e) {
        String eventArgs = e.getEventArgs();
        if ("scanner_fail".equals(e.getEventName())) {
            if (ScannerService.scannerFail((AbstractFormPlugin)this, (String)eventArgs)) {
                this.scannerProcess("uploadFinish");
            }
        } else if ("scanner_uploadFinish".equals(e.getEventName())) {
            logger.info("\u626b\u63cf\u4eea\u4e0a\u4f20\u6210\u529f\uff1a" + eventArgs);
            if (!ScannerService.uploadFinish((String)eventArgs)) {
                JSONObject json = JSON.parseObject((String)eventArgs);
                JSONObject data = json.getJSONObject("data");
                String imagesNum = data.getString("imagesNum");
                this.getPageCache().put("imagesNum", imagesNum);
                this.scannerProcess("uploadFinish");
            }
        } else if ("scanner_success".equals(e.getEventName())) {
            logger.info("\u626b\u63cf\u4eea\uff1a" + eventArgs);
            JSONObject json = JSON.parseObject((String)eventArgs);
            JSONObject data = json.getJSONObject("data");
            String url = data.getString("url");
            String name = data.getString("name");
            int index = data.getIntValue("index");
            JSONObject invoiceSeqCache = InvoiceCollectPluginService.getInvoiceSeqCache((String)this.getView().getPageId());
            invoiceSeqCache.put(name, (Object)index);
            InvoiceCollectPluginService.setInvoiceSeqCache((String)this.getView().getPageId(), (String)invoiceSeqCache.toJSONString());
            JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_SCANNER.getCode());
            ScannerService.recognitionInvoice((String)"collect", (String)this.getView().getPageId(), (String)url, (String)name, (JSONObject)businessParam, null);
        } else if ("dialog".equals(e.getEventName())) {
            this.process(eventArgs);
        } else if ("show_verify_html".equals(e.getEventName()) && StringUtils.isNotEmpty((String)eventArgs)) {
            int index = Integer.parseInt(eventArgs);
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(treeEntryEntity, index);
            if (ObjectUtils.isEmpty((Object)dynamicObject)) {
                return;
            }
            String serialNo = dynamicObject.getString("serial_no");
            logger.info("\u5408\u89c4\u6027\u6821\u9a8c\u63d0\u793a\u7d22\u5f15\uff1a[{}]\u7684\u4e34\u65f6\u7d22\u5f15\u662f\uff1a[{}]", (Object)serialNo, (Object)index);
            JSONObject invoiceJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
            JSONObject invoice = invoiceJson.getJSONObject(serialNo);
            logger.info("\u7f13\u5b58\u7684\u53d1\u7968\u4fe1\u606f\uff1a[{}]", (Object)invoice);
            String resultHtml = invoice.getString("validateMessage_html");
            if (StringUtils.isEmpty((String)resultHtml)) {
                return;
            }
            int blackListTxt = 0;
            List resultList = JSON.parseArray((String)JSON.toJSONString((Object)invoice.get((Object)"verifyResult")), VerifyResultDto.class);
            if (!CollectionUtils.isEmpty((Collection)resultList)) {
                for (VerifyResultDto verifyResultDto : resultList) {
                    String msg = verifyResultDto.getMsg();
                    DecimalFormat decimalFormat = new DecimalFormat("0.00");
                    String divide = decimalFormat.format((float)msg.length() / 21.0f);
                    double count = Double.parseDouble(divide);
                    count = Math.floor(count);
                    blackListTxt += (int)count;
                }
            }
            HashMap<String, Object> customParams = new HashMap<String, Object>(1);
            customParams.put("validateMessage_html", resultHtml);
            customParams.put("verifyResult", invoice.get((Object)"verifyResult"));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setShowTitle(false);
            showParameter.setCustomParams(customParams);
            showParameter.setFormId("rim_inv_verify_info");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            StyleCss style = new StyleCss();
            style.setWidth("300");
            int div = resultHtml.length() - resultHtml.replaceAll("<div", "").length();
            int img = resultHtml.length() - resultHtml.replaceAll("<img", "").length();
            int p = resultHtml.length() - resultHtml.replaceAll("</p>", "").length();
            int length = div / 4 * 15 + img / 4 * 22 + p / 4 * 15 + blackListTxt * 5;
            style.setHeight(length + "");
            showParameter.getOpenStyle().setInlineStyleCss(style);
            this.getView().showForm(showParameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scannerProcess(String type) {
        String pageId = this.getView().getPageId();
        try (DLock lock = DLock.create((String)("scannerProcess" + pageId), (String)ResManager.loadKDString((String)"\u5237\u65b0\u5361\u7247\u9501", (String)"InvSignByExpensePlugin_109", (String)"imc-rim-formplugin", (Object[])new Object[0]));){
            int times = 0;
            String dialogId = "scanner";
            while (times < 30) {
                ++times;
                if (!lock.tryLock(500L)) continue;
                times = 100;
                JSONObject result = RecognitionCheckTask.queryCacheFile((String)pageId);
                try {
                    boolean noWaiting;
                    CustomControl customcontrol = (CustomControl)this.getControl("progressBar_customcontrol");
                    DialogService service = new DialogService(customcontrol);
                    Set urlSet = result.keySet();
                    Iterator it = urlSet.iterator();
                    int waiting = 0;
                    int fail = 0;
                    boolean dealCount = false;
                    logger.info("\u626b\u63cf\u6587\u4ef6\u603b\u6570\u91cf\uff1a[{}]", (Object)urlSet.size());
                    while (it.hasNext()) {
                        String url = (String)it.next();
                        String status = result.getString(url);
                        if ("waiting".equals(status)) {
                            ++waiting;
                            continue;
                        }
                        if ("success".equals(status)) {
                            JSONArray invoiceArray = RecognitionCheckTask.queryCacheFileResult((String)url);
                            if (invoiceArray.isEmpty()) continue;
                            RecognitionCheckTask.saveCacheFileResult((String)url, null);
                            JSONObject scannerSerialNo = new JSONObject();
                            int invoiceSize = invoiceArray.size();
                            for (int invoiceIndex = 0; invoiceIndex < invoiceSize; ++invoiceIndex) {
                                JSONObject invoice = invoiceArray.getJSONObject(invoiceIndex);
                                logger.info("\u626b\u63cf\u4eea\u8bc6\u522b\u9884\u89c8\u53d1\u7968\uff1a" + invoice);
                                String fileName = invoice.getString("fileName");
                                JSONObject invoiceSeqCache = InvoiceCollectPluginService.getInvoiceSeqCache((String)this.getView().getPageId());
                                logger.info("[{}]\u626b\u63cf\u4eea\u4e4b\u540e\u7f13\u5b58\u7684\u4e34\u65f6\u7d22\u5f15\u662f\uff1a[{}]", (Object)fileName, (Object)invoiceSeqCache);
                                int scanIndex = invoiceSeqCache.getIntValue(fileName);
                                invoice.put("tempFileIndex", (Object)scanIndex);
                                String serialNo = invoice.getString("serialNo");
                                if (StringUtils.isEmpty((String)serialNo)) {
                                    serialNo = UUID.randomUUIDZero();
                                    invoice.put("serialNo", (Object)serialNo);
                                }
                                this.refreshInvoiceData(invoice);
                                String scannerSerialNoCache = this.getPageCache().get("scanner_serialNo");
                                scannerSerialNo.clear();
                                if (StringUtils.isNotEmpty((String)scannerSerialNoCache)) {
                                    scannerSerialNo = JSON.parseObject((String)scannerSerialNoCache);
                                }
                                if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoice.getLong("invoiceType"))) {
                                    JSONArray barcodeArray = invoice.getJSONArray("barcode");
                                    if (!CollectionUtils.isEmpty((Collection)barcodeArray) && StringUtils.isNotEmpty((String)(barcodeArray.get(0) + ""))) {
                                        scannerSerialNo.put(barcodeArray.get(0) + "", (Object)serialNo);
                                    } else {
                                        scannerSerialNo.put(serialNo, (Object)serialNo);
                                    }
                                } else {
                                    scannerSerialNo.put(serialNo, (Object)serialNo);
                                }
                                this.getPageCache().put("scanner_serialNo", scannerSerialNo.toJSONString());
                                int count = ObjectUtils.isEmpty((Object)this.getPageCache().get("dealCount")) ? 1 : Integer.parseInt(this.getPageCache().get("dealCount")) + 1;
                                this.getPageCache().put("dealCount", String.valueOf(count));
                            }
                            logger.info("\u5904\u7406\u5230\u76ee\u524d\u4e3a\u6b62\u53d1\u7968\u6570\u91cf\uff1a[{}]\uff0c \u626b\u63cf\u6587\u4ef6\u7684\u6570\u91cf\uff1a[{}]", (Object)this.getPageCache().get("dealCount"), (Object)this.getPageCache().get("imagesNum"));
                            continue;
                        }
                        if (!"fail".equals(status)) continue;
                        ++fail;
                    }
                    int total = result.size();
                    String handleCount = this.getPageCache().get("dealCount");
                    logger.info("\u5904\u7406\u6570\u91cf\uff1a[{}]\uff0c\u5269\u4f59\u626b\u63cf\u4ef6\u6570\u91cf\uff1a[{}]", (Object)handleCount, (Object)urlSet.size());
                    int imagesNum = StringUtils.isNotEmpty((String)this.getPageCache().get("imagesNum")) ? Integer.parseInt(this.getPageCache().get("imagesNum")) : -1;
                    boolean isDialog = "dialog".equals(type);
                    boolean isTotal = total == imagesNum;
                    boolean bl = noWaiting = waiting == 0;
                    if (noWaiting && isDialog && isTotal) {
                        JSONObject invoiceJson;
                        if (BigDecimalUtil.transDecimal((Object)handleCount).intValue() > imagesNum) {
                            logger.info("\u5904\u7406\u6df7\u8d34\u53d1\u7968");
                            invoiceJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
                            HashMap<String, Integer> seqMap = new HashMap<String, Integer>(invoiceJson.entrySet().size());
                            for (Map.Entry entry : invoiceJson.entrySet()) {
                                JSONObject obj = (JSONObject)entry.getValue();
                                if (!StringUtils.isNotEmpty((String)obj.getString("tempFileIndex"))) continue;
                                seqMap.put(obj.getString("serialNo"), obj.getInteger("tempFileIndex"));
                                logger.info("\u626b\u63cf\u4eea\u8bc6\u522b\u6df7\u8d34\u53d1\u7968\u6d41\u6c34\u53f7\uff1a[{}]\uff0c\u4e34\u65f6\u5e8f\u53f7\uff1a[{}]", (Object)obj.getString("serialNo"), (Object)obj.getInteger("tempFileIndex"));
                            }
                            Map sortMap = seqMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oleValue, newValue) -> oleValue, LinkedHashMap::new));
                            logger.info("\u626b\u63cf\u4eea\u8bc6\u522b\u6df7\u8d34\u53d1\u7968\u7684\u4e34\u65f6\u6392\u5e8f\u662f[{}]", (Object)sortMap);
                            Iterator<Object> iter = sortMap.entrySet().iterator();
                            int tempFileIndex = 0;
                            while (iter.hasNext()) {
                                Map.Entry entry = (Map.Entry)iter.next();
                                String serialNo = (String)entry.getKey();
                                JSONObject invoice = invoiceJson.getJSONObject(serialNo);
                                invoice.put("tempFileIndex", (Object)tempFileIndex);
                                ++tempFileIndex;
                                invoiceJson.put(serialNo, (Object)invoice);
                            }
                            InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)invoiceJson));
                        }
                        this.sortExpenseInvoice("scanner");
                        this.getPageCache().remove("dealCount");
                        this.getPageCache().remove("imagesNum");
                        this.getPageCache().remove("rescan_begin_index");
                        this.getPageCache().remove("rescan_end_index");
                        this.getPageCache().remove("scanner_serialNo");
                        invoiceJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
                        String expenseNum = "";
                        ArrayList<String> delSerialNos = new ArrayList<String>(1);
                        for (Map.Entry entry : invoiceJson.entrySet()) {
                            JSONArray barcodeArray;
                            JSONObject invoice = (JSONObject)entry.getValue();
                            if (!InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoice.getLong("invoiceType")) || CollectionUtils.isEmpty((Collection)(barcodeArray = invoice.getJSONArray("barcode"))) || !StringUtils.isNotEmpty((String)(barcodeArray.get(0) + ""))) continue;
                            String barcode = barcodeArray.get(0) + "";
                            if (expenseNum.equals(barcode)) {
                                delSerialNos.add(invoice.getString("serialNo"));
                            }
                            expenseNum = barcode;
                        }
                        logger.info("\u9700\u8981\u5220\u9664\u7684\u6d41\u6c34\u53f7\u96c6\u5408\uff1a[{}]", delSerialNos);
                        for (String serialNo : delSerialNos) {
                            invoiceJson.remove((Object)serialNo);
                        }
                        InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)SerializationUtils.toJsonString((Object)invoiceJson));
                        this.refreshInvoiceGrid("recognition_check");
                        InvoiceCollectPluginService.setInvoiceSeqCache((String)this.getView().getPageId(), (String)"{}");
                    }
                    if ("dialog".equals(type) && (total == 0 || waiting == 0)) {
                        logger.info("scannerProcess2:" + total + type + waiting + result);
                        if (total > 0) {
                            RecognitionCheckTask.clearCacheFile((String)pageId);
                        }
                        if (fail > 0) {
                            Set urlSet2 = result.keySet();
                            Iterator it2 = urlSet2.iterator();
                            JSONArray retryArray = new JSONArray();
                            while (it2.hasNext()) {
                                String url = (String)it2.next();
                                String status = result.getString(url);
                                if (!"fail".equals(status)) continue;
                                JSONObject retry = new JSONObject();
                                retry.put("fileUrl", (Object)url);
                                retry.put("fileName", (Object)url.substring(url.lastIndexOf(47) + 1, url.length()));
                                retry.put("failDescription", (Object)ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"InvSignByExpensePlugin_110", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                                retryArray.add((Object)retry);
                            }
                            if (!retryArray.isEmpty()) {
                                HashMap<String, Object> customParams = new HashMap<String, Object>(4);
                                customParams.put("retryArray", retryArray);
                                JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_SCANNER.getCode());
                                customParams.put("businessParam", businessParam);
                                FormShowParameter showParameter = this.newPage("rim_inv_recognition_retry", customParams, "retryCallback");
                                showParameter.setCaption(ResManager.loadKDString((String)"\u8bc6\u522b\u5931\u8d25\u91cd\u8bd5\u5217\u8868", (String)"InvSignByExpensePlugin_111", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                                this.getView().showForm(showParameter);
                            }
                        }
                        if (total > 0 && fail > 0) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0a\u4f20%1$s\u4e2a\u6587\u4ef6\uff0c\u5904\u7406\u5931\u8d25%2$s\u4e2a", (String)"InvSignByExpensePlugin_82", (String)"imc-rim-formplugin", (Object[])new Object[0]), total, fail), Integer.valueOf(15000));
                        } else if (total > 0 && !this.showUploadCount()) {
                            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u4e0a\u4f20%1$s\u4e2a\u6587\u4ef6\uff0c\u5904\u7406\u6210\u529f%2$s\u4e2a", (String)"InvSignByExpensePlugin_83", (String)"imc-rim-formplugin", (Object[])new Object[0]), total, total, 30000));
                        }
                        service.hide();
                        continue;
                    }
                    String[] content = new String[]{String.format(ResManager.loadKDString((String)"\u5f85\u5904\u7406\u6587\u4ef6\u5269\u4f59%1$s\u4e2a", (String)"InvSignByExpensePlugin_84", (String)"imc-rim-formplugin", (Object[])new Object[0]), waiting), String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u4e2d(%1$s/%2$s)", (String)"InvSignByExpensePlugin_85", (String)"imc-rim-formplugin", (Object[])new Object[0]), total - waiting, total)};
                    service.show(dialogId, content, 1000);
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    private void progressBarVisible(Boolean visibleFlag, String[] descriptionArray) {
        CustomControl customcontrol = (CustomControl)this.getControl("progressBar_customcontrol");
        DialogService service = new DialogService(customcontrol);
        if (visibleFlag.booleanValue()) {
            if (null != descriptionArray) {
                service.show("1", descriptionArray, 500);
            } else {
                service.show("1", new String[]{ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d...", (String)"InvSignByExpensePlugin_108", (String)"imc-rim-formplugin", (Object[])new Object[0])}, 500);
            }
        } else {
            service.hide();
        }
    }

    private void process(String eventArgs) {
        if (eventArgs != null && eventArgs.indexOf("scanner") >= 0) {
            this.scannerProcess("dialog");
            return;
        }
        String startProgress = this.getPageCache().get("startprogress");
        if (StringUtils.isBlank((String)startProgress)) {
            this.progressBarVisible(Boolean.FALSE, null);
            return;
        }
        int progress = 0;
        String cacheProgress = this.getPageCache().get("progress");
        RecognitionProgress recognitionProgress = null;
        if (StringUtils.isNotEmpty((String)cacheProgress)) {
            logger.info("\u8fdb\u5ea6\u7ed3\u679c\uff1a" + cacheProgress);
            try {
                recognitionProgress = (RecognitionProgress)JSON.parseObject((String)cacheProgress, RecognitionProgress.class);
            }
            catch (Exception e1) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u8f6c\u6362\u5bf9\u8c61\u5f02\u5e38", (String)"InvSignByExpensePlugin_86", (String)"imc-rim-formplugin", (Object[])new Object[0]), cacheProgress));
            }
        }
        if (recognitionProgress != null) {
            progress = recognitionProgress.getProgress();
            String handleUrl = recognitionProgress.getHandleUrl();
            int handleUrlIndex = recognitionProgress.getHandleUrlIndex();
            int handleUrlSize = recognitionProgress.getHandleUrlSize();
            handleUrlSize = handleUrlSize == 0 ? 1 : handleUrlSize;
            int unHandleSize = recognitionProgress.getUnHandleSize();
            int handleSize = recognitionProgress.getHandleSize();
            if (StringUtils.isNotEmpty((String)handleUrl)) {
                String[] descriptionArray = new String[]{String.format(ResManager.loadKDString((String)"\u5f85\u5904\u7406\u6587\u4ef6\u5269\u4f59%1$s\u4e2a", (String)"InvSignByExpensePlugin_84", (String)"imc-rim-formplugin", (Object[])new Object[0]), unHandleSize), String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u4e2d(%1$s/%2$s)", (String)"InvSignByExpensePlugin_85", (String)"imc-rim-formplugin", (Object[])new Object[0]), handleSize - unHandleSize, handleSize)};
                this.progressBarVisible(Boolean.TRUE, descriptionArray);
            }
        }
        String taskUrls = this.getPageCache().get("taskUrls");
        if (progress >= 100 && StringUtils.isEmpty((String)taskUrls)) {
            if (null != recognitionProgress && null != recognitionProgress.getRecognitionProgressErrors() && recognitionProgress.getRecognitionProgressErrors().size() > 0) {
                List recognitionProgressErrors = recognitionProgress.getRecognitionProgressErrors();
                recognitionProgress.setRecognitionProgressErrors(null);
                this.getPageCache().put("progress", JSONObject.toJSONString((Object)recognitionProgress));
                JSONArray retryArray = new JSONArray();
                for (RecognitionProgressError error : recognitionProgressErrors) {
                    String errUrl = error.getUrl();
                    String fileName = errUrl.substring(errUrl.lastIndexOf(47) + 1, errUrl.length());
                    if (FileUtils.isExcel((String)fileName)) {
                        if (!StringUtils.isEmpty((String)error.getDescription())) {
                            this.getView().showErrorNotification(error.getDescription());
                        }
                        if (StringUtils.isEmpty((String)error.getTipDescription())) continue;
                        this.getView().showTipNotification(error.getTipDescription());
                        continue;
                    }
                    JSONObject retry = new JSONObject();
                    retry.put("fileUrl", (Object)errUrl);
                    retry.put("fileName", (Object)errUrl.substring(errUrl.lastIndexOf(47) + 1, errUrl.length()));
                    retry.put("failDescription", (Object)error.getDescription());
                    retryArray.add((Object)retry);
                }
                JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_UPLOAD.getCode());
                HashMap<String, Object> customParams = new HashMap<String, Object>(4);
                customParams.put("retryArray", retryArray);
                customParams.put("businessParam", businessParam);
                FormShowParameter showParameter = this.newPage("rim_inv_recognition_retry", customParams, "retryCallback");
                showParameter.setCaption(ResManager.loadKDString((String)"\u8bc6\u522b\u5931\u8d25\u91cd\u8bd5\u5217\u8868", (String)"InvSignByExpensePlugin_111", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                if (!CollectionUtils.isEmpty((Collection)retryArray)) {
                    this.getView().showForm(showParameter);
                }
            }
            logger.info("\u53f0\u8d26\u53d1\u7968\u91c7\u96c6:\u8bc6\u522b\u67e5\u9a8c\u7ed3\u679c\u5904\u7406\u5b8c\u6bd5\uff1a" + JSONObject.toJSONString((Object)recognitionProgress));
            this.getPageCache().remove("progress");
            this.getPageCache().remove("taskUrls");
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_upload"});
            this.showUploadCount();
            this.progressBarVisible(Boolean.FALSE, null);
            String failedInvoiceStr = this.getPageCache().get("failed_invoice");
            if (StringUtils.isNotEmpty((String)failedInvoiceStr)) {
                FormShowParameter failedListForm = new FormShowParameter();
                failedListForm.setFormId("rim_inv_import_fail");
                failedListForm.setCustomParam("invoiceFailedList", (Object)failedInvoiceStr);
                failedListForm.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(failedListForm);
                this.getPageCache().remove("failed_invoice");
            }
        }
        if (StringUtils.isNotEmpty((String)taskUrls)) {
            for (String url : taskUrls.split(",")) {
                String resultFile = this.getPageCache().get("exportResult_" + url);
                if (StringUtils.isNotEmpty((String)resultFile)) {
                    this.getView().openUrl(resultFile);
                    this.getView().getPageCache().remove("exportResult_" + url);
                }
                String fileName = url.substring(url.lastIndexOf(47) + 1, url.length());
                String taskResultSize = this.getPageCache().get("task_" + url);
                if (!StringUtils.isNotEmpty((String)taskResultSize)) continue;
                int consumeSize = Integer.parseInt(taskResultSize);
                int taskIndex = 1;
                String taskHandleIndex = this.getPageCache().get("task_handle_" + url);
                if (StringUtils.isNotEmpty((String)taskHandleIndex)) {
                    taskIndex = Integer.parseInt(taskHandleIndex);
                }
                JSONArray invoiceArray = new JSONArray();
                String taskResult = this.getPageCache().get("task_" + url + "_" + taskIndex);
                String failedResult = this.getPageCache().get("failed_task_" + url + "_" + taskIndex);
                logger.info(taskResultSize + "\u53f0\u8d26\u53d1\u7968\u91c7\u96c6:" + fileName + "\u7b2c" + taskIndex + "\u9875\u8bc6\u522b\u67e5\u9a8c\u5904\u7406\u4e2d:" + taskResult);
                if (StringUtils.isNotEmpty((String)taskResult)) {
                    invoiceArray = JSON.parseArray((String)taskResult);
                    logger.info(taskResultSize + "\u53f0\u8d26\u53d1\u7968\u91c7\u96c6:" + fileName + "\u7b2c" + taskIndex + "\u9875\u8bc6\u522b\u67e5\u9a8c\u7ed3\u679c\u5904\u7406\u5f00\u59cb\uff1a" + invoiceArray);
                    this.getPageCache().remove("task_" + url + "_" + taskIndex);
                    this.getPageCache().put("task_handle_" + url, taskIndex + 1 + "");
                }
                if (StringUtils.isNotEmpty((String)failedResult)) {
                    JSONArray invoiceFailedResultArray = JSONArray.parseArray((String)failedResult);
                    String cachedFailedInvoice = this.getPageCache().get("failed_invoice");
                    if (StringUtils.isNotEmpty((String)cachedFailedInvoice)) {
                        JSONArray cachedFailedInvoiceArray = JSONArray.parseArray((String)cachedFailedInvoice);
                        invoiceFailedResultArray.addAll((Collection)cachedFailedInvoiceArray);
                    }
                    this.getPageCache().put("failed_invoice", invoiceFailedResultArray.toJSONString());
                }
                if (!CollectionUtils.isEmpty((Collection)invoiceArray)) {
                    int invoiceSize = invoiceArray.size();
                    for (int invoiceIndex = 0; invoiceIndex < invoiceSize; ++invoiceIndex) {
                        JSONObject invoice = invoiceArray.getJSONObject(invoiceIndex);
                        invoice.put("invoiceMessage", (Object)invoice.getString("invoice_info"));
                        logger.info("\u53d1\u7968\u7d22\u5f15\u662f[{}]", (Object)invoice.getString("fileIndex"));
                        this.recountFileIndex(invoiceIndex, invoice);
                        this.refreshInvoiceDate(invoice);
                    }
                    this.refreshInvoiceGrid("recognition_check");
                    logger.info(taskResultSize + "\u53f0\u8d26\u53d1\u7968\u91c7\u96c6:" + fileName + "\u7b2c" + taskIndex + "\u9875\u8bc6\u522b\u67e5\u9a8c\u7ed3\u679c\u5904\u7406\u5b8c\u6bd5:" + invoiceArray);
                }
                if (consumeSize != 0 && taskIndex <= consumeSize) continue;
                this.getPageCache().remove("task_" + url);
                this.getPageCache().remove("task_handle_" + url);
                if (taskUrls.indexOf(44) != -1) {
                    int sort = taskUrls.indexOf(44) + 1;
                    taskUrls = taskUrls.substring(sort);
                    this.getPageCache().put("taskUrls", taskUrls);
                    continue;
                }
                this.getPageCache().remove("taskUrls");
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_upload"});
            }
        }
    }

    private boolean showUploadCount() {
        String cover = this.getPageCache().get(UPLOAD_COVER_COUNT);
        String invoice = this.getPageCache().get(UPLOAD_INVOICE_COUNT);
        String attachment = this.getPageCache().get(UPLOAD_ATTACHMENT_COUNT);
        cover = Optional.ofNullable(cover).orElse("0");
        invoice = Optional.ofNullable(invoice).orElse("0");
        attachment = Optional.ofNullable(attachment).orElse("0");
        if (!("0".equals(cover) && "0".equals(invoice) && "0".equals(attachment))) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u8bc6\u522b\u67e5\u9a8c\u5b8c\u6210\uff0c\u5c01\u9762%1$s\u4efd\uff0c\u53d1\u7968%2$s\u4efd\uff0c\u9644\u4ef6%3$s\u4efd\u3002", (String)"InvSignByExpensePlugin_87", (String)"imc-rim-formplugin", (Object[])new Object[0]), cover, invoice, attachment), Integer.valueOf(30000));
            this.deleteUploadCountCache();
            return true;
        }
        return false;
    }

    private void deleteUploadCountCache() {
        this.getPageCache().remove(UPLOAD_INVOICE_COUNT);
        this.getPageCache().remove(UPLOAD_COVER_COUNT);
        this.getPageCache().remove(UPLOAD_ATTACHMENT_COUNT);
    }

    private void recountFileIndex(int invoiceIndex, JSONObject invoice) {
        logger.info("\u5f53\u524d\u53d1\u7968\u5728\u626b\u63cf\u4ef6\u4e2d\u7684\u7d22\u5f15\u662f\uff1a[{}]", (Object)invoiceIndex);
        this.recountFileIndex(this.getView().getPageId(), this.getCustomParam(), invoiceIndex, invoice);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("scanner".equals(operateKey)) {
            this.deleteUploadCountCache();
            this.getPageCache().remove("invoice_rescan");
            CustomControl scannerControl = (CustomControl)this.getControl(customScanner);
            ScannerService.scanner((CustomControl)scannerControl, (String)this.getView().getPageId(), (String)"invoice");
        } else if (Arrays.asList("select_edit", "select_view").contains(operateKey)) {
            int index = this.getModel().getEntryCurrentRowIndex(treeEntryEntity);
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(treeEntryEntity, index);
            if (ObjectUtils.isEmpty((Object)dynamicObject)) {
                return;
            }
            String serialNo = dynamicObject.getString("serial_no");
            String imageType = dynamicObject.getString("image_type");
            if ("batch".equals(imageType)) {
                this.showExpenseEdit(serialNo);
            } else if ("cover".equals(imageType)) {
                this.showExpenseEdit(serialNo);
            } else if ("invoice".equals(imageType)) {
                this.showInvoiceEdit(serialNo);
            } else {
                this.showAttachEdit(serialNo);
            }
        } else if ("delete_row".equals(operateKey)) {
            this.deleteRow();
        } else if ("invoice_sign_list".equals(operateKey)) {
            this.signInvoiceList(true);
        } else if ("compel_sign".equals(operateKey)) {
            this.signInvoiceList(false);
        } else if ("invoice_rescan".equals(operateKey)) {
            TreeEntryGrid entryGrid = (TreeEntryGrid)this.getView().getControl(treeEntryEntity);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u8865\u626b\u4ef6\u63d2\u5165\u7684\u4e00\u4e2a\u4f4d\u7f6e!", (String)"InvSignByExpensePlugin_112", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            DynamicObjectCollection collection = this.getModel().getEntryEntity(treeEntryEntity);
            int maxRowIndex = collection.size() - 1;
            int selectRow = selectRows[0];
            logger.info("\u5207\u5165\u70b9\u7684\u7d22\u5f15\u662f\uff1a[{}]", (Object)selectRow);
            if (selectRow < maxRowIndex) {
                this.getPageCache().put("rescan_begin_index", String.valueOf(selectRow + 1));
                this.getPageCache().put("rescan_end_index", String.valueOf(maxRowIndex));
                logger.info("\u8865\u626b\u63d2\u5165\u8d77\u59cb\u7d22\u5f15\u662f\uff1a[{}]\uff0c\u7ec8\u6b62\u7d22\u5f15\u662f\uff1a[{}]", (Object)String.valueOf(selectRow + 1), (Object)maxRowIndex);
            }
            CustomControl scannerControl = (CustomControl)this.getControl(customScanner);
            ScannerService.scanner((CustomControl)scannerControl, (String)this.getView().getPageId(), (String)"invoice");
        }
    }

    private void showAttachEdit(String serialNo) {
        FormShowParameter param = new FormShowParameter();
        param.setCaption(ResManager.loadKDString((String)"\u9644\u4ef6\u9884\u89c8", (String)"InvSignByExpensePlugin_113", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        JSONObject cacheJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        JSONObject invoice = cacheJson.getJSONObject(serialNo);
        this.setInvoiceFiled(invoice);
        if (InvoiceCollectPluginService.typeofsalerlist.equals(invoice.getLong("invoiceType"))) {
            JSONArray attachInfoList = new JSONArray();
            attachInfoList.add((Object)invoice);
            customParams.put("attachInfoList", attachInfoList);
            customParams.put("viewAttach", "viewAttach");
        } else {
            customParams.put("serialNo", serialNo);
            String fileName = invoice.getString("fileName");
            String fileType = FileUtils.getFileType((String)fileName);
            String url = invoice.getString("downloadUrl");
            if (StringUtils.isEmpty((String)url)) {
                url = invoice.getString("imageUrl");
            }
            if (StringUtils.isBlank((String)fileType)) {
                fileType = FileUtils.getFileType((String)url);
            }
            customParams.put("attach_name", fileName);
            customParams.put("file_extension", fileType);
            customParams.put("attach_remark", invoice.getString("attachRemark"));
            customParams.put("upload_date", new Date());
            if ("pdf".equalsIgnoreCase(fileType)) {
                customParams.put("attach_type", "1");
            } else {
                customParams.put("attach_type", "2");
            }
            customParams.put("attach_category", invoice.getLong("attach_category"));
            customParams.put("attach_url", url);
            customParams.put("snapshot_url", invoice.getString("snapshotUrl"));
            customParams.put("attachid", null);
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId(attachEditPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, attachEditPage);
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private void showBatchEdit(String serialNo) {
    }

    private void showExpenseEdit(String serialNo) {
        FormShowParameter param = new FormShowParameter();
        param.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u9884\u89c8", (String)"InvSignByExpensePlugin_114", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        JSONObject cacheJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        JSONObject invoiceJson = cacheJson.getJSONObject(serialNo);
        if (ObjectUtils.isEmpty((Object)invoiceJson)) {
            Map mainDetailMap = VerifyUtil.queryInvoiceDynamicObjectBySerialNo((String)serialNo);
            DynamicObject detail = (DynamicObject)mainDetailMap.get("detail");
            invoiceJson = JSON.parseObject((String)JSON.toJSONString((Object)detail));
        }
        this.setInvoiceFiled(invoiceJson);
        int invoiceIndex = 0;
        customParams.put("invoice", invoiceJson);
        customParams.put("row", invoiceIndex);
        if (this.expenseRelationService.canEdit(invoiceJson.getString("expenseNum")).booleanValue()) {
            customParams.put("editAllow", Boolean.TRUE);
            param.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91\u754c\u9762", (String)"InvSignByExpensePlugin_115", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        customParams.put("resourcePlugin", "sign_by_expense");
        JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_UPLOAD.getCode());
        invoiceJson.put("org_id", (Object)businessParam.getString("org_id"));
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId(expenseEditPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, expenseEditPage);
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private void showInvoiceEdit(String serialNo) {
        FormShowParameter param = new FormShowParameter();
        param.setCaption(ResManager.loadKDString((String)"\u53d1\u7968\u9884\u89c8", (String)"InvSignByExpensePlugin_116", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        JSONObject cacheJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        JSONObject invoiceJson = cacheJson.getJSONObject(serialNo);
        if (ObjectUtils.isEmpty((Object)invoiceJson)) {
            Map mainDetailMap = VerifyUtil.queryInvoiceDynamicObjectBySerialNo((String)serialNo);
            DynamicObject detail = (DynamicObject)mainDetailMap.get("detail");
            invoiceJson = JSON.parseObject((String)JSON.toJSONString((Object)detail));
        }
        this.setInvoiceFiled(invoiceJson);
        int invoiceIndex = 0;
        customParams.put("invoice", invoiceJson);
        customParams.put("row", invoiceIndex);
        if (InvoiceCollectPluginService.canEditInvoice((JSONObject)invoiceJson).booleanValue()) {
            customParams.put("editAllow", Boolean.TRUE);
            param.setCaption(ResManager.loadKDString((String)"\u53d1\u7968\u7f16\u8f91", (String)"InvSignByExpensePlugin_117", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_UPLOAD.getCode());
        invoiceJson.put("org_id", (Object)businessParam.getString("org_id"));
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId(invoiceEditPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "editCallback");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private void setInvoiceFiled(JSONObject invoiceJson) {
        String serialNo = invoiceJson.getString("serialNo");
        if (StringUtils.isEmpty((String)serialNo)) {
            return;
        }
        InvoiceQueryService invoiceQueryService = new InvoiceQueryService();
        QFilter qFilter = new QFilter("serial_no", "=", (Object)serialNo);
        DynamicObjectCollection collection = invoiceQueryService.findByFilter("collect_type", qFilter);
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            invoiceJson.put("collect_type", (Object)((DynamicObject)collection.get(0)).getString("collect_type"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject recountFileIndex(String pageId, Map<String, Object> customParam, int invoiceIndex, JSONObject invoice) {
        Throwable throwable = null;
        try (DLock lock = DLock.create((String)("recountFileIndex" + pageId), (String)ResManager.loadKDString((String)"\u91cd\u65b0\u8bbe\u7f6e\u53d1\u7968\u7d22\u5f15", (String)"InvSignByExpensePlugin_120", (String)"imc-rim-formplugin", (Object[])new Object[0]));){
            int times = 0;
            while (times < 30) {
                JSONObject jSONObject;
                if (!lock.tryLock(500L)) continue;
                try {
                    String cache;
                    String expenseNumTemp;
                    JSONArray barcodeArray;
                    JSONObject dataJson = InvoiceCollectPluginService.getInvoiceDataCache((String)pageId);
                    logger.info("\u8c03\u7528\u91cd\u65b0\u8bbe\u7f6e\u53d1\u7968\u7d22\u5f15\u65b9\u6cd5\u7684\u6b21\u6570");
                    String serialNo = invoice.getString("serialNo");
                    if (StringUtils.isEmpty((String)serialNo)) {
                        serialNo = UUID.randomUUIDZero();
                        invoice.put("serialNo", (Object)serialNo);
                    }
                    String expenseNum = new PageCache(pageId).get("collect_expenseNum");
                    logger.info("[{}]\u5355\u636e\u7684\u6d41\u6c34\u53f7\u662f[{}]", (Object)expenseNum, (Object)serialNo);
                    if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoice.getLong("invoiceType")) && !CollectionUtils.isEmpty((Collection)(barcodeArray = invoice.getJSONArray("barcode"))) && StringUtils.isNotEmpty((String)(expenseNumTemp = (String)barcodeArray.get(0)))) {
                        expenseNum = expenseNumTemp;
                        serialNo = expenseNumTemp;
                        logger.info("\u518d\u4e00\u6b21\u8bbe\u7f6e\u7684\u5355\u636e\u53f7\u662f\uff1a[{}]", (Object)expenseNum);
                        new PageCache(pageId).put("collect_expenseNum", expenseNum);
                    }
                    JSONObject invoiceSeqCache = StringUtils.isNotEmpty((String)(cache = new PageCache(pageId).get("serial_no_index"))) ? JSON.parseObject((String)cache) : new JSONObject();
                    Integer index = invoiceSeqCache.getInteger(serialNo);
                    logger.info("\u6d41\u6c34\u53f7[{}]\u5bf9\u5e94\u7684\u7d22\u5f15\u662f[{}]", (Object)serialNo, (Object)index);
                    this.setImageType(invoice);
                    if (index != null && StringUtils.isNotEmpty((String)serialNo)) {
                        invoice.put("fileIndex", (Object)index);
                    } else {
                        String expenseMaxSeqCache = new PageCache(pageId).get(CACHE_EXPENSE_MAX_SEQ_DATA);
                        JSONObject expenseMaxIndex = StringUtils.isNotEmpty((String)expenseMaxSeqCache) ? JSON.parseObject((String)expenseMaxSeqCache) : new JSONObject();
                        logger.info("[{}]\u5355\u636e\u7684\u7d22\u5f15\u7f13\u5b58\u662f[{}]", (Object)expenseNum, (Object)expenseMaxIndex);
                        if (StringUtils.isNotEmpty((String)expenseNum)) {
                            String maxIndex = expenseMaxIndex.getString(expenseNum);
                            logger.info("[{}]\u5355\u636e\u7684\u6700\u5927\u7d22\u5f15\u662f[{}]", (Object)expenseNum, (Object)maxIndex);
                            if (StringUtils.isNotEmpty((String)maxIndex)) {
                                if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoice.getLong("invoiceType"))) {
                                    JSONArray barcodeArray2 = invoice.getJSONArray("barcode");
                                    if (CollectionUtils.isEmpty((Collection)barcodeArray2) || StringUtils.isEmpty((String)(barcodeArray2.get(0) + ""))) {
                                        int attachIndex = Integer.parseInt(maxIndex) + 1;
                                        expenseMaxIndex.put(expenseNum, (Object)attachIndex);
                                        new PageCache(pageId).put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
                                        invoice.put("fileIndex", (Object)attachIndex);
                                        logger.info("\u91cd\u7f6e\u7d22\u5f15\u662f[{}]", (Object)attachIndex);
                                        if (StringUtils.isNotEmpty((String)serialNo)) {
                                            invoiceSeqCache.put(serialNo, (Object)attachIndex);
                                            new PageCache(pageId).put("serial_no_index", invoiceSeqCache.toJSONString());
                                        }
                                    }
                                } else {
                                    int invoicesIndex = Integer.parseInt(maxIndex) + 1;
                                    expenseMaxIndex.put(expenseNum, (Object)invoicesIndex);
                                    new PageCache(pageId).put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
                                    invoice.put("fileIndex", (Object)invoicesIndex);
                                    logger.info("\u91cd\u7f6e\u7d22\u5f15\u662f[{}]", (Object)invoicesIndex);
                                    if (StringUtils.isNotEmpty((String)serialNo)) {
                                        invoiceSeqCache.put(serialNo, (Object)invoicesIndex);
                                        new PageCache(pageId).put("serial_no_index", invoiceSeqCache.toJSONString());
                                    }
                                }
                            } else {
                                int expenseIndex = ObjectUtils.isEmpty((Object)new PageCache(pageId).get("fileIndex")) ? invoiceIndex + 1 : Integer.parseInt(new PageCache(pageId).get("fileIndex")) + 500;
                                new PageCache(pageId).put("fileIndex", String.valueOf(expenseIndex));
                                expenseMaxIndex.put(expenseNum, (Object)expenseIndex);
                                new PageCache(pageId).put(CACHE_EXPENSE_MAX_SEQ_DATA, expenseMaxIndex.toJSONString());
                                invoice.put("fileIndex", (Object)expenseIndex);
                                logger.info("\u91cd\u7f6e\u7d22\u5f15\u662f[{}]", (Object)expenseIndex);
                                if (StringUtils.isNotEmpty((String)serialNo)) {
                                    invoiceSeqCache.put(serialNo, (Object)expenseIndex);
                                    new PageCache(pageId).put("serial_no_index", invoiceSeqCache.toJSONString());
                                }
                            }
                        } else {
                            int beginIndex = ObjectUtils.isEmpty((Object)new PageCache(pageId).get("fileIndex")) ? invoiceIndex + 1 : Integer.parseInt(new PageCache(pageId).get("fileIndex")) + 1;
                            new PageCache(pageId).put("fileIndex", String.valueOf(beginIndex));
                            invoice.put("fileIndex", (Object)beginIndex);
                            logger.info("\u91cd\u7f6e\u7d22\u5f15\u662f[{}]", (Object)beginIndex);
                            if (StringUtils.isNotEmpty((String)serialNo)) {
                                invoiceSeqCache.put(serialNo, (Object)beginIndex);
                                new PageCache(pageId).put("serial_no_index", invoiceSeqCache.toJSONString());
                            }
                        }
                    }
                    jSONObject = dataJson;
                }
                catch (Throwable throwable2) {
                    try {
                        lock.unlock();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                        return null;
                    }
                }
                lock.unlock();
                return jSONObject;
            }
        }
    }

    private JSONObject clearDoubleAttachment(JSONObject dataJson) {
        HashSet<String> set = new HashSet<String>(4);
        ArrayList<String> removeset = new ArrayList<String>(4);
        for (Map.Entry entry : dataJson.entrySet()) {
            String value = (String)entry.getKey();
            JSONObject invoice = dataJson.getJSONObject(value);
            if (ObjectUtils.isEmpty((Object)invoice)) continue;
            String fileIndex = invoice.getString("fileIndex");
            String imageType = invoice.getString("imageType");
            if (!"attachment".equals(imageType) || !StringUtils.isNotEmpty((String)fileIndex) || set.add(fileIndex)) continue;
            removeset.add(value);
        }
        removeset.forEach(val -> dataJson.remove(val));
        return dataJson;
    }

    private Pattern getBatchPattern() {
        String pat = ImcConfigUtil.getValue((String)"rim_invsign", (String)"batchpattern");
        if (!StringUtils.isEmpty((String)pat)) {
            return Pattern.compile(pat);
        }
        return null;
    }

    private Pattern getCoverPattern() {
        String pat = ImcConfigUtil.getValue((String)"rim_invsign", (String)"coverpattern");
        if (!StringUtils.isEmpty((String)pat)) {
            return Pattern.compile(pat);
        }
        return null;
    }

    static {
        errorLevelColer.put("0", "#ff5257");
        errorLevelColer.put("1", "#ff5f1f");
        errorLevelColer.put("2", "#40bd6e");
    }
}

