/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.RimConfigUtils;

public class InvoiceBlackListSynTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(InvoiceBlackListSynTask.class);
    private static final String RIM_BLACK_LIST = "rim_black_list_data";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Long startTime = System.currentTimeMillis();
        logger.info("[hlzsBlackList]\u8fdb\u9879\u53d1\u7968\u9ed1\u540d\u5355\u6570\u636e\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5f00\u59cb... ");
        JSONObject blackListJson = null;
        int pageSize = 500;
        int pageNum = 1;
        int synNum = 0;
        int retryNums = 0;
        int maxRetryNums = 5;
        QFilter idFilter = new QFilter("company_name", "is not null", null);
        boolean isUnitTest = RimConfigUtils.isUnitTest();
        try {
            while (!isUnitTest || pageNum <= 1) {
                HashMap<String, Integer> requestParam = new HashMap<String, Integer>(2);
                requestParam.put("pageSize", pageSize);
                requestParam.put("pageNum", pageNum);
                logger.info("[hlzsBlackList]\u8c03\u7528\u5408\u529b\u4e2d\u7a0e\u9ed1\u540d\u5355\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a" + requestParam);
                blackListJson = AwsFpyService.newInstance().postAppJson("download_blackList", null, requestParam);
                logger.info("[hlzsBlackList]\u8c03\u7528\u5408\u529b\u4e2d\u7a0e\u9ed1\u540d\u5355\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + blackListJson);
                if (!ObjectUtils.isEmpty((Object)blackListJson)) {
                    JSONArray data = blackListJson.getJSONArray("data");
                    if (data != null && data.size() > 0 && "0000".equals(blackListJson.getString("errcode"))) {
                        JSONArray awsBlackListArray = blackListJson.getJSONArray("data");
                        if (pageNum == 1 && awsBlackListArray != null && awsBlackListArray.size() > 0) {
                            DeleteServiceHelper.delete((String)RIM_BLACK_LIST, (QFilter[])idFilter.toArray());
                        }
                        if (awsBlackListArray != null && !awsBlackListArray.isEmpty()) {
                            logger.info("[hlzsBlackList]\u8c03\u7528\u5408\u529b\u4e2d\u7a0e\u9ed1\u540d\u5355\u63a5\u53e3\u8fd4\u56de\u6570\u91cf\uff1a" + awsBlackListArray.size());
                            DynamicObject blackListObject = null;
                            for (int i = 0; i < awsBlackListArray.size(); ++i) {
                                if (awsBlackListArray.getJSONObject(i) == null) continue;
                                try {
                                    JSONObject awsBlackListJson = awsBlackListArray.getJSONObject(i);
                                    String type = awsBlackListJson.getString("type");
                                    if (!"1".equals(type)) continue;
                                    blackListObject = BusinessDataServiceHelper.newDynamicObject((String)RIM_BLACK_LIST);
                                    String caseDetail = awsBlackListJson.getString("caseDetail");
                                    if (!StringUtils.isBlank((CharSequence)caseDetail) && caseDetail.length() >= 600) {
                                        caseDetail = caseDetail.substring(0, 599);
                                    }
                                    blackListObject.set("case_detail", (Object)caseDetail);
                                    String caseNature = awsBlackListJson.getString("caseNature");
                                    if (StringUtils.isNotEmpty((CharSequence)caseNature) && caseNature.length() >= 80) {
                                        caseNature = caseNature.substring(0, 79);
                                    }
                                    blackListObject.set("case_nature", (Object)caseNature);
                                    String legalCardNo = awsBlackListJson.getString("legalCardNo");
                                    if (!StringUtils.isBlank((CharSequence)legalCardNo) && legalCardNo.length() >= 80) {
                                        legalCardNo = legalCardNo.substring(0, 79);
                                    }
                                    blackListObject.set("legal_card_no", (Object)legalCardNo);
                                    String legalCardType = awsBlackListJson.getString("legalCardType");
                                    if (StringUtils.isNotEmpty((CharSequence)legalCardType) && legalCardType.length() >= 20) {
                                        legalCardType = legalCardType.substring(0, 19);
                                    }
                                    blackListObject.set("legal_card_type", (Object)legalCardType);
                                    String legalName = awsBlackListJson.getString("legalName");
                                    if (StringUtils.isNotEmpty((CharSequence)legalName) && legalName.length() >= 50) {
                                        legalName = legalName.substring(0, 49);
                                    }
                                    blackListObject.set("legal_name", (Object)legalName);
                                    String legalSex = awsBlackListJson.getString("legalSex");
                                    if (!StringUtils.isBlank((CharSequence)legalSex) && legalSex.length() >= 80) {
                                        legalSex = legalSex.substring(0, 79);
                                    }
                                    blackListObject.set("legal_sex", (Object)legalSex);
                                    String taxPayerNo = awsBlackListJson.getString("nsrsbh");
                                    if (StringUtils.isNotEmpty((CharSequence)taxPayerNo) && taxPayerNo.length() >= 50) {
                                        taxPayerNo = taxPayerNo.substring(0, 49);
                                    }
                                    blackListObject.set("tax_payer_no", (Object)taxPayerNo);
                                    String orgId = awsBlackListJson.getString("orgDm");
                                    if (!StringUtils.isBlank((CharSequence)orgId) && orgId.length() >= 80) {
                                        orgId = orgId.substring(0, 79);
                                    }
                                    blackListObject.set("org", (Object)orgId);
                                    String province = awsBlackListJson.getString("province");
                                    if (StringUtils.isNotEmpty((CharSequence)province) && province.length() >= 50) {
                                        province = province.substring(0, 49);
                                    }
                                    blackListObject.set("province", (Object)province);
                                    String companyName = awsBlackListJson.getString("qymc");
                                    if (StringUtils.isNotEmpty((CharSequence)companyName) && companyName.length() >= 100) {
                                        companyName = companyName.substring(0, 99);
                                    }
                                    blackListObject.set("company_name", (Object)companyName);
                                    String registAddress = awsBlackListJson.getString("regeditAddress");
                                    if (StringUtils.isNotEmpty((CharSequence)registAddress) && registAddress.length() >= 150) {
                                        registAddress = registAddress.substring(0, 149);
                                    }
                                    blackListObject.set("regist_address", (Object)registAddress);
                                    String mediumInfo = awsBlackListJson.getString("mediumInfo");
                                    if (!StringUtils.isBlank((CharSequence)mediumInfo) && mediumInfo.length() >= 150) {
                                        mediumInfo = mediumInfo.substring(0, 149);
                                    }
                                    blackListObject.set("medium_info", (Object)mediumInfo);
                                    blackListObject.set("create_date", (Object)new Date());
                                    blackListObject.set("update_date", (Object)new Date());
                                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{blackListObject});
                                    continue;
                                }
                                catch (Exception e) {
                                    logger.error("\u4fdd\u5b58\u5408\u529b\u4e2d\u7a0e\u9ed1\u540d\u5355\u51fa\u9519", (Throwable)e);
                                }
                            }
                            synNum += awsBlackListArray.size();
                            ++pageNum;
                            if (awsBlackListArray.size() >= pageSize) continue;
                        }
                    } else if (retryNums < maxRetryNums) {
                        ++retryNums;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("[hlzsBlackList-fail]\u83b7\u53d6\u5408\u529b\u4e2d\u7a0e\u9ed1\u540d\u5355\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
        Long endTime = System.currentTimeMillis();
        logger.info("[hlzsBlackList]\u8fdb\u9879\u53d1\u7968\u5f88\u540d\u5355\u6570\u636e\u540c\u6b65\u4efb\u52a1\u6267\u884c\u7ed3\u675f...\u540c\u6b65 " + synNum + "\u6761\u6570\u636e, \u8017\u65f6\uff1a" + (endTime - startTime));
    }
}

