/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.invoice.fpzs.InvoiceClassService;
import kd.imc.rim.common.utils.DBUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;

public class InvoiceClassChosePlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.initEntity(customParams);
    }

    public void afterBindData(EventObject e) {
        String selectedIdsStr = this.getView().getPageCache().get("selectedIds");
        if (StringUtils.isNotEmpty((CharSequence)selectedIdsStr)) {
            JSONArray selectRows = JSONArray.parseArray((String)selectedIdsStr);
            int[] ints = new int[selectRows.size()];
            for (int j = 0; j < selectRows.size(); ++j) {
                ints[j] = (Integer)selectRows.get(j);
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            entryGrid.selectRows(ints, ints[0]);
            this.getView().getPageCache().remove("selectedIds");
        }
    }

    private void initEntity(Map<String, Object> customParams) {
        QFilter qFilter;
        DynamicObject[] invoiceClasses;
        this.getModel().deleteEntryData("entryentity");
        List ids = (List)customParams.get("ids");
        String userId = RequestContext.get().getUserId();
        String enableQuery = (String)this.getModel().getValue("enable_query");
        QFilter enableFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)enableQuery)) {
            enableFilter = new QFilter("enable", "=", (Object)enableQuery).or("enable", "=", (Object)"").or("enable", "=", (Object)" ");
        }
        if ((invoiceClasses = BusinessDataServiceHelper.load((String)"rim_invoice_class", (String)"id,number,name,isdefault,enable", (QFilter[])new QFilter[]{qFilter = new QFilter("isdefault", "=", (Object)"1").or(new QFilter("creator", "=", (Object)Long.parseLong(userId))), enableFilter}, (String)"isdefault desc")).length == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", invoiceClasses.length);
        int i = 0;
        ArrayList selectRows = Lists.newArrayList();
        for (DynamicObject obj : invoiceClasses) {
            String id = obj.getString("id");
            this.getModel().setValue("id", (Object)id, i);
            this.getModel().setValue("number", (Object)obj.getString("number"), i);
            this.getModel().setValue("name", (Object)obj.getString("name"), i);
            this.getModel().setValue("isdefault", (Object)obj.getString("isdefault"), i);
            this.getModel().setValue("enable", (Object)obj.getString("enable"), i);
            if (StringUtils.isNotEmpty((CharSequence)obj.getString("id"))) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"number", "name", "isdefault"});
            }
            if (ids != null && ids.contains(id)) {
                selectRows.add(i);
            }
            ++i;
        }
        if (selectRows.size() > 0) {
            this.getView().getPageCache().put("selectedIds", JSON.toJSONString((Object)selectRows));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("enable_query".equals(name)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            this.initEntity(customParams);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String item = evt.getItemKey();
        EntryGrid list = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = list.getSelectRows();
        if ("add".equals(item)) {
            Date date = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String format = sdf.format(date);
            this.getModel().batchCreateNewEntryRow("entryentity", 1);
            int index = this.getModel().getEntryRowCount("entryentity");
            this.getModel().setValue("number", (Object)("class_" + format + "_" + UUID.getRandomNum((int)5)), index - 1);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            entryGrid.focusCell(index - 1, "");
        } else if ("del".equals(item)) {
            ArrayList delRows = Lists.newArrayList();
            ArrayList checkRows = Lists.newArrayList();
            ArrayList ids = Lists.newArrayList();
            boolean flag = false;
            for (int index : selectRows) {
                DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", index);
                if ("1".equals(entryentity.getString("isdefault"))) {
                    flag = true;
                    continue;
                }
                String id = entryentity.getString("id");
                if (StringUtils.isEmpty((CharSequence)id)) {
                    delRows.add(index);
                    continue;
                }
                checkRows.add(index);
                ids.add(id);
            }
            if (flag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u6807\u7b7e\u4e0d\u80fd\u5220\u9664", (String)"InvoiceClassChosePlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            List<String> usedList = this.checkUsed(ids);
            if (CollectionUtils.isNotEmpty(usedList)) {
                StringBuilder sb = new StringBuilder();
                for (String s : usedList) {
                    sb.append("\u3010").append(s).append("\u3011");
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6807\u7b7e\uff1a%1$s \u5df2\u88ab\u53d1\u7968\u4f7f\u7528\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", (String)"InvoiceClassChosePlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), sb));
                return;
            }
            delRows.addAll(checkRows);
            int[] rows = delRows.stream().mapToInt(Integer::intValue).toArray();
            this.getModel().deleteEntryRows("entryentity", rows);
            int[] initRows = new int[]{};
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            entryGrid.selectRows(initRows, 0);
        } else if ("use".equals(item)) {
            ArrayList updateNumbers = Lists.newArrayList();
            for (int index : selectRows) {
                DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", index);
                if ("1".equals(entryentity.getString("enable"))) continue;
                updateNumbers.add(entryentity.getString("number"));
            }
            this.updateEnable(updateNumbers, "1");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            this.initEntity(customParams);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"QueryExportConfigPlugin_21", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else if ("unuse".equals(item)) {
            boolean showTips = false;
            for (int index : selectRows) {
                DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", index);
                if (!"1".equals(entryentity.getString("isdefault"))) continue;
                showTips = true;
                break;
            }
            if (showTips) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6807\u7b7e\u5b58\u5728\u7cfb\u7edf\u9884\u7f6e\u6807\u7b7e\uff0c\u4e0d\u5141\u8bb8\u7981\u7528", (String)"InvoiceClassChosePlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList updateNumbers = Lists.newArrayList();
            for (int index : selectRows) {
                DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", index);
                if ("0".equals(entryentity.getString("enable"))) continue;
                updateNumbers.add(entryentity.getString("number"));
            }
            this.updateEnable(updateNumbers, "0");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            this.initEntity(customParams);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"QueryExportConfigPlugin_21", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    private List<String> checkUsed(List<String> checkIds) {
        ArrayList labelList = Lists.newArrayList();
        if (checkIds == null || checkIds.size() == 0) {
            return labelList;
        }
        String sql = "select distinct a.fid, a.fname from t_rim_invoice_class a left join t_rim_invoice_mul_class b on a.fid = b.fbasedataid  where b.fbasedataid in (%s)";
        String ids = String.join((CharSequence)",", checkIds);
        List result = DBUtils.query((String)"taxc", (String)String.format(sql, ids));
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            for (Map c : result) {
                String fname = (String)c.get("FNAME");
                labelList.add(fname);
                String fid = (String)c.get("id");
                checkIds.remove(fid);
            }
        }
        if (labelList.size() == 0) {
            long[] delIds = checkIds.stream().mapToLong(Long::parseLong).toArray();
            DeleteServiceHelper.delete((String)"rim_invoice_class", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)delIds)});
        }
        return labelList;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)key)) {
            this.saveEntity();
            EntryGrid list = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = list.getSelectRows();
            HashSet ids = Sets.newHashSet();
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            if (selectRows.length > 0) {
                for (int selectRow : selectRows) {
                    String number;
                    DynamicObject object;
                    DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", selectRow);
                    if ("0".equals(entryentity.getString("enable"))) continue;
                    String id = entryentity.getString("id");
                    if (StringUtils.isEmpty((CharSequence)id) && (object = QueryServiceHelper.queryOne((String)"rim_invoice_class", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)(number = entryentity.getString("number")))})) != null) {
                        id = object.getString("id");
                    }
                    ids.add(id);
                }
            }
            this.checkSysMulClass(ids);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            JSONArray mainIds = (JSONArray)customParams.get("mainIds");
            JSONArray uncheckIds = (JSONArray)customParams.get("uncheckIds");
            if (mainIds != null && uncheckIds != null) {
                mainIds.addAll((Collection)uncheckIds);
            }
            if (mainIds != null && mainIds.size() > 0) {
                this.editInvoiceClass(mainIds, ids);
                returnMap.put("mainIds", mainIds);
                returnMap.put("uncheckIds", uncheckIds);
            } else {
                returnMap.put("choseIds", ids);
            }
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    private void checkSysMulClass(Set<String> ids) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List sysIds = (List)customParams.get("sysIds");
        if (ids == null || sysIds == null) {
            return;
        }
        if (ids.containsAll(sysIds)) {
            return;
        }
        ids.addAll(sysIds);
    }

    private void editInvoiceClass(JSONArray invoiceIds, Set<String> ids) {
        if (invoiceIds == null) {
            return;
        }
        long[] longs = invoiceIds.stream().mapToLong(m -> Long.parseLong(m.toString())).toArray();
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"rim_invoice", (String)"id, mul_class, ext_info", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)longs)});
        if (invoices != null) {
            for (DynamicObject invoice : invoices) {
                DynamicObjectCollection mul_class = invoice.getDynamicObjectCollection("mul_class");
                mul_class.clear();
                String extInfo = invoice.getString("ext_info");
                if (StringUtils.isNotEmpty((CharSequence)extInfo)) {
                    try {
                        JSONObject extInfoObj = JSONObject.parseObject((String)extInfo);
                        String sysMulClass = extInfoObj.getString("sys_mulclass");
                        if (StringUtils.isNotEmpty((CharSequence)sysMulClass)) {
                            List<String> sysIds = Arrays.asList(sysMulClass.split(","));
                            ids.addAll(sysIds);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                for (String classid : ids) {
                    DynamicObject classInfo = mul_class.addNew();
                    classInfo.set("fbasedataid_id", (Object)Long.parseLong(classid));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
            }
        }
    }

    private void saveEntity() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        ArrayList saveList = Lists.newArrayList();
        for (DynamicObject obj : entryentity) {
            String id = obj.getString("id");
            if (!StringUtils.isEmpty((CharSequence)id)) continue;
            saveList.add(obj);
        }
        if (CollectionUtils.isNotEmpty((Collection)saveList)) {
            for (DynamicObject obj : saveList) {
                String name = obj.getString("name");
                if (StringUtils.isEmpty((CharSequence)name)) continue;
                InvoiceClassService.getInstance().addInvoiceClass(obj.getString("name"), obj.getString("number"), obj.getString("enable"), Long.valueOf(RequestContext.get().getCurrUserId()));
            }
        }
    }

    private void updateEnable(List<String> numbers, String enable) {
        if (CollectionUtils.isEmpty(numbers)) {
            return;
        }
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"rim_invoice_class", (String)"enable", (QFilter[])new QFilter[]{new QFilter("number", "in", numbers)});
        if (objects.length > 0) {
            for (DynamicObject f : objects) {
                f.set("enable", (Object)(StringUtils.isEmpty((CharSequence)enable) ? "1" : enable));
            }
            SaveServiceHelper.save((DynamicObject[])objects);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.clearSelection();
        billlist.refresh();
    }
}

