/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.collector.InvoiceCollectField;
import kd.imc.rim.common.invoice.collector.InvoiceSalesListService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionCheckTask;
import kd.imc.rim.common.multitenant.service.MultiTenantService;
import kd.imc.rim.common.multitenant.service.impl.AttachQueryServiceAdapter;
import kd.imc.rim.common.multitenant.service.impl.FpzsInvoiceCollectServiceAdapter;
import kd.imc.rim.common.multitenant.service.impl.InvoiceCollectServiceAdapter;
import kd.imc.rim.common.multitenant.service.impl.SnapshotServiceAdapter;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.InvoiceCheckUtils;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;

public class InvoiceCollectEditPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final Log logger = LogFactory.getLog(InvoiceCollectEditPlugin.class);
    private static String submitButton = "submitbutton";
    private static String detailButton = "detail_button";
    private static String invoiceTypeCombo = "invoice_type_combo";
    private static String VIEW_ORIGINAL_FILE = "view_original_file";
    private static String VIEW_SNAPSHOT_FILE = "view_snapshot_file";
    private static String CREATE_IMAGE_FILE = "create_image_file";
    private static String INVOICE_CACHE_KEY = "invoice";
    private InvoiceCollectServiceAdapter invoiceCollectService = new InvoiceCollectServiceAdapter();
    private FpzsInvoiceCollectServiceAdapter fpzsInvoiceCollectService = new FpzsInvoiceCollectServiceAdapter();

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        Button submit = (Button)this.getControl(submitButton);
        submit.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"show_saleslist", "show_image", VIEW_ORIGINAL_FILE, CREATE_IMAGE_FILE, VIEW_SNAPSHOT_FILE, detailButton});
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String key = tabSelectEvent.getTabKey();
        if ("tab_invoice".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap_atach"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
        } else if ("tab_attach".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap_atach"});
            String serialNo = this.getSerialNo();
            AttachQueryServiceAdapter attachQueryService = new AttachQueryServiceAdapter();
            JSONArray attachs = attachQueryService.getAttachsMapByInvoiceSerialNo(serialNo);
            if (!CollectionUtils.isEmpty((Collection)attachs)) {
                HashMap<String, JSONArray> customParams = new HashMap<String, JSONArray>(8);
                customParams.put("attachArray", attachs);
                FormShowParameter param = new FormShowParameter();
                param.setCustomParams(customParams);
                param.setFormId("rim_view_attach");
                param.getOpenStyle().setShowType(ShowType.InContainer);
                param.getOpenStyle().setTargetKey("flexpanelap_atach");
                this.getView().showForm(param);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u6ca1\u6709\u5173\u8054\u9644\u4ef6", (String)"InvoiceCollectEditPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap_atach"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)submitButton, (CharSequence)key)) {
            JSONObject invoiceInit = JSONObject.parseObject((String)this.getPageCache().get("invoiceInit"));
            JSONObject invoice = JSONObject.parseObject((String)this.getPageCache().get(INVOICE_CACHE_KEY));
            if (InvoiceConvertUtils.checkRoadBridgeMustInput((JSONObject)invoice)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fc7\u8def\u8fc7\u6865\u8d39\u53d1\u7968\u4ee3\u7801\u3001\u51fa\u53e3\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"InvoiceCollectEditPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (invoiceInit.toJSONString().equals(invoice.toJSONString()) && !InvoiceConvertUtils.isVatInvoiceType((Long)invoice.getLong("invoiceType"))) {
                this.getView().close();
            } else {
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvoiceCollectEditPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InvoiceCollectEditPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u4fee\u6539", (String)"InvoiceCollectEditPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Save, new ConfirmCallBackListener("updateInvoice"), btnNameMaps);
            }
        } else if (StringUtils.equals((CharSequence)"show_saleslist", (CharSequence)key) || StringUtils.equals((CharSequence)"show_image", (CharSequence)key)) {
            InvoiceSalesListService.clickChange((String)key, (IFormView)this.getView());
        } else if (StringUtils.equals((CharSequence)CREATE_IMAGE_FILE, (CharSequence)key)) {
            this.createImage();
        } else if (StringUtils.equals((CharSequence)VIEW_ORIGINAL_FILE, (CharSequence)key)) {
            this.showOriginalFile("1");
        } else if (StringUtils.equals((CharSequence)VIEW_SNAPSHOT_FILE, (CharSequence)key)) {
            this.showOriginalFile("0");
        } else if (StringUtils.equals((CharSequence)detailButton, (CharSequence)key)) {
            this.showDetail();
        }
    }

    private void showOriginalFile(String originalStatus) {
        InvoiceSalesListService.clickChange((String)"show_image", (IFormView)this.getView());
        String invoice = this.getPageCache().get(INVOICE_CACHE_KEY);
        if (StringUtils.isNotEmpty((CharSequence)invoice)) {
            JSONObject invoiceJson = JSONObject.parseObject((String)invoice);
            String pdfUrl = (String)CommonUtils.getJsonValue((Map)invoiceJson, String.class, (boolean)true, (String[])new String[]{"pdfurl", "localUrl", "pdfUrl", "downloadUrl"});
            String fType = FileUtils.getFileType((String)pdfUrl);
            String fileType = invoiceJson.getString("fileType");
            if (StringUtils.isEmpty((CharSequence)pdfUrl) || "ofd".equalsIgnoreCase(fType) && "4".equals(fileType)) {
                pdfUrl = invoiceJson.getString("imageUrl");
            }
            String snapshotUrl = invoiceJson.getString("snapshotUrl");
            String rotateDeg = invoiceJson.getString("orientation");
            if (StringUtils.isEmpty((CharSequence)rotateDeg)) {
                rotateDeg = invoiceJson.getString("rotationAngle");
            }
            String pixel = invoiceJson.getString("pixel");
            String region = invoiceJson.getString("region");
            if ("1".equals(originalStatus)) {
                if (StringUtils.isNotEmpty((CharSequence)pdfUrl) && ("pdf".equalsIgnoreCase(fType) || "1".equals(fileType) || "4".equals(fileType))) {
                    fileType = "1";
                }
                this.showInvoiceInfo(pdfUrl, rotateDeg, pixel, region, fileType);
                this.getView().setVisible(Boolean.TRUE, new String[]{VIEW_SNAPSHOT_FILE});
                this.getView().setVisible(Boolean.FALSE, new String[]{VIEW_ORIGINAL_FILE});
            } else {
                this.showInvoiceInfo(snapshotUrl, rotateDeg, pixel, region, "2");
                this.getView().setVisible(Boolean.FALSE, new String[]{VIEW_SNAPSHOT_FILE});
                this.getView().setVisible(Boolean.TRUE, new String[]{VIEW_ORIGINAL_FILE});
            }
        }
    }

    private void createImage() {
        String invoice = this.getPageCache().get(INVOICE_CACHE_KEY);
        if (StringUtils.isNotEmpty((CharSequence)invoice)) {
            JSONObject invoiceJson = JSONObject.parseObject((String)invoice);
            JSONObject result = this.fpzsInvoiceCollectService.createImage(invoice);
            if (ResultContant.isSuccess((JSONObject)result).booleanValue()) {
                JSONObject data = result.getJSONObject("data");
                String snapshotUrl = data.getString("snapshotUrl");
                invoiceJson.put("snapshotUrl", (Object)snapshotUrl);
                invoiceJson.put("localUrl", (Object)data.getString("localUrl"));
                invoiceJson.put("pdfUrl", (Object)data.getString("pdfUrl"));
                invoiceJson.put("kdcloudUrl", (Object)data.getString("kdcloudUrl"));
                invoiceJson.put("downloadUrl", (Object)data.getString("downloadUrl"));
                invoiceJson.put("fileType", (Object)data.getString("fileType"));
                this.getPageCache().put(INVOICE_CACHE_KEY, invoiceJson.toJSONString());
                this.showInvoiceInfo(snapshotUrl, "0", "", "", "2");
                this.isShowCreateImg(Boolean.FALSE);
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u751f\u6210\u5e95\u8d26\u56fe\u7247\u5931\u8d25:%1$s", (String)"InvoiceCollectEditPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), result.get((Object)"description")));
            }
        }
    }

    private void showDetail() {
        Long invoiceType = Long.parseLong((String)this.getModel().getValue("invoice_type_combo"));
        String invoiceStr = this.getPageCache().get(INVOICE_CACHE_KEY);
        if (!StringUtils.isEmpty((CharSequence)invoiceStr)) {
            JSONObject invoiceJson = JSONObject.parseObject((String)invoiceStr);
            String serialNo = invoiceJson.getString("serialNo");
            if (StringUtils.isEmpty((CharSequence)serialNo)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u53d1\u7968\u7684\u6d41\u6c34\u53f7\uff0c\u65e0\u6cd5\u67e5\u770b\u660e\u7ec6", (String)"InvoiceCollectEditPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap typeSerialNoMap = new HashMap(1);
            ArrayList<String> serialNos = new ArrayList<String>(1);
            serialNos.add(serialNo);
            typeSerialNoMap.put(invoiceType, serialNos);
            String invoiceDetailFormId = "rim_invoice_query_detail";
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(invoiceDetailFormId);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String serialNoMapStr = SerializationUtils.toJsonString(typeSerialNoMap);
            formShowParameter.setCustomParam("serialNoMapStr", (Object)serialNoMapStr);
            this.getView().showForm(formShowParameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && "updateInvoice".equals(callBackId)) {
            JSONObject saveResult;
            JSONObject invoiceInit = JSONObject.parseObject((String)this.getPageCache().get("invoiceInit"));
            JSONObject invoice = JSONObject.parseObject((String)this.getPageCache().get(INVOICE_CACHE_KEY));
            boolean unChangedFlag = invoiceInit.toJSONString().equals(invoice.toJSONString());
            Map params = this.getView().getFormShowParameter().getCustomParams();
            String resoure = (String)params.get("resource");
            boolean uncheckListFlag = params.get("uncheckListFlag") != null;
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            String oldSerialNo = invoice.getString("serialNo");
            logger.info("\u4fee\u6539\u4fdd\u5b58\u524d\u7684\u53d1\u7968\u6570\u636e\uff1a" + invoice);
            String verifySaveFlag = RimConfigUtils.getConfig((String)"verify_save");
            if ("0".equals(verifySaveFlag)) {
                this.validDeleteStatus(invoice);
            }
            if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoice.getLong("invoiceType"))) {
                InvoiceCheckUtils.encodeIDNumber((JSONObject)invoice, (String)"customerIdentityNum", (int)4);
                this.dealIDNumber(invoice, "customerIdentityNum", 4);
            } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoice.getLong("invoiceType"))) {
                InvoiceCheckUtils.encodeIDNumber((JSONObject)invoice, (String)"customerIdentityNum", (int)8);
                this.dealIDNumber(invoice, "customerIdentityNum", 8);
            } else if (InputInvoiceTypeEnum.WITHHOLDING.getCode().equals(invoice.getLong("invoiceType"))) {
                invoice.put("invoiceCode", (Object)invoice.getString("salerTaxNo"));
            }
            if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoice.getLong("invoiceType"))) {
                invoice.put("invoiceDate", (Object)DateUtils.format((Date)invoice.getDate("issueDate")));
            }
            try {
                invoice.put("uncheckListFlag", (Object)uncheckListFlag);
                saveResult = this.invoiceCollectService.checkAndSaveInvoice(invoice, unChangedFlag);
            }
            catch (Exception e) {
                logger.info("\u53d1\u7968\u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\uff1a", (Object)e);
                String message = e.getMessage();
                if (message != null && (message.contains("value too long") || message.contains("numeric field overflow"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u90e8\u5206\u5b57\u6bb5\u8d85\u51fa\u6570\u636e\u5e93\u957f\u5ea6", (String)"InvoiceCollectEditPlugin_13", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff01", (String)"InvoiceCollectEditPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            logger.info("\u4fee\u6539\u4fdd\u5b58\u7ed3\u679c\uff1a" + saveResult);
            if (!saveResult.getBoolean("saveFlag").booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff01", (String)"InvoiceCollectEditPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            } else {
                JSONArray array = new JSONArray();
                array.add((Object)saveResult.getJSONObject("data"));
                RecognitionCheckTask.classOfInvoice((JSONArray)array);
                String finalSerialNo = saveResult.getJSONObject("data").getString("serialNo");
                this.fpzsInvoiceCollectService.insertModifyHisInfo(invoiceInit, JSONObject.parseObject((String)this.getPageCache().get(INVOICE_CACHE_KEY)), finalSerialNo);
                if (StringUtils.isNotEmpty((CharSequence)resoure)) {
                    JSONObject data = new JSONObject();
                    JSONObject invoiceData = new JSONObject();
                    JSONObject detailData = new JSONObject();
                    detailData.put("checkStatus", (Object)invoice.getString("checkStatus"));
                    detailData.put("expenseStatus", (Object)invoice.getString("expenseStatus"));
                    detailData.put("serialNo", (Object)invoice.getString("serialNo"));
                    detailData.put("oldSerialNo", (Object)invoice.getString("oldSerialNo"));
                    detailData.put("invoiceType", (Object)InputInvoiceTypeEnum.getAwsType((Object)invoice.getLong("invoiceType")));
                    detailData.put("invoiceCode", invoice.get((Object)"invoiceCode"));
                    detailData.put("invoiceNo", invoice.get((Object)"invoiceNo"));
                    detailData.put("amount", invoice.get((Object)"amount"));
                    detailData.put("totalAmount", invoice.get((Object)"totalAmount"));
                    detailData.put("totalTaxAmount", invoice.get((Object)"totalTaxAmount"));
                    detailData.put("taxAmount", invoice.get((Object)"taxAmount"));
                    detailData.put("sallerName", invoice.get((Object)"sallerName"));
                    detailData.put("sallerTaxNo", invoice.get((Object)"sallerTaxNo"));
                    invoiceData.put("data", (Object)detailData);
                    data.put("data", (Object)invoiceData);
                    this.getView().returnDataToParent((Object)data);
                    this.getView().close();
                } else {
                    Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
                    customParams.put("repeat", saveResult.getBoolean("repeat"));
                    customParams.put(INVOICE_CACHE_KEY, saveResult.getJSONObject("data"));
                    customParams.put("oldSerialNo", oldSerialNo);
                    customParams.put("row", parentCustomParams.get("row"));
                    customParams.put("entryName", parentCustomParams.get("entryName"));
                    this.getView().returnDataToParent(customParams);
                    this.getView().close();
                }
            }
        }
    }

    private void dealIDNumber(JSONObject invoice, String key, int enlength) {
        String idNumMiddle = invoice.getString("idNumMiddle");
        String customerIdNo = invoice.getString(key);
        String start = "";
        String end = "";
        if (StringUtils.isNotEmpty((CharSequence)customerIdNo)) {
            if (customerIdNo.length() == 18) {
                if (enlength == 4) {
                    start = customerIdNo.substring(0, 10);
                    end = customerIdNo.substring(14, 18);
                } else if (enlength == 8) {
                    start = customerIdNo.substring(0, 6);
                    end = customerIdNo.substring(14, 18);
                }
                if (StringUtils.isNotEmpty((CharSequence)idNumMiddle) && StringUtils.isNotEmpty((CharSequence)customerIdNo)) {
                    invoice.put(key, (Object)(start + idNumMiddle + end));
                }
            } else if (customerIdNo.length() >= 2) {
                start = customerIdNo.substring(0, customerIdNo.length() - 2);
                if (StringUtils.isNotEmpty((CharSequence)idNumMiddle) && StringUtils.isNotEmpty((CharSequence)customerIdNo)) {
                    invoice.put(key, (Object)(start + idNumMiddle));
                }
            } else {
                invoice.put(key, (Object)customerIdNo);
            }
        }
    }

    private void validDeleteStatus(JSONObject invoice) {
        String delete;
        if (invoice == null) {
            return;
        }
        invoice.put("delete", (Object)"2");
        Long invoiceType = invoice.getLong("invoiceType");
        Map idObject = this.fpzsInvoiceCollectService.queryMainInvoice(invoiceType, invoice.getString("invoiceCode"), invoice.getString("invoiceNo"));
        if (null != idObject && "1".equals(delete = (String)idObject.get("delete"))) {
            invoice.put("delete", (Object)"1");
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{VIEW_SNAPSHOT_FILE, CREATE_IMAGE_FILE});
        this.initView();
        InvoiceSalesListService.getInstance().initSaleslist(this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)invoiceTypeCombo, (CharSequence)fieldKey)) {
            String newInvoiceType = "";
            ChangeData[] changeDatas = e.getChangeSet();
            if (changeDatas.length == 1) {
                newInvoiceType = changeDatas[0].getNewValue().toString();
                logger.info("\u4fee\u6539\u53d1\u7968{}-{}", (Object)fieldKey, (Object)newInvoiceType);
                JSONObject invoice = JSONObject.parseObject((String)this.getPageCache().get(INVOICE_CACHE_KEY));
                Map oldInvoiceFieldMap = InvoiceCollectField.getInvoiceField((Long)invoice.getLong("invoiceType"));
                for (Map.Entry invoiceField : oldInvoiceFieldMap.entrySet()) {
                    if (null == this.getControl((String)invoiceField.getValue())) continue;
                    this.getView().setVisible(Boolean.FALSE, new String[]{(String)invoiceField.getValue()});
                }
                invoice.put("invoiceType", (Object)newInvoiceType);
                if (InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(Long.parseLong(newInvoiceType)) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(Long.parseLong(newInvoiceType))) {
                    invoice.put("invoiceCode", (Object)"");
                }
                this.getPageCache().put(INVOICE_CACHE_KEY, invoice.toJSONString());
                Map invoiceFieldMap = InvoiceCollectField.getInvoiceField((Long)invoice.getLong("invoiceType"));
                for (Map.Entry entry : invoiceFieldMap.entrySet()) {
                    if (null == this.getControl((String)entry.getValue())) continue;
                    this.getView().setVisible(Boolean.TRUE, new String[]{(String)entry.getValue()});
                    if (((String)entry.getKey()).contains(",")) {
                        String[] valueKeys;
                        for (String valueKey : valueKeys = ((String)entry.getKey()).split(",")) {
                            if (!StringUtils.isNotEmpty((CharSequence)invoice.getString(valueKey))) continue;
                            this.getModel().setValue((String)entry.getValue(), (Object)invoice.getString(valueKey));
                        }
                        continue;
                    }
                    this.getModel().setValue((String)entry.getValue(), (Object)invoice.getString((String)entry.getKey()));
                }
            }
        } else {
            Object newValue = null;
            ChangeData[] changeDatas = e.getChangeSet();
            if (changeDatas.length == 1) {
                newValue = changeDatas[0].getNewValue();
                logger.info("\u4fee\u6539\u53d1\u7968{}-{}", (Object)fieldKey, newValue);
                if (newValue instanceof Date) {
                    newValue = DateUtils.format((Date)((Date)newValue), (String)"yyyy-MM-dd");
                } else if (newValue instanceof DynamicObject) {
                    newValue = ((DynamicObject)newValue).get("id");
                }
                JSONObject invoice = JSONObject.parseObject((String)this.getPageCache().get(INVOICE_CACHE_KEY));
                Map invoiceFieldMap = InvoiceCollectField.getInvoiceField((Long)invoice.getLong("invoiceType"));
                if (invoiceFieldMap.containsValue(fieldKey)) {
                    for (Map.Entry invoiceField : invoiceFieldMap.entrySet()) {
                        if (!StringUtils.equals((CharSequence)((CharSequence)invoiceField.getValue()), (CharSequence)fieldKey)) continue;
                        if (((String)invoiceField.getKey()).contains(",")) {
                            String[] stringArray;
                            for (String valueKey : stringArray = ((String)invoiceField.getKey()).split(",")) {
                                invoice.put(valueKey, newValue);
                            }
                            continue;
                        }
                        invoice.put((String)invoiceField.getKey(), newValue);
                    }
                }
                this.getPageCache().put(INVOICE_CACHE_KEY, invoice.toJSONString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initView() {
        List<InputInvoiceTypeEnum> detailType;
        this.initHiding();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        logger.info("\u7f16\u8f91\u9884\u89c8\u754c\u9762\u53d1\u7968\u6570\u636e\u521d\u59cb\u5316\uff1a" + customParams);
        Object invoiceBody = customParams.get(INVOICE_CACHE_KEY);
        Object editSerialNo = customParams.get("serialNo");
        JSONObject invoice = new JSONObject();
        if (invoiceBody != null) {
            invoice = JSONObject.parseObject((String)invoiceBody.toString());
            String snapshotUrl = invoice.getString("snapshotUrl");
            String serialNo = invoice.getString("serialNo");
            Map mainMap = this.fpzsInvoiceCollectService.loadMainInvoice(serialNo);
            this.getModel().setValue("invoice_class", mainMap.get("invoiceClassName"));
            String invoiceType = invoice.getString("invoiceType");
            Long type = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoiceType);
            this.setMust(type);
            if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(type)) {
                Map airInvoice = this.fpzsInvoiceCollectService.queryAirInvoice(serialNo);
                BigDecimal bigDecimal = invoice.getBigDecimal("invoiceAmount");
                if (airInvoice != null) {
                    invoice.put("invoiceAmount", airInvoice.get("invoice_amount"));
                } else {
                    invoice.put("invoiceAmount", (Object)bigDecimal);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)snapshotUrl) && snapshotUrl.startsWith("http") && StringUtils.isNotEmpty((CharSequence)serialNo)) {
                String fileCache = CacheHelper.get((String)("FileCache:" + serialNo));
                if (StringUtils.isNotEmpty((CharSequence)fileCache)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u9884\u89c8\u56fe\u7247\u6b63\u5728\u5904\u7406\u4e2d,\u8bf7\u7a0d\u7b49\u7247\u523b..", (String)"InvoiceCollectEditPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                }
                this.setFileInfo(invoice);
            }
        } else if (editSerialNo != null) {
            Map mainDetailMap = this.fpzsInvoiceCollectService.queryInvoiceDynamicObjectBySerialNo(editSerialNo.toString());
            Map mainMap = (Map)mainDetailMap.get("main");
            Long invoiceType = (Long)mainMap.get("invoice_type");
            this.setMust(invoiceType);
            InvoiceConvertService convertService = InvoiceConvertService.newInstance((Long)invoiceType, null);
            Map fileMap = (Map)mainDetailMap.get("file");
            Map bodyMap = (Map)mainDetailMap.get("detail");
            InvoiceConvertService.putAll((Map)mainMap, (Map)fileMap);
            InvoiceConvertService.putAll((Map)mainMap, (Map)bodyMap);
            invoice = convertService.convert(mainMap);
        }
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoice.getString("invoiceType"));
        if (!InvoiceConvertUtils.isVatInvoiceType((Long)invoiceType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
        }
        if (!(detailType = Arrays.asList(InputInvoiceTypeEnum.getDetialType())).contains(InputInvoiceTypeEnum.getInvoiceType((String)invoice.getString("invoiceType")))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"detail_button"});
        }
        invoice.put("invoiceType", (Object)invoiceType);
        if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.encodeIDNumber((JSONObject)invoice, (String)"customerIdentityNum", (int)4);
        } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) {
            InvoiceCheckUtils.encodeIDNumber((JSONObject)invoice, (String)"customerIdentityNum", (int)8);
        }
        this.getPageCache().put("invoiceInit", invoice.toJSONString());
        this.getModel().setValue("invoice_type_combo", (Object)invoiceType);
        Map invoiceFieldMap = InvoiceCollectField.getInvoiceField((Long)invoiceType);
        Boolean editAllowFlag = Boolean.FALSE;
        if (null != customParams.get("editAllow")) {
            editAllowFlag = (Boolean)customParams.get("editAllow");
        } else if (StringUtils.isNotEmpty((CharSequence)invoice.getString("expenseStatus")) && !"1".equals(invoice.getString("expenseStatus"))) {
            editAllowFlag = Boolean.FALSE;
        } else if (!InvoiceConvertUtils.isVatInvoiceType((Long)invoiceType)) {
            editAllowFlag = Boolean.TRUE;
        } else if (InvoiceConvertUtils.isVatInvoiceType((Long)invoiceType) && StringUtils.isNotEmpty((CharSequence)invoice.getString("checkStatus")) && !"1".equals(invoice.getString("checkStatus"))) {
            editAllowFlag = Boolean.TRUE;
        }
        if (invoiceFieldMap != null) {
            List amountField = InvoiceCollectField.getAmountField();
            for (Map.Entry entry : invoiceFieldMap.entrySet()) {
                if (null == this.getControl((String)entry.getValue())) continue;
                this.getView().setVisible(Boolean.TRUE, new String[]{(String)entry.getValue()});
                Boolean encrypt = InvoiceCollectField.encryptField((String)((String)entry.getValue()), (Boolean)editAllowFlag);
                if (((String)entry.getKey()).contains(",")) {
                    String[] valueKeys;
                    for (String valueKey : valueKeys = ((String)entry.getKey()).split(",")) {
                        String fieldValue = invoice.getString(valueKey);
                        if (!StringUtils.isNotEmpty((CharSequence)fieldValue)) continue;
                        if (amountField.contains(valueKey)) {
                            fieldValue = BigDecimalUtil.transToPoint((String)fieldValue, (int)2);
                        }
                        this.getModel().setValue((String)entry.getValue(), encrypt != false ? InvoiceConvertService.encrypt((Object)fieldValue) : fieldValue);
                    }
                } else {
                    Control control;
                    String fieldValue = invoice.getString((String)entry.getKey());
                    if (StringUtils.isNotEmpty((CharSequence)fieldValue) && amountField.contains(entry.getKey())) {
                        fieldValue = BigDecimalUtil.transToPoint((String)fieldValue, (int)2);
                    }
                    if ((control = this.getControl((String)entry.getValue())) instanceof DateEdit) {
                        this.getModel().setValue((String)entry.getValue(), (Object)invoice.getDate((String)entry.getKey()));
                    } else {
                        this.getModel().setValue((String)entry.getValue(), encrypt != false ? InvoiceConvertService.encrypt((Object)fieldValue) : fieldValue);
                    }
                }
                if (editAllowFlag.booleanValue()) continue;
                this.getView().setEnable(Boolean.FALSE, new String[]{(String)entry.getValue()});
            }
            if (!editAllowFlag.booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{submitButton});
                this.getView().setEnable(Boolean.FALSE, new String[]{invoiceTypeCombo});
                HashMap map = new HashMap();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("zh_CN", ResManager.loadKDString((String)"\u6211\u77e5\u9053\u4e86", (String)"InvoiceCollectEditPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                map.put("text", hashMap);
                this.getView().updateControlMetadata("buttonap1", map);
            }
        }
        String snapshotUrl = invoice.getString("snapshotUrl");
        boolean showNoDataFlex = false;
        if (!StringUtils.isBlank((CharSequence)snapshotUrl)) {
            void var11_19;
            String string = invoice.getString("orientation");
            if (StringUtils.isEmpty((CharSequence)string)) {
                String string2 = invoice.getString("rotationAngle");
            }
            this.showInvoiceInfo(snapshotUrl, (String)var11_19, invoice.getString("pixel"), invoice.getString("region"), "2");
        } else {
            String string = invoice.getString("serialNo");
            if (!StringUtils.isBlank((CharSequence)string)) {
                JSONObject fileInfo = this.queryFileInfo(invoice);
                if (StringUtils.isNotEmpty((CharSequence)fileInfo.getString("snapshotUrl"))) {
                    String imageUrl = fileInfo.getString("snapshotUrl");
                    String rotateDeg = invoice.getString("orientation");
                    if (StringUtils.isEmpty((CharSequence)rotateDeg)) {
                        rotateDeg = invoice.getString("rotationAngle");
                    }
                    String region = invoice.getString("region");
                    String pixel = invoice.getString("pixel");
                    this.showInvoiceInfo(imageUrl, rotateDeg, pixel, region, "2");
                } else if (StringUtils.isNotEmpty((CharSequence)fileInfo.getString("pdfUrl"))) {
                    this.showInvoiceInfo(fileInfo.getString("pdfUrl"), null, null, null, "1");
                } else {
                    showNoDataFlex = true;
                    if (InputInvoiceTypeEnum.canGeneratePdf((Long)invoiceType).booleanValue()) {
                        this.isShowCreateImg(Boolean.TRUE);
                    } else {
                        this.getView().setVisible(Boolean.FALSE, new String[]{VIEW_ORIGINAL_FILE});
                    }
                }
            }
        }
        if (showNoDataFlex) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"no_data_flex"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"no_data_flex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{VIEW_ORIGINAL_FILE});
        }
        this.getPageCache().put(INVOICE_CACHE_KEY, invoice.toJSONString());
    }

    private void setMust(Long invoiceType) {
        if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceType)) {
            Map configMap = ImcConfigUtil.getValue((String)"rim_recog_check");
            String otherMust = ImcConfigUtil.getValue((Map)configMap, (String)"other_must", (String)"0");
            if ("1".equals(otherMust)) {
                TextEdit invoiceNo = (TextEdit)this.getControl("invoiceno_11");
                invoiceNo.setMustInput(true);
            } else if ("2".equals(otherMust)) {
                TextEdit invoiceNo = (TextEdit)this.getControl("invoiceno_11");
                invoiceNo.setMustInput(true);
                TextEdit invoiceCode = (TextEdit)this.getControl("invoicecode_11");
                invoiceCode.setMustInput(true);
            }
        }
    }

    private boolean setFileInfo(JSONObject invoice) {
        String serialNo = invoice.getString("serialNo");
        JSONObject fileDynamicObject = this.fpzsInvoiceCollectService.getFileBySerial(serialNo);
        if (null != fileDynamicObject && StringUtils.isNotEmpty((CharSequence)fileDynamicObject.getString("snapshot_url"))) {
            logger.info("\u4ece\u6570\u636e\u5e93\u4e2d\u62c9\u53d6\u5f97\u6587\u4ef6\u4fe1\u606f\u4e3a\uff1a" + fileDynamicObject);
            Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoice.getString("invoiceType"));
            InvoiceConvertService convertService = InvoiceConvertService.newInstance((Long)invoiceType, null);
            Map fileMap = (Map)fileDynamicObject.toJavaObject(Map.class);
            convertService.setFileField(invoice, fileMap);
            return true;
        }
        return false;
    }

    private JSONObject queryFileInfo(JSONObject invoice) {
        JSONObject fileInfo = new JSONObject();
        String serialNo = invoice.getString("serialNo");
        JSONObject fileDynamicObject = this.fpzsInvoiceCollectService.getFileBySerial(serialNo);
        if (null != fileDynamicObject) {
            SnapshotServiceAdapter service;
            JSONObject result;
            fileInfo.put("snapshotUrl", (Object)fileDynamicObject.getString("snapshot_url"));
            fileInfo.put("pdfUrl", (Object)fileDynamicObject.getString("pdf_url"));
            fileInfo.put("ofdUrl", (Object)fileDynamicObject.getString("ofd_url"));
            fileInfo.put("fileHash", (Object)fileDynamicObject.getString("file_hash"));
            if (StringUtils.isEmpty((CharSequence)fileInfo.getString("snapshotUrl")) && (StringUtils.isNotEmpty((CharSequence)fileInfo.getString("pdfUrl")) || StringUtils.isNotEmpty((CharSequence)fileInfo.getString("ofdUrl"))) && (result = (service = new SnapshotServiceAdapter()).updateInvoiceFile(fileInfo.getString("fileHash"), serialNo)) != null && !result.isEmpty()) {
                fileInfo.putAll((Map)result);
            }
            logger.info("\u4ece\u6570\u636e\u5e93\u4e2d\u62c9\u53d6\u5f97\u6587\u4ef6\u4fe1\u606f\u4e3a\uff1a" + fileInfo);
            return fileInfo;
        }
        return fileInfo;
    }

    private void showInvoiceInfo(String url, String rotateDeg, String pixel, String region, String fileType) {
        Map map;
        ArrayList urlList = new ArrayList();
        HashMap<String, String> urlMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            String newUrl;
            MultiTenantService service = new MultiTenantService();
            if (service.isMultiTenant() && (newUrl = service.getLocalUrl(url)) != null) {
                url = newUrl;
            }
            map = UrlServiceUtils.getAttachmentPreviewUrlAndType((String)url);
            urlMap.putAll(map);
        }
        urlMap.put("rotateDeg", rotateDeg);
        urlMap.put("pixel", pixel);
        urlMap.put("region", region);
        urlList.add(urlMap);
        CustomControl customcontrol = (CustomControl)this.getControl("customcontrolap");
        map = new JSONObject();
        map.put("pageId", this.getView().getPageId());
        map.put("list", urlList);
        map.put("showBtn", urlList.size() > 1);
        map.put("flexKey", "#invoice_flex_show");
        map.put("displayFlag", "cuteImage");
        if (StringUtils.equals((CharSequence)fileType, (CharSequence)"1")) {
            map.put("displayFlag", "showOther");
        }
        map.put("time", System.currentTimeMillis());
        customcontrol.setData((Object)map);
    }

    private void isShowCreateImg(Boolean value) {
        this.getView().setVisible(value, new String[]{CREATE_IMAGE_FILE});
        this.getView().setVisible(Boolean.valueOf(value == false), new String[]{VIEW_ORIGINAL_FILE});
    }

    private void initHiding() {
        this.showAttachTab();
        Set allInvoiceField = InvoiceCollectField.getAllInvoiceField();
        this.getView().setVisible(Boolean.FALSE, allInvoiceField.toArray(new String[allInvoiceField.size()]));
    }

    private void showAttachTab() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap_atach"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
        String serialNo = this.getSerialNo();
        if (StringUtils.isNotBlank((CharSequence)serialNo) && this.fpzsInvoiceCollectService.exsitAttachExpenseRelation(serialNo)) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"tab_attach"});
    }

    private String getSerialNo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object invoiceBody = customParams.get(INVOICE_CACHE_KEY);
        Object editSerialNo = customParams.get("serialNo");
        JSONObject invoice = new JSONObject();
        if (invoiceBody != null) {
            invoice = JSONObject.parseObject((String)invoiceBody.toString());
            return invoice.getString("serialNo");
        }
        if (editSerialNo != null) {
            return editSerialNo.toString();
        }
        return null;
    }
}

