/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.BadgeInfo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeUploadEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.AttachConstant;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.helper.ExcelHelper;
import kd.imc.rim.common.invoice.collector.InvoiceCollectField;
import kd.imc.rim.common.invoice.collector.InvoiceCollectPluginService;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.collector.InvoiceCollectTask;
import kd.imc.rim.common.invoice.collector.ScannerService;
import kd.imc.rim.common.invoice.fpzs.ExpenseRelationService;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionCheckTask;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionProgress;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionProgressError;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.license.LicenseFormPlugin;
import kd.imc.rim.common.service.DialogService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.InvoiceConfigUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.ViewUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class InvoiceCollectPlugin
extends LicenseFormPlugin
implements UploadListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(InvoiceCollectPlugin.class);
    private static final String TEMPLATE_DIR = "templates";
    private static final String TEMPLATE_NAME = "\u53d1\u7968\u67e5\u9a8c\u6a21\u677f.xlsx";
    private static final String TEMPLATE_NAME_2 = "\u5168\u7968\u6c60\u5f15\u5165\u6a21\u677f.xlsx";
    private static final String initFlex = "flex_init";
    private static final String toolBarLeft = "function_toolbar_left";
    private static final String toolBarRight = "function_toolbar_right";
    private static final String toolBarExit = "baritemap2";
    private static final String invoiceEditPage = "rim_inv_collect_edit";
    private static final String checkFailPage = "rim_inv_collect_checkfail";
    private static final String excelImportResultPage = "rim_collect_import_result";
    private static final String signPage = "rim_inv_collect_sign";
    private static final String enterPage = "rim_inv_collect_enter";
    private static final String checkFailList = "check_fail_list";
    private static final String excelImportResult = "excel_import_result";
    private static final String customScanner = "custom_scanner";
    private static final String invoiceCard = "invoice_card";
    private static final String uploadSeq = "upload_seq";
    private static final String export = "export";
    private static final String upload_itemKey = "upload_itemKey";
    private InvoiceCollectService invoiceCollectService = new InvoiceCollectService();

    public void registerListener(EventObject e) {
        Toolbar functionToolBarLeft = (Toolbar)this.getControl(toolBarLeft);
        functionToolBarLeft.addUploadListener((UploadListener)this);
        functionToolBarLeft.addItemClickListener((ItemClickListener)this);
        Toolbar functionToolBarRight = (Toolbar)this.getControl(toolBarRight);
        functionToolBarRight.addItemClickListener((ItemClickListener)this);
        Toolbar toolbarap = (Toolbar)this.getControl("toolbarap_1");
        toolbarap.addItemClickListener((ItemClickListener)this);
        CardEntry card = (CardEntry)this.getView().getControl(invoiceCard);
        card.addRowClickListener((RowClickEventListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        if ("clearview".equals(evt.getItemKey())) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvoiceCollectPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InvoiceCollectPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6e05\u7a7a\u540e\u6570\u636e\u5728\u5f53\u524d\u754c\u9762\u65e0\u6cd5\u67e5\u770b\uff0c\u662f\u5426\u786e\u8ba4\u6e05\u7a7a\uff1f", (String)"InvoiceCollectPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("clearviewCallBack"), btnNameMaps);
        } else if ("del_invoice".equals(evt.getItemKey())) {
            HashMap<Integer, String> confirmBtnNameMaps = new HashMap<Integer, String>(2);
            confirmBtnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvoiceCollectPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            confirmBtnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InvoiceCollectPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u540e\u53d1\u7968\u5c06\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"InvoiceCollectPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, new ConfirmCallBackListener("deleteRow"), confirmBtnNameMaps);
        } else if ("clear_invoice".equals(evt.getItemKey())) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvoiceCollectPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InvoiceCollectPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6e05\u7a7a\u540e\u6570\u636e\u5728\u5f53\u524d\u754c\u9762\u65e0\u6cd5\u67e5\u770b\uff0c\u662f\u5426\u786e\u8ba4\u6e05\u7a7a\uff1f", (String)"InvoiceCollectPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("clearCallBack"), btnNameMaps);
        } else if (checkFailList.equals(evt.getItemKey())) {
            JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_INPUT.getCode());
            HashMap<String, Object> customParams = new HashMap<String, Object>(1);
            customParams.put("checkFailArray", this.getPageCache().get("checkFailArray"));
            customParams.put("needUserRelation", businessParam.get((Object)"needUserRelation"));
            FormShowParameter showParameter = this.newPage(checkFailPage, customParams, "checkFailCallback");
            this.getView().showForm(showParameter);
        } else if (excelImportResult.equals(evt.getItemKey())) {
            HashMap<String, Object> customParams = new HashMap<String, Object>(1);
            FormShowParameter showParameter = this.newPage(excelImportResultPage, customParams, "importResultCallback");
            this.getView().showForm(showParameter);
        } else if ("invoice_sign_list".equals(evt.getItemKey())) {
            this.signInvoiceList();
        } else if ("scanner".equals(evt.getItemKey())) {
            CustomControl scannerControl = (CustomControl)this.getControl(customScanner);
            ScannerService.scanner((CustomControl)scannerControl, (String)this.getView().getPageId(), (String)"invoice");
        } else if ("artificial_enter".equals(evt.getItemKey())) {
            HashMap<String, Object> customParams = new HashMap<String, Object>(1);
            JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_INPUT.getCode());
            customParams.put("businessParam", businessParam.toJSONString());
            FormShowParameter showParameter = this.newPage(enterPage, customParams, "enterCallback");
            this.getView().showForm(showParameter);
        } else if ("san_gun".equals(evt.getItemKey())) {
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("rim_san_gun");
            param.setCustomParams((Map)this.getBusinessParam(CollectTypeEnum.PC_SCAN_GUN.getCode()));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_san_gun");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
        } else if ("downloadTemplate_1".equals(evt.getItemKey())) {
            if (InvoiceConfigUtils.isZhCn()) {
                ExcelHelper.downloadTemplate((AbstractFormPlugin)this, (String)TEMPLATE_DIR, (String)TEMPLATE_NAME);
            } else {
                ExcelHelper.downloadTemplate((AbstractFormPlugin)this, (String)TEMPLATE_DIR, (String)"invoicecheck.xlsx");
            }
        } else if ("downloadTemplate_2".equals(evt.getItemKey())) {
            if (InvoiceConfigUtils.isZhCn()) {
                ExcelHelper.downloadTemplate((AbstractFormPlugin)this, (String)TEMPLATE_DIR, (String)TEMPLATE_NAME_2);
            } else {
                ExcelHelper.downloadTemplate((AbstractFormPlugin)this, (String)TEMPLATE_DIR, (String)"invoiceImport.xlsx");
            }
        } else if ("invoice_unsign_list".equals(evt.getItemKey()) || "invoice_unsign".equals(evt.getItemKey())) {
            this.unSignInvoiceList();
        } else if (export.equals(evt.getItemKey())) {
            this.exportList();
        } else if ("import_deduct_excel".equals(evt.getItemKey()) || "import_not_deduct_excel".equals(evt.getItemKey()) || "import_authenticate_excel".equals(evt.getItemKey())) {
            logger.info("\u62b5\u6263\u52fe\u9009/\u4e0d\u62b5\u6263\u52fe\u9009 excel\u5bfc\u5165\uff0cimport_deduct_excel=============");
            this.showImportPage(evt.getItemKey());
        }
    }

    private void showImportPage(String itemKey) {
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("excelType", itemKey);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParams(customParams);
        showParameter.setShowTitle(true);
        showParameter.setFormId("deduct_invoice_import");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "deduction_import_callback");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void exportList() {
        JSONObject cacheJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        if (cacheJson.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5bfc\u51fa\u6570\u636e", (String)"InvoiceCollectPlugin_37", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet("sheet1");
        Row row = sheet.createRow(0);
        Cell cell = row.createCell(0);
        cell.setCellValue(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"InvoiceCollectPlugin_39", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        cell = row.createCell(1);
        cell.setCellValue(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b", (String)"InvoiceCollectPlugin_40", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        cell = row.createCell(2);
        cell.setCellValue(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"InvoiceCollectPlugin_41", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        cell = row.createCell(3);
        cell.setCellValue(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"InvoiceCollectPlugin_42", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        cell = row.createCell(4);
        cell.setCellValue(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"InvoiceCollectPlugin_43", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        cell = row.createCell(5);
        cell.setCellValue(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"InvoiceCollectPlugin_44", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        cell = row.createCell(6);
        cell.setCellValue(ResManager.loadKDString((String)"\u62b5\u6263\u7a0e\u989d", (String)"InvoiceCollectPlugin_45", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        this.setCellValues((Workbook)workbook, sheet, cacheJson);
    }

    private void setCellValues(Workbook workbook, Sheet sheet, JSONObject cacheJson) {
        Throwable throwable;
        int i = 1;
        for (Map.Entry invoice : cacheJson.entrySet()) {
            JSONObject value = (JSONObject)invoice.getValue();
            Long invoiceType = value.getLong("invoiceType");
            if (AttachConstant.ATTACH_LIST_CATEGORY_ID.equals(invoiceType)) continue;
            Row row = sheet.createRow(i);
            Cell cell = row.createCell(0);
            cell.setCellValue((double)i);
            cell = row.createCell(1);
            cell.setCellValue(InputInvoiceTypeEnum.getInvoiceType((Long)value.getLong("invoiceType")).getName());
            cell = row.createCell(2);
            cell.setCellValue(value.getString("invoiceCode"));
            cell = row.createCell(3);
            cell.setCellValue(value.getString("invoiceNo"));
            cell = row.createCell(4);
            cell.setCellValue(value.getString("invoiceDate"));
            cell = row.createCell(5);
            cell.setCellValue(value.getString("totalTaxAmount"));
            cell = row.createCell(6);
            cell.setCellValue(value.getString("totalTaxAmount"));
            ++i;
        }
        byte[] bytes = null;
        try {
            throwable = null;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                workbook.write((OutputStream)os);
                bytes = os.toByteArray();
            }
            catch (Throwable invoiceType) {
                throwable = invoiceType;
                throw invoiceType;
            }
        }
        catch (IOException e1) {
            throw new KDBizException((Throwable)e1, new ErrorCode("0031", ResManager.loadKDString((String)"\u751f\u6210excel\u9519\u8bef", (String)"InvoiceExportService_14", (String)"imc-rim-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        try {
            throwable = null;
            try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
                String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(ResManager.loadKDString((String)"\u53d1\u7968\u7b7e\u6536\u5217\u8868\u6570\u636e.xlsx", (String)"InvoiceCollectPlugin_38", (String)"imc-rim-formplugin", (Object[])new Object[0]), (InputStream)in, 5000);
                PermissionUtils.addTempFilePermission((String)urls, (String)this.getView().getEntityId(), (String)"1O2SPYDXPUDW", (int)5000);
                this.getView().openUrl(urls);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            logger.info("export exception:{}", (Object)e);
        }
    }

    private void unSignInvoiceList() {
        JSONArray signArray = new JSONArray();
        JSONObject signJsons = new JSONObject();
        JSONObject cacheJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        if (cacheJson != null) {
            for (String serialNo : cacheJson.keySet()) {
                JSONObject invoice = cacheJson.getJSONObject(serialNo);
                String invoiceType = invoice.getString("invoiceType");
                if (!kd.bos.util.StringUtils.isNotEmpty((String)serialNo) || !"1".equals(invoice.getString("originalState")) || "0".equals(invoice.getString("isStorage"))) continue;
                JSONObject sign = new JSONObject();
                StringJoiner serialNos = new StringJoiner(",");
                serialNos.add(serialNo);
                int invoiceCount = 1;
                BigDecimal invoiceTotalAmount = BigDecimalUtil.transDecimal((Object)invoice.getString("totalAmount")).setScale(2);
                sign.put("invoiceType", (Object)invoiceType);
                sign.put("invoiceTypeName", (Object)InputInvoiceTypeEnum.getInvoiceType((Long)invoice.getLong("invoiceType")).getName());
                if (null != signJsons.get((Object)invoiceType)) {
                    sign = (JSONObject)signJsons.get((Object)invoiceType);
                    invoiceTotalAmount = invoiceTotalAmount.add(sign.getBigDecimal("invoiceTotalAmount")).setScale(2);
                    invoiceCount += sign.getInteger("invoiceCount").intValue();
                    serialNos.add(sign.getString("serialNos"));
                }
                sign.put("invoiceTotalAmount", (Object)invoiceTotalAmount);
                sign.put("invoiceCount", (Object)invoiceCount);
                sign.put("serialNos", (Object)serialNos.toString());
                signJsons.put(invoiceType, (Object)sign);
            }
        }
        for (String invoiceType : signJsons.keySet()) {
            JSONObject signJson = signJsons.getJSONObject(invoiceType);
            signArray.add((Object)signJson);
        }
        if (CollectionUtils.isEmpty((Collection)signArray)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53d1\u7968\u53ef\u53cd\u7b7e\u6536!", (String)"InvoiceCollectPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("signArray", signArray.toJSONString());
        customParams.put("status", "0");
        FormShowParameter showParameter = this.newPage(signPage, customParams, "unSignCallback");
        showParameter.setCaption(ResManager.loadKDString((String)"\u53d1\u7968\u53cd\u7b7e\u6536", (String)"InvoiceCollectPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private void signInvoiceList() {
        JSONArray signArray = new JSONArray();
        JSONObject signJsons = new JSONObject();
        JSONObject cacheJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        ArrayList signedList = Lists.newArrayList();
        ArrayList verifyList = Lists.newArrayList();
        String verifySaveFlag = RimConfigUtils.getConfig((String)"verify_save");
        if (cacheJson != null) {
            for (String serialNo : cacheJson.keySet()) {
                JSONObject invoice = cacheJson.getJSONObject(serialNo);
                String invoiceType = invoice.getString("invoiceType");
                if ("1".equals(invoice.getString("originalState"))) {
                    signedList.add(serialNo);
                    continue;
                }
                if ("0".equals(verifySaveFlag) && "0".equals(invoice.getString("errorLevel"))) {
                    verifyList.add(serialNo);
                    continue;
                }
                if (!kd.bos.util.StringUtils.isNotEmpty((String)serialNo) || "1".equals(invoice.getString("originalState")) || "0".equals(invoice.getString("isStorage"))) continue;
                JSONObject sign = new JSONObject();
                StringJoiner serialNos = new StringJoiner(",");
                serialNos.add(serialNo);
                int invoiceCount = 1;
                BigDecimal invoiceTotalAmount = BigDecimalUtil.transDecimal((Object)invoice.getString("totalAmount")).setScale(2);
                sign.put("invoiceType", (Object)invoiceType);
                sign.put("invoiceTypeName", (Object)InputInvoiceTypeEnum.getInvoiceType((Long)invoice.getLong("invoiceType")).getName());
                if (null != signJsons.get((Object)invoiceType)) {
                    sign = (JSONObject)signJsons.get((Object)invoiceType);
                    invoiceTotalAmount = invoiceTotalAmount.add(sign.getBigDecimal("invoiceTotalAmount")).setScale(2);
                    invoiceCount += sign.getInteger("invoiceCount").intValue();
                    serialNos.add(sign.getString("serialNos"));
                }
                sign.put("invoiceTotalAmount", (Object)invoiceTotalAmount);
                sign.put("invoiceCount", (Object)invoiceCount);
                sign.put("serialNos", (Object)serialNos.toString());
                signJsons.put(invoiceType, (Object)sign);
            }
        }
        for (String invoiceType : signJsons.keySet()) {
            JSONObject signJson = signJsons.getJSONObject(invoiceType);
            signArray.add((Object)signJson);
        }
        String tips = "";
        if (signedList.size() > 0 && verifyList.size() > 0) {
            tips = String.format(ResManager.loadKDString((String)"\u5df2\u8fc7\u6ee4\u5df2\u7b7e\u6536\u53d1\u7968%1$s\u5f20,\u5408\u89c4\u6027\u4e25\u683c\u7ba1\u63a7\u4e0d\u5165\u5e93\u53d1\u7968%2$s\u5f20", (String)"InvoiceCollectPlugin_34", (String)"imc-rim-formplugin", (Object[])new Object[0]), signedList.size(), verifyList.size());
        } else if (signedList.size() > 0) {
            tips = String.format(ResManager.loadKDString((String)"\u5df2\u8fc7\u6ee4\u5df2\u7b7e\u6536\u53d1\u7968%1$s\u5f20", (String)"InvoiceCollectPlugin_35", (String)"imc-rim-formplugin", (Object[])new Object[0]), signedList.size());
        } else if (verifyList.size() > 0) {
            tips = String.format(ResManager.loadKDString((String)"\u5df2\u8fc7\u6ee4\u5408\u89c4\u6027\u4e25\u683c\u7ba1\u63a7\u4e0d\u5165\u5e93\u53d1\u7968%1$s\u5f20", (String)"InvoiceCollectPlugin_36", (String)"imc-rim-formplugin", (Object[])new Object[0]), verifyList.size());
        }
        if (CollectionUtils.isEmpty((Collection)signArray)) {
            if (kd.bos.util.StringUtils.isNotEmpty((String)tips)) {
                this.getView().showTipNotification(tips, Integer.valueOf(3000));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53d1\u7968\u53ef\u7b7e\u6536!", (String)"InvoiceCollectPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        customParams.put("signArray", signArray.toJSONString());
        customParams.put("status", "1");
        customParams.put("tipsStr", tips);
        FormShowParameter showParameter = this.newPage(signPage, customParams, "signCallback");
        this.getView().showForm(showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            if ("clearviewCallBack".equals(callBackId)) {
                InvoiceCollectPluginService.setCacheSaleList((String)this.getView().getPageId(), null);
                this.initView();
                CacheHelper.remove((String)"collect_invoice_seq_cache");
            } else if ("clearCallBack".equals(callBackId)) {
                this.operateCustomTable("clearTable");
                CacheHelper.remove((String)"collect_invoice_seq_cache");
            } else if ("downJsScanner".equals(callBackId)) {
                ScannerService.downJsScanner((AbstractFormPlugin)this);
            } else if ("deleteRow".equals(callBackId)) {
                this.operateCustomTable("deleteRow");
            }
        }
    }

    private void deleteRows(String rowsParam) {
        if (kd.bos.util.StringUtils.isEmpty((String)rowsParam)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6240\u5728\u9700\u8981\u5220\u9664\u7684\u5185\u5bb9", (String)"InvoiceCollectPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject json = JSON.parseObject((String)rowsParam);
        JSONArray rowsArray = json.getJSONArray("rows");
        String tableId = json.getString("tableId");
        if (CollectionUtils.isEmpty((Collection)rowsArray)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u53d1\u7968", (String)"InvoiceCollectPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        CustomControl scannerControl = (CustomControl)this.getControl(customScanner);
        JSONObject dataJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        if (dataJson != null) {
            for (int i = 0; i < rowsArray.size(); ++i) {
                JSONObject invoice = dataJson.getJSONObject(rowsArray.getString(i));
                this.extracted(invoice.getString("serialNo"));
                dataJson.remove((Object)rowsArray.getString(i));
            }
            InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)dataJson.toJSONString());
        }
        this.refreshCardEntry();
    }

    private void extracted(String serialNo) {
        boolean delResult = this.invoiceCollectService.delInvoice(serialNo);
        if (!delResult) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25!", (String)"InvoiceCollectPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map callBackData = (Map)closedCallBackEvent.getReturnData();
        if ("editCallback".equals(closedCallBackEvent.getActionId())) {
            if (null == callBackData) {
                return;
            }
            logger.info("\u4fee\u6539\u7ed3\u679c\uff1a" + SerializationUtils.toJsonString((Object)callBackData));
            this.editCallback(callBackData);
        } else if ("checkFailCallback".equals(closedCallBackEvent.getActionId())) {
            if (null == callBackData || null == callBackData.get("checkFailArray")) {
                return;
            }
            JSONArray checkFailArray = (JSONArray)callBackData.get("checkFailArray");
            this.getPageCache().put("checkFailArray", checkFailArray.toJSONString());
            this.refreshToolBarBadgeInfo();
            JSONArray successInvoiceArray = (JSONArray)callBackData.get("successInvoiceArray");
            if (CollectionUtils.isEmpty((Collection)successInvoiceArray)) {
                return;
            }
            int invoiceSize = successInvoiceArray.size();
            for (int invoiceIndex = 0; invoiceIndex < invoiceSize; ++invoiceIndex) {
                JSONObject invoice = successInvoiceArray.getJSONObject(invoiceIndex);
                this.refreshInvoiceDate(invoice);
            }
            this.refreshCardEntry();
        } else if ("signCallback".equals(closedCallBackEvent.getActionId())) {
            if (null != callBackData && null != callBackData.get("serialNos")) {
                String serialNos = (String)callBackData.get("serialNos");
                this.refreshSignStatus(serialNos);
            }
        } else if ("enterCallback".equals(closedCallBackEvent.getActionId())) {
            if (null == callBackData || null == callBackData.get("invoice")) {
                return;
            }
            JSONObject invoice = (JSONObject)callBackData.get("invoice");
            this.verifyById(invoice);
            this.refreshInvoiceDate(invoice);
            this.refreshCardEntry();
        } else if (callBackData != null && "rim_san_gun".equals(closedCallBackEvent.getActionId())) {
            JSONArray checkResults = (JSONArray)callBackData.get("checkResults");
            if (!CollectionUtils.isEmpty((Collection)checkResults)) {
                for (int i = 0; i < checkResults.size(); ++i) {
                    JSONObject checkResult = checkResults.getJSONObject(i);
                    this.verifyById(checkResult);
                    this.refreshInvoiceDate(checkResult);
                    this.refreshCardEntry();
                }
            }
        } else if (callBackData != null && "retryCallback".equals(closedCallBackEvent.getActionId())) {
            JSONArray successData = JSONArray.parseArray((String)callBackData.get("successData").toString());
            logger.info("\u53f0\u8d26\u53d1\u7968\u91c7\u96c6\u91cd\u8bd5\u5904\u7406\u5b8c\u6bd5:" + successData);
            if (successData.size() > 0) {
                int invoiceSize = successData.size();
                for (int invoiceIndex = 0; invoiceIndex < invoiceSize; ++invoiceIndex) {
                    JSONObject invoice = successData.getJSONObject(invoiceIndex);
                    this.verifyById(invoice);
                    this.refreshInvoiceDate(invoice);
                }
                this.refreshCardEntry();
            }
        } else if (callBackData != null && "unSignCallback".equals(closedCallBackEvent.getActionId())) {
            if (kd.bos.util.StringUtils.isNotEmpty((String)MapUtils.getString((Map)callBackData, (Object)"serialNos"))) {
                String serialNos = (String)callBackData.get("serialNos");
                this.refreshUnSignStatus(serialNos);
            }
        } else if ("importResultCallback".equals(closedCallBackEvent.getActionId())) {
            this.refreshToolBarBadgeInfo();
        } else if ("collect_vouch_list".equals(closedCallBackEvent.getActionId())) {
            this.refeshVouchStatus();
        } else if ("deduction_import_callback".equals(closedCallBackEvent.getActionId()) && callBackData != null && kd.bos.util.StringUtils.isNotEmpty((String)MapUtils.getString((Map)callBackData, (Object)"code"))) {
            if ("0000".equals(callBackData.get("code"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u60a8\u8010\u5fc3\u7b49\u5f85!\u60a8\u53ef\u4ee5\u70b9\u51fb\u3010\u67e5\u770b\u53d1\u7968\u5f15\u5165\u7ed3\u679c\u3011\u67e5\u770b\u8fdb\u5ea6\u5e76\u4e0b\u8f7d\u7ed3\u679c!", (String)"InvoiceCollectPlugin_46", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            } else {
                this.getView().showErrorNotification((String)callBackData.get("message"));
            }
        }
    }

    private void refeshVouchStatus() {
        String serials = this.getPageCache().get("vouch_serals");
        if (kd.bos.util.StringUtils.isNotEmpty((String)serials)) {
            List serialNos = CommonUtils.getMultiValues((String)serials);
            QFilter serialFilter = new QFilter("serial_no", "in", (Object)serialNos);
            DynamicObjectCollection invoices = QueryServiceHelper.query((String)"rim_invoice", (String)"serial_no,invoice_info,expense_status", (QFilter[])serialFilter.toArray());
            if (CollectionUtils.isEmpty((Collection)invoices)) {
                return;
            }
            HashMap<String, DynamicObject> statusMap = new HashMap<String, DynamicObject>(invoices.size());
            for (DynamicObject invoice : invoices) {
                statusMap.put(invoice.getString("serial_no"), invoice);
            }
            JSONObject dataJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
            if (dataJson != null) {
                for (Map.Entry entry : dataJson.entrySet()) {
                    String serialNo = (String)entry.getKey();
                    JSONObject invoice = dataJson.getJSONObject(serialNo);
                    if (!serialNos.contains(serialNo)) continue;
                    DynamicObject statusObj = (DynamicObject)statusMap.get(serialNo);
                    String invoice_info = statusObj.getString("invoice_info");
                    invoice.put("invoice_info", (Object)invoice_info);
                    invoice.put("expenseStatus", (Object)statusObj.getString("expense_status"));
                    invoice.put("expendStatus", (Object)statusObj.getString("expense_status"));
                }
                InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)dataJson.toJSONString());
                this.refreshCardEntry();
            }
        }
    }

    private void verifyById(JSONObject invoice) {
        if (invoice == null) {
            return;
        }
        JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_UPLOAD.getCode());
        boolean needUserRelation = !"0".equals(businessParam.getString("needUserRelation"));
        String mainId = invoice.getString("mainId");
        if (kd.bos.util.StringUtils.isNotEmpty((String)mainId)) {
            JSONArray invoiceArray = VerifyUtil.verifyByMainIds(this.getCustomParam(), Stream.of(Long.valueOf(Long.parseLong(mainId))).collect(Collectors.toList()), null, (boolean)true);
            for (int i = 0; i < invoiceArray.size(); ++i) {
                JSONObject info = invoiceArray.getJSONObject(i);
                String level = info.getString("errorLevel");
                String serialNo = info.getString("serialNo");
                VerifyUtil.updateDataStatus((String)level, (String)serialNo, (Long)InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)info.getString("invoiceType")), (Boolean)Boolean.TRUE, (boolean)needUserRelation);
            }
        }
    }

    private void editCallback(Map<String, Object> returnData) {
        Long uploadSeq;
        JSONObject dataJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        if (dataJson == null) {
            dataJson = new JSONObject();
        }
        JSONObject invoice = (JSONObject)returnData.get("invoice");
        String oldSerialNo = (String)returnData.get("oldSerialNo");
        String newSerialNo = invoice.getString("serialNo");
        JSONObject oldInvoice = dataJson.getJSONObject(oldSerialNo);
        if (oldInvoice != null && (uploadSeq = Long.valueOf(BigDecimalUtil.transDecimal((Object)oldInvoice.get((Object)"uploadSeq")).longValue())) >= 0L) {
            invoice.put("uploadSeq", (Object)uploadSeq);
        }
        dataJson.put(newSerialNo, (Object)invoice);
        if (!newSerialNo.equals(oldSerialNo)) {
            dataJson.remove((Object)oldSerialNo);
        }
        InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)dataJson.toJSONString());
        Long mainId = invoice.getLong("mainId");
        if (kd.bos.util.StringUtils.isNotEmpty((String)invoice.getString("serialNo"))) {
            JSONArray invoiceArray = new JSONArray();
            invoiceArray.add((Object)invoice);
            InvoiceCollectPluginService.cacheInvoiceSeqRelation((JSONArray)invoiceArray);
        }
        JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_UPLOAD.getCode());
        Map<String, Object> customParam = this.getCustomParam();
        customParam.put("needUserRelation", businessParam.getString("needUserRelation"));
        InvoiceCollectPluginService.cacheInvoiceList((String)this.getView().getPageId(), customParam, Stream.of(mainId).collect(Collectors.toList()), null, null, (Boolean)Boolean.TRUE, (Boolean)Boolean.TRUE);
        this.refreshCardEntry();
    }

    public void beforeUpload(BeforeUploadEvent evt) {
        this.progressBarVisible(Boolean.TRUE, null);
        long currentTimestamp = new Date().getTime();
        if (!CollectionUtils.isEmpty((Collection)evt.getAttachInfos())) {
            List attachInfos = evt.getAttachInfos();
            LinkedHashMap<String, Long> nameSeqMap = new LinkedHashMap<String, Long>(16);
            for (int i = 0; i < attachInfos.size(); ++i) {
                Map attachMap = (Map)attachInfos.get(i);
                Long timeIndexSeq = currentTimestamp + (long)i;
                nameSeqMap.put(String.valueOf(attachMap.get("name")), timeIndexSeq);
            }
            if (!CollectionUtils.isEmpty(nameSeqMap)) {
                this.getPageCache().put(uploadSeq, SerializationUtils.toJsonString(nameSeqMap));
            }
        }
    }

    private Map<String, Object> getCustomParam() {
        JSONObject json = new JSONObject();
        Long orgId = RequestContext.get().getOrgId();
        Map companyInfo = TenantUtils.getCompanyNameAndTaxNoByOrgId((Long)orgId);
        json.put("orgId", (Object)orgId);
        if (!companyInfo.isEmpty()) {
            ArrayList taxList = new ArrayList(1);
            ArrayList nameList = new ArrayList(1);
            taxList.add(companyInfo.get("taxNo"));
            nameList.add(companyInfo.get("name"));
            json.put("buyer_tax_no", taxList);
            json.put("buyer_name", nameList);
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        json.put("billType", (Object)"invoice_collect");
        if (customParams != null) {
            Object billType = customParams.get("billType");
            if (billType == null) {
                billType = "fpqs";
            }
            json.put("billType", (Object)String.valueOf(billType));
        }
        JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_UPLOAD.getCode());
        json.put("needUserRelation", (Object)businessParam.getString("needUserRelation"));
        logger.info("\u53d1\u7968\u7b7e\u6536\u6821\u9a8c\u53c2\u6570\uff1a" + json);
        return json;
    }

    public void afterUpload(UploadEvent evt) {
        String itemKey = evt.getCallbackKey();
        Object[] urls = evt.getUrls();
        logger.info("\u4e0a\u4f20\u6587\u4ef6:{}-{}", (Object)itemKey, (Object)urls);
        if (urls.length > 0) {
            StringJoiner taskUrls = new StringJoiner(",");
            ArrayList fileUrls = new ArrayList(urls.length);
            String mapSeqStr = this.getPageCache().get(uploadSeq);
            Map nameSeq = new HashMap(urls.length);
            if (kd.bos.util.StringUtils.isNotEmpty((String)mapSeqStr)) {
                nameSeq = (Map)SerializationUtils.fromJsonString((String)mapSeqStr, nameSeq.getClass());
            }
            int n = urls.length;
            for (int i = 0; i < n; ++i) {
                String seq;
                String url = urls[i].toString();
                String fileName = url.substring(url.lastIndexOf(47) + 1);
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put("url", url);
                map.put("name", fileName);
                if (!CollectionUtils.isEmpty(nameSeq) && kd.bos.util.StringUtils.isNotEmpty((String)(seq = String.valueOf(nameSeq.get(fileName))))) {
                    map.put("seq", seq);
                }
                fileUrls.add(map);
            }
            Collections.sort(fileUrls, (o1, o2) -> {
                Long uploadSeq1 = BigDecimalUtil.transDecimal(o1.get("seq")).longValue();
                Long uploadSeq2 = BigDecimalUtil.transDecimal(o2.get("seq")).longValue();
                return uploadSeq1.compareTo(uploadSeq2);
            });
            for (Map map : fileUrls) {
                taskUrls.add((CharSequence)map.get("url"));
            }
            this.getPageCache().put(upload_itemKey, itemKey);
            this.getPageCache().remove(uploadSeq);
            this.getPageCache().put("taskUrls", taskUrls.toString());
            this.progressBarVisible(Boolean.TRUE, new String[]{ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d...", (String)"InvoiceCollectPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0])});
            this.getPageCache().put("startprogress", "true");
            JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_UPLOAD.getCode());
            businessParam.put("itemKey", (Object)itemKey);
            InvoiceCollectTask invoiceCollectTask = new InvoiceCollectTask(RequestContext.get(), this.getView().getPageId(), fileUrls, businessParam);
            ThreadPools.executeOnce((String)"CollectorProgressPool", (Runnable)invoiceCollectTask);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initView();
        CustomControl scannerControl = (CustomControl)this.getControl(customScanner);
        ScannerService.init((CustomControl)scannerControl, (String)this.getView().getPageId());
        RequestContext request = RequestContext.get();
        String userId = request.getUserId();
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_unsign"});
        if (!PermissionUtils.checkPermission((String)userId, (Long)request.getOrgId(), (IFormView)this.getView(), (String)"1PAF60J9M7WZ").booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_upload"});
        }
        if (!PermissionUtils.checkPermission((String)userId, (Long)request.getOrgId(), (IFormView)this.getView(), (String)"2KWI8JKKG+35").booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"import_tax_excel", "baritemap3"});
        }
        if (!PermissionUtils.checkPermission((String)userId, (Long)request.getOrgId(), (IFormView)this.getView(), (String)"1PAF7SR=C+7R").booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"artificial_enter"});
        }
        if (!PermissionUtils.checkPermission((String)userId, (Long)request.getOrgId(), (IFormView)this.getView(), (String)"1PAF9M===5VG").booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"scanner"});
        }
        if (!PermissionUtils.checkPermission((String)userId, (Long)request.getOrgId(), (IFormView)this.getView(), (String)"1PAFDMU3AIX/").booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"san_gun"});
        }
        if (!PermissionUtils.checkPermission((String)userId, (Long)request.getOrgId(), (IFormView)this.getView(), (String)"1VXP9=N6T3O6").booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_sign_list"});
            if (PermissionUtils.checkPermission((String)userId, (Long)request.getOrgId(), (IFormView)this.getView(), (String)"2633TNGWR5RK").booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"invoice_unsign"});
            }
        } else if (!PermissionUtils.checkPermission((String)userId, (Long)request.getOrgId(), (IFormView)this.getView(), (String)"2633TNGWR5RK").booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_unsign_list"});
        }
        if (!PermissionUtils.checkPermission((String)userId, (Long)request.getOrgId(), (IFormView)this.getView(), (String)"232T7GFDOWDW").booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"downloadTemplate_1"});
        }
        if (!PermissionUtils.checkPermission((String)userId, (Long)request.getOrgId(), (String)this.getView().getEntityId(), (String[])new String[]{"1PAFGP5MO1NU", "2KWI8JKKG+35"}).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{excelImportResult});
        }
        if (!PermissionUtils.checkPermission((String)userId, (Long)request.getOrgId(), (IFormView)this.getView(), (String)"1PAFGP5MO1NU").booleanValue() && !PermissionUtils.checkPermission((String)userId, (Long)request.getOrgId(), (IFormView)this.getView(), (String)"2KWI8JKKG+35").booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"downloadTemplate_2"});
        }
        if (!PermissionUtils.checkPermission((String)userId, (Long)request.getOrgId(), (IFormView)this.getView(), (String)"263VK6XB31JH").booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{excelImportResult});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{export});
        String isCollectExport = RimConfigUtils.getConfig((String)"collect_export");
        if ("1".equals(isCollectExport) && PermissionUtils.checkPermission((String)userId, (Long)request.getOrgId(), (IFormView)this.getView(), (String)"1O2SPYDXPUDW").booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{export});
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String key;
        int row = evt.getRow();
        CardEntry cardEntry = (CardEntry)evt.getSource();
        IDataModel model = cardEntry.getModel();
        DynamicObject entryRowEntity = model.getEntryRowEntity(key = cardEntry.getKey(), row);
        if (entryRowEntity == null) {
            return;
        }
        if (invoiceCard.equals(key)) {
            Long invoiceType = entryRowEntity.getLong("card_invoice_type");
            this.refreshInvoiceGrid(invoiceType);
        }
    }

    private void initView() {
        ViewUtil.hideToolbar((AbstractFormPlugin)this, (String[])new String[]{toolBarExit});
        this.getView().setVisible(Boolean.TRUE, new String[]{initFlex});
        this.progressBarVisible(Boolean.FALSE, null);
        this.getModel().deleteEntryData(invoiceCard);
        InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)"{}");
        this.getView().setVisible(Boolean.FALSE, new String[]{"flex_invoice_list"});
        this.getPageCache().put("checkFailArray", "[]");
        this.refreshToolBarBadgeInfo();
    }

    private void refreshToolBarBadgeInfo() {
        Toolbar functionToolBarRight = (Toolbar)this.getControl(toolBarRight);
        JSONArray checkFailArray = JSON.parseArray((String)this.getPageCache().get("checkFailArray"));
        BadgeInfo checkFailInfo = new BadgeInfo();
        checkFailInfo.setOverflowCount(Integer.valueOf(99));
        checkFailInfo.setOffset(new String[]{"-5px", "-5px"});
        checkFailInfo.setDot(false);
        checkFailInfo.setCount(Integer.valueOf(checkFailArray.size()));
        functionToolBarRight.setBadgeInfo(checkFailList, checkFailInfo);
        String fileKey = "excel_file_id" + RequestContext.get().getUserId();
        JSONArray fileResultIds = JSONArray.parseArray((String)CacheHelper.get((String)fileKey));
        int size = 0;
        String userId = RequestContext.get().getUserId();
        if (fileResultIds != null && fileResultIds.size() > 0) {
            for (int i = 0; i < fileResultIds.size(); ++i) {
                JSONObject importResult;
                String fileResultId = fileResultIds.getString(i);
                if (kd.bos.util.StringUtils.isEmpty((String)fileResultId) || kd.bos.util.StringUtils.isBlank((String)CacheHelper.get((String)fileResultId)) || (importResult = JSONObject.parseObject((String)CacheHelper.get((String)fileResultId))) == null || kd.bos.util.StringUtils.isNotEmpty((String)userId) && !userId.equals(importResult.getString("operate_user"))) continue;
                ++size;
            }
        }
        BadgeInfo importResultInfo = new BadgeInfo();
        importResultInfo.setOverflowCount(Integer.valueOf(99));
        importResultInfo.setOffset(new String[]{"-5px", "-5px"});
        importResultInfo.setDot(false);
        importResultInfo.setCount(Integer.valueOf(size));
        functionToolBarRight.setBadgeInfo(excelImportResult, importResultInfo);
    }

    private void refreshInvoiceDate(JSONObject invoice) {
        if (InputInvoiceTypeEnum.needCheck((Long)invoice.getLong("invoiceType")).booleanValue() && (kd.bos.util.StringUtils.isNotEmpty((String)invoice.getString("checkStatus")) && !"1".equals(invoice.getString("checkStatus")) || kd.bos.util.StringUtils.isEmpty((String)invoice.getString("serialNo")))) {
            PageCache page = new PageCache(this.getView().getPageId());
            JSONArray checkFailArray = JSON.parseArray((String)page.get("checkFailArray"));
            boolean isAlive = false;
            int failSize = checkFailArray.size();
            for (int i = 0; i < failSize; ++i) {
                JSONObject checkFailInvoice = checkFailArray.getJSONObject(i);
                if (!kd.bos.util.StringUtils.isNotEmpty((String)checkFailInvoice.getString("serialNo")) || !checkFailInvoice.getString("serialNo").equals(invoice.getString("serialNo"))) continue;
                isAlive = true;
            }
            if (!isAlive) {
                checkFailArray.add((Object)invoice);
            }
            checkFailArray.sort((o1, o2) -> ((JSONObject)o1).getLong("uploadSeq").compareTo(((JSONObject)o2).getLong("uploadSeq")));
            this.getPageCache().put("checkFailArray", checkFailArray.toJSONString());
            logger.info("\u672a\u67e5\u9a8c\u901a\u8fc7\u7684\u53d1\u7968\u5217\u8868\uff1a" + checkFailArray);
            this.refreshToolBarBadgeInfo();
        } else {
            ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
            JSONArray invoiceArray = new JSONArray();
            JSONArray showInvoiceArray = new JSONArray();
            String mainId = invoice.getString("mainId");
            if (kd.bos.util.StringUtils.isNotEmpty((String)mainId)) {
                invoiceIds.add(Long.parseLong(mainId));
                invoiceArray.add((Object)invoice);
            } else {
                showInvoiceArray.add((Object)invoice);
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)invoice.getString("serialNo"))) {
                InvoiceCollectPluginService.cacheInvoiceSeqRelation((JSONArray)invoiceArray);
            }
            InvoiceCollectPluginService.cacheInvoiceList((String)this.getView().getPageId(), this.getCustomParam(), invoiceIds, null, (JSONArray)showInvoiceArray, (Boolean)Boolean.TRUE, (Boolean)Boolean.TRUE);
        }
    }

    private void refreshCardEntry() {
        String pageId = this.getView().getPageId();
        String finishFlag = this.getPageCache().get("finishFlag" + pageId);
        if (kd.bos.util.StringUtils.isEmpty((String)finishFlag)) {
            this.getPageCache().put("finishFlag" + pageId, "1");
            try {
                boolean initFlexFlag = true;
                JSONObject cardEntrys = new JSONObject();
                JSONObject cacheJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
                logger.info("\u5237\u65b0\u5361\u7247\u6570\u5b57\u7684\u7f13\u5b58\u6570\u636e\uff1a{}", (Object)cacheJson);
                if (cacheJson != null) {
                    logger.info("\u5237\u65b0\u5361\u7247\u6570\u5b57\u7684\u7f13\u5b58\u53d1\u7968\u6570\u91cf\uff1a{}", (Object)cacheJson.size());
                    for (String serialNo : cacheJson.keySet()) {
                        JSONObject invoice = cacheJson.getJSONObject(serialNo);
                        String attachUrl = invoice.getString("attach_url");
                        if (kd.bos.util.StringUtils.isNotEmpty((String)attachUrl)) {
                            this.mixSalerListCard(cardEntrys, invoice);
                            continue;
                        }
                        this.mixNormalCard(cardEntrys, invoice);
                    }
                }
                logger.info("\u5237\u65b0\u5361\u7247\u6570\u5b57\u7684\u7f13\u5b58\u6570\u636e2\uff1a{}", (Object)cardEntrys);
                CardEntry card = (CardEntry)this.getControl(invoiceCard);
                this.getModel().deleteEntryData(invoiceCard);
                for (String invoiceType : cardEntrys.keySet()) {
                    JSONObject invoice = cardEntrys.getJSONObject(invoiceType);
                    int index = this.getModel().createNewEntryRow(invoiceCard);
                    if (InvoiceCollectPluginService.typeofsalerlist.toString().equals(invoiceType)) {
                        card.setChildVisible(false, index, new String[]{"cardentryflexpanelap4", "cardentryflexpanelap5", "card_tax_amount", "card_totalamount"});
                        card.setChildVisible(true, index, new String[]{"cardentryflexpanelap"});
                        this.getModel().setValue("card_invoice_type", (Object)InvoiceCollectPluginService.typeofsalerlist, index);
                        this.getModel().setValue("card_invoice_type_name", (Object)ResManager.loadKDString((String)"\u9500\u8d27\u6e05\u5355", (String)"InvoiceCollectPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]), index);
                        this.getModel().setValue("salerlist_count", (Object)invoice.getInteger("salerlist_count"), index);
                    } else {
                        card.setChildVisible(true, index, new String[]{"cardentryflexpanelap4", "cardentryflexpanelap5", "card_tax_amount", "card_totalamount"});
                        card.setChildVisible(false, index, new String[]{"cardentryflexpanelap"});
                        this.getModel().setValue("card_invoice_type", (Object)Long.valueOf(invoiceType), index);
                        this.getModel().setValue("card_invoice_type_name", (Object)invoice.getString("card_invoice_type_name"), index);
                        this.getModel().setValue("card_invoice_count", (Object)invoice.getInteger("card_invoice_count"), index);
                        this.getModel().setValue("card_non_invoice_count", (Object)invoice.getInteger("card_non_invoice_count"), index);
                        this.getModel().setValue("card_totalamount", (Object)invoice.getBigDecimal("card_totalamount"), index);
                        this.getModel().setValue("card_tax_amount", (Object)invoice.getBigDecimal("card_tax_amount"), index);
                        this.getModel().setValue("card_invoiceamount", (Object)invoice.getBigDecimal("card_invoiceamount"), index);
                    }
                    initFlexFlag = false;
                    this.setBackground(Long.valueOf(invoiceType), index);
                }
                this.getView().setVisible(Boolean.valueOf(initFlexFlag), new String[]{initFlex});
                if (initFlexFlag) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flex_invoice_list"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flex_invoice_list"});
                    this.refreshInvoiceGrid(null);
                }
            }
            catch (Exception e) {
                this.getPageCache().remove("finishFlag" + pageId);
            }
            this.getPageCache().remove("finishFlag" + pageId);
        }
    }

    private void mixSalerListCard(JSONObject cardEntrys, JSONObject invoice) {
        int count;
        JSONObject cardEntry = new JSONObject();
        cardEntry.put("card_invoice_type_name", (Object)ResManager.loadKDString((String)"\u9500\u8d27\u6e05\u5355", (String)"InvoiceCollectPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        if (null != cardEntrys.get((Object)InvoiceCollectPluginService.typeofsalerlist.toString())) {
            cardEntry = (JSONObject)cardEntrys.get((Object)InvoiceCollectPluginService.typeofsalerlist.toString());
            count = cardEntry.getInteger("salerlist_count") + 1;
        } else {
            count = 1;
        }
        cardEntry.put("salerlist_count", (Object)count);
        cardEntrys.put(InvoiceCollectPluginService.typeofsalerlist.toString(), (Object)cardEntry);
    }

    private void mixNormalCard(JSONObject cardEntrys, JSONObject invoice) {
        String invoiceType = invoice.getString("invoiceType");
        JSONObject cardEntry = (JSONObject)cardEntrys.get((Object)invoiceType);
        int card_invoice_count = 0;
        int card_non_invoice_count = 0;
        BigDecimal card_totalamount = BigDecimalUtil.transDecimal((Object)invoice.getString("totalAmount")).setScale(2);
        BigDecimal card_tax_amount = BigDecimalUtil.transDecimal((Object)invoice.getString("totalTaxAmount")).setScale(2);
        BigDecimal card_invoiceamount = BigDecimalUtil.transDecimal((Object)invoice.getString("invoiceAmount")).setScale(2);
        if (null != cardEntrys.get((Object)invoiceType)) {
            card_invoice_count = cardEntry.getInteger("card_invoice_count");
            card_non_invoice_count = cardEntry.getInteger("card_non_invoice_count");
            card_totalamount = card_totalamount.add(cardEntry.getBigDecimal("card_totalamount")).setScale(2);
            card_tax_amount = card_tax_amount.add(cardEntry.getBigDecimal("card_tax_amount")).setScale(2);
            card_invoiceamount = card_invoiceamount.add(cardEntry.getBigDecimal("card_invoiceamount")).setScale(2);
        } else {
            cardEntry = new JSONObject();
        }
        cardEntry.put("card_invoice_type_name", (Object)InputInvoiceTypeEnum.getInvoiceType((Long)invoice.getLong("invoiceType")).getName());
        if (!"3".equals(invoice.getString("errorLevel"))) {
            ++card_non_invoice_count;
        } else {
            ++card_invoice_count;
        }
        cardEntry.put("card_totalamount", (Object)card_totalamount);
        cardEntry.put("card_tax_amount", (Object)card_tax_amount);
        cardEntry.put("card_invoiceamount", (Object)card_invoiceamount);
        cardEntry.put("card_invoice_count", (Object)card_invoice_count);
        cardEntry.put("card_non_invoice_count", (Object)card_non_invoice_count);
        cardEntrys.put(invoiceType, (Object)cardEntry);
    }

    private void refreshInvoiceGrid(Long invoiceType) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(invoiceCard);
        int cardEntryRow = 0;
        if (null == invoiceType) {
            if (cardEntry.getSelectRows().length > 0) {
                cardEntryRow = cardEntry.getSelectRows()[0];
            }
            cardEntry.selectRows(cardEntryRow);
        } else {
            cardEntryRow = cardEntry.getSelectRows()[0];
        }
        DynamicObject cardDynamicObject = (DynamicObject)this.getModel().getEntryEntity(invoiceCard).get(cardEntryRow);
        invoiceType = cardDynamicObject.getLong("card_invoice_type");
        JSONObject invoiceJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        InvoiceCollectPluginService.updateInvoiceGrid((AbstractFormPlugin)this, (JSONObject)invoiceJson, (Long)invoiceType);
        if (InvoiceCollectPluginService.typeofsalerlist.equals(invoiceType)) {
            int listCount = cardDynamicObject.getInt("salerlist_count");
            Label list_count = (Label)this.getControl("list_count");
            list_count.setText(String.format(ResManager.loadKDString((String)"\u5171%1$s\u9875\u6e05\u5355", (String)"InvoiceCollectPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]), listCount));
            Label labelap1 = (Label)this.getControl("labelap1");
            labelap1.setText("");
            Label labelap2 = (Label)this.getControl("labelap2");
            labelap2.setText("");
            Label labelap3 = (Label)this.getControl("labelap3");
            labelap3.setText("");
            Label labelap4 = (Label)this.getControl("labelap4");
            labelap4.setText("");
            Label listTotalamount = (Label)this.getControl("list_totalamount");
            listTotalamount.setText("");
            Label listTotaltaxamount = (Label)this.getControl("list_totaltaxamount");
            listTotaltaxamount.setText("");
            Label listInvoiceamount = (Label)this.getControl("list_invoiceamount");
            listInvoiceamount.setText("");
            this.getView().setVisible(Boolean.FALSE, new String[]{"del_invoice"});
        } else {
            int listCount = cardDynamicObject.getInt("card_invoice_count") + cardDynamicObject.getInt("card_non_invoice_count");
            try {
                BigDecimal listTotalAmount = cardDynamicObject.getBigDecimal("card_totalamount");
                BigDecimal listTaxAmount = cardDynamicObject.getBigDecimal("card_tax_amount");
                BigDecimal listInvoiceAmount = cardDynamicObject.getBigDecimal("card_invoiceamount");
                Label list_count = (Label)this.getControl("list_count");
                list_count.setText(String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u53d1\u7968", (String)"InvoiceCollectPlugin_13", (String)"imc-rim-formplugin", (Object[])new Object[0]), listCount));
                Label listTotalamount = (Label)this.getControl("list_totalamount");
                listTotalamount.setText("\uffe5" + listTotalAmount);
                Label listTotaltaxamount = (Label)this.getControl("list_totaltaxamount");
                listTotaltaxamount.setText("\uffe5" + listTaxAmount);
                Label labelap1 = (Label)this.getControl("labelap1");
                labelap1.setText(ResManager.loadKDString((String)"\u5408\u8ba1\u91d1\u989d\uff1a", (String)"InvoiceCollectPlugin_14", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                Label labelap2 = (Label)this.getControl("labelap2");
                labelap2.setText(ResManager.loadKDString((String)"\u5408\u8ba1\u7a0e\u989d\uff1a", (String)"InvoiceCollectPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                Label labelap3 = (Label)this.getControl("labelap3");
                labelap3.setText("|");
                Label labelap4 = (Label)this.getControl("labelap4");
                labelap4.setText("|");
                if (this.isShowInvoiceamount(invoiceType)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"lab1_invoiceamout", "lab2_invoiceamount", "list_invoiceamount"});
                    Label lab1Invoiceamout = (Label)this.getControl("lab1_invoiceamout");
                    lab1Invoiceamout.setText("|");
                    Label lab2Invoiceamount = (Label)this.getControl("lab2_invoiceamount");
                    lab2Invoiceamount.setText(ResManager.loadKDString((String)"\u5408\u8ba1\u4e0d\u542b\u7a0e\u91d1\u989d\uff1a", (String)"InvoiceCollectPlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    Label listInvoiceamount = (Label)this.getControl("list_invoiceamount");
                    listInvoiceamount.setText("\uffe5" + listInvoiceAmount);
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"lab1_invoiceamout", "lab2_invoiceamount", "list_invoiceamount"});
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"del_invoice"});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isShowInvoiceamount(Long invoicetype) {
        return InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoicetype) || InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoicetype) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoicetype) || InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(invoicetype) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoicetype) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoicetype) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoicetype) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoicetype);
    }

    private void setBackground(Long invoiceType, int index) {
        HashMap pmap = new HashMap(2);
        HashMap<String, String> pictureMap = new HashMap<String, String>(2);
        pictureMap.put("bgik", InvoiceCollectField.getIconUrl((Long)invoiceType));
        pmap.put("picturefield", pictureMap);
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        client.invokeControlMethod(invoiceCard, "setCustomProperties", new Object[]{index, pmap});
    }

    private FormShowParameter newPage(String formId, Map<String, Object> customParams, String callBackId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setShowTitle(true);
        showParameter.setCustomParams(customParams);
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (kd.bos.util.StringUtils.isNotEmpty((String)callBackId)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, callBackId);
            showParameter.setCloseCallBack(closeCallBack);
        }
        return showParameter;
    }

    private void refreshSignStatus(String serialNos) {
        JSONObject dataJson;
        if (kd.bos.util.StringUtils.isNotEmpty((String)serialNos) && (dataJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId())) != null) {
            for (Map.Entry entry : dataJson.entrySet()) {
                String serialNo = (String)entry.getKey();
                JSONObject invoice = dataJson.getJSONObject(serialNo);
                if (!serialNos.contains(serialNo)) continue;
                String invoice_info = invoice.getString("invoice_info");
                if (invoice_info.indexOf("or_0") != -1) {
                    invoice_info = invoice_info.replace("or_0", "or_1");
                } else if (invoice_info.indexOf("or_1") == -1) {
                    invoice_info = invoice_info + "or_1,";
                }
                invoice.put("invoice_info", (Object)invoice_info);
                invoice.put("originalState", (Object)"1");
            }
            InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)dataJson.toJSONString());
            this.refreshCardEntry();
        }
    }

    private void refreshUnSignStatus(String serialNos) {
        JSONObject dataJson;
        if (kd.bos.util.StringUtils.isNotEmpty((String)serialNos) && (dataJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId())) != null) {
            for (Map.Entry entry : dataJson.entrySet()) {
                String serialNo = (String)entry.getKey();
                JSONObject invoice = dataJson.getJSONObject(serialNo);
                if (!serialNos.contains(serialNo)) continue;
                String invoice_info = invoice.getString("invoice_info");
                if (invoice_info.indexOf("or_1") != -1) {
                    invoice_info = invoice_info.replace("or_1", "or_0");
                } else if (invoice_info.indexOf("or_0") == -1) {
                    invoice_info = invoice_info + "or_0,";
                }
                invoice.put("invoice_info", (Object)invoice_info);
                invoice.put("originalState", (Object)"0");
                invoice.put("originalTime", null);
                invoice.put("receiver", null);
            }
            InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)dataJson.toJSONString());
            this.refreshCardEntry();
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventArgs = e.getEventArgs();
        String pageId = this.getView().getPageId();
        if ("scanner_fail".equals(e.getEventName())) {
            if (ScannerService.scannerFail((AbstractFormPlugin)this, (String)eventArgs)) {
                this.scannerProcess("uploadFinish");
            }
        } else if ("scanner_uploadFinish".equals(e.getEventName())) {
            if (!ScannerService.uploadFinish((String)eventArgs)) {
                this.scannerProcess("uploadFinish");
            }
        } else if ("scanner_success".equals(e.getEventName())) {
            logger.info("\u626b\u63cf\u4eea\uff1a" + eventArgs);
            JSONObject json = JSON.parseObject((String)eventArgs);
            JSONObject data = json.getJSONObject("data");
            String url = data.getString("url");
            String name = data.getString("name");
            JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_SCANNER.getCode());
            businessParam.put("uploadIndex", (Object)ScannerService.getUploadIndex((JSONObject)data));
            ScannerService.recognitionInvoice((String)"collect", (String)this.getView().getPageId(), (String)url, (String)name, (JSONObject)businessParam, null);
        } else if ("datagrid_deleteRow".equals(e.getEventName())) {
            JSONObject json = JSON.parseObject((String)eventArgs);
            JSONArray array = json.getJSONArray("rows");
            if (CollectionUtils.isEmpty((Collection)array)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9700\u8981\u5220\u9664\u7684\u5185\u5bb9", (String)"InvoiceCollectPlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            JSONObject dataJson = InvoiceCollectPluginService.getInvoiceDataCache((String)pageId);
            if (dataJson != null) {
                boolean changeSale = false;
                Map salerListMap = InvoiceCollectPluginService.getCacheSaleList((String)pageId);
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject invoice = dataJson.getJSONObject(array.getString(i));
                    if (invoice != null) {
                        if (AttachConstant.ATTACH_LIST_CATEGORY_ID.equals(invoice.getLong("invoiceType")) && salerListMap != null) {
                            String no = invoice.getString("invoiceCode") + "_" + invoice.getString("invoiceNo");
                            salerListMap.remove(no);
                            changeSale = true;
                        }
                        this.extracted(invoice.getString("serialNo"));
                    }
                    dataJson.remove((Object)array.getString(i));
                }
                if (changeSale) {
                    InvoiceCollectPluginService.setCacheSaleList((String)pageId, (Map)salerListMap);
                }
                InvoiceCollectPluginService.setInvoiceDataCache((String)pageId, (String)dataJson.toJSONString());
            }
            this.refreshCardEntry();
        } else if ("datagrid_clearTable".equals(e.getEventName())) {
            JSONObject json = JSON.parseObject((String)eventArgs);
            String tableId = json.getString("tableId");
            Long invoiceType = Long.valueOf(tableId.substring(tableId.lastIndexOf(95) + 1, tableId.length()));
            JSONObject dataJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
            if (dataJson != null) {
                Iterator iterator = dataJson.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    String serialNo = (String)entry.getKey();
                    JSONObject invoice = dataJson.getJSONObject(serialNo);
                    if (invoiceType.equals(invoice.getLong("invoiceType"))) {
                        this.extracted(invoice.getString("serialNo"));
                        iterator.remove();
                    }
                    if (!AttachConstant.ATTACH_LIST_CATEGORY_ID.equals(invoice.getLong("invoiceType"))) continue;
                    InvoiceCollectPluginService.setCacheSaleList((String)pageId, null);
                }
                InvoiceCollectPluginService.setInvoiceDataCache((String)this.getView().getPageId(), (String)dataJson.toJSONString());
                this.refreshCardEntry();
            }
            CacheHelper.remove((String)"collect_invoice_seq_cache");
        } else if ("datagrid_click".equals(e.getEventName())) {
            JSONObject json = JSON.parseObject((String)eventArgs);
            String clickkey = json.getString("clickkey");
            String serialNo = json.getString("rowkey");
            if ("viewInvoice".equals(clickkey)) {
                this.showInvoiceEdit(serialNo);
            } else if ("openInvoice".equals(clickkey)) {
                this.showExpenseList(serialNo);
            } else if ("viewAttach".equals(clickkey)) {
                String attachNo = json.getString("rowkey");
                this.showAttachView(attachNo);
            }
        } else if ("dialog".equals(e.getEventName())) {
            this.process(eventArgs);
        } else if ("datagrid_confirmDelete".equals(e.getEventName())) {
            JSONObject json = JSON.parseObject((String)eventArgs);
            JSONArray rowsArray = json.getJSONArray("rows");
            String rowsArrayStr = rowsArray.toJSONString();
            this.deleteRows(rowsArrayStr);
        }
    }

    private void showAttachView(String serailNo) {
        if (kd.bos.util.StringUtils.isBlank((String)serailNo)) {
            return;
        }
        JSONObject josn = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        JSONObject obj = josn.getJSONObject(serailNo);
        String attachNo = obj.getString("invoiceCode") + "_" + obj.getString("invoiceNo");
        QFilter attachNofilter = new QFilter("attach_no", "=", (Object)attachNo);
        String attachFields = MetadataUtil.getFields((String)"rim_attach");
        DynamicObjectCollection attachCollection = QueryServiceHelper.query((String)"rim_attach", (String)attachFields, (QFilter[])new QFilter[]{attachNofilter});
        if (CollectionUtils.isEmpty((Collection)attachCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9644\u4ef6\u4fe1\u606f", (String)"InvoiceCollectPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            List attachInfoList = DynamicObjectUtil.dynamicObjectColletction2ListMap((DynamicObjectCollection)attachCollection);
            customParams.put("attachInfoList", attachInfoList);
            customParams.put("viewAttach", "viewAttach");
            showParameter.setCustomParams(customParams);
            showParameter.setFormId("rim_fpzs_attach_edit");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_fpzs_attach_edit");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    private void showExpenseList(String serialNo) {
        if (kd.bos.util.StringUtils.isBlank((String)serialNo)) {
            return;
        }
        QFilter serialNofilter = new QFilter("serial_no", "=", (Object)serialNo);
        DynamicObjectCollection list = QueryServiceHelper.query((String)"rim_expense_relation", (String)"resource,view_page,entityid,expense_id,expense_num,expense_type,create_time,reimbursingid", (QFilter[])new QFilter[]{serialNofilter});
        if (CollectionUtils.isEmpty((Collection)list)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u62a5\u9500\u5355\u4fe1\u606f", (String)"InvoiceCollectPlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else if (list.size() == 1) {
            DynamicObject expense = (DynamicObject)list.get(0);
            String expenseId = expense.getString("expense_id");
            if (!kd.bos.util.StringUtils.isBlank((String)expenseId)) {
                String expenseType = expense.getString("expense_type");
                QFilter qFilters = new QFilter("expense_id", "=", (Object)expenseId);
                ExpenseRelationService expenseRelationService = new ExpenseRelationService();
                DynamicObjectCollection relCollection = expenseRelationService.findByFilter("serial_no", qFilters);
                List<String> serialNos = relCollection.stream().map(c -> c.getString("serial_no")).collect(Collectors.toList());
                this.openInvoceList(expenseType, expenseId, serialNos);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u62a5\u9500\u5355\u8be6\u60c5", (String)"InvoiceCollectPlugin_20", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            List expenseList = DynamicObjectUtil.dynamicObjectColletction2ListMap((DynamicObjectCollection)list);
            customParams.put("expense", expenseList);
            customParams.put("openInvoice", "openInvoice");
            showParameter.setCustomParams(customParams);
            showParameter.setFormId("rim_expense_list");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_expense_list");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    private void openInvoceList(String expenseType, String expenseId, List<String> serialList) {
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("billType", expenseType);
        customParams.put("expenseId", expenseId);
        customParams.put("resource", "\u53d1\u7968\u52a9\u624b4");
        customParams.put("serialList", serialList);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("rim_view_invoice");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_view_invoice");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private JSONObject getBusinessParam(String collectType) {
        JSONObject businessParam = new JSONObject();
        IPageCache pageCache = this.getView().getPageCache();
        String businessParamCache = pageCache.get("businessParam");
        if (businessParamCache != null) {
            businessParam = JSON.parseObject((String)businessParamCache);
        } else {
            boolean isCollectOwner;
            long orgId;
            boolean isAutoSign;
            RequestContext request = RequestContext.get();
            businessParam.put("collect_type", (Object)collectType);
            businessParam.put("resource", (Object)"\u6536\u7968\u7ba1\u7406");
            businessParam.put("isAdmin", (Object)PermissionUtils.checkPermission((String)request.getUserId(), (Long)request.getOrgId(), (IFormView)this.getView(), (String)"1PAFGP5MO1NU"));
            String state = RimConfigUtils.getConfig((String)"original_state");
            if ("1".equals(state)) {
                businessParam.put("originalState", (Object)"1");
            }
            if (isAutoSign = SysParamUtil.getSysParamByOrgId((Long)(orgId = RequestContext.get().getOrgId()), (String)"is_autosign")) {
                boolean isHit = SysParamUtil.isHitValue((long)orgId, (String)"autosign_config", (String)"1");
                if (isHit) {
                    businessParam.put("originalState", (Object)"1");
                } else {
                    businessParam.remove((Object)"originalState");
                }
            }
            if (isCollectOwner = SysParamUtil.getSysParamByOrgId((Long)orgId, (String)"is_collectowner")) {
                boolean isHit = SysParamUtil.isHitValue((long)orgId, (String)"collectowner_config", (String)"1");
                if (!isHit) {
                    businessParam.put("needUserRelation", (Object)"0");
                }
            } else {
                businessParam.put("needUserRelation", (Object)"0");
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (!CollectionUtils.isEmpty((Map)customParams)) {
                businessParam.putAll(customParams);
            }
            businessParam.put("billType", (Object)"fpqs");
            pageCache.put("businessParam", businessParam.toJSONString());
        }
        InvoiceCollectService collect = new InvoiceCollectService();
        Map custom = collect.addCustomField((AbstractFormPlugin)this);
        if (custom != null) {
            businessParam.putAll(custom);
        }
        logger.info("\u53d1\u7968\u7b7e\u6536\u91c7\u96c6\u53c2\u6570:" + businessParam);
        return businessParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scannerProcess(String type) {
        String pageId = this.getView().getPageId();
        try (DLock lock = DLock.create((String)("scannerProcess" + pageId), (String)ResManager.loadKDString((String)"\u5237\u65b0\u5361\u7247\u9501", (String)"InvoiceCollectPlugin_21", (String)"imc-rim-formplugin", (Object[])new Object[0]));){
            int times = 0;
            String dialogId = "scanner";
            while (times < 30) {
                ++times;
                if (!lock.tryLock(500L)) continue;
                times = 100;
                JSONObject result = RecognitionCheckTask.queryCacheFile((String)pageId);
                try {
                    CustomControl customcontrol = (CustomControl)this.getControl("progressBar_customcontrol");
                    DialogService service = new DialogService(customcontrol);
                    Set urlSet = result.keySet();
                    Iterator it = urlSet.iterator();
                    int waiting = 0;
                    int fail = 0;
                    int dealCount = 0;
                    while (it.hasNext()) {
                        String url = (String)it.next();
                        String status = result.getString(url);
                        if ("waiting".equals(status)) {
                            ++waiting;
                            continue;
                        }
                        if ("success".equals(status)) {
                            JSONArray invoiceArray = RecognitionCheckTask.queryCacheFileResult((String)url);
                            if (!invoiceArray.isEmpty()) {
                                RecognitionCheckTask.saveCacheFileResult((String)url, null);
                                int invoiceSize = invoiceArray.size();
                                for (int invoiceIndex = 0; invoiceIndex < invoiceSize; ++invoiceIndex) {
                                    JSONObject invoice = invoiceArray.getJSONObject(invoiceIndex);
                                    logger.info("\u626b\u63cf\u4eea\u8bc6\u522b\u9884\u89c8\u53d1\u7968\uff1a" + invoice);
                                    this.refreshInvoiceDate(invoice);
                                    ++dealCount;
                                }
                                continue;
                            }
                            logger.info("\u6570\u636e\u7ed3\u679c\u4e3a\u7a7a:" + url);
                            continue;
                        }
                        if (!"fail".equals(status)) continue;
                        ++fail;
                    }
                    if (dealCount > 0) {
                        this.refreshCardEntry();
                    }
                    int total = result.size();
                    if ("dialog".equals(type) && (total == 0 || waiting == 0)) {
                        logger.info("scannerProcess2:" + total + type + waiting + result);
                        if (total > 0) {
                            RecognitionCheckTask.clearCacheFile((String)pageId);
                        }
                        if (fail > 0) {
                            Set urlSet2 = result.keySet();
                            Iterator it2 = urlSet2.iterator();
                            JSONArray retryArray = new JSONArray();
                            while (it2.hasNext()) {
                                String url = (String)it2.next();
                                String status = result.getString(url);
                                if (!"fail".equals(status)) continue;
                                JSONObject retry = new JSONObject();
                                retry.put("fileUrl", (Object)url);
                                retry.put("fileName", (Object)url.substring(url.lastIndexOf(47) + 1, url.length()));
                                retry.put("failDescription", (Object)ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"InvoiceCollectPlugin_22", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                                retryArray.add((Object)retry);
                            }
                            if (!retryArray.isEmpty()) {
                                HashMap<String, Object> customParams = new HashMap<String, Object>(4);
                                customParams.put("retryArray", retryArray);
                                JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_SCANNER.getCode());
                                customParams.put("businessParam", businessParam);
                                FormShowParameter showParameter = this.newPage("rim_inv_recognition_retry", customParams, "retryCallback");
                                showParameter.setCaption(ResManager.loadKDString((String)"\u8bc6\u522b\u5931\u8d25\u91cd\u8bd5\u5217\u8868", (String)"InvoiceCollectPlugin_23", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                                this.getView().showForm(showParameter);
                            }
                        }
                        if (total > 0 && fail > 0) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0a\u4f20%1$s\u4e2a\u6587\u4ef6\uff0c\u5904\u7406\u5931\u8d25%2$s\u4e2a", (String)"InvoiceCollectPlugin_24", (String)"imc-rim-formplugin", (Object[])new Object[0]), total, fail), Integer.valueOf(10000));
                        } else if (total > 0) {
                            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u4e0a\u4f20%1$s\u4e2a\u6587\u4ef6\uff0c\u5904\u7406\u6210\u529f%2$s\u4e2a", (String)"InvoiceCollectPlugin_25", (String)"imc-rim-formplugin", (Object[])new Object[0]), total, total, 10000));
                        }
                        service.hide();
                        continue;
                    }
                    String countMsg = total - waiting + "/" + total;
                    String[] content = new String[]{String.format(ResManager.loadKDString((String)"\u5f85\u5904\u7406\u6587\u4ef6\u5269\u4f59%1$s\u4e2a", (String)"InvoiceCollectPlugin_26", (String)"imc-rim-formplugin", (Object[])new Object[0]), waiting), String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u4e2d(%1$s)", (String)"InvoiceCollectPlugin_32", (String)"imc-rim-formplugin", (Object[])new Object[0]), countMsg)};
                    service.show(dialogId, content, 1000);
                }
                catch (Exception e) {
                    logger.error("\u5904\u7406\u626b\u63cf\u4eea\u7ed3\u679c\u5931\u8d25:", (Throwable)e);
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    private void progressBarVisible(Boolean visibleFlag, String[] descriptionArray) {
        CustomControl customcontrol = (CustomControl)this.getControl("progressBar_customcontrol");
        DialogService service = new DialogService(customcontrol);
        if (visibleFlag.booleanValue()) {
            if (null != descriptionArray) {
                service.show("1", descriptionArray, 500);
            } else {
                service.show("1", new String[]{ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d...", (String)"InvoiceCollectPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0])}, 500);
            }
        } else {
            service.hide();
        }
    }

    private void showInvoiceEdit(String serialNo) {
        FormShowParameter param = new FormShowParameter();
        param.setCaption(ResManager.loadKDString((String)"\u53d1\u7968\u9884\u89c8", (String)"InvoiceCollectPlugin_28", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        JSONObject cacheJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        JSONObject invoiceJson = cacheJson.getJSONObject(serialNo);
        if (ObjectUtils.isEmpty((Object)invoiceJson)) {
            Map mainDetailMap = VerifyUtil.queryInvoiceDynamicObjectBySerialNo((String)serialNo);
            DynamicObject detail = (DynamicObject)mainDetailMap.get("detail");
            invoiceJson = JSON.parseObject((String)JSON.toJSONString((Object)detail));
        }
        this.setInvoiceFiled(invoiceJson);
        int invoiceIndex = 0;
        customParams.put("invoice", invoiceJson);
        customParams.put("row", invoiceIndex);
        if (InvoiceCollectPluginService.canEdit((JSONObject)invoiceJson).booleanValue()) {
            customParams.put("editAllow", Boolean.TRUE);
            param.setCaption(ResManager.loadKDString((String)"\u53d1\u7968\u7f16\u8f91", (String)"InvoiceCollectPlugin_29", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_INPUT.getCode());
        invoiceJson.put("needUserRelation", (Object)businessParam.getString("needUserRelation"));
        invoiceJson.put("org_id", (Object)businessParam.getString("org_id"));
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId(invoiceEditPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "editCallback");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm(param);
    }

    private void setInvoiceFiled(JSONObject invoiceJson) {
        String serialNo = invoiceJson.getString("serialNo");
        if (StringUtils.isBlank((CharSequence)serialNo)) {
            return;
        }
        InvoiceQueryService invoiceQueryService = new InvoiceQueryService();
        QFilter qFilter = new QFilter("serial_no", "=", (Object)serialNo);
        DynamicObjectCollection collection = invoiceQueryService.findByFilter("collect_type", qFilter);
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            invoiceJson.put("collect_type", (Object)((DynamicObject)collection.get(0)).getString("collect_type"));
        }
    }

    private void operateCustomTable(String operate) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(invoiceCard);
        int cardEntryRow = cardEntry.getSelectRows()[0];
        DynamicObject cardDynamicObject = (DynamicObject)this.getModel().getEntryEntity(invoiceCard).get(cardEntryRow);
        Long invoiceType = cardDynamicObject.getLong("card_invoice_type");
        CustomControl customInvoiceControl = (CustomControl)this.getControl("custom_invoice");
        JSONObject map = new JSONObject();
        map.put("operate", (Object)operate);
        map.put("tableId", (Object)(this.getView().getPageId() + "_customInvoice_" + invoiceType));
        map.put("time", (Object)System.currentTimeMillis());
        customInvoiceControl.setData((Object)map);
    }

    private void process(String eventArgs) {
        block21: {
            if (eventArgs != null && eventArgs.indexOf("scanner") >= 0) {
                this.scannerProcess("dialog");
                return;
            }
            String startProgress = this.getPageCache().get("startprogress");
            if (kd.bos.util.StringUtils.isBlank((String)startProgress)) {
                this.progressBarVisible(Boolean.FALSE, null);
                return;
            }
            String pageId = this.getView().getPageId();
            try (DLock lock = DLock.create((String)("collectProcess" + pageId), (String)"refreshCardLock");){
                if (!lock.tryLock()) break block21;
                int progress = 0;
                String cacheProgress = this.getPageCache().get("progress");
                RecognitionProgress recognitionProgress = null;
                if (kd.bos.util.StringUtils.isNotEmpty((String)cacheProgress)) {
                    logger.info("\u8fdb\u5ea6\u7ed3\u679c\uff1a" + cacheProgress);
                    try {
                        recognitionProgress = (RecognitionProgress)JSON.parseObject((String)cacheProgress, RecognitionProgress.class);
                    }
                    catch (Exception e1) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u8f6c\u6362\u5bf9\u8c61\u5f02\u5e38", (String)"InvoiceCollectPlugin_30", (String)"imc-rim-formplugin", (Object[])new Object[0]), cacheProgress));
                    }
                }
                if (recognitionProgress != null) {
                    progress = recognitionProgress.getProgress();
                    String handleUrl = recognitionProgress.getHandleUrl();
                    int handleUrlIndex = recognitionProgress.getHandleUrlIndex();
                    int handleUrlSize = recognitionProgress.getHandleUrlSize();
                    handleUrlSize = handleUrlSize == 0 ? 1 : handleUrlSize;
                    int unHandleSize = recognitionProgress.getUnHandleSize();
                    int handleSize = recognitionProgress.getHandleSize();
                    if (kd.bos.util.StringUtils.isNotEmpty((String)handleUrl)) {
                        String countMsg = handleSize - unHandleSize + "/" + handleSize;
                        String[] descriptionArray = new String[]{String.format(ResManager.loadKDString((String)"\u5f85\u5904\u7406\u6587\u4ef6\u5269\u4f59%1$s\u4e2a", (String)"InvoiceCollectPlugin_26", (String)"imc-rim-formplugin", (Object[])new Object[0]), unHandleSize), String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u4e2d(%1$s)", (String)"InvoiceCollectPlugin_32", (String)"imc-rim-formplugin", (Object[])new Object[0]), countMsg)};
                        this.progressBarVisible(Boolean.TRUE, descriptionArray);
                    }
                }
                String taskUrls = this.getPageCache().get("taskUrls");
                if (progress >= 100 && kd.bos.util.StringUtils.isEmpty((String)taskUrls)) {
                    this.finishDialog(recognitionProgress);
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)taskUrls)) {
                    this.loadFileResult(taskUrls);
                }
            }
        }
    }

    private void finishDialog(RecognitionProgress recognitionProgress) {
        String checkFailArray;
        if (null != recognitionProgress && null != recognitionProgress.getRecognitionProgressErrors() && recognitionProgress.getRecognitionProgressErrors().size() > 0) {
            List recognitionProgressErrors = recognitionProgress.getRecognitionProgressErrors();
            recognitionProgress.setRecognitionProgressErrors(null);
            this.getPageCache().put("progress", JSONObject.toJSONString((Object)recognitionProgress));
            JSONArray retryArray = new JSONArray();
            for (RecognitionProgressError error : recognitionProgressErrors) {
                String errUrl = error.getUrl();
                String fileName = errUrl.substring(errUrl.lastIndexOf(47) + 1, errUrl.length());
                if (FileUtils.isExcel((String)fileName)) {
                    if (!kd.bos.util.StringUtils.isEmpty((String)error.getDescription())) {
                        this.getView().showErrorNotification(error.getDescription());
                    }
                    if (kd.bos.util.StringUtils.isEmpty((String)error.getTipDescription())) continue;
                    this.getView().showTipNotification(error.getTipDescription());
                    continue;
                }
                String retryStr = this.getPageCache().get(fileName);
                if (kd.bos.util.StringUtils.isNotEmpty((String)retryStr)) {
                    JSONArray cacheArray = JSON.parseArray((String)retryStr);
                    retryArray.addAll((Collection)cacheArray);
                    this.getPageCache().remove(fileName);
                }
                if (!kd.bos.util.StringUtils.isEmpty((String)retryStr)) continue;
                JSONObject retry = new JSONObject();
                retry.put("fileUrl", (Object)errUrl);
                retry.put("fileName", (Object)errUrl.substring(errUrl.lastIndexOf(47) + 1, errUrl.length()));
                retry.put("failDescription", (Object)error.getDescription());
                retryArray.add((Object)retry);
            }
            JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_UPLOAD.getCode());
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put("retryArray", retryArray);
            customParams.put("businessParam", businessParam);
            FormShowParameter showParameter = this.newPage("rim_inv_recognition_retry", customParams, "retryCallback");
            showParameter.setCaption(ResManager.loadKDString((String)"\u8bc6\u522b\u5931\u8d25\u91cd\u8bd5\u5217\u8868", (String)"InvoiceCollectPlugin_23", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            if (!CollectionUtils.isEmpty((Collection)retryArray)) {
                this.getView().showForm(showParameter);
            }
        }
        logger.info("\u53f0\u8d26\u53d1\u7968\u91c7\u96c6:\u8bc6\u522b\u67e5\u9a8c\u7ed3\u679c\u5904\u7406\u5b8c\u6bd5\uff1a" + JSONObject.toJSONString((Object)recognitionProgress));
        this.getPageCache().remove("progress");
        this.getPageCache().remove("taskUrls");
        String itemKey = this.getPageCache().get(upload_itemKey);
        if (kd.bos.util.StringUtils.isNotEmpty((String)itemKey)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{itemKey});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_upload"});
        }
        this.progressBarVisible(Boolean.FALSE, null);
        String failedInvoiceStr = this.getPageCache().get("failed_invoice");
        if (kd.bos.util.StringUtils.isNotEmpty((String)failedInvoiceStr)) {
            FormShowParameter failedListForm = new FormShowParameter();
            failedListForm.setFormId("rim_inv_import_fail");
            failedListForm.setCustomParam("invoiceFailedList", (Object)failedInvoiceStr);
            failedListForm.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(failedListForm);
            this.getPageCache().remove("failed_invoice");
        }
        this.refreshToolBarBadgeInfo();
        String saleListArray = this.getPageCache().get("saleListArray");
        if (kd.bos.util.StringUtils.isNotEmpty((String)saleListArray)) {
            this.getPageCache().remove("saleListArray");
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(checkFailArray = this.getPageCache().get("checkFailArray")))) {
            JSONArray invoiceArray = JSON.parseArray((String)checkFailArray);
            ArrayList serialNos = Lists.newArrayList();
            for (int i = 0; i < invoiceArray.size(); ++i) {
                serialNos.add(invoiceArray.getJSONObject(i).getString("serialNo"));
            }
            if (serialNos.size() > 0) {
                JSONArray verifyInvoiceArray = VerifyUtil.verifyBySerialNos(this.getCustomParam(), (List)serialNos, (boolean)true);
                logger.info("invoiceCollectPlugin verifyInvoiceArray:{}", (Object)verifyInvoiceArray);
                JSONObject businessParam = this.getBusinessParam(CollectTypeEnum.PC_INPUT.getCode());
                boolean needUserRelation = !"0".equals(businessParam.getString("needUserRelation"));
                for (int i = 0; i < verifyInvoiceArray.size(); ++i) {
                    String level = verifyInvoiceArray.getJSONObject(i).getString("errorLevel");
                    String serialNo = verifyInvoiceArray.getJSONObject(i).getString("serialNo");
                    String type = verifyInvoiceArray.getJSONObject(i).getString("invoiceType");
                    Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)type);
                    VerifyUtil.updateDataStatus((String)level, (String)serialNo, (Long)invoiceType, (Boolean)Boolean.TRUE, (boolean)needUserRelation);
                }
            }
        }
    }

    private void loadFileResult(String taskUrls) {
        logger.info("loadFileResult taskUrls:{}", (Object)taskUrls);
        String[] urls = taskUrls.split(",");
        JSONArray invoiceArray = new JSONArray();
        JSONArray retryArray = new JSONArray();
        ArrayList<String> watingUrl = new ArrayList<String>(urls.length);
        for (String url : urls) {
            String resultFile = this.getPageCache().get("exportResult_" + url);
            if (kd.bos.util.StringUtils.isNotEmpty((String)resultFile)) {
                this.getView().openUrl(resultFile);
                this.getView().getPageCache().remove("exportResult_" + url);
            }
            String fileName = url.substring(url.lastIndexOf(47) + 1, url.length());
            String taskResultSize = this.getPageCache().get("task_" + url);
            if (kd.bos.util.StringUtils.isNotEmpty((String)taskResultSize)) {
                int consumeSize = Integer.parseInt(taskResultSize);
                int taskIndex = 1;
                String taskHandleIndex = this.getPageCache().get("task_handle_" + url);
                if (kd.bos.util.StringUtils.isNotEmpty((String)taskHandleIndex)) {
                    taskIndex = Integer.parseInt(taskHandleIndex);
                }
                invoiceArray.clear();
                String taskResult = this.getPageCache().get("task_" + url + "_" + taskIndex);
                String failedResult = this.getPageCache().get("failed_task_" + url + "_" + taskIndex);
                logger.info(taskResultSize + "\u53f0\u8d26\u53d1\u7968\u91c7\u96c6:" + fileName + "\u7b2c" + taskIndex + "\u9875\u8bc6\u522b\u67e5\u9a8c\u5904\u7406\u4e2d:" + taskResult);
                if (kd.bos.util.StringUtils.isNotEmpty((String)taskResult)) {
                    invoiceArray = JSON.parseArray((String)taskResult);
                    logger.info(taskResultSize + "\u53f0\u8d26\u53d1\u7968\u91c7\u96c6:" + fileName + "\u7b2c" + taskIndex + "\u9875\u8bc6\u522b\u67e5\u9a8c\u7ed3\u679c\u5904\u7406\u5f00\u59cb\uff1a" + invoiceArray);
                    this.getPageCache().remove("task_" + url + "_" + taskIndex);
                    this.getPageCache().put("task_handle_" + url, taskIndex + 1 + "");
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)failedResult)) {
                    JSONArray invoiceFailedResultArray = JSONArray.parseArray((String)failedResult);
                    String cachedFailedInvoice = this.getPageCache().get("failed_invoice");
                    if (kd.bos.util.StringUtils.isNotEmpty((String)cachedFailedInvoice)) {
                        JSONArray cachedFailedInvoiceArray = JSONArray.parseArray((String)cachedFailedInvoice);
                        invoiceFailedResultArray.addAll((Collection)cachedFailedInvoiceArray);
                    }
                    this.getPageCache().put("failed_invoice", invoiceFailedResultArray.toJSONString());
                }
                if (!CollectionUtils.isEmpty((Collection)invoiceArray)) {
                    retryArray.clear();
                    int invoiceSize = invoiceArray.size();
                    for (int invoiceIndex = 0; invoiceIndex < invoiceSize; ++invoiceIndex) {
                        JSONObject invoice = invoiceArray.getJSONObject(invoiceIndex);
                        Object isFalse = invoice.get((Object)"isFalse");
                        if (isFalse != null) {
                            JSONObject retry = new JSONObject();
                            String errUrl = invoice.getString("pageUrl");
                            retry.put("fileUrl", (Object)errUrl);
                            retry.put("fileName", (Object)errUrl.substring(errUrl.lastIndexOf(47) + 1, errUrl.length()));
                            String pageIndex = invoice.getString("pageIndex");
                            StringBuilder description = new StringBuilder();
                            description.append(fileName).append('\u7b2c').append(pageIndex).append(ResManager.loadKDString((String)"\u9875\u8bc6\u522b\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5", (String)"InvoiceCollectPlugin_31", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                            retry.put("failDescription", (Object)description.toString());
                            retryArray.add((Object)retry);
                            String retryArrayStr = this.getPageCache().get(fileName);
                            if (!kd.bos.util.StringUtils.isEmpty((String)retryArrayStr)) {
                                JSONArray cacheRetry = JSON.parseArray((String)retryArrayStr);
                                retryArray.addAll((Collection)cacheRetry);
                            }
                            this.getPageCache().put(fileName, retryArray.toJSONString());
                            continue;
                        }
                        invoice.put("invoiceMessage", (Object)invoice.getString("invoice_info"));
                        this.refreshInvoiceDate(invoice);
                    }
                    this.refreshCardEntry();
                    logger.info(taskResultSize + "\u53f0\u8d26\u53d1\u7968\u91c7\u96c6:" + fileName + "\u7b2c" + taskIndex + "\u9875\u8bc6\u522b\u67e5\u9a8c\u7ed3\u679c\u5904\u7406\u5b8c\u6bd5:" + invoiceArray);
                }
                if (consumeSize == 0 || taskIndex > consumeSize) {
                    this.getPageCache().remove("task_" + url);
                    this.getPageCache().remove("task_handle_" + url);
                    if (taskUrls.indexOf(44) != -1) {
                        int sort = taskUrls.indexOf(44) + 1;
                        taskUrls = taskUrls.substring(sort);
                        this.getPageCache().put("taskUrls", taskUrls);
                        continue;
                    }
                    this.getPageCache().remove("taskUrls");
                    this.getView().setEnable(Boolean.TRUE, new String[]{"btn_upload"});
                    continue;
                }
                watingUrl.add(url);
                continue;
            }
            watingUrl.add(url);
        }
        if (watingUrl.isEmpty()) {
            this.getPageCache().remove("taskUrls");
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_upload"});
        } else {
            this.getPageCache().put("taskUrls", String.join((CharSequence)",", watingUrl));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("add_voucher".equals(operateKey)) {
            this.addVoucher();
        }
    }

    private void addVoucher() {
        JSONObject cacheJson = InvoiceCollectPluginService.getInvoiceDataCache((String)this.getView().getPageId());
        if (cacheJson != null && !cacheJson.isEmpty()) {
            Set serialNos = cacheJson.keySet();
            QFilter serialFilter = new QFilter("serial_no", "in", (Object)serialNos);
            DynamicObjectCollection invoices = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_type,invoice_code,invoice_no,vouch_no,total_amount", (QFilter[])serialFilter.toArray());
            if (CollectionUtils.isEmpty((Collection)invoices)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5df2\u5165\u5e93\u7684\u6570\u636e", (String)"InvoiceCollectPlugin_33", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            List vouchList = DynamicObjectUtil.dynamicObjectColletction2ListMap((DynamicObjectCollection)invoices);
            customParams.put("vouch", vouchList);
            Set serial_nos = invoices.stream().map(s -> s.getString("serial_no")).collect(Collectors.toSet());
            String serials = String.join((CharSequence)",", serial_nos);
            customParams.put("serials", serials);
            this.getPageCache().put("vouch_serals", serials);
            ViewUtil.openDialog((AbstractFormPlugin)this, null, customParams, (String)"rim_collect_vouch_list", (String)"collect_vouch_list");
        }
    }
}

