/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.rim.common.expense.service.ExpenseCallBackService;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import org.apache.commons.lang3.StringUtils;

public class InvoiceCollectSignPlugin
extends AbstractFormPlugin {
    private static final String submitButton = "submitbutton";
    private InvoiceCollectService invoiceCollectService = new InvoiceCollectService();

    public void afterCreateNewData(EventObject e) {
        this.initView();
    }

    public void registerListener(EventObject e) {
        Button submitbutton = (Button)this.getControl(submitButton);
        submitbutton.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        boolean signResult;
        EntryGrid entryGrid = (EntryGrid)this.getControl("sign_list");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e!", (String)"InvoiceCollectSignPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        ArrayList<String> serialNosList = new ArrayList<String>();
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getEntryEntity("sign_list").get(selectRows[i]);
            String serialNos = dynamicObject.getString("serialnos");
            serialNosList.addAll(Arrays.asList(serialNos.split(",")));
        }
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String status = (String)params.get("status");
        if (StringUtils.isEmpty((CharSequence)status)) {
            status = "1";
        }
        if (!(signResult = this.invoiceCollectService.signInvoice(serialNosList, status))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff01", (String)"InvoiceCollectSignPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else {
            ExpenseCallBackService.signInvoiceBatch(serialNosList, (String)"1");
            HashMap<String, Object> customParams = new HashMap<String, Object>(1);
            customParams.put("result", Boolean.TRUE);
            String serialNos = serialNosList.stream().collect(Collectors.joining(","));
            customParams.put("serialNos", serialNos);
            this.getView().returnDataToParent(customParams);
            this.getView().close();
        }
    }

    private void initView() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray signArray = JSONObject.parseArray((String)customParams.get("signArray").toString());
        int size = signArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject sign = signArray.getJSONObject(i);
            int row = this.getModel().createNewEntryRow("sign_list");
            this.getModel().setValue("invoicetype", (Object)sign.getString("invoiceType"), row);
            this.getModel().setValue("invoicetypename", (Object)sign.getString("invoiceTypeName"), row);
            this.getModel().setValue("invoicecount", (Object)String.format(ResManager.loadKDString((String)"%1$s\u4efd", (String)"InvoiceCollectSignPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), sign.getString("invoiceCount")), row);
            this.getModel().setValue("invoicetotalamount", (Object)sign.getString("invoiceTotalAmount"), row);
            this.getModel().setValue("serialnos", (Object)sign.getString("serialNos"), row);
        }
        String tipsStr = (String)customParams.get("tipsStr");
        if (StringUtils.isNotEmpty((CharSequence)tipsStr)) {
            this.getView().showTipNotification(tipsStr, Integer.valueOf(3000));
        }
    }
}

