/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.PermissionUtils;

public class InvoiceImportResultPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String importResultList = "import_result_list";

    public void registerListener(EventObject e) {
        Toolbar toolbarap = (Toolbar)this.getControl("toolbarap");
        toolbarap.addItemClickListener((ItemClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(importResultList);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initView();
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getEntryEntity(importResultList).get(arg0.getRowIndex());
        String url = dynamicObject.getString("url");
        String excelImportStatus = dynamicObject.getString("resolve_status");
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u4e0b\u8f7d\u7684\u5bfc\u51fa\u7ed3\u679c\u4e0d\u5b58\u5728", (String)"InvoiceImportResultPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!"2".equals(excelImportStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u4e0b\u8f7d\u6570\u636e", (String)"InvoiceImportResultPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entityId = "rim_invoice_collect_index";
        String permItem = "263VK6XB31JH";
        if (!ObjectUtils.isEmpty(customParams.get("entityId"))) {
            entityId = (String)customParams.get("entityId");
        }
        if (!ObjectUtils.isEmpty(customParams.get("permItem"))) {
            permItem = (String)customParams.get("permItem");
        }
        PermissionUtils.addTempFilePermission((String)url, (String)entityId, (String)permItem);
        this.getView().openUrl(url);
    }

    public void itemClick(ItemClickEvent evt) {
        if ("excel_del".equals(evt.getItemKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(importResultList);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6570\u636e!", (String)"InvoiceImportResultPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            ArrayList<String> needRemoveKey = new ArrayList<String>(selectRows.length);
            ArrayList<Integer> removedKeysList = new ArrayList<Integer>(selectRows.length);
            for (int i = 0; i < selectRows.length; ++i) {
                String fileId;
                DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getEntryEntity(importResultList).get(selectRows[i]);
                String exportFileName = dynamicObject.getString("export_file_name");
                if (!StringUtils.isBlank((CharSequence)exportFileName)) {
                    CacheFactory.getCommonCacheFactory().getTempFileCache().remove(exportFileName);
                }
                if (StringUtils.isBlank((CharSequence)(fileId = dynamicObject.getString("file_num")))) continue;
                CacheHelper.remove((String)fileId);
                needRemoveKey.add(fileId);
                removedKeysList.add(i);
            }
            if (CollectionUtils.isEmpty(needRemoveKey)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9700\u8981\u5220\u9664\u7684excel\u7684id", (String)"InvoiceImportResultPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            String fileKey = "excel_file_id" + RequestContext.get().getUserId();
            String idsStr = CacheHelper.get((String)fileKey);
            if (StringUtils.isNotBlank((CharSequence)idsStr)) {
                JSONArray ids = JSONArray.parseArray((String)idsStr);
                ids.removeAll(needRemoveKey);
                CacheHelper.put((String)fileKey, (String)ids.toJSONString(), (int)CommonUtils.getTempFileMaxTimeout());
            }
            int[] removedKeys = new int[removedKeysList.size()];
            for (int i = 0; i < removedKeysList.size(); ++i) {
                removedKeys[i] = (Integer)removedKeysList.get(i);
            }
            this.getView().getModel().deleteEntryRows(importResultList, removedKeys);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u529f\u80fd\u5f00\u53d1\u4e2d\u3002\u3002\u3002", (String)"InvoiceImportResultPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("download_excel".equals(operateKey)) {
            int index = this.getModel().getEntryCurrentRowIndex(importResultList);
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(importResultList, index);
            String url = dynamicObject.getString("url");
            String excelImportStatus = dynamicObject.getString("resolve_status");
            if (StringUtils.isBlank((CharSequence)url)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u4e0b\u8f7d\u7684\u5bfc\u51fa\u7ed3\u679c\u4e0d\u5b58\u5728", (String)"InvoiceImportResultPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!"2".equals(excelImportStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5904\u4e8e\u89e3\u6790\u5b8c\u6210\u72b6\u6001\u7684\u6587\u4ef6\u624d\u53ef\u4e0b\u8f7d", (String)"InvoiceImportResultPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().openUrl(url);
        }
    }

    private void initView() {
        String userId = RequestContext.get().getUserId();
        String fileKey = "excel_file_id" + userId;
        JSONArray fileResultIds = JSONArray.parseArray((String)CacheHelper.get((String)fileKey));
        ArrayList<String> needRemoveFileIds = new ArrayList<String>(8);
        if (CollectionUtils.isEmpty((Collection)fileResultIds)) {
            return;
        }
        for (int i = fileResultIds.size() - 1; i >= 0; --i) {
            String fileResultId = fileResultIds.getString(i);
            if (StringUtils.isEmpty((CharSequence)fileResultId)) continue;
            if (StringUtils.isBlank((CharSequence)CacheHelper.get((String)fileResultId))) {
                needRemoveFileIds.add(fileResultId);
                continue;
            }
            JSONObject importResult = JSONObject.parseObject((String)CacheHelper.get((String)fileResultId));
            if (importResult == null || StringUtils.isNotEmpty((CharSequence)userId) && !userId.equals(importResult.getString("operate_user"))) continue;
            int row = this.getModel().createNewEntryRow(importResultList);
            this.getModel().setValue("excel_name", (Object)importResult.getString("excel_name"), row);
            this.getModel().setValue("upload_time", (Object)importResult.getDate("upload_time"), row);
            this.getModel().setValue("resolve_status", (Object)importResult.getString("resolve_status"), row);
            this.getModel().setValue("operate_user", (Object)importResult.getString("operate_user"), row);
            this.getModel().setValue("url", (Object)importResult.getString("url"), row);
            this.getModel().setValue("file_num", (Object)importResult.getString("file_num"), row);
            this.getModel().setValue("export_file_name", (Object)importResult.getString("export_file_name"), row);
        }
        if (!CollectionUtils.isEmpty(needRemoveFileIds)) {
            fileResultIds.remove(needRemoveFileIds);
        }
        CacheHelper.put((String)fileKey, (String)fileResultIds.toJSONString());
    }
}

