/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.helper.ImcSaveServiceHelper;
import kd.imc.rim.common.invoice.verify.VerifyService;
import kd.imc.rim.common.utils.BatchDataUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DBUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.collections.CollectionUtils;

public class InvoiceWarningTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(InvoiceWarningTask.class);
    private static final String DBROUTE = "taxc";
    public static final String RIM_INVOICE = "rim_invoice";
    private static final String CREATE_TIME = "createtime";
    private static final String ALL_INVOICE = "1";
    private static final String MONTHLY_INVOICE = "0";
    private static final String QUERY_TYPE_INVOICE_STATUS = "1";
    private static final String QUERY_TYPE_CHECK_FAIL = "2";
    private static final String QUERY_TYPE_EINVOICE_UNORIGINAL = "3";
    private static final String[] invoiceStatusType = new String[]{"9", "10", "11", "12"};
    private static final String[] statusFinal = new String[]{"1", "2", "3", "4"};
    private static final int BATCH_SIZE = 500;

    public void execute(RequestContext requestContext, Map<String, Object> map) {
        Long startTime = System.currentTimeMillis();
        CacheHelper.put((String)"rim_warning_execute_time", (String)DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), (int)90000000);
        logger.info("[InvoiceWarningTask]\u53d1\u7968\u9884\u8b66\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb...");
        this.countBaseData("1");
        this.countBaseData(MONTHLY_INVOICE);
        this.sumCardData();
        Long endTime = System.currentTimeMillis();
        logger.info("[InvoiceWarningTask]\u53d1\u7968\u9884\u8b66\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f...\uff0c\u8017\u65f6:" + (endTime - startTime));
    }

    private void sumCardData() {
        DynamicObjectCollection dynamicObjectCollection;
        DynamicObjectCollection undeductCollet;
        QFilter newBigAmountInvoiceFilter;
        DynamicObjectCollection bigAmountCollect;
        Long org = null;
        String data_period = "1";
        boolean checkFlag = this.getCheckFlag();
        String beyond60Sql = "select forg_id as org, fserial_no as serial_no from t_rim_invoice where DATEDIFF(day, finvoice_date, fcreatetime) > 60 and fdelete = '1' and fexpense_status in('1', '30', '60')";
        String beyond90Sql = "select forg_id as org, fserial_no as serial_no from t_rim_invoice where DATEDIFF(day, finvoice_date, fcreatetime) > 90 and fdelete = '1' and fexpense_status in('1', '30', '60')";
        if (checkFlag) {
            beyond60Sql = beyond60Sql.concat(" and fcheck_status = '1'");
            beyond90Sql = beyond90Sql.concat(" and fcheck_status = '1'");
        }
        JSONArray beyond60Array = DBUtils.queryJSONArray((String)beyond60Sql, (Object[])new Object[0]);
        JSONArray beyond90Array = DBUtils.queryJSONArray((String)beyond90Sql, (Object[])new Object[0]);
        ArrayList<DynamicObject> beyondDetails = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> saveBeyondDeadLine = new ArrayList<DynamicObject>(16);
        if (beyond60Array != null && beyond60Array.size() > 0) {
            for (int i = 0; i < beyond60Array.size(); ++i) {
                JSONObject beyond60Obj = beyond60Array.getJSONObject(i);
                JSONObject beyond90Obj = null;
                if (i < beyond90Array.size()) {
                    beyond90Obj = beyond90Array.getJSONObject(i);
                }
                if (beyond60Obj != null) {
                    DynamicObject beyond60Detail = this.buildWarningDetail(beyond60Obj, "6", data_period);
                    beyondDetails.add(beyond60Detail);
                }
                if (beyond90Obj == null) continue;
                DynamicObject beyond90Detail = this.buildWarningDetail(beyond90Obj, "7", data_period);
                beyondDetails.add(beyond90Detail);
            }
            String beyond60CountSql = "select forg_id as org, count(1) as count60 from t_rim_invoice where DATEDIFF(day, finvoice_date, fcreatetime) > 60 and fdelete = '1' and fexpense_status in('1', '30', '60')";
            String beyond90CountSql = "select forg_id as org, count(1) as count90 from t_rim_invoice where DATEDIFF(day, finvoice_date, fcreatetime) > 90 and fdelete = '1' and fexpense_status in('1', '30', '60')";
            if (checkFlag) {
                beyond60CountSql = beyond60CountSql.concat(" and fcheck_status = '1'");
                beyond90CountSql = beyond90CountSql.concat(" and fcheck_status = '1'");
            }
            beyond60CountSql = beyond60CountSql.concat(" group by forg_id");
            beyond90CountSql = beyond90CountSql.concat(" group by forg_id");
            JSONArray beyond60CountArray = DBUtils.queryJSONArray((String)beyond60CountSql, (Object[])new Object[0]);
            JSONArray beyond90CountArray = DBUtils.queryJSONArray((String)beyond90CountSql, (Object[])new Object[0]);
            if (beyond60CountArray != null && beyond60CountArray.size() > 0) {
                for (int i = 0; i < beyond60CountArray.size(); ++i) {
                    JSONObject beyond60CountObj = beyond60CountArray.getJSONObject(i);
                    JSONObject beyond90CountObj = null;
                    if (i < beyond90CountArray.size()) {
                        beyond90CountObj = beyond90CountArray.getJSONObject(i);
                    }
                    if (beyond60CountObj != null) {
                        org = beyond60CountObj.getLong("ORG");
                        int beyond60Count = beyond60CountObj.getInteger("COUNT60");
                        DynamicObject beyond60DaysObj = this.createDynamicObject(org, data_period, "beyond_60days", beyond60Count);
                        saveBeyondDeadLine.add(beyond60DaysObj);
                    }
                    if (beyond90CountObj == null) continue;
                    org = beyond90CountObj.getLong("ORG");
                    int beyond90Count = beyond90CountObj.getInteger("COUNT90");
                    DynamicObject beyond90DaysObj = this.createDynamicObject(org, data_period, "beyond_90days", beyond90Count);
                    saveBeyondDeadLine.add(beyond90DaysObj);
                }
            }
        }
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_data", (QFilter[])new QFilter("data_type", "in", (Object)new String[]{"beyond_60days", "beyond_90days"}).and("data_period", "=", (Object)data_period).toArray());
        if (!CollectionUtils.isEmpty(saveBeyondDeadLine)) {
            ImcSaveServiceHelper.saveMassBatchList(saveBeyondDeadLine);
            saveBeyondDeadLine.clear();
        }
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_detail", (QFilter[])new QFilter("warning_type", "in", (Object)new String[]{"6", "7"}).and("detail_period", "=", (Object)data_period).toArray());
        if (!CollectionUtils.isEmpty(beyondDetails)) {
            ImcSaveServiceHelper.saveMassBatchList(beyondDetails);
            beyondDetails.clear();
        }
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_detail", (QFilter[])new QFilter("warning_type", "=", (Object)"21").toArray());
        ArrayList<DynamicObject> saveBigAmountInvoice = new ArrayList<DynamicObject>(16);
        BigDecimal largeAmount = BigDecimal.valueOf(100000L);
        String largeAmountStr = RimConfigUtils.getConfig((String)"rim_config", (String)"large_amount");
        if (!StringUtils.isEmpty((CharSequence)largeAmountStr)) {
            largeAmount = new BigDecimal(largeAmountStr);
        }
        QFilter bigAmountInvoiceFilter = new QFilter("total_amount", ">=", (Object)largeAmount).and("delete", "=", (Object)"1").and("invoice_type", "!=", (Object)InputInvoiceTypeEnum.OTHER_INVOICE.getCode());
        if (checkFlag) {
            bigAmountInvoiceFilter = bigAmountInvoiceFilter.and("check_status", "=", (Object)"1");
        }
        if (!CollectionUtils.isEmpty((Collection)(bigAmountCollect = QueryServiceHelper.query((String)RIM_INVOICE, (String)"org, serial_no, total_amount", (QFilter[])(newBigAmountInvoiceFilter = bigAmountInvoiceFilter.copy()).toArray())))) {
            Map<Long, List<DynamicObject>> orgInvoiceMap = bigAmountCollect.stream().collect(Collectors.groupingBy(x -> x.getLong("org")));
            for (Map.Entry<Long, List<DynamicObject>> entry : orgInvoiceMap.entrySet()) {
                Long org_id = entry.getKey();
                List<DynamicObject> list = entry.getValue();
                int n = list.size();
                BigDecimal bigAmountSum = list.stream().map(m -> m.getBigDecimal("total_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                DynamicObject bigAmountNumObj = this.createDynamicObject(org_id, data_period, "big_amount_num", n);
                DynamicObject bigAmountSumObj = this.createDynamicObject(org_id, data_period, "big_amount_sum", bigAmountSum);
                saveBigAmountInvoice.add(bigAmountNumObj);
                saveBigAmountInvoice.add(bigAmountSumObj);
                ArrayList<DynamicObject> saveObjects = new ArrayList<DynamicObject>(8);
                Iterator<DynamicObject> iterator = list.iterator();
                while (iterator.hasNext()) {
                    DynamicObject obj = iterator.next();
                    String serialNo = obj.getString("serial_no");
                    saveObjects.add(this.buildWarningDetail(serialNo, org_id, "21", data_period));
                }
                ImcSaveServiceHelper.saveMassBatchList(saveObjects);
            }
        }
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_data", (QFilter[])new QFilter("data_type", "in", (Object)new String[]{"big_amount_num", "big_amount_sum"}).and("data_period", "=", (Object)data_period).toArray());
        if (!CollectionUtils.isEmpty(saveBigAmountInvoice)) {
            ImcSaveServiceHelper.saveMassBatchList(saveBigAmountInvoice);
            saveBigAmountInvoice.clear();
        }
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_detail", (QFilter[])new QFilter("warning_type", "=", (Object)"20").toArray());
        ArrayList<DynamicObject> saveUndeduction = new ArrayList<DynamicObject>(16);
        QFilter undeductionFilter = new QFilter("expense_status", "=", (Object)"65").and("authenticate_flag", "=", (Object)MONTHLY_INVOICE).and("delete", "=", (Object)"1").and("invoice_type", "in", (Object)new Long[]{InputInvoiceTypeEnum.SPECIAL_PAPER.getCode(), InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode(), InputInvoiceTypeEnum.TOLL_ELECTRON.getCode(), InputInvoiceTypeEnum.MOTOR_INVOICE.getCode(), InputInvoiceTypeEnum.HGJKS.getCode(), InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode()});
        if (checkFlag) {
            undeductionFilter = undeductionFilter.and("check_status", "=", (Object)"1");
        }
        if (!CollectionUtils.isEmpty((Collection)(undeductCollet = QueryServiceHelper.query((String)RIM_INVOICE, (String)"org, serial_no, total_amount", (QFilter[])undeductionFilter.toArray())))) {
            Map<Long, List<DynamicObject>> orgInvoiceMap = undeductCollet.stream().collect(Collectors.groupingBy(x -> x.getLong("org")));
            for (Map.Entry entry : orgInvoiceMap.entrySet()) {
                Long org_id = (Long)entry.getKey();
                List list = (List)entry.getValue();
                int undeductionNum = list.size();
                BigDecimal undeductionAmount = list.stream().map(m -> m.getBigDecimal("total_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                DynamicObject undeductionNumObj = this.createDynamicObject(org_id, data_period, "undeduction_num", undeductionNum);
                DynamicObject undeductionAmountObj = this.createDynamicObject(org_id, data_period, "undeduction_amount", undeductionAmount);
                saveUndeduction.add(undeductionNumObj);
                saveUndeduction.add(undeductionAmountObj);
                ArrayList<DynamicObject> saveObjects = new ArrayList<DynamicObject>(8);
                for (DynamicObject obj : list) {
                    String serialNo = obj.getString("serial_no");
                    saveObjects.add(this.buildWarningDetail(serialNo, org_id, "20", data_period));
                }
                ImcSaveServiceHelper.saveMassBatchList(saveObjects);
            }
        }
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_data", (QFilter[])new QFilter("data_type", "in", (Object)new String[]{"undeduction_num", "undeduction_amount"}).and("data_period", "=", (Object)data_period).toArray());
        if (!CollectionUtils.isEmpty(saveUndeduction)) {
            ImcSaveServiceHelper.saveMassBatchList(saveUndeduction);
            saveUndeduction.clear();
        }
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_detail", (QFilter[])new QFilter("warning_type", "=", (Object)"22").toArray());
        ArrayList<DynamicObject> saveUnreceiveInvoice = new ArrayList<DynamicObject>(16);
        QFilter unreceiveFilter = new QFilter("authenticate_flag", "!=", (Object)MONTHLY_INVOICE).and("original_state", "=", (Object)MONTHLY_INVOICE).and("invoice_type", "in", (Object)new Long[]{InputInvoiceTypeEnum.SPECIAL_PAPER.getCode(), InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode(), InputInvoiceTypeEnum.TOLL_ELECTRON.getCode(), InputInvoiceTypeEnum.MOTOR_INVOICE.getCode(), InputInvoiceTypeEnum.HGJKS.getCode(), InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode()}).and("delete", "=", (Object)"1");
        if (checkFlag) {
            unreceiveFilter = unreceiveFilter.and("check_status", "=", (Object)"1");
        }
        if (!CollectionUtils.isEmpty((Collection)(dynamicObjectCollection = QueryServiceHelper.query((String)RIM_INVOICE, (String)"org, serial_no, total_amount", (QFilter[])unreceiveFilter.toArray())))) {
            Map<Long, List<DynamicObject>> orgInvoiceMap = dynamicObjectCollection.stream().collect(Collectors.groupingBy(x -> x.getLong("org")));
            for (Map.Entry<Long, List<DynamicObject>> entry : orgInvoiceMap.entrySet()) {
                Long org_id = entry.getKey();
                List<DynamicObject> list = entry.getValue();
                int unreceiveNum = list.size();
                BigDecimal unReceiveAmount = list.stream().map(m -> m.getBigDecimal("total_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                DynamicObject unreceiveNumObj = this.createDynamicObject(org_id, data_period, "selected_unsigned_num", unreceiveNum);
                DynamicObject unreceiveAmountObj = this.createDynamicObject(org_id, data_period, "selected_unsigned_amount", unReceiveAmount);
                saveUnreceiveInvoice.add(unreceiveNumObj);
                saveUnreceiveInvoice.add(unreceiveAmountObj);
                ArrayList<DynamicObject> saveObjects = new ArrayList<DynamicObject>(8);
                for (DynamicObject obj : list) {
                    String serialNo = obj.getString("serial_no");
                    saveObjects.add(this.buildWarningDetail(serialNo, org_id, "22", data_period));
                }
                ImcSaveServiceHelper.saveMassBatchList(saveObjects);
            }
        }
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_data", (QFilter[])new QFilter("data_type", "in", (Object)new String[]{"selected_unsigned_num", "selected_unsigned_amount"}).and("data_period", "=", (Object)data_period).toArray());
        if (!CollectionUtils.isEmpty(saveUnreceiveInvoice)) {
            ImcSaveServiceHelper.saveMassBatchList(saveUnreceiveInvoice);
            saveUnreceiveInvoice.clear();
        }
    }

    private void countBaseData(String data_period) {
        if (StringUtils.isBlank((CharSequence)data_period)) {
            data_period = "1";
        }
        this.countRiskInvoiceStatus(data_period);
        QFilter orgFilter = new QFilter("delete", "=", (Object)"1");
        DataSet dynamicObjects = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)RIM_INVOICE, (String)"org", (QFilter[])orgFilter.toArray(), null).groupBy(new String[]{"org"}).finish();
        if (dynamicObjects == null) {
            return;
        }
        ArrayList<Long> orgList = new ArrayList<Long>();
        while (dynamicObjects.hasNext()) {
            Row row = dynamicObjects.next();
            Long org = row.getLong("org");
            if (org == null) continue;
            orgList.add(org);
        }
        if (CollectionUtils.isEmpty(orgList)) {
            return;
        }
        this.countBlackAndSensitive(orgList, data_period);
        this.countEinviceUnoriginal(data_period, orgList);
        this.countSpecialUncomplete(data_period, orgList);
        this.countBeyondExpense(data_period, orgList);
        this.countAllRisk(data_period, orgList);
    }

    private DynamicObject createDynamicObject(Long org, String dataPeriod) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_inv_warning_data");
        dynamicObject.set("create_time", (Object)new Date());
        dynamicObject.set("org", (Object)org);
        dynamicObject.set("data_period", (Object)dataPeriod);
        return dynamicObject;
    }

    private DynamicObject createDynamicObject(Long org, String dataPeriod, String dataType, Object dataValue) {
        BigDecimal amount;
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_inv_warning_data");
        dynamicObject.set("create_time", (Object)new Date());
        dynamicObject.set("org", (Object)org);
        dynamicObject.set("data_period", (Object)dataPeriod);
        dynamicObject.set("data_type", (Object)dataType);
        if (dataValue instanceof BigDecimal && (amount = (BigDecimal)dataValue).compareTo(BigDecimal.valueOf(10000000000000L)) >= 0) {
            dataValue = BigDecimal.valueOf(9999999999999L);
        }
        dynamicObject.set("data_value", dataValue);
        return dynamicObject;
    }

    private void countRiskInvoiceStatus(String data_period) {
        JSONArray checkFailArray;
        Object[] checkFailParam;
        String checkFailSql;
        Long org;
        String abnormalStatusSql;
        boolean checkFlag = this.getCheckFlag();
        JSONArray abnormalStatusArray = null;
        Date firstDateOfTheMonth = DateUtils.getFirstDateOfMonth((Date)new Date());
        String vatType = this.getVatType();
        if ("1".equals(data_period)) {
            abnormalStatusSql = "select forg_id as org, finvoice_status as status, sum(ftotal_amount) as total, count(1) as num from t_rim_invoice where finvoice_type in(" + vatType + ") and fdelete = '1' and finvoice_status in('1','2','3','4') ";
            if (checkFlag) {
                abnormalStatusSql = abnormalStatusSql.concat("and fcheck_status = '1' ");
            }
            abnormalStatusSql = abnormalStatusSql.concat("group by finvoice_status, forg_id");
            abnormalStatusArray = DBUtils.queryJSONArray((String)abnormalStatusSql, null);
        } else {
            abnormalStatusSql = "select forg_id as org, finvoice_status as status, sum(ftotal_amount) as total, count(1) as num from t_rim_invoice where finvoice_type in(" + vatType + ") and fdelete = '1' and finvoice_status in('1','2','3','4') and fcreatetime >= ? ";
            if (checkFlag) {
                abnormalStatusSql = abnormalStatusSql.concat("and fcheck_status = '1' ");
            }
            abnormalStatusSql = abnormalStatusSql.concat("group by finvoice_status, forg_id");
            Object[] abnormalStatusParam = new Object[]{firstDateOfTheMonth};
            abnormalStatusArray = DBUtils.queryJSONArray((String)abnormalStatusSql, (Object[])abnormalStatusParam);
        }
        ArrayList<DynamicObject> saveRiskInvoiceList = new ArrayList<DynamicObject>(16);
        if (abnormalStatusArray != null && abnormalStatusArray.size() > 0) {
            block12: for (int i = 0; i < abnormalStatusArray.size(); ++i) {
                JSONObject abnormalObj = abnormalStatusArray.getJSONObject(i);
                String status = abnormalObj.getString("STATUS");
                org = abnormalObj.getLong("ORG");
                if (ObjectUtils.isEmpty((Object)abnormalObj) || StringUtils.isEmpty((CharSequence)status) || ObjectUtils.isEmpty((Object)org)) continue;
                switch (status) {
                    case "1": {
                        DynamicObject lostControlNumObj = this.createDynamicObject(org, data_period, "lost_control_num", abnormalObj.getInteger("NUM"));
                        saveRiskInvoiceList.add(lostControlNumObj);
                        DynamicObject lostControlAmountObj = this.createDynamicObject(org, data_period, "lost_control_amount", abnormalObj.getBigDecimal("TOTAL"));
                        saveRiskInvoiceList.add(lostControlAmountObj);
                        continue block12;
                    }
                    case "2": {
                        DynamicObject aboundedNumObj = this.createDynamicObject(org, data_period, "abounded_num", abnormalObj.getInteger("NUM"));
                        saveRiskInvoiceList.add(aboundedNumObj);
                        DynamicObject aboundedAmountObj = this.createDynamicObject(org, data_period, "abounded_amount", abnormalObj.getBigDecimal("TOTAL"));
                        saveRiskInvoiceList.add(aboundedAmountObj);
                        continue block12;
                    }
                    case "3": {
                        DynamicObject redNumObj = this.createDynamicObject(org, data_period, "red_num", abnormalObj.getInteger("NUM"));
                        saveRiskInvoiceList.add(redNumObj);
                        DynamicObject redAmountObj = this.createDynamicObject(org, data_period, "red_amount", abnormalObj.getBigDecimal("TOTAL"));
                        saveRiskInvoiceList.add(redAmountObj);
                        continue block12;
                    }
                    case "4": {
                        DynamicObject abnormalNumObj = this.createDynamicObject(org, data_period, "abnormal_num", abnormalObj.getInteger("NUM"));
                        saveRiskInvoiceList.add(abnormalNumObj);
                        DynamicObject abnormalAmountObj = this.createDynamicObject(org, data_period, "abnormal_amount", abnormalObj.getBigDecimal("TOTAL"));
                        saveRiskInvoiceList.add(abnormalAmountObj);
                    }
                }
            }
        }
        if ("1".equals(data_period)) {
            checkFailSql = "select forg_id as org, sum(ftotal_amount) as total, count(1) as num from t_rim_invoice where finvoice_type in(" + vatType + ") and fdelete = ? and fcheck_status = ? group by forg_id";
            checkFailParam = new Object[]{"1", QUERY_TYPE_CHECK_FAIL};
            checkFailArray = DBUtils.queryJSONArray((String)checkFailSql, (Object[])checkFailParam);
        } else {
            checkFailSql = "select forg_id as org, sum(ftotal_amount) as total, count(1) as num from t_rim_invoice where finvoice_type in(" + vatType + ") and fdelete = ? and fcheck_status = ? and fcreatetime >= ? group by forg_id";
            checkFailParam = new Object[]{"1", QUERY_TYPE_CHECK_FAIL, firstDateOfTheMonth};
            checkFailArray = DBUtils.queryJSONArray((String)checkFailSql, (Object[])checkFailParam);
        }
        if (checkFailArray != null && checkFailArray.size() > 0) {
            for (int i = 0; i < checkFailArray.size(); ++i) {
                JSONObject checkFailObj = checkFailArray.getJSONObject(i);
                org = checkFailObj.getLong("ORG");
                if (ObjectUtils.isEmpty((Object)checkFailObj) || org == null) continue;
                DynamicObject checkFailNum = this.createDynamicObject(org, data_period, "check_fail_num", checkFailObj.getInteger("NUM"));
                saveRiskInvoiceList.add(checkFailNum);
                DynamicObject checkFailAmount = this.createDynamicObject(org, data_period, "check_fail_amount", checkFailObj.getBigDecimal("TOTAL"));
                saveRiskInvoiceList.add(checkFailAmount);
            }
        }
        QFilter deleteFilter = new QFilter("data_type", "in", (Object)new String[]{"lost_control_num", "abounded_num", "red_num", "abnormal_num", "check_fail_num", "lost_control_amount", "abounded_amount", "red_amount", "abnormal_amount", "check_fail_amount"}).and("data_period", "=", (Object)data_period);
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_data", (QFilter[])deleteFilter.toArray());
        if (!CollectionUtils.isEmpty(saveRiskInvoiceList)) {
            ImcSaveServiceHelper.saveMassBatchList(saveRiskInvoiceList);
        }
        saveRiskInvoiceList.clear();
    }

    private boolean getCheckFlag() {
        String showUncheckConfig = RimConfigUtils.getConfig((String)"show_uncheck");
        return StringUtils.isBlank((CharSequence)showUncheckConfig) || MONTHLY_INVOICE.equals(showUncheckConfig);
    }

    private void countAllRisk(String data_period, List<Long> orgList) {
        Date firstDateOfTheMonth = DateUtils.getFirstDateOfMonth((Date)new Date());
        QFilter commonFilter = new QFilter("delete", "=", (Object)"1");
        if (MONTHLY_INVOICE.equals(data_period)) {
            commonFilter = commonFilter.and(CREATE_TIME, ">=", (Object)firstDateOfTheMonth);
        }
        QFilter checkFailFilter = commonFilter.copy();
        boolean checkFlag = this.getCheckFlag();
        if (checkFlag) {
            commonFilter = commonFilter.and("check_status", "=", (Object)"1");
        }
        if (CollectionUtils.isEmpty(orgList)) {
            return;
        }
        ArrayList<DynamicObject> saveDetailObjs = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> saveWarningObjs = new ArrayList<DynamicObject>(16);
        for (Long org : orgList) {
            if (ObjectUtils.isEmpty((Object)org)) continue;
            Map<Object, Object> invoiceAmountMap = new HashMap(16);
            QFilter orgFilter = commonFilter.copy().and("org", "=", (Object)org);
            DynamicObjectCollection queryResult = QueryServiceHelper.query((String)RIM_INVOICE, (String)"serial_no, total_amount, invoice_status, check_status, invoice_type, original_state", (QFilter[])orgFilter.toArray());
            invoiceAmountMap = this.buildMapResultNew(queryResult, org, data_period);
            QFilter checkFailOrgFilter = checkFailFilter.copy().and("org", "=", (Object)org);
            DynamicObjectCollection checkFailResult = QueryServiceHelper.query((String)RIM_INVOICE, (String)"serial_no, total_amount, check_status, invoice_type", (QFilter[])checkFailOrgFilter.toArray());
            List checkStatusList = checkFailResult.stream().filter(f -> QUERY_TYPE_CHECK_FAIL.equals(f.getString("check_status")) && Arrays.asList(InputInvoiceTypeEnum.getVatTypes()).contains(f.getLong("invoice_type"))).collect(Collectors.toList());
            boolean index = false;
            ArrayList<DynamicObject> saveObjects = new ArrayList<DynamicObject>(8);
            for (DynamicObject obj : checkStatusList) {
                saveObjects.add(this.buildWarningDetail(obj.getString("serial_no"), org, "13", data_period));
                invoiceAmountMap.put(obj.getString("serial_no"), obj.getBigDecimal("total_amount"));
            }
            ImcSaveServiceHelper.saveMassBatchList(saveObjects);
            QFilter blackListAndSoOnFilter = new QFilter("org", "=", (Object)org).and("detail_period", "=", (Object)data_period).and("warning_type", "in", (Object)new String[]{"1", QUERY_TYPE_CHECK_FAIL, QUERY_TYPE_EINVOICE_UNORIGINAL, "5"});
            queryResult = QueryServiceHelper.query((String)"rim_inv_warning_detail", (String)"serial_no", (QFilter[])blackListAndSoOnFilter.toArray());
            if (!queryResult.isEmpty()) {
                Object serialNo;
                ArrayList serialNos = Lists.newArrayList();
                for (DynamicObject dynamicObject : queryResult) {
                    if (ObjectUtils.isEmpty((Object)dynamicObject) || StringUtils.isBlank((CharSequence)(serialNo = dynamicObject.getString("serial_no")))) continue;
                    serialNos.add(serialNo);
                }
                QFilter serialNoFilter = new QFilter("serial_no", "in", (Object)serialNos);
                DynamicObjectCollection serialNoObjs = QueryServiceHelper.query((String)RIM_INVOICE, (String)"serial_no, total_amount", (QFilter[])serialNoFilter.toArray());
                if (!CollectionUtils.isEmpty((Collection)serialNoObjs)) {
                    serialNo = serialNoObjs.iterator();
                    while (serialNo.hasNext()) {
                        DynamicObject obj = (DynamicObject)serialNo.next();
                        invoiceAmountMap.put(obj.getString("serial_no"), obj.getBigDecimal("total_amount"));
                    }
                }
            }
            if (invoiceAmountMap.size() <= 0) continue;
            BigDecimal sumAmount = BigDecimal.ZERO;
            for (Map.Entry<Object, Object> entry : invoiceAmountMap.entrySet()) {
                if (ObjectUtils.isEmpty(entry)) continue;
                DynamicObject detailObj = BusinessDataServiceHelper.newDynamicObject((String)"rim_inv_warning_detail");
                detailObj.set("serial_no", entry.getKey());
                detailObj.set("org", (Object)org);
                detailObj.set("warning_type", (Object)"8");
                detailObj.set("detail_period", (Object)data_period);
                saveDetailObjs.add(detailObj);
                sumAmount = sumAmount.add((BigDecimal)entry.getValue());
            }
            DynamicObject allRiskCount = this.createDynamicObject(org, data_period, "exception_count", invoiceAmountMap.size());
            saveWarningObjs.add(allRiskCount);
            DynamicObject allRiskAmount = this.createDynamicObject(org, data_period, "exception_amount", sumAmount);
            saveWarningObjs.add(allRiskAmount);
        }
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_data", (QFilter[])new QFilter("data_type", "in", (Object)new String[]{"exception_count", "exception_amount"}).and("data_period", "=", (Object)data_period).toArray());
        if (!CollectionUtils.isEmpty(saveWarningObjs)) {
            ImcSaveServiceHelper.saveMassBatchList(saveWarningObjs);
            saveWarningObjs.clear();
        }
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_detail", (QFilter[])new QFilter("warning_type", "=", (Object)"8").and("detail_period", "=", (Object)data_period).toArray());
        if (!CollectionUtils.isEmpty(saveDetailObjs)) {
            ImcSaveServiceHelper.saveMassBatchList(saveDetailObjs);
            saveDetailObjs.clear();
        }
    }

    private Map<String, BigDecimal> buildMapResultNew(DynamicObjectCollection queryResult, Long org, String dataPeriod) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)10);
        String[] types = Arrays.copyOf(invoiceStatusType, invoiceStatusType.length + 2);
        types[InvoiceWarningTask.invoiceStatusType.length] = "13";
        types[InvoiceWarningTask.invoiceStatusType.length + 1] = "14";
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_detail", (QFilter[])new QFilter("warning_type", "in", (Object)types).and("detail_period", "=", (Object)dataPeriod).and("org", "=", (Object)org).toArray());
        if (CollectionUtils.isEmpty((Collection)queryResult)) {
            return result;
        }
        Map<String, List<DynamicObject>> invoiceStatus = queryResult.stream().filter(f -> {
            String invoice_status = f.getString("invoice_status");
            Long invoiceType = f.getLong("invoice_type");
            return StringUtils.isNotEmpty((CharSequence)invoice_status.trim()) && Arrays.asList(statusFinal).contains(invoice_status) && Arrays.asList(InputInvoiceTypeEnum.getVatTypes()).contains(invoiceType);
        }).collect(Collectors.groupingBy(x -> x.getString("invoice_status")));
        for (Map.Entry<String, List<DynamicObject>> entry : invoiceStatus.entrySet()) {
            String status = entry.getKey();
            ArrayList<DynamicObject> saveObjects = new ArrayList<DynamicObject>(8);
            for (DynamicObject obj : entry.getValue()) {
                saveObjects.add(this.buildWarningDetailNew(obj.getString("serial_no"), org, status, dataPeriod));
                result.put(obj.getString("serial_no"), obj.getBigDecimal("total_amount"));
            }
            ImcSaveServiceHelper.saveMassBatchList(saveObjects);
        }
        Long[] eletypes = new Long[]{InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode(), InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode(), InputInvoiceTypeEnum.TOLL_ELECTRON.getCode()};
        List unOriginalList = queryResult.stream().filter(f -> Arrays.asList(eletypes).contains(f.getLong("invoice_type")) && MONTHLY_INVOICE.equals(f.getString("original_state"))).collect(Collectors.toList());
        ArrayList<DynamicObject> unOriginalSaveObjects = new ArrayList<DynamicObject>(8);
        for (DynamicObject obj : unOriginalList) {
            unOriginalSaveObjects.add(this.buildWarningDetail(obj.getString("serial_no"), org, "14", dataPeriod));
            result.put(obj.getString("serial_no"), obj.getBigDecimal("total_amount"));
        }
        ImcSaveServiceHelper.saveMassBatchList(unOriginalSaveObjects);
        return result;
    }

    private DynamicObject buildWarningDetailNew(String serialNo, Long singleOrg, String status, String detailPeriod) {
        DynamicObject detailObj = BusinessDataServiceHelper.newDynamicObject((String)"rim_inv_warning_detail");
        detailObj.set("serial_no", (Object)serialNo);
        detailObj.set("org", (Object)singleOrg);
        String warningType = "";
        switch (status) {
            case "1": {
                warningType = "9";
                break;
            }
            case "2": {
                warningType = "10";
                break;
            }
            case "3": {
                warningType = "11";
                break;
            }
            case "4": {
                warningType = "12";
            }
        }
        detailObj.set("warning_type", (Object)warningType);
        detailObj.set("detail_period", (Object)detailPeriod);
        return detailObj;
    }

    private void buildMapResult(Map<String, BigDecimal> invoiceAmountMap, DynamicObjectCollection queryResult, String queryType, Long org, String dataPeriod) {
        if ("1".equals(queryType)) {
            ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_detail", (QFilter[])new QFilter("warning_type", "in", (Object)invoiceStatusType).and("detail_period", "=", (Object)dataPeriod).and("org", "=", (Object)org).toArray());
        } else if (QUERY_TYPE_CHECK_FAIL.equals(queryType)) {
            ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_detail", (QFilter[])new QFilter("warning_type", "=", (Object)"13").and("detail_period", "=", (Object)dataPeriod).and("org", "=", (Object)org).toArray());
        } else if (QUERY_TYPE_EINVOICE_UNORIGINAL.equals(queryType)) {
            ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_detail", (QFilter[])new QFilter("warning_type", "=", (Object)"14").and("detail_period", "=", (Object)dataPeriod).and("org", "=", (Object)org).toArray());
        }
        if (!queryResult.isEmpty()) {
            ArrayList<DynamicObject> detailObjs = new ArrayList<DynamicObject>(16);
            String warningType = "99";
            for (DynamicObject dynamicObj : queryResult) {
                if (ObjectUtils.isEmpty((Object)dynamicObj)) continue;
                if ("1".equals(queryType)) {
                    String invoiceStatus;
                    switch (invoiceStatus = dynamicObj.getString("invoice_status")) {
                        case "1": {
                            warningType = "9";
                            break;
                        }
                        case "2": {
                            warningType = "10";
                            break;
                        }
                        case "3": {
                            warningType = "11";
                            break;
                        }
                        case "4": {
                            warningType = "12";
                        }
                    }
                }
                if (QUERY_TYPE_CHECK_FAIL.equals(queryType)) {
                    warningType = "13";
                }
                if (QUERY_TYPE_EINVOICE_UNORIGINAL.equals(queryType)) {
                    warningType = "14";
                }
                String serialNo = dynamicObj.getString("serial_no");
                DynamicObject detailObj = this.buildWarningDetail(serialNo, org, warningType, dataPeriod);
                detailObjs.add(detailObj);
                invoiceAmountMap.put(serialNo, dynamicObj.getBigDecimal("total_amount"));
            }
            if (!CollectionUtils.isEmpty(detailObjs)) {
                ImcSaveServiceHelper.saveMassBatchList(detailObjs);
                detailObjs.clear();
            }
        }
    }

    private void countBlackAndSensitive(List<Long> orgList, String data_period) {
        Date firstDateOfTheMonth = DateUtils.getFirstDateOfMonth((Date)new Date());
        boolean checkFlag = this.getCheckFlag();
        ArrayList<DynamicObject> saveBlackListObjs = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> saveSensitiveWordsObjs = new ArrayList<DynamicObject>(16);
        HashSet<String> outerBlackListSet = new HashSet<String>(16);
        QFilter blackListFilter = new QFilter("company_name", "is not null", null);
        DynamicObjectCollection blackListCollection = QueryServiceHelper.query((String)"rim_black_list_data", (String)"company_name", (QFilter[])(blackListFilter = blackListFilter.and("black_list_type", "!=", (Object)"4")).toArray());
        if (!CollectionUtils.isEmpty((Collection)blackListCollection)) {
            for (DynamicObject dynamicObject : blackListCollection) {
                if (ObjectUtils.isEmpty((Object)dynamicObject) || !StringUtils.isNotBlank((CharSequence)dynamicObject.getString("company_name"))) continue;
                outerBlackListSet.add(dynamicObject.getString("company_name"));
            }
        }
        Long[] needCheckTypes = new Long[]{InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode(), InputInvoiceTypeEnum.SPECIAL_PAPER.getCode(), InputInvoiceTypeEnum.TOLL_ELECTRON.getCode(), InputInvoiceTypeEnum.ORDINARY_PAPER.getCode(), InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode(), InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode(), InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode()};
        QFilter deleteFilter = new QFilter("delete", "!=", (Object)"1").and("invoice_type", "in", (Object)needCheckTypes);
        DynamicObjectCollection deletedSpecialInvoice = QueryServiceHelper.query((String)RIM_INVOICE, (String)"serial_no", (QFilter[])deleteFilter.toArray());
        DynamicObjectCollection uncheckSpecialInvoice = null;
        if (checkFlag) {
            QFilter uncheckFilter = new QFilter("check_status", "!=", (Object)"1").and("invoice_type", "in", (Object)needCheckTypes);
            uncheckSpecialInvoice = QueryServiceHelper.query((String)RIM_INVOICE, (String)"serial_no", (QFilter[])uncheckFilter.toArray());
        }
        ArrayList<String> deletedSerialNo = null;
        if (!CollectionUtils.isEmpty((Collection)deletedSpecialInvoice)) {
            if (!CollectionUtils.isEmpty(uncheckSpecialInvoice)) {
                deletedSpecialInvoice.addAll(uncheckSpecialInvoice);
            }
            deletedSerialNo = new ArrayList<String>(deletedSpecialInvoice.size());
            for (DynamicObject dynamicObject : deletedSpecialInvoice) {
                if (ObjectUtils.isEmpty((Object)dynamicObject)) continue;
                deletedSerialNo.add(dynamicObject.getString("serial_no"));
            }
        }
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_data", (QFilter[])new QFilter("data_type", "in", (Object)new String[]{"sensitive_words", "sensitive_words_amount", "black_list", "black_list_amount"}).and("data_period", "=", (Object)data_period).toArray());
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_detail", (QFilter[])new QFilter("warning_type", "in", (Object)new String[]{"1", QUERY_TYPE_CHECK_FAIL}).and("detail_period", "=", (Object)data_period).toArray());
        for (Long singleOrg : orgList) {
            if (singleOrg == null) continue;
            HashMap<String, Long> orgMap = new HashMap<String, Long>(1);
            orgMap.put("orgId", singleOrg);
            JSONObject verifyConfig = VerifyService.getVerfifyConfig(orgMap);
            JSONArray blackListArray = verifyConfig.getJSONArray("black_list_value");
            List<String> localBlackList = new ArrayList(16);
            if (blackListArray != null && blackListArray.size() > 0) {
                localBlackList = blackListArray.toJavaList(String.class);
                localBlackList.addAll(outerBlackListSet);
            }
            JSONArray sensitiveWords = verifyConfig.getJSONArray("sensitive_word_value");
            ArrayList<QFilter> sensitiveWordFilters = new ArrayList<QFilter>(16);
            if (sensitiveWords != null && sensitiveWords.size() > 0) {
                QFilter wordFilter = null;
                for (int i = 0; i < sensitiveWords.size(); ++i) {
                    if (ObjectUtils.isEmpty((Object)sensitiveWords.get(i))) continue;
                    if (wordFilter == null) {
                        wordFilter = new QFilter("items.goods_name", "like", (Object)("%" + sensitiveWords.get(i) + "%"));
                    }
                    wordFilter.or("items.goods_name", "like", (Object)("%" + sensitiveWords.get(i) + "%"));
                }
                if (wordFilter != null) {
                    sensitiveWordFilters.add(wordFilter);
                }
            }
            QFilter orgFilter = new QFilter("org", "=", (Object)singleOrg);
            sensitiveWordFilters.add(orgFilter);
            if ("1".equals(data_period)) {
                blackListFilter = new QFilter("delete", "=", (Object)"1").and("org", "=", (Object)singleOrg);
            } else {
                blackListFilter = new QFilter("delete", "=", (Object)"1").and(CREATE_TIME, ">=", (Object)firstDateOfTheMonth).and("org", "=", (Object)singleOrg);
                QFilter monthlyFilter = new QFilter(CREATE_TIME, ">=", (Object)firstDateOfTheMonth);
                sensitiveWordFilters.add(monthlyFilter);
            }
            if (checkFlag) {
                blackListFilter = blackListFilter.and("check_status", "=", (Object)"1");
            }
            BigDecimal blackListAmount = BigDecimal.ZERO;
            int blackListNum = 0;
            DynamicObjectCollection allBlackListObjs = QueryServiceHelper.query((String)RIM_INVOICE, (String)"serial_no, total_amount, saler_name", (QFilter[])blackListFilter.toArray());
            if (!CollectionUtils.isEmpty((Collection)allBlackListObjs)) {
                DynamicObject blackListObj = this.createDynamicObject(singleOrg, data_period);
                ArrayList<DynamicObject> blackListDetails = new ArrayList<DynamicObject>(16);
                for (DynamicObject allBlackListObj : allBlackListObjs) {
                    String salerName;
                    if (ObjectUtils.isEmpty((Object)allBlackListObj) || StringUtils.isBlank((CharSequence)(salerName = allBlackListObj.getString("saler_name"))) || !localBlackList.contains(salerName)) continue;
                    blackListAmount = blackListAmount.add(allBlackListObj.getBigDecimal("total_amount"));
                    ++blackListNum;
                    DynamicObject blackListDetail = BusinessDataServiceHelper.newDynamicObject((String)"rim_inv_warning_detail");
                    blackListDetail.set("serial_no", (Object)allBlackListObj.getString("serial_no"));
                    blackListDetail.set("org", (Object)singleOrg);
                    blackListDetail.set("warning_type", (Object)"1");
                    blackListDetail.set("detail_period", (Object)data_period);
                    blackListDetails.add(blackListDetail);
                }
                blackListObj.set("data_type", (Object)"black_list");
                blackListObj.set("data_value", (Object)blackListNum);
                saveBlackListObjs.add(blackListObj);
                DynamicObject blackListObjAmount = this.createDynamicObject(singleOrg, data_period);
                blackListObjAmount.set("data_type", (Object)"black_list_amount");
                blackListObjAmount.set("data_value", (Object)blackListAmount);
                saveBlackListObjs.add(blackListObjAmount);
                if (!CollectionUtils.isEmpty(blackListDetails)) {
                    ImcSaveServiceHelper.saveMassBatchList(blackListDetails);
                }
            }
            JSONObject sensitiveObj = new JSONObject();
            sensitiveObj.put("sensitive_words", (Object)0);
            sensitiveObj.put("sensitive_words_amount", (Object)BigDecimal.ZERO);
            if (ObjectUtils.isEmpty((Object)sensitiveWords)) continue;
            this.getSensitiveWordsList(singleOrg, data_period, sensitiveWordFilters, "rim_inv_ordinary", sensitiveObj, deletedSerialNo);
            this.getSensitiveWordsList(singleOrg, data_period, sensitiveWordFilters, "rim_inv_special", sensitiveObj, deletedSerialNo);
            this.getSensitiveWordsList(singleOrg, data_period, sensitiveWordFilters, "rim_inv_toll", sensitiveObj, deletedSerialNo);
            this.getSensitiveWordsList(singleOrg, data_period, sensitiveWordFilters, "rim_inv_electric", sensitiveObj, deletedSerialNo);
            DynamicObject saveSensitiveNumObj = this.createDynamicObject(singleOrg, data_period, "sensitive_words", sensitiveObj.getInteger("sensitive_words"));
            saveSensitiveWordsObjs.add(saveSensitiveNumObj);
            DynamicObject saveSensitiveAmountObj = this.createDynamicObject(singleOrg, data_period, "sensitive_words_amount", sensitiveObj.getBigDecimal("sensitive_words_amount"));
            saveSensitiveWordsObjs.add(saveSensitiveAmountObj);
        }
        if (!CollectionUtils.isEmpty(saveBlackListObjs)) {
            ImcSaveServiceHelper.saveMassBatchList(saveBlackListObjs);
            saveBlackListObjs.clear();
        }
        if (!CollectionUtils.isEmpty(saveSensitiveWordsObjs)) {
            ImcSaveServiceHelper.saveMassBatchList(saveSensitiveWordsObjs);
            saveSensitiveWordsObjs.clear();
        }
        if (!CollectionUtils.isEmpty(deletedSerialNo)) {
            deletedSerialNo.clear();
        }
    }

    private List<Long> getEinvoice() {
        ArrayList<Long> einvoiceTypes = new ArrayList<Long>();
        einvoiceTypes.add(InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode());
        einvoiceTypes.add(InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode());
        einvoiceTypes.add(InputInvoiceTypeEnum.TOLL_ELECTRON.getCode());
        einvoiceTypes.add(InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode());
        einvoiceTypes.add(InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode());
        return einvoiceTypes;
    }

    private void countEinviceUnoriginal(String data_period, List<Long> orgList) {
        boolean checkFlag;
        Date firstDateOfTheMonth = DateUtils.getFirstDateOfMonth((Date)new Date());
        ArrayList<DynamicObject> saveEinvoiceUnoriginalObjs = new ArrayList<DynamicObject>(16);
        QFilter einvoiceFilter = new QFilter("invoice_type", "in", (Object)new Long[]{InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode(), InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode(), InputInvoiceTypeEnum.TOLL_ELECTRON.getCode()}).and("delete", "=", (Object)"1").and("original_state", "=", (Object)MONTHLY_INVOICE);
        if (!"1".equals(data_period)) {
            einvoiceFilter = einvoiceFilter.and(CREATE_TIME, ">=", (Object)firstDateOfTheMonth);
        }
        if (checkFlag = this.getCheckFlag()) {
            einvoiceFilter = einvoiceFilter.and("check_status", "=", (Object)"1");
        }
        for (Long singleOrg : orgList) {
            if (singleOrg == null) continue;
            QFilter newInvoiceFilter = einvoiceFilter.copy().and("org", "=", (Object)singleOrg);
            DataSet einvoiceDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)RIM_INVOICE, (String)"count (1) as unoriginal_einvoice, sum (total_amount) as unoriginal_einvoice_amount", (QFilter[])newInvoiceFilter.toArray(), null);
            int unoriginalEinvoice = 0;
            BigDecimal unoriginalEinvoiceAmount = BigDecimal.ZERO;
            while (einvoiceDataSet != null && einvoiceDataSet.hasNext()) {
                Row row = einvoiceDataSet.next();
                if (ObjectUtils.isEmpty((Object)singleOrg)) continue;
                unoriginalEinvoice = row.getInteger("unoriginal_einvoice");
                unoriginalEinvoiceAmount = row.getBigDecimal("unoriginal_einvoice_amount");
            }
            DynamicObject einvoiceUnoriginal = this.createDynamicObject(singleOrg, data_period, "unoriginal_einvoice", unoriginalEinvoice);
            saveEinvoiceUnoriginalObjs.add(einvoiceUnoriginal);
            DynamicObject einvoiceUnoriginalAmount = this.createDynamicObject(singleOrg, data_period, "unoriginal_einvoice_amount", unoriginalEinvoiceAmount);
            saveEinvoiceUnoriginalObjs.add(einvoiceUnoriginalAmount);
        }
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_data", (QFilter[])new QFilter("data_type", "in", (Object)new String[]{"unoriginal_einvoice", "unoriginal_einvoice_amount"}).and("data_period", "=", (Object)data_period).toArray());
        ImcSaveServiceHelper.saveMassBatchList(saveEinvoiceUnoriginalObjs);
        saveEinvoiceUnoriginalObjs.clear();
    }

    private void countSpecialUncomplete(String data_period, List<Long> orgList) {
        Date firstDateOfTheMonth = DateUtils.getFirstDateOfMonth((Date)new Date());
        ArrayList<DynamicObject> saveSpecialUncomplete = new ArrayList<DynamicObject>(16);
        Long[] specialElectricType = new Long[]{InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode(), InputInvoiceTypeEnum.SPECIAL_PAPER.getCode(), InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode()};
        QFilter deleteFilter = new QFilter("delete", "!=", (Object)"1").and("invoice_type", "in", (Object)specialElectricType);
        DynamicObjectCollection deletedSpecialInvoice = QueryServiceHelper.query((String)RIM_INVOICE, (String)"serial_no", (QFilter[])deleteFilter.toArray());
        DynamicObjectCollection uncheckSpecialInvoice = null;
        boolean checkFlag = this.getCheckFlag();
        if (checkFlag) {
            QFilter uncheckFilter = new QFilter("check_status", "!=", (Object)"1").and("invoice_type", "in", (Object)specialElectricType);
            uncheckSpecialInvoice = QueryServiceHelper.query((String)RIM_INVOICE, (String)"serial_no", (QFilter[])uncheckFilter.toArray());
        }
        ArrayList<String> deletedSerialNo = null;
        if (!CollectionUtils.isEmpty((Collection)deletedSpecialInvoice)) {
            if (!CollectionUtils.isEmpty(uncheckSpecialInvoice)) {
                deletedSpecialInvoice.addAll(uncheckSpecialInvoice);
            }
            deletedSerialNo = new ArrayList<String>(deletedSpecialInvoice.size());
            for (DynamicObject dynamicObject : deletedSpecialInvoice) {
                if (ObjectUtils.isEmpty((Object)dynamicObject)) continue;
                deletedSerialNo.add(dynamicObject.getString("serial_no"));
            }
        }
        ArrayList<QFilter> specialFilters = new ArrayList<QFilter>(2);
        ArrayList<QFilter> specialFilters1 = new ArrayList<QFilter>(2);
        QFilter nullFilter = new QFilter("buyer_address_phone", "is null", null).or("buyer_account", "is null", null).or("buyer_tax_no", "is null", null).or("buyer_address_phone", "=", (Object)"").or("buyer_account", "=", (Object)"").or("buyer_tax_no", "=", (Object)"");
        QFilter nullFilter1 = new QFilter("buyer_tax_no", "is null", null).or("buyer_tax_no", "=", (Object)"");
        specialFilters.add(nullFilter);
        specialFilters1.add(nullFilter1);
        if (MONTHLY_INVOICE.equals(data_period)) {
            QFilter monthlyFilter = new QFilter(CREATE_TIME, ">=", (Object)firstDateOfTheMonth);
            specialFilters.add(monthlyFilter);
            specialFilters1.add(monthlyFilter);
        }
        List deletedSerialNobatch = new ArrayList();
        ArrayList<String> deletedSerialNoFilter = new ArrayList<String>();
        ArrayList<String> deletedSerialNoFilter1 = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(deletedSerialNo)) {
            deletedSerialNoFilter.addAll(deletedSerialNo);
            deletedSerialNoFilter1.addAll(deletedSerialNo);
            int batchSize = 0;
            String invoiceWarnBatchEnable = RimConfigUtils.getConfig((String)"invoice_warn_batch_enable");
            if ("1".equals(invoiceWarnBatchEnable)) {
                batchSize = 500;
                String invoiceWarnBatch = RimConfigUtils.getConfig((String)"invoice_warn_batch");
                if (StringUtils.isNotBlank((CharSequence)invoiceWarnBatch)) {
                    try {
                        Integer integer = Integer.valueOf(invoiceWarnBatch);
                        batchSize = integer;
                    }
                    catch (NumberFormatException e) {
                        logger.error("\u53d1\u7968\u9884\u8b66\u5206\u6279\u53c2\u6570\u5fc5\u987b\u4e3a\u6570\u5b57\u7c7b\u578b\uff0c\u5f53\u524d\u53c2\u6570\uff0cinvoice_warn_batch\uff1a " + invoiceWarnBatch);
                        e.printStackTrace();
                    }
                }
            }
            if (batchSize > 0 && deletedSerialNo.size() > batchSize) {
                deletedSerialNobatch = BatchDataUtil.splitBatches((int)batchSize, deletedSerialNo);
            } else {
                QFilter deletedFilter = new QFilter("serial_no", "not in", deletedSerialNo);
                specialFilters.add(deletedFilter);
                specialFilters1.add(deletedFilter);
            }
        }
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_data", (QFilter[])new QFilter("data_type", "in", (Object)new String[]{"special_uncompelete", "special_uncompelete_amount"}).and("data_period", "=", (Object)data_period).toArray());
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_detail", (QFilter[])new QFilter("warning_type", "=", (Object)QUERY_TYPE_EINVOICE_UNORIGINAL).and("detail_period", "=", (Object)data_period).toArray());
        ArrayList<DynamicObject> specialUncompeleteDetails = new ArrayList<DynamicObject>(16);
        for (Long singleOrg : orgList) {
            if (singleOrg == null) continue;
            QFilter orgFilter = new QFilter("org", "=", (Object)singleOrg);
            specialFilters.add(orgFilter);
            specialFilters1.add(orgFilter);
            if (!CollectionUtils.isEmpty(deletedSerialNo)) {
                if (CollectionUtils.isEmpty(deletedSerialNoFilter)) {
                    deletedSerialNoFilter.addAll(deletedSerialNo);
                }
                if (CollectionUtils.isEmpty(deletedSerialNoFilter1)) {
                    deletedSerialNoFilter1.addAll(deletedSerialNo);
                }
            }
            if (!CollectionUtils.isEmpty(deletedSerialNobatch)) {
                for (List serialNoList : deletedSerialNobatch) {
                    if (CollectionUtils.isEmpty((Collection)serialNoList)) continue;
                    QFilter deletedFilter = new QFilter("serial_no", "not in", (Object)serialNoList);
                    specialFilters.add(deletedFilter);
                    DataSet specialDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)InputInvoiceTypeEnum.getEntity((Long)InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode()), (String)"serial_no, total_amount as special_uncompelete_amount", (QFilter[])specialFilters.toArray(new QFilter[specialFilters.size()]), null);
                    this.replenishWarnData(data_period, saveSpecialUncomplete, specialUncompeleteDetails, singleOrg, specialDataSet, deletedSerialNoFilter);
                    specialFilters.remove(deletedFilter);
                    specialFilters1.add(deletedFilter);
                    DataSet specialDataSet1 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)InputInvoiceTypeEnum.getEntity((Long)InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode()), (String)"serial_no, total_amount as special_uncompelete_amount", (QFilter[])specialFilters1.toArray(new QFilter[specialFilters1.size()]), null);
                    this.replenishWarnData(data_period, saveSpecialUncomplete, specialUncompeleteDetails, singleOrg, specialDataSet1, deletedSerialNoFilter1);
                    specialFilters1.remove(deletedFilter);
                }
            } else {
                DataSet specialDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)InputInvoiceTypeEnum.getEntity((Long)InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode()), (String)"serial_no, total_amount as special_uncompelete_amount", (QFilter[])specialFilters.toArray(new QFilter[specialFilters.size()]), null);
                this.replenishWarnData(data_period, saveSpecialUncomplete, specialUncompeleteDetails, singleOrg, specialDataSet, deletedSerialNoFilter);
                DataSet specialDataSet1 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)InputInvoiceTypeEnum.getEntity((Long)InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode()), (String)"serial_no, total_amount as special_uncompelete_amount", (QFilter[])specialFilters1.toArray(new QFilter[specialFilters1.size()]), null);
                this.replenishWarnData(data_period, saveSpecialUncomplete, specialUncompeleteDetails, singleOrg, specialDataSet1, deletedSerialNoFilter1);
            }
            specialFilters.remove(orgFilter);
            specialFilters1.remove(orgFilter);
            deletedSerialNoFilter.clear();
            deletedSerialNoFilter1.clear();
        }
        if (!CollectionUtils.isEmpty(specialUncompeleteDetails)) {
            ImcSaveServiceHelper.saveMassBatchList(specialUncompeleteDetails);
            specialUncompeleteDetails.clear();
        }
        if (!CollectionUtils.isEmpty(saveSpecialUncomplete)) {
            ImcSaveServiceHelper.saveMassBatchList(saveSpecialUncomplete);
            saveSpecialUncomplete.clear();
        }
        if (!CollectionUtils.isEmpty(deletedSerialNo)) {
            deletedSerialNo.clear();
        }
    }

    private void replenishWarnData(String data_period, List<DynamicObject> saveSpecialUncomplete, List<DynamicObject> specialUncompeleteDetails, Long singleOrg, DataSet specialDataSet, List<String> deletedSerialNo) {
        boolean addDataFlag = false;
        DynamicObject specialUncompeleteObj = this.createDynamicObject(singleOrg, data_period);
        if (!specialDataSet.isEmpty()) {
            int specialUncompeleteNum = 0;
            BigDecimal specialUncompeleteAmount = BigDecimal.ZERO;
            while (specialDataSet.hasNext()) {
                Row row = specialDataSet.next();
                if (ObjectUtils.isEmpty((Object)singleOrg) || !CollectionUtils.isEmpty(deletedSerialNo) && deletedSerialNo.contains(row.getString("serial_no"))) continue;
                if (!CollectionUtils.isEmpty(deletedSerialNo)) {
                    deletedSerialNo.add(row.getString("serial_no"));
                    addDataFlag = true;
                }
                DynamicObject specialUncompeleteDetail = BusinessDataServiceHelper.newDynamicObject((String)"rim_inv_warning_detail");
                specialUncompeleteDetail.set("serial_no", (Object)row.getString("serial_no"));
                specialUncompeleteDetail.set("org", (Object)singleOrg);
                specialUncompeleteDetail.set("warning_type", (Object)QUERY_TYPE_EINVOICE_UNORIGINAL);
                specialUncompeleteDetail.set("detail_period", (Object)data_period);
                specialUncompeleteDetails.add(specialUncompeleteDetail);
                specialUncompeleteAmount = specialUncompeleteAmount.add(row.getBigDecimal("special_uncompelete_amount"));
                ++specialUncompeleteNum;
            }
            if (addDataFlag || CollectionUtils.isEmpty(deletedSerialNo)) {
                specialUncompeleteObj.set("data_type", (Object)"special_uncompelete");
                specialUncompeleteObj.set("data_value", (Object)specialUncompeleteNum);
                saveSpecialUncomplete.add(specialUncompeleteObj);
                DynamicObject specialUncompeleteAmountObj = this.createDynamicObject(singleOrg, data_period);
                specialUncompeleteAmountObj.set("data_type", (Object)"special_uncompelete_amount");
                specialUncompeleteAmountObj.set("data_value", (Object)specialUncompeleteAmount);
                saveSpecialUncomplete.add(specialUncompeleteAmountObj);
            }
        }
    }

    private void countBeyondExpense(String data_period, List<Long> orgList) {
        Date firstDateOfTheMonth = DateUtils.getFirstDateOfMonth((Date)new Date());
        ArrayList<DynamicObject> saveBeyondExpenses = new ArrayList<DynamicObject>(16);
        QFilter beyondExpenseFilter = "1".equals(data_period) ? new QFilter("expense_status", "in", (Object)new String[]{"60", "30"}).and("delete", "=", (Object)"1") : new QFilter("expense_status", "in", (Object)new String[]{"60", "30"}).and(CREATE_TIME, ">=", (Object)firstDateOfTheMonth).and("delete", "=", (Object)"1");
        boolean checkFlag = this.getCheckFlag();
        if (checkFlag) {
            beyondExpenseFilter = beyondExpenseFilter.and("check_status", "=", (Object)"1");
        }
        ArrayList<DynamicObject> beyondExpenseDetails = new ArrayList<DynamicObject>(16);
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_data", (QFilter[])new QFilter("data_type", "in", (Object)new String[]{"beyond_expense_date", "beyond_expense_date_amount"}).and("data_period", "=", (Object)data_period).toArray());
        ImcSaveServiceHelper.deleteMassBatch((String)"rim_inv_warning_detail", (QFilter[])new QFilter("warning_type", "=", (Object)"5").and("detail_period", "=", (Object)data_period).toArray());
        Date currentDate = new Date();
        for (Long singleOrg : orgList) {
            if (singleOrg == null) continue;
            QFilter newBeyondExpenseFilter = beyondExpenseFilter.copy().and("org", "=", (Object)singleOrg);
            DynamicObjectCollection beyondExpenseObjs = QueryServiceHelper.query((String)RIM_INVOICE, (String)"serial_no, invoice_date,expense_time,total_amount,org", (QFilter[])newBeyondExpenseFilter.toArray());
            DynamicObject beyondExpenseObj = this.createDynamicObject(singleOrg, data_period);
            HashMap<String, Long> orgMap = new HashMap<String, Long>(1);
            orgMap.put("orgId", singleOrg);
            JSONObject verifyConfig = VerifyService.getVerfifyConfig(orgMap);
            int beyondExpenseNum = 0;
            BigDecimal beyondExpenseAmount = BigDecimal.ZERO;
            for (DynamicObject expenseObj : beyondExpenseObjs) {
                boolean isCrossMonth;
                String deadLineStr;
                if (ObjectUtils.isEmpty((Object)expenseObj) || ObjectUtils.isEmpty((Object)verifyConfig)) continue;
                Date invoiceDate = expenseObj.getDate("invoice_date");
                Date expenseTime = expenseObj.getDate("expense_time");
                BigDecimal invoiceAmount = expenseObj.getBigDecimal("total_amount");
                if (ObjectUtils.isEmpty((Object)expenseTime) || ObjectUtils.isEmpty((Object)invoiceDate) || StringUtils.isEmpty((CharSequence)(deadLineStr = verifyConfig.getString("deadline_date")))) continue;
                int deadLine = Integer.parseInt(deadLineStr);
                if ((expenseTime.getTime() - invoiceDate.getTime()) / 86400000L > (long)deadLine) {
                    ++beyondExpenseNum;
                    beyondExpenseAmount = beyondExpenseAmount.add(invoiceAmount);
                    beyondExpenseDetails.add(this.buildWarningDetail(expenseObj.getString("serial_no"), singleOrg, "5", data_period));
                    continue;
                }
                String expenseNextYear = verifyConfig.getString("expense_next_year");
                if (expenseTime.getYear() - invoiceDate.getYear() > 0 && MONTHLY_INVOICE.equals(expenseNextYear)) {
                    ++beyondExpenseNum;
                    beyondExpenseAmount = beyondExpenseAmount.add(invoiceAmount);
                    beyondExpenseDetails.add(this.buildWarningDetail(expenseObj.getString("serial_no"), singleOrg, "5", data_period));
                    continue;
                }
                String nextExpenseMonthStr = verifyConfig.getString("next_year_month");
                if (StringUtils.isEmpty((CharSequence)nextExpenseMonthStr)) continue;
                int nextExpenseMonth = Integer.parseInt(nextExpenseMonthStr);
                int isCrossYear = expenseTime.getYear() - currentDate.getYear();
                boolean bl = isCrossMonth = expenseTime.getMonth() > nextExpenseMonth - 1;
                if (isCrossYear <= 0 || !isCrossMonth || !"1".equals(expenseNextYear)) continue;
                beyondExpenseAmount = beyondExpenseAmount.add(invoiceAmount);
                ++beyondExpenseNum;
                beyondExpenseDetails.add(this.buildWarningDetail(expenseObj.getString("serial_no"), singleOrg, "5", data_period));
            }
            beyondExpenseObj.set("data_type", (Object)"beyond_expense_date");
            beyondExpenseObj.set("data_value", (Object)beyondExpenseNum);
            saveBeyondExpenses.add(beyondExpenseObj);
            DynamicObject beyondExpenseAmountObj = this.createDynamicObject(singleOrg, data_period);
            beyondExpenseAmountObj.set("data_type", (Object)"beyond_expense_date_amount");
            beyondExpenseAmountObj.set("data_value", (Object)beyondExpenseAmount);
            saveBeyondExpenses.add(beyondExpenseAmountObj);
        }
        if (!CollectionUtils.isEmpty(beyondExpenseDetails)) {
            ImcSaveServiceHelper.saveMassBatchList(beyondExpenseDetails);
            beyondExpenseDetails.clear();
        }
        if (!CollectionUtils.isEmpty(saveBeyondExpenses)) {
            ImcSaveServiceHelper.saveMassBatchList(saveBeyondExpenses);
            saveBeyondExpenses.clear();
        }
    }

    private DynamicObject buildWarningDetail(JSONObject beyondObj, String warningType, String detailPeriod) {
        String serialNo = beyondObj.getString("SERIAL_NO");
        Long singleOrg = beyondObj.getLong("ORG");
        return this.buildWarningDetail(serialNo, singleOrg, warningType, detailPeriod);
    }

    private DynamicObject buildWarningDetail(String serialNo, Long singleOrg, String warningType, String detailPeriod) {
        DynamicObject detailObj = BusinessDataServiceHelper.newDynamicObject((String)"rim_inv_warning_detail");
        detailObj.set("serial_no", (Object)serialNo);
        detailObj.set("org", (Object)singleOrg);
        detailObj.set("warning_type", (Object)warningType);
        detailObj.set("detail_period", (Object)detailPeriod);
        return detailObj;
    }

    private void getSensitiveWordsList(Long singleOrg, String data_period, List<QFilter> sensitiveWordFilters, String table, JSONObject sensitiveResultObj, List<String> deletedSerialNos) {
        int countSensitiveWords = 0;
        BigDecimal sumSensitiveWordsAmount = BigDecimal.ZERO;
        DynamicObjectCollection sensitiveWordsObjs = QueryServiceHelper.query((String)table, (String)"serial_no, total_amount", (QFilter[])sensitiveWordFilters.toArray(new QFilter[sensitiveWordFilters.size()]));
        if (!CollectionUtils.isEmpty((Collection)sensitiveWordsObjs)) {
            ArrayList<DynamicObject> sensitiveWordsDetails = new ArrayList<DynamicObject>(16);
            HashSet<String> countedSerialNos = new HashSet<String>(16);
            String serialNo = null;
            for (DynamicObject dynamicObject : sensitiveWordsObjs) {
                if (ObjectUtils.isEmpty((Object)dynamicObject)) continue;
                serialNo = dynamicObject.getString("serial_no");
                if (!CollectionUtils.isEmpty(deletedSerialNos) && deletedSerialNos.contains(serialNo) || countedSerialNos.contains(serialNo)) continue;
                DynamicObject sensitiveWordsDetail = BusinessDataServiceHelper.newDynamicObject((String)"rim_inv_warning_detail");
                sensitiveWordsDetail.set("serial_no", (Object)serialNo);
                sensitiveWordsDetail.set("org", (Object)singleOrg);
                sensitiveWordsDetail.set("warning_type", (Object)QUERY_TYPE_CHECK_FAIL);
                sensitiveWordsDetail.set("detail_period", (Object)data_period);
                ++countSensitiveWords;
                sumSensitiveWordsAmount = sumSensitiveWordsAmount.add(dynamicObject.getBigDecimal("total_amount"));
                sensitiveWordsDetails.add(sensitiveWordsDetail);
                countedSerialNos.add(serialNo);
            }
            sensitiveResultObj.put("sensitive_words", (Object)(countSensitiveWords + sensitiveResultObj.getInteger("sensitive_words")));
            sensitiveResultObj.put("sensitive_words_amount", (Object)(countSensitiveWords + sensitiveResultObj.getInteger("sensitive_words_amount")));
            if (!CollectionUtils.isEmpty(sensitiveWordsDetails)) {
                ImcSaveServiceHelper.saveMassBatchList(sensitiveWordsDetails);
            }
            if (CollectionUtils.isNotEmpty(countedSerialNos)) {
                countedSerialNos.clear();
            }
        }
    }

    private String getVatType() {
        Long[] types;
        StringBuilder sb = new StringBuilder();
        for (Long type : types = InputInvoiceTypeEnum.getVatTypes()) {
            if (sb.length() > 1) {
                sb.append(',');
            }
            sb.append(type);
        }
        return sb.toString();
    }
}

