/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.collector;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.recognitionnew.task.FileUploadAndSignTask;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.file.utils.FileConvertUtils;

public class OverseaInvoiceCollectEnterPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(OverseaInvoiceCollectEnterPlugin.class);
    private static final String submitButton = "save_btn";

    public void registerListener(EventObject e) {
        Button submitbutton = (Button)this.getControl(submitButton);
        submitbutton.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (submitButton.equals(control.getKey())) {
            this.enterOverseaInvoice();
        }
    }

    private void putOverseaInvoiceFile(JSONObject invoiceData) {
        Map file;
        AttachmentPanel panel = (AttachmentPanel)this.getControl("attachmentpanelap");
        List fileInfos = panel.getAttachmentData();
        if (!CollectionUtils.isEmpty((Collection)fileInfos) && !(file = (Map)fileInfos.get(0)).isEmpty()) {
            String url = (String)file.get("url");
            String name = (String)file.get("name");
            if (FileUtils.checkFileType((String)name, (String[])new String[]{"pdf", "ofd", "jpg", "png"})) {
                TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                try (InputStream inputStream = tempFileCache.getInputStream(url);){
                    String path = FileUploadUtils.upload((String)(FileUploadUtils.getInvoiceDir((String)"invoice") + name), (String)name, (InputStream)inputStream);
                    invoiceData.put("fileType", (Object)FileUtils.getFileType((String)path));
                    invoiceData.put("originalState", (Object)"0");
                    invoiceData.put("fileName", (Object)name);
                    try (InputStream fileInputStream = UrlServiceUtils.getAttachmentDecodedStream((InputStream)FileServiceFactory.getAttachmentFileService().getInputStream(path));){
                        byte[] fileContent = FileUtils.getByte((InputStream)fileInputStream);
                        if (fileContent == null) {
                            invoiceData.put("fileType", (Object)"2");
                            invoiceData.put("imageUrl", (Object)path);
                            invoiceData.put("snapshotUrl", (Object)path);
                            return;
                        }
                        FileUploadAndSignTask fileUploadAndSignTask = new FileUploadAndSignTask(path, fileContent, name, FileUtils.getFileType((String)path), FileConvertUtils.getSHA256((byte[])fileContent), false, "1", RequestContext.get());
                        JSONObject fileDetail = fileUploadAndSignTask.call();
                        invoiceData.putAll((Map)fileDetail);
                    }
                }
                catch (Exception e) {
                    logger.info("\u6d77\u5916\u53d1\u7968\u624b\u5de5\u5f55\u5165-\u5feb\u7167\u751f\u6210\u5931\u8d25\uff1a{}", (Object)e);
                }
            }
        }
    }

    private void enterOverseaInvoice() {
        JSONObject invoiceData = this.getValueObj();
        InvoiceSaveService invoiceSaveService = InvoiceSaveService.newInstance((String)(InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode() + ""));
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        if (invoiceSaveService != null) {
            ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
            try {
                this.putOverseaInvoiceFile(invoiceData);
                InvoiceSaveResult saveResult = invoiceSaveService.save(invoiceData);
                invoiceData.put("serialNo", (Object)saveResult.getSerialNo());
                invoiceData.put("invoice_info", (Object)saveResult.getInvoiceInfo());
                invoiceIds.add((Long)saveResult.getMainId());
                customParams.put("invoice", invoiceData);
                customParams.put("invoiceIds", invoiceIds);
            }
            catch (Exception e) {
                logger.info("\u6d77\u5916\u53d1\u7968\u624b\u5de5\u5f55\u5165\u4fdd\u5b58\u5931\u8d25:{}", (Object)e);
            }
        }
        if (customParams.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"InvSignByExpensePlugin_110", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().returnDataToParent(customParams);
            this.getView().close();
        }
    }

    private JSONObject getValueObj() {
        JSONObject invoiceData = new JSONObject();
        String invoiceNo = (String)this.getModel().getValue("invoiceno");
        String invoiceDate = "";
        Object invoiceDateValue = this.getModel().getValue("invoicedate");
        if (invoiceDateValue instanceof Date) {
            invoiceDate = DateUtils.format((Date)((Date)invoiceDateValue), (String)"yyyyMMdd");
        }
        BigDecimal totalAmount = (BigDecimal)this.getModel().getValue("totalamount");
        BigDecimal totalTaxAmount = (BigDecimal)this.getModel().getValue("totaltaxamount");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        String buyerName = (String)this.getModel().getValue("buyer_name");
        String salerName = (String)this.getModel().getValue("saler_name");
        String dueDate = "";
        Object dueDateValue = this.getModel().getValue("due_date");
        if (dueDateValue instanceof Date) {
            dueDate = DateUtils.format((Date)((Date)dueDateValue), (String)"yyyyMMdd");
        }
        invoiceData.put("invoiceType", (Object)InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode());
        invoiceData.put("invoiceNo", (Object)invoiceNo);
        invoiceData.put("invoiceDate", (Object)invoiceDate);
        invoiceData.put("totalAmount", (Object)totalAmount);
        invoiceData.put("totalTaxAmount", (Object)totalTaxAmount);
        invoiceData.put("currencyName", (Object)currency.getString("name"));
        invoiceData.put("currencyId", currency.getPkValue());
        invoiceData.put("buyerName", (Object)buyerName);
        invoiceData.put("salerName", (Object)salerName);
        invoiceData.put("dueDate", (Object)dueDate);
        JSONObject businessParam = null;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("businessParam") != null) {
            businessParam = JSON.parseObject((String)customParams.get("businessParam").toString());
            invoiceData.putAll((Map)businessParam);
        }
        invoiceData.put("serialNo", (Object)UUID.randomUUID());
        return invoiceData;
    }
}

