/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;

public class BatchDeductBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String CACHE_KEY = "BatchDeductBillPluginNumber";

    public void registerListener(EventObject e) {
        BasedataEdit base = (BasedataEdit)this.getView().getControl("taxpayer_org");
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Long orgId = RequestContext.get().getOrgId();
        this.getModel().setValue("org", (Object)orgId);
    }

    public void afterBindData(EventObject e) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long pkValue = (Long)dataEntity.getPkValue();
        if (pkValue <= 0L) {
            this.setNumber();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("taxpayer_org".equals(name)) {
            ChangeData[] changeData = e.getChangeSet();
            ChangeData changeDatum = changeData[0];
            int rowIndex = changeDatum.getRowIndex();
            DynamicObject newValue = (DynamicObject)changeDatum.getNewValue();
            if (newValue != null) {
                this.setOrgTaxNo(newValue, rowIndex);
            }
        }
    }

    private void setOrgTaxNo(DynamicObject org, int rowIndex) {
        long orgId = org.getLong("id");
        Map companyNameAndTaxNo = TenantUtils.getCompanyNameAndTaxNoByOrgId((Long)orgId);
        if (companyNameAndTaxNo != null && !StringUtils.isEmpty((CharSequence)((CharSequence)companyNameAndTaxNo.get("taxNo")))) {
            this.getModel().setValue("taxpayer_name", companyNameAndTaxNo.get("name"), rowIndex);
            this.getModel().setValue("taxpayer_tax_no", companyNameAndTaxNo.get("taxNo"), rowIndex);
            String dkType = (String)companyNameAndTaxNo.get("dkType");
            if (StringUtils.equals((CharSequence)"4", (CharSequence)dkType)) {
                this.getModel().setValue("is_all_ele", (Object)"1", rowIndex);
            }
        } else {
            this.getModel().setValue("taxpayer_name", null, rowIndex);
            this.getModel().setValue("taxpayer_tax_no", null, rowIndex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"rim_batch_deduct", (String)"47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            QFilter idQFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            ListShowParameter formShowParameter = (ListShowParameter)arg0.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(idQFilter);
        }
    }

    private void setNumber() {
        String numberPre = "FPYDW" + DateUtils.format((Date)new Date(), (String)"yyyyMMdd");
        String number = UUID.getNumber((String)numberPre, (String)CACHE_KEY, (String)this.getView().getEntityId());
        this.getModel().setValue("number", (Object)number);
    }
}

