/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BadgeInfo;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.deduction.SelectAccountService;
import kd.imc.rim.common.invoice.model.SelectLog;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.formplugin.deduction.BatchDeductService;

public class BatchDeductListPlugin
extends AbstractListPlugin {
    private static Log LOGGER = LogFactory.getLog(BatchDeductListPlugin.class);
    private static final String RESULT_SUM = "result_sum";

    public void afterCreateNewData(EventObject e) {
        this.refresh();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"batch_deduct")) {
            BillList billListb = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billListb.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BatchDeductListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_batch_deduct", (String)"id,name,userorg.taxpayer_org AS taxpayer_org,userorg.taxpayer_name AS taxpayer_name,userorg.taxpayer_tax_no AS taxpayer_tax_no,userorg.confirm_secret AS confirm_secret", (QFilter[])qFilter.toArray());
            String taskNo = UUID.randomUUID();
            ArrayList<Long> logIdList = new ArrayList<Long>(collection.size());
            AtomicInteger sumNum = new AtomicInteger();
            for (DynamicObject dynamicObject : collection) {
                Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.get("taxpayer_org"));
                long logId = this.insertLog(taskNo, dynamicObject.getString("taxpayer_tax_no"), orgId, sumNum);
                logIdList.add(logId);
            }
            this.refreshViewResultBadgeInfo(sumNum.get());
            ThreadPools.executeOnceIncludeRequestContext((String)"BatchDeductListPlugin.deductSync", () -> BatchDeductService.batchDeduct(logIdList.toArray(), null));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5904\u7406\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\uff0c\u7a0d\u540e\u70b9\u51fb\u3010\u67e5\u770b\u62b5\u6263\u7ed3\u679c\u3011\u67e5\u770b\u8fdb\u5ea6\u5e76\u4e0b\u8f7d\u7ed3\u679c\u3002", (String)"BatchDeductListPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"view_result")) {
            ListShowParameter showParameter = new ListShowParameter();
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            filters.add(new QFilter("creater.id", "=", (Object)Long.parseLong(RequestContext.get().getUserId())));
            filters.add(new QFilter("create_time", ">=", (Object)this.getStartDate()));
            showParameter.setFormId("bos_list");
            showParameter.setBillFormId("rim_select_log_layout");
            listFilterParameter.setQFilters(filters);
            showParameter.setListFilterParameter(listFilterParameter);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("refresh".equals(operateKey)) {
            this.refresh();
        }
    }

    private void refresh() {
        QFilter userFilter = new QFilter("creater.id", "=", (Object)Long.parseLong(RequestContext.get().getUserId()));
        QFilter timeFilter = new QFilter("create_time", ">=", (Object)this.getStartDate());
        QFilter operateFilter = new QFilter("operate_type", "=", (Object)"9");
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"rim_select_log", (String)"id", (QFilter[])new QFilter[]{userFilter, timeFilter, operateFilter});
        this.getPageCache().remove(RESULT_SUM);
        this.refreshViewResultBadgeInfo(objects.size());
    }

    private Date getStartDate() {
        int maxDateInt = InvoiceDownloadConstant.getPageSizeFromConfig((int)30, (String)"batch_deduct_days");
        return DateUtils.getDayStart((Date)DateUtils.addDay((Date)new Date(), (int)(0 - maxDateInt)));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
    }

    private void refreshViewResultBadgeInfo(int sum) {
        Toolbar functionToolBarRight = (Toolbar)this.getControl("toolbarap");
        String chche = this.getPageCache().get(RESULT_SUM);
        if (StringUtils.isNotEmpty((CharSequence)chche)) {
            sum += Integer.parseInt(chche);
        }
        this.getPageCache().put(RESULT_SUM, String.valueOf(sum));
        BadgeInfo checkFailInfo = new BadgeInfo();
        checkFailInfo.setOverflowCount(Integer.valueOf(99));
        checkFailInfo.setOffset(new String[]{"-5px", "-5px"});
        checkFailInfo.setDot(false);
        checkFailInfo.setCount(Integer.valueOf(sum));
        functionToolBarRight.setBadgeInfo("view_result", checkFailInfo);
    }

    private long insertLog(String taskNo, String taxNo, Long orgId, AtomicInteger sumNum) {
        QFilter userFilter = new QFilter("creater.id", "=", (Object)Long.parseLong(RequestContext.get().getUserId()));
        QFilter timeFilter = new QFilter("create_time", ">=", (Object)this.getStartDate());
        QFilter taxNoFilter = new QFilter("tax_no", "=", (Object)taxNo);
        QFilter operateFilter = new QFilter("operate_type", "=", (Object)"9");
        QFilter handleFilter = new QFilter("handle_status", "=", (Object)"3");
        DynamicObject log = QueryServiceHelper.queryOne((String)"rim_select_log", (String)"id", (QFilter[])new QFilter[]{taxNoFilter, userFilter, timeFilter, operateFilter, handleFilter});
        if (log != null) {
            return log.getLong("id");
        }
        sumNum.addAndGet(1);
        String batchNo = UUID.getBatchNoByTaxNo((String)taxNo);
        SelectLog selectLog = new SelectLog();
        selectLog.setTaskNo(batchNo);
        selectLog.setBatchNo(taskNo);
        selectLog.setSelectType("6");
        selectLog.setOperateType("9");
        selectLog.setSelectOperaType("1");
        selectLog.setOrgId(orgId);
        selectLog.setTaxNo(taxNo);
        selectLog.setHandleStatus("3");
        selectLog.setSelectType("6");
        return SelectAccountService.insertSelectLog((SelectLog)selectLog);
    }
}

