/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.HolytaxInvoiceTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.constant.StatisticsStatusEnum;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.deduction.DeductStatisticsService;
import kd.imc.rim.common.plugin.ProgressFormPlugin;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.compress.utils.Lists;

public class CurrentDeductStatisticsPlugin
extends ProgressFormPlugin
implements TabSelectListener,
BeforeF7SelectListener,
ProgresssListener {
    private static Log LOGGER = LogFactory.getLog(CurrentDeductStatisticsPlugin.class);
    private static final String CURRENT_STATISTICSE_NTRYENTITY = "entryentity_cur";
    private static final String CURRENT_WIZARDAP = "wizardap";
    private static final String KEY_DATA_FLEX = "flex_current_invoice";
    private static final String BATCH_NO_CREATE_STATISTICS = "batch_no_create_statistics";
    private static final String BATCH_NO_CANCEL_STATISTICS = "batch_no_cancel_statistics";
    private static final String BATCH_NO_CONFIRM_STATISTICS = "batch_no_confirm_statistics";
    private static final String TAX_NO = "tax_no";
    private static final String COMPANY_NAME = "company_name";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String KEY_LOADING_PARAM = "loading_param";
    private static final String STOP_FLAG = "stop_flag";
    private static final String EXPORT = "export";
    private static final String BATCH_NO = "batch_no";
    private static final String RESULT_CACHE = "result_cache:";
    public static final String QUERY_CURRENT_STATISTICS = "query_current_statistics";
    private static final String CANCE_STATISTICS = "cance_statistics";
    private static final String CONFIRM_STATISTICS = "confirm_statistics";
    private static final String CREATE_STATISTICS = "create_statistics";
    private static final String QUERY_LQ_INVOICES = "query_lq_invoices";

    public void registerListener(EventObject e) {
        Tab tab1 = (Tab)this.getView().getControl("tabap");
        tab1.addTabSelectListener((TabSelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit base = (BasedataEdit)this.getView().getControl("org");
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap11"});
        ProgressBar progressbar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        this.setCompanyInfo();
        this.initView();
        String unittestFlag = RimConfigUtils.getConfig((String)"unit_test_flag");
        if ("1".equals(unittestFlag)) {
            this.showInvoiceLists(this.getCurrentOrgId());
        } else {
            this.getView().addClientCallBack("queryInvoice", Integer.valueOf(100));
        }
    }

    private void initView() {
        this.getView().setVisible(Boolean.FALSE, new String[]{CANCE_STATISTICS, CONFIRM_STATISTICS, CREATE_STATISTICS});
        this.setStep(CURRENT_WIZARDAP, 0, "process");
        Label labelCurPeriod = (Label)this.getView().getControl("label_cur_period");
        labelCurPeriod.setText(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5c5e\u671f:%s", (String)"CurrentDeductStatisticsPlugin_49", (String)"imc-rim-formplugin", (Object[])new Object[0]), ""));
        this.setStatisticsStatus("");
        Label labelUpdateTime = (Label)this.getView().getControl("label_cur_updatetime");
        labelUpdateTime.setText(String.format(ResManager.loadKDString((String)"\u7edf\u8ba1\u8868\u66f4\u65b0\u65f6\u95f4:%s", (String)"CurrentDeductStatisticsPlugin_50", (String)"imc-rim-formplugin", (Object[])new Object[0]), ""));
        this.getModel().setValue("updatetime", null);
        this.getModel().deleteEntryData(CURRENT_STATISTICSE_NTRYENTITY);
    }

    private void setCompanyInfo() {
        Map companyInfo = DeductStatisticsService.getCompanyNameAndTaxNo((Long)this.getCurrentOrgId(), (Long)this.getTaxOrgId());
        String taxNo = "";
        String companyName = "";
        if (!CollectionUtils.isEmpty((Map)companyInfo)) {
            taxNo = Optional.ofNullable(companyInfo.get("taxNo")).filter(StringUtils::isNotEmpty).orElse("");
            companyName = Optional.ofNullable(companyInfo.get("name")).filter(StringUtils::isNotEmpty).orElse("");
        }
        Label labeCurrentName = (Label)this.getView().getControl("label_cur_name");
        labeCurrentName.setText(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u540d\u79f0:%s", (String)"CurrentDeductStatisticsPlugin_51", (String)"imc-rim-formplugin", (Object[])new Object[0]), companyName));
        Label labelCurrentTaxno = (Label)this.getView().getControl("label_cur_taxno");
        labelCurrentTaxno.setText(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7:%s", (String)"CurrentDeductStatisticsPlugin_52", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxNo));
        String dkType = DeductionConstant.getDkType((String)taxNo);
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)this.getCurrentOrgId(), (AbstractFormPlugin)this);
        if (deductService != null) {
            deductService.getTaxPeriod();
        }
        if ("5".equals(dkType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{QUERY_LQ_INVOICES});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{QUERY_LQ_INVOICES});
        }
        Label labeCurrentTaxPeriod = (Label)this.getView().getControl("label_curr_tax_period");
        labeCurrentTaxPeriod.setText(DeductionConstant.getSkssq((String)taxNo));
        this.getModel().setValue(TAX_NO, (Object)taxNo);
        this.getModel().setValue(COMPANY_NAME, (Object)companyName);
    }

    private void showInvoiceLists(Long orgId) {
        String taxNo = (String)this.getModel().getValue(TAX_NO);
        ListShowParameter showParameter = new ListShowParameter();
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        showParameter.setFormId("bos_list");
        Map parameter = this.getView().getFormShowParameter().getCustomParams();
        String formId = "rim_invoice";
        Object mainFormId = parameter.get("mainformid");
        if (StringUtils.isNotBlank(mainFormId)) {
            formId = mainFormId.toString();
        }
        showParameter.setBillFormId(formId);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.putAll(parameter);
        customParams.put("querytype", "current_period");
        customParams.put("invoicetype", 0L);
        String skssq = DeductionConstant.getSkssq((String)taxNo);
        Date taxPeriod = DateUtils.getFirstDateOfMonth((Date)new Date());
        if (StringUtils.isNotEmpty((CharSequence)skssq)) {
            taxPeriod = DateUtils.stringToDate((String)skssq, (String)"yyyyMM");
        }
        JSONObject orgFilter = new JSONObject();
        List orgIdList = TenantUtils.queryChildOrgIdList((String)taxNo);
        if (orgIdList != null && !orgIdList.isEmpty() && orgId != null && !orgIdList.contains(orgId)) {
            orgIdList.add(orgId);
        }
        orgFilter.put("orgIds", (Object)orgIdList);
        Long taxOrgId = this.getTaxOrgId();
        if (taxOrgId != null) {
            ArrayList taxIdList = Lists.newArrayList();
            taxIdList.add(taxOrgId);
            orgFilter.put("taxOrgIds", (Object)taxIdList);
        }
        orgFilter.put("tax_period", (Object)taxPeriod);
        customParams.put("filters", orgFilter);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(new QFilter("invoice_type", "in", (Object)InputInvoiceTypeEnum.getDeductionAllTypes()));
        QFilter tenantFilter = new QFilter("tenant_no", "=", (Object)TenantUtils.getTenantNo());
        QFilter delFilter = new QFilter("delete", "=", (Object)"1");
        QFilter taxNoFilter = new QFilter("buyer_tax_no", "=", (Object)taxNo);
        QFilter taxPeriodFilter = new QFilter("tax_period", "=", (Object)taxPeriod);
        String showUncheckConfig = RimConfigUtils.getConfig((String)"show_uncheck");
        Boolean needShow = Boolean.TRUE;
        if (StringUtils.isBlank((CharSequence)showUncheckConfig) || "0".equals(showUncheckConfig)) {
            needShow = Boolean.FALSE;
        }
        if (!needShow.booleanValue()) {
            QFilter checkFilter = new QFilter("check_status", "in", (Object)new String[]{"1", "4"});
            filters.add(checkFilter);
        }
        QFilter deductionPurposeFilter = new QFilter("deduction_purpose", "in", (Object)new String[]{"1", "2"});
        QFilter authenticateFilter = new QFilter("authenticate_flag", "in", (Object)new String[]{"1", "2", "3"});
        filters.add(deductionPurposeFilter);
        filters.add(tenantFilter);
        filters.add(delFilter);
        filters.add(taxNoFilter);
        filters.add(authenticateFilter);
        filters.add(taxPeriodFilter);
        listFilterParameter.setQFilters(filters);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5f53\u671f\u62b5\u6263\u52fe\u9009\u53d1\u7968", (String)"CurrentDeductStatisticsPlugin_53", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        showParameter.setShowTitle(false);
        showParameter.setCustomParams(customParams);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rim_invoice"));
        showParameter.setListFilterParameter(listFilterParameter);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(KEY_DATA_FLEX);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if ("org".equals(fieldKey) || "taxorg".equals(fieldKey)) {
            this.setCompanyInfo();
            this.initView();
            this.getView().addClientCallBack("queryInvoice", Integer.valueOf(100));
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        String name = e.getName();
        Object batchNo = null;
        if ("queryInvoice".equals(name)) {
            this.showInvoiceLists(this.getCurrentOrgId());
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (CONFIRM_STATISTICS.equals(actionId)) {
            Object confirmSecret = closedCallBackEvent.getReturnData();
            if (ObjectUtils.isEmpty((Object)confirmSecret)) {
                return;
            }
            this.confirmStatistics((String)confirmSecret);
        } else if ("fpdk_dkgx_dktjcx".equals(actionId)) {
            if ("success".equals(closedCallBackEvent.getReturnData())) {
                this.queryCurrentStatistics();
            }
        } else if ("fpdk_scdktjbb".equals(actionId)) {
            if ("success".equals(closedCallBackEvent.getReturnData())) {
                this.createStatistics();
            }
        } else if ("fpdk_qxdktjbb".equals(actionId)) {
            if ("success".equals(closedCallBackEvent.getReturnData())) {
                this.cancelStatistics();
            }
        } else if ("fpdk_gxConfirm".equals(actionId)) {
            if ("success".equals(closedCallBackEvent.getReturnData())) {
                // empty if block
            }
        } else if ("rim_invoice".equals(actionId)) {
            if ("close".equals(closedCallBackEvent.getReturnData())) {
                this.getView().close();
            }
        } else if (actionId != null && actionId.indexOf("loginAfter") == 0 && StringUtils.isNotBlank((Object)closedCallBackEvent.getReturnData())) {
            this.doOperate(actionId.replace("loginAfter", ""));
        }
    }

    private void exportData() {
        boolean isAllowExport;
        String tjbbStatus = (String)this.getModel().getValue("tjbb_status");
        boolean bl = isAllowExport = "02".equals(tjbbStatus) || "03".equals(tjbbStatus) || "04".equals(tjbbStatus) || "05".equals(tjbbStatus) || "24".equals(tjbbStatus) || "25".equals(tjbbStatus);
        if (!isAllowExport) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7edf\u8ba1\u6570\u636e", (String)"CurrentDeductStatisticsPlugin_55", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String taxNo = (String)this.getModel().getValue(TAX_NO);
        String taxperiod = DeductionConstant.getSkssq((String)taxNo);
        String dkType = DeductionConstant.getDkType((String)taxNo);
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)this.getCurrentOrgId(), (AbstractFormPlugin)this);
        if (deductService == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (String)"CurrentDeductStatisticsPlugin_54", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CURRENT_STATISTICSE_NTRYENTITY);
        Date updateTime = (Date)this.getModel().getValue("updatetime");
        Long orgId = this.getCurrentOrgId();
        String companyName = (String)this.getModel().getValue(COMPANY_NAME);
        this.startProgress(EXPORT, "", taxNo, "", "");
        RequestContext requestContext = RequestContext.get();
        String batchNo = UUID.randomUUID();
        this.getPageCache().put(BATCH_NO, batchNo);
        String cacheKey = RESULT_CACHE + this.getView().getPageId() + batchNo;
        ThreadPools.executeOnceIncludeRequestContext((String)"CurrentStatisticsService.export", () -> {
            RequestContext.copyAndSet((RequestContext)requestContext);
            JSONObject result = null;
            try {
                JSONObject queryJson = deductService.queryHistoryStatistics(taxNo, DateUtils.format((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyyMM"), (String)"yyyy-MM"));
                if (queryJson != null && ResultContant.isSuccess((JSONObject)queryJson).booleanValue()) {
                    if (CollectionUtils.isEmpty((Collection)queryJson.getJSONArray("data"))) {
                        result = ResultContant.createJSONObject((String)"0102", (String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5df2\u52fe\u9009\u53d1\u7968\u660e\u7ec6", (String)"CurrentDeductStatisticsPlugin_56", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        CacheHelper.put((String)cacheKey, (String)SerializationUtils.toJsonString((Object)result), (int)60);
                        return;
                    }
                } else {
                    String description = queryJson != null ? queryJson.getString("description") : "";
                    result = ResultContant.createJSONObject((String)"0102", (String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5df2\u52fe\u9009\u53d1\u7968\u660e\u7ec6\u5931\u8d25\uff1a%1$s", (String)"CurrentDeductStatisticsPlugin_57", (String)"imc-rim-formplugin", (Object[])new Object[0]), description));
                    CacheHelper.put((String)cacheKey, (String)SerializationUtils.toJsonString((Object)result), (int)60);
                    return;
                }
                result = DeductStatisticsService.exportData((DynamicObjectCollection)entryEntity, (JSONObject)queryJson, (Long)orgId, (String)taxNo, (String)companyName, (Date)updateTime, (String)ResManager.loadKDString((String)"\u5f53\u671f\u62b5\u6263\u53d1\u7968\u7edf\u8ba1\u8868", (String)"CurrentDeductStatisticsPlugin_58", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)taxperiod);
                CacheHelper.put((String)cacheKey, (String)SerializationUtils.toJsonString((Object)result), (int)60);
            }
            catch (Exception e) {
                LOGGER.error("\u5f53\u671f\u7edf\u8ba1\u8868\u67e5\u8be2\u62a5\u9519" + taxNo, (Throwable)e);
                result = ResultContant.createJSONObject((String)"0001", (String)e.getMessage());
                CacheHelper.put((String)cacheKey, (String)SerializationUtils.toJsonString((Object)result), (int)60);
            }
        });
    }

    private void handleConfirmStatistics(JSONObject result, String dkType) {
        JSONObject data = result.getJSONObject("data");
        String createTjbbStatus = "05";
        if (data != null && StringUtils.isNotEmpty((CharSequence)data.getString("createTjbbStatus"))) {
            createTjbbStatus = data.getString("createTjbbStatus");
        }
        this.setStatisticsStatus(createTjbbStatus);
        Boolean visiable = Boolean.FALSE;
        this.getView().setVisible(visiable, new String[]{CONFIRM_STATISTICS});
        this.setStep(CURRENT_WIZARDAP, 2, "finish");
        this.updateInvoiceStatus("2", dkType, result);
    }

    private void updateInvoiceStatus(String authenticateFlag, String dkTpye, JSONObject result) {
        boolean update = true;
        if ("3".equals(dkTpye) || "5".equals(dkTpye)) {
            update = this.isFinish(result);
        }
        if (update) {
            String taxNo = (String)this.getModel().getValue(TAX_NO);
            this.getView().getPageCache().remove(BATCH_NO_CONFIRM_STATISTICS);
            DeductInvoiceOperateService deductInvoiceOperateService = new DeductInvoiceOperateService();
            deductInvoiceOperateService.updateAuthenticateFlag(authenticateFlag, taxNo, DateUtils.stringToDate((String)DeductionConstant.getSkssq((String)taxNo), (String)"yyyyMM"), new String[]{"1", "2"});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            return;
        }
        if (CANCE_STATISTICS.equals(callBackId)) {
            this.cancelStatistics();
        } else if (CREATE_STATISTICS.equals(callBackId)) {
            this.createStatistics();
        } else if (CONFIRM_STATISTICS.equals(callBackId)) {
            this.confirmStatistics("");
        }
    }

    private void confirmStatistics(String confirmSecret) {
        String taxNo = (String)this.getModel().getValue(TAX_NO);
        String dkType = DeductionConstant.getDkType((String)taxNo);
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)this.getCurrentOrgId(), (AbstractFormPlugin)this);
        String batchNo = "";
        String taskNo = "";
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        param.put("password", (Object)confirmSecret);
        param.put("confirmSecret", (Object)confirmSecret);
        param.put("sqbz", (Object)"1");
        param.put("userId", (Object)RequestContext.get().getUserId());
        JSONObject createResult = deductService.confirmStatisticTable(param);
        if (ResultContant.isSuccess((JSONObject)createResult).booleanValue()) {
            JSONObject data = createResult.getJSONObject("data");
            if (!ObjectUtils.isEmpty((Object)data)) {
                batchNo = data.getString("batchNo");
                taskNo = data.getString("taskNo");
            }
            String status = "1";
            if ("3".equals(dkType) || "5".equals(dkType)) {
                this.startProgress(CONFIRM_STATISTICS, dkType, taxNo, taskNo, batchNo);
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u62b5\u6263\u7edf\u8ba1\u8868\u6210\u529f", (String)"CurrentDeductStatisticsPlugin_60", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.handleConfirmStatistics(createResult, dkType);
            this.inserSelectLog(taskNo, batchNo, "8", status, StatisticsStatusEnum.CREATED_CONFIRM.getCode());
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u62b5\u6263\u7edf\u8ba1\u8868\u5931\u8d25:%1$s", (String)"CurrentDeductStatisticsPlugin_61", (String)"imc-rim-formplugin", (Object[])new Object[0]), createResult != null ? createResult.getString("description") : ""));
        }
    }

    private void createStatistics() {
        String taxNo = (String)this.getModel().getValue(TAX_NO);
        String dkType = DeductionConstant.getDkType((String)taxNo);
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)this.getCurrentOrgId(), (AbstractFormPlugin)this);
        if (deductService == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (String)"CurrentDeductStatisticsPlugin_54", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String batchNo = "";
        String taskNo = "";
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        param.put("userId", (Object)RequestContext.get().getUserId());
        param.put("tjbz", (Object)"1");
        JSONObject createResult = deductService.createStatisticTable(param);
        if (ResultContant.isSuccess((JSONObject)createResult).booleanValue()) {
            JSONObject data = createResult.getJSONObject("data");
            if (!ObjectUtils.isEmpty((Object)data)) {
                batchNo = data.getString("batchNo");
                taskNo = data.getString("taskNo");
            }
            String status = "1";
            if ("3".equals(dkType) || "5".equals(dkType)) {
                this.startProgress(CREATE_STATISTICS, dkType, taxNo, taskNo, batchNo);
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u62b5\u6263\u7edf\u8ba1\u8868\u6210\u529f", (String)"CurrentDeductStatisticsPlugin_62", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.addCurrentStatisticsModel(createResult, true);
            this.inserSelectLog(taskNo, batchNo, "7", status, StatisticsStatusEnum.UN_CREATE.getCode());
        } else if (null != createResult) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u751f\u6210\u62b5\u6263\u7edf\u8ba1\u8868\u5931\u8d25:%1$s", (String)"CurrentDeductStatisticsPlugin_63", (String)"imc-rim-formplugin", (Object[])new Object[0]), createResult.getString("description")));
        }
    }

    private void cancelStatistics() {
        String taxNo = (String)this.getModel().getValue(TAX_NO);
        String dkType = DeductionConstant.getDkType((String)taxNo);
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)this.getCurrentOrgId(), (AbstractFormPlugin)this);
        if (deductService == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (String)"CurrentDeductStatisticsPlugin_54", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String batchNo = "";
        String taskNo = "";
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        param.put("userId", (Object)RequestContext.get().getUserId());
        param.put("tjbz", (Object)"0");
        String tjbbStatus = (String)this.getModel().getValue("tjbb_status");
        param.put("tjbbStatus", (Object)tjbbStatus);
        JSONObject cancelResult = deductService.cancelStatisticTable(param);
        if (ResultContant.isSuccess((JSONObject)cancelResult).booleanValue()) {
            JSONObject data = cancelResult.getJSONObject("data");
            if (!ObjectUtils.isEmpty((Object)data)) {
                batchNo = data.getString("batchNo");
                taskNo = data.getString("taskNo");
                this.getView().getPageCache().put(BATCH_NO_CANCEL_STATISTICS, batchNo);
            }
            String status = "1";
            if ("3".equals(dkType) || "5".equals(dkType)) {
                status = "3";
                this.startProgress(CANCE_STATISTICS, dkType, taxNo, taskNo, batchNo);
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u62b5\u6263\u7edf\u8ba1\u8868\u64a4\u9500\u6210\u529f\uff0c\u60a8\u53ef\u4ee5\u7ee7\u7eed\u52fe\u9009\u53d1\u7968\u7136\u540e\u518d\u6b21\u751f\u6210\u7edf\u8ba1", (String)"CurrentDeductStatisticsPlugin_64", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            boolean flag = StatisticsStatusEnum.CONFIRMED.getCode().equals(tjbbStatus);
            if (("5".equals(dkType) || "6".equals(dkType)) && flag) {
                this.setStatisticsStatus(StatisticsStatusEnum.CREATED_CONFIRM.getCode());
                this.getView().setVisible(Boolean.TRUE, new String[]{CONFIRM_STATISTICS});
            } else {
                this.initView();
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{CREATE_STATISTICS});
            this.updateInvoiceStatus("1", dkType, cancelResult);
            this.inserSelectLog(taskNo, batchNo, "-7", status, tjbbStatus);
        } else if (cancelResult != null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u64a4\u9500\u7edf\u8ba1\u8868\u5931\u8d25:%1$s", (String)"CurrentDeductStatisticsPlugin_65", (String)"imc-rim-formplugin", (Object[])new Object[0]), cancelResult.getString("description")));
        }
    }

    private void queryCurrentStatistics() {
        this.setStep(CURRENT_WIZARDAP, 0, "process");
        String taxNo = (String)this.getModel().getValue(TAX_NO);
        String dkType = DeductionConstant.getDkType((String)taxNo);
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)this.getCurrentOrgId(), (AbstractFormPlugin)this);
        if (deductService == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (String)"CurrentDeductStatisticsPlugin_54", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        JSONObject queryJson = deductService.getStatisticTable(param);
        if (ResultContant.isSuccess((JSONObject)queryJson).booleanValue()) {
            this.addCurrentStatisticsModel(queryJson, true);
        } else if (queryJson != null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7edf\u8ba1\u8868\u5931\u8d25:%1$s", (String)"CurrentDeductStatisticsPlugin_48", (String)"imc-rim-formplugin", (Object[])new Object[0]), queryJson.getString("description")));
        }
    }

    private void addCurrentStatisticsModel(JSONObject queryJson, boolean isQuery) {
        JSONObject data = queryJson.getJSONObject("data");
        Label labelCurrPeriod = (Label)this.getView().getControl("label_cur_period");
        String taxPeriod = data.getString("taxPeriod");
        labelCurrPeriod.setText(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5c5e\u671f:%s", (String)"CurrentDeductStatisticsPlugin_49", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxPeriod));
        if (StringUtils.isNotEmpty((CharSequence)taxPeriod)) {
            Label labeCurrentTaxPeriod = (Label)this.getView().getControl("label_curr_tax_period");
            labeCurrentTaxPeriod.setText(taxPeriod);
        }
        Label labelUpdateTime = (Label)this.getView().getControl("label_cur_updatetime");
        String updateTime = data.getString("updateTime");
        updateTime = Optional.ofNullable(updateTime).orElse("");
        labelUpdateTime.setText(String.format(ResManager.loadKDString((String)"\u7edf\u8ba1\u8868\u66f4\u65b0\u65f6\u95f4:%s", (String)"CurrentDeductStatisticsPlugin_50", (String)"imc-rim-formplugin", (Object[])new Object[0]), updateTime));
        if (StringUtils.isNotEmpty((CharSequence)updateTime)) {
            this.getModel().setValue("updatetime", (Object)DateUtils.stringToDate((String)updateTime, (String)"yyyy-MM-dd HH:mm:ss"));
        } else {
            this.getModel().setValue("updatetime", null);
        }
        this.setStatisticsStatus(data.getString("createTjbbStatus"));
        String skssq = data.getString("skssq");
        if (StringUtils.isNotEmpty((CharSequence)skssq)) {
            String taxNo = (String)this.getModel().getValue(TAX_NO);
            DeductionConstant.cacheSkssq((String)taxNo, (String)skssq);
        }
        Boolean show = Boolean.TRUE;
        Boolean hide = Boolean.FALSE;
        if ("true".equals(data.getString("isAllowQxTj"))) {
            this.getView().setVisible(show, new String[]{CANCE_STATISTICS});
            if ("05".equals(data.getString("createTjbbStatus"))) {
                this.setStep(CURRENT_WIZARDAP, 2, "finish");
            } else {
                this.setStep(CURRENT_WIZARDAP, 1, "finish");
            }
        } else {
            this.getView().setVisible(hide, new String[]{CANCE_STATISTICS});
        }
        if ("true".equals(data.getString("isAllowQrtj"))) {
            if (this.checkPreStatistic(taxPeriod, updateTime)) {
                this.setStatisticsStatus("25");
                this.getView().setVisible(hide, new String[]{CONFIRM_STATISTICS});
            } else {
                this.getView().setVisible(show, new String[]{CONFIRM_STATISTICS});
            }
        } else {
            this.getView().setVisible(hide, new String[]{CONFIRM_STATISTICS});
        }
        if ("true".equals(data.getString("isAllowGxInvoice"))) {
            this.getView().setVisible(show, new String[]{CREATE_STATISTICS});
            this.setStep(CURRENT_WIZARDAP, 0, "process");
            this.getView().getPageCache().remove(BATCH_NO_CANCEL_STATISTICS);
        } else {
            if (!"21".equals(data.getString("createTjbbStatus"))) {
                this.getView().getPageCache().remove(BATCH_NO_CREATE_STATISTICS);
            }
            this.getView().setVisible(hide, new String[]{CREATE_STATISTICS});
        }
        JSONArray statistics = data.getJSONArray("tjxx");
        if (CollectionUtils.isEmpty((Collection)statistics)) {
            statistics = data.getJSONArray("tjInfoArr");
        }
        this.getModel().deleteEntryData(CURRENT_STATISTICSE_NTRYENTITY);
        if (!CollectionUtils.isEmpty((Collection)statistics)) {
            for (int i = 0; i < statistics.size(); ++i) {
                String[] item = statistics.getJSONObject(i);
                if ("99".equals(item.getString("invoiceType"))) continue;
                int row = this.getModel().createNewEntryRow(CURRENT_STATISTICSE_NTRYENTITY);
                this.getModel().setValue("c_deduct_invoice_type", (Object)item.getString("invoiceType"), row);
                this.getModel().setValue("c_deduct_num", item.get((Object)"deductibleNum"), row);
                this.getModel().setValue("c_deduct_invoice_amount", (Object)BigDecimalUtil.transDecimal((Object)item.get((Object)"deductibleAmount")), row);
                this.getModel().setValue("c_deducteffectiveamount", (Object)BigDecimalUtil.transDecimal((Object)item.get((Object)"deductibleTax")), row);
                this.getModel().setValue("c_undeduct_num", item.get((Object)"unDeductibleNum"), row);
                this.getModel().setValue("c_undeduct_invoice_amount", (Object)BigDecimalUtil.transDecimal((Object)item.get((Object)"unDeductibleAmount")), row);
                this.getModel().setValue("c_undeducteffectiveamount", (Object)BigDecimalUtil.transDecimal((Object)item.get((Object)"unDeductibleTax")), row);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)data.getString("tjInfo"))) {
            String[] rows;
            for (String row : rows = data.getString("tjInfo").split(";")) {
                String invoiceTpye;
                String[] cells = row.split("=");
                int size = cells.length;
                if ("99".equals(cells[0]) || StringUtils.isEmpty((CharSequence)(invoiceTpye = HolytaxInvoiceTypeEnum.getAwsTypeByHolytaxType((String)cells[0])))) continue;
                int index = this.getModel().createNewEntryRow(CURRENT_STATISTICSE_NTRYENTITY);
                this.getModel().setValue("c_deduct_invoice_type", (Object)invoiceTpye, index);
                if (size > 1) {
                    this.getModel().setValue("c_deduct_num", (Object)cells[1], index);
                }
                if (size > 2) {
                    this.getModel().setValue("c_deduct_invoice_amount", (Object)cells[2], index);
                }
                if (size > 3) {
                    this.getModel().setValue("c_deducteffectiveamount", (Object)cells[3], index);
                }
                if (size > 4) {
                    this.getModel().setValue("c_undeduct_num", (Object)cells[4], index);
                }
                if (size > 5) {
                    this.getModel().setValue("c_undeduct_invoice_amount", (Object)cells[5], index);
                }
                if (size <= 6) continue;
                this.getModel().setValue("c_undeducteffectiveamount", (Object)cells[6], index);
            }
        } else {
            this.setStep(CURRENT_WIZARDAP, 0, "process");
        }
        if (isQuery) {
            String taxNo = (String)this.getModel().getValue(TAX_NO);
            String dkType = DeductionConstant.getDkType((String)taxNo);
            if (!("1".equals(dkType) || "2".equals(dkType) || "4".equals(dkType))) {
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CURRENT_STATISTICSE_NTRYENTITY);
            if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                return;
            }
            int deductNum = 0;
            for (DynamicObject dynamicObject : entryEntity) {
                String awsType = dynamicObject.getString("c_deduct_invoice_type");
                Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)awsType);
                if (!InputInvoiceTypeEnum.canDeduction((Long)invoiceType).booleanValue()) continue;
                deductNum += dynamicObject.getInt("c_deduct_num");
                deductNum += dynamicObject.getInt("c_undeduct_num");
            }
            this.queryUnSelectInvoice(taxNo, deductNum);
        }
    }

    private void queryUnSelectInvoice(String taxNo, int deductNum) {
        LOGGER.info("\u68c0\u67e5\u662f\u5426\u9700\u8981\u66f4\u65b0\u8868\u5934\u6570\u636e:{},deductNum:{}", (Object)taxNo, (Object)deductNum);
        String skssq = DeductionConstant.getSkssq((String)taxNo);
        if (StringUtils.isEmpty((CharSequence)skssq)) {
            return;
        }
        Date taxPeriod = DateUtils.stringToDate((String)skssq, (String)"yyyyMM");
        String userId = RequestContext.get().getUserId();
        ThreadPools.executeOnceIncludeRequestContext((String)"AsyncCurrentDeductQueryUnSelectRun", () -> DeductStatisticsService.updateUnselectInvoice((String)taxNo, (Date)taxPeriod, (int)deductNum, (Long)this.getCurrentOrgId(), (String)userId));
    }

    private boolean checkPreStatistic(String taxPeriod, String updateTime) {
        if (StringUtils.isEmpty((CharSequence)taxPeriod) || StringUtils.isEmpty((CharSequence)updateTime)) {
            return false;
        }
        Date updateDate = DateUtils.stringToDate((String)updateTime);
        return StringUtils.equals((CharSequence)taxPeriod, (CharSequence)DateUtils.format((Date)updateDate, (String)"yyyyMM"));
    }

    private void setStep(String key, int step, String status) {
        Wizard wizard = (Wizard)this.getControl(key);
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>();
        currentStepMap.put("currentStep", step);
        currentStepMap.put("currentStatus", status);
        wizard.setWizardCurrentStep(currentStepMap);
    }

    private Long getCurrentOrgId() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = null;
        if (org != null) {
            orgId = org.getLong("id");
        }
        return orgId;
    }

    private Long getTaxOrgId() {
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue("taxorg");
        Long taxorgId = null;
        if (taxorg != null) {
            taxorgId = taxorg.getLong("id");
        }
        return taxorgId;
    }

    private void setStatisticsStatus(String status) {
        String statusName = "";
        if (StringUtils.isNotEmpty((CharSequence)status)) {
            statusName = StatisticsStatusEnum.getNameByCode((String)status);
        }
        Label labelStatus = (Label)this.getView().getControl("label_statistics_status");
        labelStatus.setText(String.format(ResManager.loadKDString((String)"\u7edf\u8ba1\u8868\u72b6\u6001:%s", (String)"CurrentDeductStatisticsPlugin_66", (String)"imc-rim-formplugin", (Object[])new Object[0]), statusName));
        this.getModel().setValue("tjbb_status", (Object)status);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }

    private void inserSelectLog(String taskNo, String batchNo, String operateType, String handleStatus, String statisticsStatus) {
        String taxNo = (String)this.getModel().getValue(TAX_NO);
        Long orgId = this.getCurrentOrgId() != null ? this.getCurrentOrgId() : this.getTaxOrgId();
        DeductStatisticsService.inserSelectLog((String)taskNo, (String)batchNo, (String)taxNo, (Long)orgId, (String)operateType, (String)DeductionConstant.getSkssq((String)taxNo), (String)handleStatus, (String)"0", null, (String)"1", null, (String)statisticsStatus);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String taxNo;
        String dkType;
        DeductService service;
        JSONObject loginResult;
        FormOperate oprate = (FormOperate)args.getSource();
        String operationKey = oprate.getOperateKey();
        if ((QUERY_CURRENT_STATISTICS.equals(operationKey) || CANCE_STATISTICS.equals(operationKey) || CREATE_STATISTICS.equals(operationKey) || CONFIRM_STATISTICS.equals(operationKey)) && !ResultContant.isSuccess((JSONObject)(loginResult = (service = DeductServiceFactory.newInstanceForDeduct((String)(dkType = DeductionConstant.getDkType((String)(taxNo = (String)this.getModel().getValue(TAX_NO)))), (Long)this.getCurrentOrgId())).login(taxNo, operationKey, (AbstractFormPlugin)this))).booleanValue()) {
            if (!ErrorType.NEED_LOGIN.getCode().equals(loginResult.getString("errcode")) || !ErrorType.NEED_LOGIN.getName().equals(loginResult.getString("description"))) {
                this.getView().showErrorNotification(loginResult.getString("description"));
            }
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        this.doOperate(operateKey);
    }

    private void doOperate(String operateKey) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue("taxorg");
        if (ObjectUtils.isEmpty((Object)org) && ObjectUtils.isEmpty((Object)taxorg)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u548c\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"CurrentDeductStatisticsPlugin_67", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String taxNo = (String)this.getModel().getValue(TAX_NO);
        switch (operateKey) {
            case "query_current_statistics": {
                this.queryCurrentStatistics();
                break;
            }
            case "cance_statistics": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u64a4\u9500\u7edf\u8ba1\u8868\u5417?", (String)"CurrentDeductStatisticsPlugin_68", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CANCE_STATISTICS), null);
                break;
            }
            case "create_statistics": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u7533\u8bf7\u751f\u6210\u7edf\u8ba1\u8868\u5417?", (String)"CurrentDeductStatisticsPlugin_69", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CREATE_STATISTICS), null);
                break;
            }
            case "confirm_statistics": {
                String dkType = DeductionConstant.getDkType((String)taxNo);
                if ("5".equals(dkType) || "4".equals(dkType) || "6".equals(dkType)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u786e\u8ba4\u7b7e\u540d\u5417?", (String)"CurrentDeductStatisticsPlugin_70", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_STATISTICS), null);
                    break;
                }
                FormShowParameter showParameter = new FormShowParameter();
                HashMap<String, String> customParams = new HashMap<String, String>(8);
                customParams.put("dkType", dkType);
                showParameter.setCustomParams(customParams);
                showParameter.setFormId("rim_confirm_statistics");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CONFIRM_STATISTICS);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
                break;
            }
            case "export": {
                this.exportData();
                break;
            }
            case "query_lq_invoices": {
                ThreadPools.executeOnceIncludeRequestContext((String)"AsyncCurrentDeductStatisticsRun", () -> DeductStatisticsService.updateLqSelected((Long)org.getLong("id"), (String)taxNo));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u53d1\u7968\u66f4\u65b0\u4e2d,\u8bf7\u7a0d\u540e\u5237\u65b0\u52fe\u9009\u7edf\u8ba1\u6e05\u5355", (String)"CurrentDeductStatisticsPlugin_72", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private boolean isFinish(JSONObject result) {
        return ResultContant.isSuccess((JSONObject)result) != false && result.getJSONObject("data") != null && "true".equals(result.getJSONObject("data").getString("isFinish"));
    }

    private void startProgress(String operateType, String dkType, String taxNo, String taskNo, String batchNo) {
        JSONObject param = new JSONObject();
        param.put("operateType", (Object)operateType);
        param.put("dkType", (Object)dkType);
        param.put("taxNo", (Object)taxNo);
        param.put("taskNo", (Object)taskNo);
        param.put("batchNo", (Object)batchNo);
        param.put("millis", (Object)System.currentTimeMillis());
        this.getPageCache().remove(STOP_FLAG);
        this.getPageCache().put(KEY_LOADING_PARAM, SerializationUtils.toJsonString((Object)param));
        this.startProcess(new String[]{ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"CurrentDeductStatisticsPlugin_73", (String)"imc-rim-formplugin", (Object[])new Object[0])});
    }

    public void onProgress(ProgressEvent progressEvent) {
    }

    private boolean asyncConfirm(JSONObject param) {
        if (param == null) {
            return true;
        }
        String dkType = param.getString("dkType");
        String taskNo = param.getString("taskNo");
        String batchNo = param.getString("batchNo");
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)this.getCurrentOrgId(), (AbstractFormPlugin)this);
        if (deductService == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (String)"CurrentDeductStatisticsPlugin_54", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return true;
        }
        String status = "1";
        String tjbbStatus = (String)this.getModel().getValue("tjbb_status");
        JSONObject result = deductService.queryConfirmStatisticTable(param);
        if (ResultContant.isSuccess((JSONObject)result).booleanValue()) {
            if (!this.isFinish(result)) {
                if (this.isTimeout(param.getLong("millis"))) {
                    status = "3";
                    this.inserSelectLog(taskNo, batchNo, "8", status, tjbbStatus);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u62b5\u6263\u7edf\u8ba1\u8868\u7533\u8bf7\u6210\u529f\uff0c\u67e5\u8be2\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u5230'\u8fdb\u9879\u62b5\u6263-\u52fe\u9009\u8ba4\u8bc1\u65e5\u5fd7'\u5217\u8868\u67e5\u770b\u5904\u7406\u7ed3\u679c", (String)"CurrentDeductStatisticsPlugin_77", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return true;
                }
                return false;
            }
            this.getPageCache().put(STOP_FLAG, "1");
            this.handleConfirmStatistics(result, dkType);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u62b5\u6263\u7edf\u8ba1\u8868\u6210\u529f", (String)"CurrentDeductStatisticsPlugin_60", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else {
            String subMsg;
            this.getPageCache().put(STOP_FLAG, "1");
            if (result != null && StringUtils.isNotEmpty((CharSequence)(subMsg = this.getSubMsg(result)))) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u62b5\u6263\u7edf\u8ba1\u8868\u5931\u8d25:%1$s", (String)"CurrentDeductStatisticsPlugin_61", (String)"imc-rim-formplugin", (Object[])new Object[0]), result.getString("description")), subMsg, MessageTypes.Default);
                return true;
            }
            status = "2";
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u62b5\u6263\u7edf\u8ba1\u8868\u5931\u8d25:%1$s", (String)"CurrentDeductStatisticsPlugin_61", (String)"imc-rim-formplugin", (Object[])new Object[0]), result != null ? result.getString("description") : ""));
        }
        this.inserSelectLog(taskNo, batchNo, "8", status, tjbbStatus);
        return true;
    }

    private boolean asyncCancel(JSONObject param) {
        if (param == null) {
            return true;
        }
        String dkType = param.getString("dkType");
        String taskNo = param.getString("taskNo");
        String batchNo = param.getString("batchNo");
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)this.getCurrentOrgId(), (AbstractFormPlugin)this);
        if (deductService == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (String)"CurrentDeductStatisticsPlugin_54", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return true;
        }
        String status = "1";
        param.put("tjbz", (Object)"0");
        String tjbbStatus = (String)this.getModel().getValue("tjbb_status");
        JSONObject result = "5".equals(dkType) && StatisticsStatusEnum.CONFIRMED.getCode().equals(tjbbStatus) ? deductService.queryConfirmStatisticTable(param) : deductService.queryStatisticTable(param);
        if (ResultContant.isSuccess((JSONObject)result).booleanValue()) {
            if (!this.isFinish(result)) {
                if (this.isTimeout(param.getLong("millis"))) {
                    status = "3";
                    this.inserSelectLog(taskNo, batchNo, "-7", status, tjbbStatus);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64a4\u9500\u62b5\u6263\u7edf\u8ba1\u8868\u7533\u8bf7\u6210\u529f\uff0c\u67e5\u8be2\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u5230'\u8fdb\u9879\u62b5\u6263-\u52fe\u9009\u8ba4\u8bc1\u65e5\u5fd7'\u5217\u8868\u67e5\u770b\u5904\u7406\u7ed3\u679c", (String)"CurrentDeductStatisticsPlugin_76", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return true;
                }
                return false;
            }
            this.getPageCache().put(STOP_FLAG, "1");
            boolean flag = StatisticsStatusEnum.CONFIRMED.getCode().equals(tjbbStatus);
            if (("5".equals(dkType) || "6".equals(dkType)) && flag) {
                this.setStatisticsStatus(StatisticsStatusEnum.CREATED_CONFIRM.getCode());
                this.getView().setVisible(Boolean.TRUE, new String[]{CONFIRM_STATISTICS});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u62b5\u6263\u7edf\u8ba1\u8868\u64a4\u9500\u786e\u8ba4\u7b7e\u540d\u6210\u529f", (String)"CurrentDeductStatisticsPlugin_78", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            } else {
                this.initView();
                this.getView().setVisible(Boolean.TRUE, new String[]{CREATE_STATISTICS});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u62b5\u6263\u7edf\u8ba1\u8868\u64a4\u9500\u6210\u529f\uff0c\u60a8\u53ef\u4ee5\u7ee7\u7eed\u52fe\u9009\u53d1\u7968\u7136\u540e\u518d\u6b21\u751f\u6210\u7edf\u8ba1", (String)"CurrentDeductStatisticsPlugin_64", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            this.updateInvoiceStatus("1", dkType, result);
        } else {
            this.getPageCache().put(STOP_FLAG, "1");
            status = "2";
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u64a4\u9500\u7edf\u8ba1\u8868\u5931\u8d25:%1$s", (String)"CurrentDeductStatisticsPlugin_65", (String)"imc-rim-formplugin", (Object[])new Object[0]), result != null ? result.getString("description") : ""));
        }
        this.inserSelectLog(taskNo, batchNo, "-7", status, tjbbStatus);
        return true;
    }

    private boolean asyncCreate(JSONObject param) {
        if (param == null) {
            return true;
        }
        String dkType = param.getString("dkType");
        String taskNo = param.getString("taskNo");
        String batchNo = param.getString("batchNo");
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)this.getCurrentOrgId(), (AbstractFormPlugin)this);
        if (deductService == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u5c40\u63a5\u53e3\u914d\u7f6e\u9519\u8bef", (String)"CurrentDeductStatisticsPlugin_54", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return true;
        }
        String status = "1";
        String tjbbStatus = (String)this.getModel().getValue("tjbb_status");
        param.put("tjbz", (Object)"1");
        JSONObject result = deductService.queryStatisticTable(param);
        if (result != null && ResultContant.isSuccess((JSONObject)result).booleanValue()) {
            if (!this.isFinish(result)) {
                if (this.isTimeout(param.getLong("millis"))) {
                    status = "3";
                    this.inserSelectLog(taskNo, batchNo, "7", status, tjbbStatus);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u62b5\u6263\u7edf\u8ba1\u8868\u7533\u8bf7\u6210\u529f\uff0c\u67e5\u8be2\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u5230'\u8fdb\u9879\u62b5\u6263-\u52fe\u9009\u8ba4\u8bc1\u65e5\u5fd7'\u5217\u8868\u67e5\u770b\u5904\u7406\u7ed3\u679c", (String)"CurrentDeductStatisticsPlugin_75", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return true;
                }
                return false;
            }
            this.getPageCache().put(STOP_FLAG, "1");
            if ("5".equals(dkType)) {
                JSONObject data = result.getJSONObject("data");
                String taxNo = param.getString("taxNo");
                String taxPeriod = DeductionConstant.getSkssq((String)taxNo);
                if (data != null && StringUtils.isNotEmpty((CharSequence)taxPeriod) && CollectionUtils.isEmpty((Collection)data.getJSONArray("tjxx"))) {
                    JSONArray tjxx = DeductStatisticsService.createStatistics((String)taxPeriod, (String)taxNo);
                    data.put("tjxx", (Object)tjxx);
                }
            }
            this.addCurrentStatisticsModel(result, false);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u62b5\u6263\u7edf\u8ba1\u8868\u6210\u529f", (String)"CurrentDeductStatisticsPlugin_62", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else {
            String subMsg;
            this.getPageCache().put(STOP_FLAG, "1");
            if (result != null && StringUtils.isNotEmpty((CharSequence)(subMsg = this.getSubMsg(result)))) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u751f\u6210\u62b5\u6263\u7edf\u8ba1\u8868\u5931\u8d25:%1$s", (String)"CurrentDeductStatisticsPlugin_63", (String)"imc-rim-formplugin", (Object[])new Object[0]), result.getString("description")), subMsg, MessageTypes.Default);
                return true;
            }
            status = "2";
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u751f\u6210\u62b5\u6263\u7edf\u8ba1\u8868\u5931\u8d25:%1$s", (String)"CurrentDeductStatisticsPlugin_63", (String)"imc-rim-formplugin", (Object[])new Object[0]), result != null ? result.getString("description") : ""));
        }
        this.inserSelectLog(taskNo, batchNo, "7", status, tjbbStatus);
        return true;
    }

    private String getSubMsg(JSONObject result) {
        if (result == null || result.get((Object)"data") == null) {
            return null;
        }
        return result.getJSONObject("data").getString("message");
    }

    private boolean isTimeout(Long millis) {
        if (millis == null || millis <= 0L) {
            return false;
        }
        Date start = new Date(millis);
        int timeout = InvoiceDownloadConstant.getPageSizeFromConfig((int)120, (String)"current_async_timeout");
        if (timeout <= 0) {
            timeout = 120;
        }
        return new Date().compareTo(start = DateUtils.addSecond((Date)start, (int)timeout)) > 0;
    }

    /*
     * Exception decompiling
     */
    public void dialogProcess(String eventArgs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 19[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

