/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.TextProp;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DeductConfigPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(DeductConfigPlugin.class);
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String KEY_FILTER = "custom_config_tag";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
        Button buttonap = (Button)this.getView().getControl("bar_reset");
        buttonap.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initNumber();
        this.initSetFilter();
    }

    public void beforeBindData(EventObject e) {
        this.iniFilterGrid();
        super.beforeBindData(e);
    }

    public void itemClick(ItemClickEvent evt) {
        if ("barreset".equals(evt.getItemKey())) {
            this.initSetFilter();
            this.getModel().setValue("air_begin_date", (Object)DateUtils.parseDate((Object)"2019-04-01"));
            this.getModel().setValue("train_begin_date", (Object)DateUtils.parseDate((Object)"2019-04-01"));
            this.getModel().setValue("air_person_identity", (Object)"1");
            this.getModel().setValue("train_person_identity", (Object)"1");
            this.setFilterGrid();
        }
    }

    public void afterBindData(EventObject e) {
        this.setFilterGrid();
        super.afterBindData(e);
    }

    private void setFilterGrid() {
        Object filterObj = this.getModel().getValue(KEY_FILTER);
        FilterCondition filterCondition = null;
        if (!StringUtils.isBlank((Object)filterObj)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterObj.toString(), FilterCondition.class);
        }
        if (filterCondition != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            filterGrid.SetValue(filterCondition);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.initNumber();
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("bar_reset".equals(control.getKey())) {
            this.initSetFilter();
            this.getModel().setValue("air_begin_date", (Object)DateUtils.parseDate((Object)"2019-04-01"));
            this.getModel().setValue("train_begin_date", (Object)DateUtils.parseDate((Object)"2019-04-01"));
            this.getModel().setValue("air_person_identity", (Object)"1");
            this.getModel().setValue("train_person_identity", (Object)"1");
            this.setFilterGrid();
        }
    }

    private void initNumber() {
        String date = DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyyMMdd"});
        String random = String.format("%02d", new SecureRandom().nextInt(99));
        String number = "FPY" + date + random;
        this.getModel().setValue("number", (Object)number);
    }

    private void initSetFilter() {
        String filter = "{\"filterRow\":[{\"id\":\"2C7TJVLNV67G\",\"leftBracket\":\"\",\"compareType\":\"65\",\"fieldName\":\"invoice_date\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2C7TJVLNV5J7\",\"value\":\"2019-04-01\"}],\"baseDataIds\":[]},{\"id\":\"2C7TJVLNV67H\",\"leftBracket\":\"\",\"compareType\":\"60\",\"fieldName\":\"items.goods_name\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2C7TJVLNV5J8\",\"value\":\"*\u8fd0\u8f93\u670d\u52a1\"}],\"baseDataIds\":[]},{\"id\":\"2C7TJVLNV67I\",\"leftBracket\":\"\",\"compareType\":\"59\",\"fieldName\":\"items.goods_name\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2C7TJVLNV5J9\",\"value\":\"\u5ba2\u8fd0\"}],\"baseDataIds\":[]},{\"id\":\"2C7TJVLNV67J\",\"leftBracket\":\"\",\"compareType\":\"58\",\"fieldName\":\"items.goods_name\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2C7TJVLNV5J=\",\"value\":\"\u56fd\u9645\"}],\"baseDataIds\":[]},{\"id\":\"2C7TJVLNV67K\",\"leftBracket\":\"\",\"compareType\":\"58\",\"fieldName\":\"items.goods_name\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2C7TJVLNV5JA\",\"value\":\"\u6e2f\u6fb3\u53f0\"}],\"baseDataIds\":[]}],\"forList\":false}";
        this.getModel().setValue(KEY_FILTER, (Object)filter);
    }

    private void iniFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        filterCondition.getFilterRow().clear();
        MainEntityType mainEntity = new MainEntityType();
        mainEntity.setAppId("rim");
        mainEntity.setMainOrg("org");
        mainEntity.setExtendName("rim_inv_ordinary");
        mainEntity.setFromDatabase((Object)BusinessDataServiceHelper.newDynamicObject((String)"rim_inv_ordinary"));
        mainEntity.setDBRouteKey("taxc");
        DateProp dateProp = new DateProp();
        dateProp.setName("invoice_date");
        dateProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"DeductConfigPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        mainEntity.addProperty((DynamicProperty)dateProp);
        TextProp textProp = new TextProp();
        textProp.setName("items.goods_name");
        textProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0", (String)"DeductConfigPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        mainEntity.addProperty((DynamicProperty)textProp);
        TextProp textProp1 = new TextProp();
        textProp1.setName("saler_name");
        textProp1.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"DeductConfigPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        mainEntity.addProperty((DynamicProperty)textProp1);
        DataEntityPropertyCollection mainPros = mainEntity.getProperties();
        ArrayList<Map> filterColumns = new ArrayList<Map>(8);
        for (IDataEntityProperty property : mainPros) {
            IFieldHandle handle = (IFieldHandle)property;
            FilterField filterField = handle.createFilterField(mainEntity, property.getName());
            Map filterColumn = filterField.createFilterColumn(true);
            if (filterColumn != null) {
                List compareTypes = (List)filterColumn.get("compareTypes");
                List<CompareTypeDto> finalCompareTypes = this.removeSomeTypes(property.getName(), compareTypes);
                if (!CollectionUtils.isEmpty(finalCompareTypes)) {
                    filterColumn.put("compareTypes", finalCompareTypes);
                }
            }
            filterColumns.add(filterColumn);
        }
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber("rim_inv_ordinary");
    }

    private List<CompareTypeDto> removeSomeTypes(String propertyName, List<CompareTypeDto> compareTypes) {
        ArrayList<CompareTypeDto> finalCollect = new ArrayList<CompareTypeDto>(16);
        for (CompareTypeDto dto : compareTypes) {
            String id = dto.getId();
            if (id.indexOf(45) >= 0 || "25".equals(id) || "73".equals(id) || "8".equals(id) || "26".equals(id) || "79".equals(id) || "69".equals(id) || !"invoice_date".equals(propertyName) && ("21".equals(id) || "36".equals(id) || "19".equals(id) || "65".equals(id))) continue;
            finalCollect.add(dto);
        }
        return finalCollect;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        FormOperate oprate = (FormOperate)evt.getSource();
        String operationKey = oprate.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)operationKey)) {
            FilterCondition filterCondition = this.getFilter();
            this.saveFilterToText(filterCondition);
        }
        super.beforeDoOperation(evt);
    }

    private FilterCondition getFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        return condition;
    }

    private String saveFilterToText(FilterCondition filterCondition) {
        String filter = null;
        if (filterCondition != null) {
            filter = SerializationUtils.toJsonString((Object)filterCondition);
        }
        this.getModel().setValue(KEY_FILTER, (Object)filter);
        return filter;
    }
}

