/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.RimPermItemEnum;
import kd.imc.rim.common.license.LicenseListPlugin;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateFactory;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;

public class DownLogListPlugin
extends LicenseListPlugin {
    protected static final Set<String> ALLOW_DOWN_STATUS = new HashSet<String>(4){
        private static final long serialVersionUID = -2012333430055776732L;
        {
            this.add("2");
            this.add("6");
            this.add("7");
            this.add("5");
        }
    };

    private static final String TITLE() {
        String async = RimConfigUtils.getConfig((String)"rim_deduction", (String)"batch_down_invoice_sync");
        if ("1".equals(async)) {
            return ResManager.loadKDString((String)"\u5f02\u6b65\u5904\u7406\u540c\u6b65\u65e5\u5fd7", (String)"DownLogListPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u624b\u5de5\u5904\u7406\u540c\u6b65\u65e5\u5fd7", (String)"DownLogListPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("down".equals(key)) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.RIM_BATCH_DOWNLOAD, (String)"down");
            this.downLoadInvoice();
        } else if ("export".equals(key)) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.ITEM_DERIVE, (String)"export");
        }
    }

    private void downLoadInvoice() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectCollection = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"DownLogListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        QFilter filte = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
        DynamicObjectCollection initCollection = QueryServiceHelper.query((String)"rim_down_log", (String)"id,gov_status,tax_no,inout", (QFilter[])new QFilter[]{filte});
        Iterator iterator = initCollection.iterator();
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            String govStatus = dynamicObject.getString("gov_status");
            if (StringUtils.isEmpty((Object)govStatus) || ALLOW_DOWN_STATUS.contains(govStatus)) continue;
            iterator.remove();
        }
        if (CollectionUtils.isEmpty((Collection)initCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u540c\u6b65\u72b6\u6001\u4e3a'\u6570\u636e\u4e0d\u5168'\u6216'\u8fdb\u9500\u9879\u4e0b\u8f7d\u5904\u7406\u4e2d'\u7684\u6570\u636e", (String)"DownLogListPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Map<String, List<DynamicObject>> groupMap = initCollection.stream().filter(s -> !StringUtils.isEmpty((Object)s.getString("tax_no"))).collect(Collectors.groupingBy(s -> s.getString("tax_no")));
        JSONObject cacheJson = new JSONObject();
        for (Map.Entry<String, List<DynamicObject>> entry : groupMap.entrySet()) {
            List<DynamicObject> values = entry.getValue();
            ArrayList<Map> list = new ArrayList<Map>(values.size());
            for (DynamicObject value : values) {
                list.add(DynamicObjectUtil.dynamicObjectToMap((DynamicObject)value));
            }
            JSONObject data = new JSONObject();
            data.put("data", list);
            cacheJson.put(entry.getKey(), (Object)data);
        }
        this.getPageCache().put("deduct_tax_no", cacheJson.toJSONString());
        this.getPageCache().put("deduct_title", DownLogListPlugin.TITLE());
        InvoiceOperateService service = InvoiceOperateFactory.newInstance("deduct_login_down_invoice", 0L, (AbstractFormPlugin)this);
        service.operate();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
        DynamicObject logDynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"rim_down_log", (String)"batch_no");
        QFilter batchNoFilter = new QFilter("batch_no", "=", (Object)logDynamicObject.getString("batch_no"));
        DynamicObjectCollection accountCollection = QueryServiceHelper.query((String)"rim_down_account", (String)"id", (QFilter[])new QFilter[]{batchNoFilter});
        if (CollectionUtils.isEmpty((Collection)accountCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u6ca1\u6709\u5df2\u4e0b\u8f7d\u7684\u53d1\u7968\u6570\u636e", (String)"DownLogListPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else {
            Object[] idList = accountCollection.stream().map(s -> s.get("id")).toArray();
            ListShowParameter showParameter = new ListShowParameter();
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            showParameter.setFormId("bos_list");
            showParameter.setBillFormId("rim_down_account_layout");
            QFilter filter = new QFilter("id", "in", (Object)idList);
            listFilterParameter.setFilter(filter);
            showParameter.setListFilterParameter(listFilterParameter);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("deduct_login_down_invoice".equals(closedCallBackEvent.getActionId())) {
            InvoiceOperateService service = InvoiceOperateFactory.newInstance("deduct_login_down_invoice", 0L, (AbstractFormPlugin)this);
            service.closedCallBack(closedCallBackEvent);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperationResult() == null || !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectCollection = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectCollection)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"DownLogListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if ("reset_status".equals(operateKey)) {
            DynamicObject[] logs;
            QFilter qFilter = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
            for (DynamicObject log : logs = BusinessDataServiceHelper.load((String)"rim_down_log", (String)"id,gov_status,modifytime", (QFilter[])qFilter.toArray())) {
                log.set("gov_status", (Object)"6");
                log.set("modifytime", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])logs);
            billList.clearSelection();
            billList.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DownLogListPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }
}

