/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.helper.ImcSaveServiceHelper;
import kd.imc.rim.common.invoice.download.LeqiPurposeServiceTask;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.StringUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.ViewUtil;

public class LeqiPurposeListPlugin
extends AbstractListPlugin {
    private static final String ADD_INVOICE = "addinvoice";
    private static final String CACHE_START_KEY = "LeqiPurposeListPlugin-startFlag";
    private static final int QUERY_SIZE = 500;
    private static final int THREADPOOL_SIZE = 3;
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"LeqiPurposeListPluginTask", (int)3);

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (ADD_INVOICE.equals(itemKey)) {
            ViewUtil.openDialog((AbstractFormPlugin)this, null, (String)"rim_leqi_add_invoice", (String)ADD_INVOICE);
        } else if ("reset".equals(itemKey)) {
            DynamicObject[] objects;
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968\u6570\u636e\u518d\u64cd\u4f5c", (String)"LeqiPurposeListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
            for (DynamicObject object : objects = BusinessDataServiceHelper.load((String)"rim_leqi_purpose", (String)"handle_status,modifytime", (QFilter[])qFilter.toArray())) {
                if ("0".equals(object.getString("handle_status"))) continue;
                object.set("handle_status", (Object)"0");
                object.set("modifytime", (Object)new Date());
                ImcSaveServiceHelper.save((DynamicObject)object);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\u3002", (String)"LeqiPurposeListPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.refresh();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperationResult() == null || !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("try_handle".equals(operateKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968\u6570\u636e\u518d\u64cd\u4f5c", (String)"LeqiPurposeListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
            DynamicObjectCollection objects = QueryServiceHelper.query((String)"rim_leqi_purpose", (String)"id,handle_status,modifytime", (QFilter[])qFilter.toArray());
            RequestContext requestContext = RequestContext.get();
            int index = 0;
            ArrayList<Future> futureList = new ArrayList<Future>(8);
            for (DynamicObject object : objects) {
                if (!"0".equals(object.getString("handle_status"))) continue;
                LeqiPurposeServiceTask task = new LeqiPurposeServiceTask(requestContext, object.get("id"));
                futureList.add(threadPool.submit((Callable)task));
                CommonUtils.futureWait(futureList, (int)3, (int)(++index));
            }
            CommonUtils.futureWait(futureList, (int)3, (int)3);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u8bf7\u67e5\u770b\u5217\u8868\u5904\u7406\u72b6\u6001\u3002", (String)"LeqiPurposeListPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.refresh();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (ADD_INVOICE.equals(actionId) && !ObjectUtils.isEmpty((Object)returnData)) {
            JSONObject addInvoiceParam = JSONObject.parseObject((String)JSONObject.toJSONString((Object)returnData));
            int size = this.addInvoice(addInvoiceParam);
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u6dfb\u52a0\u4e86%1$s\u5f20\u53d1\u7968", (String)"LeqiPurposeListPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), size));
        }
    }

    private int addInvoice(JSONObject addInvoiceParam) {
        Date taxperiod;
        Date endDate;
        Date startDate;
        if (ObjectUtils.isEmpty((Object)addInvoiceParam)) {
            return 0;
        }
        Long orgId = addInvoiceParam.getLong("orgId");
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        String invoiceNo = addInvoiceParam.getString("invoiceNo");
        String invoiceCode = addInvoiceParam.getString("invoiceCode");
        if (StringUtils.isNotEmpty((CharSequence)invoiceNo)) {
            filter.and("invoice_no", "=", (Object)invoiceNo.trim());
            filter.and("invoice_code", "=", (Object)StringUtils.trimToEmpty((String)invoiceCode));
        }
        if ((startDate = addInvoiceParam.getDate("startDate")) != null) {
            filter.and("invoice_date", ">=", (Object)startDate);
        }
        if ((endDate = addInvoiceParam.getDate("endDate")) != null) {
            endDate = DateUtils.addDay((Date)endDate, (int)1);
            filter.and("invoice_date", "<", (Object)endDate);
        }
        filter.and("invoice_type", "in", (Object)InputInvoiceTypeEnum.getDeductionAllTypes());
        String taxno = addInvoiceParam.getString("taxno");
        if (StringUtils.isNotEmpty((CharSequence)taxno)) {
            filter.and("buyer_tax_no", "=", (Object)taxno);
        }
        if ((taxperiod = addInvoiceParam.getDate("taxperiod")) != null) {
            filter.and("tax_period", "=", (Object)taxperiod);
            filter.and("authenticate_flag", "in", (Object)new String[]{"1", "2", "3"});
        } else {
            filter.and("authenticate_flag", "=", (Object)"0");
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"invoice_type,invoice_code,invoice_no,electronic_no,invoice_date,serial_no,buyer_tax_no", (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            String taxNo = TenantUtils.getTaxNoByOrgId((Long)orgId);
            for (DynamicObject dynamicObject : collection) {
                DynamicObject leqiPurpose = BusinessDataServiceHelper.newDynamicObject((String)"rim_leqi_purpose");
                leqiPurpose.set("org", (Object)orgId);
                leqiPurpose.set("handle_status", (Object)"0");
                leqiPurpose.set("invoice_code", dynamicObject.get("invoice_code"));
                leqiPurpose.set("invoice_no", dynamicObject.get("invoice_no"));
                leqiPurpose.set("electronic_no", dynamicObject.get("electronic_no"));
                leqiPurpose.set("invoice_date", dynamicObject.get("invoice_date"));
                leqiPurpose.set("serial_no", dynamicObject.get("serial_no"));
                String buyerTaxNo = dynamicObject.getString("buyer_tax_no");
                if (StringUtils.isNotEmpty((CharSequence)buyerTaxNo)) {
                    leqiPurpose.set("buyer_tax_no", (Object)buyerTaxNo);
                } else {
                    leqiPurpose.set("buyer_tax_no", (Object)taxNo);
                }
                leqiPurpose.set("invoice_type", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.get("invoice_type")));
                leqiPurpose.set("operate_type", (Object)"1");
                leqiPurpose.set("handle_num", (Object)0);
                ImcSaveServiceHelper.save((DynamicObject)leqiPurpose);
            }
            this.refresh();
        }
        return collection.size();
    }

    private void refresh() {
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.clearSelection();
        billlist.refresh();
    }
}

