/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.deduction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dlock.DLock;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.deduction.ReadyDeductSelectSerive;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionCheckTask;
import kd.imc.rim.common.service.DialogService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;

public class ReadySelectScannerResultPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String ENTRYENTITY = "entryentity";
    private static Log logger = LogFactory.getLog(ReadySelectScannerResultPlugin.class);

    public void afterCreateNewData(EventObject e) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        this.scannerProcess("create");
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("closeandrefresh".equals(itemKey)) {
            HashMap<String, String> customParams = new HashMap<String, String>(8);
            customParams.put("closeRefreshFlag", "yes");
            this.getView().returnDataToParent(customParams);
            this.getView().close();
        }
    }

    public void customEvent(CustomEventArgs e) {
        if ("dialog".equals(e.getEventName())) {
            this.scannerProcess("dialog");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scannerProcess(String type) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String lastPageId = (String)customParams.get("lastPageId");
        String pageId = this.getView().getPageId();
        try (DLock lock = DLock.create((String)("scannerSelect" + lastPageId + "_" + pageId), (String)ResManager.loadKDString((String)"\u5237\u65b0\u5361\u7247\u9501", (String)"ReadySelectScannerResultPlugin_27", (String)"imc-rim-formplugin", (Object[])new Object[0]));){
            int times = 0;
            String dialogId = "scanner";
            ReadyDeductSelectSerive readyDeductSelectSerive = new ReadyDeductSelectSerive();
            while (times < 30) {
                ++times;
                if (!lock.tryLock(500L)) continue;
                times = 100;
                JSONObject jsonObject = RecognitionCheckTask.queryCacheFile((String)lastPageId);
                logger.info("\u7236\u9875\u9762PageId\u5bf9\u5e94\u7684\u7f13\u5b58\u4fe1\u606f\uff1a " + lastPageId + jsonObject);
                try {
                    CustomControl customcontrol = (CustomControl)this.getControl("progress_control");
                    DialogService service = new DialogService(customcontrol);
                    int waiting = 0;
                    int fail = 0;
                    for (Map.Entry entry : jsonObject.entrySet()) {
                        String operate = (String)entry.getValue();
                        if ("waiting".equals(operate)) {
                            ++waiting;
                            continue;
                        }
                        if (!"fail".equals(operate)) continue;
                        ++fail;
                    }
                    int total = jsonObject.size();
                    if ("dialog".equals(type) && (total == 0 || waiting == 0)) {
                        logger.info("scannerProcess1:" + total + type + waiting + jsonObject);
                        if (total > 0) {
                            RecognitionCheckTask.clearCacheFile((String)lastPageId);
                        }
                        Set urlSet2 = jsonObject.keySet();
                        Iterator it2 = urlSet2.iterator();
                        ArrayList failObject = Lists.newArrayList();
                        ArrayList successObject = Lists.newArrayList();
                        while (it2.hasNext()) {
                            String url = (String)it2.next();
                            JSONArray resultArray = RecognitionCheckTask.queryCacheFileResult((String)url);
                            if (ObjectUtils.isEmpty((Object)resultArray)) continue;
                            for (int i = 0; i < resultArray.size(); ++i) {
                                JSONObject object = resultArray.getJSONObject(i);
                                if ("0000".equals(object.getString("errcode"))) {
                                    successObject.add(object);
                                    continue;
                                }
                                failObject.add(object);
                            }
                        }
                        failObject.addAll(successObject);
                        if (!CollectionUtils.isEmpty((Collection)failObject)) {
                            for (JSONObject failInfo : failObject) {
                                JSONObject invoiceInfo = (JSONObject)failInfo.get((Object)"invoice_info");
                                if (invoiceInfo == null) {
                                    invoiceInfo = new JSONObject();
                                }
                                logger.info("\u9884\u52fe\u9009\u7ed3\u679c\u5217\u8868\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\uff1a " + invoiceInfo);
                                String invoiceCache = this.getView().getPageCache().get(invoiceInfo.getString("serialNo"));
                                if (!StringUtils.isEmpty((CharSequence)invoiceCache)) continue;
                                int row = this.getModel().createNewEntryRow(ENTRYENTITY);
                                String url = invoiceInfo.getString("snapshotUrl");
                                this.getModel().setValue("file_url", (Object)url, row);
                                this.getModel().setValue("tax_period", (Object)failInfo.getString("tax_period"), row);
                                this.getModel().setValue("id", invoiceInfo.get((Object)"mainId"), row);
                                this.getModel().setValue("serial_no", invoiceInfo.get((Object)"serialNo"), row);
                                this.getModel().setValue("orgid", failInfo.get((Object)"org_id"), row);
                                this.getModel().setValue("taxorgid", failInfo.get((Object)"taxorg_id"), row);
                                this.getModel().setValue("saler_name", invoiceInfo.get((Object)"salerName"), row);
                                this.getModel().setValue("total_amount", invoiceInfo.get((Object)"totalAmount"), row);
                                String invoiceType = invoiceInfo.getString("invoiceType");
                                this.getModel().setValue("invoice_type", (Object)InputInvoiceTypeEnum.getInvoiceType((String)invoiceType).getName(), row);
                                JSONObject convertInfo = readyDeductSelectSerive.getConvertInfo(InputInvoiceTypeEnum.getInvoiceType((String)invoiceType).getCode(), invoiceInfo);
                                this.getModel().setValue("invoice_code", (Object)convertInfo.getString("invoice_code"), row);
                                this.getModel().setValue("invoice_no", (Object)convertInfo.getString("invoice_no"), row);
                                this.getModel().setValue("tax_amount", (Object)invoiceInfo.getString("taxAmount"), row);
                                this.getModel().setValue("result_desc", failInfo.get((Object)"desc"), row);
                                if (StringUtils.isEmpty((CharSequence)invoiceInfo.getString("serialNo"))) continue;
                                this.getView().getPageCache().put(invoiceInfo.getString("serialNo"), invoiceInfo.toJSONString());
                            }
                        }
                        if (total > 0 && fail > 0) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0a\u4f20%1$s\u4e2a\u6587\u4ef6\uff0c\u5904\u7406\u5931\u8d25%2$s\u4e2a", (String)"ReadySelectScannerResultPlugin_23", (String)"imc-rim-formplugin", (Object[])new Object[0]), total, fail), Integer.valueOf(10000));
                        } else if (total > 0) {
                            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u4e0a\u4f20%1$s\u4e2a\u6587\u4ef6\uff0c\u5904\u7406\u6210\u529f%2$s\u4e2a", (String)"ReadySelectScannerResultPlugin_24", (String)"imc-rim-formplugin", (Object[])new Object[0]), total, total, 10000));
                        }
                        service.hide();
                        continue;
                    }
                    String[] content = new String[]{String.format(ResManager.loadKDString((String)"\u5f85\u5904\u7406\u6587\u4ef6\u5269\u4f59%1$s\u4e2a", (String)"ReadySelectScannerResultPlugin_25", (String)"imc-rim-formplugin", (Object[])new Object[0]), waiting), String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u4e2d(%1$s/%2$s)", (String)"ReadySelectScannerResultPlugin_26", (String)"imc-rim-formplugin", (Object[])new Object[0]), total - waiting, total)};
                    service.show(dialogId, content, 1000);
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if ("select_edit".equals(afterDoOperationEventArgs.getOperateKey())) {
            int index = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRYENTITY, index);
            String serialNo = dynamicObject.getString("serial_no");
            String invoiceInfo = this.getView().getPageCache().get(serialNo);
            if (StringUtils.isEmpty((CharSequence)invoiceInfo)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u884c\u53d1\u7968\u8bc6\u522b\u67e5\u9a8c\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u626b\u63cf.", (String)"ReadySelectScannerResultPlugin_28", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            JSONObject invoice = JSON.parseObject((String)invoiceInfo);
            String errcode = invoice.getString("errcode");
            if ("0010".equals(errcode)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u884c\u53d1\u7968\u8bc6\u522b\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u626b\u63cf.", (String)"ReadySelectScannerResultPlugin_29", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            String taxPeriodStr = dynamicObject.getString("tax_period");
            Date taxPeriod = DateUtils.stringToDate((String)taxPeriodStr, (String)"yyyy-MM");
            Long orgId = dynamicObject.getLong("orgid");
            Boolean editAllow = Boolean.TRUE;
            String checkStatus = invoice.getString("checkStatus");
            Long type = invoice.getLong("invoiceType");
            if (InputInvoiceTypeEnum.needCheck((Long)type).booleanValue() && "1".equals(checkStatus)) {
                editAllow = Boolean.FALSE;
            }
            this.openEditInvoicePage(index, invoice, orgId, taxPeriod, editAllow);
        }
    }

    private void openEditInvoicePage(int index, JSONObject invoice, Long orgId, Date taxPeriod, Boolean editAllow) {
        logger.info("\u626b\u63cf\u4eea\u9884\u52fe\u9009\u7ed3\u679c\u5f53\u524d\u884c\u7684\u53d1\u7968\u4fe1\u606f:" + invoice);
        FormShowParameter showParameter = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("invoice", invoice);
        customParams.put("taxPeriod", taxPeriod);
        customParams.put("row", index);
        if (orgId == null) {
            orgId = RequestContext.get().getOrgId();
        }
        customParams.put("orgId", orgId);
        customParams.put("editAllow", editAllow);
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("rim_inv_collect_edit");
        showParameter.setCaption(ResManager.loadKDString((String)"\u53d1\u7968\u7f16\u8f91\u67e5\u9a8c", (String)"ReadySelectScannerResultPlugin_30", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "editCallback");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map callBackData = (Map)closedCallBackEvent.getReturnData();
        logger.info("\u626b\u63cf\u4eea\u9884\u52fe\u9009\u7ed3\u679c\u56de\u8c03\u9875\u9762\uff1a" + callBackData + closedCallBackEvent.getActionId());
        if (null != callBackData && "editCallback".equals(closedCallBackEvent.getActionId())) {
            Date endDate;
            ReadyDeductSelectSerive readyDeductSelectSerive;
            JSONObject result;
            int row = (Integer)callBackData.get("row");
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getEntryEntity(ENTRYENTITY).get(row);
            logger.info("\u56de\u8c03\u884c\u7684\u539f\u59cb\u6570\u636e\uff1a" + dynamicObject);
            Long orgId = dynamicObject.getLong("orgid");
            Long taxOrgId = dynamicObject.getLong("taxorgid");
            String taxPeriodStr = dynamicObject.getString("tax_period");
            Date taxPeriod = DateUtils.stringToDate((String)taxPeriodStr, (String)"yyyy-MM");
            String og_serialNo = dynamicObject.getString("serial_no");
            this.cancelOgInfoSelect(og_serialNo, taxPeriod);
            JSONObject invoice = (JSONObject)callBackData.get("invoice");
            logger.info("\u56de\u8c03\u884c\u7684\u65b0\u53d1\u7968\u6570\u636e\uff1a" + invoice);
            String serialNo1 = invoice.getString("serialNo");
            this.getView().getPageCache().remove(og_serialNo);
            this.getView().getPageCache().put(serialNo1, invoice.toJSONString());
            Long invoiceType = invoice.getLong("invoiceType");
            this.getModel().setValue("id", invoice.get((Object)"mainId"), row);
            this.getModel().setValue("serial_no", invoice.get((Object)"serialNo"), row);
            this.getModel().setValue("invoice_type", (Object)InputInvoiceTypeEnum.getInvoiceType((Long)invoiceType).getName(), row);
            this.getModel().setValue("invoice_code", (Object)invoice.getString("invoiceCode"), row);
            this.getModel().setValue("invoice_no", (Object)invoice.getString("invoiceNo"), row);
            this.getModel().setValue("tax_amount", (Object)invoice.getString("taxAmount"), row);
            this.getModel().setValue("saler_name", invoice.get((Object)"salerName"), row);
            this.getModel().setValue("total_amount", invoice.get((Object)"totalAmount"), row);
            String serialNo = invoice.getString("serialNo");
            if (StringUtils.isEmpty((CharSequence)serialNo)) {
                this.getModel().setValue("result_desc", (Object)ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u53d1\u7968\u5e8f\u5217\u53f7", (String)"ReadySelectScannerResultPlugin_31", (String)"imc-rim-formplugin", (Object[])new Object[0]), row);
            }
            if (ObjectUtils.isEmpty((Object)(result = (readyDeductSelectSerive = new ReadyDeductSelectSerive()).readySelectByTypeAndSerialNo(invoiceType, serialNo, orgId, taxOrgId, endDate = DateUtils.getLastDateOfMonth((Date)taxPeriod))))) {
                this.getModel().setValue("result_desc", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u5e8f\u5217\u53f7\u4e3a\u7a7a\u6216\u53d1\u7968\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", (String)"ReadySelectScannerResultPlugin_32", (String)"imc-rim-formplugin", (Object[])new Object[0]), row);
            } else {
                this.getModel().setValue("result_desc", result.get((Object)"desc"), row);
            }
        }
    }

    private void cancelOgInfoSelect(String og_serialNo, Date taxPeriod) {
        if (StringUtils.isEmpty((CharSequence)og_serialNo)) {
            return;
        }
        QFilter filter = new QFilter("serial_no", "=", (Object)og_serialNo);
        DynamicObject og_invoice = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id, invoice_type, authenticate_flag, transport_deduction, deduction_purpose, invoice_code, invoice_no, effective_tax_amount, total_tax_amount", (QFilter[])new QFilter[]{filter});
        Long og_invoiceType = og_invoice.getLong("invoice_type");
        String authenticateFlag = og_invoice.getString("authenticate_flag");
        String transportDeduction = og_invoice.getString("transport_deduction");
        ReadyDeductSelectSerive selectSerive = new ReadyDeductSelectSerive();
        String batchNo = UUID.getBatchNo((String)"READY");
        if (InputInvoiceTypeEnum.canDeduction((Long)og_invoiceType).booleanValue() && "4".equals(authenticateFlag)) {
            JSONArray taxDeductInvoiceArray = new JSONArray();
            JSONObject submitObject = new JSONObject();
            submitObject.put("serial_no", (Object)og_serialNo);
            submitObject.put("invoice_type", (Object)og_invoice.getString("invoice_type"));
            submitObject.put("deduction_purpose", (Object)og_invoice.getString("deduction_purpose"));
            submitObject.put("effective_tax_amount", (Object)og_invoice.getString("effective_tax_amount"));
            submitObject.put("tax_period", (Object)DateUtils.format((Date)taxPeriod, (String)"yyyyMM"));
            submitObject.put("authenticate_flag", (Object)"0");
            taxDeductInvoiceArray.add((Object)submitObject);
            selectSerive.readyDeductSelect(taxDeductInvoiceArray, "0", taxPeriod, batchNo);
        } else if (InputInvoiceTypeEnum.canTransportDeduction((Long)og_invoiceType).booleanValue() && "2".equals(transportDeduction)) {
            ArrayList transportDeductSerialNos = Lists.newArrayList();
            transportDeductSerialNos.add(og_serialNo);
            selectSerive.readyDeductTransport((List)transportDeductSerialNos, "0", taxPeriod, batchNo);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getEntryEntity(ENTRYENTITY).get(arg0.getRowIndex());
        String fileUrl = dynamicObject.getString("file_url");
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("fileUrl", fileUrl);
        FormShowParameter showParameter = this.newPage("rim_inv_file_preview", customParams, null);
        showParameter.setCaption(ResManager.loadKDString((String)"\u6587\u4ef6\u9884\u89c8", (String)"ReadySelectScannerResultPlugin_33", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private FormShowParameter newPage(String formId, Map<String, Object> customParams, String callBackId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setShowTitle(true);
        showParameter.setCustomParams(customParams);
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isNotEmpty((CharSequence)callBackId)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, callBackId);
            showParameter.setCloseCallBack(closeCallBack);
        }
        return showParameter;
    }
}

