/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.downloadcenter;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.formplugin.downloadcenter.InvoiceFileDownloadService;

public class DownloadCenterHelper {
    private static Log LOGGER = LogFactory.getLog(DownloadCenterHelper.class);
    private static final String STATE = "state";
    private static final String SERIAL_NO = "serial_no";
    private static final String OFD_URL = "ofd_url";
    private static final String PDF_URL = "pdf_url";
    private static final String IMAGE_URL = "image_url";

    public static void skipDownloadCenterNotify(AbstractFormPlugin plugin, String type) {
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"DownloadCenterHelper_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7acb\u523b\u524d\u5f80", (String)"DownloadCenterHelper_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        plugin.getView().showConfirm(ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u5bfc\u51fa\u5904\u7406\u4e2d\uff0c\u7531\u4e8e\u6570\u636e\u91cf\u8f83\u5927\uff0c\u60a8\u53ef\u4ee5\u524d\u5f80\u4e0b\u8f7d\u4e2d\u5fc3\u67e5\u770b\u8fdb\u5ea6", (String)"DownloadCenterHelper_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(type), btnNameMaps);
    }

    public static void dispatch(List<Map<String, String>> invoiceList, String invoiceType) {
        DownloadCenterHelper.dispatch(invoiceList, invoiceType, null);
    }

    public static void dispatch(List<Map<String, String>> invoiceList, String invoiceType, String originalType) {
        InputInvoiceTypeEnum typeEnum = InputInvoiceTypeEnum.getInvoiceType((Long)Long.parseLong(String.valueOf(invoiceType)));
        String name = typeEnum.getName();
        Date currentDate = new Date();
        DynamicObject centerData = BusinessDataServiceHelper.newDynamicObject((String)"bdm_download_center");
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        centerData.set("file_type", (Object)"2");
        centerData.set("applytime", (Object)currentDate);
        centerData.set("source", (Object)"\u53d1\u7968\u6587\u4ef6\u4e0b\u8f7d");
        centerData.set("filename", (Object)(name + "_" + format.format(currentDate) + ".zip"));
        centerData.set("delstate", (Object)"1");
        centerData.set("handlestate", (Object)"1");
        centerData.set("appid", (Object)"rim");
        centerData.set("down_original_types", (Object)originalType);
        centerData.set("applicant", (Object)RequestContext.get().getUserId());
        DynamicObjectCollection detail = centerData.getDynamicObjectCollection("invoice_detail");
        for (Map<String, String> map : invoiceList) {
            DynamicObject entity = detail.addNew();
            entity.set(SERIAL_NO, (Object)map.get("id"));
            entity.set("deal_result", (Object)"0");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{centerData});
        new InvoiceFileDownloadService().dealSync();
        new InvoiceFileDownloadService().clearSync();
    }
}

