/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.downloadcenter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.formplugin.downloadcenter.DownLoadService;
import kd.imc.rim.formplugin.downloadcenter.DownloadCenterHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class InvoiceFileDownloadService
extends DownLoadService {
    private static Log LOGGER = LogFactory.getLog(InvoiceFileDownloadService.class);
    private static final String lockId = UUID.randomUUIDZero();
    private static final int zipSize = 0x3200000;
    private static final String success = "10";

    /*
     * Exception decompiling
     */
    @Override
    public void deal() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean downloadByTaskId(Object pk) {
        LOGGER.info("BatchDownloadHelper-" + pk);
        try (DLock lock = DLock.create((String)("downFile" + pk));){
            if (lock.tryLock()) {
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bdm_download_center");
                String state = obj.getString("handlestate");
                if ("1".equals(state)) {
                    boolean finish = false;
                    DynamicObjectCollection serialNos = obj.getDynamicObjectCollection("invoice_detail");
                    ArrayList<Long> pkList = new ArrayList<Long>(8);
                    HashMap<Long, DynamicObject> fileMap = new HashMap<Long, DynamicObject>(8);
                    for (DynamicObject entry : serialNos) {
                        String dealresult = entry.getString("deal_result");
                        if (!"0".equals(dealresult)) continue;
                        String serial = entry.getString("serial_no");
                        Long pkId = BigDecimalUtil.transDecimal((Object)serial).longValue();
                        if (pkId > 0L) {
                            pkList.add(pkId);
                        }
                        fileMap.put(pkId, entry);
                    }
                    if (pkList.isEmpty()) {
                        obj.set("handlestate", (Object)"2");
                        finish = true;
                    } else {
                        DynamicObjectCollection uploaddetail = obj.getDynamicObjectCollection("file_detail");
                        int index = uploaddetail.size() + 1;
                        String fileName = obj.getString("filename");
                        String billno = fileName.replace(".zip", "") + index + ".zip";
                        LOGGER.info("BatchDownloadHelper-" + pk + billno + "\u9700\u8981\u5904\u7406" + pkList.size());
                        String downOriginalTypes = obj.getString("down_original_types");
                        if (StringUtils.isBlank((CharSequence)downOriginalTypes)) {
                            downOriginalTypes = obj.getString("original_type");
                        }
                        Map<String, Object> result = this.download(pkList.toArray(new Long[0]), billno, downOriginalTypes);
                        String url = (String)result.get("url");
                        List dealList = (List)result.get("ids");
                        if (StringUtils.isNotEmpty((CharSequence)url)) {
                            LOGGER.info("BatchDownloadHelper-" + pk + billno + "\u5904\u7406\u6210\u529f" + dealList.size());
                            for (Long id : dealList) {
                                DynamicObject entry = (DynamicObject)fileMap.get(id);
                                entry.set("deal_result", (Object)success);
                            }
                            DynamicObject upDetail = uploaddetail.addNew();
                            upDetail.set("detail_url", (Object)url);
                            upDetail.set("detail_file_name", (Object)billno);
                            if (dealList.size() == pkList.size()) {
                                obj.set("handlestate", (Object)"2");
                                finish = true;
                            }
                        } else {
                            obj.set("handlestate", (Object)"2");
                            finish = true;
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                    LOGGER.info("BatchDownloadHelper-" + pk + "\u5df2\u7ecf\u5904\u74061");
                    boolean bl = finish;
                    return bl;
                }
                LOGGER.info("BatchDownloadHelper-" + pk + "\u5df2\u7ecf\u5904\u74062");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Map<String, Object> download(Long[] pkList, String zipName, String originalType) {
        void var11_18;
        ArrayList<Long> list = new ArrayList<Long>(4);
        List<Map<String, String>> fileList = InvoiceFileDownloadService.getInvoiceList(pkList, originalType);
        ArrayList existsId = new ArrayList(4);
        fileList.stream().forEach(map -> existsId.add(Long.valueOf((String)map.get("id"))));
        for (Long id : pkList) {
            if (existsId.contains(id)) continue;
            list.add(id);
        }
        int total = 0;
        ByteArrayOutputStream out = null;
        DeflaterOutputStream zipOut = null;
        try {
            for (Map map2 : fileList) {
                if (zipOut == null) {
                    out = new ByteArrayOutputStream();
                    zipOut = new ZipOutputStream(out);
                }
                String url = (String)map2.get("url");
                Pair fileContent = FileUtils.getFileContent((String)((String)map2.get("url")));
                if (fileContent != null) {
                    total += ((byte[])fileContent.getRight()).length;
                    try {
                        this.doZip((byte[])fileContent.getRight(), (ZipOutputStream)zipOut, "", InvoiceFileDownloadService.getFileName((String)map2.get("fileName"), (String)fileContent.getLeft()));
                        list.add(Long.valueOf((String)map2.get("id")));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (total <= 0x3200000) continue;
                    break;
                }
                LOGGER.info("BatchDownloadHelper-" + url + "\u4e0b\u8f7d\u5185\u5bb9\u4e3a\u7a7a");
                list.add(Long.valueOf((String)map2.get("id")));
            }
        }
        finally {
            if (zipOut != null) {
                try {
                    zipOut.flush();
                    ((ZipOutputStream)zipOut).close();
                }
                catch (IOException id) {}
            }
        }
        HashMap<String, Object> downResult = new HashMap<String, Object>(8);
        Object var11_16 = null;
        if (zipOut != null && out != null) {
            String string = this.upload(zipName + ".zip", out.toByteArray());
        }
        downResult.put("size", total / 1024);
        downResult.put("url", var11_18);
        downResult.put("ids", list);
        return downResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String downloadTemp(List<Map<String, String>> fileList, String zipName) {
        ByteArrayOutputStream out = null;
        DeflaterOutputStream zipOut = null;
        for (Map<String, String> map : fileList) {
            Pair fileContent;
            if (zipOut == null) {
                out = new ByteArrayOutputStream();
                zipOut = new ZipOutputStream(out);
            }
            if ((fileContent = FileUtils.getFileContent((String)map.get("url"))) == null || fileContent.getRight() == null) continue;
            try {
                this.doZip((byte[])fileContent.getRight(), (ZipOutputStream)zipOut, "", InvoiceFileDownloadService.getFileName(map.get("fileName"), (String)fileContent.getLeft()));
            }
            catch (IOException iOException) {}
        }
        if (zipOut == null) return null;
        try {
            zipOut.flush();
            ((ZipOutputStream)zipOut).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (out == null) return null;
        try (ByteArrayInputStream bytein = new ByteArrayInputStream(out.toByteArray());){
            String urls;
            String string = urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipName + ".zip", (InputStream)bytein, CommonUtils.getTempFileMaxTimeout());
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static void downloadFile(AbstractFormPlugin plugin, String type, Object[] pkList, String taxOriginalTypes) {
        List<Map<String, String>> map = InvoiceFileDownloadService.getInvoiceList(pkList, taxOriginalTypes);
        if (map == null || map.isEmpty()) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684\u6587\u4ef6", (String)"InvoiceFileDownloadService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        Object invoiceType = plugin.getView().getFormShowParameter().getCustomParam("invoicetype");
        if (pkList.length > 10) {
            DownloadCenterHelper.dispatch(map, invoiceType.toString(), taxOriginalTypes);
            DownloadCenterHelper.skipDownloadCenterNotify(plugin, type);
        } else {
            String name = InputInvoiceTypeEnum.getInvoiceType((Long)Long.parseLong(String.valueOf(invoiceType))).getName();
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            String download = new InvoiceFileDownloadService().downloadTemp(map, name + format.format(new Date()));
            PermissionUtils.addTempFilePermission((String)download, (String)"rim_invoice", (String)"23+Y3P5F6LEE", (int)CommonUtils.getTempFileMaxTimeout());
            plugin.getView().openUrl(download);
        }
    }

    public static List<Map<String, String>> getInvoiceList(Object[] pkList) {
        return InvoiceFileDownloadService.getInvoiceList(pkList, null);
    }

    public static List<Map<String, String>> getInvoiceList(Object[] pkList, String taxOriginalTypes) {
        QFilter filter = new QFilter("id", "in", (Object)pkList);
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_code,invoice_no,billno", (QFilter[])new QFilter[]{filter});
        ArrayList<String> serialNoList = new ArrayList<String>(collect.size());
        HashMap invoiceMap = new HashMap(pkList.length);
        ArrayList<String> repetKey = new ArrayList<String>();
        for (DynamicObject invoice : collect) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", invoice.get("id").toString());
            map.put("serialNo", invoice.getString("serial_no"));
            String serialNo = invoice.getString("serial_no");
            String invoice_code = invoice.getString("invoice_code");
            String invocie_no = invoice.getString("invoice_no");
            String key = invoice_code + "_" + invocie_no;
            if (StringUtils.isEmpty((CharSequence)invoice_code) && StringUtils.isEmpty((CharSequence)invocie_no)) {
                key = serialNo;
            }
            int i = 0;
            if (repetKey.contains(key)) {
                for (String str : repetKey) {
                    if (!key.equals(str)) continue;
                    ++i;
                }
            }
            repetKey.add(key);
            if (i > 0) {
                key = key + "(" + i + ")";
            }
            map.put("fileName", key);
            invoiceMap.put(serialNo, map);
            serialNoList.add(invoice.getString("serial_no"));
        }
        QFilter serialFilter = new QFilter("serial_no", "in", serialNoList);
        DynamicObjectCollection fileCollect = QueryServiceHelper.query((String)"rim_invoice_file", (String)"pdf_url,ofd_url,image_url,snapshot_url,xml_url,serial_no,tax_pdf_url,tax_ofd_url,tax_xml_url", (QFilter[])new QFilter[]{serialFilter});
        ArrayList<Map<String, String>> fileList = new ArrayList<Map<String, String>>(pkList.length);
        HashSet<String> urlSet = new HashSet<String>(8);
        for (DynamicObject invoice : fileCollect) {
            String serialNo = invoice.getString("serial_no");
            Map map = (Map)invoiceMap.get(serialNo);
            if (StringUtils.isBlank((CharSequence)taxOriginalTypes)) {
                InvoiceFileDownloadService.getFileUrl(fileList, urlSet, invoice, map, taxOriginalTypes);
                continue;
            }
            List list = CommonUtils.getMultiValues((String)taxOriginalTypes);
            for (String type : list) {
                HashMap<String, String> map2 = new HashMap<String, String>(map);
                InvoiceFileDownloadService.getFileUrl(fileList, urlSet, invoice, map2, type);
            }
        }
        return fileList;
    }

    private static void getFileUrl(List<Map<String, String>> fileList, Set<String> urlSet, DynamicObject invoice, Map<String, String> map, String type) {
        String url;
        if (fileList == null || urlSet == null || invoice == null) {
            return;
        }
        Pair<String, String> urlFile = InvoiceFileDownloadService.getDownUrl(invoice, type);
        if (urlFile != null && urlSet.add(url = (String)urlFile.getLeft())) {
            map.put("fileName", map.get("fileName") + '.' + (String)urlFile.getRight());
            map.put("url", url);
            fileList.add(map);
        }
    }

    private static Pair<String, String> getDownUrl(DynamicObject fileObject, String taxOriginalType) {
        String ofdUrl = fileObject.getString("ofd_url");
        String pdf_url = fileObject.getString("pdf_url");
        String image_url = fileObject.getString("image_url");
        String snapshot_url = fileObject.getString("snapshot_url");
        String xml_url = fileObject.getString("xml_url");
        String taxXmlUrl = fileObject.getString("tax_xml_url");
        String taxOfdUrl = fileObject.getString("tax_ofd_url");
        String taxPdfUrl = fileObject.getString("tax_pdf_url");
        if (StringUtils.isEmpty((CharSequence)taxOriginalType)) {
            if (StringUtils.isNotEmpty((CharSequence)ofdUrl)) {
                return Pair.of((Object)ofdUrl, (Object)"ofd");
            }
            if (StringUtils.isNotEmpty((CharSequence)pdf_url)) {
                return Pair.of((Object)pdf_url, (Object)"pdf");
            }
            if (StringUtils.isNotEmpty((CharSequence)image_url)) {
                return Pair.of((Object)image_url, (Object)"jpg");
            }
            if (StringUtils.isNotEmpty((CharSequence)snapshot_url)) {
                return Pair.of((Object)snapshot_url, (Object)"jpg");
            }
            if (StringUtils.isNotEmpty((CharSequence)xml_url)) {
                return Pair.of((Object)xml_url, (Object)"xml");
            }
            return null;
        }
        if ("4".equals(taxOriginalType)) {
            return Optional.ofNullable(taxOfdUrl).filter(StringUtils::isNotEmpty).map(s -> Pair.of((Object)s, (Object)"ofd")).orElse(null);
        }
        if ("1".equals(taxOriginalType)) {
            return Optional.ofNullable(taxPdfUrl).filter(StringUtils::isNotEmpty).map(s -> Pair.of((Object)s, (Object)"pdf")).orElse(null);
        }
        if ("2".equals(taxOriginalType)) {
            if (StringUtils.isNotEmpty((CharSequence)image_url)) {
                return Pair.of((Object)image_url, (Object)"jpg");
            }
            if (StringUtils.isNotEmpty((CharSequence)snapshot_url)) {
                return Pair.of((Object)snapshot_url, (Object)"jpg");
            }
            return null;
        }
        if ("9".equals(taxOriginalType)) {
            return Optional.ofNullable(taxXmlUrl).filter(StringUtils::isNotEmpty).map(s -> Pair.of((Object)s, (Object)"xml")).orElse(null);
        }
        return null;
    }

    private static String getFileName(String defaultFile, String fileType) {
        if (StringUtils.isEmpty((CharSequence)fileType) || StringUtils.isEmpty((CharSequence)defaultFile)) {
            return defaultFile;
        }
        int index = defaultFile.lastIndexOf(46);
        if (index < 0) {
            return defaultFile;
        }
        return defaultFile.substring(0, index + 1) + fileType;
    }
}

