/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.fpzs;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.invoice.query.AttachSaveService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.ViewUtil;
import org.apache.commons.lang3.StringUtils;

public class FpzsAttachListPlugin
extends AbstractListPlugin {
    private static final String BILL_LIST_AP = "billlistap";
    private static final String DELETE_BUTTON = "delete";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        billList.addListRowDoubleClickListener((ListRowClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().beginInit();
        this.getModel().setValue("start_date", (Object)DateUtils.addYear((Date)new Date(), (int)-1));
        this.getModel().setValue("end_date", (Object)new Date());
        this.getModel().endInit();
        this.loadData();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("search_category".equals(name) || "search_name".equals(name) || "end_date".equals(name) || "start_date".equals(name)) {
            this.loadData();
        }
    }

    private void loadData() {
        Date start = (Date)this.getModel().getValue("start_date");
        Date end = (Date)this.getModel().getValue("end_date");
        DynamicObject searchCategory = (DynamicObject)this.getModel().getValue("search_category");
        String searchName = (String)this.getModel().getValue("search_name");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String userIdStr = RequestContext.get().getUserId();
        Long userId = Long.valueOf(userIdStr);
        long rimUser = BigDecimalUtil.transDecimal(customParams.get("rim_user")).longValue();
        QFilter filter = new QFilter("user", "=", (Object)userId);
        if (rimUser > 0L) {
            filter.and("rim_user", "=", (Object)rimUser);
        }
        if (start != null) {
            filter.and("create_time", ">=", (Object)DateUtils.trunc((Date)start));
        }
        if (end != null) {
            filter.and("create_time", "<", (Object)DateUtils.trunc((Date)DateUtils.addDay((Date)end, (int)1)));
        }
        if (searchCategory != null && searchCategory.getLong("id") > 0L) {
            filter.and("attach_category", "=", (Object)searchCategory.getLong("id"));
        }
        if (!StringUtils.isEmpty((CharSequence)searchName)) {
            filter.and("attach_name", "like", (Object)("%" + searchName + "%"));
        }
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
        FilterParameter fp = new FilterParameter();
        fp.setFilter(filter);
        fp.setOrderBy("create_time desc");
        billList.setFilterParameter(fp);
        billList.refresh();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result == null || !result.isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (DELETE_BUTTON.equals(operateKey)) {
            BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
            ListSelectedRow currentListSelectedRow = billList.getCurrentSelectedRowInfo();
            if (currentListSelectedRow == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9644\u4ef6", (String)"FpzsAttachListPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"FpzsAttachListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"FpzsAttachListPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u540e\u6570\u636e\u65e0\u6cd5\u67e5\u770b\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"FpzsAttachListPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, new ConfirmCallBackListener(DELETE_BUTTON, (IFormPlugin)this), btnNameMaps);
        } else if ("import".equals(operateKey)) {
            BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u6570\u636e\u518d\u6267\u884c\u5bfc\u5165\u64cd\u4f5c", (String)"FpzsAttachListPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object[]> returnData = new HashMap<String, Object[]>(8);
            returnData.put("attachIds", selectedRows.getPrimaryKeyValues());
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else if ("view_detail".equals(operateKey)) {
            BillList billlistap = (BillList)this.getView().getControl(BILL_LIST_AP);
            this.viewDetail(billlistap.getCurrentSelectedRowInfo().getPrimaryKeyValue());
        }
    }

    private void viewDetail(Object attachId) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("attachid", attachId);
        customParams.put("editFlag", "0");
        ViewUtil.openDialog((AbstractFormPlugin)this, customParams, (String)"rim_fpzs_attach_edit", (String)"rim_fpzs_attach_edit");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (DELETE_BUTTON.equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            BillList billlistap = (BillList)this.getView().getControl(BILL_LIST_AP);
            Long primaryKeyValue = (Long)billlistap.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            AttachSaveService.deleteAttach((Long)primaryKeyValue);
            billlistap.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"FpzsAttachListPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        this.viewDetail(currentListSelectedRow.getPrimaryKeyValue());
    }
}

