/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.fpzs;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.AttachConstant;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.file.utils.FileConvertUtils;
import org.apache.commons.lang3.StringUtils;

public class FpzsAttachService {
    private static Log logger = LogFactory.getLog(FpzsAttachService.class);
    private static final String ATTACH_PDF_ICON_NAME = "fpy_icon_pdf.png";
    private static final String ATTACH_PDF_ICON_URL = "/rim/attach/fpy_icon_pdf.png";
    private static final String[] ALLOW_FILE_TYPE = new String[]{"png", "bmp", "jpg", "jpeg", "webp", "pdf", "doc", "docx", "xls", "xlsx", "pptx", "txt", "jfif", "gif", "tif", "ppt", "dib", "emf", "rle", "pcx", "dcx", "pic", "tga", "wmf"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAttachIconUrl(String attachUrl) {
        InputStream fileInputStream = null;
        String iconImage = "";
        try {
            fileInputStream = FileServiceFactory.getAttachmentFileService().getInputStream(attachUrl);
            byte[] streamByte = FileUtils.getByte((InputStream)fileInputStream);
            iconImage = FileConvertUtils.pdf2image((byte[])streamByte, (String)"jpg");
        }
        catch (Exception e) {
            logger.error("pdf\u9644\u4ef6\u751f\u6210\u5feb\u7167\u4fe1\u606f\u9519\u8bef,\u4f7f\u7528\u672c\u5730icon", (Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u9644\u4ef6\u6d41\u5931\u8d25", (Throwable)e);
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)iconImage)) {
            FileService service = FileServiceFactory.getAttachmentFileService();
            boolean fileExist = service.exists(ATTACH_PDF_ICON_URL);
            if (fileExist) {
                iconImage = ATTACH_PDF_ICON_URL;
            } else {
                InputStream in = null;
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    in = classLoader.getResourceAsStream("templates".concat("/").concat(ATTACH_PDF_ICON_NAME));
                    String fileName = ATTACH_PDF_ICON_NAME;
                    iconImage = FileUploadUtils.upload((String)("/rim/attach/" + fileName), (String)fileName, (InputStream)in);
                }
                catch (Exception e) {
                    logger.error("\u4e0a\u4f20\u672c\u5730\u9644\u4ef6icon\u5931\u8d25", (Throwable)e);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        logger.error("\u5173\u95ed\u9644\u4ef6pdf_icon\u9519\u8bef", (Throwable)e);
                    }
                }
            }
        }
        return iconImage;
    }

    public static DynamicObject saveAttach(String originalFileName, String urlPath, AbstractFormPlugin plugin) {
        String fileName = null;
        String fileType = null;
        if (StringUtils.isNotEmpty((CharSequence)urlPath) && urlPath.length() > 200) {
            try (InputStream fileInputStream2 = UrlServiceUtils.getAttachmentDecodedStream((InputStream)FileServiceFactory.getAttachmentFileService().getInputStream(urlPath));){
                String newFileName = UUID.randomUUID() + "." + FileUtils.getFileType((String)originalFileName);
                String storePath = FileUploadUtils.getInvoiceDir((String)"invoice") + newFileName;
                urlPath = FileUploadUtils.upload((String)storePath, (String)newFileName, (InputStream)fileInputStream2);
                FileUploadUtils.delete((String)urlPath);
            }
            catch (IOException fileInputStream2) {
                // empty catch block
            }
        }
        if (StringUtils.isEmpty((CharSequence)originalFileName)) {
            originalFileName = urlPath.substring(urlPath.lastIndexOf(47) + 1);
            if (StringUtils.isNotBlank((CharSequence)originalFileName)) {
                fileName = originalFileName.substring(0, originalFileName.lastIndexOf(46));
                fileType = originalFileName.substring(originalFileName.lastIndexOf(46) + 1);
            } else {
                fileName = UUID.randomUUID();
            }
        } else if (originalFileName.lastIndexOf(46) != -1) {
            fileName = originalFileName.substring(0, originalFileName.lastIndexOf(46));
            fileType = originalFileName.substring(originalFileName.lastIndexOf(46) + 1);
        } else {
            plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u7684\u6587\u4ef6\u7c7b\u578b", (String)"FpzsAttachService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (fileName.length() > 50) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u8fc7\u957f\uff0c\u5df2\u81ea\u52a8\u4e3a\u60a8\u622a\u53d6\u524d30\u4e2a\u5b57\u7b26", (String)"FpzsAttachService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            fileName = fileName.substring(0, 30);
        }
        if (fileType == null || !Arrays.asList(ALLOW_FILE_TYPE).contains(fileType.toLowerCase())) {
            plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u76ee\u524d\u53ea\u652f\u6301\u56fe\u7247/PDF/office\u6587\u6863/txt\u7b49\u683c\u5f0f\u4f5c\u4e3a\u9644\u4ef6", (String)"FpzsAttachService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return null;
        }
        Date createTime = new Date();
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream fileInputStream = service.getInputStream(urlPath);
        String attachHash = FileUtils.getSHA256((InputStream)fileInputStream);
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        Map customParams = plugin.getView().getFormShowParameter().getCustomParams();
        Long rim_user = BigDecimalUtil.transDecimal(customParams.get("rim_user")).longValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach");
        String iconImage = "";
        if ("ofd".equalsIgnoreCase(fileType)) {
            dynamicObject.set("attach_type", (Object)"4");
            iconImage = FpzsAttachService.getAttachIconUrl(urlPath);
            dynamicObject.set("icon_url", (Object)iconImage);
            dynamicObject.set("snapshot_url", (Object)iconImage);
        } else if ("pdf".equalsIgnoreCase(fileType)) {
            dynamicObject.set("attach_type", (Object)"1");
            iconImage = FpzsAttachService.getAttachIconUrl(urlPath);
            dynamicObject.set("icon_url", (Object)iconImage);
            dynamicObject.set("snapshot_url", (Object)iconImage);
        } else if ("doc".equalsIgnoreCase(fileType) || "docx".equalsIgnoreCase(fileType)) {
            dynamicObject.set("attach_type", (Object)"5");
        } else if ("xls".equalsIgnoreCase(fileType) || "xlsx".equalsIgnoreCase(fileType)) {
            dynamicObject.set("attach_type", (Object)"6");
        } else if ("pptx".equalsIgnoreCase(fileType)) {
            dynamicObject.set("attach_type", (Object)"7");
        } else if ("txt".equalsIgnoreCase(fileType)) {
            dynamicObject.set("attach_type", (Object)"8");
        } else {
            dynamicObject.set("snapshot_url", (Object)urlPath);
            dynamicObject.set("attach_type", (Object)"2");
        }
        dynamicObject.set("attach_category", (Object)AttachConstant.ATTACH_OTHER_CATEGORY_ID);
        dynamicObject.set("original_name", (Object)originalFileName);
        dynamicObject.set("attach_hash_value", (Object)attachHash);
        dynamicObject.set("update_time", (Object)new Date());
        dynamicObject.set("create_time", (Object)createTime);
        dynamicObject.set("attach_name", (Object)fileName);
        dynamicObject.set("user", (Object)userId);
        dynamicObject.set("file_extension", (Object)fileType);
        dynamicObject.set("rim_user", (Object)rim_user);
        String attachNo = UUID.randomUUID();
        dynamicObject.set("attach_no", (Object)attachNo);
        dynamicObject.set("attach_url", (Object)urlPath);
        dynamicObject = (DynamicObject)SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject})[0];
        return dynamicObject;
    }

    public static String getPreviewIconUrl(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        String iconImage = StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("snapshot_url")) ? dynamicObject.getString("snapshot_url") : (StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("icon_url")) ? dynamicObject.getString("icon_url") : AttachConstant.getAttachIconUrl((String)dynamicObject.getString("attach_type")));
        if ("2".equals(dynamicObject.getString("attach_type"))) {
            iconImage = dynamicObject.getString("attach_url");
        }
        return iconImage;
    }

    public static String getPreviewIconUrl(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String iconImage = StringUtils.isNotEmpty((CharSequence)jsonObject.getString("snapshotUrl")) ? jsonObject.getString("snapshotUrl") : (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("iconUrl")) ? jsonObject.getString("iconUrl") : AttachConstant.getAttachIconUrl((String)jsonObject.getString("attachType")));
        if ("2".equals(jsonObject.getString("attachType"))) {
            iconImage = jsonObject.getString("attachUrl");
        }
        return iconImage;
    }

    public static String getPreviewIconFullUrl(DynamicObject dynamicObject) {
        String iconImage = FpzsAttachService.getPreviewIconUrl(dynamicObject);
        return UrlServiceUtils.getFileFullUrl((String)iconImage);
    }

    public static String getPreviewIconFullUrl(JSONObject jsonObject) {
        String iconImage = FpzsAttachService.getPreviewIconUrl(jsonObject);
        return UrlServiceUtils.getFileFullUrl((String)iconImage);
    }
}

