/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.fpzs;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.multitenant.helper.RimInvoiceHelper;
import kd.imc.rim.common.multitenant.service.MultiTenantService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.InvoiceConfigUtils;
import kd.imc.rim.formplugin.query.OpenInvoiceDetailService;
import org.apache.commons.lang3.StringUtils;

public class FpzsMultiTenantInvoiceLisPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public static final String BILL_LIST_AP = "entryentity";
    public static final String DELETE_USER_INVOICE_BUTTON = "bardelete";
    private static final String[] FIELDS = new String[]{"id", "invoice_info", "saler_name", "invoice_no", "total_amount", "total_tax_amount", "invoice_date"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid billList = (EntryGrid)this.getControl(BILL_LIST_AP);
        billList.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        if (!InvoiceConfigUtils.showInvoiceInfo()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity.invoice_info"});
        }
        this.getModel().beginInit();
        this.getModel().setValue("start_date", (Object)DateUtils.addYear((Date)new Date(), (int)-1));
        this.getModel().setValue("end_date", (Object)new Date());
        this.getModel().endInit();
        this.loadData();
        this.initDeleteOperateColumnVisible();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)"baritemap1", (CharSequence)evt.getItemKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(BILL_LIST_AP);
            int[] selectRows = entryGrid.getSelectRows();
            HashMap<String, ArrayList<Object>> customParams = new HashMap<String, ArrayList<Object>>(8);
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u6570\u636e\u518d\u6267\u884c\u5bfc\u5165\u64cd\u4f5c", (String)"FpzsMultiTenantAttachListPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> primaryKeys = new ArrayList<Long>(8);
            DynamicObjectCollection entity = this.getModel().getEntryEntity(BILL_LIST_AP);
            for (int selectedRow : selectRows) {
                primaryKeys.add((Long)((DynamicObject)entity.get(selectedRow)).getPkValue());
            }
            if (!CollectionUtils.isEmpty(primaryKeys)) {
                customParams.put("invoiceIds", primaryKeys);
                Map preCustomParams = this.getView().getFormShowParameter().getCustomParams();
                customParams.put("isPerson", (ArrayList<Object>)preCustomParams.get("isPerson"));
            }
            this.getView().returnDataToParent(customParams);
            this.getView().close();
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("status".equals(name) || "start_date".equals(name) || "end_date".equals(name) || "search_text".equals(name) || "original_state".equals(name)) {
            this.loadData();
        }
    }

    private void loadData() {
        Date start = (Date)this.getModel().getValue("start_date");
        Date end = (Date)this.getModel().getValue("end_date");
        String status = (String)this.getModel().getValue("status");
        String originalState = (String)this.getModel().getValue("original_state");
        String searchText = (String)this.getModel().getValue("search_text");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("entity", "rim_invoice");
        customParams.put("start_date", start);
        customParams.put("end_date", end);
        customParams.put("status", status);
        customParams.put("original_state", originalState);
        customParams.put("search_text", searchText);
        Object[] dynamicObjectCollection = null;
        MultiTenantService service = new MultiTenantService();
        if (service.isMultiTenant()) {
            String result = (String)service.doPost("RimInvoiceListServiceOpenApiImpl", "queryFpzsInvoiceList", (Object)customParams);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"rim_invoice");
            dynamicObjectCollection = DynamicObjectSerializeUtil.deserialize((String)result, (DynamicObjectType)type);
        } else {
            dynamicObjectCollection = RimInvoiceHelper.getRimInvoiceList((String)"rim_invoice", (Map)customParams);
        }
        IDataModel model = this.getModel();
        model.deleteEntryData(BILL_LIST_AP);
        model.beginInit();
        if (dynamicObjectCollection != null && dynamicObjectCollection.length > 0) {
            TableValueSetter vs = new TableValueSetter(FIELDS);
            for (int i = 0; i < dynamicObjectCollection.length; ++i) {
                DynamicObject rimInfo = dynamicObjectCollection[i];
                Object[] value = new Object[FIELDS.length];
                value[0] = rimInfo.getString("id");
                value[1] = rimInfo.getString("invoice_info");
                value[2] = rimInfo.getString("saler_name");
                value[3] = rimInfo.getString("invoice_no");
                value[4] = rimInfo.getBigDecimal("total_amount");
                value[5] = rimInfo.getBigDecimal("total_tax_amount");
                value[6] = rimInfo.getDate("invoice_date");
                vs.addRow(value);
            }
            AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
            dataModel.batchCreateNewEntryRow(BILL_LIST_AP, vs);
        }
        model.endInit();
        model.setDataChanged(false);
        this.getView().updateView(BILL_LIST_AP);
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        int row = evt.getRow();
        DynamicObjectCollection entity = this.getModel().getEntryEntity(BILL_LIST_AP);
        if (new MultiTenantService().isMultiTenant()) {
            OpenInvoiceDetailService.openEditViewByMultitenantMainId(this, (Long)((DynamicObject)entity.get(row)).getPkValue());
        } else {
            OpenInvoiceDetailService.openEditViewByMainId(this, (Long)((DynamicObject)entity.get(row)).getPkValue());
        }
    }

    private void initDeleteOperateColumnVisible() {
        this.getView().setVisible(Boolean.valueOf(this.isPersonInvoice()), new String[]{"listdeletenap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("donothing".equals(afterDoOperationEventArgs.getOperateKey())) {
            if (!this.isPersonInvoice()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u7968\u5939\u5217\u8868\u4e0d\u652f\u6301\u5220\u9664\u53d1\u7968", (String)"FpzsMultiTenantInvoiceLisPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(BILL_LIST_AP);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"DownloadElectricOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"FpzsMultiTenantAttachListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"FpzsMultiTenantAttachListPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u540e\u6570\u636e\u65e0\u6cd5\u67e5\u770b\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"FpzsMultiTenantAttachListPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, new ConfirmCallBackListener(DELETE_USER_INVOICE_BUTTON, (IFormPlugin)this), btnNameMaps);
        }
    }

    private boolean isPersonInvoice() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String listType = String.valueOf(customParams.get("listType"));
        return "operate_person_invoice".equals(listType);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (DELETE_USER_INVOICE_BUTTON.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(BILL_LIST_AP);
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection entity = this.getModel().getEntryEntity(BILL_LIST_AP);
            Long primaryKeyValue = (Long)((DynamicObject)entity.get(selectRows[0])).getPkValue();
            MultiTenantService service = new MultiTenantService();
            if (service.isMultiTenant()) {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                customParams.put("primaryKeyValue", primaryKeyValue);
                service.doPost("RimInvoiceListServiceOpenApiImpl", "deleteRelation", (Object)customParams);
            } else {
                InvoiceSaveService invoiceSaveService = new InvoiceSaveService();
                invoiceSaveService.deleteRelation(primaryKeyValue, Long.valueOf(RequestContext.get().getCurrUserId()), Long.valueOf(0L));
            }
            this.loadData();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"FpzsMultiTenantAttachListPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }
}

