/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.fpzs;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.QRCode;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.multitenant.model.MultiTenantConfig;
import kd.imc.rim.common.multitenant.service.AbstractFpzsPluginService;
import kd.imc.rim.common.multitenant.service.MultiTenantService;
import kd.imc.rim.common.multitenant.service.TokenService;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.PollAwsFpyService;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import org.apache.commons.lang3.StringUtils;

public class FpzsQrCodePlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log LOGGER = LogFactory.getLog(FpzsQrCodePlugin.class);

    public void registerListener(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String linkKey = null;
        String qrcodeType = null;
        String sourceType = null;
        String fpzsPageId = null;
        Long orgId = 0L;
        if (customParams != null) {
            qrcodeType = (String)customParams.get("qrcodeType");
            linkKey = (String)customParams.get("linkKey");
            sourceType = (String)customParams.get("sourceType");
            fpzsPageId = (String)customParams.get("fpzsPageId");
            orgId = BigDecimalUtil.transDecimal(customParams.get("orgId")).longValue();
            String pageId = this.getView().getPageId();
            this.getView().getParentView().getPageCache().put("qrCodePage", pageId);
        }
        Label lb = (Label)this.getView().getControl("qrtype");
        Label labelMsg = (Label)this.getView().getControl("label_msg");
        if ("cloudhub".equals(qrcodeType)) {
            Map config = ImcConfigUtil.getValue((String)"rim_fpzs");
            String apptype = "0";
            String appname = ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6", (String)"FpzsQrCodePlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            if (config != null) {
                apptype = (String)StringUtils.defaultIfEmpty((CharSequence)((CharSequence)config.get("apptype")), (CharSequence)"0");
                appname = (String)StringUtils.defaultIfEmpty((CharSequence)((CharSequence)config.get("appname")), (CharSequence)ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6", (String)"FpzsQrCodePlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            lb.setText(appname);
            labelMsg.setText(String.format(ResManager.loadKDString((String)"\u5173\u95ed\u7a97\u53e3\u540e\uff0c\u518d\u6b21\u6253\u5f00\u8bf7\u7528%1$s\u91cd\u65b0\u626b\u7801\uff01", (String)"FpzsQrCodePlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]), appname));
            this.showH5QrCode(linkKey, fpzsPageId, apptype);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"qrtype"});
            labelMsg.setText(ResManager.loadKDString((String)"\u5173\u95ed\u7a97\u53e3\u540e\uff0c\u518d\u6b21\u6253\u5f00\u8bf7\u7528\u5fae\u4fe1\u91cd\u65b0\u626b\u7801\uff01", (String)"FpzsQrCodePlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.showWxQrCode(linkKey, fpzsPageId, sourceType, orgId);
        }
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.start();
    }

    private void showH5QrCode(String linkKey, String fpzsPageId, String appType) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"imageap"});
        RequestContext request = RequestContext.get();
        String sCurrntURL = request.getClientFullContextPath();
        String token = request.getGlobalSessionId();
        String kd_cs_ticket = UrlServiceUtils.getCsrfToken((String)request.getGlobalSessionId());
        String lang = request.getLang().name();
        String eventCode = null;
        MultiTenantService multiTenantService = new MultiTenantService();
        if (multiTenantService.isMultiTenant()) {
            MultiTenantConfig config = multiTenantService.getMultiTenantConfig();
            TokenService tokenService = new TokenService();
            token = tokenService.login(config);
            kd_cs_ticket = null;
            sCurrntURL = config.getBaseUrl();
            Map param = FpzsMainService.getCustomParam((String)fpzsPageId);
            param.put("userType", "1");
            Long orgId = BigDecimalUtil.transDecimal(param.get("orgId")).longValue();
            if (orgId <= 0L) {
                orgId = request.getOrgId();
            }
            param.put("orgNumber", multiTenantService.getOrgNumber(orgId.longValue()));
            param.put("userId", multiTenantService.getUserNumber(Long.parseLong(request.getUserId())));
            param.put("pushType", "poll");
            param.put("multiTenant", request.getTenantId());
            param.put("linkKey", linkKey);
            eventCode = (String)multiTenantService.doPost("FpzsServiceOpenApiImpl", "eventCode", (Object)param);
            fpzsPageId = "";
        } else {
            Map fpzsConfig = ImcConfigUtil.getValue((String)"rim_fpzs");
            String h5baseurl = (String)fpzsConfig.get("h5baseurl");
            try {
                new URL(h5baseurl);
                sCurrntURL = h5baseurl;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            try {
                new URL(sCurrntURL);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        String from = this.getH5Url(sCurrntURL, token, kd_cs_ticket, linkKey, fpzsPageId, lang, appType, eventCode);
        QRCode qrCode = (QRCode)this.getView().getControl("qrcodeap");
        qrCode.setUrl(from);
    }

    private String getH5Url(String baserUrl, String token, String csTicket, String linkKey, String fpzsPageId, String lang, String appType, String eventCode) {
        StringBuilder sb = new StringBuilder();
        sb.append(baserUrl).append("mobile.html?form=rim_mobile_index");
        sb.append("&source=fpzs&linkKey=").append(linkKey);
        if (StringUtils.isNotEmpty((CharSequence)fpzsPageId)) {
            sb.append("&fpzsPageId=").append(fpzsPageId);
        }
        sb.append("&appType=").append(appType);
        if (StringUtils.isNotEmpty((CharSequence)csTicket)) {
            sb.append("&kd_cs_ticket=").append(csTicket);
        }
        if (StringUtils.isNotEmpty((CharSequence)eventCode)) {
            sb.append("&eventCode=").append(eventCode);
        }
        String url = sb.toString();
        LOGGER.info("showH5QrCode:{}", (Object)url);
        try {
            url = URLEncoder.encode(url, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        StringBuilder fromsb = new StringBuilder();
        fromsb.append(baserUrl).append("accessTokenLogin.do?encode=true&access_token=").append(token);
        if (StringUtils.isNotEmpty((CharSequence)csTicket)) {
            fromsb.append("&kd_cs_ticket=").append(csTicket);
        }
        fromsb.append("&redirect=").append(url);
        fromsb.append("&language=").append(lang);
        LOGGER.info("showH5QrCode:{}", (Object)fromsb.toString());
        return fromsb.toString();
    }

    private void showWxQrCode(String linkKey, String fpzsPageId, String sourceType, Long orgId) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"qrcodeap"});
        if (linkKey == null) {
            linkKey = this.getView().getParentView().getPageId();
        }
        String socketVersion = "2";
        if ("serverPolling".equals(sourceType)) {
            socketVersion = "1";
        } else {
            linkKey = MD5.md5Hex((String)linkKey);
        }
        String cangQiongUrl = CacheHelper.get((String)linkKey);
        if (StringUtils.isEmpty((CharSequence)cangQiongUrl)) {
            JSONObject fpzsAllConfig = AbstractFpzsPluginService.newInstance().getFpzsConfig(orgId);
            AwsFpyService service = AwsFpyService.newInstance();
            RequestContext request = RequestContext.get();
            if (orgId < 1L) {
                orgId = request.getOrgId();
            }
            JSONObject config = fpzsAllConfig.getJSONObject("aws_config");
            String timestamp = String.valueOf(System.currentTimeMillis());
            String sign = MD5.md5Hex((String)(config.getString("client_id") + config.getString("client_secret") + timestamp));
            JSONObject map = new JSONObject();
            map.put("tin", (Object)TenantUtils.getTaxNoByOrgId((Long)orgId));
            map.put("eid", (Object)request.getUserId());
            map.put("client_id", (Object)config.getString("client_id"));
            map.put("sign", (Object)sign);
            map.put("timestamp", (Object)timestamp);
            map.put("linkKey", (Object)linkKey);
            map.put("random", (Object)System.currentTimeMillis());
            map.put("billNumber", (Object)linkKey);
            map.put("bxd_key", (Object)linkKey);
            map.put("ticketParam", (Object)"00000");
            String url = service.getUrl("get_user_key");
            JSONObject userKeyResult = null;
            try {
                userKeyResult = service.postAppJson(url, map.toJSONString());
            }
            catch (IOException e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6userKey\u5931\u8d25:%1$s", (String)"FpzsQrCodePlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), e.getMessage()));
                return;
            }
            String requrl = service.getUrl("get_qrcode");
            StringBuilder sb = new StringBuilder();
            sb.append(requrl);
            sb.append("?sourceType=2&socketVersion=").append(socketVersion);
            sb.append("&pushData=1&linkKey=").append(linkKey);
            if (ResultContant.isSuccess((JSONObject)userKeyResult).booleanValue()) {
                String userKey = userKeyResult.getJSONObject("data").getString("userKey");
                sb.append("&userKey=").append(userKey);
                LOGGER.info("showWxQrCode:{}", (Object)sb);
                cangQiongUrl = FileUtils.downLoadAndUploadTemp((String)sb.toString(), null);
                CacheHelper.put((String)linkKey, (String)cangQiongUrl, (int)600);
                if ("serverPolling".equals(sourceType)) {
                    PollAwsFpyService pollService = new PollAwsFpyService();
                    pollService.receive(config, fpzsPageId, linkKey + "pc");
                }
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6userKey\u5931\u8d25:%1$s", (String)"FpzsQrCodePlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), userKeyResult.toJSONString()));
            }
        }
        Image image = (Image)this.getControl("imageap");
        image.setUrl(cangQiongUrl);
    }

    public void onProgress(ProgressEvent paramProgressEvent) {
        String str = this.getView().getParentView().getPageCache().get("qrCodePage");
        if (StringUtils.isEmpty((CharSequence)str)) {
            this.getView().close();
        }
    }
}

