/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.fpzs;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.imc.rim.common.constant.AttachConstant;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;

public class FpzsViewAttachPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String KEY_ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(KEY_ENTRYENTITY);
        cardEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        if ("imageIndex".equals(eventName)) {
            String urlListStr = this.getPageCache().get("urlList");
            if (StringUtils.isNotEmpty((CharSequence)eventArgs) && StringUtils.isNotEmpty((CharSequence)urlListStr)) {
                int index = 0;
                if (eventArgs.indexOf("index") > 0) {
                    JSONObject json = JSONObject.parseObject((String)eventArgs);
                    index = json.getIntValue("index");
                } else {
                    index = Integer.parseInt(eventArgs);
                }
                JSONArray attachListArray = JSONArray.parseArray((String)urlListStr);
                JSONObject attach = attachListArray.getJSONObject(index);
                this.updateAttachModel(attach, 0);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray attachArray = JSONObject.parseArray((String)SerializationUtils.toJsonString(customParams.get("attachArray")));
        JSONArray saleList = new JSONArray();
        JSONArray attachList = new JSONArray();
        if (!CollectionUtils.isEmpty((Collection)attachArray)) {
            for (int i = 0; i < attachArray.size(); ++i) {
                JSONObject attach = attachArray.getJSONObject(i);
                Long attachCategory = attach.getLong("attachCategory");
                if (AttachConstant.ATTACH_LIST_CATEGORY_ID.equals(attachCategory)) {
                    JSONObject saleListObj = this.handleAttachList(attach);
                    if (saleListObj == null) continue;
                    saleList.add((Object)saleListObj);
                    continue;
                }
                attachList.add((Object)attach);
            }
            if (saleList.size() > 0) {
                JSONObject saleListFirst = saleList.getJSONObject(0);
                int row = this.getModel().createNewEntryRow(KEY_ENTRYENTITY);
                this.updateAttachModel(saleListFirst, row);
                this.showImages(saleList, 0);
                this.getPageCache().put("urlList", saleList.toJSONString());
            }
            for (int j = 0; j < attachList.size(); ++j) {
                JSONObject attach = attachList.getJSONObject(j);
                int row = this.getModel().createNewEntryRow(KEY_ENTRYENTITY);
                this.updateAttachModel(attach, row);
            }
            if (saleList.size() == 0) {
                this.showImage(0);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        this.showImages(row);
    }

    private JSONObject handleAttachList(JSONObject attach) {
        if (attach == null) {
            return null;
        }
        String fileType = attach.getString("fileType");
        if ("2".equals(fileType)) {
            attach.put("displayFlag", (Object)"showImage");
        } else {
            attach.put("displayFlag", (Object)"showOther");
        }
        String url = attach.getString("localUrl");
        Map previewMap = UrlServiceUtils.getAttachmentPreviewUrlAndType((String)url);
        attach.putAll(previewMap);
        attach.put("rotateDeg", (Object)"");
        return attach;
    }

    private void updateAttachModel(JSONObject attach, int row) {
        Long attachCategory = attach.getLong("attachCategory");
        String fileType = attach.getString("fileType");
        this.getModel().setValue("fseq", (Object)(row + 1), row);
        String url = attach.getString("localUrl");
        this.getModel().setValue("attach_url", (Object)url, row);
        this.getModel().setValue("file_type", (Object)fileType, row);
        this.getModel().setValue("attach_category", (Object)attachCategory, row);
        this.getModel().setValue("attach_name", attach.get((Object)"attachName"), row);
        this.getModel().setValue("create_time", attach.get((Object)"createTime"), row);
        this.getModel().setValue("attach_remark", CommonUtils.getJsonValue((Map)attach, String.class, (String[])new String[]{"attachRemark", "remark"}), row);
    }

    private void showImages(JSONArray urlList, int row) {
        CustomControl customcontrol = (CustomControl)this.getControl("customcontrolap");
        JSONObject map = new JSONObject();
        map.put("pageId", (Object)this.getView().getPageId());
        map.put("list", (Object)urlList);
        map.put("flexKey", (Object)"#image_show");
        map.put("currentIndex", (Object)row);
        map.put("showBtn", (Object)(urlList.size() > 1 ? 1 : 0));
        map.put("time", (Object)System.currentTimeMillis());
        customcontrol.setData((Object)map);
    }

    private void showImages(int row) {
        String urlListStr = this.getPageCache().get("urlList");
        if (row == 0 && !StringUtils.isEmpty((CharSequence)urlListStr)) {
            JSONArray urlList = JSONArray.parseArray((String)urlListStr);
            this.showImages(urlList, row);
            JSONObject attach = urlList.getJSONObject(0);
            this.updateAttachModel(attach, 0);
        } else {
            this.showImage(row);
        }
    }

    private void showImage(int row) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, row);
        String url = entryRowEntity.getString("attach_url");
        String fileType = entryRowEntity.getString("file_type");
        HashMap urlMap = new HashMap(8);
        Map previewMap = UrlServiceUtils.getAttachmentPreviewUrlAndType((String)url);
        urlMap.putAll(previewMap);
        ArrayList urlList = new ArrayList(8);
        urlList.add(urlMap);
        CustomControl customcontrol = (CustomControl)this.getControl("customcontrolap");
        JSONObject map = new JSONObject();
        map.put("pageId", (Object)this.getView().getPageId());
        map.put("list", urlList);
        map.put("flexKey", (Object)"#image_show");
        if ("2".equalsIgnoreCase(fileType)) {
            map.put("displayFlag", (Object)"showImage");
        } else {
            map.put("displayFlag", (Object)"showOther");
        }
        map.put("showBtn", (Object)(urlList.size() > 1 ? 1 : 0));
        map.put("time", (Object)System.currentTimeMillis());
        customcontrol.setData((Object)map);
    }
}

