/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.fpzs.operate;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.imc.rim.common.invoice.collector.ScannerService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.multitenant.service.AbstractFpzsPluginService;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.formplugin.fpzs.operate.FpzsOperateService;
import org.apache.commons.lang3.StringUtils;

public class QrCodeOperateService
extends FpzsOperateService {
    public QrCodeOperateService(AbstractFormPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void operate() {
        String qrcodeType;
        String pageId = this.plugin.getView().getPageId();
        Map custparam = FpzsMainService.getCustomParam((String)pageId);
        String operateType = this.plugin.getPageCache().get("operate_type");
        String billType = (String)custparam.get("billType");
        RequestContext request = RequestContext.get();
        Long orgId = request.getOrgId();
        long org = BigDecimalUtil.transDecimal(custparam.get("orgId")).longValue();
        if (org > 0L) {
            orgId = org;
        }
        String qrType = "cloudhub";
        DynamicObject configObj = FpzsMainService.getConfigObj((String)billType, (Long)orgId);
        if (configObj != null && "2".equals(qrcodeType = configObj.getString("qrcode_type"))) {
            qrType = "weixin";
        }
        String linkKey = null;
        String sourceType = "cloudhub";
        if ("cloudhub".equals(qrType)) {
            linkKey = "fpzs" + pageId;
            this.startErpWebSocket(linkKey);
        } else {
            JSONObject socketResult = this.startAwsWebSocket(orgId);
            if (socketResult == null) {
                return;
            }
            sourceType = socketResult.getString("sourceType");
            linkKey = socketResult.getString("linkKey");
        }
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("linkKey", linkKey);
        customParams.put("sourceType", sourceType);
        customParams.put("fpzsPageId", pageId);
        customParams.put("qrcodeType", qrType);
        customParams.put("orgId", orgId);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("rim_fpzs_qrcode");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, "rim_fpzs_qrcode");
        param.setCloseCallBack(closeCallBack);
        this.plugin.getView().showForm(param);
    }

    public JSONObject startAwsWebSocket(Long orgId) {
        String type;
        JSONObject result = new JSONObject();
        String sourceType = "socket";
        String linkKey = this.plugin.getPageCache().get("linkkey");
        RequestContext request = RequestContext.get();
        JSONObject fpzsAllConfig = AbstractFpzsPluginService.newInstance().getFpzsConfig(orgId);
        JSONObject fpzsConfig = fpzsAllConfig.getJSONObject("rim_fpzs");
        if (linkKey == null) {
            linkKey = UUID.randomUUID();
            AwsFpyService service = AwsFpyService.newInstance();
            JSONObject config = fpzsAllConfig.getJSONObject("aws_config");
            if (null == config) {
                this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u914d\u7f6e\u53d1\u7968\u4e91\u63a5\u53e3\u53c2\u6570\uff0c\u8bf7\u5148\u914d\u7f6e\u53d1\u7968\u4e91\u63a5\u53e3\u53c2\u6570", (String)"QrCodeOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return null;
            }
            this.plugin.getPageCache().put("linkkey", linkKey);
            String timestamp = String.valueOf(System.currentTimeMillis());
            String sign = MD5.md5Hex((String)(config.getString("client_id") + config.getString("client_secret") + timestamp));
            CustomControl control = (CustomControl)this.plugin.getControl("custom_socket");
            JSONObject map = new JSONObject();
            String env = this.getEnvByUrl(service.getBaseUrl());
            if (env != null) {
                map.put("env", (Object)env);
            } else {
                map.put("env", (Object)"test");
            }
            map.put("sourceType", (Object)"socket");
            if (fpzsConfig != null) {
                String type2;
                env = fpzsConfig.getString("env");
                if (StringUtils.isNotEmpty((CharSequence)env)) {
                    map.put("env", (Object)env);
                }
                if (StringUtils.isNotEmpty((CharSequence)(type2 = fpzsConfig.getString("type")))) {
                    sourceType = type2;
                    map.put("sourceType", (Object)type2);
                }
                map.put("socketUrl", (Object)StringUtils.trimToEmpty((String)fpzsConfig.getString("url")));
                map.put("apiUrl", (Object)StringUtils.trimToEmpty((String)fpzsConfig.getString("api_url")));
            }
            if ("serverPolling".equals(sourceType)) {
                this.startErpWebSocket(linkKey + "pc");
            } else {
                map.put("operate", (Object)"open");
                map.put("tin", (Object)TenantUtils.getTaxNoByOrgId((Long)orgId));
                map.put("eid", (Object)Long.parseLong(request.getUserId()));
                map.put("qrcodeType", (Object)"weixin");
                map.put("client_id", (Object)config.getString("client_id"));
                map.put("sign", (Object)sign);
                map.put("timestamp", (Object)timestamp);
                map.put("linkKey", (Object)linkKey);
                control.setData((Object)map);
            }
        } else if (fpzsConfig != null && StringUtils.isNotEmpty((CharSequence)(type = fpzsConfig.getString("type")))) {
            sourceType = type;
        }
        result.put("sourceType", (Object)sourceType);
        result.put("linkKey", (Object)linkKey);
        return result;
    }

    public String getEnvByUrl(String url) {
        if (url != null) {
            if (url.indexOf("api.piaozone.com") > 0) {
                return "prod";
            }
            if (url.indexOf("api-dev.piaozone.com") > 0 || url.indexOf("api-sit.piaozone.com") > 0) {
                return "test";
            }
        }
        return null;
    }

    private void startErpWebSocket(String linkKey) {
        IPageCache pagetCaceh = this.plugin.getPageCache();
        String flag = pagetCaceh.get(linkKey);
        if (flag == null) {
            CustomControl control = (CustomControl)this.plugin.getControl("custom_socket");
            ScannerService.startWebScoket((CustomControl)control, (String)linkKey);
            pagetCaceh.put(linkKey, "1");
        }
    }
}

