/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.h5;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.imc.rim.common.h5.H5PluginService;
import kd.imc.rim.common.invoice.query.AttachSaveService;

public class H5AttachOperatePlugin
extends AbstractMobFormPlugin {
    private static final String EDIT_BUTTON = "edit";
    private static final String DELETE_BUTTON = "delete";
    private static final String CANCEL_BUTTON = "cancel";

    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{EDIT_BUTTON, DELETE_BUTTON, CANCEL_BUTTON});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        Long attachId = (Long)parentCustomParams.get("attachId");
        int rowIndex = (Integer)parentCustomParams.get("rowIndex");
        Control control = (Control)evt.getSource();
        if (EDIT_BUTTON.equals(control.getKey())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
            this.showEditAttach(attachId, rowIndex);
        }
        if (DELETE_BUTTON.equals(control.getKey())) {
            MobileFormShowParameter parameter = new MobileFormShowParameter();
            parameter.setFormId("rim_h5_common_confirm");
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "rim_h5_common_confirm");
            parameter.setCloseCallBack(callBack);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> myOwnOpenStyle = new HashMap<String, String>(1);
            myOwnOpenStyle.put("position", "center");
            parameter.getOpenStyle().setCustParam(myOwnOpenStyle);
            HashMap<String, String> customerParam = new HashMap<String, String>(1);
            customerParam.put("msg", ResManager.loadKDString((String)"\u5220\u9664\u540e\u6570\u636e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"H5AttachOperatePlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            parameter.setCustomParams(customerParam);
            this.getView().showForm((FormShowParameter)parameter);
        }
        if (CANCEL_BUTTON.equals(control.getKey())) {
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            if ("delCallBack".equals(callBackId)) {
                if (StringUtils.isBlank((CharSequence)messageBoxClosedEvent.getCustomVaule())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9700\u8981\u5220\u9664\u7684\u9644\u4ef6\u4fe1\u606f", (String)"H5AttachOperatePlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return;
                }
                JSONObject customParam = JSONObject.parseObject((String)messageBoxClosedEvent.getCustomVaule());
                Long attachId = customParam.getLong("attachId");
                int rowIndex = customParam.getInteger("rowIndex");
                this.deleteSingleAttach(attachId);
                JSONObject returnData = new JSONObject();
                returnData.put("attachId", (Object)attachId);
                returnData.put("rowIndex", (Object)rowIndex);
                returnData.put("type", (Object)DELETE_BUTTON);
                this.getView().returnDataToParent((Object)returnData);
                this.getView().close();
            }
        } else if (MessageBoxResult.No.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("rim_h5_common_confirm".equals(closedCallBackEvent.getActionId())) {
            String returnData = (String)closedCallBackEvent.getReturnData();
            if ("left_button".equals(returnData)) {
                this.getView().close();
            }
            if ("right_button".equals(returnData)) {
                Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
                Long attachId = (Long)parentCustomParams.get("attachId");
                int rowIndex = (Integer)parentCustomParams.get("rowIndex");
                this.deleteSingleAttach(attachId);
                JSONObject backData = new JSONObject();
                backData.put("attachId", (Object)attachId);
                backData.put("rowIndex", (Object)rowIndex);
                backData.put("type", (Object)DELETE_BUTTON);
                this.getView().returnDataToParent((Object)backData);
                this.getView().close();
            }
        }
    }

    private void showEditAttach(Long attachId, int rowIndex) {
        MobileFormShowParameter showAttachEditForm = new MobileFormShowParameter();
        showAttachEditForm.setFormId("rim_h5_attach_edit");
        showAttachEditForm.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> myOwnOpenStyle = new HashMap<String, String>(1);
        myOwnOpenStyle.put("position", "center");
        showAttachEditForm.getOpenStyle().setCustParam(myOwnOpenStyle);
        HashMap<String, Number> customerParam = new HashMap<String, Number>(3);
        customerParam.put("id", attachId);
        customerParam.put("rowIndex", rowIndex);
        H5PluginService.setCommonParam(customerParam, (Map)this.getView().getFormShowParameter().getCustomParams());
        showAttachEditForm.setCustomParams(customerParam);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_h5_attach_edit");
        showAttachEditForm.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showAttachEditForm);
    }

    private Boolean deleteSingleAttach(Long attachId) {
        if (StringUtils.isBlank((Object)attachId)) {
            return Boolean.FALSE;
        }
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        String serialNo = (String)parentCustomParams.get("serialNo");
        AttachSaveService.deleteAttach((Long)attachId, (String)serialNo);
        return Boolean.TRUE;
    }

    private void initData() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
    }
}

