/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.h5;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.h5.H5PluginService;
import kd.imc.rim.common.invoice.file.InvoiceAttachCaremaService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.formplugin.fpzs.FpzsAttachService;
import org.apache.commons.lang.StringUtils;

public class H5AttachUploadPlugin
extends AbstractMobFormPlugin
implements UploadListener,
CellClickListener {
    private static Log logger = LogFactory.getLog(H5AttachUploadPlugin.class);
    private static final String[] ALLOW_FILE_TYPE = new String[]{"png", "bmp", "jpg", "jpeg", "webp", "pdf", "doc", "docx", "xls", "xlsx", "pptx", "txt"};
    private static final String ATTACH_ENTITY = "attach_entity";

    public void afterCreateNewData(EventObject e) {
        this.getModel().deleteEntryData(ATTACH_ENTITY);
        InvoiceAttachCaremaService attachService = new InvoiceAttachCaremaService();
        CustomControl customcontrol = (CustomControl)this.getControl("customcontrolap");
        attachService.initH5AttachUpload(Boolean.TRUE, customcontrol, "add_continue");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null) {
            logger.info("\u521d\u59cb\u5316\u9644\u4ef6\u4e0a\u4f20\u5217\u8868\uff1a" + customParams);
            if (customParams.get("fileArray") != null) {
                JSONArray fileArray = JSON.parseArray((String)customParams.get("fileArray").toString());
                this.recognitionAttach(fileArray);
            }
            customParams.remove("parentPageId");
            customParams.remove("fileArray");
        }
        this.updateAttachNum();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String isClicked = CacheHelper.get((String)("moreButton" + this.getView().getPageId()));
        if (!"1".equals(isClicked) && "more".equals(control.getKey())) {
            CacheHelper.put((String)("moreButton" + this.getView().getPageId()), (String)"1", (int)1);
            MobileFormShowParameter moreForm = new MobileFormShowParameter();
            moreForm.setFormId("rim_h5_attach_operate");
            moreForm.getOpenStyle().setShowType(ShowType.Modal);
            Object idObj = this.getModel().getValue("attachid");
            if (idObj == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u70b9\u51fb\u9644\u4ef6\u7684id\u4e3a\u7a7a", (String)"H5AttachUploadPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            String attachId = idObj.toString();
            if (StringUtils.isEmpty((String)attachId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u70b9\u51fb\u9644\u4ef6\u7684id\u4e3a\u7a7a", (String)"H5AttachUploadPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            Long id = Long.parseLong(attachId);
            HashMap<String, Number> customerParam = new HashMap<String, Number>(3);
            customerParam.put("attachId", id);
            customerParam.put("rowIndex", control.getModel().getEntryCurrentRowIndex(ATTACH_ENTITY));
            H5PluginService.setCommonParam(customerParam, (Map)this.getView().getFormShowParameter().getCustomParams());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_h5_attach_operate");
            moreForm.setCloseCallBack(closeCallBack);
            moreForm.setCustomParams(customerParam);
            this.getView().showForm((FormShowParameter)moreForm);
        }
        if ("submit_button".equals(control.getKey())) {
            int count = this.getModel().getEntryRowCount(ATTACH_ENTITY);
            ArrayList<Long> attachIds = new ArrayList<Long>(count);
            for (int i = 0; i < count; ++i) {
                String attachid = (String)this.getModel().getValue("attachid", i);
                if (!StringUtils.isNotEmpty((String)attachid)) continue;
                attachIds.add(Long.parseLong(attachid));
            }
            this.getView().returnDataToParent(attachIds);
            this.getView().close();
        }
    }

    public void registerListener(EventObject e) {
        CardEntry cardEntry = (CardEntry)this.getControl(ATTACH_ENTITY);
        cardEntry.addCellClickListener((CellClickListener)this);
        Button moreButton = (Button)this.getControl("more");
        moreButton.addClickListener((ClickListener)this);
        Button submitButton = (Button)this.getControl("submit_button");
        submitButton.addClickListener((ClickListener)this);
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String isClicked = CacheHelper.get((String)("cellClick" + this.getView().getPageId()));
        if (!"1".equals(isClicked)) {
            CacheHelper.put((String)("cellClick" + this.getView().getPageId()), (String)"1", (int)1);
            Long id = Long.parseLong(this.getModel().getValue("attachid").toString());
            this.showDetail(id);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventArgs = e.getEventArgs();
        if ("cameraUploadStart".equals(e.getEventName())) {
            logger.info("H5\u4e0a\u4f20\u9644\u4ef6\u4fe1\u606f\uff1acameraUploadStart" + eventArgs);
            this.setLoading(true);
        } else if ("cameraUpload".equals(e.getEventName())) {
            logger.info("H5\u4e0a\u4f20\u9644\u4ef6\u4fe1\u606f\uff1acameraUpload" + eventArgs);
            JSONObject uploadData = JSON.parseObject((String)eventArgs);
            JSONArray fileArray = uploadData.getJSONArray("fileArray");
            this.recognitionAttach(fileArray);
            this.updateAttachNum();
            this.setLoading(false);
        }
    }

    private void recognitionAttach(JSONArray fileArray) {
        for (int i = 0; i < fileArray.size(); ++i) {
            JSONObject fileJson = fileArray.getJSONObject(i);
            if ("success".equals(fileJson.getString("status"))) {
                fileJson = this.dealHttpUrl(fileJson);
                String urlPath = fileJson.getString("url");
                logger.info("H5\u9644\u4ef6\u8bc6\u522b\u6210\u529f\uff0c\u9644\u4ef6\u8def\u5f84\uff1a" + urlPath);
                String name = fileJson.getString("name");
                name = FileUtils.truncateFileName((String)name, (int)50);
                DynamicObject dynamicObject = FpzsAttachService.saveAttach(name, urlPath, (AbstractFormPlugin)this);
                if (dynamicObject == null) continue;
                int rowIndex = this.getModel().createNewEntryRow(ATTACH_ENTITY);
                this.getModel().setValue("attachid", (Object)dynamicObject.getLong("id"), rowIndex);
                this.getModel().setValue("attach_url", (Object)dynamicObject.getString("attach_url"), rowIndex);
                this.getModel().setValue("attach_name", (Object)dynamicObject.getString("attach_name"), rowIndex);
                this.getModel().setValue("create_time", (Object)DateUtils.format((Date)dynamicObject.getDate("create_time"), (String)"yyyy-MM-dd HH:mm:ss"), rowIndex);
                this.getModel().setValue("remark", (Object)dynamicObject.getString("remark"), rowIndex);
                String iconImage = FpzsAttachService.getPreviewIconFullUrl(dynamicObject);
                if (StringUtils.isBlank((String)iconImage)) continue;
                this.getModel().setValue("image_url", (Object)iconImage, rowIndex);
                continue;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b", (String)"H5AttachUploadPlugin_22", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }

    public void remove(UploadEvent evt) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        JSONObject returnData = (JSONObject)closedCallBackEvent.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        if ("rim_h5_attach_operate".equals(actionId) || "rim_h5_attach_detail".equals(actionId)) {
            String operateType = returnData.getString("type");
            if (StringUtils.isEmpty((String)operateType)) {
                return;
            }
            int rowIndex = returnData.getInteger("rowIndex");
            switch (operateType) {
                case "delete": {
                    this.getView().getModel().deleteEntryRow(ATTACH_ENTITY, rowIndex);
                    this.updateAttachNum();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u5220\u9664\u6210\u529f", (String)"H5AttachUploadPlugin_23", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "edit": {
                    String attachName = returnData.getString("attach_name");
                    String remark = returnData.getString("remark");
                    this.getView().getModel().setValue("attach_name", (Object)attachName, rowIndex);
                    this.getView().getModel().setValue("remark", (Object)remark, rowIndex);
                    break;
                }
                case "cancel": {
                    break;
                }
                default: {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u9644\u4ef6\u64cd\u4f5c\u7c7b\u578b", (String)"H5AttachUploadPlugin_24", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void updateAttachNum() {
        int attachNum = this.getModel().getEntryRowCount(ATTACH_ENTITY);
        this.getModel().setValue("attach_num", (Object)String.format(ResManager.loadKDString((String)"\u5df2\u62cd\u6444%1$s\u5f20\u9644\u4ef6", (String)"H5AttachUploadPlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]), attachNum));
        if (attachNum > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"data_empty"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"data_empty"});
        }
    }

    private void showDetail(Long id) {
        MobileFormShowParameter showAttachEditForm = new MobileFormShowParameter();
        showAttachEditForm.setFormId("rim_h5_attach_detail");
        showAttachEditForm.getOpenStyle().setShowType(ShowType.Floating);
        JSONObject customerParam = new JSONObject();
        Map params = this.getView().getFormShowParameter().getCustomParams();
        JSONObject invoiceInfo = (JSONObject)params.get("invoice_info");
        if (invoiceInfo != null) {
            String serialNo = invoiceInfo.getString("serialNo");
            customerParam.put("serialNo", (Object)serialNo);
        }
        customerParam.put("id", (Object)id);
        customerParam.put("rowIndex", (Object)this.getModel().getEntryCurrentRowIndex(ATTACH_ENTITY));
        H5PluginService.setCommonParam((Map)customerParam, (Map)this.getView().getFormShowParameter().getCustomParams());
        showAttachEditForm.setCustomParams((Map)customerParam);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_h5_attach_detail");
        showAttachEditForm.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showAttachEditForm);
    }

    private void setLoading(boolean visible) {
        CustomControl customControlAp = (CustomControl)this.getControl("dialog_customcontrolap");
        JSONObject cameraUploadParam = new JSONObject();
        cameraUploadParam.put("divId", (Object)"flexpanelap6");
        cameraUploadParam.put("operator", (Object)visible);
        customControlAp.setData((Object)cameraUploadParam);
    }

    private JSONObject dealHttpUrl(JSONObject fileJson) {
        String url;
        String fileUrl;
        if (fileJson != null && !StringUtils.isEmpty((String)(fileUrl = fileJson.getString("url"))) && fileUrl.startsWith("http") && !StringUtils.isEmpty((String)(url = FileUtils.downLoadAndUpload((String)fileUrl, null, (boolean)false)))) {
            fileJson.put("url", (Object)url);
        }
        return fileJson;
    }
}

