/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.h5;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.invoice.recognitionnew.task.SnapshotService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.file.utils.FileConvertUtils;

public class H5CoverDetailPlugin
extends AbstractMobFormPlugin {
    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    private void initData() {
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        long id = BigDecimalUtil.transDecimal(parentCustomParams.get("coverId")).longValue();
        String coverNo = (String)parentCustomParams.get("coverNo");
        this.getModel().setValue("coverno", (Object)coverNo);
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_cover", (String)"id,cover_no,cover_type,resource,cover_url,snapshot_url,create_time", (QFilter[])new QFilter[]{idFilter});
        if (collection == null || collection.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e2d\u627e\u4e0d\u5230\u8be5\u5c01\u9762\u4fe1\u606f", (String)"H5CoverDetailPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String snapshotUrl = ((DynamicObject)collection.get(0)).getString("snapshot_url");
        String coverType = ((DynamicObject)collection.get(0)).getString("cover_type");
        String pdf = ((DynamicObject)collection.get(0)).getString("cover_url");
        if (StringUtils.isEmpty((CharSequence)snapshotUrl) && "1".equals(coverType)) {
            byte[] filebyte = FileUtils.getAttachmentByte((String)pdf);
            String fileHash = FileConvertUtils.getSHA256((byte[])filebyte);
            SnapshotService snapshotService = new SnapshotService();
            JSONObject result = snapshotService.createSnapshot(filebyte, fileHash, pdf, coverNo + ".jpg", "pdf", false);
            snapshotUrl = result.getString("snapshotUrl");
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"rim_cover");
            obj.set("snapshot_url", (Object)snapshotUrl);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
        this.showInvoiceImage(snapshotUrl, pdf);
    }

    private void showInvoiceImage(String snapshotUrl, String pdfUrl) {
        ArrayList urlList = new ArrayList();
        HashMap<String, Object> urlMap = new HashMap<String, Object>();
        String imageUrl = UrlServiceUtils.getAttachmentPreviewUrl((String)snapshotUrl);
        pdfUrl = UrlServiceUtils.getAttachmentPreviewUrl((String)pdfUrl);
        JSONObject map = new JSONObject();
        urlMap.put("snapshotUrl", imageUrl);
        urlMap.put("localUrl", pdfUrl);
        urlMap.put("rotationAngle", 0);
        if (StringUtils.isEmpty((CharSequence)imageUrl)) {
            urlMap.put("fileType", "pdf");
            map.put("displayFlag", (Object)"showOther");
            urlMap.put("snapshotUrl", pdfUrl);
        } else {
            urlMap.put("fileType", "jpg");
            map.put("displayFlag", (Object)"cuteImage");
        }
        urlList.add(urlMap);
        CustomControl customcontrol = (CustomControl)this.getControl("viewinvoice_custom");
        map.put("pageId", (Object)this.getView().getPageId());
        map.put("list", urlList);
        map.put("flexKey", (Object)"#invoice_attach_show");
        map.put("displayFlag", (Object)"cuteImage");
        map.put("time", (Object)System.currentTimeMillis());
        customcontrol.setData((Object)map);
    }
}

