/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.h5;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.h5.H5PluginService;
import kd.imc.rim.common.invoice.collector.ScannerService;
import kd.imc.rim.common.invoice.file.InvoiceAttachCaremaService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.recognition.impl.RecognitionCheckTask;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.invoice.verify.dto.VerifyResultDto;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.MobileIndexMinUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.formplugin.mobile.home.operate.AbstractOperateService;

public class H5InvoiceUploadPlugin
extends AbstractFormPlugin
implements UploadListener,
CellClickListener {
    private static Log logger = LogFactory.getLog(H5InvoiceUploadPlugin.class);
    private Map<String, String> traceMap;
    private static final String INVOICE_ENTITY = "invoice_entity";

    public void registerListener(EventObject e) {
        CardEntry cardEntry = (CardEntry)this.getControl(INVOICE_ENTITY);
        cardEntry.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{"submit_button", "operation"});
    }

    public void afterCreateNewData(EventObject e) {
        InvoiceAttachCaremaService attachService = new InvoiceAttachCaremaService();
        CustomControl customcontrol = (CustomControl)this.getControl("customcontrolap");
        attachService.initH5InvoiceUpload(Boolean.FALSE, customcontrol, "add_continue");
        CustomControl customInterval = (CustomControl)this.getControl("custom_interval");
        ScannerService.startInterval((CustomControl)customInterval);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null) {
            logger.info("\u521d\u59cb\u5316\u53d1\u7968\u8bc6\u522b\u5217\u8868\uff1a" + customParams);
            JSONArray fileArray = new JSONArray();
            if (customParams.get("fileArray") != null) {
                fileArray = JSON.parseArray((String)customParams.get("fileArray").toString());
            }
            if (customParams.get("resource") != null) {
                JSONObject businessParam = new JSONObject(customParams);
                businessParam.put("collect_type", (Object)CollectTypeEnum.H5_UPLOAD.getCode());
                logger.info("parentBusinessParam:" + businessParam);
                this.getView().getPageCache().put("fpzs_param_cache", businessParam.toJSONString());
            }
            this.recognitionAndCheck(fileArray, this.getBusinessParam());
        }
    }

    private JSONObject getBusinessParam() {
        JSONObject businessParam = new JSONObject();
        if (this.getPageCache().get("fpzs_param_cache") != null) {
            businessParam = JSON.parseObject((String)this.getPageCache().get("fpzs_param_cache"));
        } else {
            FpzsMainService.cacheCustomParam((AbstractFormPlugin)this);
            businessParam = JSON.parseObject((String)this.getPageCache().get("fpzs_param_cache"));
            businessParam.put("collect_type", (Object)CollectTypeEnum.H5_UPLOAD.getCode());
        }
        String sourceSys = businessParam.getString("sourceSys");
        if (!StringUtils.isEmpty((CharSequence)sourceSys)) {
            businessParam.put("resource", (Object)sourceSys);
        }
        logger.info("businessParam:" + businessParam);
        return businessParam;
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "submit_button": {
                this.submit();
                return;
            }
            case "operation": {
                CardEntry cardEntry = (CardEntry)this.getView().getControl(INVOICE_ENTITY);
                int row = cardEntry.getSelectRows()[0];
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(INVOICE_ENTITY, row);
                Object invoice_data = entryRowEntity.get("invoice_data");
                if (invoice_data != null) {
                    JSONArray invoiceArray = JSON.parseArray((String)invoice_data.toString());
                    this.showOperateView(invoiceArray, row);
                }
                return;
            }
        }
    }

    public void cellClick(CellClickEvent arg0) {
        String invoiceStr;
        String failStr;
        String key;
        int row = arg0.getRow();
        CardEntry cardEntry = (CardEntry)arg0.getSource();
        IDataModel model = cardEntry.getModel();
        DynamicObject entryRowEntity = model.getEntryRowEntity(key = cardEntry.getKey(), row);
        if (ObjectUtils.isEmpty((Object)entryRowEntity)) {
            this.getView().showErrMessage(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6570\u636ekey:%1$s\uff0c\u884c\u6570\uff1a%2$s", (String)"H5InvoiceUploadPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), key, row), "");
            return;
        }
        Object invoice_data = entryRowEntity.get("invoice_data");
        Object fail_description = entryRowEntity.get("fail_description");
        if (fail_description != null && StringUtils.isNotEmpty((CharSequence)(failStr = fail_description.toString()))) {
            this.getView().showErrMessage(failStr, ResManager.loadKDString((String)"\u8bc6\u522b\u5931\u8d25", (String)"H5InvoiceUploadPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (invoice_data != null && StringUtils.isNotEmpty((CharSequence)(invoiceStr = invoice_data.toString()))) {
            JSONArray invoiceArray = JSON.parseArray((String)invoiceStr);
            this.showInvoiceUpdateView(invoiceArray, row);
            return;
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            if ("h5_operate".equals(closedCallBackEvent.getActionId())) {
                Map callBackData = (Map)returnData;
                if (callBackData.get("row") != null && callBackData.get("operate") != null) {
                    String operate = callBackData.get("operate").toString();
                    int row = Integer.parseInt(callBackData.get("row").toString());
                    if ("del".equals(operate)) {
                        this.getModel().deleteEntryRow(INVOICE_ENTITY, row);
                        if (null != this.getView().getPageCache().get("invoiceArrayCache")) {
                            JSONArray invoiceArrayCache = JSON.parseArray((String)this.getView().getPageCache().get("invoiceArrayCache"));
                            if (invoiceArrayCache.getJSONArray(row) != null) {
                                JSONObject rowInfo = invoiceArrayCache.getJSONArray(row).getJSONObject(0);
                                String serialNo = rowInfo.getString("serialNo");
                                JSONObject data = FpzsMainService.getInvoiceDataCache((String)this.getView().getPageId());
                                data.remove((Object)serialNo);
                                FpzsMainService.setInvoiceDataCache((String)this.getView().getPageId(), (String)(data + ""));
                            }
                            invoiceArrayCache.remove(row);
                            this.getView().getPageCache().put("invoiceArrayCache", invoiceArrayCache.toJSONString());
                        }
                        this.refreshCount();
                    }
                }
            } else if ("h5_inv_update".equals(closedCallBackEvent.getActionId())) {
                Map callBackData = (Map)returnData;
                if (callBackData.get("row") != null && callBackData.get("invoices") != null) {
                    int row = Integer.parseInt(callBackData.get("row").toString());
                    JSONArray invoices = JSON.parseArray((String)callBackData.get("invoices").toString());
                    if (invoices.size() == 0) {
                        this.getModel().deleteEntryRow(INVOICE_ENTITY, row);
                        if (null != this.getView().getPageCache().get("invoiceArrayCache")) {
                            JSONArray invoiceArrayCache = JSON.parseArray((String)this.getView().getPageCache().get("invoiceArrayCache"));
                            JSONObject rowInfo = invoiceArrayCache.getJSONArray(row).getJSONObject(0);
                            String serialNo = rowInfo.getString("serialNo");
                            invoiceArrayCache.remove(row);
                            this.getView().getPageCache().put("invoiceArrayCache", invoiceArrayCache.toJSONString());
                            JSONObject data = FpzsMainService.getInvoiceDataCache((String)this.getView().getPageId());
                            data.remove((Object)serialNo);
                            FpzsMainService.setInvoiceDataCache((String)this.getView().getPageId(), (String)(data + ""));
                        }
                        this.refreshCount();
                    }
                }
            } else if ("import".equals(returnData) || "cancel".equals(returnData)) {
                FpzsMainService.deleteListCache((String)this.getView().getPageId());
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventArgs = e.getEventArgs();
        String eventName = e.getEventName();
        if ("cameraUploadStart".equals(eventName)) {
            this.setLoading(true);
        } else if ("cameraUpload".equals(eventName)) {
            logger.info("H5\u4e0a\u4f20\u6570\u636e\uff1a" + eventArgs);
            JSONObject uploadData = JSON.parseObject((String)eventArgs);
            JSONArray fileArray = uploadData.getJSONArray("fileArray");
            this.recognitionAndCheck(fileArray, this.getBusinessParam());
        } else if ("interval".equals(eventName)) {
            String dialogClosed = this.getView().getPageCache().get("dialogClosed");
            if (!StringUtils.isEmpty((CharSequence)dialogClosed) && "1".equals(dialogClosed)) {
                this.uploadProcess("dialog");
            } else {
                String notifyDataStr = this.getView().getPageCache().get("notifyData");
                this.getView().getPageCache().remove("notifyData");
                if (StringUtils.isNotEmpty((CharSequence)notifyDataStr)) {
                    JSONObject notifyData = JSON.parseObject((String)notifyDataStr);
                    int row = notifyData.getIntValue("row");
                    JSONArray invoiceArray = notifyData.getJSONArray("invoiceArray");
                    if (invoiceArray.size() == 0) {
                        this.getModel().deleteEntryRow(INVOICE_ENTITY, row);
                        if (null != this.getView().getPageCache().get("invoiceArrayCache")) {
                            JSONArray invoiceArrayCache = JSON.parseArray((String)this.getView().getPageCache().get("invoiceArrayCache"));
                            invoiceArrayCache.remove(row);
                            this.getView().getPageCache().put("invoiceArrayCache", invoiceArrayCache.toJSONString());
                            FpzsMainService.setInvoiceDataCache((String)this.getView().getPageId(), (String)invoiceArrayCache.toJSONString());
                        }
                    } else {
                        this.freshCardInvoice(invoiceArray, row, null, null);
                    }
                    this.refreshCount();
                }
            }
        }
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadProcess(String type) {
        String pageId = this.getView().getPageId();
        logger.info("mobileUploadProcess-{}-{} coming", (Object)pageId, (Object)type);
        try (DLock lock = DLock.create((String)("mobileUploadProcess" + pageId), (String)ResManager.loadKDString((String)"\u5237\u65b0\u5361\u7247\u9501", (String)"H5InvoiceUploadPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));){
            int times = 0;
            while (times < 30) {
                ++times;
                if (!lock.tryLock(500L)) continue;
                times = 100;
                JSONObject result = RecognitionCheckTask.queryCacheFile((String)pageId);
                logger.info("mobileUploadProcess-{}:{}", (Object)pageId, (Object)result);
                try {
                    Set urlSet;
                    if (result == null || (urlSet = result.keySet()) == null) continue;
                    Iterator it = urlSet.iterator();
                    int waiting = 0;
                    int fail = 0;
                    while (it.hasNext()) {
                        String url = (String)it.next();
                        String status = result.getString(url);
                        if ("waiting".equals(status)) {
                            ++waiting;
                            continue;
                        }
                        if (!"fail".equals(status)) continue;
                        ++fail;
                    }
                    int total = result.size();
                    logger.info("mobileUploadProcess-{} waiting:{},fail:{},total:{}", new Object[]{pageId, waiting, fail, total});
                    if ("dialog".equals(type) && (total == 0 || waiting == 0)) {
                        if (total > 0) {
                            RecognitionCheckTask.clearCacheFile((String)pageId);
                        }
                        if (fail > 0) {
                            Set urlSet2 = result.keySet();
                            Iterator it2 = urlSet2.iterator();
                            JSONArray retryArray = new JSONArray();
                            while (it2.hasNext()) {
                                String url = (String)it2.next();
                                String status = result.getString(url);
                                if (!"fail".equals(status)) continue;
                                JSONObject retry = new JSONObject();
                                retry.put("fileUrl", (Object)url);
                                retry.put("fileName", (Object)url.substring(url.lastIndexOf(47) + 1, url.length()));
                                JSONObject cause = RecognitionCheckTask.queryCacheCause((String)pageId);
                                if (cause != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cause.getString(url))) {
                                    retry.put("failDescription", (Object)cause.getString(url));
                                } else {
                                    retry.put("failDescription", (Object)ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"H5InvoiceUploadPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                                }
                                retryArray.add((Object)retry);
                            }
                        }
                        this.setLoading(false);
                        this.getView().getPageCache().remove("dialogClosed");
                        String repeatFlag = this.getView().getPageId() + "scannerProcessRepeat";
                        String scannerProcessRepeat = CacheHelper.get((String)repeatFlag);
                        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)scannerProcessRepeat) && "true".equals(scannerProcessRepeat)) {
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u7968\u5df2\u5b58\u5728\u5217\u8868", (String)"H5InvoiceUploadPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                            CacheHelper.remove((String)repeatFlag);
                        }
                        if (total > 0 && fail > 0) {
                            String cacheKey = "scaner_cause_" + pageId;
                            String cacheCause = CacheHelper.get((String)cacheKey);
                            if (!StringUtils.isEmpty((CharSequence)cacheCause)) {
                                JSONObject cacheCauseObj = JSONObject.parseObject((String)cacheCause);
                                if (urlSet != null && urlSet.size() > 0) {
                                    for (String url : urlSet) {
                                        String cause = cacheCauseObj.getString(url);
                                        this.updateErrorCardView(url, cause);
                                    }
                                }
                            }
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0a\u4f20%1$s\u4e2a\u6587\u4ef6\uff0c\u5904\u7406\u5931\u8d25%2$s\u4e2a", (String)"H5InvoiceUploadPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), total, fail));
                        } else if (total > 0) {
                            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u4e0a\u4f20%1$s\u4e2a\u6587\u4ef6\uff0c\u5904\u7406\u6210\u529f%2$s\u4e2a\uff0c\u9500\u8d27\u6e05\u5355\u8bf7\u5148\u4e0a\u4f20\u9500\u8d27\u6e05\u5355\u5bf9\u5e94\u7684\u53d1\u7968", (String)"H5InvoiceUploadPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), total, total), Integer.valueOf(2000));
                        }
                    } else {
                        this.setLoading(true);
                        this.getView().getPageCache().put("dialogClosed", "1");
                    }
                    this.updateCardView();
                    this.refreshCount();
                }
                finally {
                    String failResultDataStr = CacheHelper.get((String)this.getView().getPageId().concat("failResult"));
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)failResultDataStr)) {
                        FormShowParameter failedListForm = new FormShowParameter();
                        failedListForm.setFormId("rim_inv_import_fail");
                        failedListForm.setCustomParam("invoiceFailedList", (Object)failResultDataStr);
                        failedListForm.getOpenStyle().setShowType(ShowType.Modal);
                        this.getView().showForm(failedListForm);
                        CacheHelper.remove((String)this.getView().getPageId().concat("failResult"));
                    }
                    lock.unlock();
                }
            }
        }
    }

    private void updateErrorCardView(String urlPath, String failDesc) {
        int fileNameIndex = urlPath.lastIndexOf(47) + 1;
        String fileName = urlPath.substring(fileNameIndex);
        int rowIndex = this.getModel().createNewEntryRow(INVOICE_ENTITY);
        this.getModel().setValue("invoice_name", (Object)fileName, rowIndex);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(INVOICE_ENTITY);
        cardEntry.setChildVisible(false, rowIndex, new String[]{"cardentryflexpanelap3"});
        cardEntry.setChildVisible(false, rowIndex, new String[]{"red_toast"});
        cardEntry.setChildVisible(false, rowIndex, new String[]{"yellow_toast"});
        cardEntry.setChildVisible(false, rowIndex, new String[]{"cardentryflex_success"});
        this.getModel().setValue("fail_description", (Object)failDesc, rowIndex);
        String baseUrl = H5PluginService.getBaseUrl((IFormView)this.getView());
        String url = UrlServiceUtils.getDownloadUrl((String)urlPath, (String)baseUrl);
        this.setImageAp(rowIndex, url, fileName);
        JSONArray invoiceArrayCache = null;
        String invoiceCache = this.getView().getPageCache().get("invoiceArrayCache");
        invoiceArrayCache = null != invoiceCache ? JSON.parseArray((String)invoiceCache) : new JSONArray();
        JSONArray invoiceData = new JSONArray();
        JSONObject failData = new JSONObject();
        failData.put("failDescription", (Object)failDesc);
        invoiceData.add((Object)failData);
        invoiceArrayCache.set(rowIndex, (Object)invoiceData);
        this.getView().getPageCache().put("invoiceArrayCache", invoiceArrayCache.toJSONString());
    }

    private void updateCardView() {
        JSONObject data = FpzsMainService.getInvoiceDataCache((String)this.getView().getPageId());
        JSONArray invoiceArrayCache = JSON.parseArray((String)this.getView().getPageCache().get("invoiceArrayCache"));
        if (data != null && data.size() > 0) {
            logger.info("\u79fb\u52a8\u7aef\u8bc6\u522b\u7f13\u5b58\u6570\u636e{}", (Object)data);
            ArrayList<String> listedSerialNos = new ArrayList<String>(8);
            if (invoiceArrayCache != null && invoiceArrayCache.size() > 0) {
                for (int i = 0; i < invoiceArrayCache.size(); ++i) {
                    JSONArray invoiceArray = invoiceArrayCache.getJSONArray(i);
                    if (invoiceArray == null || invoiceArray.size() <= 0) continue;
                    JSONObject invoiceCache = invoiceArray.getJSONObject(0);
                    listedSerialNos.add(invoiceCache.getString("serialNo"));
                }
            }
            for (Map.Entry entry : data.entrySet()) {
                String serialNo = (String)entry.getKey();
                if (listedSerialNos.size() > 0 && listedSerialNos.contains(serialNo)) continue;
                JSONObject invoice = (JSONObject)entry.getValue();
                int rowIndex = this.getModel().createNewEntryRow(INVOICE_ENTITY);
                JSONArray invoiceData = new JSONArray();
                invoiceData.add((Object)invoice);
                String url = invoice.getString("snapshotUrl");
                if (StringUtils.isEmpty((CharSequence)url)) {
                    url = invoice.getString("imageUrl");
                }
                String fileName = invoice.getString("originalFileName");
                if (!StringUtils.isEmpty((CharSequence)url)) {
                    int fileNameIndex = url.lastIndexOf(47) + 1;
                    if (StringUtils.isEmpty((CharSequence)fileName)) {
                        fileName = url.substring(fileNameIndex);
                    }
                }
                this.getModel().setValue("invoice_name", (Object)fileName, rowIndex);
                this.freshCardInvoice(invoiceData, rowIndex, url, fileName);
            }
        }
    }

    private void showInvoiceUpdateView(JSONArray invoiceArray, int row) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object showAttach = null;
        if (customParams != null) {
            showAttach = customParams.get("showAttach");
        }
        JSONObject businessParam = this.getBusinessParam();
        HashMap<String, Object> formParams = new HashMap<String, Object>(8);
        formParams.put("invoices", invoiceArray);
        formParams.put("row", row);
        formParams.put("parentPageId", this.getView().getPageId());
        formParams.put("businessParam", this.getBusinessParam());
        formParams.put("showAttach", showAttach);
        H5PluginService.setCommonParam(formParams, (Map)businessParam);
        showParameter.setCustomParams(formParams);
        showParameter.setFormId("rim_h5_inv_update");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "h5_inv_update");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showOperateView(JSONArray invoiceArray, int row) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("invoices", invoiceArray);
        customParams.put("row", row);
        JSONObject businessParam = this.getBusinessParam();
        H5PluginService.setCommonParam(customParams, (Map)businessParam);
        showParameter.setCustomParams(customParams);
        showParameter.setFormId("rim_h5_operate_list");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "h5_operate");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void recognitionAndCheck(JSONArray fileArray, JSONObject businessParam) {
        if (fileArray == null || fileArray.size() == 0) {
            this.refreshCount();
            return;
        }
        for (int i = 0; i < fileArray.size(); ++i) {
            String testUrl;
            String fileUrl;
            JSONObject fileJson = fileArray.getJSONObject(i);
            this.dealHttpUrl(fileJson);
            String fileName = fileJson.getString("name");
            if (StringUtils.isEmpty((CharSequence)fileName)) {
                fileUrl = fileJson.getString("url");
                testUrl = "";
                if (StringUtils.isNotEmpty((CharSequence)fileUrl)) {
                    testUrl = UrlService.getAttachmentFullUrl((String)fileUrl);
                }
                logger.info("1\u79fb\u52a8\u7aef\u5f53\u524durl\u7684\u5730\u5740:{},\u6d4b\u8bd5\u5730\u5740\uff1a{}", (Object)fileUrl, (Object)testUrl);
                int separator = fileUrl.lastIndexOf(File.separator) + 1;
                fileName = fileUrl.substring(separator);
            } else {
                fileUrl = fileJson.getString("url");
                testUrl = "";
                if (StringUtils.isNotEmpty((CharSequence)fileUrl)) {
                    testUrl = UrlService.getAttachmentFullUrl((String)fileUrl);
                }
                logger.info("2\u79fb\u52a8\u7aef\u5f53\u524durl\u7684\u5730\u5740:{},\u6d4b\u8bd5\u5730\u5740\uff1a{}", (Object)fileUrl, (Object)testUrl);
            }
            String errcode = fileJson.getString("errcode");
            String description = fileJson.getString("description");
            String lowerCaseName = fileName.toLowerCase();
            String fileType = FileUtils.getFileType((String)lowerCaseName);
            if (!("ofd".equals(fileType) || "pdf".equals(fileType) || "png".equals(fileType) || "bmp".equals(fileType) || "zip".equals(fileType) || "xml".equals(fileType) || "jpg".equals(fileType) || "jpeg".equals(fileType) || "webp".equals(fileType))) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u56fe\u7247\uff0cpdf\uff0cofd\u683c\u5f0f\u7684\u6587\u4ef6\uff0c\u5f53\u524d\u6587\u4ef6\u540d\uff1a%1$s", (String)"H5InvoiceUploadPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]), lowerCaseName));
                continue;
            }
            if ("success".equals(fileJson.getString("status"))) {
                String urlPath = fileJson.getString("url");
                if (StringUtils.isEmpty((CharSequence)fileName)) {
                    fileName = urlPath.substring(urlPath.lastIndexOf(47) + 1, urlPath.length());
                }
                businessParam.put("uploadIndex", (Object)ScannerService.getUploadIndex((JSONObject)fileJson));
                ScannerService.recognitionInvoice((String)"fpzs", (String)this.getView().getPageId(), (String)urlPath, (String)fileName, (JSONObject)businessParam, (Map)FpzsMainService.getCustomParam((AbstractFormPlugin)this));
                String traceId = RequestContext.get().getTraceId();
                if (this.traceMap == null || this.traceMap.get(traceId) == null) {
                    this.uploadProcess("upload");
                }
                if (this.traceMap == null) {
                    this.traceMap = new HashMap<String, String>(16);
                } else if (this.traceMap.size() > 1) {
                    this.traceMap.clear();
                }
                this.traceMap.put(traceId, "1");
                continue;
            }
            if ("40002".equals(errcode)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\uff1a%1$s\u4e0a\u4f20\u5931\u8d25,\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b", (String)"H5InvoiceUploadPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]), fileName));
                continue;
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)description)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\uff1a%1$s\u4e0a\u4f20\u5931\u8d25", (String)"H5InvoiceUploadPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]), fileName));
                continue;
            }
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\uff1a%1$s\u4e0a\u4f20\u5931\u8d25:%1$s", (String)"H5InvoiceUploadPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), fileName, description));
        }
        this.refreshCount();
    }

    private void refreshCount() {
        int invoiceCount = 0;
        int attachCount = 0;
        BigDecimal invoiceTotalAmount = new BigDecimal("0.00");
        ArrayList<String> invoiceSerialNos = new ArrayList<String>();
        int failCount = 0;
        if (null != this.getView().getPageCache().get("invoiceArrayCache")) {
            JSONArray invoiceArrayCache = JSON.parseArray((String)this.getView().getPageCache().get("invoiceArrayCache"));
            for (int cacheIndex = 0; cacheIndex < invoiceArrayCache.size(); ++cacheIndex) {
                JSONArray invoiceArray;
                try {
                    invoiceArray = invoiceArrayCache.getJSONArray(cacheIndex);
                }
                catch (Exception e) {
                    continue;
                }
                if (invoiceArray == null) continue;
                ArrayList<String> serialNos = new ArrayList<String>();
                for (int invoiceIndex = 0; invoiceIndex < invoiceArray.size(); ++invoiceIndex) {
                    JSONObject invoice = invoiceArray.getJSONObject(invoiceIndex);
                    ++invoiceCount;
                    BigDecimal totalAmount = BigDecimalUtil.transDecimal((Object)invoice.getString("totalAmount"));
                    invoiceTotalAmount = invoiceTotalAmount.add(totalAmount).setScale(2, 4);
                    if (StringUtils.isNotEmpty((CharSequence)invoice.getString("serialNo"))) {
                        serialNos.add(invoice.getString("serialNo"));
                        invoiceSerialNos.add(invoice.getString("serialNo"));
                        continue;
                    }
                    ++failCount;
                }
                List<Long> attachIds = this.getAttachListBySerialNos(serialNos);
                String oldCountMsg = this.getModel().getValue("success_count", cacheIndex).toString();
                int start = oldCountMsg.indexOf(ResManager.loadKDString((String)"\u9644\u4ef6", (String)"H5InvoiceUploadPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                int end = oldCountMsg.indexOf(65509);
                if (start > 0 && end > 0) {
                    String newCountMsg = String.format(ResManager.loadKDString((String)"%1$s\u9644\u4ef6%2$s\u5f20,%3$s", (String)"H5InvoiceUploadPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]), oldCountMsg.substring(0, start), attachIds.size(), oldCountMsg.substring(end));
                    this.getModel().setValue("success_count", (Object)newCountMsg, cacheIndex);
                }
                attachCount += attachIds.size();
            }
        }
        Label invoicecount_label = (Label)this.getControl("invoicecount_label");
        invoicecount_label.setText(invoiceCount + "");
        Label invoicetotalamount_label = (Label)this.getControl("invoicetotalamount_label");
        invoicetotalamount_label.setText(BigDecimalUtil.decimalFormat((BigDecimal)invoiceTotalAmount));
        Label attachcount_label = (Label)this.getControl("attachcount_label");
        attachcount_label.setText(attachCount + "");
        int rowCount = this.getModel().getEntryRowCount(INVOICE_ENTITY);
        if (rowCount > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"data_empty"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"data_empty"});
        }
        this.getView().getPageCache().put("invoiceSerialNos", invoiceSerialNos.stream().filter(StringUtils::isNotEmpty).collect(Collectors.joining(",")));
        this.getView().getPageCache().put("failCount", failCount + "");
    }

    private void submit() {
        HashMap<String, Cloneable> customParams = new HashMap<String, Cloneable>(2);
        LinkedHashMap<Long, BigDecimal> invoiceIds = new LinkedHashMap(2);
        String invoiceSerialNos = this.getView().getPageCache().get("invoiceSerialNos");
        ArrayList<Long> attachIds = new ArrayList();
        boolean min = false;
        String pageId = MobileIndexMinUtils.mobileIndex((IFormView)this.getView());
        if (pageId != null) {
            min = true;
        }
        boolean invCollect = false;
        String parentViewId = this.getView().getFormShowParameter().getParentFormId();
        String parentPAGEID = this.getView().getFormShowParameter().getParentPageId();
        if (parentViewId != null && parentViewId.startsWith("rim")) {
            invCollect = StringUtils.equals((CharSequence)"rim_inv_collect_mobile", (CharSequence)parentViewId);
            if (invCollect) {
                this.getView().returnDataToParent((Object)"refresh");
                this.getView().close();
                return;
            }
            IFormView parentView = this.getView().getViewNoPlugin(parentPAGEID);
            String parentParentId = parentView.getFormShowParameter().getParentFormId();
            if (parentParentId != null && StringUtils.equals((CharSequence)"rim_inv_collect_mobile", (CharSequence)parentParentId)) {
                parentView.close();
                this.getView().close();
                return;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceSerialNos)) {
            List<String> serialNos = Arrays.asList(invoiceSerialNos.split(","));
            invoiceIds = this.getInvoiceMapBySerialNos(serialNos);
            attachIds = this.getAttachListBySerialNos(serialNos);
        }
        if (this.getView().getPageCache().get("failCount") != null && Integer.parseInt(this.getView().getPageCache().get("failCount")) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\u5931\u8d25\u53d1\u7968", (String)"H5InvoiceUploadPlugin_13", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (invoiceIds.isEmpty()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u53d1\u7968\u6dfb\u52a0\uff01", (String)"H5InvoiceUploadPlugin_14", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            if (!min && !invCollect) {
                this.getView().close();
            }
        } else if (min) {
            Map params = FpzsMainService.getCustomParam((String)this.getView().getPageId());
            String indexPageId = (String)params.get("indexPageId");
            AbstractOperateService.addSelected(indexPageId, invoiceIds, attachIds);
            AbstractOperateService operate = AbstractOperateService.newInstance("push_pc", this);
            operate.operate();
        } else {
            customParams.put("invoiceIds", invoiceIds);
            customParams.put("attachIds", attachIds);
            this.getView().returnDataToParent(customParams);
            this.getView().close();
        }
    }

    private List<Long> getAttachListBySerialNos(List<String> serialNos) {
        ArrayList<Long> attachIds = new ArrayList<Long>();
        if (serialNos.size() == 0) {
            return attachIds;
        }
        QFilter relationFilter = new QFilter("relation_id", "in", serialNos).and("relation_type", "=", (Object)"3");
        DynamicObjectCollection relationObjects = QueryServiceHelper.query((String)"rim_attach_relation", (String)"attach_id", (QFilter[])relationFilter.toArray());
        if (relationObjects.isEmpty()) {
            return attachIds;
        }
        for (DynamicObject relationObject : relationObjects) {
            Long attachId;
            if (ObjectUtils.isEmpty((Object)relationObject) || ObjectUtils.isEmpty((Object)(attachId = Long.valueOf(relationObject.getLong("attach_id"))))) continue;
            attachIds.add(attachId);
        }
        return attachIds;
    }

    private Map<Long, BigDecimal> getInvoiceMapBySerialNos(List<String> serialNos) {
        LinkedHashMap<Long, BigDecimal> invoiceMap = new LinkedHashMap<Long, BigDecimal>(16);
        if (CollectionUtils.isEmpty(serialNos)) {
            return invoiceMap;
        }
        for (String serialNo : serialNos) {
            QFilter serialFilter;
            DynamicObject mainObject;
            if (StringUtils.isEmpty((CharSequence)serialNo) || ObjectUtils.isEmpty((Object)(mainObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id,total_amount", (QFilter[])(serialFilter = new QFilter("serial_no", "=", (Object)serialNo)).toArray())))) continue;
            Long mainId = mainObject.getLong("id");
            BigDecimal totalAmount = mainObject.getBigDecimal("total_amount");
            invoiceMap.put(mainId, totalAmount);
        }
        return invoiceMap;
    }

    private void freshCardInvoice(JSONArray recognitionData, int rowIndex, String uploadUrl, String fileName) {
        String url;
        JSONObject invoice;
        CardEntry cardEntry = (CardEntry)this.getView().getControl(INVOICE_ENTITY);
        logger.info("\u8bc6\u522b\u67e5\u9a8c\u6570\u91cf\uff1a{}", (Object)recognitionData.size());
        cardEntry.setChildVisible(false, rowIndex, new String[]{"success_flexpanelap"});
        cardEntry.setChildVisible(false, rowIndex, new String[]{"fail_flexpanelap"});
        cardEntry.setChildVisible(false, rowIndex, new String[]{"cardentryflexpanelap3"});
        cardEntry.setChildVisible(false, rowIndex, new String[]{"red_toast1"});
        cardEntry.setChildVisible(false, rowIndex, new String[]{"red_toast2"});
        cardEntry.setChildVisible(false, rowIndex, new String[]{"red_toast3"});
        cardEntry.setChildVisible(false, rowIndex, new String[]{"yellow_toast"});
        cardEntry.setChildVisible(false, rowIndex, new String[]{"cardentryflex_fail"});
        JSONArray invoiceData = new JSONArray();
        int successCount = 0;
        BigDecimal successTotalAmount = new BigDecimal("0");
        int failCount = 0;
        BigDecimal failTotalAmount = new BigDecimal("0");
        ArrayList<String> serialNos = new ArrayList<String>();
        String previewUrl = "";
        String checkFailMsg = null;
        HashMap<String, Long> seqMap = new HashMap<String, Long>(recognitionData.size());
        ArrayList<String> notSavedSerialNos = new ArrayList<String>(8);
        for (int invoiceIndex = 0; invoiceIndex < recognitionData.size(); ++invoiceIndex) {
            JSONObject invoice2 = recognitionData.getJSONObject(invoiceIndex);
            String serialNo = invoice2.getString("serialNo");
            DynamicObject rimInvoice = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id", (QFilter[])new QFilter[]{new QFilter("serial_no", "=", (Object)serialNo)});
            if (StringUtils.isNotEmpty((CharSequence)serialNo) && rimInvoice != null) {
                serialNos.add(serialNo);
                seqMap.put(serialNo, invoice2.getLong("uploadSeq"));
                ++successCount;
                successTotalAmount = successTotalAmount.add(BigDecimalUtil.transDecimal((Object)invoice2.getString("totalAmount")));
            } else {
                if (StringUtils.isNotEmpty((CharSequence)serialNo)) {
                    notSavedSerialNos.add(serialNo);
                }
                invoiceData.add((Object)invoice2);
                ++failCount;
                failTotalAmount = failTotalAmount.add(BigDecimalUtil.transDecimal((Object)invoice2.getString("totalAmount")));
            }
            if (StringUtils.isNotEmpty((CharSequence)invoice2.getString("kdcloudUrl"))) {
                previewUrl = invoice2.getString("kdcloudUrl");
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)invoice2.getString("downloadUrl"))) continue;
            previewUrl = invoice2.getString("downloadUrl");
        }
        if (serialNos.size() > 0) {
            JSONArray list = VerifyUtil.verifyBySerialNos(new HashMap(), serialNos, (boolean)true);
            for (int listIndex = 0; listIndex < list.size(); ++listIndex) {
                invoice = list.getJSONObject(listIndex);
                invoice.put("invoiceType", (Object)InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoice.getString("invoiceType")));
                Long seq = (Long)seqMap.get(invoice.getString("serialNo"));
                invoice.put("uploadSeq", (Object)seq);
                invoiceData.add((Object)invoice);
            }
            invoiceData.sort((o1, o2) -> ((JSONObject)o1).getLong("uploadSeq").compareTo(((JSONObject)o2).getLong("uploadSeq")));
        }
        List<Long> attachIds = this.getAttachListBySerialNos(serialNos);
        if (successCount > 0) {
            cardEntry.setChildVisible(true, rowIndex, new String[]{"success_flexpanelap"});
            this.getModel().setValue("success_count", (Object)String.format(ResManager.loadKDString((String)"\u6210\u529f:%1$s\u5f20,\u9644\u4ef6%2$s\u5f20,\uffe5%3$s", (String)"H5InvoiceUploadPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), successCount, attachIds.size(), BigDecimalUtil.decimalFormat((BigDecimal)successTotalAmount)), rowIndex);
        }
        if (failCount > 0) {
            cardEntry.setChildVisible(true, rowIndex, new String[]{"fail_flexpanelap"});
            cardEntry.setChildVisible(true, rowIndex, new String[]{"cardentryflexpanelap3"});
            cardEntry.setChildVisible(true, rowIndex, new String[]{"red_toast"});
            this.getModel().setValue("fail_count", (Object)String.format(ResManager.loadKDString((String)"\u5931\u8d25:%1$s\u5f20,\uffe5%2$s", (String)"H5InvoiceUploadPlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]), failCount, BigDecimalUtil.decimalFormat((BigDecimal)failTotalAmount)), rowIndex);
        }
        if (StringUtils.isNotEmpty((CharSequence)uploadUrl) && StringUtils.isNotEmpty((CharSequence)fileName)) {
            url = UrlServiceUtils.getDownloadUrl((String)uploadUrl);
            this.setImageAp(rowIndex, url, fileName);
        } else {
            url = UrlServiceUtils.getDownloadUrl((String)previewUrl);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                String previewFileName = url.substring(url.lastIndexOf(47));
                this.setImageAp(rowIndex, url, previewFileName);
            }
        }
        logger.info("\u5408\u89c4\u6027\u6821\u9a8c\u540e\u7684\u53d1\u7968\u4e0a\u4f20\u7ed3\u679c" + invoiceData.toJSONString());
        for (int n = 0; n < invoiceData.size(); ++n) {
            invoice = invoiceData.getJSONObject(n);
            if (ObjectUtils.isEmpty((Object)invoice)) continue;
            JSONArray verifyArray = invoice.getJSONArray("verifyResult");
            if (verifyArray != null) {
                List resultList = JSON.parseArray((String)verifyArray.toJSONString(), VerifyResultDto.class);
                if (resultList.size() <= 0) continue;
                for (int resultIndex = 0; resultIndex < resultList.size(); ++resultIndex) {
                    VerifyResultDto verifyResultDto = (VerifyResultDto)resultList.get(resultIndex);
                    if (!"check_status".equals(verifyResultDto.getConfigType())) continue;
                    if (checkFailMsg == null) {
                        checkFailMsg = "1";
                        continue;
                    }
                    if (checkFailMsg.contains(ResManager.loadKDString((String)"\u67e5\u9a8c\u5931\u8d25", (String)"H5InvoiceUploadPlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]))) continue;
                    checkFailMsg = "3";
                }
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)invoice.getString("serialNo")) && !notSavedSerialNos.contains(invoice.getString("serialNo"))) continue;
            if (checkFailMsg == null) {
                checkFailMsg = "2";
                continue;
            }
            if (checkFailMsg.contains(ResManager.loadKDString((String)"\u5fc5\u586b\u5b57\u6bb5", (String)"H5InvoiceUploadPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]))) continue;
            checkFailMsg = "3";
        }
        if (StringUtils.isNotEmpty(checkFailMsg)) {
            cardEntry.setChildVisible(true, rowIndex, new String[]{"cardentryflexpanelap3"});
            cardEntry.setChildVisible(true, rowIndex, new String[]{"red_toast".concat(checkFailMsg)});
        }
        this.getModel().setValue("invoice_data", (Object)invoiceData.toJSONString(), rowIndex);
        JSONArray invoiceArrayCache = JSON.parseArray((String)this.getView().getPageCache().get("invoiceArrayCache"));
        if (invoiceArrayCache == null || invoiceArrayCache.size() == 0) {
            invoiceArrayCache = new JSONArray();
        }
        if (uploadUrl != null && !CollectionUtils.isEmpty(serialNos)) {
            for (int i = 0; i < invoiceArrayCache.size(); ++i) {
                if (CollectionUtils.isEmpty((Collection)invoiceArrayCache.getJSONArray(i))) continue;
                Boolean containSameInvoice = Boolean.FALSE;
                for (int j = 0; j < invoiceArrayCache.getJSONArray(i).size(); ++j) {
                    String uploadedSerialNo;
                    JSONObject invoice3 = invoiceArrayCache.getJSONArray(i).getJSONObject(j);
                    if (ObjectUtils.isEmpty((Object)invoice3) || !serialNos.contains(uploadedSerialNo = invoice3.getString("serialNo"))) continue;
                    containSameInvoice = Boolean.TRUE;
                    break;
                }
                if (!containSameInvoice.booleanValue()) continue;
                Label yellowLabel = (Label)this.getControl("yellow_toast");
                yellowLabel.setText(ResManager.loadKDString((String)"\u91cd\u590d\u91c7\u96c6", (String)"H5InvoiceUploadPlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                cardEntry.setChildVisible(true, rowIndex, new String[]{"yellow_toast"});
                cardEntry.setChildVisible(true, rowIndex, new String[]{"cardentryflexpanelap3"});
                break;
            }
        }
        invoiceArrayCache.set(rowIndex, (Object)invoiceData);
        this.getView().getPageCache().put("invoiceArrayCache", invoiceArrayCache.toJSONString());
    }

    private void setImageAp(int rowIndex, String imageUrl, String fileName) {
        if (StringUtils.isEmpty((CharSequence)imageUrl)) {
            return;
        }
        String baseUrl = H5PluginService.getBaseUrl((IFormView)this.getView());
        imageUrl = UrlServiceUtils.getDownloadUrl((String)imageUrl, (String)baseUrl);
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap pmap = new HashMap(2);
        HashMap<String, String> propertiesMap = new HashMap<String, String>(2);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(INVOICE_ENTITY);
        if (fileName.endsWith("pdf")) {
            cardEntry.setChildVisible(false, rowIndex, new String[]{"imageap"});
            propertiesMap.put("bgik", "url(\"icons/mobile/label/fpy_pdf.png?v=1.0\")");
            pmap.put("cardentryflexpanelap", propertiesMap);
            client.invokeControlMethod(INVOICE_ENTITY, "setCustomProperties", new Object[]{rowIndex, pmap});
        } else if (fileName.endsWith("ofd")) {
            cardEntry.setChildVisible(false, rowIndex, new String[]{"imageap"});
            propertiesMap.put("bgik", "url(\"icons/mobile/label/fpy_ofd.png?v=1.0\")");
            pmap.put("cardentryflexpanelap", propertiesMap);
            client.invokeControlMethod(INVOICE_ENTITY, "setCustomProperties", new Object[]{rowIndex, pmap});
        } else {
            this.getModel().setValue("imageap", (Object)imageUrl, rowIndex);
        }
    }

    private void setLoading(boolean visible) {
        CustomControl customControlAp = (CustomControl)this.getControl("dialog_customcontrolap");
        JSONObject cameraUploadParam = new JSONObject();
        cameraUploadParam.put("divId", (Object)"upload_loading_flex");
        cameraUploadParam.put("operator", (Object)visible);
        cameraUploadParam.put("millisec", (Object)1000);
        cameraUploadParam.put("times", (Object)1000);
        cameraUploadParam.put("dialogId", (Object)"h5upload");
        customControlAp.setData((Object)cameraUploadParam);
    }

    private void dealHttpUrl(JSONObject fileJson) {
        String url;
        String fileUrl;
        if (fileJson != null && !StringUtils.isEmpty((CharSequence)(fileUrl = fileJson.getString("url"))) && fileUrl.startsWith("http") && !StringUtils.isEmpty((CharSequence)(url = FileUtils.downLoadAndUpload((String)fileUrl, null, (boolean)false)))) {
            fileJson.put("url", (Object)url);
        }
    }
}

