/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.h5;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.imc.rim.common.constant.AttachConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.h5.H5PluginService;
import kd.imc.rim.common.helper.ImcSaveServiceHelper;
import kd.imc.rim.common.invoice.collector.InvoiceCollectField;
import kd.imc.rim.common.invoice.file.InvoiceAttachCaremaService;
import kd.imc.rim.common.invoice.fpzs.InvoiceClassService;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.verify.dto.VerifyResultDto;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.formplugin.mobile.home.operate.AbstractOperateService;

public class H5InvoiceVerifyDetailPlugin
extends AbstractMobFormPlugin
implements CellClickListener {
    private static Log logger = LogFactory.getLog(AbstractMobFormPlugin.class);
    private static final String ATTACH_ENTITY = "attach_entity";

    public void afterCreateNewData(EventObject e) {
        InvoiceAttachCaremaService attachService = new InvoiceAttachCaremaService();
        CustomControl customcontrol = (CustomControl)this.getControl("customcontrolap");
        attachService.initH5AttachUpload(Boolean.FALSE, customcontrol, "add_attach");
        this.init();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"del_invoice", "check_img", "show_more", "flex_invoice_class"});
        CardEntry cardEntry = (CardEntry)this.getControl(ATTACH_ENTITY);
        cardEntry.addCellClickListener((CellClickListener)this);
        Button moreButton = (Button)this.getControl("more");
        moreButton.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control button = (Control)evt.getSource();
        if ("del_invoice".equals(button.getKey())) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"H5InvoiceVerifyDetailPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"H5InvoiceVerifyDetailPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u540e\u6570\u636e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"H5InvoiceVerifyDetailPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("delCallBack"), btnNameMaps);
        }
        if ("more".equals(button.getKey())) {
            this.dealAttachMore();
        }
        if ("check_img".equals(button.getKey())) {
            String fullUrl;
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            JSONObject invoice = JSONObject.parseObject((String)customParams.get("invoice").toString());
            String url = invoice.getString("snapshot_url");
            if (StringUtils.isEmpty((CharSequence)url)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u56fe\u7247", (String)"H5InvoiceVerifyDetailPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            String token = RequestContext.get().getGlobalSessionId();
            String baseUrl = H5PluginService.getBaseUrl((IFormView)this.getView());
            String absoluteUrl4 = UrlServiceUtils.getDownloadUrl((String)url, (String)baseUrl);
            String client = RequestContext.get().getClient();
            String agent = RequestContext.get().getUserAgent();
            logger.info("\u5ba2\u6237\u7aef\u7c7b\u578b1\uff1a{}", (Object)client);
            logger.info("\u5ba2\u6237\u7aef\u7c7b\u578b2\uff1a{}", (Object)agent);
            try {
                fullUrl = EncreptSessionUtils.encryptAcessToken((String)absoluteUrl4, (String)token);
            }
            catch (UnsupportedEncodingException e) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u56fe\u7247\u52a0\u5bc6\u5931\u8d25", (String)"H5InvoiceVerifyDetailPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            logger.info("H5InvoiceVerifyDetailPlugin-check_img\u56fe\u7247\u9884\u89c8\u5730\u5740:" + fullUrl);
            fullUrl = UrlServiceUtils.getDownloadUrl((String)fullUrl);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("method", "previewImage");
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("current", fullUrl);
            args.put("urls", new String[]{fullUrl});
            map.put("args", args);
            this.getView().executeClientCommand("callYZJApi", new Object[]{map});
        }
        if ("show_more".equals(((Control)evt.getSource()).getKey())) {
            this.showMore();
        }
        if ("flex_invoice_class".equals(((Control)evt.getSource()).getKey())) {
            InvoiceClassService.getInstance().openSelect((AbstractFormPlugin)this);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        if (this.getModel().getValue("attachid") != null) {
            Long id = Long.parseLong(this.getModel().getValue("attachid").toString());
            this.showAttachDetail(id);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            if ("delCallBack".equals(callBackId)) {
                this.getView().returnDataToParent((Object)"delete");
                this.getView().close();
            }
        } else if (MessageBoxResult.No.equals((Object)messageBoxClosedEvent.getResult())) {
            // empty if block
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventArgs = e.getEventArgs();
        if ("cameraUploadStart".equals(e.getEventName())) {
            this.setLoading(true);
        } else if ("cameraUpload".equals(e.getEventName())) {
            logger.info("\u62cd\u7167\u4e0a\u4f20\uff1a" + eventArgs);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            JSONObject invoice = JSONObject.parseObject((String)customParams.get("invoice").toString());
            if (StringUtils.isEmpty((CharSequence)invoice.getString("serial_no"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u5173\u952e\u5b57\u6bb5\u7f3a\u5931\uff0c\u4e0d\u652f\u6301\u7ed1\u5b9a\u9644\u4ef6\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"H5InvoiceVerifyDetailPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            } else {
                String serialNo = invoice.getString("serial_no");
                JSONObject uploadData = JSON.parseObject((String)eventArgs);
                JSONArray fileArray = uploadData.getJSONArray("fileArray");
                ArrayList<Long> addedAttachIds = new ArrayList<Long>(fileArray.size());
                for (int i = 0; i < fileArray.size(); ++i) {
                    QFilter hashFilter;
                    DynamicObject dynamicObject;
                    JSONObject fileJson = fileArray.getJSONObject(i);
                    if (!"success".equals(fileJson.getString("status"))) continue;
                    String urlPath = fileJson.getString("url");
                    String originalFileName = fileJson.getString("name");
                    if (StringUtils.isEmpty((CharSequence)originalFileName)) {
                        originalFileName = urlPath.substring(urlPath.lastIndexOf(47) + 1, urlPath.length());
                    }
                    FileService service = FileServiceFactory.getAttachmentFileService();
                    InputStream fileInputStream = service.getInputStream(urlPath);
                    String attachHash = FileUtils.getSHA256((InputStream)fileInputStream);
                    String fileName = originalFileName.substring(0, originalFileName.lastIndexOf(46));
                    String fileType = originalFileName.substring(originalFileName.lastIndexOf(46) + 1);
                    if (!("png".equals(fileType) || "bmp".equals(fileType) || "jpg".equals(fileType) || "jpeg".equals(fileType) || "webp".equals(fileType))) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76ee\u524d\u53ea\u652f\u6301\u56fe\u7247\u683c\u5f0f\u4f5c\u4e3a\u9644\u4ef6", (String)"H5InvoiceVerifyDetailPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (fileName.length() > 50) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u8fc7\u957f\uff0c\u5df2\u81ea\u52a8\u4e3a\u60a8\u622a\u53d6\u524d30\u4e2a\u5b57\u7b26", (String)"H5InvoiceVerifyDetailPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        fileName = fileName.substring(0, 30);
                    }
                    if (ObjectUtils.isEmpty((Object)(dynamicObject = QueryServiceHelper.queryOne((String)"rim_attach", (String)"id, attach_url, attach_name, remark, create_time, attach_category, file_extension", (QFilter[])(hashFilter = new QFilter("attach_hash_value", "=", (Object)attachHash)).toArray())))) {
                        dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach");
                        dynamicObject.set("create_time", (Object)new Date());
                        dynamicObject.set("attach_name", (Object)fileName);
                        String attachNo = UUID.randomUUID();
                        dynamicObject.set("attach_no", (Object)attachNo);
                        dynamicObject.set("user", (Object)Long.parseLong(RequestContext.get().getUserId()));
                        dynamicObject.set("attach_category", (Object)AttachConstant.ATTACH_OTHER_CATEGORY_ID);
                        dynamicObject.set("attach_url", (Object)urlPath);
                        dynamicObject.set("attach_type", (Object)2);
                        dynamicObject.set("file_extension", (Object)fileType);
                        dynamicObject.set("original_name", (Object)originalFileName);
                        dynamicObject.set("attach_hash_value", (Object)attachHash);
                        dynamicObject.set("update_time", (Object)new Date());
                        dynamicObject = (DynamicObject)ImcSaveServiceHelper.save((DynamicObject)dynamicObject);
                    } else if (ObjectUtils.isEmpty((Object)dynamicObject.get("attach_category")) || ObjectUtils.isEmpty((Object)dynamicObject.get("attach_category.id"))) {
                        dynamicObject.set("attach_category", (Object)AttachConstant.ATTACH_OTHER_CATEGORY_ID);
                    }
                    if (ObjectUtils.isEmpty((Object)dynamicObject.get("file_extension"))) {
                        dynamicObject.set("file_extension", (Object)fileType);
                    }
                    if (ObjectUtils.isEmpty((Object)dynamicObject)) continue;
                    String attachid = dynamicObject.getString("id");
                    addedAttachIds.add(Long.parseLong(attachid));
                    QFilter relationFilter = new QFilter("attach_id", "=", (Object)attachid).and("relation_id", "=", (Object)serialNo).and("relation_type", "=", (Object)"3");
                    DynamicObject relationObject = QueryServiceHelper.queryOne((String)"rim_attach_relation", (String)"attach_id, relation_type", (QFilter[])relationFilter.toArray());
                    if (!ObjectUtils.isEmpty((Object)relationObject)) continue;
                    relationObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach_relation");
                    relationObject.set("attach_id", (Object)attachid);
                    relationObject.set("relation_type", (Object)"3");
                    relationObject.set("relation_id", (Object)serialNo);
                    ImcSaveServiceHelper.save((DynamicObject)relationObject);
                }
                String indexPageId = (String)customParams.get("indexPageId");
                AbstractOperateService.addSelected(indexPageId, null, addedAttachIds);
                this.initAttachList(serialNo);
                this.setLoading(false);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("rim_h5_attach_operate".equals(closedCallBackEvent.getActionId()) || "rim_h5_attach_detail".equals(closedCallBackEvent.getActionId())) {
            Map callBackData = (Map)closedCallBackEvent.getReturnData();
            JSONObject returnData = (JSONObject)closedCallBackEvent.getReturnData();
            this.dealAttachCallback(returnData);
        } else if ("select_class".equals(closedCallBackEvent.getActionId())) {
            JSONObject invoice = JSONObject.parseObject((String)((String)this.getView().getFormShowParameter().getCustomParam("invoice")));
            InvoiceClassService.getInstance().selectCloseCallBack((AbstractFormPlugin)this, closedCallBackEvent, invoice.getLong("id"));
            InvoiceClassService.getInstance().callBackProBar((AbstractFormPlugin)this);
        }
    }

    private void dealAttachCallback(JSONObject returnData) {
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        String operateType = returnData.getString("type");
        if (org.apache.commons.lang.StringUtils.isEmpty((String)operateType)) {
            return;
        }
        int rowIndex = returnData.getInteger("rowIndex");
        switch (operateType) {
            case "delete": {
                Long attachId = Long.parseLong(this.getModel().getValue("attachid", rowIndex).toString());
                ArrayList<Long> attachIds = new ArrayList<Long>(1);
                attachIds.add(attachId);
                this.getView().getModel().deleteEntryRow(ATTACH_ENTITY, rowIndex);
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                String indexPageId = (String)customParams.get("indexPageId");
                AbstractOperateService.deleteSelected(indexPageId, null, attachIds);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u5220\u9664\u6210\u529f", (String)"H5InvoiceVerifyDetailPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                break;
            }
            case "edit": {
                String attachName = returnData.getString("attach_name");
                String remark = returnData.getString("remark");
                this.getView().getModel().setValue("attach_name", (Object)attachName, rowIndex);
                this.getView().getModel().setValue("remark", (Object)remark, rowIndex);
                break;
            }
            case "cancel": {
                break;
            }
            default: {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u9644\u4ef6\u64cd\u4f5c\u7c7b\u578b", (String)"H5InvoiceVerifyDetailPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void showAttachDetail(Long id) {
        MobileFormShowParameter showAttachEditForm = new MobileFormShowParameter();
        showAttachEditForm.setFormId("rim_h5_attach_detail");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONObject invoice = JSONObject.parseObject((String)customParams.get("invoice").toString());
        showAttachEditForm.getOpenStyle().setShowType(ShowType.Floating);
        JSONObject customerParam = new JSONObject();
        customerParam.put("id", (Object)id);
        customerParam.put("serialNo", (Object)invoice.getString("serial_no"));
        customerParam.put("rowIndex", (Object)this.getModel().getEntryCurrentRowIndex(ATTACH_ENTITY));
        Map ParentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        H5PluginService.setCommonParam((Map)customParams, (Map)ParentCustomParams);
        showAttachEditForm.setCustomParams((Map)customerParam);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_h5_attach_detail");
        showAttachEditForm.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showAttachEditForm);
    }

    private void showMore() {
        String showMore = this.getView().getPageCache().get("show_more");
        Label labelap = (Label)this.getView().getControl("show_more_text");
        if (StringUtils.isEmpty((CharSequence)showMore) || "0".equals(showMore)) {
            this.getView().getPageCache().put("show_more", "1");
            labelap.setText(ResManager.loadKDString((String)"\u6536\u8d77", (String)"H5InvoiceVerifyDetailPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"vector_down"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"vector_up"});
        } else {
            this.getView().getPageCache().put("show_more", "0");
            labelap.setText(ResManager.loadKDString((String)"\u5c55\u793a\u66f4\u591a", (String)"H5InvoiceVerifyDetailPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.TRUE, new String[]{"vector_down"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"vector_up"});
        }
        this.showInvoiceInfo();
    }

    private void showInvoiceInfo() {
        Long invoiceType = Long.parseLong(this.getModel().getValue("invoicetype").toString());
        Map invoiceFieldMap = InvoiceCollectField.getInvoiceField((Long)invoiceType);
        if (invoiceFieldMap != null) {
            if (invoiceFieldMap.size() <= 4) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"show_more"});
                return;
            }
            String showMore = this.getView().getPageCache().get("show_more");
            int showMoreCount = 0;
            for (Map.Entry invoiceField : invoiceFieldMap.entrySet()) {
                if (null == this.getControl((String)invoiceField.getValue())) continue;
                if (((String)invoiceField.getKey()).contains(",")) {
                    String[] valueKeys;
                    for (String valueKey : valueKeys = ((String)invoiceField.getKey()).split(",")) {
                        if ((StringUtils.isEmpty((CharSequence)showMore) || "0".equals(showMore)) && ++showMoreCount >= 4) {
                            this.getView().setVisible(Boolean.FALSE, new String[]{(String)invoiceField.getValue()});
                            continue;
                        }
                        this.getView().setVisible(Boolean.TRUE, new String[]{(String)invoiceField.getValue()});
                    }
                    continue;
                }
                if ((StringUtils.isEmpty((CharSequence)showMore) || "0".equals(showMore)) && ++showMoreCount >= 4) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{(String)invoiceField.getValue()});
                    continue;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{(String)invoiceField.getValue()});
            }
        }
    }

    private void showAttachInfo(JSONObject result) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String showAttach = null;
        if (customParams != null) {
            showAttach = (String)customParams.get("showAttach");
        }
        if (StringUtils.isNotEmpty(showAttach) && "0".equals(showAttach)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap11"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"inv_attach"});
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)result.getString("serialNo"))) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"flexpanelap11"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"inv_attach"});
            this.initAttachList(result.getString("serialNo"));
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap11"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"inv_attach"});
        }
    }

    private void init() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"inv_message"});
        this.invisibleInvoiceFlex();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        logger.info("\u53d1\u7968\u5408\u89c4\u6027\u6821\u9a8c\u8be6\u60c5\u754c\u9762\u6570\u636e\u521d\u59cb\u5316\uff1a" + customParams);
        if (ObjectUtils.isEmpty(customParams.get("invoice"))) {
            this.showInitFlex();
            return;
        }
        JSONObject invoice = JSONObject.parseObject((String)customParams.get("invoice").toString());
        this.showInvoiceFlex(invoice);
    }

    private void dealAttachMore() {
        MobileFormShowParameter moreForm = new MobileFormShowParameter();
        moreForm.setFormId("rim_h5_attach_operate");
        moreForm.getOpenStyle().setShowType(ShowType.Modal);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONObject invoice = JSONObject.parseObject((String)customParams.get("invoice").toString());
        Long id = Long.parseLong(this.getModel().getValue("attachid").toString());
        HashMap<String, Object> customerParam = new HashMap<String, Object>(3);
        customerParam.put("attachId", id);
        customerParam.put("serialNo", invoice.getString("serial_no"));
        customerParam.put("rowIndex", this.getModel().getEntryCurrentRowIndex(ATTACH_ENTITY));
        H5PluginService.setCommonParam((Map)customParams, (Map)customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_h5_attach_operate");
        moreForm.setCloseCallBack(closeCallBack);
        moreForm.setCustomParams(customerParam);
        this.getView().showForm((FormShowParameter)moreForm);
    }

    private void showInvoiceFlex(JSONObject invoice) {
        this.showToastMessage(null, null);
        Long invoiceType = invoice.getLong("invoice_type");
        InvoiceConvertService convertService = InvoiceConvertService.newInstance((Long)invoiceType, null);
        JSONObject result = convertService.convert((Map)invoice);
        String awsInvoiceType = InputInvoiceTypeEnum.getAwsType((Object)invoiceType);
        this.getView().setVisible(Boolean.TRUE, new String[]{"invoice_" + awsInvoiceType});
        List resultList = new ArrayList(8);
        String verifyResultConstant = "verifyResult";
        JSONArray verifyResultArray = result.getJSONArray(verifyResultConstant);
        if (verifyResultArray != null) {
            resultList = JSON.parseArray((String)verifyResultArray.toJSONString(), VerifyResultDto.class);
            if (resultList.size() > 0) {
                for (int resultIndex = 0; resultIndex < resultList.size(); ++resultIndex) {
                    VerifyResultDto verifyResultDto = (VerifyResultDto)resultList.get(resultIndex);
                    if (!"check_status".equals(verifyResultDto.getConfigType()) || !"0".equals(verifyResultDto.getConfig())) continue;
                    this.showToastMessage(verifyResultDto.getMsg(), verifyResultDto.getConfig());
                }
            }
        } else if (StringUtils.isEmpty((CharSequence)result.getString("serialNo"))) {
            this.showToastMessage(ResManager.loadKDString((String)"\u53d1\u7968\u5fc5\u586b\u5b57\u6bb5\u7f3a\u5931", (String)"H5InvoiceVerifyDetailPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]), null);
        }
        InvoiceClassService.getInstance().initInvoiceClass((Map)invoice);
        InvoiceClassService.getInstance().setValueInvoiceClass((AbstractFormPlugin)this, invoice);
        this.getView().setVisible(Boolean.FALSE, new String[]{"vector_up"});
        Map invoiceFieldMap = InvoiceCollectField.getInvoiceField((Long)invoiceType);
        if (invoiceFieldMap != null) {
            this.getModel().setValue("invoicetype", (Object)invoiceType);
            List amountField = InvoiceCollectField.getAmountField();
            for (Map.Entry invoiceField : invoiceFieldMap.entrySet()) {
                if (null == this.getControl((String)invoiceField.getValue())) continue;
                this.getView().setVisible(Boolean.TRUE, new String[]{(String)invoiceField.getValue()});
                if (((String)invoiceField.getKey()).contains(",")) {
                    String[] valueKeys;
                    for (String valueKey : valueKeys = ((String)invoiceField.getKey()).split(",")) {
                        String fieldValue = result.getString(valueKey);
                        if (!StringUtils.isNotEmpty((CharSequence)fieldValue)) continue;
                        if (amountField.contains(valueKey)) {
                            fieldValue = BigDecimalUtil.transToPoint((String)fieldValue, (int)2);
                        }
                        this.getModel().setValue((String)invoiceField.getValue(), (Object)fieldValue);
                    }
                    continue;
                }
                String fieldValue = result.getString((String)invoiceField.getKey());
                if (StringUtils.isNotEmpty((CharSequence)fieldValue) && amountField.contains(invoiceField.getKey())) {
                    fieldValue = BigDecimalUtil.transToPoint((String)fieldValue, (int)2);
                }
                this.getModel().setValue((String)invoiceField.getValue(), (Object)fieldValue);
            }
        }
        this.showInvoiceInfo();
        this.showAttachInfo(result);
        this.getView().setEnable(Boolean.FALSE, new String[]{"edit_invoice"});
        JSONArray verifyResults = invoice.getJSONArray("verifyResult");
        for (int i = 0; i < verifyResults.size(); ++i) {
            String msg;
            JSONObject verifyResult = (JSONObject)verifyResults.get(i);
            if (ObjectUtils.isEmpty((Object)verifyResult) || !"0".equals(verifyResult.getString("config")) || StringUtils.isBlank((CharSequence)(msg = verifyResult.getString("msg")))) continue;
            int verifyRow = this.getModel().createNewEntryRow("verify_entity");
            this.getModel().setValue("verify_text", (Object)verifyResult.getString("msg"), verifyRow);
        }
    }

    private void showToastMessage(String toast, String verifyLevel) {
        if (StringUtils.isNotEmpty((CharSequence)toast)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"inv_toast_flex"});
            if (StringUtils.isNotEmpty((CharSequence)verifyLevel) && "2".equals(verifyLevel)) {
                HashMap<String, String> flexFieldMap = new HashMap<String, String>();
                flexFieldMap.put("bc", "#fffbf2");
                this.getView().updateControlMetadata("inv_toast_flex", flexFieldMap);
                HashMap<String, String> labelapFieldMap = new HashMap<String, String>();
                labelapFieldMap.put("fc", "#ff991c");
                this.getView().updateControlMetadata("inv_toast_labelap", labelapFieldMap);
                Label invToastLabelap = (Label)this.getControl("inv_toast_labelap");
                invToastLabelap.setText(toast);
            } else {
                HashMap<String, String> flexFieldMap = new HashMap<String, String>();
                flexFieldMap.put("bc", "#fff2f4");
                this.getView().updateControlMetadata("inv_toast_flex", flexFieldMap);
                HashMap<String, String> labelapFieldMap = new HashMap<String, String>();
                labelapFieldMap.put("fc", "#fb2623");
                this.getView().updateControlMetadata("inv_toast_labelap", labelapFieldMap);
                Label invToastLabelap = (Label)this.getControl("inv_toast_labelap");
                invToastLabelap.setText(toast);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"inv_toast_flex"});
        }
    }

    private void initAttachList(String serialNo) {
        QFilter relationFilter = new QFilter("relation_id", "=", (Object)serialNo).and("relation_type", "=", (Object)"3");
        DynamicObjectCollection relationObjects = QueryServiceHelper.query((String)"rim_attach_relation", (String)"attach_id", (QFilter[])relationFilter.toArray());
        if (relationObjects.isEmpty()) {
            return;
        }
        for (DynamicObject relationObject : relationObjects) {
            QFilter attachFilter;
            DynamicObject dynamicObject;
            Long attachId;
            if (ObjectUtils.isEmpty((Object)relationObject) || ObjectUtils.isEmpty((Object)(attachId = Long.valueOf(relationObject.getLong("attach_id")))) || ObjectUtils.isEmpty((Object)(dynamicObject = QueryServiceHelper.queryOne((String)"rim_attach", (String)"id, attach_url, attach_name, create_time, remark, attach_type, snapshot_url, icon_url", (QFilter[])(attachFilter = new QFilter("id", "=", (Object)attachId)).toArray())))) continue;
            this.setAttachValue(dynamicObject);
        }
    }

    private void setAttachValue(DynamicObject dynamicObject) {
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            return;
        }
        String uploadedAttachStr = this.getPageCache().get("uploaded_attach");
        Set uploadedAttachList = new HashSet<String>(8);
        String attachId = dynamicObject.getString("id");
        if (StringUtils.isNotBlank((CharSequence)uploadedAttachStr) && (uploadedAttachList = (Set)SerializationUtils.fromJsonString((String)uploadedAttachStr, Set.class)).contains(attachId)) {
            return;
        }
        uploadedAttachList.add(attachId);
        int rowIndex = this.getModel().createNewEntryRow(ATTACH_ENTITY);
        this.getModel().setValue("attachid", (Object)attachId, rowIndex);
        this.getModel().setValue("attach_url", (Object)dynamicObject.getString("attach_url"), rowIndex);
        this.getModel().setValue("attach_name", (Object)dynamicObject.getString("attach_name"), rowIndex);
        this.getModel().setValue("create_time", (Object)dynamicObject.getDate("create_time"), rowIndex);
        this.getModel().setValue("remark", (Object)dynamicObject.getString("remark"), rowIndex);
        AttachQueryService attachQueryService = new AttachQueryService();
        String attachUrl = attachQueryService.getAttachUrl(dynamicObject);
        String baseUrl = H5PluginService.getBaseUrl((IFormView)this.getView());
        String url = UrlServiceUtils.getDownloadUrl((String)attachUrl, (String)baseUrl);
        this.getModel().setValue("attach_image", (Object)url, rowIndex);
        this.getPageCache().put("uploaded_attach", SerializationUtils.toJsonString(uploadedAttachList));
    }

    private void invisibleInvoiceFlex() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_2"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_3"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_4"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_5"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_15"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_12"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_13"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_7"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_23"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_9"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_10"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_16"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_20"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_8"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_14"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_17"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_11"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_19"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_21"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_24"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_25"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap11"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"inv_attach"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"init_flex"});
    }

    private void showInitFlex() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"inv_image_flex"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"inv_toast_flex"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"inv_message"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap11"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"inv_attach"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"init_flex"});
    }

    private void setLoading(boolean visible) {
        CustomControl customControlAp = (CustomControl)this.getControl("dialog_customcontrolap");
        JSONObject cameraUploadParam = new JSONObject();
        cameraUploadParam.put("divId", (Object)"flexpanelap6");
        cameraUploadParam.put("operator", (Object)visible);
        customControlAp.setData((Object)cameraUploadParam);
    }
}

