/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.h5;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.rim.common.constant.OperateType;
import kd.imc.rim.common.h5.H5InvoiceListService;
import kd.imc.rim.common.h5.H5PluginService;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.fpzs.InvoiceClassService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.formplugin.mobile.home.operate.AbstractOperateService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class H5InvoiceVerifyListPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener,
ProgresssListener {
    private static Log logger = LogFactory.getLog(H5InvoiceVerifyListPlugin.class);
    public static final String LEGAL_ENTITY = "legal_entity";
    public static final String ILLEGAL_ENTITY = "illegal_entity";
    private InvoiceCollectService invoiceCollectService = new InvoiceCollectService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(LEGAL_ENTITY);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        CardEntry cardEntry1 = (CardEntry)this.getView().getControl(ILLEGAL_ENTITY);
        cardEntry1.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"operation", "operation_1", "cancel", "import"});
        ProgressBar pb = (ProgressBar)this.getControl("probarupdateclass");
        if (pb != null) {
            pb.addProgressListener((ProgresssListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.init();
    }

    public void init() {
        JSONArray illegalInvoice;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        logger.info("H5InvoiceVerifyListPlugin-\u8bf7\u6c42\u53c2\u6570", (Object)customParams);
        if (MapUtils.isEmpty((Map)customParams)) {
            return;
        }
        JSONArray legalInvoice = (JSONArray)customParams.get("importInvoice");
        if (!CollectionUtils.isEmpty((Collection)legalInvoice)) {
            this.fillEntryEntity(legalInvoice, LEGAL_ENTITY);
            this.updateInvoiceNum("legal", legalInvoice.size());
        }
        if (!CollectionUtils.isEmpty((Collection)(illegalInvoice = (JSONArray)customParams.get("filterInvoice")))) {
            this.fillEntryEntity(illegalInvoice, ILLEGAL_ENTITY);
            this.updateInvoiceNum("illegal", illegalInvoice.size());
        }
        if (illegalInvoice.size() > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25!\u5b58\u5728%1$s\u5f20\u53d1\u7968\u4e0d\u7b26\u5408\u5bfc\u5165\u89c4\u5219\uff0c\u8bf7\u70b9\u51fb\u53d1\u7968\u8be6\u60c5\u67e5\u770b\u5931\u8d25\u539f\u56e0", (String)"H5InvoiceVerifyListPlugin_14", (String)"imc-rim-formplugin", (Object[])new Object[0]), illegalInvoice.size()), Integer.valueOf(2500));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("operation".equals(key) || "operation_1".equals(key)) {
            MobileFormShowParameter moreForm = new MobileFormShowParameter();
            moreForm.setFormId("rim_h5_common_operate");
            moreForm.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().getPageCache().put("operateKey", key);
            if ("operation".equals(key)) {
                this.getView().getPageCache().put("click_row", String.valueOf(control.getModel().getEntryCurrentRowIndex(LEGAL_ENTITY)));
            } else {
                this.getView().getPageCache().put("click_row", String.valueOf(control.getModel().getEntryCurrentRowIndex(ILLEGAL_ENTITY)));
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_h5_common_operate");
            moreForm.setCloseCallBack(closeCallBack);
            moreForm.setCustomParam("showOperate", Arrays.asList(OperateType.DELETE.getCode(), OperateType.CANCEL.getCode()));
            this.getView().showForm((FormShowParameter)moreForm);
        }
        if ("import".equals(key)) {
            int legalRowCount = this.getModel().getEntryRowCount(LEGAL_ENTITY);
            if (legalRowCount <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5bfc\u5165\u5408\u89c4\u6570\u636e", (String)"H5InvoiceVerifyListPlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent((Object)key);
            this.getView().close();
        }
        if ("cancel".equals(key)) {
            Map params = FpzsMainService.getCustomParam((String)this.getView().getPageId());
            String indexPageId = (String)params.get("indexPageId");
            CacheHelper.remove((String)(indexPageId + "cache_selected_invoice"));
            CacheHelper.remove((String)(indexPageId + "cache_selected_attach"));
            this.getView().returnDataToParent((Object)key);
            if (this.getView().getParentView() != null) {
                this.getView().getParentView().returnDataToParent((Object)key);
                this.getView().getParentView().close();
            }
            this.getView().close();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry clickCardEntry = (CardEntry)evt.getSource();
        int currentRow = evt.getRow();
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String indexPageId = (String)customParams.get("indexPageId");
        String showAttach = (String)customParams.get("showAttach");
        param.put("row", currentRow);
        param.put("indexPageId", indexPageId);
        param.put("showAttach", showAttach);
        if (LEGAL_ENTITY.equals(clickCardEntry.getEntryKey())) {
            param.put("invoice", this.getModel().getValue("invoice_info", currentRow));
            this.getView().getPageCache().put("operateKey", "operation");
        } else {
            param.put("invoice", this.getModel().getValue("invoice_info1", currentRow));
            this.getView().getPageCache().put("operateKey", "operation_1");
        }
        this.getView().getPageCache().put("click_row", String.valueOf(currentRow));
        this.getView().getPageCache().put("entity", clickCardEntry.getEntryKey());
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setFormId("rim_h5_inv_verify_detail");
        H5PluginService.setCommonParam(param, (Map)this.getView().getFormShowParameter().getCustomParams());
        showParameter.setCustomParams(param);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rim_h5_inv_verify_detail"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String clickOperation = this.getView().getPageCache().get("operateKey");
        String clickRow = this.getView().getPageCache().get("click_row");
        if ("rim_h5_common_operate".equals(actionId)) {
            OperateType returnData = (OperateType)closedCallBackEvent.getReturnData();
            if (ObjectUtils.isEmpty((Object)returnData)) {
                return;
            }
            if (ObjectUtils.isEmpty((Object)clickOperation) || ObjectUtils.isEmpty((Object)clickRow)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u70b9\u51fb\u7684\u5bf9\u8c61", (String)"H5InvoiceVerifyListPlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (OperateType.DELETE == returnData) {
                this.deleteCurrentInvoice(Boolean.FALSE);
            }
        }
        if ("rim_h5_inv_verify_detail".equals(actionId)) {
            if (ObjectUtils.isEmpty((Object)closedCallBackEvent.getReturnData())) {
                return;
            }
            if (ObjectUtils.isEmpty((Object)clickOperation) || ObjectUtils.isEmpty((Object)clickRow)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u70b9\u51fb\u7684\u5bf9\u8c61", (String)"H5InvoiceVerifyListPlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            if ("delete".equals(closedCallBackEvent.getReturnData())) {
                this.deleteCurrentInvoice(Boolean.TRUE);
            }
        }
    }

    private void deleteCurrentInvoice(Boolean deleteOriginal) {
        List<Long> deletedAttaches;
        String serialNo;
        BigDecimal invoiceAmount;
        Long invoiceId;
        String clickOperation = this.getView().getPageCache().get("operateKey");
        String clickRowStr = this.getView().getPageCache().get("click_row");
        if (StringUtils.isBlank((CharSequence)clickOperation) || StringUtils.isBlank((CharSequence)clickRowStr)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u70b9\u51fb\u7684\u5bf9\u8c61", (String)"H5InvoiceVerifyListPlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        int clickRow = Integer.parseInt(clickRowStr);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String serial_no = String.valueOf(this.getModel().getValue("serial_no", clickRow));
        String serial_no1 = String.valueOf(this.getModel().getValue("serial_no1", clickRow));
        String indexPageId = (String)customParams.get("indexPageId");
        if ("operation".equals(clickOperation)) {
            invoiceId = Long.parseLong(this.getModel().getValue("id", clickRow).toString());
            invoiceAmount = (BigDecimal)this.getModel().getValue("total_amount", clickRow);
            this.getModel().deleteEntryRow(LEGAL_ENTITY, clickRow);
            serialNo = serial_no;
            this.updateInvoiceNum("legal", this.getModel().getEntryRowCount(LEGAL_ENTITY));
            String json = this.getView().getParentView().getPageCache().get("importInvoice");
            if (!StringUtils.isBlank((CharSequence)json)) {
                List legalInvoices = SerializationUtils.fromJsonStringToList((String)json, JSONObject.class);
                for (int i = 0; i < legalInvoices.size(); ++i) {
                    if (ObjectUtils.isEmpty(legalInvoices.get(i)) || !invoiceId.equals(((JSONObject)legalInvoices.get(i)).getLong("id"))) continue;
                    legalInvoices.remove(i);
                    break;
                }
                this.getView().getParentView().getPageCache().put("importInvoice", JSON.toJSONString((Object)legalInvoices));
            }
        } else {
            invoiceId = Long.parseLong(this.getModel().getValue("id1", clickRow).toString());
            invoiceAmount = (BigDecimal)this.getModel().getValue("total_amount1", clickRow);
            this.getModel().deleteEntryRow(ILLEGAL_ENTITY, clickRow);
            serialNo = serial_no1;
            this.updateInvoiceNum("illegal", this.getModel().getEntryRowCount(ILLEGAL_ENTITY));
        }
        if (deleteOriginal.booleanValue()) {
            boolean delResult = this.invoiceCollectService.delInvoice(serialNo);
            if (!delResult) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25!", (String)"H5InvoiceVerifyListPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            deletedAttaches = this.deletedAttaches(serialNo);
        } else {
            deletedAttaches = this.getInvoiceAttaches(serialNo);
        }
        HashMap<Long, BigDecimal> invoiceIds = new HashMap<Long, BigDecimal>(1);
        invoiceIds.put(invoiceId, invoiceAmount);
        AbstractOperateService.deleteSelected(indexPageId, invoiceIds, deletedAttaches);
    }

    private List<Long> getInvoiceAttaches(String serialNo) {
        QFilter invoiceFilters = new QFilter("relation_id", "=", (Object)serialNo);
        DynamicObjectCollection attachRelations = QueryServiceHelper.query((String)"rim_attach_relation", (String)"attach_id", (QFilter[])invoiceFilters.toArray());
        if (CollectionUtils.isEmpty((Collection)attachRelations)) {
            return null;
        }
        ArrayList<Long> attachesIds = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : attachRelations) {
            if (ObjectUtils.isEmpty((Object)dynamicObject)) continue;
            attachesIds.add(dynamicObject.getLong("attach_id"));
        }
        return attachesIds;
    }

    private List<Long> deletedAttaches(String serialNo) {
        if (StringUtils.isBlank((CharSequence)serialNo)) {
            return null;
        }
        QFilter attachRelationFilter = new QFilter("relation_type", "=", (Object)"3").and("relation_id", "=", (Object)serialNo);
        DynamicObjectCollection attachRelations = QueryServiceHelper.query((String)"rim_attach_relation", (String)"id", (QFilter[])attachRelationFilter.toArray());
        if (attachRelations.isEmpty()) {
            return null;
        }
        ArrayList<Long> relationAttachIds = new ArrayList<Long>(attachRelations.size());
        for (DynamicObject attach : attachRelations) {
            if (ObjectUtils.isEmpty((Object)attach)) continue;
            relationAttachIds.add(attach.getLong("id"));
        }
        ORM orm = ORM.create();
        QFilter attachFilter = new QFilter("attach_id", "in", relationAttachIds);
        DataSet needDeleteAttach = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_attach_relation", "attach_id as attach, count(1) as attach_num", attachFilter.toArray()).groupBy(new String[]{"attach"}).finish();
        ArrayList<Long> deleteAttachId = new ArrayList<Long>(8);
        while (needDeleteAttach.hasNext()) {
            Row row = needDeleteAttach.next();
            if (ObjectUtils.isEmpty((Object)row) || row.getLong("attach") == null || row.getInteger("attach_num") != 1) continue;
            deleteAttachId.add(row.getLong("attach"));
        }
        DeleteServiceHelper.delete((String)"rim_attach_relation", (QFilter[])attachRelationFilter.toArray());
        if (!CollectionUtils.isEmpty(deleteAttachId)) {
            QFilter deleteAttachFilter = new QFilter("id", "in", deleteAttachId);
            DeleteServiceHelper.delete((String)"rim_attach", (QFilter[])deleteAttachFilter.toArray());
        }
        return deleteAttachId;
    }

    private void fillEntryEntity(JSONArray invoiceArray, String listEntity) {
        H5InvoiceListService h5InvoiceListService = null;
        h5InvoiceListService = LEGAL_ENTITY.equals(listEntity) ? new H5InvoiceListService((AbstractFormPlugin)this, listEntity, "") : new H5InvoiceListService((AbstractFormPlugin)this, listEntity, "1");
        List invoiceList = h5InvoiceListService.arrayToListMap(invoiceArray, Boolean.FALSE);
        h5InvoiceListService.setInvoiceData(invoiceList);
        h5InvoiceListService.fillEntryEntity();
    }

    private void updateInvoiceNum(String flexName, Integer num) {
        HashMap<String, String> legalCtrl = new HashMap<String, String>(1);
        legalCtrl.put("flexabstract", String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20", (String)"H5InvoiceVerifyListPlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]), num));
        this.getView().updateControlMetadata(flexName, legalCtrl);
        if ("legal".equals(flexName)) {
            HashMap<String, LocaleString> legalButtonCtrl = new HashMap<String, LocaleString>(1);
            legalButtonCtrl.put("text", new LocaleString(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5408\u89c4\u53d1\u7968\uff08%1$s\uff09", (String)"H5InvoiceVerifyListPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), num)));
            this.getView().updateControlMetadata("import", legalButtonCtrl);
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        if (LEGAL_ENTITY.equals(this.getView().getPageCache().get("entity"))) {
            InvoiceClassService.getInstance().refreshListRow((AbstractFormPlugin)this, "invoice_class", "invoice_class_show", "id");
        } else if (ILLEGAL_ENTITY.equals(this.getView().getPageCache().get("entity"))) {
            InvoiceClassService.getInstance().refreshListRow((AbstractFormPlugin)this, "invoice_class1", "invoice_class_show1", "id1");
        }
    }
}

