/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.home;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.DateUtils;

public class InvoiceCountAnalysisPlugin
extends AbstractFormPlugin {
    private static final String RIM_INVOICE_SUM = "rim_invoice_sum";

    public void afterCreateNewData(EventObject e) {
        this.drawChart();
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.drawChart();
        }
    }

    private void drawChart() {
        CustomChart customchart = this.getMainChart();
        if (!ObjectUtils.isEmpty((Object)customchart)) {
            customchart.clearData();
        }
        GroupInfo groupInfo = this.getData();
        List<Number> sumAmount = groupInfo.getAmountList();
        Number maxAmount = 0;
        for (Number amount : sumAmount) {
            if (amount == null || amount.intValue() <= maxAmount.intValue()) continue;
            maxAmount = amount;
        }
        List<Number> sumCount = groupInfo.getCountList();
        Number maxCount = 0;
        for (Number count : sumCount) {
            if (count == null || count.intValue() <= maxCount.intValue()) continue;
            maxCount = count;
        }
        Axis categoryAxis = this.createCategoryAxis(ResManager.loadKDString((String)"", (String)"InvoiceCountAnalysisPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), true);
        categoryAxis.setCategorys(groupInfo.demensions);
        int amountInterval = Math.round(maxAmount.floatValue() / 6.0f);
        int countInterval = Math.round(maxCount.floatValue() / 6.0f);
        this.createValueAxis(ResManager.loadKDString((String)"\u4e07", (String)"InvoiceCountAnalysisPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), false, amountInterval);
        BarSeries countSeries = this.createBarSeries(ResManager.loadKDString((String)"\u91d1\u989d(\u4e07)", (String)"InvoiceCountAnalysisPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), groupInfo.amountList, "#5470c6");
        countSeries.setBarWidth("25%");
        this.createValueAxis(ResManager.loadKDString((String)"\u4efd", (String)"InvoiceCountAnalysisPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), false, countInterval);
        LineSeries amountSeries = this.createLineSeries(ResManager.loadKDString((String)"\u4efd\u6570", (String)"InvoiceCountAnalysisPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), groupInfo.countList, "#39bdb9");
        amountSeries.setYAxisIndex(1);
        customchart.setMargin(Position.left, "30px");
        customchart.setMargin(Position.right, "40px");
        customchart.setMargin(Position.top, "30px");
    }

    private GroupInfo getData() {
        QFilter filter = new QFilter("create_date", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)new Date())).and("org", "=", (Object)RequestContext.get().getOrgId());
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)RIM_INVOICE_SUM, (String)"id", (QFilter[])filter.toArray());
        ArrayList<String> demensions = new ArrayList<String>(8);
        ArrayList<Number> countList = new ArrayList<Number>(8);
        ArrayList<Number> amountList = new ArrayList<Number>(8);
        GroupInfo groupInfo = new GroupInfo();
        for (DynamicObject obj : objs) {
            if (ObjectUtils.isEmpty((Object)obj)) continue;
            obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)RIM_INVOICE_SUM);
            Long invoiceType = obj.getLong("input_invoice_type_id");
            int sumCount = obj.getInt("sum_count");
            BigDecimal amount = obj.getBigDecimal("total_amount").divide(new BigDecimal(10000)).setScale(2, 1);
            InputInvoiceTypeEnum tt = InputInvoiceTypeEnum.getInvoiceType((Long)invoiceType);
            if (tt == null) continue;
            String typeName = tt.getName();
            demensions.add(typeName);
            countList.add(sumCount);
            amountList.add(amount);
        }
        groupInfo.setDemensions(demensions);
        groupInfo.setAmountList(amountList);
        groupInfo.setCountList(countList);
        return groupInfo;
    }

    private Axis createCategoryAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.category) : this.getMainChart().createYAxis(name, AxisType.category);
        HashMap<String, Integer> axisTick = new HashMap<String, Integer>();
        axisTick.put("interval", 0);
        HashMap<String, Object> axisLabel = new HashMap<String, Object>();
        axisLabel.put("show", Boolean.TRUE);
        axisLabel.put("rotate", 36);
        axisLabel.put("interval", 0);
        axisLabel.put("color", "black");
        axis.setPropValue("axisTick", axisTick);
        axis.setPropValue("axisLabel", axisLabel);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private Axis createValueAxis(String name, boolean isX, Number interval) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.value) : this.getMainChart().createYAxis(name, AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(8);
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap(8);
        HashMap<String, String> lineStyle = new HashMap<String, String>(8);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        axis.setInterval(interval);
        this.setLineColor(axis, "#999999");
        this.getMainChart().setShowTooltip(true);
        return axis;
    }

    private BarSeries createBarSeries(String name, List<Number> values, String color) {
        BarSeries barSeries = this.getMainChart().createBarSeries(name);
        barSeries.setItemColor(color);
        barSeries.setAnimationDuration(2000);
        barSeries.setData(values.toArray(new Number[0]));
        return barSeries;
    }

    private LineSeries createLineSeries(String name, List<Number> values, String color) {
        LineSeries expireSeries = this.getMainChart().createLineSeries(name);
        expireSeries.setItemColor(color);
        expireSeries.setAnimationDuration(2000);
        expireSeries.setData(values.toArray(new Number[0]));
        return expireSeries;
    }

    private CustomChart getMainChart() {
        return (CustomChart)this.getControl("customchartap");
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap(4);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(4);
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private static class GroupInfo {
        private List<String> demensions = new ArrayList<String>(8);
        private List<Number> countList = new ArrayList<Number>(8);
        private List<Number> amountList = new ArrayList<Number>(8);

        private GroupInfo() {
        }

        public List<String> getDemensions() {
            return this.demensions;
        }

        public void setDemensions(List<String> demensions) {
            this.demensions = demensions;
        }

        public List<Number> getCountList() {
            return this.countList;
        }

        public void setCountList(List<Number> countList) {
            this.countList = countList;
        }

        public List<Number> getAmountList() {
            return this.amountList;
        }

        public void setAmountList(List<Number> amountList) {
            this.amountList = amountList;
        }
    }
}

