/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.home;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.helper.ImcSaveServiceHelper;
import kd.imc.rim.common.utils.DBUtils;
import kd.imc.rim.common.utils.DateUtils;

public class InvoiceHomeTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(InvoiceHomeTask.class);
    public static final String RIM_INVOICE = "rim_invoice";
    private static final String RIM_INVOICE_SUM = "rim_invoice_sum";
    private static final String CREATE_TIME = "createtime";
    public static final String EXCEPTION_INVOICE_MONTHLY_KEY = "exception_invoice_monthly";
    public static final String EXCEPTION_INVOICE_ALL_KEY = "exception_invoice_all";
    public static final String EXCEPTION_INVOICE_CARD_KEY = "exception_invoice_title";
    private static Date lastDate = DateUtils.getFirstDateOfMonth((Date)new Date());

    public void execute(RequestContext requestContext, Map<String, Object> arg1) throws KDException {
        LOGGER.info("\u8fdb\u9879\u53d1\u7968\u9996\u9875\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb... \u4e0a\u6b21\u7edf\u8ba1\u53d1\u7968\u6570\u636e\u65f6\u95f4\uff1a" + DateUtils.format((Date)lastDate, (String)"yyyy-MM-dd hh:mm:ss"));
        Date firstDateOfTheMonth = DateUtils.getFirstDateOfMonth((Date)new Date());
        ORM orm = ORM.create();
        QFilter timeFilter = new QFilter(CREATE_TIME, ">=", (Object)firstDateOfTheMonth);
        QFilter deleteFilter = new QFilter("delete", "=", (Object)"1");
        HashMap<Long, Map<Long, DataSummarization>> allData = new HashMap<Long, Map<Long, DataSummarization>>(16);
        String sumAmountAndReceiveSql = "select finvoice_type as type, forg_id as org, foriginal_state as original, count(foriginal_state) as originalnum, sum(finvoice_amount) as amount, sum(ftotal_tax_amount) as tax, sum(ftotal_amount) as total from t_rim_invoice where fcreatetime >= ? and  fdelete = ? group by finvoice_type, forg_id, foriginal_state";
        Object[] amountParam = new Object[]{firstDateOfTheMonth, "1"};
        JSONArray amountArray = DBUtils.queryJSONArray((String)sumAmountAndReceiveSql, (Object[])amountParam);
        this.setSumData(amountArray, allData);
        String authSql = "select finvoice_type as type, forg_id as org, fauthenticate_flag as auth, count(fauthenticate_flag) as authnum from t_rim_invoice where fcreatetime >= ? and  fdelete = ? group by finvoice_type, forg_id, fauthenticate_flag";
        Object[] authParam = new Object[]{firstDateOfTheMonth, "1"};
        JSONArray authArray = DBUtils.queryJSONArray((String)authSql, (Object[])authParam);
        this.setSumData(authArray, allData);
        QFilter removeFilter = new QFilter("create_date", ">=", (Object)firstDateOfTheMonth);
        DeleteServiceHelper.delete((String)RIM_INVOICE_SUM, (QFilter[])removeFilter.toArray());
        ArrayList<DynamicObject> sumDatas = new ArrayList<DynamicObject>(InputInvoiceTypeEnum.values().length + 1);
        if (CollectionUtils.isEmpty(allData)) {
            return;
        }
        for (Map.Entry orgData : allData.entrySet()) {
            if (ObjectUtils.isEmpty(orgData) || ObjectUtils.isEmpty(orgData.getKey()) || ObjectUtils.isEmpty(orgData.getValue())) continue;
            Long org = (Long)orgData.getKey();
            Map typeDataMap = (Map)orgData.getValue();
            for (Map.Entry entry : typeDataMap.entrySet()) {
                if (ObjectUtils.isEmpty(entry) || ObjectUtils.isEmpty(entry.getValue())) continue;
                Long type = (Long)entry.getKey();
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)RIM_INVOICE_SUM);
                obj.set("create_date", (Object)new Date());
                int received = ((DataSummarization)entry.getValue()).getReceived();
                int unreceived = ((DataSummarization)entry.getValue()).getUnreceived();
                obj.set("sum_count", (Object)(unreceived + received));
                obj.set("data_date_time", (Object)new Date());
                obj.set("input_invoice_type", (Object)type);
                obj.set("amount", (Object)((DataSummarization)entry.getValue()).getSumAmount());
                obj.set("tax_amount", (Object)((DataSummarization)entry.getValue()).getSumTaxAmount());
                obj.set("total_amount", (Object)((DataSummarization)entry.getValue()).getSumTotalAmount());
                obj.set("received_count", (Object)received);
                obj.set("unreceive_count", (Object)unreceived);
                obj.set("certified_count", (Object)((DataSummarization)entry.getValue()).getAuthed());
                obj.set("uncertified_count", (Object)((DataSummarization)entry.getValue()).getUnauthed());
                obj.set("org", (Object)org);
                sumDatas.add(obj);
            }
        }
        if (sumDatas.size() > 0) {
            ImcSaveServiceHelper.save(sumDatas);
        }
        lastDate = new Date();
        LOGGER.info("\u8fdb\u9879\u53d1\u7968\u9996\u9875\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f...");
    }

    private Map<Long, Map<Long, DataSummarization>> setSumData(JSONArray dataArray, Map<Long, Map<Long, DataSummarization>> orgDataMap) {
        if (dataArray != null && dataArray.size() > 0) {
            for (int i = 0; i < dataArray.size(); ++i) {
                Long org;
                Long type;
                JSONObject queryData = dataArray.getJSONObject(i);
                if (queryData == null || queryData.isEmpty() || ObjectUtils.isEmpty((Object)(type = queryData.getLong("TYPE"))) || ObjectUtils.isEmpty((Object)(org = queryData.getLong("ORG")))) continue;
                Map<Long, DataSummarization> typeDataMap = this.getTypeDataMap(orgDataMap, org, type);
                DataSummarization data = typeDataMap.get(type);
                String original = queryData.getString("ORIGINAL");
                Integer originalNum = queryData.getInteger("ORIGINALNUM");
                BigDecimal invoiceAmount = queryData.getBigDecimal("AMOUNT");
                BigDecimal totalTaxAmount = queryData.getBigDecimal("TAX");
                BigDecimal totalAmount = queryData.getBigDecimal("TOTAL");
                String auth = queryData.getString("AUTH");
                Integer authNum = queryData.getInteger("AUTHNUM");
                if ("0".equals(original) && originalNum > 0) {
                    data.setUnreceived(originalNum + data.getUnreceived());
                }
                if ("1".equals(original) && originalNum > 0) {
                    data.setReceived(originalNum + data.getReceived());
                }
                if (!ObjectUtils.isEmpty((Object)invoiceAmount)) {
                    if (ObjectUtils.isEmpty((Object)data.getSumAmount())) {
                        data.setSumAmount(invoiceAmount);
                    } else {
                        data.setSumAmount(invoiceAmount.add(data.getSumAmount()));
                    }
                }
                if (!ObjectUtils.isEmpty((Object)totalTaxAmount)) {
                    if (ObjectUtils.isEmpty((Object)data.getSumTaxAmount())) {
                        data.setSumTaxAmount(totalTaxAmount);
                    } else {
                        data.setSumTaxAmount(totalTaxAmount.add(data.getSumTaxAmount()));
                    }
                }
                if (!ObjectUtils.isEmpty((Object)totalAmount)) {
                    if (ObjectUtils.isEmpty((Object)data.getSumTotalAmount())) {
                        data.setSumTotalAmount(totalAmount);
                    } else {
                        data.setSumTotalAmount(totalAmount.add(data.getSumTotalAmount()));
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)auth) && authNum != null && authNum > 0 && ("2".equals(auth) || "3".equals(auth))) {
                    data.setAuthed(authNum + data.getAuthed());
                    continue;
                }
                if (authNum == null || authNum <= 0) continue;
                data.setUnauthed(authNum + data.getUnauthed());
            }
        }
        return orgDataMap;
    }

    private Map<Long, DataSummarization> getTypeDataMap(Map<Long, Map<Long, DataSummarization>> orgDataMap, Long org, Long type) {
        Map<Object, Object> typeDataMap;
        if (CollectionUtils.isEmpty(orgDataMap)) {
            typeDataMap = new HashMap(16);
            orgDataMap.put(org, typeDataMap);
            DataSummarization data = new DataSummarization();
            typeDataMap.put(type, data);
        } else {
            typeDataMap = orgDataMap.get(org);
            if (CollectionUtils.isEmpty(typeDataMap)) {
                typeDataMap = new HashMap(16);
                orgDataMap.put(org, typeDataMap);
                DataSummarization data = new DataSummarization();
                typeDataMap.put(type, data);
            } else {
                DataSummarization data = (DataSummarization)typeDataMap.get(type);
                if (ObjectUtils.isEmpty((Object)data)) {
                    data = new DataSummarization();
                    typeDataMap.put(type, data);
                }
            }
        }
        return typeDataMap;
    }

    static class DataSummarization {
        private BigDecimal sumAmount;
        private BigDecimal sumTaxAmount;
        private BigDecimal sumTotalAmount;
        private int received = 0;
        private int unreceived = 0;
        private int authed = 0;
        private int unauthed;

        DataSummarization() {
        }

        public BigDecimal getSumAmount() {
            return this.sumAmount;
        }

        public void setSumAmount(BigDecimal sumAmount) {
            this.sumAmount = sumAmount;
        }

        public BigDecimal getSumTaxAmount() {
            return this.sumTaxAmount;
        }

        public void setSumTaxAmount(BigDecimal sumTaxAmount) {
            this.sumTaxAmount = sumTaxAmount;
        }

        public BigDecimal getSumTotalAmount() {
            return this.sumTotalAmount;
        }

        public void setSumTotalAmount(BigDecimal sumTotalAmount) {
            this.sumTotalAmount = sumTotalAmount;
        }

        public int getReceived() {
            return this.received;
        }

        public void setReceived(int received) {
            this.received = received;
        }

        public int getUnreceived() {
            return this.unreceived;
        }

        public void setUnreceived(int unreceived) {
            this.unreceived = unreceived;
        }

        public int getAuthed() {
            return this.authed;
        }

        public void setAuthed(int authed) {
            this.authed = authed;
        }

        public int getUnauthed() {
            return this.unauthed;
        }

        public void setUnauthed(int unauthed) {
            this.unauthed = unauthed;
        }
    }
}

