/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.home;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.IconAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.report.ReportShowParameter;
import kd.imc.rim.common.utils.ImcConfigUtil;
import org.apache.commons.lang.StringUtils;

public class InvoiceMenuOfTabPlugin
extends AbstractFormPlugin {
    private static final String CENTER = "center";
    private static final String ICON_PREFIX = "iconap";
    private static final String CACHE_APP = "keyIdToApp";
    private static final String PARAM_MENU = "menu";
    private static final String CACHE_FORMPAGE = "formPage";
    private static final String CONFIG_TYPE_KEY = "rim_menu";
    private static final Map<String, String> KEY_IDS;

    public void afterCreateNewData(EventObject e) {
        Label label;
        List menuList;
        String menu = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_MENU);
        if (StringUtils.isEmpty((String)menu)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6253\u5f00\u83dc\u5355\u5931\u8d25\uff0c\u672a\u8bbe\u7f6e\u83dc\u5355\u9009\u9879\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InvoiceMenuOfTabPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String menuConfig = ImcConfigUtil.getValue((String)CONFIG_TYPE_KEY, (String)menu);
        if (StringUtils.isEmpty((String)menuConfig)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6253\u5f00\u83dc\u5355\u5931\u8d25\uff0c\u672a\u627e\u5230\u5f53\u524d\u83dc\u5355\u5206\u7c7b\uff1a%1$s\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InvoiceMenuOfTabPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), menu));
            return;
        }
        List<String> formIdList = Arrays.asList(menuConfig.split(","));
        if (formIdList == null || formIdList.isEmpty()) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6253\u5f00\u83dc\u5355\u5931\u8d25\uff0c\u672a\u627e\u5230\u5f53\u524d\u83dc\u5355\u5206\u7c7b\uff1a%1$s\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InvoiceMenuOfTabPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), menu));
            return;
        }
        List<AppMenuInfo> needShowList = this.getShowAllMenu(this.getMenuMap(AppMetadataCache.getAppMenusInfoByAppId((String)"rim")), KEY_IDS.get(menu));
        HashMap keyMenus = Maps.newHashMapWithExpectedSize((int)needShowList.size());
        for (AppMenuInfo appMenuInfo : needShowList) {
            String formId = appMenuInfo.getFormId();
            menuList = (List)keyMenus.get(formId);
            if (menuList == null) {
                menuList = Lists.newArrayListWithExpectedSize((int)needShowList.size());
                keyMenus.put(formId, menuList);
            }
            menuList.add(appMenuInfo);
        }
        int maxCount = 0;
        for (String formId : formIdList) {
            menuList = (List)keyMenus.get(formId);
            if (menuList == null) continue;
            for (AppMenuInfo appMenuInfo : menuList) {
                String nodeName = appMenuInfo.getName().getLocaleValue();
                String iconUrl = appMenuInfo.getShortcutIcon();
                this.creatLaunchNode(appMenuInfo.getFormId(), nodeName, iconUrl, maxCount);
                this.getPageCache().put("keyIdToApp_iconap" + maxCount, JSONObject.toJSONString((Object)appMenuInfo));
                ++maxCount;
            }
        }
        if (!needShowList.isEmpty() && (label = (Label)this.getControl("title")) != null) {
            label.setText(formIdList.get(0));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.startsWith(ICON_PREFIX)) {
            String appStr = this.getPageCache().get("keyIdToApp_" + key);
            if (StringUtils.isBlank((String)appStr)) {
                return;
            }
            AppMenuInfo appMenuInfo = (AppMenuInfo)JSONObject.parseObject((String)appStr, AppMenuInfo.class);
            String formId = appMenuInfo.getFormId();
            String paramType = appMenuInfo.getParamType();
            FormShowParameter fsp = new FormShowParameter();
            if (StringUtils.equals((String)paramType, (String)"ListShowParameter")) {
                fsp = new ListShowParameter();
                ((ListShowParameter)fsp).setBillFormId(formId);
                fsp.setFormId("bos_list");
            } else if (StringUtils.equals((String)paramType, (String)"ReportShowParameter")) {
                fsp = new ReportShowParameter();
                fsp.setFormId(formId);
            } else {
                fsp.setFormId(formId);
            }
            String pageID = this.getPageCache().get("formPage_" + key);
            IFormView childView = this.getView().getViewNoPlugin(pageID);
            if (pageID != null && childView != null) {
                childView.getFormShowParameter().setHasRight(true);
                childView.activate();
                this.getView().sendFormAction(childView);
            } else {
                String param = appMenuInfo.getParams();
                if (StringUtils.isNotBlank((String)param)) {
                    JSONObject paramJson = JSONObject.parseObject((String)param);
                    fsp.getCustomParams().putAll(paramJson.getInnerMap());
                }
                fsp.getCustomParams().put("currentPageKey", "formPage_" + key);
                fsp.getOpenStyle().setShowType(ShowType.NewTabPage);
                fsp.getOpenStyle().setTargetKey("tabap");
                fsp.setCaption(appMenuInfo.getName().getLocaleValue());
                String markId = appMenuInfo.getId();
                boolean existView = true;
                String menuPageID = markId;
                while (existView) {
                    menuPageID = markId + "_" + kd.bos.login.utils.StringUtils.randomNumber((int)16);
                    existView = this.getView().existView(menuPageID);
                }
                fsp.setPageId(menuPageID);
                this.getPageCache().put("formPage_" + key, menuPageID);
                this.getView().showForm(fsp);
            }
        }
    }

    private void creatLaunchNode(String formId, String nodeName, String iconUrl, int maxCount) {
        this.getPageCache().put("cache_click_key", "" + maxCount);
        FlexPanelAp flexAp = new FlexPanelAp();
        flexAp.setKey("dflexpanel" + maxCount);
        flexAp.setDirection("column");
        flexAp.setAlignItems(CENTER);
        flexAp.setGrow(0);
        flexAp.setJustifyContent(CENTER);
        flexAp.setAlignItems(CENTER);
        flexAp.setShrink(0);
        flexAp.setWidth(new LocaleString("100px"));
        flexAp.setOverflow("hidden");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("12px");
        margin.setLeft("12px");
        style.setMargin(margin);
        flexAp.setStyle(style);
        IconAp icon = new IconAp();
        icon.setKey(ICON_PREFIX + maxCount);
        icon.setName(new LocaleString(nodeName));
        if (StringUtils.isEmpty((String)iconUrl)) {
            icon.setImageKey("/icons/pc/entrance/default_48_48.png");
        } else {
            icon.setImageKey(iconUrl);
        }
        icon.setHeight(new LocaleString("48px"));
        icon.setWidth(new LocaleString("48px"));
        icon.setRadius("6px");
        icon.setImageZoom(true);
        style = new Style();
        margin = new Margin();
        margin.setBottom("3px");
        style.setMargin(margin);
        icon.setStyle(style);
        LabelAp label = new LabelAp();
        label.setKey("dlabel" + maxCount);
        label.setName(new LocaleString(nodeName));
        label.setWidth(new LocaleString("100px"));
        label.setHeight(new LocaleString("31px"));
        label.setTextAlign(CENTER);
        label.setAutoTextWrap(true);
        label.setLineHeight("15px");
        style = new Style();
        margin = new Margin();
        margin.setBottom("3px");
        style.setMargin(margin);
        label.setStyle(style);
        flexAp.getItems().add(icon);
        flexAp.getItems().add(label);
        Container c = (Container)((Container)((Tab)this.getControl("tabap")).getItems().get(0)).getItems().get(0);
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(flexAp.createControl());
        c.insertControls(maxCount, list);
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.startsWith(ICON_PREFIX)) {
            Button button = new Button();
            button.setKey(key);
            button.setView(this.getView());
            button.addClickListener((ClickListener)this);
            e.setControl((Control)button);
        }
    }

    private Map<String, List<AppMenuInfo>> getMenuMap(List<AppMenuInfo> allMenuList) {
        HashMap menuListMap = Maps.newHashMapWithExpectedSize((int)allMenuList.size());
        for (AppMenuInfo menuInfo : allMenuList) {
            String parentd = menuInfo.getParentId();
            List menuList = (List)menuListMap.get(parentd);
            if (menuList == null) {
                menuList = Lists.newArrayListWithExpectedSize((int)allMenuList.size());
                menuListMap.put(parentd, menuList);
            }
            menuList.add(menuInfo);
        }
        return menuListMap;
    }

    private List<AppMenuInfo> getShowAllMenu(Map<String, List<AppMenuInfo>> menuListMap, String menuId) {
        ArrayList menuList = Lists.newArrayList();
        List<AppMenuInfo> menuIdList = menuListMap.get(menuId);
        if (menuIdList != null) {
            menuList.addAll(menuIdList);
            int count = menuIdList.size();
            for (int i = 0; i < count; ++i) {
                menuList.addAll(this.getShowAllMenu(menuListMap, menuIdList.get(i).getId()));
            }
        }
        return menuList;
    }

    static {
        HashMap keyIds = Maps.newHashMap();
        keyIds.put("sync", "1117307512249428992");
        keyIds.put("collect", "1301408445479519232");
        keyIds.put("deduct", "1112205346694571008");
        keyIds.put("out", "1386086372611232768");
        keyIds.put("warn", "1274461397954069504");
        keyIds.put("report", "1274461397954069504");
        keyIds.put("base", "1204865802348787712");
        keyIds.put("down", "1489184127805854720");
        KEY_IDS = Collections.unmodifiableMap(keyIds);
    }
}

