/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.message.BusinessSystemService;
import kd.imc.rim.common.message.constant.OpenApiInterfaceCodeEnum;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.message.vo.RequestVo;
import kd.imc.rim.formplugin.message.service.OpenApiService;
import kd.imc.rim.formplugin.message.service.RimApiHelper;

public class OpenApiPlugin
implements IBillWebApiPlugin {
    private static Log LOGGER = LogFactory.getLog(OpenApiPlugin.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        if (null == params) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u65e0\u6548\uff0c\u8bf7\u6838\u5bf9!", (String)"OpenApiPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)ErrorType.PARAM_ERROR.getCode());
        }
        LOGGER.info("rim-openApi\u539f\u59cb\u4f20\u5165\u53c2\u6570{}", (Object)JSON.toJSONString(params));
        RequestVo requestVo = (RequestVo)JSON.parseObject((String)JSON.toJSONString(params), RequestVo.class);
        ApiResult apiResult = RimApiHelper.apiCommonCheckValid(requestVo);
        if (!apiResult.getSuccess()) {
            return apiResult;
        }
        OpenApiInterfaceCodeEnum apiCode = OpenApiInterfaceCodeEnum.getInterfaceByCode((String)requestVo.getInterfaceCode());
        if (null == apiCode || StringUtils.isEmpty((CharSequence)apiCode.getImpl())) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u63a5\u53e3[%s]", (String)"OpenApiPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), requestVo.getInterfaceCode()), (String)ErrorType.PARAM_ERROR.getCode());
        }
        DynamicObject businessSys = null;
        try {
            businessSys = BusinessSystemService.getBusinessSystemByCode((String)requestVo.getBusinessSystemCode());
            RimApiHelper.decryptData(requestVo, businessSys);
            LOGGER.info("rim-openApi\u4f20\u5165\u53c2\u6570(\u89e3\u5bc6\u540e):{}", (Object)JSON.toJSONString((Object)requestVo));
            Class<?> clazz = Class.forName(apiCode.getImpl());
            OpenApiService openApiService = (OpenApiService)clazz.newInstance();
            ApiResult result = openApiService.doBusiness(requestVo);
            if (null != result.getData() && StringUtils.isNotBlank((CharSequence)result.getData().toString())) {
                result.setData((Object)BusinessSystemService.getDecryptData((DynamicObject)businessSys, (int)0, (String)result.getData().toString()));
            }
            return result;
        }
        catch (MsgException e) {
            return ApiResult.fail((String)e.getErrorMsg(), (String)e.getErrorCode());
        }
        catch (Exception e) {
            LOGGER.error("rim-openApi\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            String errorMsg = e.getMessage();
            return ApiResult.fail((String)(StringUtils.isEmpty((CharSequence)errorMsg) ? ResManager.loadKDString((String)"\u7cfb\u7edf\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!", (String)"OpenApiPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]) : errorMsg), (String)ErrorType.PARAM_ERROR.getCode());
        }
    }
}

