/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.expense.domain.ExpenseCoverDTO;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.domain.ExpenseInvoiceDTO;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.expense.service.InvoiceImageNotifyService;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.formplugin.message.service.AbstractMessageServie;
import org.apache.commons.lang3.StringUtils;

public class BillSaveService
extends AbstractMessageServie {
    private static Log LOGGER = LogFactory.getLog(BillSaveService.class);

    @Override
    public ApiResult doBusiness(Object reqObject) {
        String json = SerializationUtils.toJsonString((Object)reqObject);
        LOGGER.info("\u62a5\u9500\u5355\u4fdd\u5b58\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a" + json);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        ExpenseDTO dto = new ExpenseDTO();
        dto.setExpenseId(jsonObj.getString("billId"));
        dto.setExpenseNum(jsonObj.getString("billNo"));
        dto.setResource(jsonObj.getString("resource"));
        dto.setEntityId(jsonObj.getString("billType"));
        dto.setExpenseType(jsonObj.getString("billType"));
        dto.setOriginalId(jsonObj.getString("originalId"));
        dto.setOriginalType(jsonObj.getString("originalType"));
        if (StringUtils.isNotEmpty((CharSequence)dto.getOriginalId()) && StringUtils.isEmpty((CharSequence)dto.getOriginalType())) {
            dto.setOriginalType(dto.getEntityId());
        }
        dto.setStatus(jsonObj.getString("status"));
        Long orgId = this.getOrgIdByNumber(jsonObj.getString("orgNumber"));
        dto.setOrgId(orgId);
        JSONArray array = jsonObj.getJSONArray("invoiceData");
        ArrayList<ExpenseInvoiceDTO> list = new ArrayList<ExpenseInvoiceDTO>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            JSONObject invoice = array.getJSONObject(i);
            ExpenseInvoiceDTO invoiceDto = new ExpenseInvoiceDTO();
            invoiceDto.setSerialNo(invoice.getString("serialNo"));
            invoiceDto.setDeductionAmount(invoice.getBigDecimal("deductionTaxAmount"));
            invoiceDto.setEffectiveTaxAmount(invoice.getBigDecimal("effectiveTaxAmount"));
            invoiceDto.setDeductionFlag(invoice.getString("deductionFlag"));
            invoiceDto.setOutputAmount(invoice.getBigDecimal("outputAmount"));
            invoiceDto.setRemark(invoice.getString("remark"));
            invoiceDto.setEntryId(invoice.getString("entryId"));
            invoiceDto.setDeductionPurpose(invoice.getString("deductionPurpose"));
            try {
                invoiceDto.setExtInfo(invoice.getJSONObject("extInfo"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            list.add(invoiceDto);
        }
        dto.setInvoiceList(list);
        dto.setAttachList(jsonObj);
        Object coverData1 = jsonObj.get((Object)"coverData");
        JSONObject coverData = null;
        if (coverData1 instanceof JSONArray && ((JSONArray)coverData1).size() > 0) {
            coverData = ((JSONArray)coverData1).getJSONObject(0);
        } else if (coverData1 instanceof JSONObject) {
            coverData = (JSONObject)coverData1;
        }
        if (coverData != null) {
            ArrayList<ExpenseCoverDTO> coverList = new ArrayList<ExpenseCoverDTO>(1);
            ExpenseCoverDTO expenseCoverDTO = new ExpenseCoverDTO();
            expenseCoverDTO.setCoverNo(coverData.getString("coveNo"));
            expenseCoverDTO.setBase64(coverData.getString("base64"));
            String type = coverData.getString("coveType");
            if (type != null && (type.equalsIgnoreCase("pdf") || "1".equals(type))) {
                expenseCoverDTO.setFileType(Integer.valueOf(1));
            } else {
                expenseCoverDTO.setFileType(Integer.valueOf(2));
            }
            coverList.add(expenseCoverDTO);
            dto.setCoverDTOList(coverList);
            jsonObj.remove((Object)"coverData");
            jsonObj.put("coverMsg", (Object)String.format(ResManager.loadKDString((String)"\u5c01\u9762\u6570\u91cf%1$s", (String)"BillSaveService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), coverList.size()));
        }
        ExpenseService service = new ExpenseService();
        service.save(dto);
        InvoiceLog.insertExpenseLog((String)"api\u4fdd\u5b58\u5355\u636e", (String)dto.getExpenseId(), (String)dto.getExpenseNum(), (String)json);
        if (StringUtils.equals((CharSequence)"1", (CharSequence)jsonObj.getString("needCoverNo"))) {
            String imageNumber = InvoiceImageNotifyService.getImageNumber((String)dto.getExpenseType(), (String)dto.getExpenseId());
            if (StringUtils.isBlank((CharSequence)imageNumber)) {
                imageNumber = InvoiceImageNotifyService.createImageNumber((String)dto.getExpenseId(), (String)dto.getExpenseNum(), (String)RequestContext.get().getUserId(), (String)(RequestContext.get().getOrgId() + ""), (String)dto.getExpenseType());
            }
            if (StringUtils.isNotBlank((CharSequence)imageNumber)) {
                ArrayList<ExpenseCoverDTO> coverList = new ArrayList<ExpenseCoverDTO>(1);
                ExpenseCoverDTO expenseCoverDTO = new ExpenseCoverDTO();
                coverList.add(expenseCoverDTO);
                expenseCoverDTO.setCoverNo(imageNumber);
                expenseCoverDTO.setBase64("");
                expenseCoverDTO.setFileType(Integer.valueOf(1));
                dto.setCoverDTOList(coverList);
            }
            InvoiceImageNotifyService.imageNotify((ExpenseDTO)dto);
            ApiResult results = this.successResult();
            JSONObject obj = new JSONObject();
            obj.put("coveNo", (Object)((ExpenseCoverDTO)dto.getCoverDTOList().get(0)).getCoverNo());
            results.setData((Object)obj.toJSONString());
            return results;
        }
        return this.successResult();
    }
}

