/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.message.BusinessSystemService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.message.vo.RequestVo;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.TenantUtils;

public class RimApiHelper {
    private static Log LOGGER = LogFactory.getLog(RimApiHelper.class);

    public static Long getOrgId(Object orgId, String orgNumber, String taxNo) {
        Long org = BigDecimalUtil.transDecimal((Object)orgId).longValue();
        if (org > 0L) {
            return org;
        }
        org = TenantUtils.getOrgByNumberOrTaxNo((String)orgNumber, (String)taxNo);
        if (org > 0L) {
            return org;
        }
        return RequestContext.get().getOrgId();
    }

    public static DynamicObject decryptData(RequestVo requestVo, DynamicObject businessSys) {
        String businessData;
        try {
            businessData = BusinessSystemService.getDecryptData((DynamicObject)businessSys, (int)1, (String)requestVo.getData());
        }
        catch (Exception e) {
            LOGGER.error("openApi\u6570\u636e\u52a0\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u6570\u636e\u89e3\u5bc6\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\u52a0\u5bc6\u65b9\u5f0f", (String)"RimApiHelper_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)businessData)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u6570\u636e\u89e3\u5bc6\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\u52a0\u5bc6\u65b9\u5f0f", (String)"RimApiHelper_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        requestVo.setData(businessData);
        return businessSys;
    }

    public static ApiResult apiCommonCheckValid(RequestVo requestVo) {
        if (null == requestVo) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u65e0\u6548\uff0c\u8bf7\u6838\u5bf9!", (String)"RimApiHelper_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)ErrorType.PARAM_ERROR.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)requestVo.getInterfaceCode())) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570interfaceCode\u672a\u4f20\u5165\u503c", (String)"RimApiHelper_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)ErrorType.PARAM_ERROR.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)requestVo.getBusinessSystemCode())) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570businessSystemCode\u672a\u4f20\u5165\u503c", (String)"RimApiHelper_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)ErrorType.PARAM_ERROR.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)requestVo.getData())) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570data\u672a\u4f20\u5165\u503c", (String)"RimApiHelper_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)ErrorType.PARAM_ERROR.getCode());
        }
        return ApiResult.success((Object)"");
    }

    public static ApiResult convertApiResult(Map<String, Object> result) {
        return RimApiHelper.convertApiResult(result, "");
    }

    public static ApiResult convertApiResult(Map<String, Object> result, String reqName) {
        if (ObjectUtils.isEmpty(result)) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"%s\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RimApiHelper_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), reqName), (String)ErrorType.PARAM_ERROR.getCode());
        }
        ApiResult apiResult = new ApiResult();
        apiResult.setErrorCode((String)result.get("errcode"));
        apiResult.setMessage((String)result.get("description"));
        if (null != result.get("data")) {
            apiResult.setData(result.get("data"));
        }
        apiResult.setSuccess(ErrorType.SUCCESS.getCode().equals(apiResult.getErrorCode()));
        return apiResult;
    }
}

