/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service.fpdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.invoice.deduction.AsyncDeductQueryService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.invoice.deduction.impl.AsyncInvoiceDownQueryServiceImpl;
import kd.imc.rim.common.invoice.deduction.impl.AsyncSelectQueryServiceImpl;
import kd.imc.rim.common.invoice.deduction.impl.AsyncStatisticConfirmQueryServiceImpl;
import kd.imc.rim.common.invoice.deduction.impl.AsyncStatisticCreateQueryServiceImpl;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.formplugin.message.service.fpdk.ChangeTaxperiodService;
import kd.imc.rim.formplugin.message.service.fpdk.DktjbbService;
import kd.imc.rim.formplugin.message.service.fpdk.DqtjcxService;
import kd.imc.rim.formplugin.message.service.fpdk.FpdkAsyncDeductQueryService;
import kd.imc.rim.formplugin.message.service.fpdk.GxConfirmService;
import kd.imc.rim.formplugin.message.service.fpdk.GxInvoiceService;
import kd.imc.rim.formplugin.message.service.fpdk.InvoiceTableDownService;
import kd.imc.rim.formplugin.message.service.fpdk.ReadySelectConfirmService;
import kd.imc.rim.formplugin.message.service.fpdk.ReadySelectService;
import kd.imc.rim.formplugin.message.service.fpdk.StatisticQueryService;
import kd.imc.rim.formplugin.message.service.fpdk.TaxLoginService;

public abstract class AbstractFpdkService {
    private static Log LOGGER = LogFactory.getLog(AbstractFpdkService.class);
    protected String type;
    public static final String MSG_TAX_LOGIN = "taxLogin";
    public static final String MSG_TAXPERIOD_QUERY = "taxperiodQuery";
    public static final String MSG_TAXPERIOD_CHANGE = "taxperiodChange";
    public static final String MSG_STATISTIC_QUERY = "statisticQuery";
    public static final String MSG_STATISTIC_CREATE = "statisticCreate";
    public static final String MSG_STATISTIC_CREATE_QUERY = "statisticCreateQuery";
    public static final String MSG_STATISTIC_CONFIRM = "statisticConfirm";
    private static final String MSG_STATISTIC_CONFIRM_QUERY = "statisticConfirmQuery";
    public static final String MSG_INVOICE_SELECT = "invoiceSelect";
    public static final String MSG_SELECT_QUERY = "invoiceSelectQuery";
    public static final String MSG_INVOICE_DOWN = "invoiceDown";
    public static final String MSG_INVOICE_DOWN_QUERY = "invoiceDownQuery";
    public static final String MSG_INVOICE_READY_SELECT = "readySelect";
    public static final String MSG_INVOICE_READY_SELECT_CONFIRM = "readySelectConfirm";
    public static final String MSG_INVOICE_READY_SELECT_CONFIRM_QUERY = "readySelectConfirmQuery";

    public static AbstractFpdkService newInstance(String type) {
        switch (type) {
            case "taxperiodQuery": {
                return new DqtjcxService(type);
            }
            case "statisticQuery": {
                return new StatisticQueryService(type);
            }
            case "statisticCreate": {
                return new DktjbbService(type);
            }
            case "statisticConfirm": {
                return new GxConfirmService(type);
            }
            case "invoiceSelect": {
                return new GxInvoiceService(type);
            }
            case "invoiceDown": {
                return new InvoiceTableDownService(type);
            }
            case "invoiceSelectQuery": 
            case "statisticCreateQuery": 
            case "statisticConfirmQuery": 
            case "invoiceDownQuery": 
            case "readySelectConfirmQuery": {
                return new FpdkAsyncDeductQueryService(type);
            }
            case "taxLogin": {
                return new TaxLoginService(type);
            }
            case "taxperiodChange": {
                return new ChangeTaxperiodService(type);
            }
            case "readySelect": {
                return new ReadySelectService(type);
            }
            case "readySelectConfirm": {
                return new ReadySelectConfirmService(type);
            }
        }
        return null;
    }

    public ApiResult doBusiness(Object reqObject) {
        String dataStr;
        Object object;
        ApiResult result = null;
        String json = SerializationUtils.toJsonString((Object)reqObject);
        LOGGER.info("\u62b5\u6263\u8bf7\u6c42\u53c2\u6570\uff1a" + json);
        if (StringUtils.isEmpty((CharSequence)json)) {
            return ApiResult.fail((String)ErrorType.PARAM_NULL.getName(), (String)ErrorType.PARAM_NULL.getCode());
        }
        JSONObject param = JSONObject.parseObject((String)json);
        if (ObjectUtils.isEmpty((Object)param)) {
            return ApiResult.fail((String)ErrorType.PARAM_NULL.getName(), (String)ErrorType.PARAM_NULL.getCode());
        }
        String taxNo = param.getString("taxNo");
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractFpdkService_7", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)ErrorType.PARAM_ERROR.getCode());
        }
        if (taxNo.length() > 20) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u7a0e\u53f7\u4e0d\u5408\u89c4,\u8bf7\u68c0\u67e5", (String)"AbstractFpdkService_8", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)ErrorType.PARAM_ERROR.getCode());
        }
        Long orgId = TenantUtils.getOrgByNumberOrTaxNo((String)param.getString("orgNumber"), (String)taxNo);
        if (orgId <= 0L) {
            orgId = RequestContext.get().getOrgId();
        }
        param.put("orgId", (Object)orgId);
        result = this.getResult(param);
        if (result != null && result.getData() != null && (object = JSON.parse((String)(dataStr = JSON.toJSONString((Object)result.getData(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect})))) instanceof JSONObject) {
            JSONObject data = (JSONObject)object;
            data.remove((Object)"batchNo");
            if (MSG_SELECT_QUERY.equals(this.type) || MSG_STATISTIC_CREATE_QUERY.equals(this.type) || MSG_STATISTIC_CONFIRM_QUERY.equals(this.type) || MSG_INVOICE_READY_SELECT_CONFIRM_QUERY.equals(this.type) || MSG_INVOICE_DOWN_QUERY.equals(this.type)) {
                data.remove((Object)"taskNo");
                data.remove((Object)"asyncFlag");
            } else if (!"1".equals(data.getString("asyncFlag"))) {
                data.remove((Object)"taskNo");
            }
            result.setData((Object)data);
        }
        LOGGER.info("\u62b5\u6263\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)result));
        return result;
    }

    protected DeductService getDeductService(String taxNo, Long orgId) {
        String dkType = DeductionConstant.getDkType((String)taxNo);
        if (orgId == null || orgId < 1L) {
            orgId = RequestContext.get().getOrgId();
        }
        return DeductServiceFactory.newInstanceForDeduct((String)dkType, (Long)orgId);
    }

    public abstract ApiResult getResult(JSONObject var1);

    protected String getTaskNo(JSONObject result) {
        return Optional.ofNullable(result).map(s -> s.getJSONObject("data")).filter(j -> !ObjectUtils.isEmpty((Object)j)).map(i -> i.getString("taskNo")).filter(StringUtils::isNotEmpty).orElseGet(() -> UUID.randomUUID());
    }

    protected String getBatchNo(JSONObject result, String taxNo) {
        return Optional.ofNullable(result).map(s -> s.getJSONObject("data")).filter(j -> !ObjectUtils.isEmpty((Object)j)).map(i -> i.getString("batchNo")).filter(StringUtils::isNotEmpty).orElseGet(() -> UUID.getBatchNoByTaxNo((String)taxNo));
    }

    protected String getTjbbStatus(JSONObject result) {
        return Optional.ofNullable(result).map(s -> s.getJSONObject("data")).filter(j -> !ObjectUtils.isEmpty((Object)j)).map(i -> i.getString("tjbbStatus")).filter(StringUtils::isNotEmpty).orElse("");
    }

    protected AsyncDeductQueryService getAsyncDeductQueryService(String type) {
        switch (type) {
            case "invoiceSelectQuery": 
            case "readySelectConfirmQuery": {
                return new AsyncSelectQueryServiceImpl();
            }
            case "statisticCreateQuery": {
                return new AsyncStatisticCreateQueryServiceImpl();
            }
            case "statisticConfirmQuery": {
                return new AsyncStatisticConfirmQueryServiceImpl();
            }
            case "invoiceDownQuery": {
                return new AsyncInvoiceDownQueryServiceImpl();
            }
        }
        return null;
    }

    protected void checkValue(String value, String paramName) {
        this.checkValue(value, paramName, new String[]{"0", "1"});
    }

    protected void checkValue(String value, String paramName, String[] valueList) {
        if (StringUtils.isNotEmpty((CharSequence)value) && !ObjectUtils.isEmpty((Object[])valueList) && !Arrays.asList(valueList).contains(value)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53c2\u6570\u6709\u8bef\uff0c%1$s\u7684\u53ef\u9009\u503c\u4e3a[%2$s]", (String)"AbstractFpdkService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), paramName, StringUtils.join((Object[])valueList, (String)",")));
        }
    }

    protected String getHandleStatus(String asyncFlag) {
        return "1".equals(asyncFlag) ? "3" : "1";
    }

    protected List<Long> getAllOrgIdByTaxNo(String taxNo) {
        List orgList = TenantUtils.queryChildOrgList((String)taxNo);
        if (ObjectUtils.isEmpty((Object)orgList)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u7a0e\u53f7[%s]\u548c\u7ec4\u7ec7\u5173\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u53d1\u7968\u4e91-\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u4f01\u4e1a\u4fe1\u606f\u4e2d\u7ef4\u62a4\u7a0e\u53f7\u4e0e\u7ec4\u7ec7\u7684\u5173\u7cfb", (String)"AbstractFpdkService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), taxNo));
        }
        return orgList.stream().map(s -> (String)s.get("orgId")).filter(StringUtils::isNotEmpty).map(Long::parseLong).distinct().collect(Collectors.toList());
    }
}

