/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service.fpdk;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.ListUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.formplugin.message.service.RimApiHelper;
import kd.imc.rim.formplugin.message.service.fpdk.AbstractFpdkService;

public class GxInvoiceService
extends AbstractFpdkService {
    private static Log LOGGER = LogFactory.getLog(GxInvoiceService.class);
    private static final int MAX_SIZE = 100;

    public GxInvoiceService() {
        this.type = "invoiceSelect";
    }

    public GxInvoiceService(String type) {
        this.type = type;
    }

    @Override
    public ApiResult getResult(JSONObject reqObject) {
        String taxNo = reqObject.getString("taxNo");
        this.checkParam(reqObject);
        String asyncFlag = reqObject.getString("asyncFlag");
        String authenticateFlag = reqObject.getString("authenticateFlag");
        String deductionPurpose = reqObject.getString("deductionPurpose");
        String taskNo = UUID.randomUUID();
        reqObject.put("taskNo", (Object)taskNo);
        String deductibleMode = DeductionConstant.getDeductibleMode((String)deductionPurpose, (String)authenticateFlag);
        reqObject.put("deductibleMode", (Object)deductibleMode);
        DeductService deductService = this.getDeductService(taxNo, reqObject.getLong("orgId"));
        if ("1".equals(asyncFlag)) {
            return this.asyncSelect(reqObject, taxNo, deductService);
        }
        return this.syncSelect(reqObject, taxNo, deductService);
    }

    private void checkParam(JSONObject reqObject) {
        String asyncFlag = Optional.ofNullable(reqObject.getString("asyncFlag")).filter(StringUtils::isNotEmpty).orElse("0");
        this.checkValue(asyncFlag, "asyncFlag");
        reqObject.put("asyncFlag", (Object)asyncFlag);
        String authenticateFlag = reqObject.getString("authenticateFlag");
        String deductionPurpose = reqObject.getString("deductionPurpose");
        JSONArray invoiceArray = reqObject.getJSONArray("invoices");
        if (StringUtils.isEmpty((CharSequence)authenticateFlag) || StringUtils.isEmpty((CharSequence)deductionPurpose)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"authenticateFlag,deductionPurpose\u5747\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"GxInvoiceService_46", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        this.checkValue(authenticateFlag, "authenticateFlag");
        this.checkValue(deductionPurpose, "deductionPurpose", new String[]{"1", "2", "3"});
        if (CollectionUtils.isEmpty((Collection)invoiceArray)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"GxInvoiceService_47", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        int size = InvoiceDownloadConstant.getPageSizeFromConfig((int)100, (String)"holytax_select_size");
        if ("1".equals(asyncFlag)) {
            size = InvoiceDownloadConstant.getPageSizeFromConfig((int)50000, (String)"async_select_size");
        }
        if (invoiceArray.size() > size) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5355\u6b21\u52fe\u9009\u53d1\u7968\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7%s\u5f20", (String)"GxInvoiceService_48", (String)"imc-rim-formplugin", (Object[])new Object[0]), size));
        }
        String billType = Optional.ofNullable(reqObject.getString("billType")).filter(StringUtils::isNotEmpty).orElse("0");
        this.checkValue(billType, "billType");
        reqObject.put("billType", (Object)billType);
        String dkType = DeductionConstant.getDkType((String)reqObject.getString("taxNo"));
        for (int i = 0; i < invoiceArray.size(); ++i) {
            String invoiceDate;
            JSONObject invoice = invoiceArray.getJSONObject(i);
            if (invoice == null) continue;
            CommonUtils.jsonNullToEmptyString((JSONObject)invoice, (String[])new String[]{"invoiceCode", "invoiceType", "etaxInvoiceNo"});
            String invoiceCode = invoice.getString("invoiceCode");
            String invoiceNo = invoice.getString("invoiceNo");
            if (StringUtils.isEmpty((CharSequence)invoiceNo)) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u5f20\u53d1\u7968,\u7f3a\u5c11\u53d1\u7968\u53f7\u7801", (String)"GxInvoiceService_49", (String)"imc-rim-formplugin", (Object[])new Object[0]), String.valueOf(i + 1)));
            }
            if (invoiceNo.length() > 32) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968:%s,\u53d1\u7968\u53f7\u7801\u4e0d\u5408\u89c4,\u8bf7\u68c0\u67e5", (String)"GxInvoiceService_50", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo));
            }
            if ("1".equals(billType)) {
                if (StringUtils.isNotEmpty((CharSequence)invoiceCode)) {
                    throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968:%s,\u6d77\u5173\u7f34\u6b3e\u4e66\u6ca1\u6709\u53d1\u7968\u4ee3\u7801,\u8bf7\u68c0\u67e5", (String)"GxInvoiceService_51", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo));
                }
                invoice.put("invoiceType", (Object)InputInvoiceTypeEnum.HGJKS.getAwsType());
                invoice.put("customDeclarationNo", (Object)invoiceNo);
            } else {
                if (invoiceNo.length() != 20 && StringUtils.isEmpty((CharSequence)invoiceCode)) {
                    throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968:%s,\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5", (String)"GxInvoiceService_52", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo));
                }
                if (StringUtils.isNotEmpty((CharSequence)invoiceCode) && invoiceCode.length() > 32) {
                    throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968:%s,\u53d1\u7968\u4ee3\u7801\u4e0d\u5408\u89c4,\u8bf7\u68c0\u67e5", (String)"GxInvoiceService_53", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo));
                }
                String etaxInvoiceNo = invoice.getString("etaxInvoiceNo");
                if (StringUtils.isNotEmpty((CharSequence)etaxInvoiceNo) && etaxInvoiceNo.length() > 30) {
                    throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968:%s,\u6570\u7535\u53f7\u7801\u4e0d\u5408\u89c4,\u8bf7\u68c0\u67e5", (String)"GxInvoiceService_54", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo));
                }
                String invoiceType = invoice.getString("invoiceType");
                if (("3".equals(dkType) || "5".equals(dkType)) && StringUtils.isEmpty((CharSequence)invoiceType)) {
                    throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968:%s,\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"GxInvoiceService_55", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo));
                }
            }
            if ("2".equals(deductionPurpose) && "1".equals(authenticateFlag)) {
                String notDeductibleType = invoice.getString("notDeductibleType");
                if (StringUtils.isEmpty((CharSequence)notDeductibleType)) {
                    throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968:%s,\u62b5\u6263\u7528\u9014\u4e3a\u4e0d\u62b5\u6263\u65f6\uff0c\u5fc5\u987b\u586b\u4e0d\u62b5\u6263\u539f\u56e0", (String)"GxInvoiceService_56", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo));
                }
                if (!Arrays.asList("1", "2", "3", "4", "5").contains(notDeductibleType)) {
                    throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968:%s,\u4e0d\u62b5\u6263\u539f\u56e0\u4e0d\u5408\u89c4,\u8bf7\u68c0\u67e5", (String)"GxInvoiceService_57", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(invoiceDate = invoice.getString("invoiceDate")))) {
                try {
                    invoice.getDate("invoiceDate");
                }
                catch (Exception e) {
                    throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968:%1$s,%2$s", (String)"GxInvoiceService_42", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo, ResManager.loadKDString((String)"\u53d1\u7968\u65e5\u671f\u4e0d\u5408\u89c4,\u8bf7\u68c0\u67e5", (String)"GxInvoiceService_58", (String)"imc-rim-formplugin", (Object[])new Object[0])));
                }
            } else {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968:%1$s,%2$s", (String)"GxInvoiceService_42", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo, ResManager.loadKDString((String)"\u53d1\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"GxInvoiceService_59", (String)"imc-rim-formplugin", (Object[])new Object[0])));
            }
            if (StringUtils.isNotEmpty((CharSequence)invoice.getString("invoiceAmount")) && !BigDecimalUtil.isNumber((String)invoice.getString("invoiceAmount"))) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968:%1$s,\u53d1\u7968\u91d1\u989d\u4e0d\u5408\u89c4,\u8bf7\u68c0\u67e5", (String)"GxInvoiceService_43", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo));
            }
            if (StringUtils.isNotEmpty((CharSequence)invoice.getString("totalTaxAmount")) && !BigDecimalUtil.isNumber((String)invoice.getString("totalTaxAmount"))) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968:%1$s,\u53d1\u7968\u7a0e\u989d\u4e0d\u5408\u89c4,\u8bf7\u68c0\u67e5", (String)"GxInvoiceService_44", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo));
            }
            if (!StringUtils.isNotEmpty((CharSequence)invoice.getString("effectiveTaxAmount")) || BigDecimalUtil.isNumber((String)invoice.getString("effectiveTaxAmount"))) continue;
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968:%1$s,\u6709\u6548\u7a0e\u989d\u4e0d\u5408\u89c4,\u8bf7\u68c0\u67e5", (String)"GxInvoiceService_45", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo));
        }
    }

    public ApiResult syncSelect(JSONObject param, String taxNo, DeductService deductService) {
        JSONArray invoiceArray = param.getJSONArray("invoices");
        if (CollectionUtils.isEmpty((Collection)invoiceArray)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"GxInvoiceService_60", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)ErrorType.PARAM_ERROR.getCode());
        }
        param.remove((Object)"invoices");
        List invoiceList = JSONObject.parseArray((String)invoiceArray.toJSONString(), JSONObject.class);
        Map listToMonth = ListUtils.splitListToMonth((List)invoiceList, (String)"invoiceDate");
        if (CollectionUtils.isEmpty((Map)listToMonth)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u5206\u7ec4\u5931\u8d25", (String)"GxInvoiceService_61", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        JSONArray success = new JSONArray();
        JSONArray fail = new JSONArray();
        for (List list : listToMonth.values()) {
            JSONObject selectParam = new JSONObject();
            selectParam.putAll((Map)param);
            selectParam.put("invoices", (Object)list);
            String batchNo = UUID.getBatchNoByTaxNo((String)taxNo);
            selectParam.put("batchNo", (Object)batchNo);
            JSONObject resultJson = deductService.gxInvoices(selectParam);
            this.handleResult(success, fail, list, resultJson);
            this.asyncSaveSelectLog(selectParam, resultJson, batchNo);
        }
        JSONObject data = new JSONObject();
        data.put("success", (Object)success);
        data.put("fail", (Object)fail);
        return RimApiHelper.convertApiResult((Map<String, Object>)ResultContant.createSuccessJSONObject((Object)data));
    }

    private void handleResult(JSONArray success, JSONArray fail, List<JSONObject> invoices, JSONObject resultJson) {
        JSONObject resultData;
        if (success == null || fail == null || CollectionUtils.isEmpty(invoices)) {
            return;
        }
        if (resultJson == null) {
            resultJson = ResultContant.createJSONObject((String)"0202", (String)ResManager.loadKDString((String)"\u52fe\u9009\u53d1\u7968\u5931\u8d25", (String)"GxInvoiceService_62", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if ((resultData = resultJson.getJSONObject("data")) != null && resultData.get((Object)"success") != null && resultData.get((Object)"fail") != null) {
            success.addAll((Collection)resultData.getJSONArray("success"));
            fail.addAll((Collection)resultData.getJSONArray("fail"));
        } else {
            String selectResult = Objects.equals("10006", resultJson.getString("errcode")) ? "33" : "34";
            for (JSONObject invoice : invoices) {
                JSONObject rtnJson = new JSONObject();
                rtnJson.put("invoiceCode", invoice.get((Object)"invoiceCode"));
                rtnJson.put("invoiceNo", invoice.get((Object)"invoiceNo"));
                if (StringUtils.isNotEmpty((CharSequence)invoice.getString("etaxInvoiceNo"))) {
                    rtnJson.put("etaxInvoiceNo", invoice.get((Object)"etaxInvoiceNo"));
                }
                rtnJson.put("invoiceDate", invoice.get((Object)"invoiceDate"));
                rtnJson.put("selectResult", (Object)selectResult);
                rtnJson.put("description", (Object)resultJson.getString("description"));
                fail.add((Object)rtnJson);
            }
        }
    }

    public ApiResult asyncSelect(JSONObject param, String taxNo, DeductService deductService) {
        JSONArray invoiceArray = param.getJSONArray("invoices");
        if (CollectionUtils.isEmpty((Collection)invoiceArray)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"GxInvoiceService_60", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)ErrorType.PARAM_ERROR.getCode());
        }
        String taskNo = param.getString("taskNo");
        JSONObject result = ResultContant.createSuccessJSONObject();
        String selectFlag = RimConfigUtils.getConfig((String)"rim_deduction", (String)"api_gx_async");
        if ("1".equals(selectFlag)) {
            ThreadPools.executeOnceIncludeRequestContext((String)"GxInvoiceService.asyncSelect", () -> this.asyncSelectInvoice(param, taxNo, deductService, invoiceArray));
        } else {
            this.asyncSelectInvoice(param, taxNo, deductService, invoiceArray);
        }
        return RimApiHelper.convertApiResult((Map<String, Object>)DeductionUtils.setBatchNo2Result((JSONObject)result, (String)param.getString("asyncFlag"), null, (String)taskNo));
    }

    private void asyncSelectInvoice(JSONObject param, String taxNo, DeductService deductService, JSONArray invoiceArray) {
        boolean isDateSplit;
        if (CollectionUtils.isEmpty((Collection)invoiceArray)) {
            return;
        }
        param.remove((Object)"invoices");
        List invoiceList = JSONObject.parseArray((String)invoiceArray.toJSONString(), JSONObject.class);
        String dkType = DeductionConstant.getDkType((String)taxNo);
        String dateSplit = RimConfigUtils.getConfig((String)"rim_deduction", (String)"all_type_split");
        boolean bl = isDateSplit = "1".equals(dateSplit) || "1".equals(dkType) || "4".equals(dkType);
        if (isDateSplit) {
            Map listToMonth = ListUtils.splitListToMonth((List)invoiceList, (String)"invoiceDate");
            if (CollectionUtils.isEmpty((Map)listToMonth)) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u5206\u7ec4\u5931\u8d25", (String)"GxInvoiceService_61", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            for (List list : listToMonth.values()) {
                this.selectForGroups(param, list, deductService, taxNo);
            }
        } else {
            this.selectForGroups(param, invoiceList, deductService, taxNo);
        }
    }

    private void selectForGroups(JSONObject param, List<JSONObject> invoiceList, DeductService deductService, String taxNo) {
        String dkType = DeductionConstant.getDkType((String)taxNo);
        int size = "4".equals(dkType) ? InvoiceDownloadConstant.getPageSizeFromConfig((int)100, (String)"newtax_select_size") : ("5".equals(dkType) ? InvoiceDownloadConstant.getPageSizeFromConfig((int)100, (String)"lq_select_size") : InvoiceDownloadConstant.getPageSizeFromConfig((int)100, (String)"holytax_select_size"));
        if (invoiceList.size() <= size) {
            JSONObject selectParam = new JSONObject();
            selectParam.putAll((Map)param);
            selectParam.put("requestId", (Object)UUID.randomUUID());
            String batchNo = UUID.getBatchNoByTaxNo((String)taxNo);
            selectParam.put("batchNo", (Object)batchNo);
            selectParam.put("invoices", invoiceList);
            JSONObject result = deductService.gxInvoices(selectParam);
            this.asyncUpdateInvoiceStatus(selectParam, result, batchNo);
        } else {
            List groups = ListUtils.splitList(invoiceList, (int)size);
            if (CollectionUtils.isEmpty((Collection)groups)) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u5206\u7ec4\u5931\u8d25", (String)"GxInvoiceService_61", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            for (List subArray : groups) {
                JSONObject selectParam = new JSONObject();
                selectParam.putAll((Map)param);
                selectParam.put("invoices", (Object)subArray);
                selectParam.put("requestId", (Object)UUID.randomUUID());
                String batchNo1 = UUID.getBatchNoByTaxNo((String)taxNo);
                selectParam.put("batchNo", (Object)batchNo1);
                JSONObject resultJson = deductService.gxInvoices(selectParam);
                this.asyncUpdateInvoiceStatus(selectParam, resultJson, batchNo1);
            }
        }
    }

    public void asyncSaveSelectLog(JSONObject reqObject, JSONObject jsonResult, String batchNo) {
        ThreadPools.executeOnceIncludeRequestContext((String)"SelectAuthService.invoiceSelect", () -> this.asyncUpdateInvoiceStatus(reqObject, jsonResult, batchNo));
    }

    public void asyncUpdateInvoiceStatus(JSONObject reqObject, JSONObject jsonResult) {
        this.asyncUpdateInvoiceStatus(reqObject, jsonResult, null);
    }

    private void asyncUpdateInvoiceStatus(JSONObject reqObject, JSONObject jsonResult, String batchNo) {
        String selectType;
        JSONObject resultData = jsonResult.getJSONObject("data");
        String taxNo = reqObject.getString("taxNo");
        batchNo = Optional.ofNullable(batchNo).orElseGet(() -> UUID.getBatchNoByTaxNo((String)taxNo));
        batchNo = Optional.ofNullable(resultData).map(s -> s.getString("batchNo")).filter(StringUtils::isNotEmpty).orElse(batchNo);
        LOGGER.info("\u5f02\u6b65\u66f4\u65b0\u53d1\u7968\u7684\u72b6\u6001\u4fe1\u606f{}:{}-{}", new Object[]{taxNo, batchNo, jsonResult});
        int successNum = 0;
        int failNum = 0;
        StringBuilder message = new StringBuilder();
        String asyncFlag = reqObject.getString("asyncFlag");
        reqObject.put("selectOperationType", (Object)"3");
        String dkType = DeductionConstant.getDkType((String)taxNo);
        DeductSelectService invoiceDeductService = DeductServiceFactory.newInstanceForDeductSelect((String)dkType);
        String string = selectType = DeductionConstant.isAsyncGxRequest((String)dkType) ? "2" : "1";
        if (resultData != null && resultData.get((Object)"success") != null && resultData.get((Object)"fail") != null) {
            invoiceDeductService.updateInvoiceStatus(reqObject, resultData, batchNo, message, selectType);
            successNum = resultData.getJSONArray("success").size();
            failNum = resultData.getJSONArray("fail").size();
        } else if (Objects.equals("10006", jsonResult.getString("errcode"))) {
            invoiceDeductService.insertSelectAccount(reqObject, "10006", jsonResult.getString("description"), batchNo, "1", "2", false);
            failNum = reqObject.getJSONArray("invoices").size();
        } else if (ResultContant.isSuccess((JSONObject)jsonResult).booleanValue() && (DeductionConstant.isAsyncGxRequest((String)dkType) || "1".equals(asyncFlag))) {
            invoiceDeductService.insertSelectAccount(reqObject, ErrorType.STATUS_HANDLING.getCode(), null, batchNo, selectType, "3", false);
            successNum = reqObject.getJSONArray("invoices").size();
        } else {
            invoiceDeductService.insertSelectAccount(reqObject, "0200", jsonResult.getString("description"), batchNo, "1", "2", false);
            failNum = reqObject.getJSONArray("invoices").size();
        }
        LOGGER.info("SelectAuthService - \u8c03\u7528\u53d1\u7968\u52fe\u9009\u63a5\u53e3\uff0c\u5f02\u6b65\u66f4\u65b0\u53d1\u7968\u7684\u72b6\u6001\u4fe1\u606f\uff0c\u6210\u529f\u6570\u91cf:{},\u5931\u8d25\u6570\u91cf:{}", (Object)successNum, (Object)failNum);
    }
}

