/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service.fpdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.download.impl.HeaderInvoiceDownServiceImpl;
import kd.imc.rim.common.message.constant.OpenApiInterfaceCodeEnum;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.message.vo.RequestVo;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.formplugin.message.service.fpdk.AbstractFpdkService;
import kd.imc.rim.formplugin.message.service.impl.DownInvoiceServiceImpl;

public class InvoiceTableDownService
extends AbstractFpdkService {
    public InvoiceTableDownService(String type) {
        this.type = type;
    }

    @Override
    public ApiResult getResult(JSONObject reqJson) {
        String taxNo = reqJson.getString("taxNo");
        String asyncFlag = reqJson.getString("asyncFlag");
        this.checkValue(asyncFlag, "asyncFlag");
        String dkType = DeductionConstant.getDkType((String)taxNo);
        reqJson.put("dkType", (Object)dkType);
        DownInvoiceServiceImpl service = new DownInvoiceServiceImpl();
        service.checkDownParam(reqJson);
        RequestVo requestVo = new RequestVo();
        requestVo.setInterfaceCode(OpenApiInterfaceCodeEnum.DOWN_INVOICE.getCode());
        requestVo.setData(reqJson.toJSONString());
        ApiResult apiResult = service.doBusiness(requestVo);
        if (!apiResult.getSuccess()) {
            return apiResult;
        }
        Object jsonStr = apiResult.getData();
        String taskNo = "";
        String batchNo = "";
        int totalNum = 0;
        JSONArray invoices = null;
        if (StringUtils.isNotBlank((Object)jsonStr)) {
            Object object = JSON.parse((String)jsonStr.toString());
            if (object instanceof JSONObject) {
                JSONObject data2 = (JSONObject)object;
                taskNo = data2.getString("taskNo");
                batchNo = data2.getString("batchNo");
            } else if (object instanceof JSONArray) {
                taskNo = UUID.randomUUID();
                batchNo = UUID.getBatchNoByTaxNo((String)taxNo);
                invoices = (JSONArray)object;
                JSONObject data = new JSONObject();
                data.put("taskNo", (Object)taskNo);
                data.put("invoicesData", (Object)invoices);
                totalNum = CollectionUtils.isEmpty((Collection)invoices) ? 0 : invoices.size();
                data.put("totalElement", (Object)totalNum);
                apiResult.setData((Object)data);
            }
        }
        HeaderInvoiceDownServiceImpl downService = new HeaderInvoiceDownServiceImpl();
        JSONObject searchOpt = reqJson.getJSONObject("searchOpt");
        if (ObjectUtils.isEmpty((Object)searchOpt)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvoiceTableDownService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        String invoiceType = searchOpt.getString("invoiceType");
        DynamicObject downLogObj = downService.getDownLogDynamicObject(taskNo, batchNo, reqJson.getLong("orgId"), taxNo, Integer.valueOf(totalNum), "1", InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoiceType));
        String taxPeriodStr = searchOpt.getString("taxPeriod");
        Date startTime = null;
        Date endTime = null;
        if (StringUtils.isNotEmpty((CharSequence)taxPeriodStr)) {
            startTime = DateUtils.stringToDate((String)taxPeriodStr, (String)"yyyyMM");
            endTime = DateUtils.getLastDateOfMonth((Date)startTime);
        } else {
            startTime = searchOpt.getDate("startTime");
            endTime = searchOpt.getDate("endTime");
        }
        downLogObj.set("invoice_startdate", (Object)startTime);
        downLogObj.set("invoice_enddate", (Object)endTime);
        downLogObj.set("json_tag", (Object)reqJson.toJSONString());
        if ("1".equals(asyncFlag)) {
            downLogObj.set("gov_status", (Object)"6");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLogObj});
        } else if (CollectionUtils.isEmpty((Collection)invoices)) {
            downLogObj.set("gov_status", (Object)"9");
            downLogObj.set("success_num", (Object)0);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{downLogObj});
        } else {
            downService.insertHeaderSyncAccount(downLogObj, null, invoices);
        }
        return apiResult;
    }
}

