/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service.fpdk;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductInvoiceOperateService;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.ReadyDeductConfirmService;
import kd.imc.rim.common.invoice.deduction.SelectAccountService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.formplugin.message.service.RimApiHelper;
import kd.imc.rim.formplugin.message.service.fpdk.AbstractFpdkService;
import kd.imc.rim.formplugin.message.service.fpdk.GxInvoiceService;
import org.apache.commons.compress.utils.Lists;

public class ReadySelectConfirmService
extends AbstractFpdkService {
    private static Log LOGGER = LogFactory.getLog(ReadySelectConfirmService.class);

    public ReadySelectConfirmService(String type) {
        this.type = type;
    }

    @Override
    public ApiResult getResult(JSONObject reqJson) {
        Date taxPeriod = DeductionUtils.getParamTaxPeriod((String)reqJson.getString("taxPeriod"));
        String taxNo = reqJson.getString("taxNo");
        List<Long> orgIds = this.getAllOrgIdByTaxNo(taxNo);
        ReadyDeductConfirmService confirmService = new ReadyDeductConfirmService();
        Map readyVatDeductInvoices = confirmService.queryDeductReadySelect(orgIds, null, taxNo, taxPeriod, InputInvoiceTypeEnum.getDeductionTypes());
        List readyVatDeductIds = null;
        if (!CollectionUtils.isEmpty((Map)readyVatDeductInvoices)) {
            readyVatDeductIds = (List)readyVatDeductInvoices.get("ids");
        }
        Map readyVatUnDeductInvoices = confirmService.queryUnDeductReadySelect(orgIds, null, taxNo, taxPeriod, InputInvoiceTypeEnum.getDeductionTypes());
        List readyVatUnDeductIds = null;
        if (!CollectionUtils.isEmpty((Map)readyVatUnDeductInvoices)) {
            readyVatUnDeductIds = (List)readyVatUnDeductInvoices.get("ids");
        }
        Map readyVatDrawbackInvoices = confirmService.queryVatDrawBackReadySelect(orgIds, null, taxNo, taxPeriod, InputInvoiceTypeEnum.getVatDrawbackTypes());
        List readyVatDrawbackIds = null;
        if (!CollectionUtils.isEmpty((Map)readyVatDrawbackInvoices)) {
            readyVatDrawbackIds = (List)readyVatDrawbackInvoices.get("ids");
        }
        Map readyDeductCalcOrdinary = confirmService.queryDeductCalcOrdinary(orgIds, null, taxNo, taxPeriod, "2");
        List readyDeductCalcOrdinaryIds = null;
        if (!CollectionUtils.isEmpty((Map)readyDeductCalcOrdinary)) {
            readyDeductCalcOrdinaryIds = (List)readyDeductCalcOrdinary.get("ids");
        }
        Map readyDeductCalcOthers = confirmService.queryDedutCalcOthers(orgIds, null, taxPeriod, "2");
        List readyDeductCalcOthersIds = null;
        if (!CollectionUtils.isEmpty((Map)readyDeductCalcOthers)) {
            readyDeductCalcOthersIds = (List)readyDeductCalcOthers.get("ids");
        }
        if (CollectionUtils.isEmpty((Collection)readyVatDeductIds) && CollectionUtils.isEmpty((Collection)readyVatUnDeductIds) && CollectionUtils.isEmpty((Collection)readyDeductCalcOrdinaryIds) && CollectionUtils.isEmpty((Collection)readyDeductCalcOthersIds) && CollectionUtils.isEmpty((Collection)readyVatDrawbackIds)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u786e\u8ba4\u62b5\u6263\u7684\u53d1\u7968", (String)"ReadySelectConfirmService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)ErrorType.PARAM_ERROR.getCode());
        }
        String taskNo = UUID.randomUUID();
        this.asyncConfirm(taskNo, readyVatDeductIds, readyVatUnDeductIds, readyVatDrawbackIds, readyDeductCalcOrdinaryIds, readyDeductCalcOthersIds, taxNo, taxPeriod, orgIds.get(0));
        JSONObject data = new JSONObject();
        data.put("taskNo", (Object)taskNo);
        data.put("asyncFlag", (Object)"1");
        JSONObject result = ResultContant.createSuccessJSONObject((Object)data);
        return RimApiHelper.convertApiResult((Map<String, Object>)result);
    }

    private void asyncConfirm(String taskNo, List<Long> readyVatInvoices, List<Long> readyVatUnDeductInvoices, List<Long> readyVatDrawbackInvoices, List<Long> readyDeductCalcOrdinary, List<Long> readyDeductCalcOthers, String taxNo, Date taxPeriod, Long orgId) {
        this.handleVatInvoices(taskNo, readyVatInvoices, readyVatUnDeductInvoices, readyVatDrawbackInvoices, taxNo, taxPeriod, orgId);
        this.handleTransportInvoices(taskNo, readyDeductCalcOrdinary, readyDeductCalcOthers, taxNo, taxPeriod, orgId);
    }

    private void handleVatInvoices(String taskNo, List<Long> readyVatInvoices, List<Long> readyVatUnDeductInvoices, List<Long> readyVatDrawbackInvoices, String taxNo, Date taxPeriod, Long orgId) {
        if (!CollectionUtils.isEmpty(readyVatInvoices)) {
            this.selectTaxInvoice(taskNo, readyVatInvoices, taxNo, orgId, "1");
        }
        if (!CollectionUtils.isEmpty(readyVatUnDeductInvoices)) {
            this.selectTaxInvoice(taskNo, readyVatUnDeductInvoices, taxNo, orgId, "2");
        }
        if (!CollectionUtils.isEmpty(readyVatDrawbackInvoices)) {
            this.selectTaxInvoice(taskNo, readyVatDrawbackInvoices, taxNo, orgId, "3");
        }
    }

    private void selectTaxInvoice(String taskNo, List<Long> readyVatInvoices, String taxNo, Long orgId, String deductionPurpose) {
        ApiResult apiResult;
        JSONObject selectParam;
        if (CollectionUtils.isEmpty(readyVatInvoices)) {
            return;
        }
        GxInvoiceService gxInvoiceService = new GxInvoiceService();
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        param.put("taskNo", (Object)taskNo);
        param.put("asyncFlag", (Object)"1");
        param.put("selectOperaType", (Object)"3");
        DeductService deductService = this.getDeductService(taxNo, orgId);
        param.put("billType", (Object)"0");
        QFilter filte = new QFilter("id", "in", readyVatInvoices);
        QFilter flagfilte = new QFilter("authenticate_flag", "=", (Object)"4");
        DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,authenticate_flag,effective_tax_amount,buyer_tax_no,org,isvoucher,invoice_status,deduction_flag,deduction_purpose,not_deductible_type,saler_name,saler_tax_no,output_type,remark,electronic_no,createtime,purchase_ticket,agric_handle_status,invoice_risk_level", (QFilter[])new QFilter[]{filte, flagfilte});
        if (CollectionUtils.isEmpty((Collection)invoiceCollection)) {
            return;
        }
        JSONArray vatDeduction = new JSONArray();
        JSONArray hgDeduction = new JSONArray();
        for (DynamicObject mainIvn : invoiceCollection) {
            Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)mainIvn.get("invoice_type"));
            if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
                hgDeduction.add((Object)DeductionConstant.createSelectJson((DynamicObject)mainIvn));
                continue;
            }
            vatDeduction.add((Object)DeductionConstant.createSelectJson((DynamicObject)mainIvn));
        }
        String deductibleMode = DeductionConstant.getDeductibleMode((String)deductionPurpose, (String)"1");
        if (!CollectionUtils.isEmpty((Collection)vatDeduction)) {
            selectParam = new JSONObject();
            selectParam.putAll((Map)param);
            selectParam.put("deductibleMode", (Object)deductibleMode);
            selectParam.put("invoices", (Object)vatDeduction);
            apiResult = gxInvoiceService.asyncSelect(selectParam, taxNo, deductService);
            LOGGER.info("\u786e\u8ba4\u52fe\u9009\u589e\u503c\u7a0e\u62b5\u6263\u7ed3\u679c:{}-{}", (Object)deductionPurpose, (Object)JSONObject.toJSONString((Object)apiResult));
        }
        if (!CollectionUtils.isEmpty((Collection)hgDeduction)) {
            selectParam = new JSONObject();
            selectParam.putAll((Map)param);
            selectParam.put("billType", (Object)"1");
            selectParam.put("deductibleMode", (Object)deductibleMode);
            apiResult = gxInvoiceService.asyncSelect(selectParam, taxNo, deductService);
            LOGGER.info("\u786e\u8ba4\u52fe\u6d77\u5173\u62b5\u6263\u7ed3\u679c:{}-{}", (Object)deductionPurpose, (Object)JSONObject.toJSONString((Object)apiResult));
        }
    }

    private void handleTransportInvoices(String taskNo, List<Long> readyDeductCalcOrdinary, List<Long> readyDeductCalcOthers, String taxNo, Date taxPeriod, Long orgId) {
        if (readyDeductCalcOrdinary == null) {
            readyDeductCalcOrdinary = Lists.newArrayList();
        }
        if (!CollectionUtils.isEmpty(readyDeductCalcOthers)) {
            readyDeductCalcOrdinary.addAll(readyDeductCalcOthers);
        }
        if (!CollectionUtils.isEmpty((Collection)readyDeductCalcOrdinary)) {
            LOGGER.info("\u5f00\u59cb\u6267\u884c\u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263:{}", (Object)taxNo);
            QFilter idFilter = new QFilter("id", "in", (Object)readyDeductCalcOrdinary);
            QFilter tranFilter = new QFilter("transport_deduction", "=", (Object)"2");
            DynamicObjectCollection mainCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"serial_no,transport_deduction", (QFilter[])new QFilter[]{idFilter, tranFilter});
            if (!CollectionUtils.isEmpty((Collection)mainCollection)) {
                List serialNoList = mainCollection.stream().map(s -> s.getString("serial_no")).collect(Collectors.toList());
                String batchNo = UUID.getBatchNoByTaxNo((String)taxNo);
                DeductInvoiceOperateService service = new DeductInvoiceOperateService();
                service.transportDeductBySerialNo(serialNoList, "1", taxPeriod, "6", batchNo, "1", false);
                JSONObject logParam = new JSONObject();
                logParam.put("taskNo", (Object)taskNo);
                logParam.put("taxPeriod", (Object)DateUtils.format((Date)taxPeriod, (String)"yyyyMM"));
                logParam.put("orgId", (Object)orgId);
                logParam.put("taxNo", (Object)taxNo);
                logParam.put("batchNo", (Object)batchNo);
                logParam.put("asyncFlag", (Object)"1");
                logParam.put("selectType", (Object)"1");
                logParam.put("billType", null);
                logParam.put("selectOperaType", (Object)"3");
                logParam.put("deductibleMode", (Object)"6");
                logParam.put("handleStatus", (Object)"1");
                JSONArray selectAccountList = service.getTransportAccount(serialNoList, batchNo, "6", "3");
                SelectAccountService selectAccountService = new SelectAccountService();
                selectAccountService.asyncSaveSelectLogAndAccount(logParam, selectAccountList);
            }
        }
    }
}

