/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.api.ApiResult;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.message.vo.RequestVo;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.StringUtils;
import kd.imc.rim.formplugin.message.service.OpenApiService;

public class DownFullInvoiceServiceImpl
implements OpenApiService {
    @Override
    public ApiResult doBusiness(RequestVo requestVo) {
        JSONObject param = JSON.parseObject((String)requestVo.getData());
        this.checkDownFullInvoiceParam(param);
        NewEtaxDeductService deductService = new NewEtaxDeductService(Long.valueOf(RequestContext.get().getOrgId()));
        JSONObject resultJson = deductService.downFullInvoiceSync(param);
        ApiResult result = this.convertApiResult(resultJson, requestVo);
        if (result.getSuccess() && null != resultJson && ResultContant.isSuccess((JSONObject)resultJson).booleanValue()) {
            JSONObject data = new JSONObject();
            data.put("pageNo", resultJson.get((Object)"pageNo"));
            data.put("totalElement", resultJson.get((Object)"totalElement"));
            data.put("pageSize", resultJson.get((Object)"pageSize"));
            data.put("invoicesData", resultJson.get((Object)"data"));
            result.setData((Object)data);
        }
        return result;
    }

    private void checkDownFullInvoiceParam(JSONObject param) {
        this.checkParam(param);
        JSONObject searchOpt = param.getJSONObject("searchOpt");
        if (ObjectUtils.isEmpty((Object)searchOpt)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"DownFullInvoiceServiceImpl_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        String dataType = searchOpt.getString("dataType");
        if (StringUtils.isEmpty((CharSequence)dataType)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"DownFullInvoiceServiceImpl_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (!"1".equals(dataType) && !"2".equals(dataType)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4f20\u5165\u53c2\u6570\u9519\u8bef", (String)"DownFullInvoiceServiceImpl_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        Integer pageNo = searchOpt.getInteger("pageNo");
        if (ObjectUtils.isEmpty((Object)pageNo)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"DownFullInvoiceServiceImpl_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (pageNo < 1) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u9875\u7801\u53c2\u6570\u4f20\u5165\u9519\u8bef", (String)"DownFullInvoiceServiceImpl_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        Integer pageSize = searchOpt.getInteger("pageSize");
        if (ObjectUtils.isEmpty((Object)pageSize)) {
            pageSize = InvoiceDownloadConstant.getPageSizeFromConfig((int)500, (String)"all_e_inout_down_pagesize");
        }
        if (pageSize <= 0) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u5206\u9875\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e1", (String)"DownFullInvoiceServiceImpl_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        int pageSizeMax = InvoiceDownloadConstant.getPageSizeFromConfig((int)1000, (String)"all_e_inout_down_max_pagesize");
        if (pageSize > pageSizeMax) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5206\u9875\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e%s", (String)"DownFullInvoiceServiceImpl_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), pageSizeMax));
        }
        String invoiceNo = searchOpt.getString("invoiceNo");
        if (StringUtils.isNotEmpty((CharSequence)invoiceNo)) {
            if (invoiceNo.length() == 20) {
                searchOpt.put("qdInvoiceNo", (Object)invoiceNo);
                searchOpt.remove((Object)"invoiceNo");
            }
        } else if (StringUtils.isEmpty((CharSequence)searchOpt.getString("invoiceType"))) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"DownFullInvoiceServiceImpl_7", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        String startTimeStr = searchOpt.getString("startTime");
        String endTimeStr = searchOpt.getString("endTime");
        if (StringUtils.isEmpty((CharSequence)startTimeStr)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"DownFullInvoiceServiceImpl_8", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)endTimeStr)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"DownFullInvoiceServiceImpl_9", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = searchOpt.getDate("startTime");
            endTime = searchOpt.getDate("endTime");
            searchOpt.put("startTime", (Object)DateUtils.format((Date)startTime));
            searchOpt.put("endTime", (Object)DateUtils.format((Date)endTime));
        }
        catch (Exception e) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u5f00\u59cb\u65e5\u671f\u6216\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\u975e\u65e5\u671f\u683c\u5f0f,\u8bf7\u68c0\u67e5", (String)"DownFullInvoiceServiceImpl_10", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (endTime.compareTo(startTime) < 0) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f", (String)"DownFullInvoiceServiceImpl_11", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        long between = DateUtils.daysBetween((Date)endTime, (Date)startTime);
        if (between > 31L) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc731\u5929", (String)"DownFullInvoiceServiceImpl_12", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (!DateUtils.isMonth((Date)startTime, (Date)endTime)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u4e0b\u8f7d\u65e5\u671f\u8303\u56f4\u5fc5\u987b\u662f\u540c\u4e00\u4e2a\u6708\u5185", (String)"DownFullInvoiceServiceImpl_13", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }
}

