/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.mobile.home;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.expense.domain.ExpenseAttachDTO;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.domain.ExpenseInvoiceDTO;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.license.LicenseFormPlugin;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.formplugin.mobile.home.operate.AbstractOperateService;
import kd.imc.rim.formplugin.mobile.home.operate.WXCardOperateService;
import org.apache.commons.collections.CollectionUtils;

public class MobileExpensePlugin
extends LicenseFormPlugin
implements CellClickListener {
    private static Log logger = LogFactory.getLog(MobileExpensePlugin.class);
    private static final String SHOW = "1";
    private static final String HIDE = "0";
    private static final String INVOICE_ENTRY = "invoice_entity";
    private static final String ATTACH_ENTRY = "attach_entity";
    private static final String CACHED_INVOICE_KEY = "invoice_cache";
    private static final String CACHED_ATTACH_KEY = "attach_cache";
    private static final String EXPENSE_STATUS = "expense_status";
    private static final String EXPENSE_STATUS_A = MobileExpensePlugin.getExpenseName("A");
    private static final String EXPENSE_STATUS_B = MobileExpensePlugin.getExpenseName("B");
    private static final String EXPENSE_STATUS_C = MobileExpensePlugin.getExpenseName("C");
    private static final String EXPENSE_STATUS_D = MobileExpensePlugin.getExpenseName("D");

    private static final String getExpenseName(String type) {
        if ("A".equals(type)) {
            return ResManager.loadKDString((String)"\u5f85\u91c7\u96c6", (String)"MobileExpensePlugin_39", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        if ("B".equals(type)) {
            return ResManager.loadKDString((String)"\u5f85\u5ba1\u6838", (String)"MobileExpensePlugin_40", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        if ("C".equals(type)) {
            return ResManager.loadKDString((String)"\u5df2\u9a73\u56de", (String)"MobileExpensePlugin_41", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        if ("D".equals(type)) {
            return ResManager.loadKDString((String)"\u5ba1\u6838\u901a\u8fc7", (String)"MobileExpensePlugin_42", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"invoice_flex", "attach_flex", "add", "submit", "save", "clear_invoice", "clear_attach", "invoice_detail_flex"});
        CardEntry invoiceCardEntry = (CardEntry)this.getControl(INVOICE_ENTRY);
        invoiceCardEntry.addCellClickListener((CellClickListener)this);
        CardEntry attachCardEntry = (CardEntry)this.getControl(ATTACH_ENTRY);
        attachCardEntry.addCellClickListener((CellClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.loadData();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("invoice_flex".equals(key)) {
            String showInvoice = (String)this.getModel().getValue("show_invoice");
            if (SHOW.equals(showInvoice)) {
                this.getModel().setValue("show_invoice", (Object)HIDE);
                this.getView().setVisible(Boolean.TRUE, new String[]{"invoice_vectorap_open"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_vectorap_close"});
            } else {
                this.getModel().setValue("show_invoice", (Object)SHOW);
                this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_vectorap_open"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"invoice_vectorap_close"});
            }
        } else if ("attach_flex".equals(key)) {
            String showAttach = (String)this.getModel().getValue("show_attach");
            if (SHOW.equals(showAttach)) {
                this.getModel().setValue("show_attach", (Object)HIDE);
                this.getView().setVisible(Boolean.TRUE, new String[]{"attach_vectorap_open"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"attach_vectorap_close"});
            } else {
                this.getModel().setValue("show_attach", (Object)SHOW);
                this.getView().setVisible(Boolean.FALSE, new String[]{"attach_vectorap_open"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"attach_vectorap_close"});
            }
        } else if ("add".equals(key)) {
            this.addNewInvoice();
        } else if ("clear_invoice".equals(key)) {
            this.getModel().deleteEntryData(INVOICE_ENTRY);
            this.getPageCache().remove(CACHED_INVOICE_KEY);
            this.updateOrgChoose();
        } else if ("clear_attach".equals(key)) {
            this.getModel().deleteEntryData(ATTACH_ENTRY);
            this.getPageCache().remove(CACHED_ATTACH_KEY);
            Map customParam = FpzsMainService.getCustomParam((AbstractFormPlugin)this);
            AttachQueryService attachQueryService = new AttachQueryService();
            attachQueryService.cacheFpzsAttach((String)customParam.get("billId"), (String)customParam.get("entityId"), (String)customParam.get("resource"), null);
            this.updateOrgChoose();
        } else if ("submit".equals(key)) {
            this.saveFpyExpense(true);
        } else if ("save".equals(key)) {
            this.saveFpyExpense(false);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String key;
        int row = cellClickEvent.getRow();
        CardEntry cardEntry = (CardEntry)cellClickEvent.getSource();
        IDataModel model = cardEntry.getModel();
        DynamicObject entryRowEntity = model.getEntryRowEntity(key = cardEntry.getKey(), row);
        if (ObjectUtils.isEmpty((Object)entryRowEntity)) {
            this.getView().showErrMessage(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6570\u636ekey:%1$s\uff0c\u884c\u6570\uff1a%1$s", (String)"MobileExpensePlugin_36", (String)"imc-rim-formplugin", (Object[])new Object[0]), key, row), "");
            return;
        }
        if (INVOICE_ENTRY.equals(key)) {
            Long invoiceId = Long.parseLong((String)model.getValue("invoice_id", row));
            HashMap<String, Constable> param = new HashMap<String, Constable>(3);
            param.put("mainIds", invoiceId);
            param.put("allowEdit", Boolean.FALSE);
            param.put("showAttach", Character.valueOf('1'));
            param.put("addAttach", Boolean.FALSE);
            param.put("allowDel", Boolean.FALSE);
            param.put("row", Integer.valueOf(row));
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setFormId("rim_h5_inv_update");
            showParameter.setCustomParams(param);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rim_h5_inv_update"));
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (ATTACH_ENTRY.equals(key)) {
            Long attachId = Long.parseLong((String)model.getValue("attach_id", row));
            HashMap<String, Constable> attachParam = new HashMap<String, Constable>(2);
            attachParam.put("id", attachId);
            attachParam.put("allowDel", Boolean.FALSE);
            attachParam.put("allowEdit", Boolean.FALSE);
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("rim_h5_attach_detail");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rim_h5_attach_detail"));
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCustomParams(attachParam);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyNme = e.getProperty().getName();
        if ("cost_org".equals(propertyNme)) {
            this.updateCompanyName();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj != null && "rim_mobile_index".equals(actionId)) {
            JSONArray invoiceArray;
            if ("cancel".equals(returnDataObj)) {
                return;
            }
            JSONObject returnData = JSONObject.parseObject((String)JSONObject.toJSONString((Object)returnDataObj));
            JSONArray attachArray = returnData.getJSONArray("attachData");
            if (attachArray != null && attachArray.size() > 0) {
                String cachedAttachStr = this.getPageCache().get(CACHED_ATTACH_KEY);
                JSONArray cachedAttach = new JSONArray();
                if (!StringUtils.isEmpty((String)cachedAttachStr)) {
                    cachedAttach = JSONArray.parseArray((String)cachedAttachStr);
                }
                for (int i = 0; i < attachArray.size(); ++i) {
                    JSONObject attach = attachArray.getJSONObject(i);
                    Long attachId = attach.getLong("attachId");
                    if (cachedAttach.contains((Object)attachId)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9644\u4ef6\u5df2\u5b58\u5728\u5217\u8868\u4e2d", (String)"MobileExpensePlugin_43", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    int attachIndex = this.getModel().createNewEntryRow(ATTACH_ENTRY);
                    String attachName = attach.getString("originalName");
                    this.getModel().setValue("attach_name", (Object)attachName, attachIndex);
                    this.getModel().setValue("attach_id", (Object)attachId, attachIndex);
                    cachedAttach.add((Object)attachId);
                }
                if (cachedAttach.size() > 0) {
                    this.getPageCache().put(CACHED_ATTACH_KEY, cachedAttach.toJSONString());
                }
            }
            if ((invoiceArray = returnData.getJSONArray("invoiceData")) != null && invoiceArray.size() > 0) {
                QFilter invoiceFilter;
                DynamicObjectCollection invoiceObjs;
                String cachedInvoiceStr = this.getPageCache().get(CACHED_INVOICE_KEY);
                JSONArray cachedInvoice = new JSONArray();
                if (!StringUtils.isEmpty((String)cachedInvoiceStr)) {
                    cachedInvoice = JSONArray.parseArray((String)cachedInvoiceStr);
                }
                ArrayList<Long> newInvoiceIds = new ArrayList<Long>(invoiceArray.size());
                for (int j = 0; j < invoiceArray.size(); ++j) {
                    JSONObject invoice = invoiceArray.getJSONObject(j);
                    Long invoiceId = invoice.getLong("id");
                    if (cachedInvoice.contains((Object)invoiceId)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u5df2\u5b58\u5728\u5217\u8868\u4e2d", (String)"MobileExpensePlugin_44", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    newInvoiceIds.add(invoiceId);
                    cachedInvoice.add((Object)invoiceId);
                }
                if (cachedInvoice.size() > 0) {
                    this.getPageCache().put(CACHED_INVOICE_KEY, cachedInvoice.toJSONString());
                }
                if (newInvoiceIds.size() > 0 && (invoiceObjs = QueryServiceHelper.query((String)"rim_invoice", (String)"invoice_no, total_amount, id", (QFilter[])(invoiceFilter = new QFilter("id", "in", newInvoiceIds)).toArray())) != null && invoiceObjs.size() > 0) {
                    for (DynamicObject invoiceObj : invoiceObjs) {
                        int invoiceIndex = this.getModel().createNewEntryRow(INVOICE_ENTRY);
                        String invoiceNo = invoiceObj.getString("invoice_no");
                        BigDecimal totalAmount = invoiceObj.getBigDecimal("total_amount");
                        this.getModel().setValue("invoice_no", (Object)invoiceNo, invoiceIndex);
                        this.getModel().setValue("total_amount", (Object)totalAmount, invoiceIndex);
                        this.getModel().setValue("invoice_id", (Object)invoiceObj.getLong("id"), invoiceIndex);
                    }
                }
            }
            this.updateOrgChoose();
        } else if (returnDataObj != null && "rim_h5_inv_update".equals(actionId)) {
            JSONObject returnData = JSONObject.parseObject((String)JSONObject.toJSONString((Object)returnDataObj));
            int row = returnData.getInteger("row");
            this.getModel().deleteEntryRow(INVOICE_ENTRY, row);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        logger.info("\u79fb\u52a8\u62a5\u9500\u5355\u63a5\u6536\u5230\u7684\u6d88\u606f:{},{}", (Object)eventName, (Object)eventArgs);
        if ("pushData".equals(eventName) || "onMessage".equals(eventName)) {
            this.dealWxCardPushData(eventArgs);
        }
    }

    private void loadData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String jsonStr = SerializationUtils.toJsonString((Object)customParams);
        logger.info("MobileExpensePlugin-\u79fb\u52a8\u7aef\u62a5\u9500\u5355\u8bf7\u6c42\u53c2\u6570:" + jsonStr);
        JSONObject jsonObj = JSON.parseObject((String)jsonStr);
        String expenseNo = jsonObj.getString("expenseNo");
        if (StringUtils.isEmpty((String)expenseNo)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a", (String)"MobileExpensePlugin_45", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter expenseFilter = new QFilter("billno", "=", (Object)expenseNo);
        DynamicObject expenseInfo = QueryServiceHelper.queryOne((String)"rim_expense_manage", (String)"id, expense_type.name as bill_type, reimburser, reimburser.name as name, company_tax_no, company_name, org, billstatus", (QFilter[])expenseFilter.toArray());
        if (expenseInfo == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5355\u636e\u7f16\u53f7\u4e3a%1$s\u7684\u5355\u636e\u4fe1\u606f", (String)"MobileExpensePlugin_37", (String)"imc-rim-formplugin", (Object[])new Object[0]), expenseNo));
            return;
        }
        String expenseType = expenseInfo.getString("bill_type");
        String expenseStatus = expenseInfo.getString("billstatus");
        String reimburser = RequestContext.get().getUserName();
        String costDept = expenseInfo.getString("org");
        String costCompany = expenseInfo.getString("company_name");
        String companyTaxNo = expenseInfo.getString("company_tax_no");
        switch (expenseStatus) {
            case "A": {
                this.getModel().setValue(EXPENSE_STATUS, (Object)EXPENSE_STATUS_A);
                break;
            }
            case "B": {
                this.getModel().setValue(EXPENSE_STATUS, (Object)EXPENSE_STATUS_B);
                this.getView().setVisible(Boolean.FALSE, new String[]{"clear_invoice", "clear_attach", "add", "submit", "save"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"cost_company_name", "cost_org"});
                break;
            }
            case "C": {
                this.getModel().setValue(EXPENSE_STATUS, (Object)EXPENSE_STATUS_C);
                break;
            }
            case "D": {
                this.getModel().setValue(EXPENSE_STATUS, (Object)EXPENSE_STATUS_D);
                this.getView().setVisible(Boolean.FALSE, new String[]{"clear_invoice", "clear_attach", "add", "submit", "save"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"cost_company_name", "cost_org"});
                break;
            }
            default: {
                this.getModel().setValue(EXPENSE_STATUS, (Object)expenseStatus);
            }
        }
        this.getModel().setValue("expense_no", (Object)expenseNo);
        this.getModel().setValue("expense_type", (Object)expenseType);
        this.getModel().setValue("reimburser", (Object)reimburser);
        this.getModel().setValue("cost_org", (Object)costDept);
        this.getModel().setValue("cost_company_name", (Object)costCompany);
        this.getModel().setValue("company_tax_no", (Object)companyTaxNo);
        this.getModel().deleteEntryData(INVOICE_ENTRY);
        this.getModel().deleteEntryData(ATTACH_ENTRY);
        String expenseId = BigDecimalUtil.transDecimal((Object)expenseInfo.get("id")).toString();
        List<String> serialNos = this.initInvoiceInfo(expenseId);
        this.initAttachInfo(expenseId, serialNos);
        this.updateOrgChoose();
        this.buildExpenseParam(expenseNo);
    }

    private List<String> initInvoiceInfo(String expenseId) {
        QFilter serialNoFilter;
        DynamicObjectCollection invoiceCollection;
        QFilter expenseRelationFilter = new QFilter("expense_id", "=", (Object)expenseId);
        DynamicObjectCollection expenseRelationObjs = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])expenseRelationFilter.toArray());
        ArrayList<String> serialNos = null;
        if (expenseRelationObjs != null && expenseRelationObjs.size() > 0) {
            serialNos = new ArrayList<String>(expenseRelationObjs.size());
            for (DynamicObject obj : expenseRelationObjs) {
                if (obj == null) continue;
                String serialNo = obj.getString("serial_no");
                serialNos.add(serialNo);
            }
        }
        if (serialNos != null && serialNos.size() > 0 && (invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id, invoice_no, total_amount, serial_no", (QFilter[])(serialNoFilter = new QFilter("serial_no", "in", serialNos)).toArray())) != null && invoiceCollection.size() > 0) {
            JSONArray cachedInvoice = new JSONArray();
            for (DynamicObject invoice : invoiceCollection) {
                if (invoice == null) continue;
                Long invoiceId = invoice.getLong("id");
                int invoiceIndex = this.getModel().createNewEntryRow(INVOICE_ENTRY);
                String invoiceNo = invoice.getString("invoice_no");
                BigDecimal totalAmount = invoice.getBigDecimal("total_amount");
                cachedInvoice.add((Object)invoiceId);
                this.getModel().setValue("invoice_no", (Object)invoiceNo, invoiceIndex);
                this.getModel().setValue("total_amount", (Object)totalAmount, invoiceIndex);
                this.getModel().setValue("invoice_id", (Object)invoiceId, invoiceIndex);
            }
            if (cachedInvoice.size() > 0) {
                this.getPageCache().put(CACHED_INVOICE_KEY, cachedInvoice.toJSONString());
            }
        }
        return serialNos;
    }

    private Boolean dealWxCardPushData(String eventArgs) {
        JSONObject result = null;
        try {
            result = JSON.parseObject((String)eventArgs);
        }
        catch (Exception ex) {
            return Boolean.FALSE;
        }
        if (null == result) {
            return Boolean.FALSE;
        }
        String resource = result.getString("resource");
        JSONObject data = result.getJSONObject("data");
        String type = result.getString("type");
        if (null == data || !"updateSelected".equals(type)) {
            return Boolean.FALSE;
        }
        JSONArray invoiceJSONArray = data.getJSONArray("invoiceData");
        WXCardOperateService operateService = new WXCardOperateService("imageap_wxcard", (AbstractFormPlugin)this);
        String indexPageId = (String)operateService.getCustomParams().get("indexPageId");
        JSONObject businessParam = FpzsMainService.getBusinessParam((String)indexPageId, (String)CollectTypeEnum.WEIXIN.getCode());
        HashMap<Long, BigDecimal> invoiceIdsMap = new HashMap<Long, BigDecimal>(16);
        for (int i = 0; i < invoiceJSONArray.size(); ++i) {
            JSONObject invoiceJson = invoiceJSONArray.getJSONObject(i);
            InvoiceSaveService service = InvoiceSaveService.newInstance((String)invoiceJson.getString("invoiceType"));
            if (service == null) continue;
            invoiceJson.putAll((Map)businessParam);
            try {
                InvoiceSaveResult saveResult = service.save(invoiceJson);
                invoiceIdsMap.put(BigDecimalUtil.transDecimal((Object)saveResult.getMainId()).longValue(), invoiceJson.getBigDecimal("totalAmount"));
                continue;
            }
            catch (MsgException e) {
                logger.error("MobileExpensePlugin\u53d1\u7968\u4fdd\u5b58\u5931\u8d25", (Object)e.getMessage());
            }
        }
        AbstractOperateService.addSelected(indexPageId, invoiceIdsMap, new ArrayList<Long>());
        operateService.refreshSelectedInfo("close");
        return Boolean.TRUE;
    }

    private void initAttachInfo(String expenseId, List<String> serialNos) {
        QFilter attachRelationFilter = new QFilter("expense_id", "=", (Object)expenseId);
        DynamicObjectCollection attachRelationObjs = QueryServiceHelper.query((String)"rim_attach_relation", (String)"attach_id", (QFilter[])attachRelationFilter.toArray());
        ArrayList<Long> attachIds = null;
        if (attachRelationObjs != null && attachRelationObjs.size() > 0) {
            attachIds = new ArrayList<Long>(attachRelationObjs.size());
            for (DynamicObject attachObj : attachRelationObjs) {
                Long attachId;
                if (attachObj == null || attachIds.contains(attachId = Long.valueOf(attachObj.getLong("attach_id")))) continue;
                attachIds.add(attachObj.getLong("attach_id"));
            }
        }
        if (attachIds != null && attachIds.size() > 0) {
            JSONArray cachedAttach = new JSONArray();
            QFilter attachFilter = new QFilter("id", "in", attachIds);
            DynamicObjectCollection attachObjs = QueryServiceHelper.query((String)"rim_attach", (String)"id, original_name", (QFilter[])attachFilter.toArray());
            if (attachObjs != null && attachObjs.size() > 0) {
                for (DynamicObject attachObj : attachObjs) {
                    if (attachObj == null) continue;
                    int attachIndex = this.getModel().createNewEntryRow(ATTACH_ENTRY);
                    String attachName = attachObj.getString("original_name");
                    Object attachId = attachObj.get("id");
                    cachedAttach.add(attachId);
                    this.getModel().setValue("attach_name", (Object)attachName, attachIndex);
                    this.getModel().setValue("attach_id", attachId, attachIndex);
                }
            }
            if (cachedAttach.size() > 0) {
                this.getPageCache().put(CACHED_ATTACH_KEY, cachedAttach.toJSONString());
            }
        }
    }

    private void saveFpyExpense(boolean isSubmit) {
        JSONArray attachIdArray;
        JSONArray invoiceIdArray;
        Map customParam = FpzsMainService.getCustomParam((AbstractFormPlugin)this);
        String invoiceStr = this.getPageCache().get(CACHED_INVOICE_KEY);
        DynamicObjectCollection invoiceCollection = null;
        List<DynamicObject> orderedInvoices = null;
        if (!StringUtils.isEmpty((String)invoiceStr) && (invoiceIdArray = JSONArray.parseArray((String)invoiceStr)) != null && invoiceIdArray.size() > 0) {
            QFilter invoiceFilter = new QFilter("id", "in", (Object)invoiceIdArray.toJavaList(Long.class));
            invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id, serial_no, total_amount, deduction_flag, deduction_purpose, org, original_state, remark", (QFilter[])invoiceFilter.toArray());
            orderedInvoices = this.orderObj(invoiceIdArray.toJavaList(Long.class), invoiceCollection);
        }
        String attachStr = this.getPageCache().get(CACHED_ATTACH_KEY);
        DynamicObjectCollection attachCollection = null;
        List<DynamicObject> orderedAttaches = null;
        List attachIdList = null;
        if (!StringUtils.isEmpty((String)attachStr) && (attachIdArray = JSONArray.parseArray((String)attachStr)) != null && attachIdArray.size() > 0) {
            attachIdList = attachIdArray.toJavaList(Long.class);
            QFilter attachFilter = new QFilter("id", "in", (Object)attachIdList);
            attachCollection = QueryServiceHelper.query((String)"rim_attach", (String)"id, attach_name, attach_no, attach_type, remark, attach_url", (QFilter[])attachFilter.toArray());
            orderedAttaches = this.orderObj(attachIdList, attachCollection);
        }
        String expenseId = String.valueOf(customParam.get("billId"));
        String entityId = String.valueOf(customParam.get("entityId"));
        if (CollectionUtils.isEmpty((Collection)invoiceCollection) && CollectionUtils.isEmpty(attachCollection)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5bfc\u5165\u53d1\u7968\u6216\u9644\u4ef6", (String)"MobileExpensePlugin_46", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((String)expenseId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u62a5\u9500\u5355id", (String)"MobileExpensePlugin_47", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        ExpenseService expenseService = new ExpenseService();
        ExpenseDTO expenseDTO = new ExpenseDTO();
        String expenseNum = (String)customParam.get("billNo");
        expenseDTO.setExpenseId(expenseId);
        expenseDTO.setExpenseNum(expenseNum);
        expenseDTO.setEntityId(entityId);
        expenseDTO.setReimbursingId((String)customParam.get("rim_user"));
        expenseDTO.setBillUser((String)customParam.get("bill_user"));
        expenseDTO.setOrgId(Long.valueOf(BigDecimalUtil.transDecimal(customParam.get("orgId")).longValue()));
        expenseDTO.setExpenseType((String)customParam.get("billType"));
        ArrayList<ExpenseInvoiceDTO> invoiceList = new ArrayList<ExpenseInvoiceDTO>(8);
        ArrayList<ExpenseAttachDTO> attachList = new ArrayList<ExpenseAttachDTO>(8);
        BigDecimal expenseAmount = BigDecimal.ZERO;
        if (orderedInvoices != null && orderedInvoices.size() > 0) {
            for (int i = 0; i < orderedInvoices.size(); ++i) {
                DynamicObject invoiceObj = orderedInvoices.get(i);
                ExpenseInvoiceDTO invoiceDTO = new ExpenseInvoiceDTO();
                String serialNo = invoiceObj.getString("serial_no");
                invoiceDTO.setSerialNo(serialNo);
                invoiceDTO.setExpenseAmount(invoiceObj.getBigDecimal("total_amount"));
                if (invoiceObj.getBigDecimal("total_amount") != null) {
                    expenseAmount = expenseAmount.add(invoiceObj.getBigDecimal("total_amount"));
                }
                invoiceDTO.setDeductionFlag(invoiceObj.getString("deduction_flag"));
                invoiceDTO.setDeductionPurpose(invoiceObj.getString("deduction_purpose"));
                invoiceDTO.setOrgId(Long.valueOf(invoiceObj.getLong("org")));
                invoiceDTO.setOriginalState(invoiceObj.getString("original_state"));
                invoiceDTO.setRemark(invoiceObj.getString("remark"));
                invoiceList.add(invoiceDTO);
            }
            expenseDTO.setInvoiceList(invoiceList);
        }
        if (orderedAttaches != null && orderedAttaches.size() > 0) {
            for (int j = 0; j < orderedAttaches.size(); ++j) {
                DynamicObject attach = orderedAttaches.get(j);
                ExpenseAttachDTO attachDTO = new ExpenseAttachDTO();
                attachDTO.setAttachId(attach.getString("id"));
                attachDTO.setAttachName(attach.getString("attach_name"));
                attachDTO.setAttachNo(attach.getString("attach_no"));
                attachDTO.setAttachRemark(attach.getString("remark"));
                attachDTO.setAttachType(attach.getString("attach_type"));
                attachDTO.setAttachUrl(attach.getString("attach_url"));
                attachList.add(attachDTO);
            }
        }
        expenseDTO.setAttachDTOList(attachList);
        expenseDTO.setStatus("30");
        expenseDTO.setUpdateAttachRelation(true);
        logger.info("\u4fdd\u5b58\u79fb\u52a8\u7aef\u62a5\u9500\u5355\u8bf7\u6c42\u53c2\u6570:" + SerializationUtils.toJsonString((Object)expenseDTO));
        expenseService.save(expenseDTO);
        QFilter expenseFilter = new QFilter("id", "=", (Object)BigDecimalUtil.transDecimal((Object)expenseId).longValue());
        DynamicObject expenseObj = BusinessDataServiceHelper.loadSingle((String)"rim_expense_manage", (String)"id, invoice_num, invoice_total_amount, billstatus, modifytime, org, company_name, company_tax_no, reimburser", (QFilter[])expenseFilter.toArray());
        if (expenseObj == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u62a5\u9500\u5355:%1$s", (String)"MobileExpensePlugin_38", (String)"imc-rim-formplugin", (Object[])new Object[0]), expenseId));
            return;
        }
        expenseObj.set("invoice_num", (Object)invoiceList.size());
        expenseObj.set("invoice_total_amount", (Object)expenseAmount);
        expenseObj.set("org", this.getModel().getValue("cost_org"));
        expenseObj.set("company_name", this.getModel().getValue("cost_company_name"));
        expenseObj.set("company_tax_no", this.getModel().getValue("company_tax_no"));
        expenseObj.set("reimburser", (Object)RequestContext.get().getUserId());
        if (isSubmit) {
            expenseObj.set("billstatus", (Object)"B");
        }
        expenseObj.set("modifytime", (Object)new Date());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{expenseObj});
        if (isSubmit) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"MobileExpensePlugin_48", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"MobileExpensePlugin_49", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        this.loadData();
    }

    private List<DynamicObject> orderObj(List<Long> orderedIdList, DynamicObjectCollection collection) {
        if (orderedIdList == null || orderedIdList.size() == 0 || collection == null || collection.size() == 0) {
            return new ArrayList<DynamicObject>(1);
        }
        HashMap<Long, DynamicObject> attachMap = new HashMap<Long, DynamicObject>(collection.size());
        ArrayList<DynamicObject> orderedCollection = new ArrayList<DynamicObject>(collection.size());
        for (DynamicObject obj : collection) {
            Long id = obj.getLong("id");
            attachMap.put(id, obj);
        }
        for (Long attachId : orderedIdList) {
            orderedCollection.add((DynamicObject)attachMap.get(attachId));
        }
        return orderedCollection;
    }

    private void updateOrgChoose() {
        int invoiceRowCount = this.getModel().getEntryRowCount(INVOICE_ENTRY);
        int attachRowCount = this.getModel().getEntryRowCount(ATTACH_ENTRY);
        if (invoiceRowCount == 0 && attachRowCount == 0) {
            this.getModel().setValue("choose_org", (Object)SHOW);
        } else {
            this.getModel().setValue("choose_org", (Object)HIDE);
        }
    }

    private void updateCompanyName() {
        DynamicObject orgObj = (DynamicObject)this.getModel().getValue("cost_org");
        if (orgObj == null) {
            return;
        }
        Long orgId = (Long)orgObj.getPkValue();
        if (orgId == null || orgId == 0L) {
            return;
        }
        Map companyNameAndTaxNo = TenantUtils.getCompanyNameAndTaxNoByOrgId((Long)orgId);
        String name = (String)companyNameAndTaxNo.get("name");
        String taxNo = (String)companyNameAndTaxNo.get("taxNo");
        this.getModel().setValue("cost_company_name", (Object)name);
        this.getModel().setValue("company_tax_no", (Object)taxNo);
        Map customParam = FpzsMainService.getCustomParam((AbstractFormPlugin)this);
        JSONArray companyInfos = new JSONArray();
        JSONObject info = new JSONObject();
        info.put("taxNo", (Object)taxNo);
        info.put("name", (Object)name);
        companyInfos.add((Object)info);
        customParam.put("companyInfo", companyInfos);
        JSONArray nameList = new JSONArray();
        nameList.add((Object)name);
        JSONArray taxNoList = new JSONArray();
        taxNoList.add((Object)taxNo);
        customParam.put("buyer_tax_no", taxNoList);
        customParam.put("buyer_name", nameList);
        customParam.put("orgId", orgId);
        String orgTaxNo = TenantUtils.getTaxNoByOrgId((Long)orgId);
        if (StringUtils.isEmpty((String)orgTaxNo)) {
            orgTaxNo = taxNo;
        }
        customParam.put("taxNo", orgTaxNo);
        String content = JSON.toJSONString((Object)customParam);
        FpzsMainService.cacheCustomParam((AbstractFormPlugin)this, (String)content);
    }

    private void addNewInvoice() {
        FormShowParameter showParameter = new FormShowParameter();
        Map customParam = FpzsMainService.getCustomParam((AbstractFormPlugin)this);
        showParameter.setCustomParams(customParam);
        showParameter.setFormId("rim_mobile_index");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_mobile_index");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private Map<String, Object> buildExpenseParam(String expenseNo) {
        QFilter expenseFilter = new QFilter("billno", "=", (Object)expenseNo);
        DynamicObject expenseInfo = QueryServiceHelper.queryOne((String)"rim_expense_manage", (String)"id, expense_type.number as bill_type, reimburser, reimburser.name as name, creator, company_tax_no, company_name, org", (QFilter[])expenseFilter.toArray());
        if (expenseInfo == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7f16\u53f7\u4e3a%1$s\u7684\u5355\u636e\u4fe1\u606f", (String)"MobileExpensePlugin_50", (String)"imc-rim-formplugin", (Object[])new Object[0]), expenseNo));
            this.getView().close();
            return null;
        }
        String resource = "expense_mobile";
        Long userId = RequestContext.get().getCurrUserId();
        String userName = RequestContext.get().getUserName();
        String openId = MD5.md5Hex((String)(RequestContext.get().getTenantId() + resource + userId));
        HashMap<String, Object> customParam = new HashMap<String, Object>(8);
        String expenseBillType = expenseInfo.getString("bill_type");
        customParam.put("billType", expenseBillType);
        customParam.put("billNo", expenseNo);
        customParam.put("billId", BigDecimalUtil.transDecimal((Object)expenseInfo.get("id")).longValue());
        customParam.put("entityId", expenseBillType);
        customParam.put("viewPage", "");
        customParam.put("reimburser", userId);
        customParam.put("reimburserName", userName);
        customParam.put("bill_user", userId);
        customParam.put("resource", resource);
        customParam.put("sourceSys", ResManager.loadKDString((String)"\u82cd\u7a79\u62a5\u9500\u5355\u79fb\u52a8\u7aef\u91c7\u96c6", (String)"MobileExpensePlugin_51", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        customParam.put("orgId", BigDecimalUtil.transDecimal((Object)expenseInfo.get("org")).longValue());
        JSONArray companyInfos = new JSONArray();
        JSONObject companyInfo = new JSONObject();
        companyInfo.put("taxNo", expenseInfo.get("company_tax_no"));
        companyInfo.put("name", expenseInfo.get("company_name"));
        companyInfos.add((Object)companyInfo);
        customParam.put("companyInfo", companyInfos);
        JSONObject param = FpzsMainService.cacheCustomParam((AbstractFormPlugin)this, customParam);
        HashMap<String, LocaleString> ctrl = new HashMap<String, LocaleString>(2);
        ctrl.put("text", new LocaleString(ResManager.loadKDString((String)"\u5bfc\u5165\u5355\u636e", (String)"MobileExpensePlugin_52", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        this.getView().updateControlMetadata("push_pc", ctrl);
        return param;
    }
}

