/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.mobile.home;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.config.client.ConfigurationFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BadgeInfo;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.FpzsConstant;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.invoice.collector.ScannerService;
import kd.imc.rim.common.invoice.file.InvoiceAttachCaremaService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.license.LicenseFormPlugin;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.RimUserService;
import kd.imc.rim.formplugin.mobile.home.operate.AbstractOperateService;
import kd.imc.rim.formplugin.mobile.home.operate.InvoiceListOperateService;
import kd.imc.rim.formplugin.mobile.home.operate.WXCardOperateService;

public class MobileIndexPlugin
extends LicenseFormPlugin {
    private static Log logger = LogFactory.getLog(MobileIndexPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"imageap_scan", "imageap_handwork"});
        this.addClickListeners(new String[]{"imageap_dd", "imageap_mail"});
        this.addClickListeners(new String[]{"imageap_ype", "imageap_invoicelist"});
        this.addClickListeners(new String[]{"imageap_file", "imageap_wxcard"});
        this.addClickListeners(new String[]{"select_invoice", "select_attach"});
        this.addClickListeners(new String[]{"push_pc", "imageap_msg"});
    }

    public void afterCreateNewData(EventObject e) {
        String sourceSys;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String jsonStr = SerializationUtils.toJsonString((Object)customParams);
        logger.info("MobileIndexPlugin-cacheCustomParam:" + jsonStr);
        logger.info("\u9996\u9875pageId" + this.getView().getPageId());
        JSONObject jsonObj = JSON.parseObject((String)jsonStr);
        String fpzsPageId = jsonObj.getString("fpzsPageId");
        String appType = (String)customParams.get("appType");
        String eventCode = jsonObj.getString("eventCode");
        String billType = "";
        String socketId = null;
        Long orgId = 0L;
        Object param = null;
        if (StringUtils.isNotEmpty((CharSequence)eventCode)) {
            param = FpzsMainService.cacheCustomParam((AbstractFormPlugin)this);
            socketId = (String)param.get("linkKey");
            billType = (String)param.get("billType");
            HashMap<String, LocaleString> ctrl = new HashMap<String, LocaleString>(2);
            ctrl.put("text", new LocaleString(ResManager.loadKDString((String)"\u5bfc\u5165\u5355\u636e", (String)"MobileIndexPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0])));
            this.getView().updateControlMetadata("push_pc", ctrl);
        } else if (fpzsPageId != null) {
            param = FpzsMainService.getCustomParam((String)fpzsPageId);
            logger.info("\u53d1\u7968\u52a9\u624b\u626b\u7801\u8fdb\u5165\u79fb\u52a8\u7aef\u9996\u9875\u53c2\u6570:{}", param);
            if (!"0".equals(appType)) {
                param.put("indexPageId", this.getView().getPageId());
            } else {
                param.put("indexPageId", fpzsPageId);
            }
            param.put("fpzsPageId", fpzsPageId);
            sourceSys = (String)param.get("sourceSys");
            billType = (String)param.get("billType");
            orgId = BigDecimalUtil.transDecimal(param.get("orgId")).longValue();
            if (StringUtils.isEmpty((CharSequence)sourceSys) || "\u53d1\u7968\u52a9\u624b".equals(sourceSys)) {
                param.put("sourceSys", "\u79fb\u52a8\u7aef\u91c7\u96c6");
            }
            socketId = (String)param.get("indexPageId");
            FpzsMainService.cacheCustomParam((AbstractFormPlugin)this, (String)SerializationUtils.toJsonString((Object)param));
        } else {
            param = FpzsMainService.cacheCustomParam((AbstractFormPlugin)this);
            logger.info("\u79fb\u52a8\u7aef\u8fdb\u5165\u79fb\u52a8\u7aef\u9996\u9875\u53c2\u6570:{}", param);
            socketId = (String)param.get("indexPageId");
            sourceSys = (String)param.get("sourceSys");
            if (StringUtils.isEmpty((CharSequence)sourceSys) || "\u53d1\u7968\u52a9\u624b".equals(sourceSys)) {
                param.put("sourceSys", "\u79fb\u52a8\u7aef\u91c7\u96c6");
                FpzsMainService.cacheCustomParam((AbstractFormPlugin)this, (String)SerializationUtils.toJsonString((Object)param));
            }
            billType = (String)param.get("billType");
            orgId = BigDecimalUtil.transDecimal(param.get("orgId")).longValue();
            HashMap<String, LocaleString> ctrl = new HashMap<String, LocaleString>(2);
            ctrl.put("text", new LocaleString(ResManager.loadKDString((String)"\u5bfc\u5165\u5355\u636e", (String)"MobileIndexPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0])));
            this.getView().updateControlMetadata("push_pc", ctrl);
        }
        String flexKey = this.showAndHideButton(billType, orgId);
        Object resource = customParams.get("resource");
        String showWxCard = RimConfigUtils.getConfig((String)"show_wxcard");
        if ("expense_mobile".equals(resource) || "1".equals(showWxCard)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"mob_invoice_wxcard"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mob_invoice_wxcard"});
        }
        CustomControl customControl = (CustomControl)this.getControl("custom_interval");
        ScannerService.startWebScoket((CustomControl)customControl, (String)AbstractOperateService.getIndexWebsocketId(socketId));
        Map fpzsConfig = ImcConfigUtil.getValue((String)"rim_fpzs");
        this.loadUserAndOrgInfo((Map<String, Object>)param);
        this.initCount("select_invoice");
        this.initCount("select_attach");
        new InvoiceListOperateService("imageap_invoicelist", (AbstractFormPlugin)this).refreshSelectedInfo("close");
        this.loadUploadPlugin(fpzsConfig, (Map<String, Object>)param, flexKey);
        this.loadAppAuthCustonPlugin(appType, fpzsConfig);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        AbstractOperateService operate = AbstractOperateService.newInstance(control.getKey(), (AbstractFormPlugin)this);
        if (operate != null) {
            operate.operate();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        AbstractOperateService operate = AbstractOperateService.newInstance(actionId, (AbstractFormPlugin)this);
        if (operate != null) {
            operate.closedCallBack(closedCallBackEvent);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        logger.info("MobileIndexPlugin.customEvent:{},{}", (Object)eventName, (Object)eventArgs);
        AbstractOperateService operate = AbstractOperateService.newInstance(eventName, (AbstractFormPlugin)this);
        if (operate != null) {
            operate.customEvent(e);
        } else if ("showmsg".equals(eventName)) {
            this.getView().showTipNotification(eventArgs, Integer.valueOf(4000));
        } else if ("interval".equals(eventName)) {
            InvoiceListOperateService service = new InvoiceListOperateService("imageap_invoicelist", (AbstractFormPlugin)this);
            String indexPageId = (String)service.getCustomParams().get("indexPageId");
            CacheHelper.put((String)(indexPageId + "pushType"), (String)"poll", (int)3600);
            service.refreshSelectedInfo("poll");
        } else if ("pushData".equals(eventName) || "onMessage".equals(eventName)) {
            if (!this.dealWxCardPushData(eventArgs).booleanValue()) {
                InvoiceListOperateService service = new InvoiceListOperateService("imageap_invoicelist", (AbstractFormPlugin)this);
                String indexPageId = (String)service.getCustomParams().get("indexPageId");
                CacheHelper.put((String)(indexPageId + "pushType"), (String)"websocket", (int)3600);
                service.refreshSelectedInfo("websocket");
            }
        } else if ("appauth".equals(eventName)) {
            String checkAppAuth = this.getPageCache().get("checkAppAuth");
            if (StringUtils.isNotEmpty((CharSequence)checkAppAuth)) {
                JSONObject auth = JSONObject.parseObject((String)e.getEventArgs());
                if ("0000".equals(auth.getString("errcode"))) {
                    JSONObject result = auth.getJSONObject("result");
                    String type = auth.getString("type");
                    JSONObject data = result.getJSONObject("data");
                    String openId = data.getString("openId");
                    String openName = data.getString("name");
                    Map map = FpzsMainService.getCustomParam((AbstractFormPlugin)this);
                    Long oldRimUser = BigDecimalUtil.transDecimal(map.get("rim_user")).longValue();
                    Long rimUser = RimUserService.createRimUser((Long)oldRimUser, (String)type, (String)openId, (String)openName);
                    map.put("rim_user", rimUser);
                    map.put("openId", openId);
                    FpzsMainService.cacheCustomParam((AbstractFormPlugin)this, (String)SerializationUtils.toJsonString((Object)map));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u79fb\u52a8\u7aef\u7528\u6237\u4fe1\u606f\u5931\u8d25", (String)"MobileIndexPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(4000));
                }
            }
        } else {
            AbstractOperateService service = AbstractOperateService.getCameraService(eventName, eventArgs, (AbstractFormPlugin)this);
            if (service != null) {
                service.customEvent(e);
            }
        }
    }

    private void initCount(String key) {
        Image image = (Image)this.getControl(key);
        BadgeInfo checkFailInfo = new BadgeInfo();
        checkFailInfo.setOverflowCount(Integer.valueOf(99));
        checkFailInfo.setOffset(new String[]{"-5px", "-5px"});
        checkFailInfo.setDot(false);
        checkFailInfo.setCount(Integer.valueOf(0));
        image.setBadgeInfo(checkFailInfo);
    }

    private String showAndHideButton(String billType, Long orgId) {
        Control control2;
        String formId = this.getView().getEntityId();
        JSONObject mobileConfig = FpzsMainService.getOperateConfigMap((String)billType, (String)"mobile_config_tag", (Long)orgId);
        Boolean showAttachFlex = Boolean.TRUE;
        LinkedHashSet<String> flexKeySet = new LinkedHashSet<String>(4);
        Boolean showInvoiceFlex = Boolean.TRUE;
        List<String> mobileInvoiceConfigKey = Arrays.asList(FpzsConstant.default_mob_invoice_operate);
        Boolean allHide = this.initMobileFlex(mobileConfig, mobileInvoiceConfigKey, "invoice");
        if (allHide.booleanValue()) {
            showInvoiceFlex = Boolean.FALSE;
        }
        String invoiceCameraShowType = mobileConfig.getString("mob_invoice_camera");
        Boolean showInvoiceCamera = FpzsMainService.getPermissionResult((String)invoiceCameraShowType, (String)"2V02RZGF97HS", (String)formId);
        List<String> mobileAttachConfigKey = Arrays.asList(FpzsConstant.default_mob_attach_operate);
        allHide = this.initMobileFlex(mobileConfig, mobileAttachConfigKey, "attach");
        if (allHide.booleanValue()) {
            showAttachFlex = Boolean.FALSE;
        }
        String attachCameraShowType = mobileConfig.getString("mob_attach_camera");
        Boolean showAttachCamera = FpzsMainService.getPermissionResult((String)attachCameraShowType, (String)"2V031VW2NS9Q", (String)formId);
        if (showInvoiceFlex.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"invoice_flex"});
        }
        if (showAttachFlex.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"attach_flex"});
        }
        if (!showInvoiceFlex.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_flex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"select_invoice"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_amount"});
        } else if (showInvoiceCamera.booleanValue()) {
            flexKeySet.add("imageap_upload");
        }
        if (!showAttachFlex.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attach_flex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"select_attach"});
            this.getPageCache().put("showAttach", "0");
        } else if (showAttachCamera.booleanValue()) {
            flexKeySet.add("imageap_attach");
        }
        Control control1 = this.getControl("imageap_upload_file");
        if (control1 != null) {
            flexKeySet.add("imageap_upload_file");
        }
        if ((control2 = this.getControl("imageap_attach_file")) != null) {
            flexKeySet.add("imageap_attach_file");
        }
        String flexKey = String.join((CharSequence)",", flexKeySet);
        if (!showAttachFlex.booleanValue() && !showInvoiceFlex.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u91c7\u96c6\u53d1\u7968\u548c\u91c7\u96c6\u9644\u4ef6\u7684\u6743\u9650\uff0c\u8bf7\u5148\u914d\u7f6e\u597d\u6743\u9650\u540e\u518d\u8fdb\u884c\u91c7\u96c6!", (String)"MobileIndexPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        return flexKey;
    }

    private Boolean dealWxCardPushData(String eventArgs) {
        IFormView frameView;
        JSONObject result = null;
        try {
            result = JSON.parseObject((String)eventArgs);
        }
        catch (Exception ex) {
            return Boolean.FALSE;
        }
        if (null == result) {
            return Boolean.FALSE;
        }
        String resource = result.getString("resource");
        JSONObject data = result.getJSONObject("data");
        String type = result.getString("type");
        if (null == data || !"updateSelected".equals(type)) {
            return Boolean.FALSE;
        }
        JSONArray invoiceJSONArray = data.getJSONArray("invoiceData");
        WXCardOperateService operateService = new WXCardOperateService("imageap_wxcard", (AbstractFormPlugin)this);
        String indexPageId = (String)operateService.getCustomParams().get("indexPageId");
        JSONObject businessParam = FpzsMainService.getBusinessParam((String)indexPageId, (String)CollectTypeEnum.WEIXIN.getCode());
        HashMap<Long, BigDecimal> invoiceIdsMap = new HashMap<Long, BigDecimal>(16);
        for (int i = 0; i < invoiceJSONArray.size(); ++i) {
            JSONObject invoiceJson = invoiceJSONArray.getJSONObject(i);
            InvoiceSaveService service = InvoiceSaveService.newInstance((String)invoiceJson.getString("invoiceType"));
            if (service == null) continue;
            try {
                invoiceJson.putAll((Map)businessParam);
                InvoiceSaveResult saveResult = service.save(invoiceJson);
                invoiceIdsMap.put(BigDecimalUtil.transDecimal((Object)saveResult.getMainId()).longValue(), invoiceJson.getBigDecimal("totalAmount"));
                continue;
            }
            catch (MsgException e) {
                logger.error("MobileIndexPlugin\u53d1\u7968\u4fdd\u5b58\u5931\u8d25", (Object)e.getMessage());
            }
        }
        AbstractOperateService.addSelected(indexPageId, invoiceIdsMap, new ArrayList<Long>());
        operateService.refreshSelectedInfo("close");
        String framePageId = this.getPageCache().get("frame_page_id");
        if (!StringUtils.isEmpty((CharSequence)framePageId) && (frameView = this.getView().getView(framePageId)) != null) {
            frameView.close();
        }
        return Boolean.TRUE;
    }

    private void loadUserAndOrgInfo(Map<String, Object> param) {
        long orgId;
        RequestContext requestContext = RequestContext.get();
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        String userName = requestContext.getUserName();
        Long userId = BigDecimalUtil.transDecimal((Object)param.get(InvoiceSaveConstant.OPERATE_USER_ID)).longValue();
        if (userId <= 0L) {
            userId = Long.parseLong(requestContext.getUserId());
        }
        userIds.add(userId);
        List userInfoList = UserServiceHelper.get(userIds);
        if (!CollectionUtils.isEmpty((Collection)userInfoList)) {
            Map userInfo = (Map)userInfoList.get(0);
            ILocaleString name = (ILocaleString)userInfo.get("name");
            userName = name != null ? name.getLocaleValue() : "";
            Image image = (Image)this.getControl("imageap");
            String picturefield = (String)userInfo.get("picturefield");
            String fileServerUrl = ConfigurationFactory.getGlobalConfiguration().getProperty("fileserver");
            if (picturefield != null) {
                if (!picturefield.startsWith("http")) {
                    image.setUrl(fileServerUrl + (String)userInfo.get("picturefield"));
                } else {
                    image.setUrl(picturefield);
                }
            }
        }
        if ((orgId = BigDecimalUtil.transDecimal((Object)param.get("orgId")).longValue()) < 1L) {
            orgId = RequestContext.get().getOrgId();
        }
        Map orgMap = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{orgId}, (String)"bos_org");
        Label username = (Label)this.getView().getControl("username");
        username.setText(userName);
        Label orgname = (Label)this.getView().getControl("orgname");
        DynamicObject org = (DynamicObject)orgMap.get(orgId);
        orgname.setText(org.getString("name"));
    }

    private void loadAppAuthCustonPlugin(String appType, Map<String, String> fpzsConfig) {
        if (StringUtils.isNotEmpty((CharSequence)appType) && !"0".equals(appType)) {
            this.getPageCache().put("checkAppAuth", appType);
            JSONObject authUploadParam = new JSONObject();
            String jsurl = fpzsConfig.get("appjs");
            if (StringUtils.isEmpty((CharSequence)jsurl)) {
                authUploadParam.put("url", (Object)"https://static.yunzhijia.com/public/js/qing/latest/qing.js");
            } else {
                authUploadParam.put("url", (Object)jsurl);
            }
            authUploadParam.put("urlType", (Object)appType);
            CustomControl authControlAp = (CustomControl)this.getControl("customcontrolap_app");
            authControlAp.setData((Object)authUploadParam);
        }
    }

    private void loadUploadPlugin(Map<String, String> fpzsConfig, Map<String, Object> customParams, String flexKey) {
        CustomControl uploadCustomControlAp = (CustomControl)this.getControl("customcontrolap_upload");
        InvoiceAttachCaremaService.loadPlugin(fpzsConfig, customParams, (CustomControl)uploadCustomControlAp, (String)flexKey);
    }

    private Boolean initMobileFlex(JSONObject fpzsConfig, List<String> defaultConfigList, String flexType) {
        String invoiceShowType;
        Boolean invoiceShowFlag;
        String attachShowType;
        Boolean attachShowFlag;
        String entityId = this.getView().getEntityId();
        Map permMap = FpzsConstant.createPermMap();
        Boolean allHide = Boolean.TRUE;
        if ("attach".equals(flexType) && !(attachShowFlag = FpzsMainService.getPermissionResult((String)(attachShowType = fpzsConfig.getString("mobile_attach")), (String)((String)permMap.get("mobile_attach")), (String)entityId)).booleanValue()) {
            return allHide;
        }
        if ("invoice".equals(flexType) && !(invoiceShowFlag = FpzsMainService.getPermissionResult((String)(invoiceShowType = fpzsConfig.getString("mobile_invoice")), (String)((String)permMap.get("mobile_invoice")), (String)entityId)).booleanValue()) {
            return allHide;
        }
        for (String defaultConfig : defaultConfigList) {
            String showType = fpzsConfig.getString(defaultConfig);
            Boolean showFlag = FpzsMainService.getPermissionResult((String)showType, (String)((String)permMap.get(defaultConfig)), (String)entityId);
            this.getView().setVisible(showFlag, new String[]{defaultConfig});
            if (!showFlag.booleanValue()) continue;
            allHide = Boolean.FALSE;
        }
        return allHide;
    }
}

