/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.mobile.home.operate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BadgeInfo;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.formplugin.mobile.home.operate.AttachOperateService;
import kd.imc.rim.formplugin.mobile.home.operate.DdOperateService;
import kd.imc.rim.formplugin.mobile.home.operate.HandworkOperateService;
import kd.imc.rim.formplugin.mobile.home.operate.InvoiceListOperateService;
import kd.imc.rim.formplugin.mobile.home.operate.MailOperateService;
import kd.imc.rim.formplugin.mobile.home.operate.MsgOperateService;
import kd.imc.rim.formplugin.mobile.home.operate.PushPcOperateService;
import kd.imc.rim.formplugin.mobile.home.operate.ScanOperateService;
import kd.imc.rim.formplugin.mobile.home.operate.SelectedAttachOperateService;
import kd.imc.rim.formplugin.mobile.home.operate.SelectedInvoiceOperateService;
import kd.imc.rim.formplugin.mobile.home.operate.UploadOperateService;
import kd.imc.rim.formplugin.mobile.home.operate.WXCardOperateService;

public abstract class AbstractOperateService {
    private static Log logger = LogFactory.getLog(AbstractOperateService.class);
    public static final String OPERATE_TYPE_UPOLAD = "imageap_upload";
    public static final String OPERATE_TYPE_ATTACH = "imageap_attach";
    public static final String OPERATE_TYPE_SCAN = "imageap_scan";
    public static final String OPERATE_TYPE_HANDWORK = "imageap_handwork";
    public static final String OPERATE_TYPE_DD = "imageap_dd";
    public static final String OPERATE_TYPE_MAIL = "imageap_mail";
    public static final String OPERATE_TYPE_MSG = "imageap_msg";
    public static final String OPERATE_TYPE_YPE = "imageap_ype";
    public static final String OPERATE_TYPE_WXCARD = "imageap_wxcard";
    public static final String OPERATE_TYPE_FILE = "imageap_file";
    public static final String OPERATE_TYPE_INVOICELIST = "imageap_invoicelist";
    public static final String OPERATE_TYPE_SELECT_INVOICE = "select_invoice";
    public static final String OPERATE_TYPE_SELECT_ATTACH = "select_attach";
    public static final String OPERATE_TYPE_PUSH_PC = "push_pc";
    public static final String CACHE_SELECTED_INVOICE = "cache_selected_invoice";
    public static final String CACHE_SELECTED_ATTACH = "cache_selected_attach";
    public static final String CACHE_IFRAME_PAGE_ID = "frame_page_id";
    private static int timeOut = 7200;
    protected AbstractFormPlugin plugin;
    protected String type;

    public static AbstractOperateService newInstance(String type, AbstractFormPlugin plugin) {
        AbstractOperateService service = AbstractOperateService.getCustomService(type, plugin);
        if (service != null) {
            return service;
        }
        if (OPERATE_TYPE_UPOLAD.equals(type)) {
            return new UploadOperateService(type, plugin);
        }
        if (OPERATE_TYPE_ATTACH.equals(type)) {
            return new AttachOperateService(type, plugin);
        }
        if (OPERATE_TYPE_SCAN.equals(type)) {
            return new ScanOperateService(type, plugin);
        }
        if (OPERATE_TYPE_HANDWORK.equals(type)) {
            return new HandworkOperateService(type, plugin);
        }
        if (OPERATE_TYPE_DD.equals(type)) {
            return new DdOperateService(type, plugin);
        }
        if (OPERATE_TYPE_MAIL.equals(type)) {
            return new MailOperateService(type, plugin);
        }
        if (OPERATE_TYPE_MSG.equals(type)) {
            return new MsgOperateService(type, plugin);
        }
        if (!OPERATE_TYPE_YPE.equals(type) && !OPERATE_TYPE_FILE.equals(type)) {
            if (OPERATE_TYPE_INVOICELIST.equals(type)) {
                return new InvoiceListOperateService(type, plugin);
            }
            if (OPERATE_TYPE_SELECT_INVOICE.equals(type)) {
                return new SelectedInvoiceOperateService(type, plugin);
            }
            if (OPERATE_TYPE_SELECT_ATTACH.equals(type)) {
                return new SelectedAttachOperateService(type, plugin);
            }
            if (OPERATE_TYPE_PUSH_PC.equals(type)) {
                return new PushPcOperateService(type, plugin);
            }
            if ("scanQRCode".equals(type)) {
                return new ScanOperateService(type, plugin);
            }
            if (OPERATE_TYPE_WXCARD.equals(type)) {
                return new WXCardOperateService(type, plugin);
            }
        }
        return null;
    }

    public static AbstractOperateService getCameraService(String eventName, String eventArgs, AbstractFormPlugin plugin) {
        if (StringUtils.isNotEmpty((String)eventArgs)) {
            if ("cameraUploadStart".equals(eventName) || "cameraUpload".equals(eventName) || "mobileFileUpload".equals(eventName)) {
                String flex = AbstractOperateService.getFlexKey(eventArgs);
                AbstractOperateService service = AbstractOperateService.getCustomService(flex, plugin);
                if (service != null) {
                    return service;
                }
                if (flex.contains(OPERATE_TYPE_UPOLAD)) {
                    return new UploadOperateService(OPERATE_TYPE_UPOLAD, plugin);
                }
                return new AttachOperateService(OPERATE_TYPE_ATTACH, plugin);
            }
            return new AttachOperateService(OPERATE_TYPE_ATTACH, plugin);
        }
        return null;
    }

    private static String getFlexKey(String eventArgs) {
        try {
            JSONObject json = JSONObject.parseObject((String)eventArgs);
            String flex = json.getString("flex");
            if (StringUtils.isNotEmpty((String)flex)) {
                return flex;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return eventArgs;
    }

    private static AbstractOperateService getCustomService(String type, AbstractFormPlugin plugin) {
        String serivice = RimConfigUtils.getConfig((String)"rim_mobile_service", (String)type);
        if (StringUtils.isNotEmpty((String)serivice)) {
            try {
                Class<?> className = Class.forName(serivice);
                Constructor<?> constructor = className.getConstructor(String.class, AbstractFormPlugin.class);
                AbstractOperateService service = (AbstractOperateService)constructor.newInstance(type, plugin);
                logger.info("\u79fb\u52a8\u7aef\u81ea\u5b9a\u4e49\u65b9\u6cd5{}:{}", (Object)type, (Object)serivice);
                return service;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public abstract void operate();

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        logger.info("closedCallBack:{}", (Object)closedCallBackEvent.getActionId());
    }

    public static String getIndexWebsocketId(String indexPageId) {
        return "m" + indexPageId + "pc";
    }

    public void customEvent(CustomEventArgs e) {
    }

    public void refreshSelectedInfo(String type) {
        String indexPageId = (String)this.getCustomParams().get("indexPageId");
        String refresh = CacheHelper.get((String)(indexPageId + "refresh"));
        logger.info("\u5237\u65b0\u7edf\u8ba1\u4fe1\u606fpageId:{},{},{},{}", new Object[]{this.plugin.getView().getPageId(), indexPageId, refresh, type});
        if ("poll".equals(type) && StringUtils.isEmpty((String)refresh)) {
            return;
        }
        int invoiceCount = 0;
        String cacheStr = CacheHelper.get((String)(indexPageId + CACHE_SELECTED_INVOICE));
        JSONObject array = null;
        BigDecimal total = BigDecimal.ZERO;
        if (!StringUtils.isEmpty((String)cacheStr)) {
            array = JSONObject.parseObject((String)cacheStr);
            invoiceCount = array.size();
            Set keySet = array.keySet();
            for (String key : keySet) {
                total = total.add(array.getBigDecimal(key));
            }
        }
        Label lb = (Label)this.plugin.getView().getControl("label_amount");
        DecimalFormat decimalFormat = new DecimalFormat("###,##0.00");
        if (lb != null) {
            lb.setText(String.format(ResManager.loadKDString((String)"\u5408\u8ba1:%1$s", (String)"AbstractOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), decimalFormat.format(total)));
        }
        this.setCount(OPERATE_TYPE_SELECT_INVOICE, invoiceCount);
        int attachCount = 0;
        cacheStr = CacheHelper.get((String)(indexPageId + CACHE_SELECTED_ATTACH));
        if (!StringUtils.isEmpty((String)cacheStr)) {
            JSONArray attachArray = JSONArray.parseArray((String)cacheStr);
            attachCount = attachArray.size();
        }
        this.setCount(OPERATE_TYPE_SELECT_ATTACH, attachCount);
        CacheHelper.remove((String)(indexPageId + "refresh"));
    }

    private void setCount(String key, int count) {
        Image image = (Image)this.plugin.getControl(key);
        BadgeInfo checkFailInfo = new BadgeInfo();
        checkFailInfo.setOverflowCount(Integer.valueOf(99));
        checkFailInfo.setOffset(new String[]{"-5px", "-5px"});
        checkFailInfo.setDot(false);
        checkFailInfo.setCount(Integer.valueOf(count));
        checkFailInfo.setShowZero(false);
        checkFailInfo.setBadgeText("");
        if (count > 0) {
            checkFailInfo.setBadgeText(count + "");
        }
        if (image != null) {
            image.setBadgeInfo(checkFailInfo);
        }
    }

    public void addSelected(String pageId, Map<Long, BigDecimal> invoiceIds, List<Long> attachIds, boolean isInvoiceBox) {
        if (isInvoiceBox) {
            String cacheStr;
            logger.info("\u6dfb\u52a0\u5df2\u9009\u53d1\u7968{},{},{}", new Object[]{pageId, invoiceIds, attachIds});
            if (CollectionUtils.isEmpty(invoiceIds)) {
                cacheStr = CacheHelper.get((String)(pageId + CACHE_SELECTED_INVOICE));
                JSONObject array = new JSONObject(true);
                if (!StringUtils.isEmpty((String)cacheStr)) {
                    array = JSONObject.parseObject((String)cacheStr, (Feature[])new Feature[]{Feature.OrderedField});
                }
                CacheHelper.put((String)(pageId + CACHE_SELECTED_INVOICE), (String)array.toJSONString(), (int)7200);
                logger.info("\u5df2\u9009\u53d1\u7968\u7f13\u5b58\u7ed3\u679c\uff1a{}", (Object)array);
            }
            if (CollectionUtils.isEmpty(attachIds)) {
                cacheStr = CacheHelper.get((String)(pageId + CACHE_SELECTED_ATTACH));
                LinkedHashSet<Long> attachSet = new LinkedHashSet<Long>();
                if (!StringUtils.isEmpty((String)cacheStr)) {
                    JSONArray array = JSONArray.parseArray((String)cacheStr);
                    for (int i = 0; i < array.size(); ++i) {
                        attachSet.add(array.getLong(i));
                    }
                }
                CacheHelper.put((String)(pageId + CACHE_SELECTED_ATTACH), (String)SerializationUtils.toJsonString(attachSet), (int)timeOut);
            }
        }
        AbstractOperateService.addSelected(pageId, invoiceIds, attachIds);
    }

    public static void addSelected(String pageId, Map<Long, BigDecimal> invoiceIds, List<Long> attachIds) {
        String cacheStr;
        logger.info("\u6dfb\u52a0\u5df2\u9009\u53d1\u7968{},{},{}", new Object[]{pageId, invoiceIds, attachIds});
        Boolean refresh = Boolean.FALSE;
        if (!CollectionUtils.isEmpty(invoiceIds)) {
            cacheStr = CacheHelper.get((String)(pageId + CACHE_SELECTED_INVOICE));
            JSONObject array = new JSONObject(true);
            if (!StringUtils.isEmpty((String)cacheStr)) {
                array = JSONObject.parseObject((String)cacheStr, (Feature[])new Feature[]{Feature.OrderedField});
            }
            for (Map.Entry<Long, BigDecimal> entry : invoiceIds.entrySet()) {
                Long key = entry.getKey();
                array.put(((Object)key).toString(), (Object)entry.getValue());
            }
            CacheHelper.put((String)(pageId + CACHE_SELECTED_INVOICE), (String)array.toJSONString(), (int)7200);
            logger.info("\u5df2\u9009\u53d1\u7968\u7f13\u5b58\u7ed3\u679c\uff1a{}", (Object)array);
            refresh = Boolean.TRUE;
        }
        if (!CollectionUtils.isEmpty(attachIds)) {
            cacheStr = CacheHelper.get((String)(pageId + CACHE_SELECTED_ATTACH));
            LinkedHashSet<Long> attachSet = new LinkedHashSet<Long>(attachIds);
            if (!StringUtils.isEmpty((String)cacheStr)) {
                JSONArray array = JSONArray.parseArray((String)cacheStr);
                for (int i = 0; i < array.size(); ++i) {
                    attachSet.add(array.getLong(i));
                }
            }
            CacheHelper.put((String)(pageId + CACHE_SELECTED_ATTACH), (String)SerializationUtils.toJsonString(attachSet), (int)timeOut);
            refresh = Boolean.TRUE;
        }
        if (refresh.booleanValue()) {
            String pushType = CacheHelper.get((String)(pageId + "pushType"));
            CacheHelper.put((String)(pageId + "refresh"), (String)"1", (int)timeOut);
            if (!"poll".equals(pushType)) {
                MsgSendFactory.getSender().send(AbstractOperateService.getIndexWebsocketId(pageId), "refresh");
            }
        }
    }

    public static void deleteSelected(String pageId, Map<Long, BigDecimal> invoiceIds, List<Long> attachIds) {
        JSONObject array;
        logger.info("\u5220\u9664\u5df2\u9009\u53d1\u7968{},{},{}", new Object[]{pageId, invoiceIds, attachIds});
        String cacheStr = CacheHelper.get((String)(pageId + CACHE_SELECTED_INVOICE));
        Boolean refresh = Boolean.FALSE;
        if (!StringUtils.isEmpty((String)cacheStr)) {
            array = JSONObject.parseObject((String)cacheStr, (Feature[])new Feature[]{Feature.OrderedField});
            if (!CollectionUtils.isEmpty(invoiceIds)) {
                for (Map.Entry<Long, BigDecimal> entry : invoiceIds.entrySet()) {
                    array.remove((Object)String.valueOf(entry.getKey()));
                }
            }
            CacheHelper.put((String)(pageId + CACHE_SELECTED_INVOICE), (String)array.toJSONString(), (int)timeOut);
            refresh = Boolean.TRUE;
        }
        if (!StringUtils.isEmpty((String)(cacheStr = CacheHelper.get((String)(pageId + CACHE_SELECTED_ATTACH))))) {
            array = JSONArray.parseArray((String)cacheStr);
            if (!CollectionUtils.isEmpty(attachIds)) {
                HashSet<Long> attachSet = new HashSet<Long>(attachIds);
                HashSet<Long> existsSet = new HashSet<Long>(16);
                for (int i = 0; i < array.size(); ++i) {
                    existsSet.add(array.getLong(i));
                }
                existsSet.removeAll(attachSet);
                CacheHelper.put((String)(pageId + CACHE_SELECTED_ATTACH), (String)SerializationUtils.toJsonString(existsSet), (int)timeOut);
                refresh = Boolean.TRUE;
            }
        }
        if (refresh.booleanValue()) {
            String pushType = CacheHelper.get((String)(pageId + "pushType"));
            CacheHelper.put((String)(pageId + "refresh"), (String)"1", (int)timeOut);
            if (!"poll".equals(pushType)) {
                MsgSendFactory.getSender().send(AbstractOperateService.getIndexWebsocketId(pageId), "refresh");
            }
        }
    }

    protected void clearCache() {
        String indexPageId = (String)this.getCustomParams().get("indexPageId");
        CacheHelper.remove((String)(indexPageId + CACHE_SELECTED_INVOICE));
        CacheHelper.remove((String)(indexPageId + CACHE_SELECTED_ATTACH));
        this.refreshSelectedInfo("close");
    }

    public Map<String, Object> getCustomParams() {
        String pageId = this.plugin.getView().getPageId();
        String showAttach = this.plugin.getPageCache().get("showAttach");
        Map params = FpzsMainService.getCustomParam((String)pageId);
        params.put("org_id", params.get("orgId"));
        params.put("showAttach", showAttach);
        InvoiceCollectService collect = new InvoiceCollectService();
        Map cust = collect.addCustomField(this.plugin);
        if (cust != null && !cust.isEmpty()) {
            params.putAll(cust);
        }
        return params;
    }
}

