/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.mobile.home.operate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.expense.domain.ExpenseAttachDTO;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.domain.ExpenseInvoiceDTO;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.verify.VerifyService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.service.InvoiceLog;
import kd.imc.rim.common.service.RecognitionCheckService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.MobileIndexMinUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.formplugin.mobile.home.operate.AbstractOperateService;
import org.apache.commons.lang.StringUtils;

public class PushPcOperateService
extends AbstractOperateService {
    private static Log logger = LogFactory.getLog(PushPcOperateService.class);

    public PushPcOperateService(String type, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
    }

    @Override
    public void operate() {
        Map customParam = FpzsMainService.getCustomParam((AbstractFormPlugin)this.plugin);
        String fpzsPageId = (String)customParam.get("fpzsPageId");
        String indexPageId = (String)customParam.get("indexPageId");
        String pushType = (String)customParam.get("pushType");
        String linkKey = (String)this.plugin.getView().getFormShowParameter().getCustomParams().get("linkKey");
        linkKey = Optional.ofNullable(linkKey).orElseGet(() -> (String)customParam.get("linkKey"));
        String invoiceCacheStr = CacheHelper.get((String)(indexPageId + "cache_selected_invoice"));
        String attachCacheStr = CacheHelper.get((String)(indexPageId + "cache_selected_attach"));
        if (StringUtils.isEmpty((String)invoiceCacheStr) && StringUtils.isEmpty((String)attachCacheStr)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u53d1\u7968", (String)"PushPcOperateService_17", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        JSONObject invoiceObj = JSONObject.parseObject((String)invoiceCacheStr, (Feature[])new Feature[]{Feature.OrderedField});
        JSONArray attachObj = JSONArray.parseArray((String)attachCacheStr);
        if (CollectionUtils.isEmpty((Map)invoiceObj) && CollectionUtils.isEmpty((Collection)attachObj)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5bfc\u5165\u7684\u53d1\u7968", (String)"PushPcOperateService_17", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        boolean isInvoiceBox = StringUtils.equals((String)((String)customParam.get("invoiceBox")), (String)"1");
        String resource = String.valueOf(customParam.get("resource"));
        String multiTenant = (String)customParam.get("multiTenant");
        boolean pushBillMobile = false;
        if (StringUtils.isNotEmpty((String)multiTenant)) {
            pushBillMobile = false;
        } else {
            boolean bl = pushBillMobile = StringUtils.isEmpty((String)fpzsPageId) || "expense_mobile".equals(resource);
        }
        if (pushBillMobile) {
            logger.info("\u63a8\u9001\u5355\u636e\u79fb\u52a8\u7aef{}", (Object)fpzsPageId);
            if (ObjectUtils.isEmpty((Object)invoiceObj) && !isInvoiceBox) {
                JSONObject returnData = new JSONObject();
                JSONArray attachArray = this.getAttachList(attachObj);
                returnData.put("attachData", (Object)attachArray);
                InvoiceLog.insertExpenseLog((String)"\u53d1\u7968\u52a9\u624bH5\u5bfc\u5165\u5355\u636e", (String)String.valueOf(customParam.get("billId")), (String)String.valueOf(customParam.get("billNo")), (String)returnData.toJSONString());
                this.pushData(pushType, linkKey, returnData);
                this.plugin.getView().close();
                this.clearCache();
                return;
            }
            Set keySet = invoiceObj.keySet();
            Iterator iterator = keySet.iterator();
            ArrayList<Long> invoiceIds = new ArrayList<Long>(keySet.size());
            while (iterator.hasNext()) {
                invoiceIds.add(Long.parseLong((String)iterator.next()));
            }
            JSONArray list = VerifyUtil.verifyByMainIds((Map)customParam, invoiceIds, (boolean)false);
            VerifyService.verifySequenceNo((Map)customParam, (JSONArray)list);
            JSONArray filterArray = new JSONArray();
            JSONArray importArray = new JSONArray();
            JSONArray importArrayCache = new JSONArray();
            JSONArray importConvertArray = new JSONArray();
            for (int i = 0; i < list.size(); ++i) {
                JSONObject mainObj = list.getJSONObject(i);
                String level = mainObj.getString("errorLevel");
                if ("0".equals(level)) {
                    filterArray.add((Object)mainObj);
                    continue;
                }
                importArray.add((Object)mainObj);
                Long invoiceType = mainObj.getLong("invoice_type");
                InvoiceConvertService convertService = InvoiceConvertService.newInstance((Long)invoiceType, (String)resource);
                JSONObject result = convertService.convert((Map)mainObj);
                result.put("errorLevel", mainObj.get((Object)"errorLevel"));
                result.put("validateMessage", mainObj.get((Object)"validateMessage"));
                result.put("verifyResult", mainObj.get((Object)"verifyResult"));
                result.put("id", (Object)mainObj.getLong("id"));
                importArrayCache.add((Object)result);
                importConvertArray.add((Object)result);
            }
            if (!CollectionUtils.isEmpty((Collection)importConvertArray)) {
                Long rimUser = FpzsMainService.getRimUser((Map)customParam);
                for (int i = 0; i < importConvertArray.size(); ++i) {
                    JSONObject importInvoice = importConvertArray.getJSONObject(i);
                    String level = importInvoice.getString("errorLevel");
                    String serialNo = importInvoice.getString("serialNo");
                    VerifyUtil.updateDataStatus((String)level, (String)serialNo, (Long)InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)importInvoice.getString("invoiceType")), (Boolean)Boolean.TRUE, (Long)rimUser, (boolean)true);
                }
            }
            if (filterArray.isEmpty()) {
                JSONObject returnData = new JSONObject();
                JSONArray importAttachArray = this.getAttachList(attachObj);
                JSONArray orderedImportArray = new JSONArray();
                HashMap<Long, JSONObject> importArrayMap = new HashMap<Long, JSONObject>(importConvertArray.size());
                for (int i = 0; i < importConvertArray.size(); ++i) {
                    JSONObject importInvoice = importConvertArray.getJSONObject(i);
                    importArrayMap.put(importInvoice.getLong("id"), importInvoice);
                }
                int index = 0;
                String uploadIndex = String.valueOf(System.currentTimeMillis());
                for (Long invoiceId : invoiceIds) {
                    JSONObject orderedImportInvoice = (JSONObject)importArrayMap.get(invoiceId);
                    if (ObjectUtils.isEmpty((Object)orderedImportInvoice)) continue;
                    Long uploadSeq = RecognitionCheckService.getInvoiceSeq((String)uploadIndex, (int)0, (int)index);
                    orderedImportInvoice.put("uploadSeq", (Object)uploadSeq);
                    orderedImportArray.add((Object)orderedImportInvoice);
                    ++index;
                }
                logger.info("\u63a8\u9001\u53d1\u7968\u4fe1\u606f\u5230\u79fb\u52a8\u7aef:{}", (Object)orderedImportArray);
                returnData.put("attachData", (Object)importAttachArray);
                returnData.put("invoiceData", (Object)orderedImportArray);
                InvoiceLog.insertExpenseLog((String)"\u53d1\u7968\u52a9\u624bH5\u5bfc\u5165\u5355\u636e", (String)String.valueOf(customParam.get("billId")), (String)String.valueOf(customParam.get("billNo")), (String)returnData.toJSONString());
                this.pushData(pushType, linkKey, returnData);
                this.clearCache();
                this.plugin.getView().close();
            } else {
                Object importAttachIds;
                IPageCache pageCache = this.plugin.getPageCache();
                String pageId = MobileIndexMinUtils.mobileIndex((IFormView)this.plugin.getView());
                if (pageId != null && !"rim_inv_collect_mobile".equals(this.plugin.getView().getEntityId())) {
                    pageCache = new PageCache(pageId);
                }
                pageCache.put("importInvoice", SerializationUtils.toJsonString((Object)importArrayCache));
                HashSet<Long> attachIds = null;
                if (!CollectionUtils.isEmpty((Collection)attachObj)) {
                    attachIds = new HashSet<Long>(attachObj.size());
                    for (int i = 0; i < attachObj.size(); ++i) {
                        attachIds.add(attachObj.getLong(i));
                    }
                    List<Long> filterAttachIds = this.getInvoiceAttachList(filterArray);
                    importAttachIds = this.getInvoiceAttachList(importArray);
                    if (!CollectionUtils.isEmpty(filterAttachIds)) {
                        attachIds.removeAll(filterAttachIds);
                    }
                    if (!CollectionUtils.isEmpty((Collection)importAttachIds)) {
                        attachIds.addAll((Collection<Long>)importAttachIds);
                    }
                }
                if (!CollectionUtils.isEmpty(attachIds)) {
                    String attachIdsStr = SerializationUtils.toJsonString(attachIds);
                    importAttachIds = JSONArray.parseArray((String)attachIdsStr);
                    JSONArray importAttach = this.getAttachList((JSONArray)importAttachIds);
                    pageCache.put("importAttach", SerializationUtils.toJsonString((Object)importAttach));
                }
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                Map<String, Object> customParams = this.getCustomParams();
                customParams.put("filterInvoice", filterArray);
                customParams.put("importInvoice", importArray);
                showParameter.setCustomParams(customParams);
                showParameter.setFormId("rim_h5_inv_verify_list");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, this.type);
                showParameter.setCloseCallBack(closeCallBack);
                this.plugin.getView().showForm((FormShowParameter)showParameter);
            }
        } else {
            IFormView formView;
            logger.info("\u63a8\u9001\u5355\u636epc\u7aef{}", (Object)fpzsPageId);
            if (StringUtils.isEmpty((String)multiTenant) && (formView = SessionManager.getCurrent().getView(fpzsPageId)) == null) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u63a8\u9001\u5931\u8d25\uff1aPC\u7aef\u9875\u9762\u5df2\u7ecf\u5173\u95ed", (String)"PushPcOperateService_18", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            if (linkKey != null) {
                JSONObject returnData = ResultContant.createSuccessJSONObject();
                returnData.put("resource", (Object)"rim");
                JSONObject data = new JSONObject();
                if (!CollectionUtils.isEmpty((Map)invoiceObj)) {
                    data.put("invoiceData", (Object)invoiceObj.keySet());
                }
                data.put("attachIds", (Object)attachObj);
                returnData.put("data", (Object)data);
                if (StringUtils.isNotEmpty((String)multiTenant)) {
                    this.pushData(pushType, linkKey, returnData);
                } else if ("0".equals(RimConfigUtils.getConfig((String)"rim_fpzs", (String)"enablesocket"))) {
                    CacheHelper.put((String)linkKey, (String)returnData.toJSONString(), (int)120);
                } else {
                    MsgSendFactory.getSender().send(linkKey, returnData.toJSONString());
                }
                this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63a8\u9001\u6210\u529f", (String)"PushPcOperateService_19", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                this.clearCache();
            } else {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u63a8\u9001\u5931\u8d25", (String)"PushPcOperateService_20", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        }
    }

    private void pushData(String pushType, String linkKey, JSONObject returnData) {
        logger.info("\u79fb\u52a8\u7aef\u63a8\u9001{},{}", (Object)pushType, (Object)linkKey);
        if (!StringUtils.isEmpty((String)linkKey) && "socket".equals(pushType)) {
            MsgSendFactory.getSender().send(linkKey, returnData.toJSONString());
        } else if (!StringUtils.isEmpty((String)linkKey) && "poll".equals(pushType)) {
            CacheHelper.put((String)("rim_push:" + linkKey), (String)returnData.toJSONString(), (int)120);
        } else {
            this.plugin.getView().returnDataToParent((Object)returnData);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String data = (String)closedCallBackEvent.getReturnData();
        if ("import".equals(data)) {
            IPageCache pageCache = this.plugin.getPageCache();
            String invoiceJson = pageCache.get("importInvoice");
            String attachJson = pageCache.get("importAttach");
            JSONObject returnData = new JSONObject();
            JSONArray attachArray = new JSONArray();
            if (!StringUtils.isEmpty((String)attachJson)) {
                attachArray = JSONArray.parseArray((String)attachJson);
            }
            Map customParam = FpzsMainService.getCustomParam((AbstractFormPlugin)this.plugin);
            Long rimUser = FpzsMainService.getRimUser((Map)customParam);
            JSONArray invoiceArray = new JSONArray();
            if (!StringUtils.isEmpty((String)invoiceJson)) {
                invoiceArray = JSONArray.parseArray((String)invoiceJson);
            }
            returnData.put("invoiceData", (Object)invoiceArray);
            returnData.put("attachData", (Object)attachArray);
            String pushType = (String)customParam.get("pushType");
            String linkKey = (String)customParam.get("linkKey");
            InvoiceLog.insertExpenseLog((String)ResManager.loadKDString((String)"\u53d1\u7968\u52a9\u624bH5\u5bfc\u5165\u5355\u636e", (String)"PushPcOperateService_21", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)String.valueOf(customParam.get("billId")), (String)String.valueOf(customParam.get("billNo")), (String)returnData.toJSONString());
            this.pushData(pushType, linkKey, returnData);
            this.clearCache();
            this.plugin.getView().close();
        }
    }

    private void saveFpyExpense(JSONArray orderedImportArray, JSONArray importAttachArray) {
        Map customParam = FpzsMainService.getCustomParam((AbstractFormPlugin)this.plugin);
        String expenseId = String.valueOf(customParam.get("billId"));
        String entityId = String.valueOf(customParam.get("entityId"));
        if (orderedImportArray == null || orderedImportArray.size() <= 0) {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u5165\u7684\u5408\u89c4\u53d1\u7968", (String)"PushPcOperateService_22", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((String)expenseId)) {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u62a5\u9500\u5355id", (String)"PushPcOperateService_23", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        logger.info("\u4fdd\u5b58\u53d1\u7968\u4fe1\u606f\u5230\u82cd\u7a79\u672c\u5730\u5355\u636e:{}", (Object)orderedImportArray);
        ExpenseService expenseService = new ExpenseService();
        ExpenseDTO expenseDTO = new ExpenseDTO();
        String expenseNum = (String)customParam.get("billNo");
        expenseDTO.setExpenseId(expenseId);
        expenseDTO.setExpenseNum(expenseNum);
        expenseDTO.setEntityId(entityId);
        expenseDTO.setReimbursingId((String)customParam.get("rim_user"));
        expenseDTO.setBillUser((String)customParam.get("bill_user"));
        expenseDTO.setOrgId(Long.valueOf(BigDecimalUtil.transDecimal(customParam.get("orgId")).longValue()));
        expenseDTO.setExpenseType((String)customParam.get("billType"));
        ArrayList<ExpenseInvoiceDTO> invoiceList = new ArrayList<ExpenseInvoiceDTO>(8);
        ArrayList<ExpenseAttachDTO> attachList = new ArrayList<ExpenseAttachDTO>(8);
        BigDecimal expenseAmount = BigDecimal.ZERO;
        if (importAttachArray != null && importAttachArray.size() > 0) {
            for (int j = 0; j < importAttachArray.size(); ++j) {
                JSONObject attach = importAttachArray.getJSONObject(j);
                ExpenseAttachDTO attachDTO = new ExpenseAttachDTO();
                attachDTO.setAttachId(attach.getString("attachId"));
                attachDTO.setAttachName(attach.getString("attachName"));
                attachDTO.setAttachNo(attach.getString("attachNo"));
                attachDTO.setSerialNo(attach.getString("serialNo"));
                attachDTO.setAttachRemark(attach.getString("remark"));
                attachDTO.setAttachType(attach.getString("attachType"));
                attachDTO.setAttachUrl(attach.getString("attachUrl"));
                attachList.add(attachDTO);
            }
        }
        for (int i = 0; i < orderedImportArray.size(); ++i) {
            JSONObject orderedInvoice = orderedImportArray.getJSONObject(i);
            ExpenseInvoiceDTO invoiceDTO = new ExpenseInvoiceDTO();
            invoiceDTO.setSerialNo(orderedInvoice.getString("serialNo"));
            invoiceDTO.setExpenseAmount(orderedInvoice.getBigDecimal("totalAmount"));
            if (orderedInvoice.getBigDecimal("totalAmount") != null) {
                expenseAmount = expenseAmount.add(orderedInvoice.getBigDecimal("totalAmount"));
            }
            invoiceDTO.setDeductionFlag(orderedInvoice.getString("deductionFlag"));
            invoiceDTO.setDeductionPurpose(orderedInvoice.getString("deductionPurpose"));
            invoiceDTO.setOrgId(orderedInvoice.getLong("org"));
            invoiceDTO.setOriginalState(orderedInvoice.getString("originalState"));
            invoiceDTO.setRemark(orderedInvoice.getString("remark"));
            invoiceList.add(invoiceDTO);
        }
        expenseDTO.setInvoiceList(invoiceList);
        if (attachList.size() > 0) {
            expenseDTO.setAttachDTOList(attachList);
        }
        expenseDTO.setStatus("30");
        expenseService.save(expenseDTO);
        QFilter expenseFilter = new QFilter("id", "=", (Object)BigDecimalUtil.transDecimal((Object)expenseId).longValue());
        DynamicObject expenseObj = BusinessDataServiceHelper.loadSingle((String)"rim_expense_manage", (String)"id, invoice_num, invoice_total_amount, billstatus, modifytime", (QFilter[])expenseFilter.toArray());
        if (expenseObj == null) {
            this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u62a5\u9500\u5355:%1$s", (String)"PushPcOperateService_16", (String)"imc-rim-formplugin", (Object[])new Object[0]), expenseId));
            return;
        }
        expenseObj.set("invoice_num", (Object)invoiceList.size());
        expenseObj.set("invoice_total_amount", (Object)expenseAmount);
        expenseObj.set("billstatus", (Object)"B");
        expenseObj.set("modifytime", (Object)new Date());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{expenseObj});
    }

    private List<Long> getInvoiceAttachList(JSONArray invoiceArray) {
        if (CollectionUtils.isEmpty((Collection)invoiceArray)) {
            return null;
        }
        ArrayList<Long> attachIds = new ArrayList<Long>(16);
        for (int n = 0; n < invoiceArray.size(); ++n) {
            QFilter attachFilter;
            DynamicObjectCollection invoiceAttaches;
            String serial_no;
            if (ObjectUtils.isEmpty((Object)invoiceArray.get(n)) || StringUtils.isEmpty((String)(serial_no = invoiceArray.getJSONObject(n).getString("serial_no"))) || (invoiceAttaches = QueryServiceHelper.query((String)"rim_attach_relation", (String)"attach_id", (QFilter[])(attachFilter = new QFilter("relation_type", "=", (Object)"3").and("relation_id", "=", (Object)serial_no)).toArray())).isEmpty()) continue;
            for (DynamicObject dynamicObject : invoiceAttaches) {
                if (ObjectUtils.isEmpty((Object)dynamicObject)) continue;
                attachIds.add(dynamicObject.getLong("attach_id"));
            }
        }
        return attachIds;
    }

    private JSONArray getAttachList(JSONArray attachObj) {
        JSONArray attachCacheArray = new JSONArray();
        if (attachObj != null && !attachObj.isEmpty()) {
            ArrayList<Long> attachIds = new ArrayList<Long>(attachObj.size());
            ArrayList<String> attachidStringList = new ArrayList<String>(attachObj.size());
            for (int i = 0; i < attachObj.size(); ++i) {
                attachIds.add(attachObj.getLong(i));
                attachidStringList.add(attachObj.getString(i));
            }
            QFilter idFilter = new QFilter("id", "in", attachIds);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_attach", (String)"", (QFilter[])new QFilter[]{idFilter});
            QFilter attachIdFilter = new QFilter("attach_id", "in", attachidStringList);
            DynamicObjectCollection relationCollection = QueryServiceHelper.query((String)"rim_attach_relation", (String)"attach_id,expense_id,relation_id", (QFilter[])new QFilter[]{attachIdFilter});
            HashMap<String, String> serialMap = new HashMap<String, String>(attachIds.size());
            for (DynamicObject relation : relationCollection) {
                String serialNo = relation.getString("relation_id");
                if (!StringUtils.isNotEmpty((String)serialNo)) continue;
                serialMap.put(relation.getString("attach_id"), serialNo);
            }
            for (DynamicObject att : collection) {
                JSONObject dataJson = new JSONObject();
                String id = String.valueOf(att.get("id"));
                dataJson.put("serialNo", serialMap.get(id));
                dataJson.put("attachId", (Object)id);
                dataJson.put("attachUrl", att.get("attach_url"));
                dataJson.put("attachType", att.get("attach_type"));
                dataJson.put("attachNo", att.get("attach_no"));
                dataJson.put("attachName", att.get("attach_name"));
                dataJson.put("originalName", att.get("original_name"));
                dataJson.put("remark", att.get("remark"));
                dataJson.put("attachSize", att.get("size"));
                dataJson.put("createTime", (Object)DateUtils.format((Date)att.getDate("create_time"), (String)"yyyy-MM-dd HH:mm:ss"));
                attachCacheArray.add((Object)dataJson);
            }
            Map customParam = FpzsMainService.getCustomParam((AbstractFormPlugin)this.plugin);
            String billId = (String)customParam.get("billId");
            String entityId = (String)customParam.get("entityId");
            String resource = (String)customParam.get("resource");
            AttachQueryService attachQueryService = new AttachQueryService();
            attachQueryService.addFpzsAttach(billId, entityId, resource, attachCacheArray);
        }
        return attachCacheArray;
    }
}

